/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.parameter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import org.apache.commons.lang3.BooleanUtils;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.auth.AuthenticationType;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.parameter.DataSourceSparkParameterComposer;
import org.opensearch.sql.spark.parameter.SparkSubmitParameters;

public class S3GlueDataSourceSparkParameterComposer
implements DataSourceSparkParameterComposer {
    public static final String FLINT_BASIC_AUTH = "basic";

    public void compose(DataSourceMetadata metadata, SparkSubmitParameters params, DispatchQueryRequest dispatchQueryRequest, AsyncQueryRequestContext context) {
        String roleArn = (String)metadata.getProperties().get("glue.auth.role_arn");
        params.setConfigItem("spark.emr-serverless.driverEnv.ASSUME_ROLE_CREDENTIALS_ROLE_ARN", roleArn);
        params.setConfigItem("spark.executorEnv.ASSUME_ROLE_CREDENTIALS_ROLE_ARN", roleArn);
        params.setConfigItem("spark.hive.metastore.glue.role.arn", roleArn);
        params.setConfigItem("spark.sql.catalog." + metadata.getName(), "org.opensearch.sql.FlintDelegatingSessionCatalog");
        params.setConfigItem("spark.flint.datasource.name", metadata.getName());
        boolean lakeFormationEnabled = BooleanUtils.toBoolean((String)((String)metadata.getProperties().get("glue.lakeformation.enabled")));
        params.setConfigItem("spark.emr-serverless.lakeformation.enabled", Boolean.toString(lakeFormationEnabled));
        params.setConfigItem("spark.flint.optimizer.covering.enabled", Boolean.toString(!lakeFormationEnabled));
        this.setFlintIndexStoreHost(params, this.parseUri((String)metadata.getProperties().get("glue.indexstore.opensearch.uri"), metadata.getName()));
        this.setFlintIndexStoreAuthProperties(params, (String)metadata.getProperties().get("glue.indexstore.opensearch.auth"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.auth.username"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.auth.password"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.region"));
        params.setConfigItem("spark.flint.datasource.name", metadata.getName());
    }

    private void setFlintIndexStoreHost(SparkSubmitParameters params, URI uri) {
        params.setConfigItem("spark.datasource.flint.host", uri.getHost());
        params.setConfigItem("spark.datasource.flint.port", String.valueOf(uri.getPort()));
        params.setConfigItem("spark.datasource.flint.scheme", uri.getScheme());
    }

    private void setFlintIndexStoreAuthProperties(SparkSubmitParameters params, String authType, Supplier<String> userName, Supplier<String> password, Supplier<String> region) {
        if (AuthenticationType.get((String)authType).equals((Object)AuthenticationType.BASICAUTH)) {
            params.setConfigItem("spark.datasource.flint.auth", FLINT_BASIC_AUTH);
            params.setConfigItem("spark.datasource.flint.auth.username", userName.get());
            params.setConfigItem("spark.datasource.flint.auth.password", password.get());
        } else if (AuthenticationType.get((String)authType).equals((Object)AuthenticationType.AWSSIGV4AUTH)) {
            params.setConfigItem("spark.datasource.flint.auth", "sigv4");
            params.setConfigItem("spark.datasource.flint.region", region.get());
        } else {
            params.setConfigItem("spark.datasource.flint.auth", authType);
        }
    }

    private URI parseUri(String opensearchUri, String datasourceName) {
        try {
            return new URI(opensearchUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Bad URI in indexstore configuration of the : %s datasoure.", datasourceName));
        }
    }
}

