/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.controller;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.opensearch.OpenSearchParseException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLRateLimiter
implements ToXContentObject,
Writeable {
    public static final String LIMIT_FIELD = "limit";
    public static final String UNIT_FIELD = "unit";
    private String limit;
    private TimeUnit unit;

    public MLRateLimiter(String limit, TimeUnit unit) {
        this.limit = limit;
        this.unit = unit;
    }

    public static MLRateLimiter parse(XContentParser parser) throws IOException {
        String limit = null;
        TimeUnit unit = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "limit": {
                    limit = parser.text();
                    try {
                        double limitNumber = Double.parseDouble(limit);
                        if (!(limitNumber < 0.0)) continue block10;
                        throw new OpenSearchParseException("Limit field must be a positive number.", new Object[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new OpenSearchParseException("Limit field must be a positive number.", new Object[0]);
                    }
                }
                case "unit": {
                    unit = TimeUnit.valueOf(parser.text());
                    break;
                }
                default: {
                    parser.skipChildren();
                }
            }
        }
        return new MLRateLimiter(limit, unit);
    }

    public MLRateLimiter(StreamInput in) throws IOException {
        this.limit = in.readOptionalString();
        if (in.readBoolean()) {
            this.unit = (TimeUnit)in.readEnum(TimeUnit.class);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.limit);
        if (this.unit != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.unit);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.limit != null) {
            builder.field(LIMIT_FIELD, this.limit);
        }
        if (this.unit != null) {
            builder.field(UNIT_FIELD, (Object)this.unit);
        }
        builder.endObject();
        return builder;
    }

    public void update(MLRateLimiter updateContent) {
        if (updateContent.getLimit() != null) {
            this.limit = updateContent.getLimit();
        }
        if (updateContent.getUnit() != null) {
            this.unit = updateContent.getUnit();
        }
    }

    public static MLRateLimiter update(MLRateLimiter rateLimiter, MLRateLimiter updateContent) {
        if (rateLimiter == null) {
            return updateContent;
        }
        rateLimiter.update(updateContent);
        return rateLimiter;
    }

    public static boolean updateValidityPreCheck(MLRateLimiter rateLimiter, MLRateLimiter updateContent) {
        if (updateContent == null) {
            return false;
        }
        if (rateLimiter == null) {
            return true;
        }
        if (updateContent.isEmpty()) {
            return false;
        }
        return !Objects.equals(updateContent.getLimit(), rateLimiter.getLimit()) && updateContent.getLimit() != null || !Objects.equals((Object)updateContent.getUnit(), (Object)rateLimiter.getUnit()) && updateContent.getUnit() != null;
    }

    public static boolean isDeployRequiredAfterUpdate(MLRateLimiter rateLimiter, MLRateLimiter updateContent) {
        if (!MLRateLimiter.updateValidityPreCheck(rateLimiter, updateContent)) {
            return false;
        }
        return updateContent.isValid() || rateLimiter.getUnit() != null && updateContent.getLimit() != null || rateLimiter.getLimit() != null && updateContent.getUnit() != null;
    }

    public boolean isValid() {
        return this.unit != null && this.limit != null;
    }

    public boolean isEmpty() {
        return this.unit == null && this.limit == null;
    }

    @Generated
    public static MLRateLimiterBuilder builder() {
        return new MLRateLimiterBuilder();
    }

    @Generated
    public MLRateLimiterBuilder toBuilder() {
        return new MLRateLimiterBuilder().limit(this.limit).unit(this.unit);
    }

    @Generated
    public void setLimit(String limit) {
        this.limit = limit;
    }

    @Generated
    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    @Generated
    public String getLimit() {
        return this.limit;
    }

    @Generated
    public TimeUnit getUnit() {
        return this.unit;
    }

    @Generated
    public static class MLRateLimiterBuilder {
        @Generated
        private String limit;
        @Generated
        private TimeUnit unit;

        @Generated
        MLRateLimiterBuilder() {
        }

        @Generated
        public MLRateLimiterBuilder limit(String limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public MLRateLimiterBuilder unit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        @Generated
        public MLRateLimiter build() {
            return new MLRateLimiter(this.limit, this.unit);
        }

        @Generated
        public String toString() {
            return "MLRateLimiter.MLRateLimiterBuilder(limit=" + this.limit + ", unit=" + String.valueOf((Object)this.unit) + ")";
        }
    }
}

