/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

public class NameRecord {
    private short _platformId;
    private short _encodingId;
    private short _languageId;
    private short _nameId;
    private short _stringLength;
    private short _stringOffset;
    private String _record;

    NameRecord(DataInput dataInput) throws IOException {
        this._platformId = dataInput.readShort();
        this._encodingId = dataInput.readShort();
        this._languageId = dataInput.readShort();
        this._nameId = dataInput.readShort();
        this._stringLength = dataInput.readShort();
        this._stringOffset = dataInput.readShort();
    }

    public short getEncodingId() {
        return this._encodingId;
    }

    public short getLanguageId() {
        return this._languageId;
    }

    public short getNameId() {
        return this._nameId;
    }

    public short getPlatformId() {
        return this._platformId;
    }

    public String getRecordString() {
        return this._record;
    }

    void loadString(DataInput dataInput) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        dataInput.skipBytes(this._stringOffset);
        if (this._platformId == 0) {
            for (int i = 0; i < this._stringLength / 2; ++i) {
                stringBuilder.append(dataInput.readChar());
            }
        } else if (this._platformId == 1) {
            for (int i = 0; i < this._stringLength; ++i) {
                stringBuilder.append((char)dataInput.readByte());
            }
        } else if (this._platformId == 2) {
            for (int i = 0; i < this._stringLength; ++i) {
                stringBuilder.append((char)dataInput.readByte());
            }
        } else if (this._platformId == 3) {
            for (int i = 0; i < this._stringLength / 2; ++i) {
                char c = dataInput.readChar();
                stringBuilder.append(c);
            }
        }
        this._record = stringBuilder.toString();
    }

    public String toString() {
        String string = "             Platform ID:       " + this._platformId + "\n             Specific ID:       " + this._encodingId + "\n             Language ID:       " + this._languageId + "\n             Name ID:           " + this._nameId + "\n             Length:            " + this._stringLength + "\n             Offset:            " + this._stringOffset + "\n\n" + this._record;
        return string;
    }
}

