# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_dra_global_optspecs
	string join \n h/help V/version
end

function __fish_dra_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_dra_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_dra_using_subcommand
	set -l cmd (__fish_dra_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c dra -n "__fish_dra_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c dra -n "__fish_dra_needs_command" -s V -l version -d 'Print version'
complete -c dra -n "__fish_dra_needs_command" -f -a "download" -d 'Select and download an asset'
complete -c dra -n "__fish_dra_needs_command" -f -a "untag" -d 'Select an asset and generate an untagged version of it'
complete -c dra -n "__fish_dra_needs_command" -f -a "completion" -d 'Generate shell completion'
complete -c dra -n "__fish_dra_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c dra -n "__fish_dra_using_subcommand download" -s s -l select -d 'Untagged asset name to automatically select which asset to download' -r
complete -c dra -n "__fish_dra_using_subcommand download" -s t -l tag -d 'Set the tag name for fetching a specific release' -r
complete -c dra -n "__fish_dra_using_subcommand download" -s o -l output -d 'Save asset to custom path (file or directory)' -r -F
complete -c dra -n "__fish_dra_using_subcommand download" -s I -l install-file -d 'Install downloaded asset and select which executable to install' -r
complete -c dra -n "__fish_dra_using_subcommand download" -s a -l automatic -d 'Automatically select and download an asset based on your operating system and architecture'
complete -c dra -n "__fish_dra_using_subcommand download" -s i -l install -d 'Install downloaded asset'
complete -c dra -n "__fish_dra_using_subcommand download" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c dra -n "__fish_dra_using_subcommand untag" -s h -l help -d 'Print help'
complete -c dra -n "__fish_dra_using_subcommand completion" -s h -l help -d 'Print help'
complete -c dra -n "__fish_dra_using_subcommand help; and not __fish_seen_subcommand_from download untag completion help" -f -a "download" -d 'Select and download an asset'
complete -c dra -n "__fish_dra_using_subcommand help; and not __fish_seen_subcommand_from download untag completion help" -f -a "untag" -d 'Select an asset and generate an untagged version of it'
complete -c dra -n "__fish_dra_using_subcommand help; and not __fish_seen_subcommand_from download untag completion help" -f -a "completion" -d 'Generate shell completion'
complete -c dra -n "__fish_dra_using_subcommand help; and not __fish_seen_subcommand_from download untag completion help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
