/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.JavaMethod;
import io.cucumber.messages.types.JavaStackTraceElement;
import io.cucumber.messages.types.Location;
import java.util.Objects;
import java.util.Optional;

public final class SourceReference {
    private final String uri;
    private final JavaMethod javaMethod;
    private final JavaStackTraceElement javaStackTraceElement;
    private final Location location;

    public static SourceReference of(String uri) {
        return new SourceReference(Objects.requireNonNull(uri, "SourceReference.uri cannot be null"), null, null, null);
    }

    public static SourceReference of(JavaMethod javaMethod) {
        return new SourceReference(null, Objects.requireNonNull(javaMethod, "SourceReference.javaMethod cannot be null"), null, null);
    }

    public static SourceReference of(JavaStackTraceElement javaStackTraceElement) {
        return new SourceReference(null, null, Objects.requireNonNull(javaStackTraceElement, "SourceReference.javaStackTraceElement cannot be null"), null);
    }

    public static SourceReference of(Location location) {
        return new SourceReference(null, null, null, Objects.requireNonNull(location, "SourceReference.location cannot be null"));
    }

    public SourceReference(String uri, JavaMethod javaMethod, JavaStackTraceElement javaStackTraceElement, Location location) {
        this.uri = uri;
        this.javaMethod = javaMethod;
        this.javaStackTraceElement = javaStackTraceElement;
        this.location = location;
    }

    public Optional<String> getUri() {
        return Optional.ofNullable(this.uri);
    }

    public Optional<JavaMethod> getJavaMethod() {
        return Optional.ofNullable(this.javaMethod);
    }

    public Optional<JavaStackTraceElement> getJavaStackTraceElement() {
        return Optional.ofNullable(this.javaStackTraceElement);
    }

    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceReference that = (SourceReference)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.javaMethod, that.javaMethod) && Objects.equals(this.javaStackTraceElement, that.javaStackTraceElement) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.javaMethod, this.javaStackTraceElement, this.location);
    }

    public String toString() {
        return "SourceReference{uri=" + this.uri + ", javaMethod=" + this.javaMethod + ", javaStackTraceElement=" + this.javaStackTraceElement + ", location=" + this.location + '}';
    }
}

