/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.repl.CreateReplStageStateAction;
import org.jetbrains.kotlin.cli.common.repl.GenericReplCompilingEvaluator;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.InvokeWrapper;
import org.jetbrains.kotlin.cli.common.repl.ReplClassLoader;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompilerWithoutCheck;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.common.repl.ReplFullEvaluator;
import org.jetbrains.kotlin.cli.common.repl.ReplRepeatingMode;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.GenericReplCompiler;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplInterpreter;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.ReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.writer.ReplWriter;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000u\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0017\u0018\u0000 .2\u00020\u0001:\u0001.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0013\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0013\u001a\u0004\b$\u0010%\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter;", "", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "replConfiguration", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;)V", "classLoader", "Lorg/jetbrains/kotlin/cli/common/repl/ReplClassLoader;", "classpathRoots", "", "Ljava/io/File;", "evalState", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "getEvalState", "()Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "evalState$delegate", "Lkotlin/Lazy;", "lineNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "messageCollector", "org/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter$messageCollector$1", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter$messageCollector$1;", "previousIncompleteLines", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "scriptCompiler", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompilerWithoutCheck;", "getScriptCompiler", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplCompilerWithoutCheck;", "scriptCompiler$delegate", "scriptEvaluator", "Lorg/jetbrains/kotlin/cli/common/repl/ReplFullEvaluator;", "getScriptEvaluator", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplFullEvaluator;", "scriptEvaluator$delegate", "dumpClasses", "", "out", "Ljava/io/PrintWriter;", "eval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "line", "Companion", "kotlin-scripting-compiler"})
public final class ReplInterpreter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final ReplConfiguration replConfiguration;
    @NotNull
    private final AtomicInteger lineNumber;
    @NotNull
    private final ArrayList<String> previousIncompleteLines;
    @NotNull
    private final List<File> classpathRoots;
    @NotNull
    private final ReplClassLoader classLoader;
    @NotNull
    private final messageCollector.1 messageCollector;
    @NotNull
    private final Lazy scriptCompiler$delegate;
    @NotNull
    private final Lazy scriptEvaluator$delegate;
    @NotNull
    private final Lazy evalState$delegate;
    @NotNull
    private static final Companion.REPL_LINE_AS_SCRIPT_DEFINITION.1 REPL_LINE_AS_SCRIPT_DEFINITION;

    /*
     * WARNING - void declaration
     */
    public ReplInterpreter(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration, @NotNull ReplConfiguration replConfiguration) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)replConfiguration, (String)"replConfiguration");
        this.configuration = configuration;
        this.replConfiguration = replConfiguration;
        this.lineNumber = new AtomicInteger();
        this.previousIncompleteLines = new ArrayList();
        List list = this.configuration.getList(CLIConfigurationKeys.CONTENT_ROOTS);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"configuration.getList(CL\u2026rationKeys.CONTENT_ROOTS)");
        Iterable iterable = list;
        ReplInterpreter replInterpreter = this;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            File it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            ContentRoot root = (ContentRoot)element$iv$iv;
            boolean bl2 = false;
            ContentRoot contentRoot = root;
            if ((contentRoot instanceof JvmModulePathRoot ? ((JvmModulePathRoot)root).getFile() : (contentRoot instanceof JvmClasspathRoot ? ((JvmClasspathRoot)root).getFile() : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        replInterpreter.classpathRoots = (List)destination$iv$iv;
        $this$mapNotNull$iv = this.classpathRoots;
        replInterpreter = this;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toURI().toURL());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        Intrinsics.checkNotNull((Object)uRLArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ClassLoader classLoader2 = classLoader != null ? classLoader.getParent() : null;
        URL[] uRLArray2 = uRLArray;
        ClassLoader classLoader3 = new URLClassLoader(uRLArray2, classLoader2);
        replInterpreter.classLoader = new ReplClassLoader(classLoader3);
        this.messageCollector = new MessageCollector(this){
            private boolean hasErrors;
            private final MessageRenderer messageRenderer;
            final /* synthetic */ ReplInterpreter this$0;
            {
                this.this$0 = $receiver;
                this.messageRenderer = MessageRenderer.WITHOUT_PATHS;
            }

            public void clear() {
                this.hasErrors = false;
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
                Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                String string = this.messageRenderer.render(severity, message, location);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageRenderer.render(s\u2026erity, message, location)");
                String msg = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
                ReplWriter $this$report_u24lambda_u2d0 = ReplInterpreter.access$getReplConfiguration$p(this.this$0).getWriter();
                boolean bl = false;
                switch (messageCollector.WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        $this$report_u24lambda_u2d0.sendInternalErrorReport(msg);
                        break;
                    }
                    case 2: {
                        $this$report_u24lambda_u2d0.outputCompileError(msg);
                    }
                }
            }

            public boolean hasErrors() {
                return this.hasErrors;
            }
        };
        this.scriptCompiler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GenericReplCompiler>(disposable, this){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ ReplInterpreter this$0;
            {
                this.$disposable = $disposable;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GenericReplCompiler invoke() {
                return new GenericReplCompiler(this.$disposable, ReplInterpreter.access$getREPL_LINE_AS_SCRIPT_DEFINITION$cp(), ReplInterpreter.access$getConfiguration$p(this.this$0), ReplInterpreter.access$getMessageCollector$p(this.this$0));
            }
        }));
        this.scriptEvaluator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GenericReplCompilingEvaluator>(this){
            final /* synthetic */ ReplInterpreter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GenericReplCompilingEvaluator invoke() {
                return new GenericReplCompilingEvaluator(ReplInterpreter.access$getScriptCompiler(this.this$0), (Iterable)ReplInterpreter.access$getClasspathRoots$p(this.this$0), (ClassLoader)ReplInterpreter.access$getClassLoader$p(this.this$0), null, ReplRepeatingMode.REPEAT_ANY_PREVIOUS);
            }
        }));
        this.evalState$delegate = LazyKt.lazy((Function0)new Function0<IReplStageState<?>>(this){
            final /* synthetic */ ReplInterpreter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IReplStageState<?> invoke() {
                return CreateReplStageStateAction.DefaultImpls.createState$default((CreateReplStageStateAction)((CreateReplStageStateAction)ReplInterpreter.access$getScriptEvaluator(this.this$0)), null, (int)1, null);
            }
        });
    }

    private final ReplCompilerWithoutCheck getScriptCompiler() {
        Lazy lazy = this.scriptCompiler$delegate;
        return (ReplCompilerWithoutCheck)lazy.getValue();
    }

    private final ReplFullEvaluator getScriptEvaluator() {
        Lazy lazy = this.scriptEvaluator$delegate;
        return (ReplFullEvaluator)lazy.getValue();
    }

    private final IReplStageState<?> getEvalState() {
        Lazy lazy = this.evalState$delegate;
        return (IReplStageState)lazy.getValue();
    }

    @NotNull
    public final ReplEvalResult eval(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String fullText = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)this.previousIncompleteLines, (Object)line), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        try {
            ReplEvalResult evalRes2 = this.getScriptEvaluator().compileAndEval(this.getEvalState(), new ReplCodeLine(this.lineNumber.getAndIncrement(), 0, fullText), null, new InvokeWrapper(this){
                final /* synthetic */ ReplInterpreter this$0;
                {
                    this.this$0 = $receiver;
                }

                public <T> T invoke(@NotNull Function0<? extends T> body) {
                    Intrinsics.checkNotNullParameter(body, (String)"body");
                    return ReplInterpreter.access$getReplConfiguration$p(this.this$0).getExecutionInterceptor().execute(body);
                }
            });
            if (!(evalRes2 instanceof ReplEvalResult.Incomplete)) {
                this.previousIncompleteLines.clear();
            } else if (this.replConfiguration.getAllowIncompleteLines()) {
                this.previousIncompleteLines.add(line);
            } else {
                return (ReplEvalResult)new ReplEvalResult.Error.CompileTime("incomplete code", null, 2, null);
            }
            return evalRes2;
        }
        catch (Throwable e) {
            PrintWriter writer = new PrintWriter(System.err);
            this.classLoader.dumpClasses(writer);
            writer.flush();
            throw e;
        }
    }

    public final void dumpClasses(@NotNull PrintWriter out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.classLoader.dumpClasses(out);
    }

    public static final /* synthetic */ ReplConfiguration access$getReplConfiguration$p(ReplInterpreter $this) {
        return $this.replConfiguration;
    }

    public static final /* synthetic */ Companion.REPL_LINE_AS_SCRIPT_DEFINITION.1 access$getREPL_LINE_AS_SCRIPT_DEFINITION$cp() {
        return REPL_LINE_AS_SCRIPT_DEFINITION;
    }

    public static final /* synthetic */ CompilerConfiguration access$getConfiguration$p(ReplInterpreter $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ messageCollector.1 access$getMessageCollector$p(ReplInterpreter $this) {
        return $this.messageCollector;
    }

    public static final /* synthetic */ ReplCompilerWithoutCheck access$getScriptCompiler(ReplInterpreter $this) {
        return $this.getScriptCompiler();
    }

    public static final /* synthetic */ List access$getClasspathRoots$p(ReplInterpreter $this) {
        return $this.classpathRoots;
    }

    public static final /* synthetic */ ReplClassLoader access$getClassLoader$p(ReplInterpreter $this) {
        return $this.classLoader;
    }

    public static final /* synthetic */ ReplFullEvaluator access$getScriptEvaluator(ReplInterpreter $this) {
        return $this.getScriptEvaluator();
    }

    static {
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        REPL_LINE_AS_SCRIPT_DEFINITION = new KotlinScriptDefinition((KClass<Object>)kClass){
            @NotNull
            private final String name;
            {
                this.name = "Kotlin REPL";
            }

            @NotNull
            public String getName() {
                return this.name;
            }
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter$Companion;", "", "()V", "REPL_LINE_AS_SCRIPT_DEFINITION", "org/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter$Companion$REPL_LINE_AS_SCRIPT_DEFINITION$1", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter$Companion$REPL_LINE_AS_SCRIPT_DEFINITION$1;", "kotlin-scripting-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

