/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.mapper.SeqNoFieldMapper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.shard.ShardUtils;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.compliance.ComplianceIndexingOperationListener;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.DlsFlsFilterLeafReader;
import org.opensearch.security.configuration.DlsQueryParser;
import org.opensearch.security.configuration.Salt;
import org.opensearch.security.configuration.SecurityIndexSearcherWrapper;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.support.SecurityUtils;

public class SecurityFlsDlsIndexSearcherWrapper
extends SecurityIndexSearcherWrapper {
    public final Logger log = LogManager.getLogger(this.getClass());
    private final Set<String> metaFields;
    public static final Set<String> META_FIELDS_BEFORE_7DOT8 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_timestamp", "_ttl", "_type")));
    private final ClusterService clusterService;
    private final IndexService indexService;
    private final AuditLog auditlog;
    private final LongSupplier nowInMillis;
    private final DlsQueryParser dlsQueryParser;
    private final Salt salt;

    public SecurityFlsDlsIndexSearcherWrapper(IndexService indexService, Settings settings, AdminDNs adminDNs, ClusterService clusterService, AuditLog auditlog, ComplianceIndexingOperationListener ciol, PrivilegesEvaluator evaluator, Salt salt) {
        super(indexService, settings, adminDNs, evaluator);
        Set metadataFieldsCopy;
        if (indexService.getMetadata().getState() == IndexMetadata.State.CLOSE) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} was closed. Setting metadataFields to empty. Closed index is not searchable.", (Object)indexService.index().getName());
            }
            metadataFieldsCopy = Collections.emptySet();
        } else {
            metadataFieldsCopy = new HashSet(indexService.mapperService().getMetadataFields());
            SeqNoFieldMapper.SequenceIDFields sequenceIDFields = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
            metadataFieldsCopy.add(sequenceIDFields.primaryTerm.name());
            metadataFieldsCopy.addAll(META_FIELDS_BEFORE_7DOT8);
        }
        this.metaFields = metadataFieldsCopy;
        ciol.setIs(indexService);
        this.clusterService = clusterService;
        this.indexService = indexService;
        this.auditlog = auditlog;
        this.dlsQueryParser = new DlsQueryParser(indexService.xContentRegistry());
        boolean allowNowinDlsQueries = settings.getAsBoolean("plugins.security.unsupported.allow_now_in_dls", Boolean.valueOf(false));
        this.nowInMillis = allowNowinDlsQueries ? () -> System.currentTimeMillis() : () -> {
            throw new IllegalArgumentException("'now' is not allowed in DLS queries");
        };
        this.log.debug("FLS/DLS {} enabled for index {}", (Object)this, (Object)indexService.index().getName());
        this.salt = salt;
    }

    @Override
    protected DirectoryReader dlsFlsWrap(DirectoryReader reader, boolean isAdmin) throws IOException {
        ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
        Sets.SetView flsFields = null;
        HashSet maskedFields = null;
        ConstantScoreQuery dlsQuery = null;
        if (!isAdmin) {
            Set unparsedDlsQueries;
            Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_fls_fields"));
            Map queries = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_dls_query"));
            Map maskedFieldsMap = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_masked_fields"));
            String flsEval = SecurityUtils.evalMap(allowedFlsFields, this.index.getName());
            String dlsEval = SecurityUtils.evalMap(queries, this.index.getName());
            String maskedEval = SecurityUtils.evalMap(maskedFieldsMap, this.index.getName());
            if (flsEval != null) {
                flsFields = Sets.union(this.metaFields, (Set)((Set)allowedFlsFields.get(flsEval)));
            }
            if (dlsEval != null && (unparsedDlsQueries = (Set)queries.get(dlsEval)) != null && !unparsedDlsQueries.isEmpty()) {
                QueryShardContext queryShardContext = this.indexService.newQueryShardContext(shardId.getId(), null, this.nowInMillis, null);
                dlsQuery = new ConstantScoreQuery((Query)this.dlsQueryParser.parse(unparsedDlsQueries, queryShardContext).build());
            }
            if (maskedEval != null) {
                maskedFields = new HashSet();
                maskedFields.addAll((Collection)maskedFieldsMap.get(maskedEval));
            }
        }
        return new DlsFlsFilterLeafReader.DlsFlsDirectoryReader(reader, (Set<String>)flsFields, (Query)dlsQuery, this.indexService, this.threadContext, this.clusterService, this.auditlog, maskedFields, shardId, this.salt);
    }
}

