/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.transport;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchException;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.NodesDnModel;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.transport.InterClusterRequestEvaluator;
import org.opensearch.transport.TransportRequest;

public final class DefaultInterClusterRequestEvaluator
implements InterClusterRequestEvaluator {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final String certOid;
    private final WildcardMatcher staticNodesDnFromEsYml;
    private boolean dynamicNodesDnConfigEnabled;
    private volatile Map<String, WildcardMatcher> dynamicNodesDn;

    public DefaultInterClusterRequestEvaluator(Settings settings) {
        this.certOid = settings.get("plugins.security.cert.oid", "1.2.3.4.5.5");
        this.staticNodesDnFromEsYml = WildcardMatcher.from(settings.getAsList("plugins.security.nodes_dn", Collections.emptyList()), false);
        this.dynamicNodesDnConfigEnabled = settings.getAsBoolean("plugins.security.nodes_dn_dynamic_config_enabled", Boolean.valueOf(false));
        this.dynamicNodesDn = Collections.emptyMap();
    }

    public void subscribeForChanges(DynamicConfigFactory dynamicConfigFactory) {
        if (this.dynamicNodesDnConfigEnabled) {
            dynamicConfigFactory.registerDCFListener(this);
        }
    }

    private WildcardMatcher getNodesDnToEvaluate() {
        if (this.dynamicNodesDnConfigEnabled) {
            return this.staticNodesDnFromEsYml.concat(this.dynamicNodesDn.values());
        }
        return this.staticNodesDnFromEsYml;
    }

    @Override
    public boolean isInterClusterRequest(TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) {
        Object[] principals = new String[2];
        if (principal != null && principal.length() > 0) {
            principals[0] = principal;
            principals[1] = principal.replace(" ", "");
        }
        WildcardMatcher nodesDn = this.getNodesDnToEvaluate();
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (principals[0] != null && nodesDn.matchAny((String[])principals)) {
            if (isTraceEnabled) {
                this.log.trace("Treat certificate with principal {} as other node because of it matches one of {}", (Object)Arrays.toString(principals), (Object)nodesDn);
            }
            return true;
        }
        if (isTraceEnabled) {
            this.log.trace("Treat certificate with principal {} NOT as other node because we it does not matches one of {}", (Object)Arrays.toString(principals), (Object)nodesDn);
        }
        try {
            Collection<List<?>> ianList = peerCerts[0].getSubjectAlternativeNames();
            if (ianList != null) {
                StringBuilder sb = new StringBuilder();
                for (List<?> ian : ianList) {
                    if (ian == null) continue;
                    Iterator<?> iterator = ian.iterator();
                    while (iterator.hasNext()) {
                        int id = (Integer)iterator.next();
                        if (id == 8) {
                            Object value = iterator.next();
                            if (value == null) continue;
                            if (value instanceof String) {
                                sb.append(id + "::" + value);
                                continue;
                            }
                            if (value instanceof byte[]) {
                                this.log.error("Unable to handle OID san {} with value {} of type byte[] (ASN.1 DER not supported here)", (Object)id, (Object)Arrays.toString((byte[])value));
                                continue;
                            }
                            this.log.error("Unable to handle OID san {} with value {} of type {}", (Object)id, value, value.getClass());
                            continue;
                        }
                        iterator.next();
                    }
                }
                if (sb.indexOf("8::" + this.certOid) >= 0) {
                    return true;
                }
            } else if (isTraceEnabled) {
                this.log.trace("No subject alternative names (san) found");
            }
        }
        catch (CertificateParsingException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Exception parsing certificate using {}", this.getClass(), (Object)e);
            }
            throw new OpenSearchException((Throwable)e);
        }
        return false;
    }

    @Subscribe
    public void onNodesDnModelChanged(NodesDnModel nm) {
        this.dynamicNodesDn = nm.getNodesDn();
    }
}

