# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Optional
from typing_extensions import Literal

from ..._models import BaseModel

__all__ = ["FileSearchTool", "FileSearch", "FileSearchRankingOptions"]


class FileSearchRankingOptions(BaseModel):
    ranker: Optional[Literal["auto", "default_2024_08_21"]] = None
    """The ranker to use for the file search.

    If not specified will use the `auto` ranker.
    """

    score_threshold: Optional[float] = None
    """The score threshold for the file search.

    All values must be a floating point number between 0 and 1.
    """


class FileSearch(BaseModel):
    max_num_results: Optional[int] = None
    """The maximum number of results the file search tool should output.

    The default is 20 for `gpt-4*` models and 5 for `gpt-3.5-turbo`. This number
    should be between 1 and 50 inclusive.

    Note that the file search tool may output fewer than `max_num_results` results.
    See the
    [file search tool documentation](https://platform.openai.com/docs/assistants/tools/file-search/customizing-file-search-settings)
    for more information.
    """

    ranking_options: Optional[FileSearchRankingOptions] = None
    """The ranking options for the file search.

    See the
    [file search tool documentation](https://platform.openai.com/docs/assistants/tools/file-search/customizing-file-search-settings)
    for more information.
    """


class FileSearchTool(BaseModel):
    type: Literal["file_search"]
    """The type of tool being defined: `file_search`"""

    file_search: Optional[FileSearch] = None
    """Overrides for the file search tool."""
