/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.opensearch.neuralsearch.search.util.HybridSearchResultFormatUtil;

class HybridQueryScoreDocsMerger<T extends ScoreDoc> {
    private static final int MIN_NUMBER_OF_ELEMENTS_IN_SCORE_DOC = 3;

    public T[] merge(T[] sourceScoreDocs, T[] newScoreDocs, Comparator<T> comparator, boolean isSortEnabled) {
        if (((ScoreDoc[])Objects.requireNonNull(sourceScoreDocs, "score docs cannot be null")).length < 3 || ((ScoreDoc[])Objects.requireNonNull(newScoreDocs, "score docs cannot be null")).length < 3) {
            throw new IllegalArgumentException("cannot merge top docs because it does not have enough elements");
        }
        ArrayList<T> mergedScoreDocs = new ArrayList<T>(sourceScoreDocs.length + newScoreDocs.length);
        int sourcePointer = 0;
        mergedScoreDocs.add(sourceScoreDocs[sourcePointer]);
        ++sourcePointer;
        int newPointer = 1;
        while (sourcePointer < sourceScoreDocs.length - 1 && newPointer < newScoreDocs.length - 1) {
            mergedScoreDocs.add(sourceScoreDocs[sourcePointer]);
            ++sourcePointer;
            ++newPointer;
            while (sourcePointer < sourceScoreDocs.length && HybridSearchResultFormatUtil.isHybridQueryScoreDocElement(sourceScoreDocs[sourcePointer]) && newPointer < newScoreDocs.length && HybridSearchResultFormatUtil.isHybridQueryScoreDocElement(newScoreDocs[newPointer])) {
                if (this.compareCondition((ScoreDoc)sourceScoreDocs[sourcePointer], (ScoreDoc)newScoreDocs[newPointer], comparator, isSortEnabled)) {
                    mergedScoreDocs.add(sourceScoreDocs[sourcePointer]);
                    ++sourcePointer;
                    continue;
                }
                mergedScoreDocs.add(newScoreDocs[newPointer]);
                ++newPointer;
            }
            while (sourcePointer < sourceScoreDocs.length && HybridSearchResultFormatUtil.isHybridQueryScoreDocElement(sourceScoreDocs[sourcePointer])) {
                mergedScoreDocs.add(sourceScoreDocs[sourcePointer]);
                ++sourcePointer;
            }
            while (newPointer < newScoreDocs.length && HybridSearchResultFormatUtil.isHybridQueryScoreDocElement(newScoreDocs[newPointer])) {
                mergedScoreDocs.add(newScoreDocs[newPointer]);
                ++newPointer;
            }
        }
        mergedScoreDocs.add(sourceScoreDocs[sourceScoreDocs.length - 1]);
        if (isSortEnabled) {
            return mergedScoreDocs.toArray((ScoreDoc[])new FieldDoc[0]);
        }
        return mergedScoreDocs.toArray(new ScoreDoc[0]);
    }

    private boolean compareCondition(ScoreDoc oldScoreDoc, ScoreDoc secondScoreDoc, Comparator<T> comparator, boolean isSortEnabled) {
        if (isSortEnabled) {
            return comparator.compare(oldScoreDoc, secondScoreDoc) < 0;
        }
        return comparator.compare(oldScoreDoc, secondScoreDoc) >= 0;
    }

    @Generated
    HybridQueryScoreDocsMerger() {
    }
}

