/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.session;

import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.client.EMRServerlessClient;
import org.opensearch.sql.spark.client.StartJobRequest;
import org.opensearch.sql.spark.execution.session.CreateSessionRequest;
import org.opensearch.sql.spark.execution.session.Session;
import org.opensearch.sql.spark.execution.session.SessionModel;
import org.opensearch.sql.spark.execution.session.SessionState;
import org.opensearch.sql.spark.execution.statement.QueryRequest;
import org.opensearch.sql.spark.execution.statement.Statement;
import org.opensearch.sql.spark.execution.statement.StatementId;
import org.opensearch.sql.spark.execution.statement.StatementModel;
import org.opensearch.sql.spark.execution.statestore.SessionStorageService;
import org.opensearch.sql.spark.execution.statestore.StatementStorageService;
import org.opensearch.sql.spark.utils.TimeProvider;

public class InteractiveSession
implements Session {
    private static final Logger LOG = LogManager.getLogger();
    public static final String SESSION_ID_TAG_KEY = "sid";
    private final String sessionId;
    private final SessionStorageService sessionStorageService;
    private final StatementStorageService statementStorageService;
    private final EMRServerlessClient serverlessClient;
    private SessionModel sessionModel;
    private long sessionInactivityTimeoutMilli;
    private TimeProvider timeProvider;

    @Override
    public void open(CreateSessionRequest createSessionRequest, AsyncQueryRequestContext asyncQueryRequestContext) {
        createSessionRequest.getSparkSubmitParametersBuilder().sessionExecution(this.sessionId, createSessionRequest.getDatasourceName());
        createSessionRequest.getTags().put(SESSION_ID_TAG_KEY, this.sessionId);
        StartJobRequest startJobRequest = createSessionRequest.getStartJobRequest(this.sessionId);
        String jobID = this.serverlessClient.startJobRun(startJobRequest);
        String applicationId = startJobRequest.getApplicationId();
        String accountId = createSessionRequest.getAccountId();
        this.sessionModel = SessionModel.initInteractiveSession(accountId, applicationId, jobID, this.sessionId, createSessionRequest.getDatasourceName());
        this.sessionStorageService.createSession(this.sessionModel, asyncQueryRequestContext);
    }

    @Override
    public void close() {
        Optional<SessionModel> model = this.sessionStorageService.getSession(this.sessionModel.getId(), this.sessionModel.getDatasourceName());
        if (model.isEmpty()) {
            throw new IllegalStateException("session does not exist. " + this.sessionModel.getSessionId());
        }
        this.serverlessClient.cancelJobRun(this.sessionModel.getApplicationId(), this.sessionModel.getJobId(), false);
    }

    @Override
    public StatementId submit(QueryRequest request, AsyncQueryRequestContext asyncQueryRequestContext) {
        Optional<SessionModel> model = this.sessionStorageService.getSession(this.sessionModel.getId(), this.sessionModel.getDatasourceName());
        if (model.isEmpty()) {
            throw new IllegalStateException("session does not exist. " + this.sessionModel.getSessionId());
        }
        this.sessionModel = model.get();
        if (!SessionState.END_STATE.contains((Object)this.sessionModel.getSessionState())) {
            String qid = request.getQueryId();
            StatementId statementId = StatementId.newStatementId(qid);
            Statement st = Statement.builder().sessionId(this.sessionId).accountId(this.sessionModel.getAccountId()).applicationId(this.sessionModel.getApplicationId()).jobId(this.sessionModel.getJobId()).statementStorageService(this.statementStorageService).statementId(statementId).langType(request.getLangType()).datasourceName(this.sessionModel.getDatasourceName()).query(request.getQuery()).queryId(qid).asyncQueryRequestContext(asyncQueryRequestContext).build();
            st.open();
            return statementId;
        }
        String errMsg = String.format("can't submit statement, session should not be in end state, current session state is: %s", this.sessionModel.getSessionState().getSessionState());
        LOG.debug(errMsg);
        throw new IllegalStateException(errMsg);
    }

    @Override
    public Optional<Statement> get(StatementId stID) {
        return this.statementStorageService.getStatement(stID.getId(), this.sessionModel.getDatasourceName()).map(model -> Statement.builder().sessionId(this.sessionId).accountId(model.getAccountId()).applicationId(model.getApplicationId()).jobId(model.getJobId()).statementId(model.getStatementId()).langType(model.getLangType()).query(model.getQuery()).queryId(model.getQueryId()).statementStorageService(this.statementStorageService).statementModel((StatementModel)model).build());
    }

    @Override
    public boolean isOperationalForDataSource(String dataSourceName) {
        boolean isSessionStateValid = this.sessionModel.getSessionState() != SessionState.DEAD && this.sessionModel.getSessionState() != SessionState.FAIL;
        boolean isSessionUpdatedRecently = this.timeProvider.currentEpochMillis() - this.sessionModel.getLastUpdateTime() <= this.sessionInactivityTimeoutMilli;
        return isSessionStateValid && isSessionUpdatedRecently;
    }

    @Generated
    InteractiveSession(String sessionId, SessionStorageService sessionStorageService, StatementStorageService statementStorageService, EMRServerlessClient serverlessClient, SessionModel sessionModel, long sessionInactivityTimeoutMilli, TimeProvider timeProvider) {
        this.sessionId = sessionId;
        this.sessionStorageService = sessionStorageService;
        this.statementStorageService = statementStorageService;
        this.serverlessClient = serverlessClient;
        this.sessionModel = sessionModel;
        this.sessionInactivityTimeoutMilli = sessionInactivityTimeoutMilli;
        this.timeProvider = timeProvider;
    }

    @Generated
    public static InteractiveSessionBuilder builder() {
        return new InteractiveSessionBuilder();
    }

    @Override
    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public SessionStorageService getSessionStorageService() {
        return this.sessionStorageService;
    }

    @Generated
    public StatementStorageService getStatementStorageService() {
        return this.statementStorageService;
    }

    @Generated
    public EMRServerlessClient getServerlessClient() {
        return this.serverlessClient;
    }

    @Override
    @Generated
    public SessionModel getSessionModel() {
        return this.sessionModel;
    }

    @Generated
    public long getSessionInactivityTimeoutMilli() {
        return this.sessionInactivityTimeoutMilli;
    }

    @Generated
    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @Generated
    public static class InteractiveSessionBuilder {
        @Generated
        private String sessionId;
        @Generated
        private SessionStorageService sessionStorageService;
        @Generated
        private StatementStorageService statementStorageService;
        @Generated
        private EMRServerlessClient serverlessClient;
        @Generated
        private SessionModel sessionModel;
        @Generated
        private long sessionInactivityTimeoutMilli;
        @Generated
        private TimeProvider timeProvider;

        @Generated
        InteractiveSessionBuilder() {
        }

        @Generated
        public InteractiveSessionBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public InteractiveSessionBuilder sessionStorageService(SessionStorageService sessionStorageService) {
            this.sessionStorageService = sessionStorageService;
            return this;
        }

        @Generated
        public InteractiveSessionBuilder statementStorageService(StatementStorageService statementStorageService) {
            this.statementStorageService = statementStorageService;
            return this;
        }

        @Generated
        public InteractiveSessionBuilder serverlessClient(EMRServerlessClient serverlessClient) {
            this.serverlessClient = serverlessClient;
            return this;
        }

        @Generated
        public InteractiveSessionBuilder sessionModel(SessionModel sessionModel) {
            this.sessionModel = sessionModel;
            return this;
        }

        @Generated
        public InteractiveSessionBuilder sessionInactivityTimeoutMilli(long sessionInactivityTimeoutMilli) {
            this.sessionInactivityTimeoutMilli = sessionInactivityTimeoutMilli;
            return this;
        }

        @Generated
        public InteractiveSessionBuilder timeProvider(TimeProvider timeProvider) {
            this.timeProvider = timeProvider;
            return this;
        }

        @Generated
        public InteractiveSession build() {
            return new InteractiveSession(this.sessionId, this.sessionStorageService, this.statementStorageService, this.serverlessClient, this.sessionModel, this.sessionInactivityTimeoutMilli, this.timeProvider);
        }

        @Generated
        public String toString() {
            return "InteractiveSession.InteractiveSessionBuilder(sessionId=" + this.sessionId + ", sessionStorageService=" + this.sessionStorageService + ", statementStorageService=" + this.statementStorageService + ", serverlessClient=" + this.serverlessClient + ", sessionModel=" + this.sessionModel + ", sessionInactivityTimeoutMilli=" + this.sessionInactivityTimeoutMilli + ", timeProvider=" + this.timeProvider + ")";
        }
    }
}

