/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.configs;

import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class HighOldGenOccupancyRcaConfig {
    private static final String CONFIG_NAME = "high-old-gen-occupancy-config";
    public static final long DEFAULT_UTILIZATION = 75L;
    public static final long DEFAULT_EVALUATION_INTERVAL_IN_S = 60L;
    private final Long heapUtilizationThreshold;
    private final long evaluationIntervalInS;

    public HighOldGenOccupancyRcaConfig(RcaConf conf) {
        this.evaluationIntervalInS = conf.readRcaConfig(CONFIG_NAME, HighOldGenOccupancyRcaConfigKeys.EVALUATION_INTERVAL_IN_S.toString(), 60L, Long.class);
        this.heapUtilizationThreshold = conf.readRcaConfig(CONFIG_NAME, HighOldGenOccupancyRcaConfigKeys.HEAP_UTILIZATION_THRESHOLD.toString(), 75L, Long.class);
    }

    public Long getHeapUtilizationThreshold() {
        return this.heapUtilizationThreshold;
    }

    public long getEvaluationIntervalInS() {
        return this.evaluationIntervalInS;
    }

    static enum HighOldGenOccupancyRcaConfigKeys {
        HEAP_UTILIZATION_THRESHOLD("heap-utilization-threshold"),
        EVALUATION_INTERVAL_IN_S("eval-interval-in-s");

        private final String value;

        private HighOldGenOccupancyRcaConfigKeys(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

