import { Adapter, TsType } from '../..';
import { Backup } from '../../../models';
import { BroadcastAddress } from '../../../zspec/enums';
import * as Zcl from '../../../zspec/zcl';
import { ZclPayload } from '../../events';
import { Coordinator } from '../../tstype';
export declare class ZBOSSAdapter extends Adapter {
    private queue;
    private readonly driver;
    private waitress;
    coordinator?: Coordinator;
    constructor(networkOptions: TsType.NetworkOptions, serialPortOptions: TsType.SerialPortOptions, backupPath: string, adapterOptions: TsType.AdapterOptions);
    private processMessage;
    static isValidPath(path: string): Promise<boolean>;
    static autoDetectPath(): Promise<string | null>;
    start(): Promise<TsType.StartResult>;
    stop(): Promise<void>;
    getCoordinator(): Promise<Coordinator>;
    getCoordinatorVersion(): Promise<TsType.CoordinatorVersion>;
    reset(type: 'soft' | 'hard'): Promise<void>;
    supportsBackup(): Promise<boolean>;
    backup(ieeeAddressesInDatabase: string[]): Promise<Backup>;
    getNetworkParameters(): Promise<TsType.NetworkParameters>;
    supportsChangeChannel(): Promise<boolean>;
    changeChannel(newChannel: number): Promise<void>;
    setTransmitPower(value: number): Promise<void>;
    addInstallCode(ieeeAddress: string, key: Buffer): Promise<void>;
    permitJoin(seconds: number, networkAddress: number): Promise<void>;
    lqi(networkAddress: number): Promise<TsType.LQI>;
    routingTable(networkAddress: number): Promise<TsType.RoutingTable>;
    nodeDescriptor(networkAddress: number): Promise<TsType.NodeDescriptor>;
    activeEndpoints(networkAddress: number): Promise<TsType.ActiveEndpoints>;
    simpleDescriptor(networkAddress: number, endpointID: number): Promise<TsType.SimpleDescriptor>;
    bind(destinationNetworkAddress: number, sourceIeeeAddress: string, sourceEndpoint: number, clusterID: number, destinationAddressOrGroup: string | number, type: 'endpoint' | 'group', destinationEndpoint?: number): Promise<void>;
    unbind(destinationNetworkAddress: number, sourceIeeeAddress: string, sourceEndpoint: number, clusterID: number, destinationAddressOrGroup: string | number, type: 'endpoint' | 'group', destinationEndpoint: number): Promise<void>;
    removeDevice(networkAddress: number, ieeeAddr: string): Promise<void>;
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<ZclPayload | void>;
    private sendZclFrameToEndpointInternal;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame, sourceEndpoint?: number): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: BroadcastAddress): Promise<void>;
    setChannelInterPAN(channel: number): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddress: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number): Promise<ZclPayload>;
    restoreChannelInterPAN(): Promise<void>;
    waitFor(networkAddress: number, endpoint: number, transactionSequenceNumber: number, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<ZclPayload>;
        cancel: () => void;
        start: () => {
            promise: Promise<ZclPayload>;
        };
    };
    private waitressTimeoutFormatter;
    private waitressValidator;
}
//# sourceMappingURL=zbossAdapter.d.ts.map