# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network nic list-effective-nsg",
)
class ListEffectiveNsg(AAZCommand):
    """List all effective network security groups applied to a network interface.

    To learn more about troubleshooting using effective security rules visit https://learn.microsoft.com/en-us/azure/virtual-network/diagnose-network-traffic-filter-problem.

    :example: List the effective security groups associated with a NIC.
        az network nic list-effective-nsg -g MyResourceGroup -n MyNic
    """

    _aaz_info = {
        "version": "2018-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkinterfaces/{}/effectivenetworksecuritygroups", "2018-11-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the network interface (NIC).",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.NetworkInterfacesListEffectiveNetworkSecurityGroups(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class NetworkInterfacesListEffectiveNetworkSecurityGroups(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/effectiveNetworkSecurityGroups",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "networkInterfaceName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.value = AAZListType()

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.association = AAZObjectType()
            _element.effective_security_rules = AAZListType(
                serialized_name="effectiveSecurityRules",
            )
            _element.network_security_group = AAZObjectType(
                serialized_name="networkSecurityGroup",
            )
            _ListEffectiveNsgHelper._build_schema_sub_resource_read(_element.network_security_group)
            _element.tag_map = AAZDictType(
                serialized_name="tagMap",
            )

            association = cls._schema_on_200.value.Element.association
            association.network_interface = AAZObjectType(
                serialized_name="networkInterface",
            )
            _ListEffectiveNsgHelper._build_schema_sub_resource_read(association.network_interface)
            association.subnet = AAZObjectType()
            _ListEffectiveNsgHelper._build_schema_sub_resource_read(association.subnet)

            effective_security_rules = cls._schema_on_200.value.Element.effective_security_rules
            effective_security_rules.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.effective_security_rules.Element
            _element.access = AAZStrType()
            _element.destination_address_prefix = AAZStrType(
                serialized_name="destinationAddressPrefix",
            )
            _element.destination_address_prefixes = AAZListType(
                serialized_name="destinationAddressPrefixes",
            )
            _element.destination_port_range = AAZStrType(
                serialized_name="destinationPortRange",
            )
            _element.destination_port_ranges = AAZListType(
                serialized_name="destinationPortRanges",
            )
            _element.direction = AAZStrType()
            _element.expanded_destination_address_prefix = AAZListType(
                serialized_name="expandedDestinationAddressPrefix",
            )
            _element.expanded_source_address_prefix = AAZListType(
                serialized_name="expandedSourceAddressPrefix",
            )
            _element.name = AAZStrType()
            _element.priority = AAZIntType()
            _element.protocol = AAZStrType()
            _element.source_address_prefix = AAZStrType(
                serialized_name="sourceAddressPrefix",
            )
            _element.source_address_prefixes = AAZListType(
                serialized_name="sourceAddressPrefixes",
            )
            _element.source_port_range = AAZStrType(
                serialized_name="sourcePortRange",
            )
            _element.source_port_ranges = AAZListType(
                serialized_name="sourcePortRanges",
            )

            destination_address_prefixes = cls._schema_on_200.value.Element.effective_security_rules.Element.destination_address_prefixes
            destination_address_prefixes.Element = AAZStrType()

            destination_port_ranges = cls._schema_on_200.value.Element.effective_security_rules.Element.destination_port_ranges
            destination_port_ranges.Element = AAZStrType()

            expanded_destination_address_prefix = cls._schema_on_200.value.Element.effective_security_rules.Element.expanded_destination_address_prefix
            expanded_destination_address_prefix.Element = AAZStrType()

            expanded_source_address_prefix = cls._schema_on_200.value.Element.effective_security_rules.Element.expanded_source_address_prefix
            expanded_source_address_prefix.Element = AAZStrType()

            source_address_prefixes = cls._schema_on_200.value.Element.effective_security_rules.Element.source_address_prefixes
            source_address_prefixes.Element = AAZStrType()

            source_port_ranges = cls._schema_on_200.value.Element.effective_security_rules.Element.source_port_ranges
            source_port_ranges.Element = AAZStrType()

            tag_map = cls._schema_on_200.value.Element.tag_map
            tag_map.Element = AAZListType()

            _element = cls._schema_on_200.value.Element.tag_map.Element
            _element.Element = AAZStrType()

            return cls._schema_on_200


class _ListEffectiveNsgHelper:
    """Helper class for ListEffectiveNsg"""

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id


__all__ = ["ListEffectiveNsg"]
