/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.dataprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.dataprocessor.ImputationMethod;

public class ImputationOption
implements Writeable,
ToXContent {
    public static final String METHOD_FIELD = "method";
    public static final String DEFAULT_FILL_FIELD = "defaultFill";
    public static final String INTEGER_SENSITIVE_FIELD = "integerSensitive";
    private final ImputationMethod method;
    private final Optional<double[]> defaultFill;
    private final boolean integerSentive;

    public ImputationOption(ImputationMethod method, Optional<double[]> defaultFill, boolean integerSentive) {
        this.method = method;
        this.defaultFill = defaultFill;
        this.integerSentive = integerSentive;
    }

    public ImputationOption(ImputationMethod method) {
        this(method, Optional.empty(), false);
    }

    public ImputationOption(StreamInput in) throws IOException {
        this.method = (ImputationMethod)in.readEnum(ImputationMethod.class);
        this.defaultFill = in.readBoolean() ? Optional.of(in.readDoubleArray()) : Optional.empty();
        this.integerSentive = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.method);
        if (this.defaultFill.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeDoubleArray(this.defaultFill.get());
        }
        out.writeBoolean(this.integerSentive);
    }

    public static ImputationOption parse(XContentParser parser) throws IOException {
        ImputationMethod method = ImputationMethod.ZERO;
        ArrayList<Double> defaultFill = null;
        Boolean integerSensitive = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "method": {
                    method = ImputationMethod.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "defaultFill": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    defaultFill = new ArrayList<Double>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        defaultFill.add(parser.doubleValue());
                    }
                    break;
                }
                case "integerSensitive": {
                    integerSensitive = parser.booleanValue();
                    break;
                }
            }
        }
        return new ImputationOption(method, Optional.ofNullable(defaultFill).map(list -> list.stream().mapToDouble(Double::doubleValue).toArray()), integerSensitive);
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        builder.field(METHOD_FIELD, (Object)this.method);
        if (!this.defaultFill.isEmpty()) {
            builder.array(DEFAULT_FILL_FIELD, this.defaultFill.get());
        }
        builder.field(INTEGER_SENSITIVE_FIELD, this.integerSentive);
        return xContentBuilder.endObject();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImputationOption other = (ImputationOption)o;
        return this.method == other.method && (this.defaultFill.isEmpty() ? other.defaultFill.isEmpty() : Arrays.equals(this.defaultFill.get(), other.defaultFill.get())) && this.integerSentive == other.integerSentive;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.defaultFill.isEmpty() ? 0 : Arrays.hashCode(this.defaultFill.get()), this.integerSentive});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(METHOD_FIELD, (Object)this.method).append(DEFAULT_FILL_FIELD, this.defaultFill.isEmpty() ? null : Arrays.toString(this.defaultFill.get())).append("integerSentive", this.integerSentive).toString();
    }

    public ImputationMethod getMethod() {
        return this.method;
    }

    public Optional<double[]> getDefaultFill() {
        return this.defaultFill;
    }

    public boolean isIntegerSentive() {
        return this.integerSentive;
    }
}

