/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint.operation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.client.EMRServerlessClientFactory;
import org.opensearch.sql.spark.flint.FlintIndexClient;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexState;
import org.opensearch.sql.spark.flint.FlintIndexStateModel;
import org.opensearch.sql.spark.flint.FlintIndexStateModelService;
import org.opensearch.sql.spark.flint.operation.FlintIndexOp;

public class FlintIndexOpVacuum
extends FlintIndexOp {
    private static final Logger LOG = LogManager.getLogger();
    private final FlintIndexClient flintIndexClient;

    public FlintIndexOpVacuum(FlintIndexStateModelService flintIndexStateModelService, String datasourceName, FlintIndexClient flintIndexClient, EMRServerlessClientFactory emrServerlessClientFactory) {
        super(flintIndexStateModelService, datasourceName, emrServerlessClientFactory);
        this.flintIndexClient = flintIndexClient;
    }

    @Override
    boolean validate(FlintIndexState state) {
        return state == FlintIndexState.DELETED;
    }

    @Override
    FlintIndexState transitioningState() {
        return FlintIndexState.VACUUMING;
    }

    @Override
    public void runOp(FlintIndexMetadata flintIndexMetadata, FlintIndexStateModel flintIndex) {
        LOG.info("Vacuuming Flint index {}", (Object)flintIndexMetadata.getOpensearchIndexName());
        this.flintIndexClient.deleteIndex(flintIndexMetadata.getOpensearchIndexName());
    }

    @Override
    FlintIndexState stableState() {
        return FlintIndexState.NONE;
    }
}

