/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.stagent;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.sampler.truffle.stagent.TruffleJMX;
import sun.misc.Unsafe;

class TruffleClassLoader
extends ClassLoader {
    private static final String TRUFFLE_LOCATOR_CLASS_NAME = "com.oracle.truffle.api.impl.TruffleLocator";
    private static final String GRAALVM_LOCATOR_CLASS_NAME = "com.oracle.graalvm.locator.GraalVMLocator";
    private Collection<ClassLoader> loaders;

    TruffleClassLoader(ClassLoader parent, Unsafe unsafe) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        super(parent);
        this.loaders = TruffleClassLoader.getTruffleLocatorLoaders(parent);
        if (this.loaders == null) {
            this.loaders = TruffleClassLoader.getGraalVMLocatorLoaders(parent, unsafe);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.loaders == null) {
            return super.findClass(name);
        }
        for (ClassLoader loader : this.loaders) {
            if (loader == null) continue;
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    private static Class getClass(ClassLoader cl, String className) throws ClassNotFoundException {
        if (cl == null) {
            return Class.forName(className);
        }
        return cl.loadClass(className);
    }

    private static Collection<ClassLoader> getTruffleLocatorLoaders(ClassLoader cl) {
        try {
            Class LocatorClass = TruffleClassLoader.getClass(cl, TRUFFLE_LOCATOR_CLASS_NAME);
            return (Collection)LocatorClass.getMethod("loaders", null).invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            if (TruffleJMX.DEBUG) {
                Logger.getLogger(TruffleClassLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    private static Collection<ClassLoader> getGraalVMLocatorLoaders(ClassLoader cl, Unsafe unsafe) {
        try {
            Class LocatorClass = TruffleClassLoader.getClass(cl, GRAALVM_LOCATOR_CLASS_NAME);
            Field f = LocatorClass.getDeclaredField("loader");
            Object base = unsafe.staticFieldBase(f);
            ClassLoader loader = (ClassLoader)unsafe.getObject(base, unsafe.staticFieldOffset(f));
            return Collections.singletonList(loader);
        }
        catch (Exception ex) {
            Logger.getLogger(TruffleClassLoader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

