import * as Models from '../../../models';
import { BroadcastAddress } from '../../../zspec/enums';
import * as Zcl from '../../../zspec/zcl';
import Adapter from '../../adapter';
import * as Events from '../../events';
import { ActiveEndpoints, AdapterOptions, Coordinator, CoordinatorVersion, LQI, NetworkOptions, NetworkParameters, NodeDescriptor, RoutingTable, SerialPortOptions, SimpleDescriptor, StartResult } from '../../tstype';
declare class DeconzAdapter extends Adapter {
    private driver;
    private queue;
    private openRequestsQueue;
    private transactionID;
    private frameParserEvent;
    private joinPermitted;
    private fwVersion?;
    private waitress;
    private TX_OPTIONS;
    constructor(networkOptions: NetworkOptions, serialPortOptions: SerialPortOptions, backupPath: string, adapterOptions: AdapterOptions);
    static isValidPath(path: string): Promise<boolean>;
    static autoDetectPath(): Promise<string | undefined>;
    /**
     * Adapter methods
     */
    start(): Promise<StartResult>;
    stop(): Promise<void>;
    getCoordinator(): Promise<Coordinator>;
    permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    getCoordinatorVersion(): Promise<CoordinatorVersion>;
    addInstallCode(ieeeAddress: string, key: Buffer): Promise<void>;
    reset(type: 'soft' | 'hard'): Promise<void>;
    lqi(networkAddress: number): Promise<LQI>;
    routingTable(networkAddress: number): Promise<RoutingTable>;
    nodeDescriptor(networkAddress: number): Promise<NodeDescriptor>;
    activeEndpoints(networkAddress: number): Promise<ActiveEndpoints>;
    simpleDescriptor(networkAddress: number, endpointID: number): Promise<SimpleDescriptor>;
    private checkCoordinatorSimpleDescriptor;
    waitFor(networkAddress: number | undefined, endpoint: number, frameType: Zcl.FrameType, direction: Zcl.Direction, transactionSequenceNumber: number | undefined, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<Events.ZclPayload>;
        cancel: () => void;
    };
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<Events.ZclPayload | void>;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: BroadcastAddress): Promise<void>;
    bind(destinationNetworkAddress: number, sourceIeeeAddress: string, sourceEndpoint: number, clusterID: number, destinationAddressOrGroup: string | number, type: 'endpoint' | 'group', destinationEndpoint?: number): Promise<void>;
    unbind(destinationNetworkAddress: number, sourceIeeeAddress: string, sourceEndpoint: number, clusterID: number, destinationAddressOrGroup: string | number, type: 'endpoint' | 'group', destinationEndpoint?: number): Promise<void>;
    removeDevice(networkAddress: number, ieeeAddr: string): Promise<void>;
    supportsBackup(): Promise<boolean>;
    backup(): Promise<Models.Backup>;
    getNetworkParameters(): Promise<NetworkParameters>;
    restoreChannelInterPAN(): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddr: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number): Promise<Events.ZclPayload>;
    sendZclFrameInterPANBroadcastWithResponse(zclFrame: Zcl.Frame, timeout: number): Promise<Events.ZclPayload>;
    setChannelInterPAN(channel: number): Promise<void>;
    changeChannel(newChannel: number): Promise<void>;
    setTransmitPower(value: number): Promise<void>;
    sendZclFrameInterPANIeeeAddr(zclFrame: Zcl.Frame, ieeeAddr: string): Promise<void>;
    /**
     * Private methods
     */
    private sleep;
    private waitForData;
    private checkReceivedGreenPowerIndication;
    private checkReceivedDataPayload;
    private nextTransactionID;
    private waitressTimeoutFormatter;
    private waitressValidator;
}
export default DeconzAdapter;
//# sourceMappingURL=deconzAdapter.d.ts.map