"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrameType = exports.ZBOSSBuffaloZcl = void 0;
exports.readZBOSSFrame = readZBOSSFrame;
exports.writeZBOSSFrame = writeZBOSSFrame;
exports.makeFrame = makeFrame;
const buffaloZcl_1 = require("../../zspec/zcl/buffaloZcl");
const commands_1 = require("./commands");
const enums_1 = require("./enums");
class ZBOSSBuffaloZcl extends buffaloZcl_1.BuffaloZcl {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    write(type, value, options) {
        switch (type) {
            case enums_1.BuffaloZBOSSDataType.EXTENDED_PAN_ID: {
                return this.writeBuffer(value, 8);
            }
            default: {
                return super.write(type, value, options);
            }
        }
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    read(type, options) {
        switch (type) {
            case enums_1.BuffaloZBOSSDataType.EXTENDED_PAN_ID: {
                return this.readBuffer(8);
            }
            default: {
                return super.read(type, options);
            }
        }
    }
    writeByDesc(payload, params) {
        const start = this.getPosition();
        for (const parameter of params) {
            const options = {};
            if (parameter.condition && !parameter.condition(payload, this)) {
                continue;
            }
            if (parameter.options)
                parameter.options(payload, options);
            if (parameter.type == enums_1.BuffaloZBOSSDataType.LIST_TYPED && parameter.typed) {
                const internalPaload = payload[parameter.name];
                for (const value of internalPaload) {
                    this.writeByDesc(value, parameter.typed);
                }
            }
            else {
                this.write(parameter.type, payload[parameter.name], options);
            }
        }
        return this.getPosition() - start;
    }
    readByDesc(params) {
        const payload = {};
        for (const parameter of params) {
            const options = { payload };
            if (parameter.condition && !parameter.condition(payload, this)) {
                continue;
            }
            if (parameter.options)
                parameter.options(payload, options);
            if (parameter.type == enums_1.BuffaloZBOSSDataType.LIST_TYPED && parameter.typed) {
                payload[parameter.name] = [];
                if (!this.isMore())
                    break;
                for (let i = 0; i < (options.length || 0); i++) {
                    const internalPaload = this.readByDesc(parameter.typed);
                    payload[parameter.name].push(internalPaload);
                }
            }
            else {
                if (!this.isMore())
                    break;
                payload[parameter.name] = this.read(parameter.type, options);
            }
        }
        return payload;
    }
}
exports.ZBOSSBuffaloZcl = ZBOSSBuffaloZcl;
function getFrameDesc(type, key) {
    const frameDesc = commands_1.FRAMES[key];
    if (!frameDesc)
        throw new Error(`Unrecognized frame type from FrameID ${key}`);
    switch (type) {
        case FrameType.REQUEST:
            return frameDesc.request || [];
        case FrameType.RESPONSE:
            return frameDesc.response || [];
        case FrameType.INDICATION:
            return frameDesc.indication || [];
    }
}
function readZBOSSFrame(buffer) {
    const buf = new ZBOSSBuffaloZcl(buffer);
    const version = buf.readUInt8();
    const type = buf.readUInt8();
    const commandId = buf.readUInt16();
    let tsn = 0;
    if ([FrameType.REQUEST, FrameType.RESPONSE].includes(type)) {
        tsn = buf.readUInt8();
    }
    const payload = readPayload(type, commandId, buf);
    return {
        version,
        type,
        commandId,
        tsn,
        payload,
    };
}
function writeZBOSSFrame(frame) {
    const buf = new ZBOSSBuffaloZcl(Buffer.alloc(247));
    buf.writeInt8(frame.version);
    buf.writeInt8(frame.type);
    buf.writeUInt16(frame.commandId);
    buf.writeUInt8(frame.tsn);
    writePayload(frame.type, frame.commandId, frame.payload, buf);
    return buf.getWritten();
}
var FrameType;
(function (FrameType) {
    FrameType[FrameType["REQUEST"] = 0] = "REQUEST";
    FrameType[FrameType["RESPONSE"] = 1] = "RESPONSE";
    FrameType[FrameType["INDICATION"] = 2] = "INDICATION";
})(FrameType || (exports.FrameType = FrameType = {}));
function makeFrame(type, commandId, params) {
    const frameDesc = getFrameDesc(type, commandId);
    const payload = {};
    for (const parameter of frameDesc) {
        // const options: BuffaloZclOptions = {payload};
        if (parameter.condition && !parameter.condition(payload, undefined)) {
            continue;
        }
        payload[parameter.name] = params[parameter.name];
    }
    return {
        version: 0,
        type: type,
        commandId: commandId,
        tsn: 0,
        payload: payload,
    };
}
function readPayload(type, commandId, buffalo) {
    const frameDesc = getFrameDesc(type, commandId);
    return buffalo.readByDesc(frameDesc);
}
function writePayload(type, commandId, payload, buffalo) {
    const frameDesc = getFrameDesc(type, commandId);
    return buffalo.writeByDesc(payload, frameDesc);
}
//# sourceMappingURL=frame.js.map