# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobStatisticsVertexStage(Model):
    """The Data Lake Analytics job statistics vertex stage information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar data_read: the amount of data read, in bytes.
    :vartype data_read: long
    :ivar data_read_cross_pod: the amount of data read across multiple pods,
     in bytes.
    :vartype data_read_cross_pod: long
    :ivar data_read_intra_pod: the amount of data read in one pod, in bytes.
    :vartype data_read_intra_pod: long
    :ivar data_to_read: the amount of data remaining to be read, in bytes.
    :vartype data_to_read: long
    :ivar data_written: the amount of data written, in bytes.
    :vartype data_written: long
    :ivar duplicate_discard_count: the number of duplicates that were
     discarded.
    :vartype duplicate_discard_count: int
    :ivar failed_count: the number of failures that occured in this stage.
    :vartype failed_count: int
    :ivar max_vertex_data_read: the maximum amount of data read in a single
     vertex, in bytes.
    :vartype max_vertex_data_read: long
    :ivar min_vertex_data_read: the minimum amount of data read in a single
     vertex, in bytes.
    :vartype min_vertex_data_read: long
    :ivar read_failure_count: the number of read failures in this stage.
    :vartype read_failure_count: int
    :ivar revocation_count: the number of vertices that were revoked during
     this stage.
    :vartype revocation_count: int
    :ivar running_count: the number of currently running vertices in this
     stage.
    :vartype running_count: int
    :ivar scheduled_count: the number of currently scheduled vertices in this
     stage
    :vartype scheduled_count: int
    :ivar stage_name: the name of this stage in job execution.
    :vartype stage_name: str
    :ivar succeeded_count: the number of vertices that succeeded in this
     stage.
    :vartype succeeded_count: int
    :ivar temp_data_written: the amount of temporary data written, in bytes.
    :vartype temp_data_written: long
    :ivar total_count: the total vertex count for this stage.
    :vartype total_count: int
    :ivar total_failed_time: the amount of time that failed vertices took up
     in this stage.
    :vartype total_failed_time: timedelta
    :ivar total_progress: the current progress of this stage, as a percentage.
    :vartype total_progress: int
    :ivar total_succeeded_time: the amount of time all successful vertices
     took in this stage.
    :vartype total_succeeded_time: timedelta
    """

    _validation = {
        'data_read': {'readonly': True},
        'data_read_cross_pod': {'readonly': True},
        'data_read_intra_pod': {'readonly': True},
        'data_to_read': {'readonly': True},
        'data_written': {'readonly': True},
        'duplicate_discard_count': {'readonly': True},
        'failed_count': {'readonly': True},
        'max_vertex_data_read': {'readonly': True},
        'min_vertex_data_read': {'readonly': True},
        'read_failure_count': {'readonly': True},
        'revocation_count': {'readonly': True},
        'running_count': {'readonly': True},
        'scheduled_count': {'readonly': True},
        'stage_name': {'readonly': True},
        'succeeded_count': {'readonly': True},
        'temp_data_written': {'readonly': True},
        'total_count': {'readonly': True},
        'total_failed_time': {'readonly': True},
        'total_progress': {'readonly': True},
        'total_succeeded_time': {'readonly': True},
    }

    _attribute_map = {
        'data_read': {'key': 'dataRead', 'type': 'long'},
        'data_read_cross_pod': {'key': 'dataReadCrossPod', 'type': 'long'},
        'data_read_intra_pod': {'key': 'dataReadIntraPod', 'type': 'long'},
        'data_to_read': {'key': 'dataToRead', 'type': 'long'},
        'data_written': {'key': 'dataWritten', 'type': 'long'},
        'duplicate_discard_count': {'key': 'duplicateDiscardCount', 'type': 'int'},
        'failed_count': {'key': 'failedCount', 'type': 'int'},
        'max_vertex_data_read': {'key': 'maxVertexDataRead', 'type': 'long'},
        'min_vertex_data_read': {'key': 'minVertexDataRead', 'type': 'long'},
        'read_failure_count': {'key': 'readFailureCount', 'type': 'int'},
        'revocation_count': {'key': 'revocationCount', 'type': 'int'},
        'running_count': {'key': 'runningCount', 'type': 'int'},
        'scheduled_count': {'key': 'scheduledCount', 'type': 'int'},
        'stage_name': {'key': 'stageName', 'type': 'str'},
        'succeeded_count': {'key': 'succeededCount', 'type': 'int'},
        'temp_data_written': {'key': 'tempDataWritten', 'type': 'long'},
        'total_count': {'key': 'totalCount', 'type': 'int'},
        'total_failed_time': {'key': 'totalFailedTime', 'type': 'duration'},
        'total_progress': {'key': 'totalProgress', 'type': 'int'},
        'total_succeeded_time': {'key': 'totalSucceededTime', 'type': 'duration'},
    }

    def __init__(self):
        self.data_read = None
        self.data_read_cross_pod = None
        self.data_read_intra_pod = None
        self.data_to_read = None
        self.data_written = None
        self.duplicate_discard_count = None
        self.failed_count = None
        self.max_vertex_data_read = None
        self.min_vertex_data_read = None
        self.read_failure_count = None
        self.revocation_count = None
        self.running_count = None
        self.scheduled_count = None
        self.stage_name = None
        self.succeeded_count = None
        self.temp_data_written = None
        self.total_count = None
        self.total_failed_time = None
        self.total_progress = None
        self.total_succeeded_time = None
