/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.notifications.core.repackage.com.amazonaws.AmazonServiceException;
import org.opensearch.notifications.core.repackage.com.amazonaws.AmazonWebServiceResponse;
import org.opensearch.notifications.core.repackage.com.amazonaws.SDKGlobalConfiguration;
import org.opensearch.notifications.core.repackage.com.amazonaws.annotation.SdkProtectedApi;
import org.opensearch.notifications.core.repackage.com.amazonaws.annotation.ThreadSafe;
import org.opensearch.notifications.core.repackage.com.amazonaws.http.HttpResponseHandler;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.OperationInfo;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.Protocol;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.ProtocolRequestMarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.JsonClientMetadata;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.JsonContentTypeResolver;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.JsonOperationMetadata;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.JsonProtocolMarshallerBuilder;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.SdkStructuredCborFactory;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.SdkStructuredJsonFactory;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.SdkStructuredPlainJsonFactory;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.StructuredJsonGenerator;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.internal.EmptyBodyJsonMarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.JsonErrorUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.JsonUnmarshallerContext;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Unmarshaller;

@ThreadSafe
@SdkProtectedApi
public class SdkJsonProtocolFactory
implements SdkJsonMarshallerFactory {
    private final JsonClientMetadata metadata;
    private final List<JsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();

    public SdkJsonProtocolFactory(JsonClientMetadata metadata) {
        this.metadata = metadata;
        this.createErrorUnmarshallers();
    }

    @Override
    public StructuredJsonGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    @Override
    public String getContentType() {
        return this.getContentTypeResolver().resolveContentType(this.metadata);
    }

    public <T> ProtocolRequestMarshaller<T> createProtocolMarshaller(OperationInfo operationInfo, T origRequest) {
        return JsonProtocolMarshallerBuilder.standard().jsonGenerator(this.createGenerator(operationInfo)).contentType(this.getContentType()).operationInfo(operationInfo).originalRequest(origRequest).emptyBodyMarshaller(this.createEmptyBodyMarshaller(operationInfo)).build();
    }

    private StructuredJsonGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.AWS_JSON) {
            return this.createGenerator();
        }
        return StructuredJsonGenerator.NO_OP;
    }

    private EmptyBodyJsonMarshaller createEmptyBodyMarshaller(OperationInfo operationInfo) {
        if (operationInfo.protocol() == Protocol.API_GATEWAY) {
            throw new IllegalStateException("Detected the API_GATEWAY protocol which should not be used with this protocol factory.");
        }
        if (!operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.API_GATEWAY) {
            return EmptyBodyJsonMarshaller.NULL;
        }
        return EmptyBodyJsonMarshaller.EMPTY;
    }

    public <T> HttpResponseHandler<AmazonWebServiceResponse<T>> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public HttpResponseHandler<AmazonServiceException> createErrorResponseHandler(JsonErrorResponseMetadata errorResponsMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(errorResponsMetadata, this.errorUnmarshallers);
    }

    private void createErrorUnmarshallers() {
        for (JsonErrorShapeMetadata errorMetadata : this.metadata.getErrorShapeMetadata()) {
            if (errorMetadata.getExceptionUnmarshaller() != null) {
                this.errorUnmarshallers.add(errorMetadata.getExceptionUnmarshaller());
                continue;
            }
            if (errorMetadata.getModeledClass() == null) continue;
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        if (this.metadata.getBaseServiceExceptionClass() != null) {
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), null));
        }
    }

    private SdkStructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return SdkStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        return SdkStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    }

    private JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return JsonContentTypeResolver.CBOR;
        }
        return JsonContentTypeResolver.JSON;
    }

    private boolean isCborEnabled() {
        return this.metadata.isSupportsCbor() && !SDKGlobalConfiguration.isCborDisabled();
    }
}

