/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.BSUtil;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class SpaceGroupFinder {
    private static final int MAX_COUNT = 100;
    private static int GROUP_COUNT;
    private static int OP_COUNT;
    private static BS[] bsOpGroups;
    private static BS[] bsGroupOps;
    private static String[] groupNames;
    private static String[] opXYZ;
    private static SymmetryOperation[] ops;
    private static BufferedReader rdr;
    private Viewer vwr;
    private Symmetry uc;
    private SpaceGroup sg;
    private Atom[] cartesians;
    private SGAtom[] atoms;
    private int nAtoms;
    private String xyzList;
    private float[] unitCellParams;
    private float slop;
    private boolean isCalcOnly;
    private boolean isAssign;
    private boolean isUnknown;
    private boolean checkSupercell;
    private boolean isSupercell;
    private boolean asString;
    private BS bsPoints0;
    private BS bsAtoms;
    private BS targets;
    private T3 origin;
    private T3[] oabc;
    private P3 scaling;
    private P3 pTemp = new P3();
    private int isg;

    Object findSpaceGroup(Viewer vwr, BS atoms0, String xyzList0, float[] unitCellParams, T3 origin, T3[] oabc0, SymmetryInterface uci, int flags) {
        BS basis;
        String name;
        boolean isHall;
        this.vwr = vwr;
        this.xyzList = xyzList0;
        this.unitCellParams = unitCellParams;
        this.origin = origin;
        this.oabc = oabc0;
        this.uc = (Symmetry)uci;
        System.out.println(this.xyzList);
        this.isCalcOnly = (flags & 0x10) != 0;
        this.isAssign = (flags & 2) != 0;
        this.checkSupercell = (flags & 8) != 0;
        this.asString = (flags & 1) != 0;
        boolean setFromScratch = (flags & 4) != 0;
        float slop0 = this.uc.getPrecision();
        this.slop = !Double.isNaN(slop0) ? slop0 : (unitCellParams != null && unitCellParams.length > 26 ? unitCellParams[26] : 1.0E-4f);
        this.cartesians = vwr.ms.at;
        this.bsPoints0 = new BS();
        if (this.xyzList == null || this.isAssign) {
            this.bsAtoms = BSUtil.copy(atoms0);
            this.nAtoms = this.bsAtoms.cardinality();
        }
        this.targets = BS.newN(this.nAtoms);
        this.scaling = P3.new3(1.0f, 1.0f, 1.0f);
        this.isUnknown = true;
        boolean isITA = this.xyzList != null && this.xyzList.toUpperCase().startsWith("ITA/");
        boolean bl = isHall = this.xyzList != null && !isITA && (this.xyzList.startsWith("[") || this.xyzList.startsWith("Hall:"));
        if (this.isAssign && isHall || !isHall && (isITA || (isITA = this.checkWyckoffHM()))) {
            this.isUnknown = false;
            this.xyzList = isITA ? PT.rep(this.xyzList.substring(4), " ", "") : (this.xyzList.startsWith("Hall:") ? this.xyzList.substring(5) : PT.replaceAllCharacters(this.xyzList, "[]", ""));
            this.sg = this.setITA(isHall);
            if (this.sg == null) {
                return null;
            }
            name = this.sg.getName();
        } else if (this.oabc != null || isHall) {
            name = this.xyzList;
            if (name != null) {
                this.sg = SpaceGroup.createSpaceGroupN(name, isHall);
            }
            boolean bl2 = this.isUnknown = this.sg == null;
            if (isHall && !this.isUnknown) {
                return this.sg.dumpInfoObj();
            }
        } else if (SpaceGroup.isXYZList(this.xyzList)) {
            this.sg = SpaceGroup.findSpaceGroupFromXYZ(this.xyzList);
            if (this.sg != null) {
                return this.sg.dumpInfoObj();
            }
        }
        if (setFromScratch) {
            if (this.sg == null && (this.sg = SpaceGroup.determineSpaceGroupNA(this.xyzList, unitCellParams)) == null && (this.sg = SpaceGroup.createSpaceGroupN(this.xyzList, false)) == null) {
                return null;
            }
            basis = new BS();
            name = this.sg.asString();
            if (this.oabc == null) {
                boolean userDefined = unitCellParams.length == 6;
                this.uc = SpaceGroupFinder.setSpaceGroupAndUnitCell(this.sg, unitCellParams, null, userDefined);
                this.oabc = this.uc.getUnitCellVectors();
                if (origin != null) {
                    this.oabc[0].setT(origin);
                }
            } else {
                this.uc = SpaceGroupFinder.setSpaceGroupAndUnitCell(this.sg, null, this.oabc, false);
                this.uc.transformUnitCell(uci.replaceTransformMatrix(null));
            }
        } else {
            Object ret = this.findGroupByOperations();
            if (!this.isAssign || !(ret instanceof SpaceGroup)) {
                return ret;
            }
            this.sg = (SpaceGroup)ret;
            name = this.sg.asString();
            basis = BSUtil.copy(this.bsAtoms);
            int i = this.targets.nextSetBit(0);
            while (i >= 0) {
                basis.clear(this.atoms[i].index);
                i = this.targets.nextSetBit(i + 1);
            }
            int nb = basis.cardinality();
            if (!this.isCalcOnly) {
                String msg = name + (atoms0 == null || nb == 0 ? "" : "\nbasis is " + nb + " atom" + (nb == 1 ? "" : "s") + ": " + basis);
                System.out.println("SpaceGroupFinder: " + msg);
                if (this.asString) {
                    return msg;
                }
            }
        }
        Map map = (Map)this.sg.dumpInfoObj();
        if (this.uc != null && !this.isCalcOnly) {
            System.out.println("unitcell is " + this.uc.getUnitCellInfo(true));
        }
        if (!this.isAssign) {
            BS bs1 = BS.copy(this.bsPoints0);
            bs1.andNot(this.targets);
            this.dumpBasis(bsGroupOps[this.isg], bs1, this.bsPoints0);
        }
        map.put("name", name);
        map.put("basis", basis);
        if (this.isSupercell) {
            map.put("supercell", this.scaling);
        }
        this.oabc[1].scale(1.0f / this.scaling.x);
        this.oabc[2].scale(1.0f / this.scaling.y);
        this.oabc[3].scale(1.0f / this.scaling.z);
        map.put("unitcell", this.oabc);
        if (this.isAssign) {
            map.put("sg", this.sg);
        }
        return map;
    }

    private boolean checkWyckoffHM() {
        String clegId;
        if (this.xyzList != null && this.xyzList.indexOf(",") < 0 && (clegId = SpaceGroup.convertWyckoffHMCleg(this.xyzList, null)) != null) {
            this.xyzList = "ITA/" + clegId;
            return true;
        }
        return false;
    }

    private SpaceGroup setITA(boolean isHall) {
        Lst genPos;
        boolean isITADotSetting;
        String name = null;
        Map sgdata = null;
        int pt = this.xyzList.lastIndexOf(":");
        int pt2 = this.xyzList.indexOf(",");
        boolean hasTransform = pt > 0 && pt2 > pt;
        String clegId = null;
        boolean isJmolCode = pt > 0 && !hasTransform;
        String transform = null;
        if (hasTransform) {
            name = transform = this.uc.staticCleanTransform(this.xyzList.substring(pt + 1));
            this.xyzList = this.xyzList.substring(0, pt);
            clegId = this.xyzList + ":" + transform;
            if (transform.equals("a,b,c")) {
                transform = null;
                hasTransform = false;
            }
        }
        if ((pt = this.xyzList.indexOf(".")) > 0 && (hasTransform || isJmolCode)) {
            this.xyzList = this.xyzList.substring(0, pt);
            pt = -1;
        }
        String itano = this.xyzList;
        boolean bl = isITADotSetting = pt > 0;
        if (!(isJmolCode || isHall || hasTransform || isITADotSetting || PT.parseInt(itano) == Integer.MIN_VALUE)) {
            this.xyzList = this.xyzList + ".1";
        }
        Map setting = null;
        String itaIndex = this.xyzList;
        if (isHall) {
            genPos = (Lst)this.uc.getSpaceGroupInfoObj("nameToXYZList", "Hall:" + this.xyzList, false, false);
            if (genPos == null) {
                return null;
            }
        } else {
            name = hasTransform ? transform : itaIndex;
            this.sg = SpaceGroup.getSpaceGroupFromJmolClegOrITA(hasTransform ? clegId : itaIndex);
            Object o = this.uc.getSpaceGroupJSON(this.vwr, "ITA", itaIndex, 0);
            if (o == null || o instanceof String) {
                return null;
            }
            sgdata = (Map)o;
            if (isJmolCode || hasTransform) {
                Lst its = (Lst)sgdata.get("its");
                if (its == null) {
                    return null;
                }
                sgdata = null;
                int c = its.size();
                for (int i = 0; i < c; ++i) {
                    setting = (Map)its.get(i);
                    if (!name.equals(setting.get(hasTransform ? "trm" : "jmolId"))) continue;
                    sgdata = setting;
                    break;
                }
                if (sgdata == null || !sgdata.containsKey("jmolId")) {
                    if (isJmolCode) {
                        return null;
                    }
                    setting = null;
                    if (sgdata != null) {
                        transform = (String)sgdata.get("trm");
                    }
                    hasTransform = true;
                    sgdata = (Map)its.get(0);
                } else {
                    setting = null;
                    hasTransform = false;
                    transform = null;
                }
            } else {
                name = (String)sgdata.get("jmolId");
            }
            genPos = (Lst)sgdata.get("gp");
        }
        if (this.sg != null && transform == null) {
            this.sg = SpaceGroup.createITASpaceGroup(genPos, this.sg);
            return this.sg;
        }
        this.sg = SpaceGroup.transformSpaceGroup(null, this.sg, genPos, hasTransform ? transform : null, hasTransform ? new M4() : null);
        if (this.sg == null) {
            return null;
        }
        name = "";
        if (this.sg.itaNumber.equals("0")) {
            if (transform == null) {
                transform = (String)sgdata.get("trm");
                String hm = (String)sgdata.get("hm");
                this.sg.setHMSymbol(hm);
            } else {
                this.sg.setITATableNames(null, itano, null, transform);
            }
            name = null;
            System.out.println("SpaceGroupFinder: new setting: " + this.sg.asString());
        }
        return this.sg;
    }

    private Object findGroupByOperations() {
        BS bsOps = new BS();
        BS bsGroups = new BS();
        int n = 0;
        int nChecked = 0;
        try {
            int i;
            if (this.isUnknown) {
                if (bsOpGroups == null) {
                    SpaceGroupFinder.loadData(this.vwr, this);
                }
            } else {
                bsGroups.set(0);
            }
            if (this.xyzList != null) {
                if (this.isUnknown) {
                    Object ret = this.getGroupsWithOps(this.xyzList, this.unitCellParams, this.isAssign);
                    if (!this.isAssign || ret == null) {
                        return ret;
                    }
                    this.sg = (SpaceGroup)ret;
                }
                if (this.oabc == null) {
                    this.uc.setUnitCellFromParams(this.unitCellParams, false, this.slop);
                }
            }
            Symmetry uc0 = this.uc;
            if (this.oabc == null) {
                this.oabc = this.uc.getUnitCellVectors();
                this.uc = (Symmetry)this.uc.getUnitCellMultiplied();
                if (this.origin != null && !this.origin.equals(this.uc.getCartesianOffset())) {
                    this.oabc[0].setT(this.origin);
                    this.uc.setCartesianOffset(this.origin);
                }
            } else {
                this.uc.getUnitCell(this.oabc, false, "finder");
            }
            if (this.isUnknown) {
                this.filterGroups(bsGroups, this.uc.getUnitCellParams());
            } else if (this.nAtoms == 0) {
                return this.sg;
            }
            if (this.bsAtoms != null) {
                this.atoms = new SGAtom[this.bsAtoms.cardinality()];
                System.out.println("bsAtoms = " + this.bsAtoms);
                int p = 0;
                i = this.bsAtoms.nextSetBit(0);
                while (i >= 0) {
                    Atom a = this.cartesians[i];
                    int type = a.getAtomicAndIsotopeNumber();
                    this.atoms[p] = new SGAtom(type, i, a.getAtomName(), a.getOccupancy100());
                    this.atoms[p].setT(this.toFractional(a, this.uc));
                    i = this.bsAtoms.nextSetBit(i + 1);
                    ++p;
                }
            }
            BS bsPoints = BSUtil.newBitSet2(0, this.nAtoms);
            this.nAtoms = bsPoints.cardinality();
            uc0 = this.uc;
            if (this.nAtoms > 0) {
                i = bsPoints.nextSetBit(0);
                while (i >= 0) {
                    this.uc.unitize(this.atoms[i]);
                    i = bsPoints.nextSetBit(i + 1);
                }
                this.removeDuplicates(bsPoints);
                if (this.checkSupercell) {
                    this.uc = this.checkSupercell(this.vwr, this.uc, bsPoints, 1, this.scaling);
                    this.uc = this.checkSupercell(this.vwr, this.uc, bsPoints, 2, this.scaling);
                    this.uc = this.checkSupercell(this.vwr, this.uc, bsPoints, 3, this.scaling);
                    boolean bl = this.isSupercell = this.uc != uc0;
                    if (this.isSupercell) {
                        if (this.scaling.x != 1.0f) {
                            System.out.println("supercell found; a scaled by 1/" + this.scaling.x);
                        }
                        if (this.scaling.y != 1.0f) {
                            System.out.println("supercell found; b scaled by 1/" + this.scaling.y);
                        }
                        if (this.scaling.z != 1.0f) {
                            System.out.println("supercell found; c scaled by 1/" + this.scaling.z);
                        }
                    }
                }
            }
            n = bsPoints.cardinality();
            this.bsAtoms = new BS();
            SGAtom[] newAtoms = new SGAtom[n];
            int p = 0;
            int i2 = bsPoints.nextSetBit(0);
            while (i2 >= 0) {
                SGAtom a = this.atoms[i2];
                newAtoms[p++] = a;
                if (this.isSupercell) {
                    a.setT(this.toFractional(this.cartesians[a.index], this.uc));
                    this.uc.unitize(a);
                }
                this.bsAtoms.set(this.atoms[i2].index);
                i2 = bsPoints.nextSetBit(i2 + 1);
            }
            this.atoms = newAtoms;
            this.nAtoms = n;
            bsPoints.clearAll();
            bsPoints.setBits(0, this.nAtoms);
            this.bsPoints0 = BS.copy(bsPoints);
            BS temp1 = BS.newN(OP_COUNT);
            BS targeted = BS.newN(this.nAtoms);
            bsOps.setBits(1, this.sg == null ? OP_COUNT : this.sg.getOperationCount());
            if (this.nAtoms == 0) {
                bsGroups.clearBits(1, GROUP_COUNT);
                bsOps.clearAll();
            }
            BS uncheckedOps = BS.newN(OP_COUNT);
            BS opsChecked = BS.newN(OP_COUNT);
            opsChecked.set(0);
            boolean hasC1 = false;
            int iop = bsOps.nextSetBit(1);
            while (iop > 0 && !bsGroups.isEmpty()) {
                SymmetryOperation op;
                SymmetryOperation symmetryOperation = op = this.sg == null ? SpaceGroupFinder.getOp(iop) : (SymmetryOperation)this.sg.getOperation(iop);
                if (this.sg == null) {
                    System.out.println("\nChecking operation " + iop + " " + opXYZ[iop]);
                    System.out.println("bsGroups = " + bsGroups);
                    System.out.println("bsOps = " + bsOps);
                    ++nChecked;
                }
                boolean isOK = true;
                bsPoints.clearAll();
                bsPoints.or(this.bsPoints0);
                targeted.clearAll();
                boolean allInvariant = true;
                int i3 = bsPoints.nextSetBit(0);
                while (i3 >= 0) {
                    bsPoints.clear(i3);
                    int j = this.findEquiv(this.uc, iop, op, i3, bsPoints, this.pTemp, true);
                    if (j < 0 && this.sg == null) {
                        System.out.println("failed op " + iop + " for atom " + i3 + " " + this.atoms[i3].name + " " + this.atoms[i3] + " looking for " + this.pTemp + "\n" + op);
                        isOK = false;
                        break;
                    }
                    if (j >= 0 && i3 != j) {
                        allInvariant = false;
                        targeted.set(j);
                    }
                    i3 = bsPoints.nextSetBit(i3 + 1);
                }
                if (this.sg == null) {
                    int i4;
                    BS myGroups = bsOpGroups[iop];
                    bsOps.clear(iop);
                    opsChecked.set(iop);
                    if (isOK) {
                        if (iop == 1) {
                            hasC1 = true;
                        }
                        this.targets.or(targeted);
                        if (!allInvariant) {
                            bsGroups.and(myGroups);
                            temp1.setBits(1, OP_COUNT);
                            i4 = bsGroups.nextSetBit(0);
                            while (i4 >= 0) {
                                temp1.and(bsGroupOps[i4]);
                                i4 = bsGroups.nextSetBit(i4 + 1);
                            }
                            uncheckedOps.or(temp1);
                            bsOps.andNot(temp1);
                        }
                    } else {
                        bsGroups.andNot(myGroups);
                        temp1.clearAll();
                        i4 = bsGroups.nextSetBit(0);
                        while (i4 >= 0) {
                            temp1.or(bsGroupOps[i4]);
                            i4 = bsGroups.nextSetBit(i4 + 1);
                        }
                        bsOps.and(temp1);
                    }
                } else {
                    this.targets.or(targeted);
                }
                iop = bsOps.nextSetBit(iop + 1);
            }
            if (this.sg == null) {
                n = bsGroups.cardinality();
                if (n == 0) {
                    bsGroups.set(hasC1 ? 1 : 0);
                    n = 1;
                    if (hasC1 && !this.asString) {
                        uncheckedOps.clearAll();
                        uncheckedOps.set(1);
                        opsChecked.clearAll();
                        this.targets.clearAll();
                        bsPoints.or(this.bsPoints0);
                    }
                }
                this.isg = bsGroups.nextSetBit(0);
                if (n == 1) {
                    if (this.isg > 0) {
                        opsChecked.and(bsGroupOps[this.isg]);
                        uncheckedOps.and(bsGroupOps[this.isg]);
                        uncheckedOps.andNot(opsChecked);
                        uncheckedOps.or(bsGroupOps[this.isg]);
                        uncheckedOps.clear(0);
                        bsPoints.or(this.bsPoints0);
                        bsPoints.andNot(this.targets);
                        if (!this.checkBasis(this.uc, uncheckedOps, bsPoints, this.targets)) {
                            this.isg = 0;
                        }
                    }
                    if (this.isg == 0) {
                        this.targets.clearAll();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            bsGroups.clearAll();
        }
        if (this.sg == null) {
            System.out.println("checked " + nChecked + " operations; now " + n + " " + bsGroups + " " + bsOps);
            int i = bsGroups.nextSetBit(0);
            while (i >= 0) {
                System.out.println("SpaceGroupFinder found " + SpaceGroup.nameToGroup.get(groupNames[i]));
                i = bsGroups.nextSetBit(i + 1);
            }
            if (n != 1) {
                this.isg = bsGroups.length() - 1;
                if (this.isg < 0) {
                    return null;
                }
            }
            this.sg = SpaceGroup.nameToGroup.get(PT.trim(groupNames[this.isg], "0"));
        }
        return this.sg;
    }

    private static Symmetry setSpaceGroupAndUnitCell(SpaceGroup sg, float[] params, T3[] oabc, boolean allowSame) {
        Symmetry sym = new Symmetry();
        sym.setSpaceGroupTo(sg);
        if (oabc == null) {
            float[] newParams = new float[6];
            if (!UnitCell.createCompatibleUnitCell(sg, params, newParams, allowSame)) {
                newParams = params;
            }
            sym.setUnitCellFromParams(newParams, false, Float.NaN);
        } else {
            sym.getUnitCell(oabc, false, "modelkit");
        }
        return sym;
    }

    private void removeDuplicates(BS bs) {
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            SGAtom a = this.atoms[i];
            int j = bs.nextSetBit(0);
            while (j < i) {
                SGAtom b = this.atoms[j];
                if (a.typeAndOcc == b.typeAndOcc && a.distanceSquared(b) < 1.96E-6f) {
                    bs.clear(i);
                    break;
                }
                j = bs.nextSetBit(j + 1);
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    private void dumpBasis(BS ops, BS bs1, BS bsPoints) {
    }

    private boolean checkBasis(SymmetryInterface uc, BS uncheckedOps, BS bsPoints, BS targets) {
        int n = uncheckedOps.cardinality();
        if (n == 0) {
            return true;
        }
        BS bs = new BS();
        bs.or(bsPoints);
        System.out.println("finishing check for basis for " + n + " operations");
        int iop = uncheckedOps.nextSetBit(0);
        while (iop >= 0) {
            bs.or(bsPoints);
            SymmetryOperation op = SpaceGroupFinder.getOp(iop);
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                int j = this.findEquiv(uc, -1, op, i, bs, this.pTemp, false);
                if (j < 0) {
                    return false;
                }
                if (i != j) {
                    j = Math.max(i, j);
                    targets.set(j);
                    bs.clear(j);
                }
                i = bs.nextSetBit(i + 1);
            }
            iop = uncheckedOps.nextSetBit(iop + 1);
        }
        return true;
    }

    private void filterGroups(BS bsGroups, float[] params) {
        int i;
        int i0;
        block13: {
            boolean isOrtho = false;
            boolean isTet = false;
            boolean isTri = false;
            boolean isRhombo = false;
            boolean isCubic = false;
            boolean absame = this.approx001(params[0] - params[1]);
            boolean bcsame = this.approx001(params[1] - params[2]);
            if (params[3] == 90.0f) {
                if (params[4] == 90.0f) {
                    if (absame && params[0] != params[1]) {
                        System.out.println("OHOH");
                    }
                    boolean bl = isTri = absame && this.approx001(params[5] - 120.0f);
                    if (params[5] == 90.0f) {
                        isCubic = absame && params[1] == params[2];
                        isTet = !isCubic && absame;
                        isOrtho = !isCubic && !isTet;
                    }
                }
            } else if (absame && bcsame && this.approx001(params[3] - params[4]) && this.approx001(params[4] - params[5])) {
                isRhombo = true;
            }
            bsGroups.setBits(0, 2);
            i0 = 2;
            i = 2;
            i = SpaceGroupFinder.scanTo(i, "16");
            if (!isOrtho && !isTet && !isTri && !isRhombo && !isCubic) break block13;
            i = SpaceGroupFinder.scanTo(i, "75");
            if (!isTet && !isTri && !isRhombo && !isCubic) break block13;
            i = SpaceGroupFinder.scanTo(i, "143");
            if (!isTri && !isRhombo && !isCubic) break block13;
            i0 = i;
            while (true) {
                block15: {
                    String g;
                    block14: {
                        if ((g = groupNames[i]).indexOf(":r") < 0) break block14;
                        if (!isRhombo) break block15;
                        bsGroups.set(i);
                    }
                    if (g.startsWith("195")) {
                        if (!isRhombo) break;
                        return;
                    }
                }
                ++i;
            }
            if (isCubic) {
                bsGroups.setBits(2, i0);
                i0 = i;
                i = GROUP_COUNT;
            }
        }
        bsGroups.setBits(i0, i);
    }

    private boolean approx001(float d) {
        return Math.abs(d) < 0.001f;
    }

    private static int scanTo(int i, String num) {
        num = "000" + num;
        num = num.substring(num.length() - 3);
        while (!groupNames[i].startsWith(num)) {
            ++i;
        }
        return i;
    }

    private Object getGroupsWithOps(String xyzList, float[] unitCellParams, boolean isAssign) {
        int i;
        BS groups = new BS();
        if (unitCellParams == null) {
            groups.setBits(0, GROUP_COUNT);
        } else {
            this.filterGroups(groups, unitCellParams);
        }
        SpaceGroup sgo = null;
        if (!SpaceGroup.isXYZList(xyzList)) {
            sgo = SpaceGroup.determineSpaceGroupNA(xyzList, unitCellParams);
            if (sgo == null) {
                return null;
            }
            sgo.checkHallOperators();
            String tableNo = "00" + sgo.jmolId;
            int pt = tableNo.indexOf(":");
            tableNo = tableNo.substring((pt < 0 ? tableNo.length() : pt) - 3);
            for (int i2 = 0; i2 < GROUP_COUNT; ++i2) {
                if (!groupNames[i2].equals(tableNo)) continue;
                return groups.get(i2) ? sgo : null;
            }
            return null;
        }
        boolean isEqual = xyzList.indexOf("&") < 0 || isAssign;
        String[] ops = PT.split(PT.trim(xyzList.trim().replace('&', ';'), ";="), ";");
        int j = ops.length;
        block1: while (--j >= 0) {
            String xyz = ops[j];
            if (xyz == null) {
                return "?" + ops[j] + "?";
            }
            xyz = SymmetryOperation.getJmolCanonicalXYZ(xyz);
            i = opXYZ.length;
            while (--i >= 0) {
                if (opXYZ[i].equals(xyz)) {
                    groups.and(bsOpGroups[i]);
                    continue block1;
                }
                if (i != 0) continue;
                groups.clearAll();
            }
        }
        if (groups.isEmpty()) {
            return isAssign ? SpaceGroup.createSpaceGroupN(xyzList, true) : null;
        }
        if (isEqual) {
            int n = ops.length;
            int i3 = groups.nextSetBit(0);
            while (i3 >= 0) {
                if (bsGroupOps[i3].cardinality() == n) {
                    if (isAssign) {
                        return SpaceGroup.createSpaceGroupN(groupNames[i3], true);
                    }
                    return SpaceGroup.getInfo(null, groupNames[i3], unitCellParams, true, false);
                }
                i3 = groups.nextSetBit(i3 + 1);
            }
            return null;
        }
        String[] ret = new String[groups.cardinality()];
        int p = 0;
        i = groups.nextSetBit(0);
        while (i >= 0) {
            ret[p++] = groupNames[i];
            i = groups.nextSetBit(i + 1);
        }
        return ret;
    }

    P3 toFractional(Atom a, SymmetryInterface uc) {
        this.pTemp.setT(a);
        uc.toFractional(this.pTemp, false);
        return this.pTemp;
    }

    private static SymmetryOperation getOp(int iop) {
        SymmetryOperation op = ops[iop];
        if (op == null) {
            SpaceGroupFinder.ops[iop] = op = new SymmetryOperation(null, iop, false);
            op.setMatrixFromXYZ(opXYZ[iop], 0, false);
            op.doFinalize();
        }
        return op;
    }

    public Symmetry checkSupercell(Viewer vwr, Symmetry uc, BS bsPoints, int abc, P3 scaling) {
        int n;
        if (bsPoints.isEmpty()) {
            return uc;
        }
        int minF = Integer.MAX_VALUE;
        int maxF = Integer.MIN_VALUE;
        int[] counts = new int[101];
        int nAtoms = bsPoints.cardinality();
        int i = bsPoints.nextSetBit(0);
        while (i >= 0) {
            SGAtom a = this.atoms[i];
            int type = a.typeAndOcc;
            int j = bsPoints.nextSetBit(0);
            while (j >= 0) {
                block24: {
                    int n2;
                    float f;
                    if (j == i) break block24;
                    SGAtom b = this.atoms[j];
                    if (b.typeAndOcc != type) break block24;
                    this.pTemp.sub2(b, a);
                    switch (abc) {
                        case 1: {
                            f = this.pTemp.x;
                            if (!this.approx0(f) && this.approx0(this.pTemp.y) && this.approx0(this.pTemp.z)) break;
                            break block24;
                        }
                        case 2: {
                            f = this.pTemp.y;
                            if (!this.approx0(f) && this.approx0(this.pTemp.x) && this.approx0(this.pTemp.z)) break;
                            break block24;
                        }
                        default: {
                            f = this.pTemp.z;
                            if (this.approx0(f) || !this.approx0(this.pTemp.x) || !this.approx0(this.pTemp.y)) break block24;
                        }
                    }
                    if ((n2 = this.approxInt(1.0f / f)) != 0 && (double)(nAtoms / n2) == 1.0 * (double)nAtoms / (double)n2 && n2 <= 100) {
                        if (n2 > maxF) {
                            maxF = n2;
                        }
                        if (n2 < minF) {
                            minF = n2;
                        }
                        int n3 = n2;
                        counts[n3] = counts[n3] + 1;
                    }
                }
                j = bsPoints.nextSetBit(j + 1);
            }
            i = bsPoints.nextSetBit(i + 1);
        }
        for (n = maxF; n >= minF && (counts[n] <= 0 || counts[n] != (n - 1) * nAtoms / n); --n) {
        }
        if (n < minF) {
            return uc;
        }
        T3[] oabc = uc.getUnitCellVectors();
        oabc[abc].scale(1.0f / (float)n);
        switch (abc) {
            case 1: {
                scaling.x = n;
                break;
            }
            case 2: {
                scaling.y = n;
                break;
            }
            case 3: {
                scaling.z = n;
            }
        }
        uc = new Symmetry();
        uc.getUnitCell(oabc, false, "scaled");
        int f = 0;
        int i2 = bsPoints.nextSetBit(0);
        while (i2 >= 0) {
            switch (abc) {
                case 1: {
                    f = this.approxInt((float)n * this.atoms[i2].x);
                    break;
                }
                case 2: {
                    f = this.approxInt((float)n * this.atoms[i2].y);
                    break;
                }
                case 3: {
                    f = this.approxInt((float)n * this.atoms[i2].z);
                }
            }
            if (f != 0) {
                this.atoms[i2] = null;
                bsPoints.clear(i2);
            }
            i2 = bsPoints.nextSetBit(i2 + 1);
        }
        nAtoms = bsPoints.cardinality();
        return uc;
    }

    private boolean approx0(float f) {
        return Math.abs(f) < this.slop;
    }

    private int approxInt(float finv) {
        int i = (int)(finv + this.slop);
        return this.approx0(finv - (float)i) ? i : 0;
    }

    private int findEquiv(SymmetryInterface uc, int iop, SymmetryOperation op, int i, BS bsPoints, P3 pt, boolean andClear) {
        SGAtom a = this.atoms[i];
        pt.setT(a);
        op.rotTrans(pt);
        uc.unitize(pt);
        if (pt.distanceSquared(a) == 0.0f) {
            return i;
        }
        int testiop = -99;
        int type = a.typeAndOcc;
        String name = a.name;
        int j = this.nAtoms;
        while (--j >= 0) {
            float d;
            SGAtom b = this.atoms[j];
            if (b.typeAndOcc != type || !((d = b.distance(pt)) * d < 1.96E-6f) && (!((1.0f - d) * (1.0f - d) < 1.96E-6f) || !this.latticeShift(pt, b))) continue;
            if (andClear && i != (j = Math.max(i, j))) {
                bsPoints.clear(j);
            }
            return j;
        }
        return -1;
    }

    private boolean latticeShift(P3 a, P3 b) {
        boolean is1;
        boolean bl = is1 = this.approx0(Math.abs(a.x - b.x) - 1.0f) || this.approx0(Math.abs(a.y - b.y) - 1.0f) || this.approx0(Math.abs(a.z - b.z) - 1.0f);
        if (is1) {
            // empty if block
        }
        return is1;
    }

    public static void main(String[] args) {
        if (SpaceGroupFinder.loadData(null, new SpaceGroupFinder())) {
            System.out.println("OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadData(Viewer vwr, Object me) {
        try {
            groupNames = SpaceGroupFinder.getList(vwr, me, null, "sggroups_ordered.txt");
            GROUP_COUNT = groupNames.length;
            opXYZ = SpaceGroupFinder.getList(vwr, me, null, "sgops_ordered.txt");
            OP_COUNT = opXYZ.length;
            String[] map = SpaceGroupFinder.getList(vwr, me, new String[OP_COUNT], "sgmap.txt");
            bsGroupOps = new BS[GROUP_COUNT];
            bsOpGroups = new BS[OP_COUNT];
            for (int j = 0; j < GROUP_COUNT; ++j) {
                SpaceGroupFinder.bsGroupOps[j] = BS.newN(OP_COUNT);
            }
            for (int i = 0; i < OP_COUNT; ++i) {
                String m = map[i];
                int n = m.length();
                SpaceGroupFinder.bsOpGroups[i] = BS.newN(GROUP_COUNT);
                for (int j = 0; j < n; ++j) {
                    if (m.charAt(j) != '1') continue;
                    bsGroupOps[j].set(i);
                    bsOpGroups[i].set(j);
                }
            }
            ops = new SymmetryOperation[OP_COUNT];
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String[] getList(Viewer vwr, Object me, String[] list, String fileName) throws IOException {
        rdr = FileManager.getBufferedReaderForResource(vwr, me, "org/jmol/symmetry/", "sg/" + fileName);
        if (list == null) {
            String line;
            Lst<String> l = new Lst<String>();
            while ((line = rdr.readLine()) != null) {
                if (line.length() <= 0) continue;
                l.addLast(line);
            }
            list = new String[l.size()];
            l.toArray(list);
        } else {
            for (int i = 0; i < list.length; ++i) {
                list[i] = rdr.readLine();
            }
        }
        rdr.close();
        return list;
    }

    static {
        rdr = null;
    }

    private class SGAtom
    extends P3 {
        int typeAndOcc;
        int index;
        String name;

        SGAtom(int type, int index, String name, int occupancy) {
            this.typeAndOcc = type + 1000 * occupancy;
            this.index = index;
            this.name = name;
        }
    }
}

