/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class GCMUtil {
    static final Constructor<AlgorithmParameterSpec> gcmParameterSpec = GCMUtil.getConstructor();

    GCMUtil() {
    }

    static AlgorithmParameterSpec createGCMParameterSpec(final int n, final byte[] byArray) throws Exception {
        if (gcmParameterSpec == null) {
            throw new IllegalStateException();
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<AlgorithmParameterSpec>(){

            @Override
            public AlgorithmParameterSpec run() throws Exception {
                return gcmParameterSpec.newInstance(Integers.valueOf((int)n), byArray);
            }
        });
    }

    static boolean isGCMParameterSpecAvailable() {
        return gcmParameterSpec != null;
    }

    private static Constructor<AlgorithmParameterSpec> getConstructor() {
        return AccessController.doPrivileged(new PrivilegedAction<Constructor<AlgorithmParameterSpec>>(){

            @Override
            public Constructor<AlgorithmParameterSpec> run() {
                try {
                    Class<?> clazz;
                    String string = "javax.crypto.spec.GCMParameterSpec";
                    ClassLoader classLoader = GCMUtil.class.getClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    if ((clazz = classLoader.loadClass(string)) != null && AlgorithmParameterSpec.class.isAssignableFrom(clazz)) {
                        Class<?> clazz2 = clazz;
                        return clazz2.getConstructor(Integer.TYPE, byte[].class);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

