/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kmssdkv2;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.internal.VersionInfo;
import com.amazonaws.encryptionsdk.kms.KmsMethods;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;

public final class KmsMasterKey
extends MasterKey<KmsMasterKey>
implements KmsMethods {
    private static final ApiName API_NAME = ApiName.builder().name(VersionInfo.apiName()).version(VersionInfo.versionNumber()).build();
    private static final Consumer<AwsRequestOverrideConfiguration.Builder> API_NAME_INTERCEPTOR = builder -> builder.addApiName(API_NAME);
    private final Supplier<KmsClient> clientSupplier_;
    private final MasterKeyProvider<KmsMasterKey> sourceProvider_;
    private final String id_;
    private final List<String> grantTokens_ = new ArrayList<String>();

    static KmsMasterKey getInstance(Supplier<KmsClient> clientSupplier, String id, MasterKeyProvider<KmsMasterKey> provider) {
        return new KmsMasterKey(clientSupplier, id, provider);
    }

    private KmsMasterKey(Supplier<KmsClient> clientSupplier, String id, MasterKeyProvider<KmsMasterKey> provider) {
        this.clientSupplier_ = clientSupplier;
        this.id_ = id;
        this.sourceProvider_ = provider;
    }

    @Override
    public String getProviderId() {
        return this.sourceProvider_.getDefaultProviderId();
    }

    @Override
    public String getKeyId() {
        return this.id_;
    }

    @Override
    public DataKey<KmsMasterKey> generateDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext) {
        GenerateDataKeyResponse gdkResponse = this.clientSupplier_.get().generateDataKey((GenerateDataKeyRequest)GenerateDataKeyRequest.builder().overrideConfiguration(API_NAME_INTERCEPTOR).keyId(this.getKeyId()).numberOfBytes(Integer.valueOf(algorithm.getDataKeyLength())).encryptionContext(encryptionContext).grantTokens(this.grantTokens_).build());
        ByteBuffer plaintextBuffer = gdkResponse.plaintext().asByteBuffer();
        if (plaintextBuffer.limit() != algorithm.getDataKeyLength()) {
            throw new IllegalStateException("Received an unexpected number of bytes from KMS");
        }
        byte[] rawKey = new byte[algorithm.getDataKeyLength()];
        plaintextBuffer.get(rawKey);
        ByteBuffer ciphertextBlobBuffer = gdkResponse.ciphertextBlob().asByteBuffer();
        byte[] encryptedKey = new byte[ciphertextBlobBuffer.remaining()];
        ciphertextBlobBuffer.get(encryptedKey);
        String gdkResponseKeyId = gdkResponse.keyId();
        SecretKeySpec key = new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo());
        return new DataKey<KmsMasterKey>(key, encryptedKey, gdkResponseKeyId.getBytes(StandardCharsets.UTF_8), this);
    }

    @Override
    public void setGrantTokens(List<String> grantTokens) {
        this.grantTokens_.clear();
        this.grantTokens_.addAll(grantTokens);
    }

    @Override
    public List<String> getGrantTokens() {
        return this.grantTokens_;
    }

    @Override
    public void addGrantToken(String grantToken) {
        this.grantTokens_.add(grantToken);
    }

    @Override
    public DataKey<KmsMasterKey> encryptDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext, DataKey<?> dataKey) {
        SecretKey key = dataKey.getKey();
        if (!key.getFormat().equals("RAW")) {
            throw new IllegalArgumentException("Only RAW encoded keys are supported");
        }
        try {
            EncryptResponse encryptResponse = this.clientSupplier_.get().encrypt((EncryptRequest)EncryptRequest.builder().overrideConfiguration(API_NAME_INTERCEPTOR).keyId(this.id_).plaintext(SdkBytes.fromByteArray((byte[])key.getEncoded())).encryptionContext(encryptionContext).grantTokens(this.grantTokens_).build());
            ByteBuffer ciphertextBlobBuffer = encryptResponse.ciphertextBlob().asByteBuffer();
            byte[] edk = new byte[ciphertextBlobBuffer.remaining()];
            ciphertextBlobBuffer.get(edk);
            String encryptResultKeyId = encryptResponse.keyId();
            return new DataKey<KmsMasterKey>(dataKey.getKey(), edk, encryptResultKeyId.getBytes(StandardCharsets.UTF_8), this);
        }
        catch (AwsServiceException asex) {
            throw new AwsCryptoException(asex);
        }
    }

    @Override
    public DataKey<KmsMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws UnsupportedProviderException, AwsCryptoException {
        ArrayList<AwsServiceException> exceptions = new ArrayList<AwsServiceException>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            try {
                String edkKeyId = new String(encryptedDataKey.getProviderInformation(), StandardCharsets.UTF_8);
                if (!edkKeyId.equals(this.id_)) continue;
                DecryptResponse decryptResponse = this.clientSupplier_.get().decrypt((DecryptRequest)DecryptRequest.builder().overrideConfiguration(API_NAME_INTERCEPTOR).ciphertextBlob(SdkBytes.fromByteArray((byte[])encryptedDataKey.getEncryptedDataKey())).encryptionContext(encryptionContext).grantTokens(this.grantTokens_).keyId(edkKeyId).build());
                String decryptResponseKeyId = decryptResponse.keyId();
                if (decryptResponseKeyId == null) {
                    throw new IllegalStateException("Received an empty keyId from KMS");
                }
                if (!decryptResponseKeyId.equals(this.id_)) continue;
                ByteBuffer plaintextBuffer = decryptResponse.plaintext().asByteBuffer();
                if (plaintextBuffer.limit() != algorithm.getDataKeyLength()) {
                    throw new IllegalStateException("Received an unexpected number of bytes from KMS");
                }
                byte[] rawKey = new byte[algorithm.getDataKeyLength()];
                plaintextBuffer.get(rawKey);
                return new DataKey<KmsMasterKey>(new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo()), encryptedDataKey.getEncryptedDataKey(), encryptedDataKey.getProviderInformation(), this);
            }
            catch (AwsServiceException awsex) {
                exceptions.add(awsex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }
}

