"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addClickToMetric = addClickToMetric;
exports.addRequestToMetric = addRequestToMetric;
exports.getMetrics = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("./constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const time2CountWin = new Map();
function addClickToMetric(element, counter = 'count') {
  // remove outdated key-value pairs
  trim();
  const timeKey = getKey(Date.now());
  const rollingCounter = time2CountWin.get(timeKey) || _lodash.default.cloneDeep(_constants.DEFAULT_ROLLING_COUNTER);
  const key = `click.${element}.${counter}`;
  _lodash.default.set(rollingCounter, key, _lodash.default.get(rollingCounter, key, 0) + 1);
  if (counter === 'count') {
    const basicCounterKey = `click.${element}.total`;
    _lodash.default.set(_constants.GLOBAL_BASIC_COUNTER, basicCounterKey, _lodash.default.get(_constants.GLOBAL_BASIC_COUNTER, basicCounterKey, 0) + 1);
  }
  time2CountWin.set(timeKey, rollingCounter);
}
function addRequestToMetric(component, request, counterNameOrError) {
  const counter = typeof counterNameOrError === 'object' ? checkErrorType(counterNameOrError) : counterNameOrError;

  // remove outdated key-value pairs
  trim();
  const timeKey = getKey(Date.now());
  const rollingCounter = time2CountWin.get(timeKey) || _lodash.default.cloneDeep(_constants.DEFAULT_ROLLING_COUNTER);
  rollingCounter[component][request][counter]++;
  if (counter === 'count') {
    _constants.GLOBAL_BASIC_COUNTER[component][request].total++;
  }
  time2CountWin.set(timeKey, rollingCounter);
}
const getMetrics = () => {
  const preTimeKey = getPreKey(Date.now());
  const rollingCounters = time2CountWin.get(preTimeKey);
  return buildMetrics(rollingCounters);
};
exports.getMetrics = getMetrics;
const checkErrorType = error => {
  if (error.statusCode && Math.floor(error.statusCode / 100) === 4) {
    return 'user_error';
  } else {
    return 'system_error';
  }
};
const trim = () => {
  if (time2CountWin.size > _constants.CAPACITY) {
    const currentKey = getKey(Date.now() - _constants.WINDOW * _constants.MILLIS_MULTIPLIER);
    time2CountWin.forEach((_value, key, map) => {
      if (key < currentKey) {
        map.delete(key);
      }
    });
  }
};
const getKey = milliseconds => {
  return Math.floor(milliseconds / _constants.MILLIS_MULTIPLIER / _constants.INTERVAL);
};
const getPreKey = milliseconds => {
  return getKey(milliseconds) - 1;
};
const isComponent = arg => {
  return _constants.COMPONENTS.includes(arg);
};
const buildMetrics = rollingCounters => {
  if (!rollingCounters) {
    rollingCounters = _constants.DEFAULT_ROLLING_COUNTER;
  }
  const basicMetrics = _lodash.default.merge(rollingCounters, _constants.GLOBAL_BASIC_COUNTER);
  const overallActionMetrics = {
    request_total: 0,
    request_count: 0,
    success_count: 0,
    failed_request_count_system_error: 0,
    failed_request_count_user_error: 0
  };
  Object.keys(basicMetrics).forEach(key => {
    if (isComponent(key)) {
      for (const counter of Object.values(basicMetrics[key])) {
        overallActionMetrics.request_count += (counter === null || counter === void 0 ? void 0 : counter.count) || 0;
        overallActionMetrics.request_total += (counter === null || counter === void 0 ? void 0 : counter.total) || 0;
        overallActionMetrics.failed_request_count_system_error += (counter === null || counter === void 0 ? void 0 : counter.system_error) || 0;
        overallActionMetrics.failed_request_count_user_error += (counter === null || counter === void 0 ? void 0 : counter.user_error) || 0;
      }
    }
  });
  overallActionMetrics.success_count = overallActionMetrics.request_count - (overallActionMetrics.failed_request_count_system_error + overallActionMetrics.failed_request_count_user_error);
  return {
    ...basicMetrics,
    ...overallActionMetrics
  };
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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