/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.DBUtils;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.Removable;

public class ClusterManagerEventMetricsSnapshot
implements Removable {
    private static final Logger LOG = LogManager.getLogger(ClusterManagerEventMetricsSnapshot.class);
    private final DSLContext create;
    private final Long windowStartTime;
    private final String tableName;
    private static final Long EXPIRE_AFTER = 1200000L;
    private List<Field<?>> columns;

    public ClusterManagerEventMetricsSnapshot(Connection conn, Long windowStartTime) {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.windowStartTime = windowStartTime;
        this.tableName = "cluster_manager_event_" + windowStartTime;
        this.columns = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_INSERT_ORDER.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_PRIORITY.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_TYPE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_METADATA.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
            }
        };
        this.create.createTable(this.tableName).columns(this.columns).execute();
    }

    @Override
    public void remove() throws Exception {
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public void rolloverInflightRequests(ClusterManagerEventMetricsSnapshot prevSnap) {
        this.create.insertInto(DSL.table((String)this.tableName)).select(prevSnap.fetchInflightRequests()).execute();
        LOG.debug("Inflight shard requests");
        LOG.debug(() -> this.fetchAll());
    }

    private SelectHavingStep<Record> fetchInflightRequests() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_INSERT_ORDER.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_PRIORITY.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_TYPE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_METADATA.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
            }
        };
        return this.create.select((Collection)fields).from(this.groupByInsertOrder()).where(DSL.field((String)Fields.ST.toString()).isNotNull().and(DSL.field((String)Fields.ET.toString()).isNull()).and(DSL.field((String)Fields.ST.toString()).gt((Object)(this.windowStartTime - EXPIRE_AFTER))));
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    public BatchBindStep startBatchPut() {
        ArrayList<Object> dummyValues = new ArrayList<Object>();
        for (int i = 0; i < this.columns.size(); ++i) {
            dummyValues.add(null);
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    public Result<Record> fetchQueueAndRunTime() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_INSERT_ORDER.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_PRIORITY.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_TYPE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_METADATA.toString()), String.class));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString(), "max")));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString(), "max")));
            }
        };
        ArrayList groupByFields = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_INSERT_ORDER.toString()), String.class));
            }
        };
        return this.create.select((Collection)fields).from(this.fetchRunTimeHelper()).groupBy((Collection)groupByFields).fetch();
    }

    private SelectHavingStep<Record> fetchRunTimeHelper() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_INSERT_ORDER.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_PRIORITY.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_TYPE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_METADATA.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString()), String.class));
                this.add(DSL.field((String)Fields.ET.toString()).minus(DSL.field((String)Fields.ST.toString())).as(DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_RUN_TIME.toString())));
            }
        };
        return this.create.select((Collection)fields).from(this.groupByInsertOrderAndAutoFillEndTime()).where(DSL.field((String)Fields.ET.toString()).isNotNull().and(DSL.field((String)Fields.ST.toString()).isNotNull()));
    }

    private SelectHavingStep<Record> groupByInsertOrderAndAutoFillEndTime() {
        Long endTime = this.windowStartTime + 5000L;
        ArrayList<SelectField<?>> fields = this.getGroupByInsertOrderSelectFields();
        fields.add((SelectField<?>)DSL.least((Object)DSL.coalesce((Field)DSL.max((Field)DSL.field((String)Fields.ET.toString(), Long.class)), (Object)endTime), (Object[])new Serializable[]{endTime}).as(DSL.name((String)Fields.ET.toString())));
        ArrayList groupByInsertOrder = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_INSERT_ORDER.toString()), String.class));
            }
        };
        return this.create.select(fields).from((TableLike)DSL.table((String)this.tableName)).groupBy((Collection)groupByInsertOrder);
    }

    private SelectHavingStep<Record> groupByInsertOrder() {
        ArrayList<SelectField<?>> fields = this.getGroupByInsertOrderSelectFields();
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.ET.toString(), Long.class)).as(DSL.name((String)Fields.ET.toString())));
        fields.add((SelectField<?>)DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
        ArrayList groupByInsertOrder = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_INSERT_ORDER.toString()), String.class));
            }
        };
        return this.create.select(fields).from((TableLike)DSL.table((String)this.tableName)).groupBy((Collection)groupByInsertOrder);
    }

    private ArrayList<SelectField<?>> getGroupByInsertOrderSelectFields() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_INSERT_ORDER.toString()), String.class));
                this.add(DSL.max((Field)DSL.field((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_TYPE.toString())).as(DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_TYPE.toString())));
                this.add(DSL.max((Field)DSL.field((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_METADATA.toString())).as(DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_METADATA.toString())));
                this.add(DSL.max((Field)DSL.field((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString())).as(DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString())));
                this.add(DSL.max((Field)DSL.field((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_PRIORITY.toString())).as(DSL.name((String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_PRIORITY.toString())));
                this.add(DSL.max((Field)DSL.field((String)Fields.ST.toString(), Long.class)).as(DSL.name((String)Fields.ST.toString())));
            }
        };
        return fields;
    }

    public static enum Fields {
        TID("tid"),
        IS_CURRENT("isCurrent"),
        OLD_START("oldStart"),
        ST("st"),
        ET("et"),
        LAT("lat");

        private final String fieldValue;

        private Fields(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        public String toString() {
            return this.fieldValue;
        }
    }
}

