/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AddressTransferStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressTransfer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddressTransfer> {
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(AddressTransfer.getter(AddressTransfer::publicIp)).setter(AddressTransfer.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(AddressTransfer.getter(AddressTransfer::allocationId)).setter(AddressTransfer.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> TRANSFER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferAccountId").getter(AddressTransfer.getter(AddressTransfer::transferAccountId)).setter(AddressTransfer.setter(Builder::transferAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferAccountId").unmarshallLocationName("transferAccountId").build()}).build();
    private static final SdkField<Instant> TRANSFER_OFFER_EXPIRATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TransferOfferExpirationTimestamp").getter(AddressTransfer.getter(AddressTransfer::transferOfferExpirationTimestamp)).setter(AddressTransfer.setter(Builder::transferOfferExpirationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferOfferExpirationTimestamp").unmarshallLocationName("transferOfferExpirationTimestamp").build()}).build();
    private static final SdkField<Instant> TRANSFER_OFFER_ACCEPTED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TransferOfferAcceptedTimestamp").getter(AddressTransfer.getter(AddressTransfer::transferOfferAcceptedTimestamp)).setter(AddressTransfer.setter(Builder::transferOfferAcceptedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferOfferAcceptedTimestamp").unmarshallLocationName("transferOfferAcceptedTimestamp").build()}).build();
    private static final SdkField<String> ADDRESS_TRANSFER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressTransferStatus").getter(AddressTransfer.getter(AddressTransfer::addressTransferStatusAsString)).setter(AddressTransfer.setter(Builder::addressTransferStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressTransferStatus").unmarshallLocationName("addressTransferStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IP_FIELD, ALLOCATION_ID_FIELD, TRANSFER_ACCOUNT_ID_FIELD, TRANSFER_OFFER_EXPIRATION_TIMESTAMP_FIELD, TRANSFER_OFFER_ACCEPTED_TIMESTAMP_FIELD, ADDRESS_TRANSFER_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String publicIp;
    private final String allocationId;
    private final String transferAccountId;
    private final Instant transferOfferExpirationTimestamp;
    private final Instant transferOfferAcceptedTimestamp;
    private final String addressTransferStatus;

    private AddressTransfer(BuilderImpl builder) {
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.transferAccountId = builder.transferAccountId;
        this.transferOfferExpirationTimestamp = builder.transferOfferExpirationTimestamp;
        this.transferOfferAcceptedTimestamp = builder.transferOfferAcceptedTimestamp;
        this.addressTransferStatus = builder.addressTransferStatus;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String transferAccountId() {
        return this.transferAccountId;
    }

    public final Instant transferOfferExpirationTimestamp() {
        return this.transferOfferExpirationTimestamp;
    }

    public final Instant transferOfferAcceptedTimestamp() {
        return this.transferOfferAcceptedTimestamp;
    }

    public final AddressTransferStatus addressTransferStatus() {
        return AddressTransferStatus.fromValue(this.addressTransferStatus);
    }

    public final String addressTransferStatusAsString() {
        return this.addressTransferStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferOfferExpirationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferOfferAcceptedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressTransferStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressTransfer)) {
            return false;
        }
        AddressTransfer other = (AddressTransfer)obj;
        return Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.transferAccountId(), other.transferAccountId()) && Objects.equals(this.transferOfferExpirationTimestamp(), other.transferOfferExpirationTimestamp()) && Objects.equals(this.transferOfferAcceptedTimestamp(), other.transferOfferAcceptedTimestamp()) && Objects.equals(this.addressTransferStatusAsString(), other.addressTransferStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AddressTransfer").add("PublicIp", (Object)this.publicIp()).add("AllocationId", (Object)this.allocationId()).add("TransferAccountId", (Object)this.transferAccountId()).add("TransferOfferExpirationTimestamp", (Object)this.transferOfferExpirationTimestamp()).add("TransferOfferAcceptedTimestamp", (Object)this.transferOfferAcceptedTimestamp()).add("AddressTransferStatus", (Object)this.addressTransferStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "TransferAccountId": {
                return Optional.ofNullable(clazz.cast(this.transferAccountId()));
            }
            case "TransferOfferExpirationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.transferOfferExpirationTimestamp()));
            }
            case "TransferOfferAcceptedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.transferOfferAcceptedTimestamp()));
            }
            case "AddressTransferStatus": {
                return Optional.ofNullable(clazz.cast(this.addressTransferStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddressTransfer, T> g) {
        return obj -> g.apply((AddressTransfer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String publicIp;
        private String allocationId;
        private String transferAccountId;
        private Instant transferOfferExpirationTimestamp;
        private Instant transferOfferAcceptedTimestamp;
        private String addressTransferStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressTransfer model) {
            this.publicIp(model.publicIp);
            this.allocationId(model.allocationId);
            this.transferAccountId(model.transferAccountId);
            this.transferOfferExpirationTimestamp(model.transferOfferExpirationTimestamp);
            this.transferOfferAcceptedTimestamp(model.transferOfferAcceptedTimestamp);
            this.addressTransferStatus(model.addressTransferStatus);
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getTransferAccountId() {
            return this.transferAccountId;
        }

        public final void setTransferAccountId(String transferAccountId) {
            this.transferAccountId = transferAccountId;
        }

        @Override
        public final Builder transferAccountId(String transferAccountId) {
            this.transferAccountId = transferAccountId;
            return this;
        }

        public final Instant getTransferOfferExpirationTimestamp() {
            return this.transferOfferExpirationTimestamp;
        }

        public final void setTransferOfferExpirationTimestamp(Instant transferOfferExpirationTimestamp) {
            this.transferOfferExpirationTimestamp = transferOfferExpirationTimestamp;
        }

        @Override
        public final Builder transferOfferExpirationTimestamp(Instant transferOfferExpirationTimestamp) {
            this.transferOfferExpirationTimestamp = transferOfferExpirationTimestamp;
            return this;
        }

        public final Instant getTransferOfferAcceptedTimestamp() {
            return this.transferOfferAcceptedTimestamp;
        }

        public final void setTransferOfferAcceptedTimestamp(Instant transferOfferAcceptedTimestamp) {
            this.transferOfferAcceptedTimestamp = transferOfferAcceptedTimestamp;
        }

        @Override
        public final Builder transferOfferAcceptedTimestamp(Instant transferOfferAcceptedTimestamp) {
            this.transferOfferAcceptedTimestamp = transferOfferAcceptedTimestamp;
            return this;
        }

        public final String getAddressTransferStatus() {
            return this.addressTransferStatus;
        }

        public final void setAddressTransferStatus(String addressTransferStatus) {
            this.addressTransferStatus = addressTransferStatus;
        }

        @Override
        public final Builder addressTransferStatus(String addressTransferStatus) {
            this.addressTransferStatus = addressTransferStatus;
            return this;
        }

        @Override
        public final Builder addressTransferStatus(AddressTransferStatus addressTransferStatus) {
            this.addressTransferStatus(addressTransferStatus == null ? null : addressTransferStatus.toString());
            return this;
        }

        public AddressTransfer build() {
            return new AddressTransfer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddressTransfer> {
        public Builder publicIp(String var1);

        public Builder allocationId(String var1);

        public Builder transferAccountId(String var1);

        public Builder transferOfferExpirationTimestamp(Instant var1);

        public Builder transferOfferAcceptedTimestamp(Instant var1);

        public Builder addressTransferStatus(String var1);

        public Builder addressTransferStatus(AddressTransferStatus var1);
    }
}

