/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.spring.stat;

import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.alibaba.druid.support.spring.stat.SpringStatUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class SpringStatManager {
    public static final String SYS_PROP_INSTANCES = "druid.spring.springStat";
    private static final SpringStatManager instance = new SpringStatManager();
    private Set<Object> springStatSet = null;

    public static SpringStatManager getInstance() {
        return instance;
    }

    public Set<Object> getSpringStatSet() {
        if (this.springStatSet == null) {
            this.springStatSet = DruidDataSourceStatManager.isRegisterToSystemProperty() ? SpringStatManager.getSpringStatSetFromSysProperty() : new CopyOnWriteArraySet<Object>();
        }
        return this.springStatSet;
    }

    public void addSpringStat(Object springStat) {
        this.getSpringStatSet().add(springStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Object> getSpringStatSetFromSysProperty() {
        Properties properties = System.getProperties();
        CopyOnWriteArraySet webAppStats = (CopyOnWriteArraySet)properties.get(SYS_PROP_INSTANCES);
        if (webAppStats == null) {
            Properties properties2 = properties;
            synchronized (properties2) {
                webAppStats = (Set)properties.get(SYS_PROP_INSTANCES);
                if (webAppStats == null) {
                    webAppStats = new CopyOnWriteArraySet();
                    properties.put(SYS_PROP_INSTANCES, webAppStats);
                }
            }
        }
        return webAppStats;
    }

    public List<Map<String, Object>> getMethodStatData() {
        Set<Object> stats = this.getSpringStatSet();
        ArrayList<Map<String, Object>> allMethodStatDataList = new ArrayList<Map<String, Object>>();
        for (Object stat : stats) {
            List<Map<String, Object>> methodStatDataList = SpringStatUtils.getMethodStatDataList(stat);
            allMethodStatDataList.addAll(methodStatDataList);
        }
        return allMethodStatDataList;
    }

    public Map<String, Object> getMethodStatData(String clazz, String method) {
        Set<Object> stats = this.getSpringStatSet();
        for (Object stat : stats) {
            Map<String, Object> statData = SpringStatUtils.getMethodStatData(stat, clazz, method);
            if (statData == null) continue;
            return statData;
        }
        return null;
    }

    public void resetStat() {
        Set<Object> stats = this.getSpringStatSet();
        for (Object stat : stats) {
            SpringStatUtils.reset(stat);
        }
    }
}

