/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.ObjectSupport;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509CRL;
import org.jruby.ext.openssl.X509Extension;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.util.ByteList;

public class X509Cert
extends RubyObject {
    private static final long serialVersionUID = -6524431607032364369L;
    private IRubyObject subject;
    private IRubyObject issuer;
    private BigInteger serial = BigInteger.ZERO;
    private RubyTime not_before;
    private RubyTime not_after;
    private IRubyObject sig_alg;
    private IRubyObject version;
    private X509Certificate cert;
    private transient PKey public_key;
    private final List<X509Extension> extensions = new ArrayList<X509Extension>(4);
    private boolean changed = true;

    static void createX509Cert(Ruby runtime, RubyModule X5092, RubyClass OpenSSLError) {
        RubyClass Certificate2 = X5092.defineClassUnder("Certificate", runtime.getObject(), (r, klass) -> new X509Cert(r, klass));
        X5092.defineClassUnder("CertificateError", OpenSSLError, OpenSSLError.getAllocator());
        Certificate2.defineAnnotatedMethods(X509Cert.class);
    }

    public X509Cert(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private X509Cert(Ruby runtime) {
        super(runtime, X509Cert._Certificate(runtime));
    }

    final X509AuxCertificate getAuxCert() {
        if (this.cert == null) {
            return null;
        }
        if (this.cert instanceof X509AuxCertificate) {
            return (X509AuxCertificate)this.cert;
        }
        return new X509AuxCertificate(this.cert);
    }

    public static IRubyObject wrap(Ruby runtime, Certificate cert2) throws java.security.cert.CertificateEncodingException {
        return X509Cert.wrap(runtime.getCurrentContext(), cert2);
    }

    static X509Cert wrap(ThreadContext context2, Certificate cert2) throws java.security.cert.CertificateEncodingException {
        if (cert2 instanceof X509Certificate) {
            X509Cert c = new X509Cert(context2.runtime);
            c.initialize(context2, (X509Certificate)cert2);
            return c;
        }
        return X509Cert.wrap(context2, cert2.getEncoded());
    }

    public static IRubyObject wrap(Ruby runtime, javax.security.cert.Certificate cert2) throws CertificateEncodingException {
        return X509Cert.wrap(runtime.getCurrentContext(), cert2.getEncoded());
    }

    static X509Cert wrap(ThreadContext context2, byte[] encoded) {
        X509Cert cert2 = new X509Cert(context2.runtime);
        cert2.initialize(context2, encoded);
        return cert2;
    }

    @JRubyMethod(name={"initialize"}, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args, Block unusedBlock) {
        if (args.length == 0) {
            this.subject = X509Name.newName(context2.runtime);
            this.issuer = X509Name.newName(context2.runtime);
            return this;
        }
        RubyString str = StringHelper.readPossibleDERInput(context2, args[0]);
        ByteList bytes = str.getByteList();
        this.initialize(context2, bytes.unsafeBytes(), bytes.getBegin(), bytes.getRealSize());
        return this;
    }

    private void initialize(ThreadContext context2, byte[] encoded) {
        this.initialize(context2, encoded, 0, encoded.length);
    }

    private void initialize(ThreadContext context2, byte[] encoded, int offset, int length) {
        X509Certificate cert2;
        byte[] bytes = StringHelper.readX509PEM(encoded, offset, length);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            cert2 = (X509Certificate)SecurityHelper.getCertificateFactory("X.509").generateCertificate(bis);
        }
        catch (CertificateException e) {
            throw X509Cert.newCertificateError(context2.runtime, e);
        }
        this.initialize(context2, cert2);
    }

    private void initialize(ThreadContext context2, X509Certificate cert2) {
        Set<String> nonCriticalExtOIDs;
        Ruby runtime = context2.runtime;
        if (cert2 == null) {
            throw X509Cert.newCertificateError(runtime, (String)null);
        }
        this.cert = cert2;
        this.set_serial((IRubyObject)RubyNumeric.str2inum((Ruby)runtime, (RubyString)runtime.newString(cert2.getSerialNumber().toString()), (int)10));
        this.set_not_before(context2, (IRubyObject)RubyTime.newTime((Ruby)runtime, (long)cert2.getNotBefore().getTime()));
        this.set_not_after(context2, (IRubyObject)RubyTime.newTime((Ruby)runtime, (long)cert2.getNotAfter().getTime()));
        this.subject = X509Name.newName(runtime, cert2.getSubjectX500Principal());
        this.issuer = X509Name.newName(runtime, cert2.getIssuerX500Principal());
        this.version = RubyFixnum.newFixnum((Ruby)runtime, (long)(cert2.getVersion() - 1));
        String sigAlgorithm = cert2.getSigAlgOID();
        if (sigAlgorithm == null) {
            sigAlgorithm = cert2.getSigAlgName();
        } else if ((sigAlgorithm = ASN1.oid2name(runtime, new ASN1ObjectIdentifier(sigAlgorithm), true)) == null) {
            sigAlgorithm = "0.0";
            if (cert2.getSigAlgName() != null && !cert2.getSigAlgOID().equals(cert2.getSigAlgName())) {
                sigAlgorithm = cert2.getSigAlgName();
            }
        }
        this.sig_alg = RubyString.newString((Ruby)runtime, (String)sigAlgorithm);
        Set<String> criticalExtOIDs = cert2.getCriticalExtensionOIDs();
        if (criticalExtOIDs != null) {
            for (String extOID : criticalExtOIDs) {
                this.addExtension(context2, extOID, true);
            }
        }
        if ((nonCriticalExtOIDs = cert2.getNonCriticalExtensionOIDs()) != null) {
            for (String extOID : nonCriticalExtOIDs) {
                this.addExtension(context2, extOID, false);
            }
        }
        this.changed = false;
    }

    private void addExtension(ThreadContext context2, String extOID, boolean critical) {
        try {
            byte[] extValue = this.cert.getExtensionValue(extOID);
            if (extValue == null) {
                return;
            }
            X509Extension[] extension = X509Extension.newExtension(context2, extOID, extValue, critical);
            for (int i2 = 0; i2 < extension.length; ++i2) {
                this.extensions.add(extension[i2]);
            }
        }
        catch (IOException e) {
            throw X509Cert.newCertificateError(context2.runtime, e);
        }
    }

    private static RubyClass _CertificateError(Ruby runtime) {
        return X509._X509(runtime).getClass("CertificateError");
    }

    static RubyClass _Certificate(Ruby runtime) {
        return X509._X509(runtime).getClass("Certificate");
    }

    public static RaiseException newCertificateError(Ruby runtime, Exception e) {
        return Utils.newError(runtime, X509Cert._CertificateError(runtime), e);
    }

    static RaiseException newCertificateError(Ruby runtime, String msg) {
        return Utils.newError(runtime, X509Cert._CertificateError(runtime), msg);
    }

    static RaiseException newCertificateError(Ruby runtime, String msg, Exception e) {
        return Utils.newError(runtime, X509Cert._CertificateError(runtime), msg, e);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        return this;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return StringHelper.newString(this.getRuntime(), this.cert.getEncoded());
        }
        catch (java.security.cert.CertificateEncodingException ex) {
            throw X509Cert.newCertificateError(this.getRuntime(), ex);
        }
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        StringWriter str = new StringWriter();
        try {
            PEMInputOutput.writeX509Certificate(str, this.getAuxCert());
            return this.getRuntime().newString(str.toString());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
    }

    @JRubyMethod
    public IRubyObject to_text(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        char[] S20 = StringHelper.S20;
        StringBuilder text = new StringBuilder(240);
        text.append("Certificate:\n");
        text.append(S20, 0, 4).append("Data:\n");
        int version2 = this.version == null ? 0 : RubyNumeric.fix2int((IRubyObject)this.version);
        text.append(S20, 0, 8).append("Version: ").append(version2 + 1).append(" (0x").append(Integer.toString(version2, 16)).append(")\n");
        text.append(S20, 0, 8).append("Serial Number:");
        if (this.serial.compareTo(new BigInteger("FFFFFFFFFFFFFFFF", 16)) > 0) {
            text.append('\n');
            text.append(S20, 0, 12).append((CharSequence)StringHelper.lowerHexBytes(this.serial.toByteArray(), 1)).append('\n');
        } else {
            text.append(' ').append(this.serial.toString(10)).append(' ');
            text.append('(').append("0x").append(this.serial.toString(16)).append(')').append('\n');
        }
        text.append(S20, 0, 4).append("Signature Algorithm: ").append(this.signature_algorithm()).append('\n');
        text.append(S20, 0, 8).append("Issuer: ").append(this.issuer).append('\n');
        text.append(S20, 0, 8).append("Validity\n");
        text.append(S20, 0, 12).append("Not Before: ");
        StringHelper.appendGMTDateTime(text, this.getNotBefore()).append('\n');
        text.append(S20, 0, 12).append("Not After : ");
        StringHelper.appendGMTDateTime(text, this.getNotAfter()).append('\n');
        text.append(S20, 0, 8).append("Subject: ").append(this.subject()).append('\n');
        text.append(S20, 0, 8).append("Subject Public Key Info:\n");
        PublicKey publicKey = this.getPublicKey();
        text.append(S20, 0, 12).append("Public Key Algorithm: ").append(publicKey.getAlgorithm()).append('\n');
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)publicKey;
            text.append(S20, 0, 16).append("Public-Key: (").append(rsaKey.getModulus().bitLength()).append(" bit)\n");
            text.append(S20, 0, 16).append("Modulus:\n");
            StringHelper.appendLowerHexValue(text, rsaKey.getModulus().toByteArray(), 20, 45);
            BigInteger exponent = rsaKey.getPublicExponent();
            text.append(S20, 0, 16).append("Exponent: ").append(exponent).append(" (0x").append(exponent.toString(16)).append(")\n");
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaKey = (DSAPublicKey)publicKey;
            text.append(S20, 0, 16).append("Public-Key: (").append(dsaKey.getY().bitLength()).append(" bit)\n");
            text.append(S20, 0, 16).append("TODO: not-implemented (PR HOME-WORK)").append('\n');
        } else {
            text.append(S20, 0, 16).append("TODO: not-implemented (PRs WELCOME!)").append('\n');
        }
        if (this.extensions != null && this.extensions.size() > 0) {
            text.append(S20, 0, 8).append("X509v3 extensions:\n");
            X509CRL.extensions_to_text(context2, this.extensions, text, 12);
        }
        text.append(S20, 0, 4).append("Signature Algorithm: ").append(this.signature_algorithm()).append('\n');
        StringHelper.appendLowerHexValue(text, this.getSignature(), 9, 54);
        return RubyString.newString((Ruby)runtime, (CharSequence)text);
    }

    @JRubyMethod
    public IRubyObject inspect() {
        ArrayList<Variable> varList = new ArrayList<Variable>(5);
        varList.add((Variable)new VariableEntry("subject", (Object)(this.subject().isNil() ? "nil" : this.subject().asString().toString())));
        varList.add((Variable)new VariableEntry("issuer", (Object)(this.issuer().isNil() ? "nil" : this.issuer().asString().toString())));
        varList.add((Variable)new VariableEntry("serial", (Object)(this.serial().isNil() ? "nil" : this.serial().asString().toString())));
        varList.add((Variable)new VariableEntry("not_before", (Object)(this.not_before().isNil() ? "nil" : this.not_before().toString())));
        varList.add((Variable)new VariableEntry("not_after", (Object)(this.not_after().isNil() ? "nil" : this.not_after().toString())));
        return ObjectSupport.inspect((RubyBasicObject)this, varList);
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.version != null ? this.version : (this.version = this.getRuntime().newFixnum(0));
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(IRubyObject version2) {
        if (!this.version().equals(version2)) {
            this.changed = true;
        }
        this.version = version2;
        return this.version;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm() {
        return this.sig_alg;
    }

    private byte[] getSignature() {
        return this.cert.getSignature();
    }

    BigInteger getSerial() {
        return this.serial;
    }

    @JRubyMethod
    public IRubyObject serial() {
        return BN.newBN(this.getRuntime(), this.serial);
    }

    @JRubyMethod(name={"serial="})
    public IRubyObject set_serial(IRubyObject serial2) {
        String serialStr = serial2.asString().toString();
        BigInteger serialInt = serialStr.equals("0") ? BigInteger.ONE : new BigInteger(serialStr);
        this.changed = !serialInt.equals(this.serial);
        this.serial = serialInt;
        return serial2;
    }

    X509Name getSubject() {
        return (X509Name)this.subject;
    }

    @JRubyMethod
    public IRubyObject subject() {
        return this.subject;
    }

    @JRubyMethod(name={"subject="})
    public IRubyObject set_subject(IRubyObject subject2) {
        if (!subject2.equals(this.subject)) {
            this.changed = true;
        }
        this.subject = subject2;
        return this.subject;
    }

    X509Name getIssuer() {
        return (X509Name)this.issuer;
    }

    @JRubyMethod
    public IRubyObject issuer() {
        return this.issuer;
    }

    @JRubyMethod(name={"issuer="})
    public IRubyObject set_issuer(IRubyObject issuer2) {
        if (!issuer2.equals(this.issuer)) {
            this.changed = true;
        }
        this.issuer = issuer2;
        return this.issuer;
    }

    @JRubyMethod
    public IRubyObject not_before() {
        return this.not_before == null ? this.getRuntime().getNil() : this.not_before;
    }

    @JRubyMethod(name={"not_before="})
    public IRubyObject set_not_before(ThreadContext context2, IRubyObject time2) {
        this.changed = true;
        this.not_before = (RubyTime)time2.callMethod(context2, "getutc");
        this.not_before.setMicroseconds(0L);
        return time2;
    }

    DateTime getNotBefore() {
        return this.not_before == null ? null : this.not_before.getDateTime();
    }

    @JRubyMethod
    public IRubyObject not_after() {
        return this.not_after == null ? this.getRuntime().getNil() : this.not_after;
    }

    @JRubyMethod(name={"not_after="})
    public IRubyObject set_not_after(ThreadContext context2, IRubyObject time2) {
        this.changed = true;
        this.not_after = (RubyTime)time2.callMethod(context2, "getutc");
        this.not_after.setMicroseconds(0L);
        return time2;
    }

    DateTime getNotAfter() {
        return this.not_after == null ? null : this.not_after.getDateTime();
    }

    @JRubyMethod
    public IRubyObject public_key(ThreadContext context2) {
        if (this.public_key == null) {
            this.initializePublicKey();
        }
        return this.public_key;
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject public_key2) {
        if (!(public_key2 instanceof PKey)) {
            throw this.getRuntime().newTypeError("OpenSSL::PKey::PKey expected but got " + public_key2.getMetaClass().getName());
        }
        if (!public_key2.equals((Object)this.public_key)) {
            this.changed = true;
        }
        this.public_key = (PKey)public_key2;
        return this.public_key;
    }

    private PublicKey getPublicKey() {
        if (this.public_key == null) {
            this.initializePublicKey();
        }
        return this.public_key.getPublicKey();
    }

    private void initializePublicKey() throws RaiseException {
        Ruby runtime = this.getRuntime();
        boolean changed = this.changed;
        if (this.cert == null) {
            throw X509Cert.newCertificateError(runtime, "no certificate");
        }
        this.set_public_key((IRubyObject)PKey.newInstance(runtime, this.cert.getPublicKey()));
        this.changed = changed;
    }

    @JRubyMethod
    public IRubyObject sign(ThreadContext context2, IRubyObject key, IRubyObject digest2) {
        X509CertificateHolder certHolder;
        String digName;
        String digAlg;
        Ruby runtime = context2.runtime;
        if (!(key instanceof PKey)) {
            throw runtime.newTypeError(key, PKey._PKey(runtime).getClass("PKey"));
        }
        String keyAlg = ((PKey)key).getAlgorithm();
        if (digest2 instanceof Digest) {
            digAlg = ((Digest)digest2).getShortAlgorithm();
            digName = ((Digest)digest2).getName();
        } else if (digest2 instanceof RubyString) {
            digAlg = digest2.asJavaString();
            digName = null;
        } else {
            throw runtime.newTypeError(digest2, Digest._Digest(runtime));
        }
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(digName)) {
            throw X509Cert.newCertificateError(runtime, "signature_algorithm not supported");
        }
        X509v3CertificateBuilder builder = this.newCertificateBuilder();
        for (X509Extension ext2 : this.uniqueExtensions()) {
            try {
                byte[] bytes = ext2.getRealValueEncoded();
                builder.addExtension(ext2.getRealObjectID(), ext2.isRealCritical(), bytes);
            }
            catch (IOException e) {
                throw X509Cert.newCertificateError(runtime, "invalid extension (" + e.getMessage() + ")", e);
            }
        }
        try {
            ContentSigner signer = new JcaContentSignerBuilder(digAlg + "WITH" + keyAlg).build(((PKey)key).getPrivateKey());
            certHolder = builder.build(signer);
        }
        catch (OperatorCreationException e) {
            Throwable cause = (Exception)e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw X509Cert.newCertificateError(runtime, "cannot create signer: " + cause.getMessage(), (Exception)cause);
        }
        catch (IllegalStateException e) {
            throw X509Cert.newCertificateError(runtime, "could not generate certificate", e);
        }
        catch (RuntimeException e) {
            throw X509Cert.newCertificateError(runtime, e);
        }
        try {
            this.cert = (X509Certificate)SecurityHelper.getCertificateFactory("X.509").generateCertificate(new ByteArrayInputStream(certHolder.getEncoded()));
        }
        catch (IOException | CertificateException e) {
            throw X509Cert.newCertificateError(runtime, "could not re-generate certificate", e);
        }
        String name2 = ASN1Registry.o2a(certHolder.getSignatureAlgorithm().getAlgorithm());
        if (name2 == null) {
            name2 = this.cert.getSigAlgOID();
        }
        this.sig_alg = runtime.newString(name2);
        this.changed = false;
        return this;
    }

    private X509v3CertificateBuilder newCertificateBuilder() {
        SubjectPublicKeyInfo publicKeyInfo;
        try {
            publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)this.public_key.getPublicKey().getEncoded());
        }
        catch (Exception e) {
            throw X509Cert.newCertificateError(this.getRuntime(), "invalid public key data", e);
        }
        return new X509v3CertificateBuilder(this.issuer == null ? null : ((X509Name)this.issuer).getX500Name(), this.serial.abs(), this.not_before.getJavaDate(), this.not_after.getJavaDate(), this.subject == null ? null : ((X509Name)this.subject).getX500Name(), publicKeyInfo);
    }

    @JRubyMethod
    public RubyBoolean verify(IRubyObject key) {
        Ruby runtime = this.getRuntime();
        if (this.changed) {
            return runtime.getFalse();
        }
        try {
            this.cert.verify(((PKey)key).getPublicKey());
            return runtime.getTrue();
        }
        catch (CertificateException e) {
            OpenSSL.debugStackTrace(runtime, "X509Cert#verify", e);
            throw X509Cert.newCertificateError(runtime, e);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509Cert.newCertificateError(runtime, e);
        }
        catch (InvalidKeyException | SignatureException e) {
            OpenSSL.debug(runtime, "X509Cert#verify failed", e);
            return runtime.getFalse();
        }
    }

    @JRubyMethod
    public RubyBoolean check_private_key(IRubyObject key) {
        PublicKey certPublicKey = this.cert.getPublicKey();
        if (certPublicKey.equals(((PKey)key).getPublicKey())) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyArray extensions() {
        List<X509Extension> extensions2 = this.extensions;
        return this.getRuntime().newArray(extensions2);
    }

    @JRubyMethod(name={"extensions="})
    public IRubyObject set_extensions(IRubyObject array) {
        this.extensions.clear();
        this.extensions.addAll((List)array);
        return array;
    }

    @JRubyMethod
    public IRubyObject add_extension(IRubyObject ext2) {
        this.changed = true;
        this.extensions.add((X509Extension)ext2);
        return ext2;
    }

    private Collection<X509Extension> uniqueExtensions() {
        LinkedHashMap<ASN1ObjectIdentifier, X509Extension> unique = new LinkedHashMap<ASN1ObjectIdentifier, X509Extension>();
        for (X509Extension current : this.extensions) {
            ASN1EncodableVector vec;
            ASN1ObjectIdentifier oid2 = current.getRealObjectID();
            X509Extension existing = (X509Extension)((Object)unique.get(oid2));
            if (existing == null) {
                unique.put(oid2, current);
                continue;
            }
            if ("2.5.29.17".equals(oid2.getId()) || "2.5.29.18".equals(oid2.getId())) {
                vec = new ASN1EncodableVector();
                try {
                    GeneralName[] n1 = X509Cert.extRealNames(existing);
                    for (int i2 = 0; i2 < n1.length; ++i2) {
                        vec.add((ASN1Encodable)n1[i2]);
                    }
                    GeneralName[] n2 = X509Cert.extRealNames(current);
                    for (int i3 = 0; i3 < n2.length; ++i3) {
                        vec.add((ASN1Encodable)n2[i3]);
                    }
                    GeneralNames nn = GeneralNames.getInstance((Object)new DLSequence(vec));
                    X509Extension existingDup = existing.clone();
                    existingDup.setRealValue((ASN1Encodable)nn);
                    unique.put(oid2, existingDup);
                    continue;
                }
                catch (IOException ex) {
                    throw this.getRuntime().newIOErrorFromException(ex);
                }
            }
            vec = new ASN1EncodableVector();
            try {
                ASN1Encodable existingValue = existing.getRealValue();
                if (existingValue instanceof ASN1Sequence) {
                    ASN1Sequence seq = (ASN1Sequence)existingValue;
                    for (int i4 = 0; i4 < seq.size(); ++i4) {
                        vec.add(seq.getObjectAt(i4));
                    }
                } else {
                    vec.add(existingValue);
                }
                vec.add(current.getRealValue());
                X509Extension existingDup = existing.clone();
                existingDup.setRealValue((ASN1Encodable)new DLSequence(vec));
                unique.put(oid2, existingDup);
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOErrorFromException(ex);
            }
        }
        return unique.values();
    }

    private static GeneralName[] extRealNames(X509Extension extension) throws IOException {
        ASN1Encodable value2 = extension.getRealValue();
        if (value2 instanceof GeneralName) {
            return new GeneralName[]{(GeneralName)value2};
        }
        return GeneralNames.getInstance((Object)value2).getNames();
    }

    public Object toJava(Class target) {
        if (target.isAssignableFrom(X509Certificate.class)) {
            if (target == X509AuxCertificate.class) {
                return this.getAuxCert();
            }
            return this.cert;
        }
        return super.toJava(target);
    }
}

