import EventEmitter from 'events';
import { TsType } from '..';
import { KeyValue } from '../../controller/tstype';
import { DeviceType } from './enums';
import { ZBOSSFrame } from './frame';
import { ZBOSSUart } from './uart';
type ZBOSSNetworkInfo = {
    joined: boolean;
    nodeType: DeviceType;
    ieeeAddr: string;
    network: {
        panID: number;
        extendedPanID: number[];
        channel: number;
    };
};
export declare class ZBOSSDriver extends EventEmitter {
    readonly port: ZBOSSUart;
    private waitress;
    private queue;
    private tsn;
    private nwkOpt;
    netInfo?: ZBOSSNetworkInfo;
    constructor(options: TsType.SerialPortOptions, nwkOpt: TsType.NetworkOptions);
    connect(): Promise<boolean>;
    private reset;
    startup(): Promise<TsType.StartResult>;
    private needsToBeInitialised;
    private getNetworkInfo;
    private addEndpoint;
    private getChannelMask;
    private formNetwork;
    stop(): Promise<void>;
    private onFrame;
    isInitialized(): boolean | undefined;
    execCommand(commandId: number, params?: KeyValue, timeout?: number): Promise<ZBOSSFrame>;
    waitFor(commandId: number, tsn: number | null, timeout?: number): {
        start: () => {
            promise: Promise<ZBOSSFrame>;
            ID: number;
        };
        ID: number;
    };
    private waitressTimeoutFormatter;
    private waitressValidator;
    getCoordinator(): Promise<TsType.Coordinator>;
    getCoordinatorVersion(): Promise<TsType.CoordinatorVersion>;
    permitJoin(nwk: number, duration: number): Promise<void>;
    setTXPower(value: number): Promise<void>;
    lqi(nwk: number, index: number): Promise<ZBOSSFrame>;
    neighbors(ieee: string): Promise<ZBOSSFrame>;
    nodeDescriptor(nwk: number): Promise<ZBOSSFrame>;
    activeEndpoints(nwk: number): Promise<ZBOSSFrame>;
    simpleDescriptor(nwk: number, ep: number): Promise<ZBOSSFrame>;
    removeDevice(nwk: number, ieee: string): Promise<ZBOSSFrame>;
    request(ieee: string, profileID: number, clusterID: number, dstEp: number, srcEp: number, data: Buffer): Promise<ZBOSSFrame>;
    bind(destinationNetworkAddress: number, sourceIeeeAddress: string, sourceEndpoint: number, clusterID: number, destinationAddressOrGroup: string | number, type: 'endpoint' | 'group', destinationEndpoint?: number): Promise<ZBOSSFrame>;
    unbind(destinationNetworkAddress: number, sourceIeeeAddress: string, sourceEndpoint: number, clusterID: number, destinationAddressOrGroup: string | number, type: 'endpoint' | 'group', destinationEndpoint?: number): Promise<ZBOSSFrame>;
    ieeeByNwk(nwk: number): Promise<string>;
}
export {};
//# sourceMappingURL=driver.d.ts.map