"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLQueryParser = void 0;
var _ppl_syntax_parser = require("../antlr/ppl_syntax_parser");
var _stats_ast_builder = require("../ast/builder/stats_ast_builder");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class PPLQueryParser {
  constructor() {
    _defineProperty(this, "parser", null);
    _defineProperty(this, "visitor", null);
    _defineProperty(this, "rawQuery", '');
  }
  parse(pplQuery) {
    this.rawQuery = pplQuery;
    this.parser = new _ppl_syntax_parser.PPLSyntaxParser().parse(this.rawQuery);
    return this;
  }
  getStats() {
    this.visitor = new _stats_ast_builder.StatsAstBuilder();
    let inter = null;
    try {
      inter = this.visitor.visitRoot(this.parser.root()).getTokens();
    } catch (e) {
      console.error(e);
    }
    return inter;
  }
}
exports.PPLQueryParser = PPLQueryParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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