# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BOPTools module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_boptools.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BOPTools
else:
    import _BOPTools

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BOPTools.delete_SwigPyIterator

    def value(self):
        return _BOPTools.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BOPTools.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BOPTools.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BOPTools.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BOPTools.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BOPTools.SwigPyIterator_copy(self)

    def next(self):
        return _BOPTools.SwigPyIterator_next(self)

    def __next__(self):
        return _BOPTools.SwigPyIterator___next__(self)

    def previous(self):
        return _BOPTools.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BOPTools.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BOPTools.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BOPTools.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BOPTools.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BOPTools.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BOPTools.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BOPTools.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BOPTools:
_BOPTools.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BOPTools.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.IntTools
import OCC.Core.BRepAdaptor
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dAdaptor
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.Geom2dHatch
import OCC.Core.IntRes2d
import OCC.Core.HatchGen
import OCC.Core.Geom2dInt
import OCC.Core.IntCurve
import OCC.Core.Extrema
import OCC.Core.Intf
import OCC.Core.GeomAPI
import OCC.Core.Approx
import OCC.Core.AppCont
import OCC.Core.AppParCurves
import OCC.Core.BRepClass3d
import OCC.Core.IntCurveSurface
import OCC.Core.IntSurf
import OCC.Core.TopTools
import OCC.Core.IntCurvesFace
import OCC.Core.IntPatch
import OCC.Core.IntAna
import OCC.Core.GeomInt
import OCC.Core.IntImp
import OCC.Core.ApproxInt

from enum import IntEnum
from OCC.Core.Exception import *



class BOPTools_IndexedDataMapOfSetShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_begin(self)

    def end(self):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_end(self)

    def cbegin(self):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_cbegin(self)

    def cend(self):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_cend(self)

    def __init__(self, *args):
        _BOPTools.BOPTools_IndexedDataMapOfSetShape_swiginit(self, _BOPTools.new_BOPTools_IndexedDataMapOfSetShape(*args))

    def Exchange(self, theOther):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Exchange(self, theOther)

    def Assign(self, theOther):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Assign(self, theOther)

    def Set(self, theOther):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Set(self, theOther)

    def ReSize(self, N):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_ReSize(self, N)

    def Add(self, theKey1, theItem):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Add(self, theKey1, theItem)

    def Contains(self, theKey1):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Contains(self, theKey1)

    def Substitute(self, theIndex, theKey1, theItem):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Substitute(self, theIndex, theKey1, theItem)

    def Swap(self, theIndex1, theIndex2):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Swap(self, theIndex1, theIndex2)

    def RemoveLast(self):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_RemoveLast(self)

    def RemoveFromIndex(self, theIndex):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_RemoveFromIndex(self, theIndex)

    def RemoveKey(self, theKey1):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_RemoveKey(self, theKey1)

    def FindKey(self, theIndex):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_FindKey(self, theIndex)

    def FindFromIndex(self, theIndex):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_FindFromIndex(self, theIndex)

    def ChangeFromIndex(self, theIndex):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_ChangeFromIndex(self, theIndex)

    def __call__(self, *args):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape___call__(self, *args)

    def FindIndex(self, theKey1):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_FindIndex(self, theKey1)

    def ChangeFromKey(self, theKey1):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_ChangeFromKey(self, theKey1)

    def Seek(self, theKey1):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Seek(self, theKey1)

    def ChangeSeek(self, theKey1):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_ChangeSeek(self, theKey1)

    def FindFromKey(self, *args):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_FindFromKey(self, *args)

    def Clear(self, *args):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Clear(self, *args)
    __swig_destroy__ = _BOPTools.delete_BOPTools_IndexedDataMapOfSetShape

    def Size(self):
        return _BOPTools.BOPTools_IndexedDataMapOfSetShape_Size(self)

# Register BOPTools_IndexedDataMapOfSetShape in _BOPTools:
_BOPTools.BOPTools_IndexedDataMapOfSetShape_swigregister(BOPTools_IndexedDataMapOfSetShape)
class BOPTools_ListOfConnexityBlock(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_begin(self)

    def end(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_end(self)

    def cbegin(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_cbegin(self)

    def cend(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_cend(self)

    def __init__(self, *args):
        _BOPTools.BOPTools_ListOfConnexityBlock_swiginit(self, _BOPTools.new_BOPTools_ListOfConnexityBlock(*args))

    def Size(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Size(self)

    def Assign(self, theOther):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Assign(self, theOther)

    def Set(self, theOther):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Clear(self, theAllocator)

    def First(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_First(self)

    def Last(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Last(self)

    def Append(self, *args):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Append(self, *args)

    def Prepend(self, *args):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Prepend(self, *args)

    def RemoveFirst(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_RemoveFirst(self)

    def Remove(self, theIter):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _BOPTools.BOPTools_ListOfConnexityBlock_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _BOPTools.BOPTools_ListOfConnexityBlock_InsertAfter(self, *args)

    def Reverse(self):
        return _BOPTools.BOPTools_ListOfConnexityBlock_Reverse(self)
    __swig_destroy__ = _BOPTools.delete_BOPTools_ListOfConnexityBlock

    def __len__(self):
        return self.Size()


# Register BOPTools_ListOfConnexityBlock in _BOPTools:
_BOPTools.BOPTools_ListOfConnexityBlock_swigregister(BOPTools_ListOfConnexityBlock)
class BOPTools_ListOfCoupleOfShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_begin(self)

    def end(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_end(self)

    def cbegin(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_cbegin(self)

    def cend(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_cend(self)

    def __init__(self, *args):
        _BOPTools.BOPTools_ListOfCoupleOfShape_swiginit(self, _BOPTools.new_BOPTools_ListOfCoupleOfShape(*args))

    def Size(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Size(self)

    def Assign(self, theOther):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Assign(self, theOther)

    def Set(self, theOther):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Clear(self, theAllocator)

    def First(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_First(self)

    def Last(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Last(self)

    def Append(self, *args):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Append(self, *args)

    def Prepend(self, *args):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Prepend(self, *args)

    def RemoveFirst(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_RemoveFirst(self)

    def Remove(self, theIter):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_InsertAfter(self, *args)

    def Reverse(self):
        return _BOPTools.BOPTools_ListOfCoupleOfShape_Reverse(self)
    __swig_destroy__ = _BOPTools.delete_BOPTools_ListOfCoupleOfShape

    def __len__(self):
        return self.Size()


# Register BOPTools_ListOfCoupleOfShape in _BOPTools:
_BOPTools.BOPTools_ListOfCoupleOfShape_swigregister(BOPTools_ListOfCoupleOfShape)
class BOPTools_MapOfSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def cbegin(self):
        return _BOPTools.BOPTools_MapOfSet_cbegin(self)

    def cend(self):
        return _BOPTools.BOPTools_MapOfSet_cend(self)

    def __init__(self, *args):
        _BOPTools.BOPTools_MapOfSet_swiginit(self, _BOPTools.new_BOPTools_MapOfSet(*args))

    def Exchange(self, theOther):
        return _BOPTools.BOPTools_MapOfSet_Exchange(self, theOther)

    def Assign(self, theOther):
        return _BOPTools.BOPTools_MapOfSet_Assign(self, theOther)

    def Set(self, theOther):
        return _BOPTools.BOPTools_MapOfSet_Set(self, theOther)

    def ReSize(self, N):
        return _BOPTools.BOPTools_MapOfSet_ReSize(self, N)

    def Add(self, K):
        return _BOPTools.BOPTools_MapOfSet_Add(self, K)

    def Added(self, K):
        return _BOPTools.BOPTools_MapOfSet_Added(self, K)

    def Remove(self, K):
        return _BOPTools.BOPTools_MapOfSet_Remove(self, K)

    def Clear(self, *args):
        return _BOPTools.BOPTools_MapOfSet_Clear(self, *args)
    __swig_destroy__ = _BOPTools.delete_BOPTools_MapOfSet

    def Size(self):
        return _BOPTools.BOPTools_MapOfSet_Size(self)

    def IsEqual(self, theOther):
        return _BOPTools.BOPTools_MapOfSet_IsEqual(self, theOther)

    def Contains(self, *args):
        return _BOPTools.BOPTools_MapOfSet_Contains(self, *args)

    def Union(self, theLeft, theRight):
        return _BOPTools.BOPTools_MapOfSet_Union(self, theLeft, theRight)

    def Unite(self, theOther):
        return _BOPTools.BOPTools_MapOfSet_Unite(self, theOther)

    def HasIntersection(self, theMap):
        return _BOPTools.BOPTools_MapOfSet_HasIntersection(self, theMap)

    def Intersection(self, theLeft, theRight):
        return _BOPTools.BOPTools_MapOfSet_Intersection(self, theLeft, theRight)

    def Intersect(self, theOther):
        return _BOPTools.BOPTools_MapOfSet_Intersect(self, theOther)

    def Subtraction(self, theLeft, theRight):
        return _BOPTools.BOPTools_MapOfSet_Subtraction(self, theLeft, theRight)

    def Subtract(self, theOther):
        return _BOPTools.BOPTools_MapOfSet_Subtract(self, theOther)

    def Difference(self, theLeft, theRight):
        return _BOPTools.BOPTools_MapOfSet_Difference(self, theLeft, theRight)

    def Differ(self, theOther):
        return _BOPTools.BOPTools_MapOfSet_Differ(self, theOther)

# Register BOPTools_MapOfSet in _BOPTools:
_BOPTools.BOPTools_MapOfSet_swigregister(BOPTools_MapOfSet)
class BOPTools_AlgoTools(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def AreFacesSameDomain(*args):
        r"""

        Parameters
        ----------
        theF1: TopoDS_Face
        theF2: TopoDS_Face
        theContext: IntTools_Context
        theFuzz: float (optional, default to Precision::Confusion())

        Return
        -------
        bool

        Description
        -----------
        Checks if the given faces are same-domain, i.e. coincide.

        """
        return _BOPTools.BOPTools_AlgoTools_AreFacesSameDomain(*args)

    @staticmethod
    def ComputeState(*args):
        r"""

        Parameters
        ----------
        thePoint: gp_Pnt
        theSolid: TopoDS_Solid
        theTol: float
        theContext: IntTools_Context

        Return
        -------
        TopAbs_State

        Description
        -----------
        Computes the 3-d state of the point thepoint toward solid thesolid. thetol - value of precision of computation thecontext- cahed geometrical tools returns 3-d state.

        Parameters
        ----------
        theVertex: TopoDS_Vertex
        theSolid: TopoDS_Solid
        theTol: float
        theContext: IntTools_Context

        Return
        -------
        TopAbs_State

        Description
        -----------
        Computes the 3-d state of the vertex thevertex toward solid thesolid. thetol - value of precision of computation thecontext- cahed geometrical tools returns 3-d state.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theSolid: TopoDS_Solid
        theTol: float
        theContext: IntTools_Context

        Return
        -------
        TopAbs_State

        Description
        -----------
        Computes the 3-d state of the edge theedge toward solid thesolid. thetol - value of precision of computation thecontext- cahed geometrical tools returns 3-d state.

        Parameters
        ----------
        theFace: TopoDS_Face
        theSolid: TopoDS_Solid
        theTol: float
        theBounds: TopTools_IndexedMapOfShape
        theContext: IntTools_Context

        Return
        -------
        TopAbs_State

        Description
        -----------
        Computes the 3-d state of the face theface toward solid thesolid. thetol - value of precision of computation thebounds - set of edges of <thesolid> to avoid thecontext- cahed geometrical tools returns 3-d state.

        """
        return _BOPTools.BOPTools_AlgoTools_ComputeState(*args)

    @staticmethod
    def ComputeStateByOnePoint(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theSolid: TopoDS_Solid
        theTol: float
        theContext: IntTools_Context

        Return
        -------
        TopAbs_State

        Description
        -----------
        Computes the 3-d state of the shape theshape toward solid thesolid. thetol - value of precision of computation thecontext- cahed geometrical tools returns 3-d state.

        """
        return _BOPTools.BOPTools_AlgoTools_ComputeStateByOnePoint(*args)

    @staticmethod
    def ComputeTolerance(*args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face
        theEdge: TopoDS_Edge

        Return
        -------
        theMaxDist: float
        theMaxPar: float

        Description
        -----------
        Computes the necessary value of the tolerance for the edge.

        """
        return _BOPTools.BOPTools_AlgoTools_ComputeTolerance(*args)

    @staticmethod
    def ComputeVV(*args):
        r"""

        Parameters
        ----------
        theV: TopoDS_Vertex
        theP: gp_Pnt
        theTolP: float

        Return
        -------
        int

        Description
        -----------
        Intersects the vertex <thev1> with the point <thep> with tolerance <thetolp>. returns the error status: - 0 - no error, meaning that the vertex intersects the point; - 1 - the distance between vertex and point is grater than the sum of tolerances.

        Parameters
        ----------
        theV1: TopoDS_Vertex
        theV2: TopoDS_Vertex
        theFuzz: float (optional, default to Precision::Confusion())

        Return
        -------
        int

        Description
        -----------
        Intersects the given vertices with given fuzzy value. returns the error status: - 0 - no error, meaning that the vertices interferes with given tolerance; - 1 - the distance between vertices is grater than the sum of their tolerances.

        """
        return _BOPTools.BOPTools_AlgoTools_ComputeVV(*args)

    @staticmethod
    def CopyEdge(*args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Makes a copy of <theedge> with vertices.

        """
        return _BOPTools.BOPTools_AlgoTools_CopyEdge(*args)

    @staticmethod
    def CorrectCurveOnSurface(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theMapToAvoid: TopTools_IndexedMapOfShape
        theTolMax: float (optional, default to 0.0001)
        theRunParallel: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Provides valid values of tolerances for the shape <thes> in terms of brepcheck_invalidcurveonsurface.

        """
        return _BOPTools.BOPTools_AlgoTools_CorrectCurveOnSurface(*args)

    @staticmethod
    def CorrectPointOnCurve(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theMapToAvoid: TopTools_IndexedMapOfShape
        theTolMax: float (optional, default to 0.0001)
        theRunParallel: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Provides valid values of tolerances for the shape <thes> in terms of brepcheck_invalidpointoncurve.

        """
        return _BOPTools.BOPTools_AlgoTools_CorrectPointOnCurve(*args)

    @staticmethod
    def CorrectRange(*args):
        r"""

        Parameters
        ----------
        aE1: TopoDS_Edge
        aE2: TopoDS_Edge
        aSR: IntTools_Range
        aNewSR: IntTools_Range

        Return
        -------
        None

        Description
        -----------
        Correct shrunk range <asr> taking into account 3d-curve resolution and corresponding tolerance values of <ae1>, <ae2>.

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aSR: IntTools_Range
        aNewSR: IntTools_Range

        Return
        -------
        None

        Description
        -----------
        Correct shrunk range <asr> taking into account 3d-curve resolution and corresponding tolerance values of <ae>, <af>.

        """
        return _BOPTools.BOPTools_AlgoTools_CorrectRange(*args)

    @staticmethod
    def CorrectShapeTolerances(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theMapToAvoid: TopTools_IndexedMapOfShape
        theRunParallel: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Corrects tolerance values of the sub-shapes of the shape <thes> if needed.

        """
        return _BOPTools.BOPTools_AlgoTools_CorrectShapeTolerances(*args)

    @staticmethod
    def CorrectTolerances(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theMapToAvoid: TopTools_IndexedMapOfShape
        theTolMax: float (optional, default to 0.0001)
        theRunParallel: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Provides valid values of tolerances for the shape <thes> <thetolmax> is max value of the tolerance that can be accepted for correction. if real value of the tolerance will be greater than <atolmax>, the correction does not perform.

        """
        return _BOPTools.BOPTools_AlgoTools_CorrectTolerances(*args)

    @staticmethod
    def DTolerance(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Additional tolerance (delta tolerance) is used in boolean operations to ensure that the tolerance of new/old entities obtained by intersection of two shapes is slightly bigger than the actual distances to these shapes. it helps to avoid numerical instability which may occur when comparing distances and tolerances.

        """
        return _BOPTools.BOPTools_AlgoTools_DTolerance(*args)

    @staticmethod
    def Dimension(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        int

        Description
        -----------
        Returns dimension of the shape <thes>. if the shape contains elements of different dimension, -1 is returned.

        """
        return _BOPTools.BOPTools_AlgoTools_Dimension(*args)

    @staticmethod
    def Dimensions(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        theDMin: int
        theDMax: int

        Description
        -----------
        Returns the min and max dimensions of the shape <thes>.

        """
        return _BOPTools.BOPTools_AlgoTools_Dimensions(*args)

    @staticmethod
    def GetEdgeOff(*args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face
        theEdgeOff: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        Returns true if the face theface contains the edge theedge but with opposite orientation. if the method returns true theedgeoff is the edge founded.

        """
        return _BOPTools.BOPTools_AlgoTools_GetEdgeOff(*args)

    @staticmethod
    def GetEdgeOnFace(*args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face
        theEdgeOnF: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        For the face theface gets the edge theedgeonf that is the same as theedge returns true if such edge exists returns false if there is no such edge.

        """
        return _BOPTools.BOPTools_AlgoTools_GetEdgeOnFace(*args)

    @staticmethod
    def GetFaceOff(*args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face
        theLCEF: BOPTools_ListOfCoupleOfShape
        theFaceOff: TopoDS_Face
        theContext: IntTools_Context

        Return
        -------
        bool

        Description
        -----------
        For the face theface and its edge theedge finds the face suitable to produce shell. thelcef - set of faces to search. all faces from thelcef must share edge theedge.

        """
        return _BOPTools.BOPTools_AlgoTools_GetFaceOff(*args)

    @staticmethod
    def IsBlockInOnFace(*args):
        r"""

        Parameters
        ----------
        aShR: IntTools_Range
        aF: TopoDS_Face
        aE: TopoDS_Edge
        aContext: IntTools_Context

        Return
        -------
        bool

        Description
        -----------
        Returns true if paveblock <apb> lays on the face <af>, i.e the <pb> is in or on in 2d of <af>.

        """
        return _BOPTools.BOPTools_AlgoTools_IsBlockInOnFace(*args)

    @staticmethod
    def IsHole(*args):
        r"""

        Parameters
        ----------
        theW: TopoDS_Shape
        theF: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Checks if the wire is a hole for the face.

        """
        return _BOPTools.BOPTools_AlgoTools_IsHole(*args)

    @staticmethod
    def IsInternalFace(*args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face
        theEdge: TopoDS_Edge
        theFace1: TopoDS_Face
        theFace2: TopoDS_Face
        theContext: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Returns true if the face theface is inside of the couple of faces theface1, theface2. the faces theface, theface1, theface2 must share the edge theedge return values: * 0 state is not in * 1 state is in * 2 state can not be found by the method of angles.

        Parameters
        ----------
        theFace: TopoDS_Face
        theEdge: TopoDS_Edge
        theLF: TopTools_ListOfShape
        theContext: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Returns true if the face theface is inside of the appropriate couple of faces (from the set thelf) . the faces of the set thelf and theface must share the edge theedge * 0 state is not in * 1 state is in * 2 state can not be found by the method of angles.

        Parameters
        ----------
        theFace: TopoDS_Face
        theSolid: TopoDS_Solid
        theMEF: TopTools_IndexedDataMapOfShapeListOfShape
        theTol: float
        theContext: IntTools_Context

        Return
        -------
        bool

        Description
        -----------
        Returns true if the face theface is inside the solid thesolid. themef - map edge/faces for thesolid thetol - value of precision of computation thecontext- cahed geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools_IsInternalFace(*args)

    @staticmethod
    def IsInvertedSolid(*args):
        r"""

        Parameters
        ----------
        theSolid: TopoDS_Solid

        Return
        -------
        bool

        Description
        -----------
        Returns true if the solid <thesolid> is inverted.

        """
        return _BOPTools.BOPTools_AlgoTools_IsInvertedSolid(*args)

    @staticmethod
    def IsMicroEdge(*args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theContext: IntTools_Context
        theCheckSplittable: bool (optional, default to Standard_True)

        Return
        -------
        bool

        Description
        -----------
        Checks if it is possible to compute shrunk range for the edge <ae> flag <thechecksplittable> defines whether to take into account the possibility to split the edge or not.

        """
        return _BOPTools.BOPTools_AlgoTools_IsMicroEdge(*args)

    @staticmethod
    def IsOpenShell(*args):
        r"""

        Parameters
        ----------
        theShell: TopoDS_Shell

        Return
        -------
        bool

        Description
        -----------
        Returns true if the shell <theshell> is open.

        """
        return _BOPTools.BOPTools_AlgoTools_IsOpenShell(*args)

    @staticmethod
    def IsSplitToReverse(*args):
        r"""

        Parameters
        ----------
        theSplit: TopoDS_Shape
        theShape: TopoDS_Shape
        theContext: IntTools_Context
        theError: int * (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        Checks if the direction of the split shape is opposite to the direction of the original shape. the method is an overload for (edge,edge) and (face,face) corresponding methods and checks only these types of shapes. for faces the method checks if normal directions are opposite. for edges the method checks if tangent vectors are opposite. //! in case the directions do not coincide, it returns true, meaning that split shape has to be reversed to match the direction of the original shape. //! if requested (<theerror> is not null), the method returns the status of the operation: - 0 - no error; - error from (edge,edge) or (face,face) corresponding method - 100 - bad types. in case of any error the method always returns false. //! @param thesplit [in] split shape @param theshape [in] original shape @param thecontext [in] cached geometrical tools @param theerror [out] error status of the operation.

        Parameters
        ----------
        theSplit: TopoDS_Face
        theShape: TopoDS_Face
        theContext: IntTools_Context
        theError: int * (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        Checks if the normal direction of the split face is opposite to the normal direction of the original face. the normal directions for both faces are taken in the same point - point inside the split face is projected onto the original face. returns true if the normals do not coincide, meaning the necessity to revert the orientation of the split face to match the direction of the original face. //! if requested (<theerror> is not null), the method returns the status of the operation: - 0 - no error; - 1 - unable to find the point inside split face; - 2 - unable to compute the normal for the split face; - 3 - unable to project the point inside the split face on the original face; - 4 - unable to compute the normal for the original face. in case of any error the method always returns false. //! @param thesplit [in] split face @param theshape [in] original face @param thecontext [in] cached geometrical tools @param theerror [out] error status of the operation.

        Parameters
        ----------
        theSplit: TopoDS_Edge
        theShape: TopoDS_Edge
        theContext: IntTools_Context
        theError: int * (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        Checks if the tangent vector of the split edge is opposite to the tangent vector of the original edge. the tangent vectors for both edges are computed in the same point - point inside the split edge is projected onto the original edge. returns true if the tangent vectors do not coincide, meaning the necessity to revert the orientation of the split edge to match the direction of the original edge. //! if requested (<theerror> is not null), the method returns the status of the operation: - 0 - no error; - 1 - degenerated edges are given; - 2 - unable to compute the tangent vector for the split edge; - 3 - unable to project the point inside the split edge on the original edge; - 4 - unable to compute the tangent vector for the original edge; in case of any error the method always returns false. //! @param thesplit [in] split edge @param theshape [in] original edge @param thecontext [in] cached geometrical tools @param theerror [out] error status of the operation.

        """
        return _BOPTools.BOPTools_AlgoTools_IsSplitToReverse(*args)

    @staticmethod
    def IsSplitToReverseWithWarn(*args):
        r"""

        Parameters
        ----------
        theSplit: TopoDS_Shape
        theShape: TopoDS_Shape
        theContext: IntTools_Context
        theReport: Message_Report (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        Add-on for the *issplittoreverse()* to check for its errors and in case of any add the *bopalgo_alertunabletoorienttheshape* warning to the report.

        """
        return _BOPTools.BOPTools_AlgoTools_IsSplitToReverseWithWarn(*args)

    @staticmethod
    def MakeConnexityBlock(*args):
        r"""

        Parameters
        ----------
        theLS: TopTools_ListOfShape
        theMapAvoid: TopTools_IndexedMapOfShape
        theLSCB: TopTools_ListOfShape
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        For the list of faces thels build block thelscb in terms of connexity by edges themapavoid - set of edges to avoid for the treatment.

        """
        return _BOPTools.BOPTools_AlgoTools_MakeConnexityBlock(*args)

    @staticmethod
    def MakeConnexityBlocks(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theConnectionType: TopAbs_ShapeEnum
        theElementType: TopAbs_ShapeEnum
        theLCB: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        For the compound <thes> builds the blocks (compounds) of elements of type <theelementtype> connected through the shapes of the type <theconnectiontype>. the blocks are stored into the list <thelcb>.

        Parameters
        ----------
        theS: TopoDS_Shape
        theConnectionType: TopAbs_ShapeEnum
        theElementType: TopAbs_ShapeEnum
        theLCB: TopTools_ListOfListOfShape
        theConnectionMap: TopTools_IndexedDataMapOfShapeListOfShape

        Return
        -------
        None

        Description
        -----------
        For the compound <thes> builds the blocks (compounds) of elements of type <theelementtype> connected through the shapes of the type <theconnectiontype>. the blocks are stored into the list of lists <thelcb>. returns also the connection map <theconnectionmap>, filled during operation.

        Parameters
        ----------
        theLS: TopTools_ListOfShape
        theConnectionType: TopAbs_ShapeEnum
        theElementType: TopAbs_ShapeEnum
        theLCB: BOPTools_ListOfConnexityBlock

        Return
        -------
        None

        Description
        -----------
        Makes connexity blocks of elements of the given type with the given type of the connecting elements. the blocks are checked on regularity (multi-connectivity) and stored to the list of blocks <thelcb>.

        """
        return _BOPTools.BOPTools_AlgoTools_MakeConnexityBlocks(*args)

    @staticmethod
    def MakeContainer(*args):
        r"""

        Parameters
        ----------
        theType: TopAbs_ShapeEnum
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Makes empty container of requested type.

        """
        return _BOPTools.BOPTools_AlgoTools_MakeContainer(*args)

    @staticmethod
    def MakeEdge(*args):
        r"""

        Parameters
        ----------
        theCurve: IntTools_Curve
        theV1: TopoDS_Vertex
        theT1: float
        theV2: TopoDS_Vertex
        theT2: float
        theTolR3D: float
        theE: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Makes the edge based on the given curve with given bounding vertices.

        """
        return _BOPTools.BOPTools_AlgoTools_MakeEdge(*args)

    @staticmethod
    def MakeNewVertex(*args):
        r"""

        Parameters
        ----------
        aP1: gp_Pnt
        aTol: float
        aNewVertex: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Make a vertex using 3d-point <ap1> and 3d-tolerance value <atol>.

        Parameters
        ----------
        aV1: TopoDS_Vertex
        aV2: TopoDS_Vertex
        aNewVertex: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Make a vertex using couple of vertices <av1, av2>.

        Parameters
        ----------
        aE1: TopoDS_Edge
        aP1: float
        aE2: TopoDS_Edge
        aP2: float
        aNewVertex: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Make a vertex in place of intersection between two edges <ae1, ae2> with parameters <ap1, ap2>.

        Parameters
        ----------
        aE1: TopoDS_Edge
        aP1: float
        aF2: TopoDS_Face
        aNewVertex: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Make a vertex in place of intersection between the edge <ae1> with parameter <ap1> and the face <af2>.

        """
        return _BOPTools.BOPTools_AlgoTools_MakeNewVertex(*args)

    @staticmethod
    def MakePCurve(*args):
        r"""

        Parameters
        ----------
        theE: TopoDS_Edge
        theF1: TopoDS_Face
        theF2: TopoDS_Face
        theCurve: IntTools_Curve
        thePC1: bool
        thePC2: bool
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        None

        Description
        -----------
        Makes 2d curve of the edge <thee> on the faces <thef1> and <thef2>. <thecontext> - storage for caching the geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools_MakePCurve(*args)

    @staticmethod
    def MakeSectEdge(*args):
        r"""

        Parameters
        ----------
        aIC: IntTools_Curve
        aV1: TopoDS_Vertex
        aP1: float
        aV2: TopoDS_Vertex
        aP2: float
        aNewEdge: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Make the edge from 3d-curve <aic> and two vertices <av1,av2> at parameters <ap1,ap2>.

        """
        return _BOPTools.BOPTools_AlgoTools_MakeSectEdge(*args)

    @staticmethod
    def MakeSplitEdge(*args):
        r"""

        Parameters
        ----------
        aE1: TopoDS_Edge
        aV1: TopoDS_Vertex
        aP1: float
        aV2: TopoDS_Vertex
        aP2: float
        aNewEdge: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Make the edge from base edge <ae1> and two vertices <av1,av2> at parameters <ap1,ap2>.

        """
        return _BOPTools.BOPTools_AlgoTools_MakeSplitEdge(*args)

    @staticmethod
    def MakeVertex(*args):
        r"""

        Parameters
        ----------
        theLV: TopTools_ListOfShape
        theV: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Makes the vertex in the middle of given vertices with the tolerance covering all tolerance spheres of vertices.

        """
        return _BOPTools.BOPTools_AlgoTools_MakeVertex(*args)

    @staticmethod
    def OrientEdgesOnWire(*args):
        r"""

        Parameters
        ----------
        theWire: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Correctly orients edges on the wire.

        """
        return _BOPTools.BOPTools_AlgoTools_OrientEdgesOnWire(*args)

    @staticmethod
    def OrientFacesOnShell(*args):
        r"""

        Parameters
        ----------
        theShell: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Correctly orients faces on the shell.

        """
        return _BOPTools.BOPTools_AlgoTools_OrientFacesOnShell(*args)

    @staticmethod
    def PointOnEdge(*args):
        r"""

        Parameters
        ----------
        aEdge: TopoDS_Edge
        aPrm: float
        aP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Compute a 3d-point on the edge <aedge> at parameter <aprm>.

        """
        return _BOPTools.BOPTools_AlgoTools_PointOnEdge(*args)

    @staticmethod
    def Sense(*args):
        r"""

        Parameters
        ----------
        theF1: TopoDS_Face
        theF2: TopoDS_Face
        theContext: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Checks if the normals direction of the given faces computed near the shared edge coincide. returns the status of operation: * 0 - in case of error (shared edge not found or directions are not collinear) * 1 - normal directions coincide; * -1 - normal directions are opposite.

        """
        return _BOPTools.BOPTools_AlgoTools_Sense(*args)

    @staticmethod
    def TreatCompound(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theList: TopTools_ListOfShape
        theMap: TopTools_MapOfShape * (optional, default to NULL)

        Return
        -------
        None

        Description
        -----------
        Collects in the output list recursively all non-compound sub-shapes of the first level of the given shape thes. the optional map themap is used to avoid the duplicates in the output list, so it will also contain all non-compound sub-shapes.

        """
        return _BOPTools.BOPTools_AlgoTools_TreatCompound(*args)

    @staticmethod
    def UpdateVertex(*args):
        r"""

        Parameters
        ----------
        aIC: IntTools_Curve
        aT: float
        aV: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Update the tolerance value for vertex <av> taking into account the fact that <av> lays on the curve <aic>.

        Parameters
        ----------
        aE: TopoDS_Edge
        aT: float
        aV: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Update the tolerance value for vertex <av> taking into account the fact that <av> lays on the edge <ae>.

        Parameters
        ----------
        aVF: TopoDS_Vertex
        aVN: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Update the tolerance value for vertex <avn> taking into account the fact that <avn> should cover tolerance zone of <avf>.

        """
        return _BOPTools.BOPTools_AlgoTools_UpdateVertex(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BOPTools.BOPTools_AlgoTools_swiginit(self, _BOPTools.new_BOPTools_AlgoTools())
    __swig_destroy__ = _BOPTools.delete_BOPTools_AlgoTools

# Register BOPTools_AlgoTools in _BOPTools:
_BOPTools.BOPTools_AlgoTools_swigregister(BOPTools_AlgoTools)
class BOPTools_AlgoTools2D(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def AdjustPCurveOnFace(*args):
        r"""

        Parameters
        ----------
        theF: TopoDS_Face
        theC3D: Geom_Curve
        theC2D: Geom2d_Curve
        theC2DA: Geom2d_Curve
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        None

        Description
        -----------
        Adjust p-curve <thec2d> (3d-curve <thec3d>) on surface of the face <thef>. <thecontext> - storage for caching the geometrical tools.

        Parameters
        ----------
        theF: TopoDS_Face
        theFirst: float
        theLast: float
        theC2D: Geom2d_Curve
        theC2DA: Geom2d_Curve
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        None

        Description
        -----------
        Adjust p-curve <ac2d> (3d-curve <c3d>) on surface <af> . [at1, at2] - range to adjust <thecontext> - storage for caching the geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools2D_AdjustPCurveOnFace(*args)

    @staticmethod
    def AdjustPCurveOnSurf(*args):
        r"""

        Parameters
        ----------
        aF: BRepAdaptor_Surface
        aT1: float
        aT2: float
        aC2D: Geom2d_Curve
        aC2DA: Geom2d_Curve

        Return
        -------
        None

        Description
        -----------
        Adjust p-curve <ac2d> (3d-curve <c3d>) on surface <af> . [at1, at2] - range to adjust.

        """
        return _BOPTools.BOPTools_AlgoTools2D_AdjustPCurveOnSurf(*args)

    @staticmethod
    def AttachExistingPCurve(*args):
        r"""

        Parameters
        ----------
        aEold: TopoDS_Edge
        aEnew: TopoDS_Edge
        aF: TopoDS_Face
        aCtx: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Attach p-curve from the edge <aeold> on surface <af> to the edge <aenew> returns 0 in case of success.

        """
        return _BOPTools.BOPTools_AlgoTools2D_AttachExistingPCurve(*args)

    @staticmethod
    def BuildPCurveForEdgeOnFace(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        None

        Description
        -----------
        Compute p-curve for the edge <ae> on the face <af>. raises exception standard_constructionerror if projection algorithm fails. <thecontext> - storage for caching the geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools2D_BuildPCurveForEdgeOnFace(*args)

    @staticmethod
    def CurveOnSurface(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aC: Geom2d_Curve
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        aToler: float

        Description
        -----------
        Get p-curve <ac> for the edge <ae> on surface <af> . if the p-curve does not exist, build it using make2d(). [atoler] - reached tolerance raises exception standard_constructionerror if algorithm make2d() fails. <thecontext> - storage for caching the geometrical tools.

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aC: Geom2d_Curve
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        aFirst: float
        aLast: float
        aToler: float

        Description
        -----------
        Get p-curve <ac> for the edge <ae> on surface <af> . if the p-curve does not exist, build it using make2d(). [afirst, alast] - range of the p-curve [atoler] - reached tolerance raises exception standard_constructionerror if algorithm make2d() fails. <thecontext> - storage for caching the geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools2D_CurveOnSurface(*args)

    @staticmethod
    def EdgeTangent(*args):
        r"""

        Parameters
        ----------
        anE: TopoDS_Edge
        aT: float
        Tau: gp_Vec

        Return
        -------
        bool

        Description
        -----------
        Compute tangent for the edge <ae> [in 3d] at parameter <at>.

        """
        return _BOPTools.BOPTools_AlgoTools2D_EdgeTangent(*args)

    @staticmethod
    def HasCurveOnSurface(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aC: Geom2d_Curve

        Return
        -------
        aFirst: float
        aLast: float
        aToler: float

        Description
        -----------
        Returns true if the edge <ae> has p-curve <ac> on surface <af> . [afirst, alast] - range of the p-curve [atoler] - reached tolerance if the p-curve does not exist, ac.isnull()=true.

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        Returns true if the edge <ae> has p-curve <ac> on surface <af> . if the p-curve does not exist, ac.isnull()=true.

        """
        return _BOPTools.BOPTools_AlgoTools2D_HasCurveOnSurface(*args)

    @staticmethod
    def IntermediatePoint(*args):
        r"""

        Parameters
        ----------
        aFirst: float
        aLast: float

        Return
        -------
        float

        Description
        -----------
        Compute intermediate value in between [afirst, alast] .

        Parameters
        ----------
        anE: TopoDS_Edge

        Return
        -------
        float

        Description
        -----------
        Compute intermediate value of parameter for the edge <ane>.

        """
        return _BOPTools.BOPTools_AlgoTools2D_IntermediatePoint(*args)

    @staticmethod
    def IsEdgeIsoline(*args):
        r"""

        Parameters
        ----------
        theE: TopoDS_Edge
        theF: TopoDS_Face

        Return
        -------
        isTheUIso: bool
        isTheVIso: bool

        Description
        -----------
        Checks if curveonsurface of thee on thef matches with isoline of thef surface. sets corresponding values for istheuiso and istheviso variables. //! attention!!! this method is based on the comparison between direction of surface (which thef is based on) iso-lines and the direction of the edge p-curve (on thef) in middle-point of the p-curve. //! this method should be used carefully (e.g. brep_tool::isclosed(...) together) in order to avoid false classification some p-curves as isoline (e.g. circle on a plane).

        """
        return _BOPTools.BOPTools_AlgoTools2D_IsEdgeIsoline(*args)

    @staticmethod
    def Make2D(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aC: Geom2d_Curve
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        aFirst: float
        aLast: float
        aToler: float

        Description
        -----------
        Make p-curve <ac> for the edge <ae> on surface <af> . [afirst, alast] - range of the p-curve [atoler] - reached tolerance raises exception standard_constructionerror if algorithm fails. <thecontext> - storage for caching the geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools2D_Make2D(*args)

    @staticmethod
    def MakePCurveOnFace(*args):
        r"""

        Parameters
        ----------
        aF: TopoDS_Face
        C3D: Geom_Curve
        aC: Geom2d_Curve
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        aToler: float

        Description
        -----------
        Make p-curve <ac> for the 3d-curve <c3d> on surface <af> . [atoler] - reached tolerance raises exception standard_constructionerror if projection algorithm fails. <thecontext> - storage for caching the geometrical tools.

        Parameters
        ----------
        aF: TopoDS_Face
        C3D: Geom_Curve
        aT1: float
        aT2: float
        aC: Geom2d_Curve
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        aToler: float

        Description
        -----------
        Make p-curve <ac> for the 3d-curve <c3d> on surface <af> . [at1, at2] - range to build [atoler] - reached tolerance raises exception standard_constructionerror if projection algorithm fails. <thecontext> - storage for caching the geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools2D_MakePCurveOnFace(*args)

    @staticmethod
    def PointOnSurface(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aT: float
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        U: float
        V: float

        Description
        -----------
        Compute surface parameters <u,v> of the face <af> for the point from the edge <ae> at parameter <at>. if <ae> has't pcurve on surface, algorithm tries to get it by projection and can raise exception standard_constructionerror if projection algorithm fails. <thecontext> - storage for caching the geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools2D_PointOnSurface(*args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def MakeCurveOnSurface(self):
    	pass


    def __init__(self):
        _BOPTools.BOPTools_AlgoTools2D_swiginit(self, _BOPTools.new_BOPTools_AlgoTools2D())
    __swig_destroy__ = _BOPTools.delete_BOPTools_AlgoTools2D

# Register BOPTools_AlgoTools2D in _BOPTools:
_BOPTools.BOPTools_AlgoTools2D_swigregister(BOPTools_AlgoTools2D)
class BOPTools_AlgoTools3D(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def DoSplitSEAMOnFace(*args):
        r"""

        Parameters
        ----------
        theESplit: TopoDS_Edge
        theFace: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        Makes the edge <theesplit> seam edge for the face <theface> basing on the surface properties (u and v periods).

        Parameters
        ----------
        theEOrigin: TopoDS_Edge
        theESplit: TopoDS_Edge
        theFace: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        Makes the split edge <theesplit> seam edge for the face <theface> basing on the positions of 2d curves of the original edge <theeorigin>.

        """
        return _BOPTools.BOPTools_AlgoTools3D_DoSplitSEAMOnFace(*args)

    @staticmethod
    def GetApproxNormalToFaceOnEdge(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aT: float
        aPx: gp_Pnt
        aD: gp_Dir
        theContext: IntTools_Context

        Return
        -------
        bool

        Description
        -----------
        Computes normal to the face <af> for the 3d-point that belongs to the edge <ae> at parameter <at>. output: apx - the 3d-point where the normal computed ad - the normal; warning: the normal is computed not exactly in the point on the edge, but in point that is near to the edge towards to the face material (so, we'll have approx. normal); the point is computed using pointnearedge function, with the shifting value boptools_algotools3d::minstepin2d(), from the edge, but if this value is too big, the point will be computed using hatcher (pointinface function). returns true in case of success.

        Parameters
        ----------
        theE: TopoDS_Edge
        theF: TopoDS_Face
        aT: float
        aP: gp_Pnt
        aDNF: gp_Dir
        aDt2D: float

        Return
        -------
        bool

        Description
        -----------
        Computes normal to the face <af> for the 3d-point that belongs to the edge <ae> at parameter <at>. output: apx - the 3d-point where the normal computed ad - the normal; warning: the normal is computed not exactly in the point on the edge, but in point that is near to the edge towards to the face material (so, we'll have approx. normal); the point is computed using pointnearedge function with the shifting value <adt2d> from the edge; no checks on this value will be done. returns true in case of success.

        Parameters
        ----------
        theE: TopoDS_Edge
        theF: TopoDS_Face
        aT: float
        aDt2D: float
        aP: gp_Pnt
        aDNF: gp_Dir
        theContext: IntTools_Context

        Return
        -------
        bool

        Description
        -----------
        Computes normal to the face <af> for the 3d-point that belongs to the edge <ae> at parameter <at>. output: apx - the 3d-point where the normal computed ad - the normal; warning: the normal is computed not exactly in the point on the edge, but in point that is near to the edge towards to the face material (so, we'll have approx. normal); the point is computed using pointnearedge function with the shifting value <adt2d> from the edge, but if this value is too big the point will be computed using hatcher (pointinface function). returns true in case of success.

        """
        return _BOPTools.BOPTools_AlgoTools3D_GetApproxNormalToFaceOnEdge(*args)

    @staticmethod
    def GetNormalToFaceOnEdge(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aT: float
        aD: gp_Dir
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        None

        Description
        -----------
        Computes normal to the face <af> for the point on the edge <ae> at parameter <at>. <thecontext> - storage for caching the geometrical tools.

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aD: gp_Dir
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        None

        Description
        -----------
        Computes normal to the face <af> for the point on the edge <ae> at arbitrary intermediate parameter. <thecontext> - storage for caching the geometrical tools.

        """
        return _BOPTools.BOPTools_AlgoTools3D_GetNormalToFaceOnEdge(*args)

    @staticmethod
    def GetNormalToSurface(*args):
        r"""

        Parameters
        ----------
        aS: Geom_Surface
        U: float
        V: float
        aD: gp_Dir

        Return
        -------
        bool

        Description
        -----------
        Compute normal <ad> to surface <as> in point (u,v) returns true if directions ad1u, ad1v coincide.

        """
        return _BOPTools.BOPTools_AlgoTools3D_GetNormalToSurface(*args)

    @staticmethod
    def IsEmptyShape(*args):
        r"""

        Parameters
        ----------
        aS: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns true if the shape <as> does not contain geometry information (e.g. empty compound).

        """
        return _BOPTools.BOPTools_AlgoTools3D_IsEmptyShape(*args)

    @staticmethod
    def MinStepIn2d(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns simple step value that is used in 2d-computations = 1.e-5.

        """
        return _BOPTools.BOPTools_AlgoTools3D_MinStepIn2d(*args)

    @staticmethod
    def OrientEdgeOnFace(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aER: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Get the edge <aer> from the face <af> that is the same as the edge <ae>.

        """
        return _BOPTools.BOPTools_AlgoTools3D_OrientEdgeOnFace(*args)

    @staticmethod
    def PointInFace(*args):
        r"""

        Parameters
        ----------
        theF: TopoDS_Face
        theP: gp_Pnt
        theP2D: gp_Pnt2d
        theContext: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Computes arbitrary point <thep> inside the face <thef>. <thep2d> - 2d representation of <thep> on the surface of <thef> returns 0 in case of success.

        Parameters
        ----------
        theF: TopoDS_Face
        theE: TopoDS_Edge
        theT: float
        theDt2D: float
        theP: gp_Pnt
        theP2D: gp_Pnt2d
        theContext: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Computes a point <thep> inside the face <thef> using starting point taken by the parameter <thet> from the 2d curve of the edge <thee> on the face <thef> in the direction perpendicular to the tangent vector of the 2d curve of the edge. the point will be distanced on <thedt2d> from the 2d curve. <thep2d> - 2d representation of <thep> on the surface of <thef> returns 0 in case of success.

        Parameters
        ----------
        theF: TopoDS_Face
        theL: Geom2d_Curve
        theP: gp_Pnt
        theP2D: gp_Pnt2d
        theContext: IntTools_Context
        theDt2D: float (optional, default to 0.0)

        Return
        -------
        int

        Description
        -----------
        Computes a point <thep> inside the face <thef> using the line <thel> so that 2d point <thep2d>, 2d representation of <thep> on the surface of <thef>, lies on that line. returns 0 in case of success.

        """
        return _BOPTools.BOPTools_AlgoTools3D_PointInFace(*args)

    @staticmethod
    def PointNearEdge(*args):
        r"""

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aT: float
        aDt2D: float
        aP2D: gp_Pnt2d
        aPx: gp_Pnt
        theContext: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Compute the point <apx>, (<ap2d>) that is near to the edge <ae> at parameter <at> towards to the material of the face <af>. the value of shifting in 2d is <adt2d> if the value of shifting is too big the point will be computed using hatcher (pointinface function). returns error status: 0 - in case of success; 1 - <ae> does not have 2d curve on the face <af>; 2 - the computed point is out of the face.

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aT: float
        aDt2D: float
        aP2D: gp_Pnt2d
        aPx: gp_Pnt

        Return
        -------
        int

        Description
        -----------
        Compute the point <apx>, (<ap2d>) that is near to the edge <ae> at parameter <at> towards to the material of the face <af>. the value of shifting in 2d is <adt2d>. no checks on this value will be done. returns error status: 0 - in case of success; 1 - <ae> does not have 2d curve on the face <af>.

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aT: float
        aP2D: gp_Pnt2d
        aPx: gp_Pnt
        theContext: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Computes the point <apx>, (<ap2d>) that is near to the edge <ae> at parameter <at> towards to the material of the face <af>. the value of shifting in 2d is dt2d=boptools_algotools3d::minstepin2d() if the value of shifting is too big the point will be computed using hatcher (pointinface function). returns error status: 0 - in case of success; 1 - <ae> does not have 2d curve on the face <af>; 2 - the computed point is out of the face.

        Parameters
        ----------
        aE: TopoDS_Edge
        aF: TopoDS_Face
        aP2D: gp_Pnt2d
        aPx: gp_Pnt
        theContext: IntTools_Context

        Return
        -------
        int

        Description
        -----------
        Compute the point <apx>, (<ap2d>) that is near to the edge <ae> at arbitrary parameter towards to the material of the face <af>. the value of shifting in 2d is dt2d=boptools_algotools3d::minstepin2d(). if the value of shifting is too big the point will be computed using hatcher (pointinface function). returns error status: 0 - in case of success; 1 - <ae> does not have 2d curve on the face <af>; 2 - the computed point is out of the face.

        """
        return _BOPTools.BOPTools_AlgoTools3D_PointNearEdge(*args)

    @staticmethod
    def SenseFlag(*args):
        r"""

        Parameters
        ----------
        aNF1: gp_Dir
        aNF2: gp_Dir

        Return
        -------
        int

        Description
        -----------
        Returns 1 if scalar product anf1* anf2>0. returns 0 if directions anf1 anf2 coincide returns -1 if scalar product anf1* anf2<0.

        """
        return _BOPTools.BOPTools_AlgoTools3D_SenseFlag(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BOPTools.BOPTools_AlgoTools3D_swiginit(self, _BOPTools.new_BOPTools_AlgoTools3D())
    __swig_destroy__ = _BOPTools.delete_BOPTools_AlgoTools3D

# Register BOPTools_AlgoTools3D in _BOPTools:
_BOPTools.BOPTools_AlgoTools3D_swigregister(BOPTools_AlgoTools3D)
class BOPTools_ConnexityBlock(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPTools.BOPTools_ConnexityBlock_swiginit(self, _BOPTools.new_BOPTools_ConnexityBlock(*args))

    def ChangeLoops(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_ConnexityBlock_ChangeLoops(self, *args)

    def ChangeShapes(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_ConnexityBlock_ChangeShapes(self, *args)

    def IsRegular(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_ConnexityBlock_IsRegular(self, *args)

    def Loops(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_ConnexityBlock_Loops(self, *args)

    def SetRegular(self, *args):
        r"""

        Parameters
        ----------
        theFlag: bool

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_ConnexityBlock_SetRegular(self, *args)

    def Shapes(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_ConnexityBlock_Shapes(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPTools.delete_BOPTools_ConnexityBlock

# Register BOPTools_ConnexityBlock in _BOPTools:
_BOPTools.BOPTools_ConnexityBlock_swigregister(BOPTools_ConnexityBlock)
class BOPTools_CoupleOfShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPTools.BOPTools_CoupleOfShape_swiginit(self, _BOPTools.new_BOPTools_CoupleOfShape(*args))

    def SetShape1(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_CoupleOfShape_SetShape1(self, *args)

    def SetShape2(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_CoupleOfShape_SetShape2(self, *args)

    def Shape1(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_CoupleOfShape_Shape1(self, *args)

    def Shape2(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_CoupleOfShape_Shape2(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPTools.delete_BOPTools_CoupleOfShape

# Register BOPTools_CoupleOfShape in _BOPTools:
_BOPTools.BOPTools_CoupleOfShape_swigregister(BOPTools_CoupleOfShape)
class BOPTools_Set(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theOther: BOPTools_Set

        Return
        -------
        None

        Description
        -----------
        Copy constructor.

        """
        _BOPTools.BOPTools_Set_swiginit(self, _BOPTools.new_BOPTools_Set(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theType: TopAbs_ShapeEnum

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_Set_Add(self, *args)

    def Assign(self, *args):
        r"""

        Parameters
        ----------
        Other: BOPTools_Set

        Return
        -------
        BOPTools_Set

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_Set_Assign(self, *args)

    def HashCode(self, *args):
        r"""

        Parameters
        ----------
        theUpperBound: int

        Return
        -------
        int

        Description
        -----------
        Computes a hash code for this set, in the range [1, theupperbound] @param theupperbound the upper bound of the range a computing hash code must be within return a computed hash code, in the range [1, theupperbound].

        """
        return _BOPTools.BOPTools_Set_HashCode(self, *args)

    def __hash__(self):
        return _BOPTools.BOPTools_Set___hash__(self)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        aOther: BOPTools_Set

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_Set_IsEqual(self, *args)

    def NbShapes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_Set_NbShapes(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_Set_Shape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPTools.delete_BOPTools_Set

# Register BOPTools_Set in _BOPTools:
_BOPTools.BOPTools_Set_swigregister(BOPTools_Set)
class BOPTools_SetMapHasher(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def HashCode(*args):
        r"""

        Parameters
        ----------
        theSet: BOPTools_Set
        theUpperBound: int

        Return
        -------
        int

        Description
        -----------
        Computes a hash code for the given set, in the range [1, theupperbound] @param theset the set which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within return a computed hash code, in the range [1, theupperbound].

        """
        return _BOPTools.BOPTools_SetMapHasher_HashCode(*args)

    @staticmethod
    def IsEqual(*args):
        r"""

        Parameters
        ----------
        aSet1: BOPTools_Set
        aSet2: BOPTools_Set

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BOPTools.BOPTools_SetMapHasher_IsEqual(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BOPTools.BOPTools_SetMapHasher_swiginit(self, _BOPTools.new_BOPTools_SetMapHasher())
    __swig_destroy__ = _BOPTools.delete_BOPTools_SetMapHasher

# Register BOPTools_SetMapHasher in _BOPTools:
_BOPTools.BOPTools_SetMapHasher_swigregister(BOPTools_SetMapHasher)

@classnotwrapped
class BOPTools_Parallel:
	pass

@classnotwrapped
class BOPTools_BoxSelector:
	pass

@classnotwrapped
class BOPTools_BoxSet:
	pass

@classnotwrapped
class BOPTools_PairSelector:
	pass





@deprecated
def BOPTools_AlgoTools_AreFacesSameDomain(*args):
	return BOPTools_AlgoTools.AreFacesSameDomain(*args)

@deprecated
def BOPTools_AlgoTools_ComputeState(*args):
	return BOPTools_AlgoTools.ComputeState(*args)

@deprecated
def BOPTools_AlgoTools_ComputeState(*args):
	return BOPTools_AlgoTools.ComputeState(*args)

@deprecated
def BOPTools_AlgoTools_ComputeState(*args):
	return BOPTools_AlgoTools.ComputeState(*args)

@deprecated
def BOPTools_AlgoTools_ComputeState(*args):
	return BOPTools_AlgoTools.ComputeState(*args)

@deprecated
def BOPTools_AlgoTools_ComputeStateByOnePoint(*args):
	return BOPTools_AlgoTools.ComputeStateByOnePoint(*args)

@deprecated
def BOPTools_AlgoTools_ComputeTolerance(*args):
	return BOPTools_AlgoTools.ComputeTolerance(*args)

@deprecated
def BOPTools_AlgoTools_ComputeVV(*args):
	return BOPTools_AlgoTools.ComputeVV(*args)

@deprecated
def BOPTools_AlgoTools_ComputeVV(*args):
	return BOPTools_AlgoTools.ComputeVV(*args)

@deprecated
def BOPTools_AlgoTools_CopyEdge(*args):
	return BOPTools_AlgoTools.CopyEdge(*args)

@deprecated
def BOPTools_AlgoTools_CorrectCurveOnSurface(*args):
	return BOPTools_AlgoTools.CorrectCurveOnSurface(*args)

@deprecated
def BOPTools_AlgoTools_CorrectPointOnCurve(*args):
	return BOPTools_AlgoTools.CorrectPointOnCurve(*args)

@deprecated
def BOPTools_AlgoTools_CorrectRange(*args):
	return BOPTools_AlgoTools.CorrectRange(*args)

@deprecated
def BOPTools_AlgoTools_CorrectRange(*args):
	return BOPTools_AlgoTools.CorrectRange(*args)

@deprecated
def BOPTools_AlgoTools_CorrectShapeTolerances(*args):
	return BOPTools_AlgoTools.CorrectShapeTolerances(*args)

@deprecated
def BOPTools_AlgoTools_CorrectTolerances(*args):
	return BOPTools_AlgoTools.CorrectTolerances(*args)

@deprecated
def BOPTools_AlgoTools_DTolerance(*args):
	return BOPTools_AlgoTools.DTolerance(*args)

@deprecated
def BOPTools_AlgoTools_Dimension(*args):
	return BOPTools_AlgoTools.Dimension(*args)

@deprecated
def BOPTools_AlgoTools_Dimensions(*args):
	return BOPTools_AlgoTools.Dimensions(*args)

@deprecated
def BOPTools_AlgoTools_GetEdgeOff(*args):
	return BOPTools_AlgoTools.GetEdgeOff(*args)

@deprecated
def BOPTools_AlgoTools_GetEdgeOnFace(*args):
	return BOPTools_AlgoTools.GetEdgeOnFace(*args)

@deprecated
def BOPTools_AlgoTools_GetFaceOff(*args):
	return BOPTools_AlgoTools.GetFaceOff(*args)

@deprecated
def BOPTools_AlgoTools_IsBlockInOnFace(*args):
	return BOPTools_AlgoTools.IsBlockInOnFace(*args)

@deprecated
def BOPTools_AlgoTools_IsHole(*args):
	return BOPTools_AlgoTools.IsHole(*args)

@deprecated
def BOPTools_AlgoTools_IsInternalFace(*args):
	return BOPTools_AlgoTools.IsInternalFace(*args)

@deprecated
def BOPTools_AlgoTools_IsInternalFace(*args):
	return BOPTools_AlgoTools.IsInternalFace(*args)

@deprecated
def BOPTools_AlgoTools_IsInternalFace(*args):
	return BOPTools_AlgoTools.IsInternalFace(*args)

@deprecated
def BOPTools_AlgoTools_IsInvertedSolid(*args):
	return BOPTools_AlgoTools.IsInvertedSolid(*args)

@deprecated
def BOPTools_AlgoTools_IsMicroEdge(*args):
	return BOPTools_AlgoTools.IsMicroEdge(*args)

@deprecated
def BOPTools_AlgoTools_IsOpenShell(*args):
	return BOPTools_AlgoTools.IsOpenShell(*args)

@deprecated
def BOPTools_AlgoTools_IsSplitToReverse(*args):
	return BOPTools_AlgoTools.IsSplitToReverse(*args)

@deprecated
def BOPTools_AlgoTools_IsSplitToReverse(*args):
	return BOPTools_AlgoTools.IsSplitToReverse(*args)

@deprecated
def BOPTools_AlgoTools_IsSplitToReverse(*args):
	return BOPTools_AlgoTools.IsSplitToReverse(*args)

@deprecated
def BOPTools_AlgoTools_IsSplitToReverseWithWarn(*args):
	return BOPTools_AlgoTools.IsSplitToReverseWithWarn(*args)

@deprecated
def BOPTools_AlgoTools_MakeConnexityBlock(*args):
	return BOPTools_AlgoTools.MakeConnexityBlock(*args)

@deprecated
def BOPTools_AlgoTools_MakeConnexityBlocks(*args):
	return BOPTools_AlgoTools.MakeConnexityBlocks(*args)

@deprecated
def BOPTools_AlgoTools_MakeConnexityBlocks(*args):
	return BOPTools_AlgoTools.MakeConnexityBlocks(*args)

@deprecated
def BOPTools_AlgoTools_MakeConnexityBlocks(*args):
	return BOPTools_AlgoTools.MakeConnexityBlocks(*args)

@deprecated
def BOPTools_AlgoTools_MakeContainer(*args):
	return BOPTools_AlgoTools.MakeContainer(*args)

@deprecated
def BOPTools_AlgoTools_MakeEdge(*args):
	return BOPTools_AlgoTools.MakeEdge(*args)

@deprecated
def BOPTools_AlgoTools_MakeNewVertex(*args):
	return BOPTools_AlgoTools.MakeNewVertex(*args)

@deprecated
def BOPTools_AlgoTools_MakeNewVertex(*args):
	return BOPTools_AlgoTools.MakeNewVertex(*args)

@deprecated
def BOPTools_AlgoTools_MakeNewVertex(*args):
	return BOPTools_AlgoTools.MakeNewVertex(*args)

@deprecated
def BOPTools_AlgoTools_MakeNewVertex(*args):
	return BOPTools_AlgoTools.MakeNewVertex(*args)

@deprecated
def BOPTools_AlgoTools_MakePCurve(*args):
	return BOPTools_AlgoTools.MakePCurve(*args)

@deprecated
def BOPTools_AlgoTools_MakeSectEdge(*args):
	return BOPTools_AlgoTools.MakeSectEdge(*args)

@deprecated
def BOPTools_AlgoTools_MakeSplitEdge(*args):
	return BOPTools_AlgoTools.MakeSplitEdge(*args)

@deprecated
def BOPTools_AlgoTools_MakeVertex(*args):
	return BOPTools_AlgoTools.MakeVertex(*args)

@deprecated
def BOPTools_AlgoTools_OrientEdgesOnWire(*args):
	return BOPTools_AlgoTools.OrientEdgesOnWire(*args)

@deprecated
def BOPTools_AlgoTools_OrientFacesOnShell(*args):
	return BOPTools_AlgoTools.OrientFacesOnShell(*args)

@deprecated
def BOPTools_AlgoTools_PointOnEdge(*args):
	return BOPTools_AlgoTools.PointOnEdge(*args)

@deprecated
def BOPTools_AlgoTools_Sense(*args):
	return BOPTools_AlgoTools.Sense(*args)

@deprecated
def BOPTools_AlgoTools_TreatCompound(*args):
	return BOPTools_AlgoTools.TreatCompound(*args)

@deprecated
def BOPTools_AlgoTools_UpdateVertex(*args):
	return BOPTools_AlgoTools.UpdateVertex(*args)

@deprecated
def BOPTools_AlgoTools_UpdateVertex(*args):
	return BOPTools_AlgoTools.UpdateVertex(*args)

@deprecated
def BOPTools_AlgoTools_UpdateVertex(*args):
	return BOPTools_AlgoTools.UpdateVertex(*args)

@deprecated
def BOPTools_AlgoTools2D_AdjustPCurveOnFace(*args):
	return BOPTools_AlgoTools2D.AdjustPCurveOnFace(*args)

@deprecated
def BOPTools_AlgoTools2D_AdjustPCurveOnFace(*args):
	return BOPTools_AlgoTools2D.AdjustPCurveOnFace(*args)

@deprecated
def BOPTools_AlgoTools2D_AdjustPCurveOnSurf(*args):
	return BOPTools_AlgoTools2D.AdjustPCurveOnSurf(*args)

@deprecated
def BOPTools_AlgoTools2D_AttachExistingPCurve(*args):
	return BOPTools_AlgoTools2D.AttachExistingPCurve(*args)

@deprecated
def BOPTools_AlgoTools2D_BuildPCurveForEdgeOnFace(*args):
	return BOPTools_AlgoTools2D.BuildPCurveForEdgeOnFace(*args)

@deprecated
def BOPTools_AlgoTools2D_CurveOnSurface(*args):
	return BOPTools_AlgoTools2D.CurveOnSurface(*args)

@deprecated
def BOPTools_AlgoTools2D_CurveOnSurface(*args):
	return BOPTools_AlgoTools2D.CurveOnSurface(*args)

@deprecated
def BOPTools_AlgoTools2D_EdgeTangent(*args):
	return BOPTools_AlgoTools2D.EdgeTangent(*args)

@deprecated
def BOPTools_AlgoTools2D_HasCurveOnSurface(*args):
	return BOPTools_AlgoTools2D.HasCurveOnSurface(*args)

@deprecated
def BOPTools_AlgoTools2D_HasCurveOnSurface(*args):
	return BOPTools_AlgoTools2D.HasCurveOnSurface(*args)

@deprecated
def BOPTools_AlgoTools2D_IntermediatePoint(*args):
	return BOPTools_AlgoTools2D.IntermediatePoint(*args)

@deprecated
def BOPTools_AlgoTools2D_IntermediatePoint(*args):
	return BOPTools_AlgoTools2D.IntermediatePoint(*args)

@deprecated
def BOPTools_AlgoTools2D_IsEdgeIsoline(*args):
	return BOPTools_AlgoTools2D.IsEdgeIsoline(*args)

@deprecated
def BOPTools_AlgoTools2D_Make2D(*args):
	return BOPTools_AlgoTools2D.Make2D(*args)

@deprecated
def BOPTools_AlgoTools2D_MakePCurveOnFace(*args):
	return BOPTools_AlgoTools2D.MakePCurveOnFace(*args)

@deprecated
def BOPTools_AlgoTools2D_MakePCurveOnFace(*args):
	return BOPTools_AlgoTools2D.MakePCurveOnFace(*args)

@deprecated
def BOPTools_AlgoTools2D_PointOnSurface(*args):
	return BOPTools_AlgoTools2D.PointOnSurface(*args)

@deprecated
def BOPTools_AlgoTools3D_DoSplitSEAMOnFace(*args):
	return BOPTools_AlgoTools3D.DoSplitSEAMOnFace(*args)

@deprecated
def BOPTools_AlgoTools3D_DoSplitSEAMOnFace(*args):
	return BOPTools_AlgoTools3D.DoSplitSEAMOnFace(*args)

@deprecated
def BOPTools_AlgoTools3D_GetApproxNormalToFaceOnEdge(*args):
	return BOPTools_AlgoTools3D.GetApproxNormalToFaceOnEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_GetApproxNormalToFaceOnEdge(*args):
	return BOPTools_AlgoTools3D.GetApproxNormalToFaceOnEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_GetApproxNormalToFaceOnEdge(*args):
	return BOPTools_AlgoTools3D.GetApproxNormalToFaceOnEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_GetNormalToFaceOnEdge(*args):
	return BOPTools_AlgoTools3D.GetNormalToFaceOnEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_GetNormalToFaceOnEdge(*args):
	return BOPTools_AlgoTools3D.GetNormalToFaceOnEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_GetNormalToSurface(*args):
	return BOPTools_AlgoTools3D.GetNormalToSurface(*args)

@deprecated
def BOPTools_AlgoTools3D_IsEmptyShape(*args):
	return BOPTools_AlgoTools3D.IsEmptyShape(*args)

@deprecated
def BOPTools_AlgoTools3D_MinStepIn2d(*args):
	return BOPTools_AlgoTools3D.MinStepIn2d(*args)

@deprecated
def BOPTools_AlgoTools3D_OrientEdgeOnFace(*args):
	return BOPTools_AlgoTools3D.OrientEdgeOnFace(*args)

@deprecated
def BOPTools_AlgoTools3D_PointInFace(*args):
	return BOPTools_AlgoTools3D.PointInFace(*args)

@deprecated
def BOPTools_AlgoTools3D_PointInFace(*args):
	return BOPTools_AlgoTools3D.PointInFace(*args)

@deprecated
def BOPTools_AlgoTools3D_PointInFace(*args):
	return BOPTools_AlgoTools3D.PointInFace(*args)

@deprecated
def BOPTools_AlgoTools3D_PointNearEdge(*args):
	return BOPTools_AlgoTools3D.PointNearEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_PointNearEdge(*args):
	return BOPTools_AlgoTools3D.PointNearEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_PointNearEdge(*args):
	return BOPTools_AlgoTools3D.PointNearEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_PointNearEdge(*args):
	return BOPTools_AlgoTools3D.PointNearEdge(*args)

@deprecated
def BOPTools_AlgoTools3D_SenseFlag(*args):
	return BOPTools_AlgoTools3D.SenseFlag(*args)

@deprecated
def BOPTools_SetMapHasher_HashCode(*args):
	return BOPTools_SetMapHasher.HashCode(*args)

@deprecated
def BOPTools_SetMapHasher_IsEqual(*args):
	return BOPTools_SetMapHasher.IsEqual(*args)



