/* Generated by wayland-scanner 1.23.1 */

#ifndef XX_COLOR_MANAGEMENT_V2_SERVER_PROTOCOL_H
#define XX_COLOR_MANAGEMENT_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_xx_color_management_v2 The xx_color_management_v2 protocol
 * color management protocol
 *
 * @section page_desc_xx_color_management_v2 Description
 *
 * The aim of the color management extension is to allow clients to know
 * the color properties of outputs, and to tell the compositor about the color
 * properties of their content on surfaces. Doing this enables a compositor
 * to perform automatic color management of content for different outputs
 * according to how content is intended to look like.
 *
 * The color properties are represented as an image description object which
 * is immutable after it has been created. A wl_output always has an
 * associated image description that clients can observe. A wl_surface
 * always has an associated preferred image description as a hint chosen by
 * the compositor that clients can also observe. Clients can set an image
 * description on a wl_surface to denote the color characteristics of the
 * surface contents.
 *
 * An image description includes SDR and HDR colorimetry and encoding, HDR
 * metadata, and viewing environment parameters. An image description does
 * not include the properties set through color-representation extension.
 * It is expected that the color-representation extension is used in
 * conjunction with the color management extension when necessary,
 * particularly with the YUV family of pixel formats.
 *
 * Recommendation ITU-T H.273
 * "Coding-independent code points for video signal type identification"
 * shall be referred to as simply H.273 here.
 *
 * The color-and-hdr repository
 * (https://gitlab.freedesktop.org/pq/color-and-hdr) contains
 * background information on the protocol design and legacy color management.
 * It also contains a glossary, learning resources for digital color, tools,
 * samples and more.
 *
 * The terminology used in this protocol is based on common color science and
 * color encoding terminology where possible. The glossary in the color-and-hdr
 * repository shall be the authority on the definition of terms in this
 * protocol.
 *
 * @section page_ifaces_xx_color_management_v2 Interfaces
 * - @subpage page_iface_xx_color_manager_v2 - color manager singleton
 * - @subpage page_iface_xx_color_management_output_v2 - output color properties
 * - @subpage page_iface_xx_color_management_surface_v2 - color management extension to a surface
 * - @subpage page_iface_xx_image_description_creator_icc_v2 - holder of image description ICC information
 * - @subpage page_iface_xx_image_description_creator_params_v2 - holder of image description parameters
 * - @subpage page_iface_xx_image_description_v2 - Colorimetric image description
 * - @subpage page_iface_xx_image_description_info_v2 - Colorimetric image description information
 * @section page_copyright_xx_color_management_v2 Copyright
 * <pre>
 *
 * Copyright 2019 Sebastian Wick
 * Copyright 2019 Erwin Burema
 * Copyright 2020 AMD
 * Copyright 2020, 2022, 2023 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_output;
struct wl_surface;
struct xx_color_management_output_v2;
struct xx_color_management_surface_v2;
struct xx_color_manager_v2;
struct xx_image_description_creator_icc_v2;
struct xx_image_description_creator_params_v2;
struct xx_image_description_info_v2;
struct xx_image_description_v2;

#ifndef XX_COLOR_MANAGER_V2_INTERFACE
#define XX_COLOR_MANAGER_V2_INTERFACE
/**
 * @page page_iface_xx_color_manager_v2 xx_color_manager_v2
 * @section page_iface_xx_color_manager_v2_desc Description
 *
 * A global interface used for getting color management extensions for
 * wl_surface and wl_output objects, and for creating client defined image
 * description objects. The extension interfaces allow
 * getting the image description of outputs and setting the image
 * description of surfaces.
 * @section page_iface_xx_color_manager_v2_api API
 * See @ref iface_xx_color_manager_v2.
 */
/**
 * @defgroup iface_xx_color_manager_v2 The xx_color_manager_v2 interface
 *
 * A global interface used for getting color management extensions for
 * wl_surface and wl_output objects, and for creating client defined image
 * description objects. The extension interfaces allow
 * getting the image description of outputs and setting the image
 * description of surfaces.
 */
extern const struct wl_interface xx_color_manager_v2_interface;
#endif
#ifndef XX_COLOR_MANAGEMENT_OUTPUT_V2_INTERFACE
#define XX_COLOR_MANAGEMENT_OUTPUT_V2_INTERFACE
/**
 * @page page_iface_xx_color_management_output_v2 xx_color_management_output_v2
 * @section page_iface_xx_color_management_output_v2_desc Description
 *
 * A xx_color_management_output_v2 describes the color properties of an
 * output.
 *
 * The xx_color_management_output_v2 is associated with the wl_output global
 * underlying the wl_output object. Therefore the client destroying the
 * wl_output object has no impact, but the compositor removing the output
 * global makes the xx_color_management_output_v2 object inert.
 * @section page_iface_xx_color_management_output_v2_api API
 * See @ref iface_xx_color_management_output_v2.
 */
/**
 * @defgroup iface_xx_color_management_output_v2 The xx_color_management_output_v2 interface
 *
 * A xx_color_management_output_v2 describes the color properties of an
 * output.
 *
 * The xx_color_management_output_v2 is associated with the wl_output global
 * underlying the wl_output object. Therefore the client destroying the
 * wl_output object has no impact, but the compositor removing the output
 * global makes the xx_color_management_output_v2 object inert.
 */
extern const struct wl_interface xx_color_management_output_v2_interface;
#endif
#ifndef XX_COLOR_MANAGEMENT_SURFACE_V2_INTERFACE
#define XX_COLOR_MANAGEMENT_SURFACE_V2_INTERFACE
/**
 * @page page_iface_xx_color_management_surface_v2 xx_color_management_surface_v2
 * @section page_iface_xx_color_management_surface_v2_desc Description
 *
 * A xx_color_management_surface_v2 allows the client to set the color
 * space and HDR properties of a surface.
 *
 * If the wl_surface associated with the xx_color_management_surface_v2 is
 * destroyed, the xx_color_management_surface_v2 object becomes inert.
 * @section page_iface_xx_color_management_surface_v2_api API
 * See @ref iface_xx_color_management_surface_v2.
 */
/**
 * @defgroup iface_xx_color_management_surface_v2 The xx_color_management_surface_v2 interface
 *
 * A xx_color_management_surface_v2 allows the client to set the color
 * space and HDR properties of a surface.
 *
 * If the wl_surface associated with the xx_color_management_surface_v2 is
 * destroyed, the xx_color_management_surface_v2 object becomes inert.
 */
extern const struct wl_interface xx_color_management_surface_v2_interface;
#endif
#ifndef XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_INTERFACE
#define XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_INTERFACE
/**
 * @page page_iface_xx_image_description_creator_icc_v2 xx_image_description_creator_icc_v2
 * @section page_iface_xx_image_description_creator_icc_v2_desc Description
 *
 * This type of object is used for collecting all the information required
 * to create a xx_image_description_v2 object from an ICC file. A complete
 * set of required parameters consists of these properties:
 * - ICC file
 *
 * Each required property must be set exactly once if the client is to create
 * an image description. The set requests verify that a property was not
 * already set. The create request verifies that all required properties are
 * set. There may be several alternative requests for setting each property,
 * and in that case the client must choose one of them.
 *
 * Once all properties have been set, the create request must be used to
 * create the image description object, destroying the creator in the
 * process.
 * @section page_iface_xx_image_description_creator_icc_v2_api API
 * See @ref iface_xx_image_description_creator_icc_v2.
 */
/**
 * @defgroup iface_xx_image_description_creator_icc_v2 The xx_image_description_creator_icc_v2 interface
 *
 * This type of object is used for collecting all the information required
 * to create a xx_image_description_v2 object from an ICC file. A complete
 * set of required parameters consists of these properties:
 * - ICC file
 *
 * Each required property must be set exactly once if the client is to create
 * an image description. The set requests verify that a property was not
 * already set. The create request verifies that all required properties are
 * set. There may be several alternative requests for setting each property,
 * and in that case the client must choose one of them.
 *
 * Once all properties have been set, the create request must be used to
 * create the image description object, destroying the creator in the
 * process.
 */
extern const struct wl_interface xx_image_description_creator_icc_v2_interface;
#endif
#ifndef XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_INTERFACE
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_INTERFACE
/**
 * @page page_iface_xx_image_description_creator_params_v2 xx_image_description_creator_params_v2
 * @section page_iface_xx_image_description_creator_params_v2_desc Description
 *
 * This type of object is used for collecting all the parameters required
 * to create a xx_image_description_v2 object. A complete set of required
 * parameters consists of these properties:
 * - transfer characteristic function (tf)
 * - chromaticities of primaries and white point (primary color volume)
 *
 * The following properties are optional and have a well-defined default
 * if not explicitly set:
 * - mastering display primaries and white point (target color volume)
 * - mastering luminance range
 * - maximum content light level
 * - maximum frame-average light level
 *
 * Each required property must be set exactly once if the client is to create
 * an image description. The set requests verify that a property was not
 * already set. The create request verifies that all required properties are
 * set. There may be several alternative requests for setting each property,
 * and in that case the client must choose one of them.
 *
 * Once all properties have been set, the create request must be used to
 * create the image description object, destroying the creator in the
 * process.
 * @section page_iface_xx_image_description_creator_params_v2_api API
 * See @ref iface_xx_image_description_creator_params_v2.
 */
/**
 * @defgroup iface_xx_image_description_creator_params_v2 The xx_image_description_creator_params_v2 interface
 *
 * This type of object is used for collecting all the parameters required
 * to create a xx_image_description_v2 object. A complete set of required
 * parameters consists of these properties:
 * - transfer characteristic function (tf)
 * - chromaticities of primaries and white point (primary color volume)
 *
 * The following properties are optional and have a well-defined default
 * if not explicitly set:
 * - mastering display primaries and white point (target color volume)
 * - mastering luminance range
 * - maximum content light level
 * - maximum frame-average light level
 *
 * Each required property must be set exactly once if the client is to create
 * an image description. The set requests verify that a property was not
 * already set. The create request verifies that all required properties are
 * set. There may be several alternative requests for setting each property,
 * and in that case the client must choose one of them.
 *
 * Once all properties have been set, the create request must be used to
 * create the image description object, destroying the creator in the
 * process.
 */
extern const struct wl_interface xx_image_description_creator_params_v2_interface;
#endif
#ifndef XX_IMAGE_DESCRIPTION_V2_INTERFACE
#define XX_IMAGE_DESCRIPTION_V2_INTERFACE
/**
 * @page page_iface_xx_image_description_v2 xx_image_description_v2
 * @section page_iface_xx_image_description_v2_desc Description
 *
 * An image description carries information about the color encoding used
 * on a surface when attached to a wl_surface via
 * xx_color_management_surface_v2.set_image_description. A compositor can
 * use this information to decode pixel values into colorimetrically
 * meaningful quantities.
 *
 * Note, that the xx_image_description_v2 object is not ready to be used
 * immediately after creation. The object eventually delivers either the
 * 'ready' or the 'failed' event, specified in all requests creating it. The
 * object is deemed "ready" after receiving the 'ready' event.
 *
 * An object which is not ready is illegal to use, it can only be destroyed.
 * Any other request in this interface shall result in the 'not_ready'
 * protocol error. Attempts to use an object which is not ready through other
 * interfaces shall raise protocol errors defined there.
 *
 * Once created and regardless of how it was created, a xx_image_description_v2
 * object always refers to one fixed image description. It cannot change
 * after creation.
 * @section page_iface_xx_image_description_v2_api API
 * See @ref iface_xx_image_description_v2.
 */
/**
 * @defgroup iface_xx_image_description_v2 The xx_image_description_v2 interface
 *
 * An image description carries information about the color encoding used
 * on a surface when attached to a wl_surface via
 * xx_color_management_surface_v2.set_image_description. A compositor can
 * use this information to decode pixel values into colorimetrically
 * meaningful quantities.
 *
 * Note, that the xx_image_description_v2 object is not ready to be used
 * immediately after creation. The object eventually delivers either the
 * 'ready' or the 'failed' event, specified in all requests creating it. The
 * object is deemed "ready" after receiving the 'ready' event.
 *
 * An object which is not ready is illegal to use, it can only be destroyed.
 * Any other request in this interface shall result in the 'not_ready'
 * protocol error. Attempts to use an object which is not ready through other
 * interfaces shall raise protocol errors defined there.
 *
 * Once created and regardless of how it was created, a xx_image_description_v2
 * object always refers to one fixed image description. It cannot change
 * after creation.
 */
extern const struct wl_interface xx_image_description_v2_interface;
#endif
#ifndef XX_IMAGE_DESCRIPTION_INFO_V2_INTERFACE
#define XX_IMAGE_DESCRIPTION_INFO_V2_INTERFACE
/**
 * @page page_iface_xx_image_description_info_v2 xx_image_description_info_v2
 * @section page_iface_xx_image_description_info_v2_desc Description
 *
 * Sends all matching events describing an image description object exactly
 * once and finally sends the 'done' event.
 *
 * Once a xx_image_description_info_v2 object has delivered a 'done' event
 * it is automatically destroyed.
 *
 * Every xx_image_description_info_v2 created from the same
 * xx_image_description_v2 shall always return the exact same data.
 * @section page_iface_xx_image_description_info_v2_api API
 * See @ref iface_xx_image_description_info_v2.
 */
/**
 * @defgroup iface_xx_image_description_info_v2 The xx_image_description_info_v2 interface
 *
 * Sends all matching events describing an image description object exactly
 * once and finally sends the 'done' event.
 *
 * Once a xx_image_description_info_v2 object has delivered a 'done' event
 * it is automatically destroyed.
 *
 * Every xx_image_description_info_v2 created from the same
 * xx_image_description_v2 shall always return the exact same data.
 */
extern const struct wl_interface xx_image_description_info_v2_interface;
#endif

#ifndef XX_COLOR_MANAGER_V2_ERROR_ENUM
#define XX_COLOR_MANAGER_V2_ERROR_ENUM
enum xx_color_manager_v2_error {
	/**
	 * request not supported
	 */
	XX_COLOR_MANAGER_V2_ERROR_UNSUPPORTED_FEATURE = 0,
};
/**
 * @ingroup iface_xx_color_manager_v2
 * Validate a xx_color_manager_v2 error value.
 *
 * @return true on success, false on error.
 * @ref xx_color_manager_v2_error
 */
static inline bool
xx_color_manager_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_COLOR_MANAGER_V2_ERROR_UNSUPPORTED_FEATURE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_COLOR_MANAGER_V2_ERROR_ENUM */

#ifndef XX_COLOR_MANAGER_V2_RENDER_INTENT_ENUM
#define XX_COLOR_MANAGER_V2_RENDER_INTENT_ENUM
/**
 * @ingroup iface_xx_color_manager_v2
 * rendering intents
 *
 * See the ICC.1:2022 specification from the International Color Consortium
 * for more details about rendering intents.
 *
 * The principles of ICC defined rendering intents apply with all types
 * of image descriptions, not only those with ICC file profiles.
 *
 * Compositors must support the perceptual rendering intent. Other
 * rendering intents are optional.
 */
enum xx_color_manager_v2_render_intent {
	/**
	 * perceptual
	 */
	XX_COLOR_MANAGER_V2_RENDER_INTENT_PERCEPTUAL = 0,
	/**
	 * media-relative colorimetric
	 */
	XX_COLOR_MANAGER_V2_RENDER_INTENT_RELATIVE = 1,
	/**
	 * saturation
	 */
	XX_COLOR_MANAGER_V2_RENDER_INTENT_SATURATION = 2,
	/**
	 * ICC-absolute colorimetric
	 */
	XX_COLOR_MANAGER_V2_RENDER_INTENT_ABSOLUTE = 3,
	/**
	 * media-relative colorimetric + black point compensation
	 */
	XX_COLOR_MANAGER_V2_RENDER_INTENT_RELATIVE_BPC = 4,
};
/**
 * @ingroup iface_xx_color_manager_v2
 * Validate a xx_color_manager_v2 render_intent value.
 *
 * @return true on success, false on error.
 * @ref xx_color_manager_v2_render_intent
 */
static inline bool
xx_color_manager_v2_render_intent_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_COLOR_MANAGER_V2_RENDER_INTENT_PERCEPTUAL:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_RENDER_INTENT_RELATIVE:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_RENDER_INTENT_SATURATION:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_RENDER_INTENT_ABSOLUTE:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_RENDER_INTENT_RELATIVE_BPC:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_COLOR_MANAGER_V2_RENDER_INTENT_ENUM */

#ifndef XX_COLOR_MANAGER_V2_FEATURE_ENUM
#define XX_COLOR_MANAGER_V2_FEATURE_ENUM
/**
 * @ingroup iface_xx_color_manager_v2
 * compositor supported features
 */
enum xx_color_manager_v2_feature {
	/**
	 * new_icc_creator request
	 */
	XX_COLOR_MANAGER_V2_FEATURE_ICC_V2_V4 = 0,
	/**
	 * new_parametric_creator request
	 */
	XX_COLOR_MANAGER_V2_FEATURE_PARAMETRIC = 1,
	/**
	 * parametric set_primaries request
	 */
	XX_COLOR_MANAGER_V2_FEATURE_SET_PRIMARIES = 2,
	/**
	 * parametric set_tf_power request
	 */
	XX_COLOR_MANAGER_V2_FEATURE_SET_TF_POWER = 3,
	/**
	 * parametric set_mastering_display_primaries request
	 *
	 * The compositor supports set_mastering_display_primaries
	 * request with a target color volume fully contained inside the
	 * primary color volume.
	 */
	XX_COLOR_MANAGER_V2_FEATURE_SET_MASTERING_DISPLAY_PRIMARIES = 4,
	/**
	 * parametric target exceeds primary color volume
	 *
	 * The compositor additionally supports target color volumes that
	 * extend outside of the primary color volume.
	 *
	 * This can only be advertised if feature
	 * set_mastering_display_primaries is supported as well.
	 */
	XX_COLOR_MANAGER_V2_FEATURE_EXTENDED_TARGET_VOLUME = 5,
};
/**
 * @ingroup iface_xx_color_manager_v2
 * Validate a xx_color_manager_v2 feature value.
 *
 * @return true on success, false on error.
 * @ref xx_color_manager_v2_feature
 */
static inline bool
xx_color_manager_v2_feature_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_COLOR_MANAGER_V2_FEATURE_ICC_V2_V4:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_FEATURE_PARAMETRIC:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_FEATURE_SET_PRIMARIES:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_FEATURE_SET_TF_POWER:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_FEATURE_SET_MASTERING_DISPLAY_PRIMARIES:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_FEATURE_EXTENDED_TARGET_VOLUME:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_COLOR_MANAGER_V2_FEATURE_ENUM */

#ifndef XX_COLOR_MANAGER_V2_PRIMARIES_ENUM
#define XX_COLOR_MANAGER_V2_PRIMARIES_ENUM
/**
 * @ingroup iface_xx_color_manager_v2
 * named color primaries
 *
 * Named color primaries used to encode well-known sets of primaries.
 * H.273 is the authority, when it comes to the exact values of primaries and authoritative specifications,
 * where an equivalent code point exists.
 * Descriptions do list the specifications for convenience.
 */
enum xx_color_manager_v2_primaries {
	/**
	 * Color primaries for the sRGB color space as defined by the BT.709 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.709-6 - Rec.
	 * ITU-R BT.1361-0 conventional colour gamut system and extended
	 * colour gamut system (historical) - IEC 61966-2-1 sRGB or sYCC -
	 * IEC 61966-2-4 - Society of Motion Picture and Television
	 * Engineers (SMPTE) RP 177 (1993) Annex B Equivalent to H.273
	 * ColourPrimaries code point 1.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_SRGB = 0,
	/**
	 * Color primaries for PAL-M as defined by the BT.470 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.470-6 System M
	 * (historical) - United States National Television System
	 * Committee 1953 Recommendation for transmission standards for
	 * color television - United States Federal Communications
	 * Commission (2003) Title 47 Code of Federal Regulations 73.682
	 * (a)(20) Equivalent to H.273 ColourPrimaries code point 4.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_PAL_M = 1,
	/**
	 * Color primaries for PAL as defined by the BT.601 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.470-6 System B,
	 * G (historical) - Rec. ITU-R BT.601-7 625 - Rec. ITU-R BT.1358-0
	 * 625 (historical) - Rec. ITU-R BT.1700-0 625 PAL and 625 SECAM
	 * Equivalent to H.273 ColourPrimaries code point 5.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_PAL = 2,
	/**
	 * Color primaries for NTSC as defined by the BT.601 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.601-7 525 - Rec.
	 * ITU-R BT.1358-1 525 or 625 (historical) - Rec. ITU-R BT.1700-0
	 * NTSC - SMPTE 170M (2004) - SMPTE 240M (1999) (historical)
	 * Equivalent to H.273 ColourPrimaries code point 6 and 7.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_NTSC = 3,
	/**
	 * Generic film with colour filters using Illuminant C
	 *
	 * Color primaries as defined by H.273 for generic film.
	 * Equivalent to H.273 ColourPrimaries code point 8.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_GENERIC_FILM = 4,
	/**
	 * Color primaries as defined by the BT.2020 and BT.2100 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.2020-2 - Rec.
	 * ITU-R BT.2100-0 Equivalent to H.273 ColourPrimaries code point
	 * 9.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_BT2020 = 5,
	/**
	 * Color primaries of the full CIE 1931 XYZ color space
	 *
	 * Color primaries as defined as the maximum of the CIE 1931 XYZ
	 * color space by - SMPTE ST 428-1 - (CIE 1931 XYZ as in ISO
	 * 11664-1) Equivalent to H.273 ColourPrimaries code point 10.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_CIE1931_XYZ = 6,
	/**
	 * Color primaries of the DCI P3 color space as defined by the SMPTE RP 431 standard
	 *
	 * Color primaries as defined by Digital Cinema System and
	 * published in SMPTE RP 431-2 (2011). Equivalent to H.273
	 * ColourPrimaries code point 11.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_DCI_P3 = 7,
	/**
	 * Color primaries of Display P3 variant of the DCI-P3 color space as defined by the SMPTE EG 432 standard
	 *
	 * Color primaries as defined by Digital Cinema System and
	 * published in SMPTE EG 432-1 (2010). Equivalent to H.273
	 * ColourPrimaries code point 12.
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_DISPLAY_P3 = 8,
	/**
	 * Color primaries of the Adobe RGB color space as defined by the ISO 12640 standard
	 *
	 * Color primaries as defined by Adobe as "Adobe RGB" and later
	 * published by ISO 12640-4 (2011).
	 */
	XX_COLOR_MANAGER_V2_PRIMARIES_ADOBE_RGB = 9,
};
/**
 * @ingroup iface_xx_color_manager_v2
 * Validate a xx_color_manager_v2 primaries value.
 *
 * @return true on success, false on error.
 * @ref xx_color_manager_v2_primaries
 */
static inline bool
xx_color_manager_v2_primaries_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_COLOR_MANAGER_V2_PRIMARIES_SRGB:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_PAL_M:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_PAL:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_NTSC:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_GENERIC_FILM:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_BT2020:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_CIE1931_XYZ:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_DCI_P3:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_DISPLAY_P3:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_PRIMARIES_ADOBE_RGB:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_COLOR_MANAGER_V2_PRIMARIES_ENUM */

#ifndef XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ENUM
#define XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ENUM
/**
 * @ingroup iface_xx_color_manager_v2
 * named transfer functions
 *
 * Named Transfer Functions.
 */
enum xx_color_manager_v2_transfer_function {
	/**
	 * BT.709 transfer function
	 *
	 * Transfer characteristics as defined by - Rec. ITU-R BT.709-6 -
	 * Rec. ITU-R BT.1361-0 conventional colour gamut system
	 * (historical) Equivalent to H.273 TransferCharacteristics code
	 * point 1, 6, 14, 15.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_BT709 = 0,
	/**
	 * Assumed display gamma 2.2 transfer function
	 *
	 * Transfer characteristics as defined by - Rec. ITU-R BT.470-6
	 * System M (historical) - United States National Television System
	 * Committee 1953 Recommendation for transmission standards for
	 * color television - United States Federal Communications
	 * Commission (2003) Title 47 Code of Federal Regulations 73.682
	 * (a) (20) - Rec. ITU-R BT.1700-0 625 PAL and 625 SECAM Equivalent
	 * to H.273 TransferCharacteristics code point 4.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_GAMMA22 = 1,
	/**
	 * Assumed display gamma 2.8 transfer function
	 *
	 * Transfer characteristics as defined by - Rec. ITU-R BT.470-6
	 * System B, G (historical) Equivalent to H.273
	 * TransferCharacteristics code point 5.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_GAMMA28 = 2,
	/**
	 * SMPTE ST 240 transfer function
	 *
	 * Transfer characteristics as defined by - SMPTE ST 240 (1999)
	 * Equivalent to H.273 TransferCharacteristics code point 7.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ST240 = 3,
	/**
	 * linear transfer function
	 *
	 * Linear transfer characteristics. Equivalent to H.273
	 * TransferCharacteristics code point 8.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_LINEAR = 4,
	/**
	 * logarithmic 100:1 transfer function
	 *
	 * Logarithmic transfer characteristic (100:1 range). Equivalent
	 * to H.273 TransferCharacteristics code point 9.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_LOG_100 = 5,
	/**
	 * logarithmic (100*Sqrt(10) : 1) transfer function
	 *
	 * Logarithmic transfer characteristic (100 * Sqrt(10) : 1
	 * range). Equivalent to H.273 TransferCharacteristics code point
	 * 10.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_LOG_316 = 6,
	/**
	 * IEC 61966-2-4 transfer function
	 *
	 * Transfer characteristics as defined by - IEC 61966-2-4
	 * Equivalent to H.273 TransferCharacteristics code point 11.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_XVYCC = 7,
	/**
	 * BT.1361 extended transfer function
	 *
	 * Transfer characteristics as defined by - Rec. ITU-R BT.1361-0
	 * extended colour gamut system (historical) Equivalent to H.273
	 * TransferCharacteristics code point 12.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_BT1361 = 8,
	/**
	 * sRGB piece-wise transfer function
	 *
	 * Transfer characteristics as defined by - IEC 61966-2-1 sRGB
	 * Equivalent to H.273 TransferCharacteristics code point 13 with
	 * MatrixCoefficients set to 0.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_SRGB = 9,
	/**
	 * Extended sRGB piece-wise transfer function
	 *
	 * Transfer characteristics as defined by - IEC 61966-2-1 sYCC
	 * Equivalent to H.273 TransferCharacteristics code point 13 with
	 * MatrixCoefficients set to anything but 0.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_EXT_SRGB = 10,
	/**
	 * perceptual quantizer transfer function
	 *
	 * Transfer characteristics as defined by - SMPTE ST 2084 (2014)
	 * for 10-, 12-, 14- and 16-bit systems - Rec. ITU-R BT.2100-2
	 * perceptual quantization (PQ) system Equivalent to H.273
	 * TransferCharacteristics code point 16.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ST2084_PQ = 11,
	/**
	 * SMPTE ST 428 transfer function
	 *
	 * Transfer characteristics as defined by - SMPTE ST 428-1 (2019)
	 * Equivalent to H.273 TransferCharacteristics code point 17.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ST428 = 12,
	/**
	 * hybrid log-gamma transfer function
	 *
	 * Transfer characteristics as defined by - ARIB STD-B67 (2015) -
	 * Rec. ITU-R BT.2100-2 hybrid log-gamma (HLG) system Equivalent to
	 * H.273 TransferCharacteristics code point 18.
	 */
	XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_HLG = 13,
};
/**
 * @ingroup iface_xx_color_manager_v2
 * Validate a xx_color_manager_v2 transfer_function value.
 *
 * @return true on success, false on error.
 * @ref xx_color_manager_v2_transfer_function
 */
static inline bool
xx_color_manager_v2_transfer_function_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_BT709:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_GAMMA22:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_GAMMA28:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ST240:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_LINEAR:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_LOG_100:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_LOG_316:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_XVYCC:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_BT1361:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_SRGB:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_EXT_SRGB:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ST2084_PQ:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ST428:
		return version >= 1;
	case XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_HLG:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_COLOR_MANAGER_V2_TRANSFER_FUNCTION_ENUM */

/**
 * @ingroup iface_xx_color_manager_v2
 * @struct xx_color_manager_v2_interface
 */
struct xx_color_manager_v2_interface {
	/**
	 * destroy the color manager
	 *
	 * Destroy the xx_color_manager_v2 object. This does not affect
	 * any other objects in any way.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a color management interface for a wl_output
	 *
	 * This creates a new xx_color_management_output_v2 object for
	 * the given wl_output.
	 *
	 * See the xx_color_management_output_v2 interface for more
	 * details.
	 */
	void (*get_output)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t id,
			   struct wl_resource *output);
	/**
	 * create a color management interface for a wl_surface
	 *
	 * This creates a new color xx_color_management_surface_v2 object
	 * for the given wl_surface.
	 *
	 * See the xx_color_management_surface_v2 interface for more
	 * details.
	 */
	void (*get_surface)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id,
			    struct wl_resource *surface);
	/**
	 * make a new ICC-based image description creator object
	 *
	 * Makes a new ICC-based image description creator object with
	 * all properties initially unset. The client can then use the
	 * object's interface to define all the required properties for an
	 * image description and finally create a xx_image_description_v2
	 * object.
	 *
	 * This request can be used when the compositor advertises
	 * xx_color_manager_v2.feature.icc_v2_v4. Otherwise this request
	 * raises the protocol error unsupported_feature.
	 * @param obj the new creator object
	 */
	void (*new_icc_creator)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t obj);
	/**
	 * make a new parametric image description creator object
	 *
	 * Makes a new parametric image description creator object with
	 * all properties initially unset. The client can then use the
	 * object's interface to define all the required properties for an
	 * image description and finally create a xx_image_description_v2
	 * object.
	 *
	 * This request can be used when the compositor advertises
	 * xx_color_manager_v2.feature.parametric. Otherwise this request
	 * raises the protocol error unsupported_feature.
	 * @param obj the new creator object
	 */
	void (*new_parametric_creator)(struct wl_client *client,
				       struct wl_resource *resource,
				       uint32_t obj);
};

#define XX_COLOR_MANAGER_V2_SUPPORTED_INTENT 0
#define XX_COLOR_MANAGER_V2_SUPPORTED_FEATURE 1
#define XX_COLOR_MANAGER_V2_SUPPORTED_TF_NAMED 2
#define XX_COLOR_MANAGER_V2_SUPPORTED_PRIMARIES_NAMED 3

/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_SUPPORTED_INTENT_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_SUPPORTED_FEATURE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_SUPPORTED_TF_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_SUPPORTED_PRIMARIES_NAMED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_GET_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_GET_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_NEW_ICC_CREATOR_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_manager_v2
 */
#define XX_COLOR_MANAGER_V2_NEW_PARAMETRIC_CREATOR_SINCE_VERSION 1

/**
 * @ingroup iface_xx_color_manager_v2
 * Sends an supported_intent event to the client owning the resource.
 * @param resource_ The client's resource
 * @param render_intent rendering intent
 */
static inline void
xx_color_manager_v2_send_supported_intent(struct wl_resource *resource_, uint32_t render_intent)
{
	wl_resource_post_event(resource_, XX_COLOR_MANAGER_V2_SUPPORTED_INTENT, render_intent);
}

/**
 * @ingroup iface_xx_color_manager_v2
 * Sends an supported_feature event to the client owning the resource.
 * @param resource_ The client's resource
 * @param feature supported feature
 */
static inline void
xx_color_manager_v2_send_supported_feature(struct wl_resource *resource_, uint32_t feature)
{
	wl_resource_post_event(resource_, XX_COLOR_MANAGER_V2_SUPPORTED_FEATURE, feature);
}

/**
 * @ingroup iface_xx_color_manager_v2
 * Sends an supported_tf_named event to the client owning the resource.
 * @param resource_ The client's resource
 * @param tf Named transfer function
 */
static inline void
xx_color_manager_v2_send_supported_tf_named(struct wl_resource *resource_, uint32_t tf)
{
	wl_resource_post_event(resource_, XX_COLOR_MANAGER_V2_SUPPORTED_TF_NAMED, tf);
}

/**
 * @ingroup iface_xx_color_manager_v2
 * Sends an supported_primaries_named event to the client owning the resource.
 * @param resource_ The client's resource
 * @param primaries Named color primaries
 */
static inline void
xx_color_manager_v2_send_supported_primaries_named(struct wl_resource *resource_, uint32_t primaries)
{
	wl_resource_post_event(resource_, XX_COLOR_MANAGER_V2_SUPPORTED_PRIMARIES_NAMED, primaries);
}

/**
 * @ingroup iface_xx_color_management_output_v2
 * @struct xx_color_management_output_v2_interface
 */
struct xx_color_management_output_v2_interface {
	/**
	 * destroy the color management output
	 *
	 * Destroy the color xx_color_management_output_v2 object. This
	 * does not affect any remaining protocol objects.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * get the image description of the output
	 *
	 * This creates a new xx_image_description_v2 object for the
	 * current image description of the output. There always is exactly
	 * one image description active for an output so the client should
	 * destroy the image description created by earlier invocations of
	 * this request. This request is usually sent as a reaction to the
	 * image_description_changed event or when creating a
	 * xx_color_management_output_v2 object.
	 *
	 * The created xx_image_description_v2 object preserves the image
	 * description of the output from the time the object was created.
	 *
	 * The resulting image description object allows get_information
	 * request.
	 *
	 * If this protocol object is inert, the resulting image
	 * description object shall immediately deliver the
	 * xx_image_description_v2.failed event with the no_output cause.
	 *
	 * If the interface version is inadequate for the output's image
	 * description, meaning that the client does not support all the
	 * events needed to deliver the crucial information, the resulting
	 * image description object shall immediately deliver the
	 * xx_image_description_v2.failed event with the low_version cause.
	 *
	 * Otherwise the object shall immediately deliver the ready event.
	 */
	void (*get_image_description)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t image_description);
};

#define XX_COLOR_MANAGEMENT_OUTPUT_V2_IMAGE_DESCRIPTION_CHANGED 0

/**
 * @ingroup iface_xx_color_management_output_v2
 */
#define XX_COLOR_MANAGEMENT_OUTPUT_V2_IMAGE_DESCRIPTION_CHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_color_management_output_v2
 */
#define XX_COLOR_MANAGEMENT_OUTPUT_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_management_output_v2
 */
#define XX_COLOR_MANAGEMENT_OUTPUT_V2_GET_IMAGE_DESCRIPTION_SINCE_VERSION 1

/**
 * @ingroup iface_xx_color_management_output_v2
 * Sends an image_description_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_color_management_output_v2_send_image_description_changed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, XX_COLOR_MANAGEMENT_OUTPUT_V2_IMAGE_DESCRIPTION_CHANGED);
}

#ifndef XX_COLOR_MANAGEMENT_SURFACE_V2_ERROR_ENUM
#define XX_COLOR_MANAGEMENT_SURFACE_V2_ERROR_ENUM
/**
 * @ingroup iface_xx_color_management_surface_v2
 * protocol errors
 */
enum xx_color_management_surface_v2_error {
	/**
	 * forbidden request on inert object
	 */
	XX_COLOR_MANAGEMENT_SURFACE_V2_ERROR_INERT = 0,
	/**
	 * unsupported rendering intent
	 */
	XX_COLOR_MANAGEMENT_SURFACE_V2_ERROR_RENDER_INTENT = 1,
};
/**
 * @ingroup iface_xx_color_management_surface_v2
 * Validate a xx_color_management_surface_v2 error value.
 *
 * @return true on success, false on error.
 * @ref xx_color_management_surface_v2_error
 */
static inline bool
xx_color_management_surface_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_COLOR_MANAGEMENT_SURFACE_V2_ERROR_INERT:
		return version >= 1;
	case XX_COLOR_MANAGEMENT_SURFACE_V2_ERROR_RENDER_INTENT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_COLOR_MANAGEMENT_SURFACE_V2_ERROR_ENUM */

/**
 * @ingroup iface_xx_color_management_surface_v2
 * @struct xx_color_management_surface_v2_interface
 */
struct xx_color_management_surface_v2_interface {
	/**
	 * destroy the color management interface for a surface
	 *
	 * Destroy the xx_color_management_surface_v2 object.
	 *
	 * When the last xx_color_management_surface_v2 object for a
	 * wl_surface is destroyed, it does the same as
	 * unset_image_description.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set the surface image description
	 *
	 * Set the image description of the underlying surface. The image
	 * description and rendering intent are double-buffered state, see
	 * wl_surface.commit.
	 *
	 * It is the client's responsibility to understand the image
	 * description it sets on a surface, and to provide content that
	 * matches that image description.
	 *
	 * A rendering intent provides the client's preference on how
	 * content colors should be mapped to each output. The
	 * render_intent value must be one advertised by the compositor
	 * with xx_color_manager_v2.render_intent event, otherwise the
	 * protocol error render_intent is raised.
	 *
	 * By default, a surface does not have an associated image
	 * description nor a rendering intent. The handling of color on
	 * such surfaces is compositor implementation defined. Compositors
	 * should handle such surfaces as sRGB but may handle them
	 * differently if they have specific requirements.
	 * @param render_intent rendering intent
	 */
	void (*set_image_description)(struct wl_client *client,
				      struct wl_resource *resource,
				      struct wl_resource *image_description,
				      uint32_t render_intent);
	/**
	 * remove the surface image description
	 *
	 * This request removes any image description from the surface.
	 * See set_image_description for how a compositor handles a surface
	 * without an image description. This is double-buffered state, see
	 * wl_surface.commit.
	 */
	void (*unset_image_description)(struct wl_client *client,
					struct wl_resource *resource);
	/**
	 * get the preferred image description
	 *
	 * If this protocol object is inert, the protocol error inert is
	 * raised.
	 *
	 * This creates a new xx_image_description_v2 object for the
	 * currently preferred image description for the wl_surface. The
	 * client should stop using and destroy the image descriptions
	 * created by earlier invocations of this request for the
	 * associated wl_surface. This request is usually sent as a
	 * reaction to the preferred_changed event or when creating a
	 * xx_color_management_surface_v2 object if the client is capable
	 * of adapting to image descriptions.
	 *
	 * The created xx_image_description_v2 object preserves the
	 * preferred image description of the wl_surface from the time the
	 * object was created.
	 *
	 * The resulting image description object allows get_information
	 * request.
	 *
	 * If the interface version is inadequate for the preferred image
	 * description, meaning that the client does not support all the
	 * events needed to deliver the crucial information, the resulting
	 * image description object shall immediately deliver the
	 * xx_image_description_v2.failed event with the low_version cause,
	 * otherwise the object shall immediately deliver the ready event.
	 */
	void (*get_preferred)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t image_description);
};

#define XX_COLOR_MANAGEMENT_SURFACE_V2_PREFERRED_CHANGED 0

/**
 * @ingroup iface_xx_color_management_surface_v2
 */
#define XX_COLOR_MANAGEMENT_SURFACE_V2_PREFERRED_CHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_color_management_surface_v2
 */
#define XX_COLOR_MANAGEMENT_SURFACE_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_management_surface_v2
 */
#define XX_COLOR_MANAGEMENT_SURFACE_V2_SET_IMAGE_DESCRIPTION_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_management_surface_v2
 */
#define XX_COLOR_MANAGEMENT_SURFACE_V2_UNSET_IMAGE_DESCRIPTION_SINCE_VERSION 1
/**
 * @ingroup iface_xx_color_management_surface_v2
 */
#define XX_COLOR_MANAGEMENT_SURFACE_V2_GET_PREFERRED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_color_management_surface_v2
 * Sends an preferred_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_color_management_surface_v2_send_preferred_changed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, XX_COLOR_MANAGEMENT_SURFACE_V2_PREFERRED_CHANGED);
}

#ifndef XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_ENUM
#define XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_ENUM
/**
 * @ingroup iface_xx_image_description_creator_icc_v2
 * protocol errors
 */
enum xx_image_description_creator_icc_v2_error {
	/**
	 * incomplete parameter set
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_INCOMPLETE_SET = 0,
	/**
	 * property already set
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_ALREADY_SET = 1,
	/**
	 * fd not seekable and readable
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_BAD_FD = 2,
	/**
	 * no or too much data
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_BAD_SIZE = 3,
	/**
	 * offset + length exceeds file size
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_OUT_OF_FILE = 4,
};
/**
 * @ingroup iface_xx_image_description_creator_icc_v2
 * Validate a xx_image_description_creator_icc_v2 error value.
 *
 * @return true on success, false on error.
 * @ref xx_image_description_creator_icc_v2_error
 */
static inline bool
xx_image_description_creator_icc_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_INCOMPLETE_SET:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_ALREADY_SET:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_BAD_FD:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_BAD_SIZE:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_OUT_OF_FILE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_ERROR_ENUM */

/**
 * @ingroup iface_xx_image_description_creator_icc_v2
 * @struct xx_image_description_creator_icc_v2_interface
 */
struct xx_image_description_creator_icc_v2_interface {
	/**
	 * Create the image description object from ICC data
	 *
	 * Create an image description object based on the ICC
	 * information previously set on this object. A compositor must
	 * parse the ICC data in some undefined but finite amount of time.
	 *
	 * The completeness of the parameter set is verified. If the set is
	 * not complete, the protocol error incomplete_set is raised. For
	 * the definition of a complete set, see the description of this
	 * interface.
	 *
	 * If the particular combination of the information is not
	 * supported by the compositor, the resulting image description
	 * object shall immediately deliver the
	 * xx_image_description_v2.failed event with the 'unsupported'
	 * cause. If a valid image description was created from the
	 * information, the xx_image_description_v2.ready event will
	 * eventually be sent instead.
	 *
	 * This request destroys the xx_image_description_creator_icc_v2
	 * object.
	 *
	 * The resulting image description object does not allow
	 * get_information request.
	 */
	void (*create)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t image_description);
	/**
	 * set the ICC profile file
	 *
	 * Sets the ICC profile file to be used as the basis of the image
	 * description.
	 *
	 * The data shall be found through the given fd at the given
	 * offset, having the given length. The fd must seekable and
	 * readable. Violating these requirements raises the bad_fd
	 * protocol error.
	 *
	 * If reading the data fails due to an error independent of the
	 * client, the compositor shall send the
	 * xx_image_description_v2.failed event on the created
	 * xx_image_description_v2 with the 'operating_system' cause.
	 *
	 * The maximum size of the ICC profile is 4 MB. If length is
	 * greater than that or zero, the protocol error bad_size is
	 * raised. If offset + length exceeds the file size, the protocol
	 * error out_of_file is raised.
	 *
	 * A compositor may read the file at any time starting from this
	 * request and only until whichever happens first: - If create
	 * request was issued, the xx_image_description_v2 object delivers
	 * either failed or ready event; or - if create request was not
	 * issued, this xx_image_description_creator_icc_v2 object is
	 * destroyed.
	 *
	 * A compositor shall not modify the contents of the file, and the
	 * fd may be sealed for writes and size changes. The client must
	 * ensure to its best ability that the data does not change while
	 * the compositor is reading it.
	 *
	 * The data must represent a valid ICC profile. The ICC profile
	 * version must be 2 or 4, it must be a 3 channel profile and the
	 * class must be 'display'. Violating these requirements will not
	 * result in a protocol error but will eventually send the
	 * xx_image_description_v2.failed event on the created
	 * xx_image_description_v2 with the 'unsupported' cause.
	 *
	 * See the International Color Consortium specification ICC.1:2022
	 * for more details about ICC profiles.
	 *
	 * If ICC file has already been set on this object, the protocol
	 * error already_set is raised.
	 * @param icc_profile ICC profile
	 * @param offset byte offset in fd to start of ICC data
	 * @param length length of ICC data in bytes
	 */
	void (*set_icc_file)(struct wl_client *client,
			     struct wl_resource *resource,
			     int32_t icc_profile,
			     uint32_t offset,
			     uint32_t length);
};


/**
 * @ingroup iface_xx_image_description_creator_icc_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_icc_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_ICC_V2_SET_ICC_FILE_SINCE_VERSION 1

#ifndef XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_ENUM
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_ENUM
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 * protocol errors
 */
enum xx_image_description_creator_params_v2_error {
	/**
	 * incomplete parameter set
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INCOMPLETE_SET = 0,
	/**
	 * invalid combination of parameters
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INCONSISTENT_SET = 1,
	/**
	 * property already set
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_ALREADY_SET = 2,
	/**
	 * invalid transfer characteristic
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INVALID_TF = 3,
	/**
	 * invalid primaries or white point
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INVALID_PRIMARIES = 4,
	/**
	 * invalid luminance value or range
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INVALID_LUMINANCE = 5,
	/**
	 * invalid mastering information
	 */
	XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INVALID_MASTERING = 6,
};
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 * Validate a xx_image_description_creator_params_v2 error value.
 *
 * @return true on success, false on error.
 * @ref xx_image_description_creator_params_v2_error
 */
static inline bool
xx_image_description_creator_params_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INCOMPLETE_SET:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INCONSISTENT_SET:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_ALREADY_SET:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INVALID_TF:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INVALID_PRIMARIES:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INVALID_LUMINANCE:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_INVALID_MASTERING:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_ERROR_ENUM */

/**
 * @ingroup iface_xx_image_description_creator_params_v2
 * @struct xx_image_description_creator_params_v2_interface
 */
struct xx_image_description_creator_params_v2_interface {
	/**
	 * Create the image description object using params
	 *
	 * Create an image description object based on the parameters
	 * previously set on this object.
	 *
	 * The completeness of the parameter set is verified. If the set is
	 * not complete, the protocol error incomplete_set is raised. For
	 * the definition of a complete set, see the description of this
	 * interface.
	 *
	 * If the particular combination of the parameter set is not
	 * supported by the compositor, the resulting image description
	 * object shall immediately deliver the
	 * xx_image_description_v2.failed event with the 'unsupported'
	 * cause. If a valid image description was created from the
	 * parameter set, the xx_image_description_v2.ready event will
	 * eventually be sent instead.
	 *
	 * This request destroys the xx_image_description_creator_params_v2
	 * object.
	 *
	 * The resulting image description object does not allow
	 * get_information request.
	 */
	void (*create)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t image_description);
	/**
	 * named transfer characteristic
	 *
	 * Sets the transfer characteristic using explicitly enumerated
	 * named functions.
	 *
	 * Only names advertised with xx_color_manager_v2 event
	 * supported_tf_named are allowed. Other values shall raise the
	 * protocol error invalid_tf.
	 *
	 * If transfer characteristic has already been set on this object,
	 * the protocol error already_set is raised.
	 * @param tf named transfer function
	 */
	void (*set_tf_named)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t tf);
	/**
	 * transfer characteristic as a power curve
	 *
	 * Sets the color component transfer characteristic to a power
	 * curve with the given exponent. This curve represents the
	 * conversion from electrical to optical pixel or color values.
	 *
	 * The curve exponent shall be multiplied by 10000 to get the
	 * argument eexp value to carry the precision of 4 decimals.
	 *
	 * The curve exponent must be at least 1.0 and at most 10.0.
	 * Otherwise the protocol error invalid_tf is raised.
	 *
	 * If transfer characteristic has already been set on this object,
	 * the protocol error already_set is raised.
	 *
	 * This request can be used when the compositor advertises
	 * xx_color_manager_v2.feature.set_tf_power. Otherwise this request
	 * raises the protocol error invalid_tf.
	 * @param eexp the exponent * 10000
	 */
	void (*set_tf_power)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t eexp);
	/**
	 * named primaries
	 *
	 * Sets the color primaries and white point using explicitly
	 * named sets. This describes the primary color volume which is the
	 * basis for color value encoding.
	 *
	 * Only names advertised with xx_color_manager_v2 event
	 * supported_primaries_named are allowed. Other values shall raise
	 * the protocol error invalid_primaries.
	 *
	 * If primaries have already been set on this object, the protocol
	 * error already_set is raised.
	 * @param primaries named primaries
	 */
	void (*set_primaries_named)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t primaries);
	/**
	 * primaries as chromaticity coordinates
	 *
	 * Sets the color primaries and white point using CIE 1931 xy
	 * chromaticity coordinates. This describes the primary color
	 * volume which is the basis for color value encoding.
	 *
	 * Each coordinate value is multiplied by 10000 to get the argument
	 * value to carry precision of 4 decimals.
	 *
	 * If primaries have already been set on this object, the protocol
	 * error already_set is raised.
	 *
	 * This request can be used if the compositor advertises
	 * xx_color_manager_v2.feature.set_primaries. Otherwise this
	 * request raises the protocol error invalid_primaries.
	 * @param r_x Red x * 10000
	 * @param r_y Red y * 10000
	 * @param g_x Green x * 10000
	 * @param g_y Green y * 10000
	 * @param b_x Blue x * 10000
	 * @param b_y Blue y * 10000
	 * @param w_x White x * 10000
	 * @param w_y White y * 10000
	 */
	void (*set_primaries)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t r_x,
			      uint32_t r_y,
			      uint32_t g_x,
			      uint32_t g_y,
			      uint32_t b_x,
			      uint32_t b_y,
			      uint32_t w_x,
			      uint32_t w_y);
	/**
	 * mastering display primaries as chromaticity coordinates
	 *
	 * Provides the color primaries and white point of the mastering
	 * display using CIE 1931 xy chromaticity coordinates. This is
	 * compatible with the SMPTE ST 2086 definition of HDR static
	 * metadata.
	 *
	 * The mastering display primaries define the target color volume.
	 *
	 * If mastering display primaries are not explicitly set, the
	 * target color volume is assumed to be equal to the primary color
	 * volume.
	 *
	 * The target color volume is defined by all tristimulus values
	 * between 0.0 and 1.0 (inclusive) of the color space defined by
	 * the given mastering display primaries and white point. The
	 * colorimetry is identical between the container color space and
	 * the mastering display color space, including that no chromatic
	 * adaptation is applied even if the white points differ.
	 *
	 * The target color volume can exceed the primary color volume to
	 * allow for a greater color volume with an existing color space
	 * definition (for example scRGB). It can be smaller than the
	 * primary color volume to minimize gamut and tone mapping
	 * distances for big color spaces (HDR metadata).
	 *
	 * To make use of the entire target color volume a suitable pixel
	 * format has to be chosen (e.g. floating point to exceed the
	 * primary color volume, or abusing limited quantization range as
	 * with xvYCC).
	 *
	 * Each coordinate value is multiplied by 10000 to get the argument
	 * value to carry precision of 4 decimals.
	 *
	 * If mastering display primaries have already been set on this
	 * object, the protocol error already_set is raised.
	 *
	 * This request can be used if the compositor advertises
	 * xx_color_manager_v2.feature.set_mastering_display_primaries.
	 * Otherwise this request raises the protocol error
	 * invalid_mastering. The advertisement implies support only for
	 * target color volumes fully contained within the primary color
	 * volume.
	 *
	 * If a compositor additionally supports target color volume
	 * exceeding the primary color volume, it must advertise
	 * xx_color_manager_v2.feature.extended_target_volume. If a client
	 * uses target color volume exceeding the primary color volume and
	 * the compositor does not support it, the result is implementation
	 * defined. Compositors are recommended to detect this case and
	 * fail the image description gracefully, but it may as well result
	 * in color artifacts.
	 * @param r_x Red x * 10000
	 * @param r_y Red y * 10000
	 * @param g_x Green x * 10000
	 * @param g_y Green y * 10000
	 * @param b_x Blue x * 10000
	 * @param b_y Blue y * 10000
	 * @param w_x White x * 10000
	 * @param w_y White y * 10000
	 */
	void (*set_mastering_display_primaries)(struct wl_client *client,
						struct wl_resource *resource,
						uint32_t r_x,
						uint32_t r_y,
						uint32_t g_x,
						uint32_t g_y,
						uint32_t b_x,
						uint32_t b_y,
						uint32_t w_x,
						uint32_t w_y);
	/**
	 * display mastering luminance range
	 *
	 * Sets the luminance range that was used during the content
	 * mastering process as the minimum and maximum absolute luminance
	 * L. This is compatible with the SMPTE ST 2086 definition of HDR
	 * static metadata.
	 *
	 * This can only be set when set_tf_cicp is used to set the
	 * transfer characteristic to Rec. ITU-R BT.2100-2 perceptual
	 * quantization system. Otherwise, 'create' request shall raise
	 * inconsistent_set protocol error.
	 *
	 * The mastering luminance range is undefined by default.
	 *
	 * If max L is less than or equal to min L, the protocol error
	 * invalid_luminance is raised.
	 *
	 * Min L value is multiplied by 10000 to get the argument min_lum
	 * value and carry precision of 4 decimals. Max L value is unscaled
	 * for max_lum.
	 * @param min_lum min L (cd/m²) * 10000
	 * @param max_lum max L (cd/m²)
	 */
	void (*set_mastering_luminance)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t min_lum,
					uint32_t max_lum);
	/**
	 * maximum content light level
	 *
	 * Sets the maximum content light level (max_cll) as defined by
	 * CTA-861-H.
	 *
	 * This can only be set when set_tf_cicp is used to set the
	 * transfer characteristic to Rec. ITU-R BT.2100-2 perceptual
	 * quantization system. Otherwise, 'create' request shall raise
	 * inconsistent_set protocol error.
	 *
	 * max_cll is undefined by default.
	 * @param max_cll Maximum content light level (cd/m²)
	 */
	void (*set_max_cll)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t max_cll);
	/**
	 * maximum frame-average light level
	 *
	 * Sets the maximum frame-average light level (max_fall) as
	 * defined by CTA-861-H.
	 *
	 * This can only be set when set_tf_cicp is used to set the
	 * transfer characteristic to Rec. ITU-R BT.2100-2 perceptual
	 * quantization system. Otherwise, 'create' request shall raise
	 * inconsistent_set protocol error.
	 *
	 * max_fall is undefined by default.
	 * @param max_fall Maximum frame-average light level (cd/m²)
	 */
	void (*set_max_fall)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t max_fall);
};


/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_SET_TF_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_SET_TF_POWER_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_SET_PRIMARIES_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_SET_PRIMARIES_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_SET_MASTERING_DISPLAY_PRIMARIES_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_SET_MASTERING_LUMINANCE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_SET_MAX_CLL_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_creator_params_v2
 */
#define XX_IMAGE_DESCRIPTION_CREATOR_PARAMS_V2_SET_MAX_FALL_SINCE_VERSION 1

#ifndef XX_IMAGE_DESCRIPTION_V2_ERROR_ENUM
#define XX_IMAGE_DESCRIPTION_V2_ERROR_ENUM
/**
 * @ingroup iface_xx_image_description_v2
 * protocol errors
 */
enum xx_image_description_v2_error {
	/**
	 * attempted to use an object which is not ready
	 */
	XX_IMAGE_DESCRIPTION_V2_ERROR_NOT_READY = 0,
	/**
	 * get_information not allowed
	 */
	XX_IMAGE_DESCRIPTION_V2_ERROR_NO_INFORMATION = 1,
};
/**
 * @ingroup iface_xx_image_description_v2
 * Validate a xx_image_description_v2 error value.
 *
 * @return true on success, false on error.
 * @ref xx_image_description_v2_error
 */
static inline bool
xx_image_description_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_IMAGE_DESCRIPTION_V2_ERROR_NOT_READY:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_V2_ERROR_NO_INFORMATION:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_IMAGE_DESCRIPTION_V2_ERROR_ENUM */

#ifndef XX_IMAGE_DESCRIPTION_V2_CAUSE_ENUM
#define XX_IMAGE_DESCRIPTION_V2_CAUSE_ENUM
/**
 * @ingroup iface_xx_image_description_v2
 * generic reason for failure
 */
enum xx_image_description_v2_cause {
	/**
	 * interface version too low
	 */
	XX_IMAGE_DESCRIPTION_V2_CAUSE_LOW_VERSION = 0,
	/**
	 * unsupported image description data
	 */
	XX_IMAGE_DESCRIPTION_V2_CAUSE_UNSUPPORTED = 1,
	/**
	 * error independent of the client
	 */
	XX_IMAGE_DESCRIPTION_V2_CAUSE_OPERATING_SYSTEM = 2,
	/**
	 * the relevant output no longer exists
	 */
	XX_IMAGE_DESCRIPTION_V2_CAUSE_NO_OUTPUT = 3,
};
/**
 * @ingroup iface_xx_image_description_v2
 * Validate a xx_image_description_v2 cause value.
 *
 * @return true on success, false on error.
 * @ref xx_image_description_v2_cause
 */
static inline bool
xx_image_description_v2_cause_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_IMAGE_DESCRIPTION_V2_CAUSE_LOW_VERSION:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_V2_CAUSE_UNSUPPORTED:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_V2_CAUSE_OPERATING_SYSTEM:
		return version >= 1;
	case XX_IMAGE_DESCRIPTION_V2_CAUSE_NO_OUTPUT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_IMAGE_DESCRIPTION_V2_CAUSE_ENUM */

/**
 * @ingroup iface_xx_image_description_v2
 * @struct xx_image_description_v2_interface
 */
struct xx_image_description_v2_interface {
	/**
	 * destroy the image description
	 *
	 * Destroy this object. It is safe to destroy an object which is
	 * not ready.
	 *
	 * Destroying a xx_image_description_v2 object has no side-effects,
	 * not even if a
	 * xx_color_management_surface_v2.set_image_description has not yet
	 * been followed by a wl_surface.commit.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * get information about the image description
	 *
	 * Creates a xx_image_description_info_v2 object which delivers
	 * the information that makes up the image description.
	 *
	 * Not all image description protocol objects allow get_information
	 * request. Whether it is allowed or not is defined by the request
	 * that created the object. If get_information is not allowed, the
	 * protocol error no_information is raised.
	 */
	void (*get_information)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t information);
};

#define XX_IMAGE_DESCRIPTION_V2_FAILED 0
#define XX_IMAGE_DESCRIPTION_V2_READY 1

/**
 * @ingroup iface_xx_image_description_v2
 */
#define XX_IMAGE_DESCRIPTION_V2_FAILED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_v2
 */
#define XX_IMAGE_DESCRIPTION_V2_READY_SINCE_VERSION 1

/**
 * @ingroup iface_xx_image_description_v2
 */
#define XX_IMAGE_DESCRIPTION_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_v2
 */
#define XX_IMAGE_DESCRIPTION_V2_GET_INFORMATION_SINCE_VERSION 1

/**
 * @ingroup iface_xx_image_description_v2
 * Sends an failed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param cause generic reason
 * @param msg ad hoc human-readable explanation
 */
static inline void
xx_image_description_v2_send_failed(struct wl_resource *resource_, uint32_t cause, const char *msg)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_V2_FAILED, cause, msg);
}

/**
 * @ingroup iface_xx_image_description_v2
 * Sends an ready event to the client owning the resource.
 * @param resource_ The client's resource
 * @param identity image description id number
 */
static inline void
xx_image_description_v2_send_ready(struct wl_resource *resource_, uint32_t identity)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_V2_READY, identity);
}

#define XX_IMAGE_DESCRIPTION_INFO_V2_DONE 0
#define XX_IMAGE_DESCRIPTION_INFO_V2_ICC_FILE 1
#define XX_IMAGE_DESCRIPTION_INFO_V2_PRIMARIES 2
#define XX_IMAGE_DESCRIPTION_INFO_V2_PRIMARIES_NAMED 3
#define XX_IMAGE_DESCRIPTION_INFO_V2_TF_POWER 4
#define XX_IMAGE_DESCRIPTION_INFO_V2_TF_NAMED 5
#define XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_PRIMARIES 6
#define XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_LUMINANCE 7
#define XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_MAX_CLL 8
#define XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_MAX_FALL 9

/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_ICC_FILE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_PRIMARIES_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_PRIMARIES_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_TF_POWER_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_TF_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_PRIMARIES_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_LUMINANCE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_MAX_CLL_SINCE_VERSION 1
/**
 * @ingroup iface_xx_image_description_info_v2
 */
#define XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_MAX_FALL_SINCE_VERSION 1


/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_image_description_info_v2_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_DONE);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an icc_file event to the client owning the resource.
 * @param resource_ The client's resource
 * @param icc ICC profile file descriptor
 * @param icc_size ICC profile size, in bytes
 */
static inline void
xx_image_description_info_v2_send_icc_file(struct wl_resource *resource_, int32_t icc, uint32_t icc_size)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_ICC_FILE, icc, icc_size);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an primaries event to the client owning the resource.
 * @param resource_ The client's resource
 * @param r_x Red x * 10000
 * @param r_y Red y * 10000
 * @param g_x Green x * 10000
 * @param g_y Green y * 10000
 * @param b_x Blue x * 10000
 * @param b_y Blue y * 10000
 * @param w_x White x * 10000
 * @param w_y White y * 10000
 */
static inline void
xx_image_description_info_v2_send_primaries(struct wl_resource *resource_, uint32_t r_x, uint32_t r_y, uint32_t g_x, uint32_t g_y, uint32_t b_x, uint32_t b_y, uint32_t w_x, uint32_t w_y)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_PRIMARIES, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an primaries_named event to the client owning the resource.
 * @param resource_ The client's resource
 * @param primaries named primaries
 */
static inline void
xx_image_description_info_v2_send_primaries_named(struct wl_resource *resource_, uint32_t primaries)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_PRIMARIES_NAMED, primaries);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an tf_power event to the client owning the resource.
 * @param resource_ The client's resource
 * @param eexp the exponent * 10000
 */
static inline void
xx_image_description_info_v2_send_tf_power(struct wl_resource *resource_, uint32_t eexp)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_TF_POWER, eexp);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an tf_named event to the client owning the resource.
 * @param resource_ The client's resource
 * @param tf named transfer function
 */
static inline void
xx_image_description_info_v2_send_tf_named(struct wl_resource *resource_, uint32_t tf)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_TF_NAMED, tf);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an target_primaries event to the client owning the resource.
 * @param resource_ The client's resource
 * @param r_x Red x * 10000
 * @param r_y Red y * 10000
 * @param g_x Green x * 10000
 * @param g_y Green y * 10000
 * @param b_x Blue x * 10000
 * @param b_y Blue y * 10000
 * @param w_x White x * 10000
 * @param w_y White y * 10000
 */
static inline void
xx_image_description_info_v2_send_target_primaries(struct wl_resource *resource_, uint32_t r_x, uint32_t r_y, uint32_t g_x, uint32_t g_y, uint32_t b_x, uint32_t b_y, uint32_t w_x, uint32_t w_y)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_PRIMARIES, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an target_luminance event to the client owning the resource.
 * @param resource_ The client's resource
 * @param min_lum min L (cd/m²) * 10000
 * @param max_lum max L (cd/m²)
 */
static inline void
xx_image_description_info_v2_send_target_luminance(struct wl_resource *resource_, uint32_t min_lum, uint32_t max_lum)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_LUMINANCE, min_lum, max_lum);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an target_max_cll event to the client owning the resource.
 * @param resource_ The client's resource
 * @param max_cll Maximum content light-level (cd/m²)
 */
static inline void
xx_image_description_info_v2_send_target_max_cll(struct wl_resource *resource_, uint32_t max_cll)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_MAX_CLL, max_cll);
}

/**
 * @ingroup iface_xx_image_description_info_v2
 * Sends an target_max_fall event to the client owning the resource.
 * @param resource_ The client's resource
 * @param max_fall Maximum frame-average light level (cd/m²)
 */
static inline void
xx_image_description_info_v2_send_target_max_fall(struct wl_resource *resource_, uint32_t max_fall)
{
	wl_resource_post_event(resource_, XX_IMAGE_DESCRIPTION_INFO_V2_TARGET_MAX_FALL, max_fall);
}

#ifdef  __cplusplus
}
#endif

#endif
