/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.model.Guardrails;

public class MLGuard {
    @Generated
    private static final Logger log = LogManager.getLogger(MLGuard.class);
    private NamedXContentRegistry xContentRegistry;
    private Client client;
    private Guardrails guardrails;

    public MLGuard(Guardrails guardrails, NamedXContentRegistry xContentRegistry, Client client) {
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.guardrails = guardrails;
        if (this.guardrails != null && this.guardrails.getInputGuardrail() != null) {
            this.guardrails.getInputGuardrail().init(xContentRegistry, client);
        }
        if (this.guardrails != null && this.guardrails.getOutputGuardrail() != null) {
            this.guardrails.getOutputGuardrail().init(xContentRegistry, client);
        }
    }

    public Boolean validate(String input, Type type, Map<String, String> parameters) {
        switch (type) {
            case INPUT: {
                return this.guardrails.getInputGuardrail() == null ? true : this.guardrails.getInputGuardrail().validate(input, parameters);
            }
            case OUTPUT: {
                return this.guardrails.getOutputGuardrail() == null ? true : this.guardrails.getOutputGuardrail().validate(input, parameters);
            }
        }
        throw new IllegalArgumentException("Unsupported type to validate for guardrails.");
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public Guardrails getGuardrails() {
        return this.guardrails;
    }

    public static enum Type {
        INPUT,
        OUTPUT;

    }
}

