/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.hash;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.IntProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tribuo.hash.Hasher;

public final class ModHashCodeHasher
extends Hasher {
    private static final long serialVersionUID = 2L;
    static final String DIMENSION = "dimension";
    @Config(mandatory=true, redact=true, description="Salt used in the hash.")
    private transient String salt = null;
    @Config(mandatory=true, description="Range of the hashing function.")
    private int dimension = 100;
    private ModHashCodeHasherProvenance provenance;

    private ModHashCodeHasher() {
    }

    public ModHashCodeHasher(String salt) {
        this(100, salt);
    }

    public ModHashCodeHasher(int dimension, String salt) {
        this.dimension = dimension;
        this.salt = salt;
        this.postConfig();
    }

    public void postConfig() {
        this.provenance = new ModHashCodeHasherProvenance(this.dimension);
    }

    @Override
    public String hash(String name) {
        if (this.salt == null) {
            throw new IllegalStateException("Salt not set");
        }
        String salted = this.salt + name;
        return "" + salted.hashCode() % this.dimension;
    }

    @Override
    public void setSalt(String salt) {
        if (!Hasher.validateSalt(salt)) {
            throw new IllegalArgumentException("Salt: '" + salt + ", does not meet the requirements for a salt.");
        }
        this.salt = salt;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return this.provenance;
    }

    public String toString() {
        return "ModHashCodeHasher(dimension=" + this.dimension + ")";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.salt = null;
    }

    public static final class ModHashCodeHasherProvenance
    implements ConfiguredObjectProvenance {
        private static final long serialVersionUID = 1L;
        private final IntProvenance dimension;

        ModHashCodeHasherProvenance(int dimension) {
            this.dimension = new IntProvenance(ModHashCodeHasher.DIMENSION, dimension);
        }

        public ModHashCodeHasherProvenance(Map<String, Provenance> map) {
            this.dimension = (IntProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)ModHashCodeHasher.DIMENSION, IntProvenance.class, (String)ModHashCodeHasherProvenance.class.getSimpleName());
        }

        public Map<String, Provenance> getConfiguredParameters() {
            HashMap<String, Provenance> map = new HashMap<String, Provenance>();
            map.put("saltStr", (Provenance)new StringProvenance("saltStr", ""));
            map.put(ModHashCodeHasher.DIMENSION, (Provenance)this.dimension);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModHashCodeHasherProvenance)) {
                return false;
            }
            ModHashCodeHasherProvenance pairs = (ModHashCodeHasherProvenance)o;
            return this.dimension.equals((Object)pairs.dimension);
        }

        public int hashCode() {
            return Objects.hash(this.dimension);
        }

        public String getClassName() {
            return ModHashCodeHasher.class.getName();
        }

        public String toString() {
            return this.generateString("Hasher");
        }
    }
}

