/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.repackage.com.google.common.annotations.VisibleForTesting;

@ToolAnnotation(value="MLModelTool")
public class MLModelTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(MLModelTool.class);
    public static final String TYPE = "MLModelTool";
    public static final String RESPONSE_FIELD = "response_field";
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String DEFAULT_RESPONSE_FIELD = "response";
    private String name = "MLModelTool";
    @VisibleForTesting
    static String DEFAULT_DESCRIPTION = "Use this tool to run any model.";
    private String description = DEFAULT_DESCRIPTION;
    private Client client;
    private String modelId;
    private Parser inputParser;
    @VisibleForTesting
    private Parser outputParser;
    private String responseField;

    public MLModelTool(Client client, String modelId, String responseField) {
        this.client = client;
        this.modelId = modelId;
        this.responseField = responseField;
        this.outputParser = o -> {
            try {
                List mlModelOutputs = (List)o;
                Map dataAsMap = ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap();
                if (dataAsMap.containsKey(responseField)) {
                    return dataAsMap.get(responseField);
                }
                return StringUtils.toJson((Object)dataAsMap);
            }
            catch (Exception e) {
                throw new IllegalStateException("LLM returns wrong or empty tensors", e);
            }
        };
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(parameters).build();
        MLPredictionTaskRequest request = new MLPredictionTaskRequest(this.modelId, MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inputDataSet).build());
        this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
            ModelTensorOutput modelTensorOutput = (ModelTensorOutput)r.getOutput();
            modelTensorOutput.getMlModelOutputs();
            listener.onResponse(this.outputParser.parse((Object)modelTensorOutput.getMlModelOutputs()));
        }, e -> {
            log.error("Failed to run model " + this.modelId, (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() != 0;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public void setInputParser(Parser inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    @Generated
    public Parser getOutputParser() {
        return this.outputParser;
    }

    @Generated
    public void setResponseField(String responseField) {
        this.responseField = responseField;
    }

    @Generated
    public String getResponseField() {
        return this.responseField;
    }

    public static class Factory
    implements Tool.Factory<MLModelTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<MLModelTool> clazz = MLModelTool.class;
            synchronized (MLModelTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public MLModelTool create(Map<String, Object> map) {
            return new MLModelTool(this.client, (String)map.get(MLModelTool.MODEL_ID_FIELD), (String)map.getOrDefault(MLModelTool.RESPONSE_FIELD, MLModelTool.DEFAULT_RESPONSE_FIELD));
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return MLModelTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

