/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;

public class OWLLiteralReplacer {
    private final OWLOntologyManager owlOntologyManager;
    private final Set<OWLOntology> ontologies;

    public OWLLiteralReplacer(@Nonnull OWLOntologyManager owlOntologyManager, @Nonnull Set<OWLOntology> ontologies) {
        this.owlOntologyManager = OWLAPIPreconditions.checkNotNull(owlOntologyManager, "owlOntologyManager cannot be null");
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
    }

    @Nonnull
    public List<OWLOntologyChange> changeLiteral(@Nonnull OWLLiteral literal, @Nonnull OWLLiteral newLiteral) {
        OWLAPIPreconditions.checkNotNull(literal, "literal cannot be null");
        OWLAPIPreconditions.checkNotNull(newLiteral, "newLiteral cannot be null");
        HashMap<OWLLiteral, OWLLiteral> uriMap = new HashMap<OWLLiteral, OWLLiteral>();
        uriMap.put(literal, newLiteral);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator dup = new OWLObjectDuplicator(this.owlOntologyManager.getOWLDataFactory(), Collections.emptyMap(), uriMap);
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            OWLLiteralReplacer.fillListWithTransformChanges(changes, OWLLiteralReplacer.getAxioms(ont, literal), ont, dup);
        }
        return changes;
    }

    public List<OWLOntologyChange> changeLiterals(@Nonnull Map<OWLLiteral, OWLLiteral> literalToLiteralMap) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator duplicator = new OWLObjectDuplicator(Collections.emptyMap(), this.owlOntologyManager.getOWLDataFactory(), literalToLiteralMap, new RemappingIndividualProvider(this.owlOntologyManager.getOWLDataFactory(), false));
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            for (OWLLiteral ent : literalToLiteralMap.keySet()) {
                assert (ent != null);
                OWLLiteralReplacer.fillListWithTransformChanges(changes, OWLLiteralReplacer.getAxioms(ont, ent), ont, duplicator);
            }
        }
        return changes;
    }

    private static Set<OWLAxiom> getAxioms(@Nonnull OWLOntology ont, @Nonnull OWLLiteral entity) {
        Set<OWLAxiom> axioms = ont.getReferencingAxioms((OWLPrimitive)entity, Imports.EXCLUDED);
        axioms.addAll(ont.getDeclarationAxioms(entity.getDatatype()));
        return axioms;
    }

    private static void fillListWithTransformChanges(List<OWLOntologyChange> changes, Set<OWLAxiom> axioms, @Nonnull OWLOntology ont, OWLObjectDuplicator duplicator) {
        for (OWLAxiom ax : axioms) {
            assert (ax != null);
            changes.add(new RemoveAxiom(ont, ax));
            OWLAxiom dupAx = (OWLAxiom)duplicator.duplicateObject(ax);
            changes.add(new AddAxiom(ont, dupAx));
        }
    }
}

