/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.http.HttpServlet;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapperFacade;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.security.SecurityUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.PeriodicEventListener;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.Util;

public class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper,
NotificationEmitter {
    private final Log log = LogFactory.getLog(StandardWrapper.class);
    protected static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD", "POST"};
    protected long available = 0L;
    protected final NotificationBroadcasterSupport broadcaster;
    protected final AtomicInteger countAllocated = new AtomicInteger(0);
    protected final StandardWrapperFacade facade = new StandardWrapperFacade(this);
    protected volatile Servlet instance = null;
    protected volatile boolean instanceInitialized = false;
    protected int loadOnStartup = -1;
    protected final ArrayList<String> mappings = new ArrayList();
    protected HashMap<String, String> parameters = new HashMap();
    protected HashMap<String, String> references = new HashMap();
    protected String runAs = null;
    protected long sequenceNumber = 0L;
    protected String servletClass = null;
    protected volatile boolean unloading = false;
    protected long unloadDelay = 2000L;
    protected boolean isJspServlet;
    protected ObjectName jspMonitorON;
    protected boolean swallowOutput = false;
    protected StandardWrapperValve swValve;
    protected long loadTime = 0L;
    protected int classLoadTime = 0;
    protected MultipartConfigElement multipartConfigElement = null;
    protected boolean asyncSupported = false;
    protected boolean enabled = true;
    private boolean overridable = false;
    protected static Class<?>[] classType = new Class[]{ServletConfig.class};
    private final ReentrantReadWriteLock parametersLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock mappingsLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock referencesLock = new ReentrantReadWriteLock();
    protected MBeanNotificationInfo[] notificationInfo;

    public StandardWrapper() {
        this.swValve = new StandardWrapperValve();
        this.pipeline.setBasic(this.swValve);
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    @Override
    public boolean isOverridable() {
        return this.overridable;
    }

    @Override
    public void setOverridable(boolean bl) {
        this.overridable = bl;
    }

    @Override
    public long getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(long l) {
        long l2 = this.available;
        this.available = l > System.currentTimeMillis() ? l : 0L;
        this.support.firePropertyChange("available", l2, this.available);
    }

    public int getCountAllocated() {
        return this.countAllocated.get();
    }

    @Override
    public int getLoadOnStartup() {
        if (this.isJspServlet && this.loadOnStartup == -1) {
            return Integer.MAX_VALUE;
        }
        return this.loadOnStartup;
    }

    @Override
    public void setLoadOnStartup(int n) {
        int n2 = this.loadOnStartup;
        this.loadOnStartup = n;
        this.support.firePropertyChange("loadOnStartup", (Object)n2, (Object)this.loadOnStartup);
    }

    public void setLoadOnStartupString(String string) {
        try {
            this.setLoadOnStartup(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.setLoadOnStartup(0);
        }
    }

    public String getLoadOnStartupString() {
        return Integer.toString(this.getLoadOnStartup());
    }

    @Override
    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardWrapper.notContext"));
        }
        if (container instanceof StandardContext) {
            this.swallowOutput = ((StandardContext)container).getSwallowOutput();
            this.unloadDelay = ((StandardContext)container).getUnloadDelay();
        }
        super.setParent(container);
    }

    @Override
    public String getRunAs() {
        return this.runAs;
    }

    @Override
    public void setRunAs(String string) {
        String string2 = this.runAs;
        this.runAs = string;
        this.support.firePropertyChange("runAs", string2, this.runAs);
    }

    @Override
    public String getServletClass() {
        return this.servletClass;
    }

    @Override
    public void setServletClass(String string) {
        String string2 = this.servletClass;
        this.servletClass = string;
        this.support.firePropertyChange("servletClass", string2, this.servletClass);
        if ("org.apache.jasper.servlet.JspServlet".equals(string)) {
            this.isJspServlet = true;
        }
    }

    public void setServletName(String string) {
        this.setName(string);
    }

    @Override
    public boolean isUnavailable() {
        if (!this.isEnabled()) {
            return true;
        }
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    @Override
    public String[] getServletMethods() throws ServletException {
        this.instance = this.loadServlet();
        Class<?> clazz = this.instance.getClass();
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            return DEFAULT_SERVLET_METHODS;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("OPTIONS");
        if (this.isJspServlet) {
            hashSet.add("GET");
            hashSet.add("HEAD");
            hashSet.add("POST");
        } else {
            hashSet.add("TRACE");
            Method[] methodArray = this.getAllDeclaredMethods(clazz);
            for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (method.getName().equals("doGet")) {
                    hashSet.add("GET");
                    hashSet.add("HEAD");
                    continue;
                }
                if (method.getName().equals("doPost")) {
                    hashSet.add("POST");
                    continue;
                }
                if (method.getName().equals("doPut")) {
                    hashSet.add("PUT");
                    continue;
                }
                if (!method.getName().equals("doDelete")) continue;
                hashSet.add("DELETE");
            }
        }
        return hashSet.toArray(new String[0]);
    }

    @Override
    public Servlet getServlet() {
        return this.instance;
    }

    @Override
    public void setServlet(Servlet servlet) {
        this.instance = servlet;
    }

    @Override
    public synchronized void backgroundProcess() {
        super.backgroundProcess();
        if (!this.getState().isAvailable()) {
            return;
        }
        if (this.getServlet() instanceof PeriodicEventListener) {
            ((PeriodicEventListener)this.getServlet()).periodicEvent();
        }
    }

    public static Throwable getRootCause(ServletException servletException) {
        Throwable throwable = servletException;
        Throwable throwable2 = null;
        int n = 0;
        do {
            ++n;
            throwable2 = throwable.getCause();
            if (throwable2 == null) continue;
            throwable = throwable2;
        } while (throwable2 != null && n < 20);
        return throwable;
    }

    @Override
    public void addChild(Container container) {
        throw new IllegalStateException(sm.getString("standardWrapper.notChild"));
    }

    @Override
    public void addInitParameter(String string, String string2) {
        this.parametersLock.writeLock().lock();
        try {
            this.parameters.put(string, string2);
        }
        finally {
            this.parametersLock.writeLock().unlock();
        }
        this.fireContainerEvent("addInitParameter", string);
    }

    @Override
    public void addMapping(String string) {
        this.mappingsLock.writeLock().lock();
        try {
            this.mappings.add(string);
        }
        finally {
            this.mappingsLock.writeLock().unlock();
        }
        if (this.parent.getState().equals((Object)LifecycleState.STARTED)) {
            this.fireContainerEvent("addMapping", string);
        }
    }

    @Override
    public void addSecurityReference(String string, String string2) {
        this.referencesLock.writeLock().lock();
        try {
            this.references.put(string, string2);
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.fireContainerEvent("addSecurityReference", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Servlet allocate() throws ServletException {
        if (this.unloading) {
            throw new ServletException(sm.getString("standardWrapper.unloading", new Object[]{this.getName()}));
        }
        boolean bl = false;
        if (this.instance == null || !this.instanceInitialized) {
            StandardWrapper standardWrapper = this;
            synchronized (standardWrapper) {
                if (this.instance == null) {
                    try {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Allocating instance");
                        }
                        this.instance = this.loadServlet();
                        bl = true;
                        this.countAllocated.incrementAndGet();
                    }
                    catch (ServletException servletException) {
                        throw servletException;
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        throw new ServletException(sm.getString("standardWrapper.allocate"), throwable);
                    }
                }
                if (!this.instanceInitialized) {
                    this.initServlet(this.instance);
                }
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"  Returning instance");
        }
        if (!bl) {
            this.countAllocated.incrementAndGet();
        }
        return this.instance;
    }

    @Override
    public void deallocate(Servlet servlet) throws ServletException {
        this.countAllocated.decrementAndGet();
    }

    @Override
    public String findInitParameter(String string) {
        this.parametersLock.readLock().lock();
        try {
            String string2 = this.parameters.get(string);
            return string2;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    @Override
    public String[] findInitParameters() {
        this.parametersLock.readLock().lock();
        try {
            String[] stringArray = this.parameters.keySet().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    @Override
    public String[] findMappings() {
        this.mappingsLock.readLock().lock();
        try {
            String[] stringArray = this.mappings.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.mappingsLock.readLock().unlock();
        }
    }

    @Override
    public String findSecurityReference(String string) {
        String string2 = null;
        this.referencesLock.readLock().lock();
        try {
            string2 = this.references.get(string);
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        if (this.getParent() instanceof Context) {
            Context context = (Context)this.getParent();
            string2 = string2 != null ? context.findRoleMapping(string2) : context.findRoleMapping(string);
        }
        return string2;
    }

    @Override
    public String[] findSecurityReferences() {
        this.referencesLock.readLock().lock();
        try {
            String[] stringArray = this.references.keySet().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
    }

    @Override
    public synchronized void load() throws ServletException {
        this.instance = this.loadServlet();
        if (!this.instanceInitialized) {
            this.initServlet(this.instance);
        }
        if (this.isJspServlet) {
            StringBuilder stringBuilder = new StringBuilder(this.getDomain());
            stringBuilder.append(":type=JspMonitor");
            stringBuilder.append(this.getWebModuleKeyProperties());
            stringBuilder.append(",name=");
            stringBuilder.append(this.getName());
            stringBuilder.append(this.getJ2EEKeyProperties());
            try {
                this.jspMonitorON = new ObjectName(stringBuilder.toString());
                Registry.getRegistry(null, null).registerComponent((Object)this.instance, this.jspMonitorON, null);
            }
            catch (Exception exception) {
                this.log.warn((Object)sm.getString("standardWrapper.jspMonitorError", new Object[]{this.instance}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Servlet loadServlet() throws ServletException {
        Servlet servlet;
        if (this.instance != null) {
            return this.instance;
        }
        PrintStream printStream = System.out;
        if (this.swallowOutput) {
            SystemLogHandler.startCapture();
        }
        try {
            MultipartConfig multipartConfig;
            long l = System.currentTimeMillis();
            if (this.servletClass == null) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.notClass", new Object[]{this.getName()}));
            }
            InstanceManager instanceManager = ((StandardContext)this.getParent()).getInstanceManager();
            try {
                servlet = (Servlet)instanceManager.newInstance(this.servletClass);
            }
            catch (ClassCastException classCastException) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.notServlet", new Object[]{this.servletClass}), (Throwable)classCastException);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
                this.unavailable(null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("standardWrapper.instantiate", new Object[]{this.servletClass}), throwable2);
                }
                throw new ServletException(sm.getString("standardWrapper.instantiate", new Object[]{this.servletClass}), throwable2);
            }
            if (this.multipartConfigElement == null && (multipartConfig = servlet.getClass().getAnnotation(MultipartConfig.class)) != null) {
                this.multipartConfigElement = new MultipartConfigElement(multipartConfig);
            }
            if (servlet instanceof ContainerServlet) {
                ((ContainerServlet)servlet).setWrapper(this);
            }
            this.classLoadTime = (int)(System.currentTimeMillis() - l);
            this.initServlet(servlet);
            this.fireContainerEvent("load", this);
            this.loadTime = System.currentTimeMillis() - l;
        }
        finally {
            String string;
            if (this.swallowOutput && (string = SystemLogHandler.stopCapture()) != null && string.length() > 0) {
                if (this.getServletContext() != null) {
                    this.getServletContext().log(string);
                } else {
                    printStream.println(string);
                }
            }
        }
        return servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initServlet(Servlet servlet) throws ServletException {
        if (this.instanceInitialized) {
            return;
        }
        try {
            if (Globals.IS_SECURITY_ENABLED) {
                boolean bl = false;
                try {
                    Object[] objectArray = new Object[]{this.facade};
                    SecurityUtil.doAsPrivilege("init", servlet, classType, objectArray);
                    bl = true;
                }
                finally {
                    if (!bl) {
                        SecurityUtil.remove(servlet);
                    }
                }
            } else {
                servlet.init((ServletConfig)this.facade);
            }
            this.instanceInitialized = true;
        }
        catch (UnavailableException unavailableException) {
            this.unavailable(unavailableException);
            throw unavailableException;
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.getServletContext().log(sm.getString("standardWrapper.initException", new Object[]{this.getName()}), throwable);
            throw new ServletException(sm.getString("standardWrapper.initException", new Object[]{this.getName()}), throwable);
        }
    }

    @Override
    public void removeInitParameter(String string) {
        this.parametersLock.writeLock().lock();
        try {
            this.parameters.remove(string);
        }
        finally {
            this.parametersLock.writeLock().unlock();
        }
        this.fireContainerEvent("removeInitParameter", string);
    }

    @Override
    public void removeMapping(String string) {
        this.mappingsLock.writeLock().lock();
        try {
            this.mappings.remove(string);
        }
        finally {
            this.mappingsLock.writeLock().unlock();
        }
        if (this.parent.getState().equals((Object)LifecycleState.STARTED)) {
            this.fireContainerEvent("removeMapping", string);
        }
    }

    @Override
    public void removeSecurityReference(String string) {
        this.referencesLock.writeLock().lock();
        try {
            this.references.remove(string);
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.fireContainerEvent("removeSecurityReference", string);
    }

    @Override
    public void unavailable(UnavailableException unavailableException) {
        this.getServletContext().log(sm.getString("standardWrapper.unavailable", new Object[]{this.getName()}));
        if (unavailableException == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailableException.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int n = unavailableException.getUnavailableSeconds();
            if (n <= 0) {
                n = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)n * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void unload() throws ServletException {
        if (this.instance == null) {
            return;
        }
        this.unloading = true;
        if (this.countAllocated.get() > 0) {
            long l = this.unloadDelay / 20L;
            for (int i = 0; i < 21 && this.countAllocated.get() > 0; ++i) {
                if (i % 10 == 0) {
                    this.log.info((Object)sm.getString("standardWrapper.waiting", new Object[]{this.countAllocated.toString(), this.getName()}));
                }
                try {
                    Thread.sleep(l);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.instanceInitialized) {
            String string;
            PrintStream printStream;
            block29: {
                printStream = System.out;
                if (this.swallowOutput) {
                    SystemLogHandler.startCapture();
                }
                try {
                    if (Globals.IS_SECURITY_ENABLED) {
                        try {
                            SecurityUtil.doAsPrivilege("destroy", this.instance);
                        }
                        finally {
                            SecurityUtil.remove(this.instance);
                        }
                    } else {
                        this.instance.destroy();
                    }
                    if (((Context)this.getParent()).getIgnoreAnnotations()) break block29;
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                        ExceptionUtils.handleThrowable((Throwable)throwable2);
                        this.fireContainerEvent("unload", this);
                        this.unloading = false;
                        throw new ServletException(sm.getString("standardWrapper.destroyException", new Object[]{this.getName()}), throwable2);
                    }
                    catch (Throwable throwable3) {
                        String string2;
                        if (!((Context)this.getParent()).getIgnoreAnnotations()) {
                            try {
                                ((Context)this.getParent()).getInstanceManager().destroyInstance((Object)this.instance);
                            }
                            catch (Throwable throwable4) {
                                ExceptionUtils.handleThrowable((Throwable)throwable4);
                                this.log.error((Object)sm.getString("standardWrapper.destroyInstance", new Object[]{this.getName()}), throwable4);
                            }
                        }
                        if (this.swallowOutput && (string2 = SystemLogHandler.stopCapture()) != null && string2.length() > 0) {
                            if (this.getServletContext() != null) {
                                this.getServletContext().log(string2);
                            } else {
                                printStream.println(string2);
                            }
                        }
                        this.instance = null;
                        this.instanceInitialized = false;
                        throw throwable3;
                    }
                }
                try {
                    ((Context)this.getParent()).getInstanceManager().destroyInstance((Object)this.instance);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.log.error((Object)sm.getString("standardWrapper.destroyInstance", new Object[]{this.getName()}), throwable);
                }
            }
            if (this.swallowOutput && (string = SystemLogHandler.stopCapture()) != null && string.length() > 0) {
                if (this.getServletContext() != null) {
                    this.getServletContext().log(string);
                } else {
                    printStream.println(string);
                }
            }
            this.instance = null;
            this.instanceInitialized = false;
        }
        this.instance = null;
        if (this.isJspServlet && this.jspMonitorON != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.jspMonitorON);
        }
        this.unloading = false;
        this.fireContainerEvent("unload", this);
    }

    public String getInitParameter(String string) {
        return this.findInitParameter(string);
    }

    public Enumeration<String> getInitParameterNames() {
        this.parametersLock.readLock().lock();
        try {
            Enumeration<String> enumeration = Collections.enumeration(this.parameters.keySet());
            return enumeration;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    public String getServletName() {
        return this.getName();
    }

    public long getProcessingTime() {
        return this.swValve.getProcessingTime();
    }

    public long getMaxTime() {
        return this.swValve.getMaxTime();
    }

    public long getMinTime() {
        return this.swValve.getMinTime();
    }

    @Deprecated
    public int getRequestCount() {
        return this.swValve.getRequestCount();
    }

    @Deprecated
    public int getErrorCount() {
        return this.swValve.getErrorCount();
    }

    @Override
    public void incrementErrorCount() {
        this.swValve.incrementErrorCount();
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public int getClassLoadTime() {
        return this.classLoadTime;
    }

    @Override
    public MultipartConfigElement getMultipartConfigElement() {
        return this.multipartConfigElement;
    }

    @Override
    public void setMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
        this.multipartConfigElement = multipartConfigElement;
    }

    @Override
    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    @Override
    public void setAsyncSupported(boolean bl) {
        this.asyncSupported = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected Method[] getAllDeclaredMethods(Class<?> clazz) {
        if (clazz.equals(HttpServlet.class)) {
            return null;
        }
        Method[] methodArray = this.getAllDeclaredMethods(clazz.getSuperclass());
        Method[] methodArray2 = clazz.getDeclaredMethods();
        if (methodArray2.length == 0) {
            return methodArray;
        }
        if (methodArray != null && methodArray.length > 0) {
            Method[] methodArray3 = new Method[methodArray.length + methodArray2.length];
            System.arraycopy(methodArray, 0, methodArray3, 0, methodArray.length);
            System.arraycopy(methodArray2, 0, methodArray3, methodArray.length, methodArray2.length);
            methodArray2 = methodArray3;
        }
        return methodArray2;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        Notification notification;
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.startInternal();
        this.setAvailable(0L);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        Notification notification;
        this.setAvailable(Long.MAX_VALUE);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        try {
            this.unload();
        }
        catch (ServletException servletException) {
            this.getServletContext().log(sm.getString("standardWrapper.unloadException", new Object[]{this.getName()}), (Throwable)servletException);
        }
        super.stopInternal();
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
        this.broadcaster.sendNotification(notification);
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("j2eeType=Servlet");
        stringBuilder.append(this.getWebModuleKeyProperties());
        stringBuilder.append(",name=");
        String string = this.getName();
        if (Util.objectNameValueNeedsQuote((String)string)) {
            string = ObjectName.quote(string);
        }
        stringBuilder.append(string);
        stringBuilder.append(this.getJ2EEKeyProperties());
        return stringBuilder.toString();
    }

    private String getWebModuleKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder(",WebModule=//");
        String string = this.getParent().getParent().getName();
        if (string == null) {
            stringBuilder.append("DEFAULT");
        } else {
            stringBuilder.append(string);
        }
        String string2 = this.getParent().getName();
        if (!string2.startsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private String getJ2EEKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder(",J2EEApplication=");
        StandardContext standardContext = null;
        if (this.parent instanceof StandardContext) {
            standardContext = (StandardContext)this.getParent();
        }
        if (standardContext == null) {
            stringBuilder.append("none");
        } else {
            stringBuilder.append(standardContext.getJ2EEApplication());
        }
        stringBuilder.append(",J2EEServer=");
        if (standardContext == null) {
            stringBuilder.append("none");
        } else {
            stringBuilder.append(standardContext.getJ2EEServer());
        }
        return stringBuilder.toString();
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            this.notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"j2ee.object.created"}, Notification.class.getName(), "servlet is created"), new MBeanNotificationInfo(new String[]{"j2ee.state.starting"}, Notification.class.getName(), "servlet is starting"), new MBeanNotificationInfo(new String[]{"j2ee.state.running"}, Notification.class.getName(), "servlet is running"), new MBeanNotificationInfo(new String[]{"j2ee.state.stopped"}, Notification.class.getName(), "servlet start to stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.stopped"}, Notification.class.getName(), "servlet is stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.deleted"}, Notification.class.getName(), "servlet is deleted")};
        }
        return this.notificationInfo;
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener);
    }
}

