/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.explorer.ExplorerContextMenuFactory;
import org.graalvm.visualvm.core.explorer.ExplorerModelBuilder;
import org.graalvm.visualvm.core.explorer.ExplorerNodeRenderer;
import org.graalvm.visualvm.core.explorer.ExplorerSupport;
import org.graalvm.visualvm.uisupport.UISupport;

class ExplorerComponent
extends JPanel {
    private static final Color MAC_TREE_BG_FOCUSED = new Color(214, 221, 229);
    private static final Color MAC_TREE_BG_NOTFOCUSED = new Color(232, 232, 232);
    private static ExplorerComponent instance;
    private JTree explorerTree;
    private boolean vetoTreeExpansion = false;

    public static synchronized ExplorerComponent instance() {
        if (instance == null) {
            instance = new ExplorerComponent();
        }
        return instance;
    }

    private ExplorerComponent() {
        this.initComponents();
    }

    public JTree getTree() {
        return this.explorerTree;
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.explorerTree != null) {
            return this.explorerTree.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.explorerTree = new JTree(ExplorerModelBuilder.getInstance().getModel()){
            private Window window;
            private WindowFocusListener focusListener;

            @Override
            protected void processMouseEvent(MouseEvent e) {
                Set<DataSource> selectedDataSources;
                ExplorerComponent.this.vetoTreeExpansion = false;
                if (e.getModifiers() == 16 && e.getClickCount() >= this.getToggleClickCount() && ExplorerComponent.getDefaultAction(selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources()) != null) {
                    ExplorerComponent.this.vetoTreeExpansion = true;
                }
                super.processMouseEvent(e);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.setCellRenderer(new ExplorerNodeRenderer());
            }

            @Override
            public void addNotify() {
                if (UISupport.isAquaLookAndFeel()) {
                    this.setWindow();
                }
                super.addNotify();
            }

            @Override
            public void removeNotify() {
                if (UISupport.isAquaLookAndFeel()) {
                    this.resetWindow();
                }
                super.removeNotify();
            }

            private void setWindow() {
                this.window = SwingUtilities.getWindowAncestor(this);
                if (this.window != null) {
                    if (this.focusListener == null) {
                        this.focusListener = new WindowFocusListener(){

                            @Override
                            public void windowGainedFocus(WindowEvent e) {
                                this.repaint();
                            }

                            @Override
                            public void windowLostFocus(WindowEvent e) {
                                this.repaint();
                            }
                        };
                    }
                    this.window.addWindowFocusListener(this.focusListener);
                }
            }

            private void resetWindow() {
                if (this.window != null && this.focusListener != null) {
                    this.window.removeWindowFocusListener(this.focusListener);
                    this.window = null;
                }
            }

            @Override
            public Color getBackground() {
                if (!UISupport.isAquaLookAndFeel()) {
                    return super.getBackground();
                }
                return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == this.window ? MAC_TREE_BG_FOCUSED : MAC_TREE_BG_NOTFOCUSED;
            }
        };
        this.explorerTree.setRootVisible(false);
        this.explorerTree.setShowsRootHandles(true);
        this.explorerTree.setRowHeight(ExplorerComponent.getTreeRowHeight());
        this.explorerTree.setCellRenderer(new ExplorerNodeRenderer());
        this.explorerTree.getSelectionModel().setSelectionMode(4);
        this.explorerTree.addKeyListener(new ExplorerTreeKeyAdapter());
        this.explorerTree.addMouseListener(new ExplorerTreeMouseAdapter());
        JScrollPane explorerTreeScrollPane = new JScrollPane(this.explorerTree, 20, 30);
        explorerTreeScrollPane.setBorder(BorderFactory.createEmptyBorder());
        explorerTreeScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        String DEFAULT_ACTION_KEY = "DEFAULT_ACTION";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), DEFAULT_ACTION_KEY);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), DEFAULT_ACTION_KEY);
        this.getActionMap().put(DEFAULT_ACTION_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerComponent.this.performDefaultAction();
            }
        });
        this.explorerTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (!ExplorerComponent.this.vetoTreeExpansion) {
                    return;
                }
                ExplorerComponent.this.vetoTreeExpansion = false;
                throw new ExpandVetoException(event);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (!ExplorerComponent.this.vetoTreeExpansion) {
                    return;
                }
                ExplorerComponent.this.vetoTreeExpansion = false;
                throw new ExpandVetoException(event);
            }
        });
        this.add((Component)explorerTreeScrollPane, "Center");
    }

    private static int getTreeRowHeight() {
        return new JLabel((String)"XXX").getPreferredSize().height + 4;
    }

    private static Action getDefaultAction(Set<DataSource> dataSources) {
        return ExplorerContextMenuFactory.instance().getDefaultActionFor(dataSources);
    }

    private void performDefaultAction() {
        Set<DataSource> selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
        Action defaultAction = ExplorerComponent.getDefaultAction(selectedDataSources);
        if (defaultAction != null) {
            defaultAction.actionPerformed(new ActionEvent(selectedDataSources, 0, "Default Action"));
        }
    }

    private void displayContextMenu(int x, int y) {
        JPopupMenu popupMenu = ExplorerContextMenuFactory.instance().createPopupMenu();
        if (popupMenu != null) {
            popupMenu.show(this.explorerTree, x, y);
        }
    }

    private class ExplorerTreeMouseAdapter
    extends MouseAdapter {
        private ExplorerTreeMouseAdapter() {
        }

        private void updatePathSelection(TreePath path, MouseEvent e) {
            if (path != null) {
                if (!ExplorerComponent.this.explorerTree.isPathSelected(path)) {
                    ExplorerComponent.this.explorerTree.setSelectionPath(path);
                }
            } else {
                ExplorerComponent.this.explorerTree.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath path = ExplorerComponent.this.explorerTree.getPathForLocation(e.getX(), e.getY());
            this.updatePathSelection(path, e);
            if (e.isPopupTrigger()) {
                ExplorerComponent.this.displayContextMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TreePath path = ExplorerComponent.this.explorerTree.getPathForLocation(e.getX(), e.getY());
            this.updatePathSelection(path, e);
            if (e.isPopupTrigger()) {
                ExplorerComponent.this.displayContextMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == ExplorerComponent.this.explorerTree.getToggleClickCount()) {
                ExplorerComponent.this.performDefaultAction();
            }
        }
    }

    private class ExplorerTreeKeyAdapter
    extends KeyAdapter {
        private ExplorerTreeKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) {
                int y;
                int x;
                e.consume();
                TreePath path = ExplorerComponent.this.explorerTree.getSelectionPath();
                if (path != null) {
                    Rectangle pathRect = ExplorerComponent.this.explorerTree.getPathBounds(path);
                    x = pathRect.x;
                    y = pathRect.y;
                } else {
                    Point pathPoint = new Point(ExplorerComponent.this.explorerTree.getWidth() / 3, ExplorerComponent.this.explorerTree.getHeight() / 3);
                    x = pathPoint.x;
                    y = pathPoint.y;
                }
                ExplorerComponent.this.displayContextMenu(x, y);
            }
        }
    }
}

