/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.JSJSONParser;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.symmetry.CIPDataSmiles;
import org.jmol.symmetry.CLEG;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SpaceGroupFinder;
import org.jmol.symmetry.SymmetryDesc;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.symmetry.UnitCellIterator;
import org.jmol.symmetry.WyckoffFinder;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class Symmetry
implements SymmetryInterface {
    private static SymmetryDesc nullDesc;
    private static Map<String, Object> aflowStructures;
    private static Map<String, Object>[] itaData;
    private static Map<String, Object>[] itaSubData;
    private static Lst<Object> allDataITA;
    private static WyckoffFinder wyckoffFinder;
    private static CLEG clegInstance;
    public SpaceGroup spaceGroup;
    public UnitCell unitCell;
    public boolean isBio;
    PointGroup pointGroup;
    CIPChirality cip;
    private SymmetryInfo symmetryInfo;
    private SymmetryDesc desc;
    private M4 transformMatrix;
    private Viewer vwr = null;

    @Override
    public String[] getSymopList(boolean doNormalize) {
        int n = this.spaceGroup.operationCount;
        String[] list = new String[n];
        for (int i = 0; i < n; ++i) {
            list[i] = "" + this.getSpaceGroupXyz(i, doNormalize);
        }
        return list;
    }

    @Override
    public boolean isBio() {
        return this.isBio;
    }

    @Override
    public SymmetryInterface setPointGroup(Viewer vwr, SymmetryInterface siLast, T3 center, T3[] atomset, BS bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance, int maxAtoms, boolean localEnvOnly) {
        this.pointGroup = PointGroup.getPointGroup(siLast == null ? null : ((Symmetry)siLast).pointGroup, center, atomset, bsAtoms, haveVibration, distanceTolerance, linearTolerance, maxAtoms, localEnvOnly, vwr.getBoolean(603979956), vwr.getScalePixelsPerAngstrom(false));
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int modelIndex, String drawID, boolean asInfo, String type, int index, float scale) {
        if (drawID == null && !asInfo && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (drawID == null && this.pointGroup.isDrawType(type, index, scale)) {
            return this.pointGroup.drawInfo;
        }
        if (asInfo && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(modelIndex, drawID, asInfo, type, index, scale);
    }

    @Override
    public void setSpaceGroup(boolean doNormalize) {
        this.symmetryInfo = null;
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, doNormalize, false);
        }
    }

    @Override
    public int addSpaceGroupOperation(String xyz, int opId) {
        return this.spaceGroup.addSymmetry(xyz, opId, false);
    }

    @Override
    public int addBioMoleculeOperation(M4 mat, boolean isReverse) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry((isReverse ? "!" : "") + "[[bio" + mat, 0, false);
    }

    @Override
    public void setLattice(int latt) {
        this.spaceGroup.setLatticeParam(latt);
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public Object getSpaceGroupInfoObj(String name, Object params, boolean isFull, boolean addNonstandard) {
        boolean isNorT = false;
        switch (name) {
            case "list": {
                return this.getSpaceGroupList((Integer)params);
            }
            case "opsCtr": {
                return this.spaceGroup.getOpsCtr((String)params);
            }
            case "itaTransform": 
            case "itaNumber": {
                isNorT = true;
            }
            case "nameToXYZList": 
            case "itaIndex": 
            case "hmName": {
                SpaceGroup sg = null;
                if (params != null) {
                    String s = (String)params;
                    if (s.endsWith("'")) {
                        s = SpaceGroup.convertWyckoffHMCleg(s, null);
                        if (isNorT && s != null) {
                            int pt = s.indexOf(":");
                            return "itaNumber".equals(name) ? s.substring(0, pt) : s.substring(pt + 1);
                        }
                        return null;
                    }
                    sg = SpaceGroup.determineSpaceGroupN(s);
                    if (sg == null && "nameToXYZList".equals(name)) {
                        sg = SpaceGroup.createSpaceGroupN(s, true);
                    }
                } else if (this.spaceGroup != null) {
                    sg = this.spaceGroup;
                } else if (this.symmetryInfo != null) {
                    sg = this.symmetryInfo.getDerivedSpaceGroup();
                }
                switch (sg == null ? "" : name) {
                    case "hmName": {
                        return sg.getHMName();
                    }
                    case "nameToXYZList": {
                        Lst<String> genPos = new Lst<String>();
                        sg.setFinalOperations();
                        int n = sg.getOperationCount();
                        for (int i = 0; i < n; ++i) {
                            genPos.addLast(((SymmetryOperation)sg.getOperation((int)i)).xyz);
                        }
                        return genPos;
                    }
                    case "itaIndex": {
                        return sg.getItaIndex();
                    }
                    case "itaTransform": {
                        return sg.itaTransform;
                    }
                    case "itaNumber": {
                        return sg.itaNumber;
                    }
                }
                return null;
            }
        }
        return SpaceGroup.getInfo(this.spaceGroup, name, (float[])params, isFull, addNonstandard);
    }

    private String getSpaceGroupList(Integer sg0) {
        SB sb = new SB();
        Lst list = (Lst)this.getSpaceGroupJSON(this.vwr, "ITA", "ALL", 0);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Map map = (Map)list.get(i);
            Integer sg = (Integer)map.get("sg");
            if (sg0 != null && !sg.equals(sg0)) continue;
            sb.appendO(sg).appendC('.').appendO(map.get("set")).appendC('\t').appendO(map.get("hm")).appendC('\t').appendO(map.get("sg")).appendC(':').appendO(map.get("trm")).appendC('\n');
        }
        return sb.toString();
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getShelxLATTDesignation();
    }

    @Override
    public void setFinalOperations(int dim, String name, P3[] atoms, int iAtomFirst, int noSymmetryCount, boolean doNormalize, String filterSymop) {
        boolean doCalculate;
        if (name != null && (name.startsWith("bio") || name.indexOf(" *(") >= 0)) {
            this.spaceGroup.setName(name);
        }
        if (doCalculate = "unspecified!".equals(name)) {
            filterSymop = "calculated";
        }
        if (filterSymop != null) {
            Lst<SymmetryOperation> lst = new Lst<SymmetryOperation>();
            lst.addLast(this.spaceGroup.matrixOperations[0]);
            for (int i = 1; i < this.spaceGroup.operationCount; ++i) {
                if (!doCalculate && !filterSymop.contains(" " + (i + 1) + " ")) continue;
                lst.addLast(this.spaceGroup.matrixOperations[i]);
            }
            this.spaceGroup = SpaceGroup.createSpaceGroup(-1, name + " *(" + filterSymop.trim() + ")", lst, -1);
        }
        this.spaceGroup.setFinalOperationsForAtoms(dim, atoms, iAtomFirst, noSymmetryCount, doNormalize);
    }

    @Override
    public M4 getSpaceGroupOperation(int i) {
        return this.spaceGroup == null || this.spaceGroup.matrixOperations == null || i >= this.spaceGroup.matrixOperations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.matrixOperations[i] : this.spaceGroup.finalOperations[i]);
    }

    @Override
    public String getSpaceGroupXyz(int i, boolean doNormalize) {
        return this.spaceGroup.getXyz(i, doNormalize);
    }

    @Override
    public void newSpaceGroupPoint(P3 pt, int i, M4 o, int transX, int transY, int transZ, P3 retPoint) {
        if (o == null && this.spaceGroup.finalOperations == null) {
            SymmetryOperation op = this.spaceGroup.matrixOperations[i];
            if (!op.isFinalized) {
                op.doFinalize();
            }
            o = op;
        }
        SymmetryOperation.rotateAndTranslatePoint(o == null ? this.spaceGroup.finalOperations[i] : o, pt, transX, transY, transZ, retPoint);
    }

    @Override
    public V3[] rotateAxes(int iop, V3[] axes, P3 ptTemp, M3 mTemp) {
        return iop == 0 ? axes : this.spaceGroup.finalOperations[iop].rotateAxes(axes, this.unitCell, ptTemp, mTemp);
    }

    @Override
    public int getSpinOp(int op) {
        return this.spaceGroup.matrixOperations[op].getMagneticOp();
    }

    @Override
    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    @Override
    public Lst<P3> getLatticeCentering() {
        return SymmetryOperation.getLatticeCentering(this.getSymmetryOperations());
    }

    @Override
    public Matrix getOperationRsVs(int iop) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.matrixOperations : this.spaceGroup.finalOperations)[iop].rsvs;
    }

    @Override
    public int getSiteMultiplicity(P3 pt) {
        return this.spaceGroup.getSiteMultiplicity(pt, this.unitCell);
    }

    @Override
    public String getSpaceGroupName() {
        return this.spaceGroup != null ? this.spaceGroup.getName() : (this.symmetryInfo != null ? this.symmetryInfo.sgName : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
    }

    @Override
    public String getSpaceGroupNameType(String type) {
        return this.spaceGroup == null ? null : this.spaceGroup.getNameType(type, this);
    }

    @Override
    public char getLatticeType() {
        return this.symmetryInfo != null ? this.symmetryInfo.latticeType : (this.spaceGroup == null ? (char)'P' : this.spaceGroup.latticeType);
    }

    @Override
    public String getIntTableNumber() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableNo : (this.spaceGroup == null ? null : this.spaceGroup.itaNumber);
    }

    @Override
    public String getIntTableIndex() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableIndex : (this.spaceGroup == null ? null : this.spaceGroup.getItaIndex());
    }

    @Override
    public String getIntTableTransform() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableTransform : (this.spaceGroup == null ? null : this.spaceGroup.itaTransform);
    }

    @Override
    public String getIntTableNumberFull() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableJmolID : (this.spaceGroup == null ? null : (this.spaceGroup.jmolId != null ? this.spaceGroup.jmolId : this.spaceGroup.itaNumber));
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo == null ? null : this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoStr() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.infoStr;
        }
        if (this.spaceGroup == null) {
            return "";
        }
        this.symmetryInfo = new SymmetryInfo();
        this.symmetryInfo.setSymmetryInfoFromModelkit(this.spaceGroup);
        return this.symmetryInfo.infoStr;
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null && this.symmetryInfo.symmetryOperations != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null ? (this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : this.spaceGroup.operationCount) : 0);
    }

    public SymmetryOperation[] getSymmetryOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.symmetryOperations;
        }
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, false, true);
        }
        this.spaceGroup.setFinalOperations();
        return this.spaceGroup.finalOperations;
    }

    @Override
    public int getAdditionalOperationsCount() {
        return this.symmetryInfo != null && this.symmetryInfo.symmetryOperations != null && this.symmetryInfo.getAdditionalOperations() != null ? this.symmetryInfo.additionalOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.getAdditionalOperationsCount() : 0);
    }

    @Override
    public M4[] getAdditionalOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.getAdditionalOperations();
        }
        this.getSymmetryOperations();
        return this.spaceGroup.getAdditionalOperations();
    }

    @Override
    public boolean isSimple() {
        return this.spaceGroup == null && (this.symmetryInfo == null || this.symmetryInfo.symmetryOperations == null);
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    @Override
    public SymmetryInterface setUnitCellFromParams(float[] unitCellParams, boolean setRelative, float slop) {
        if (unitCellParams == null) {
            unitCellParams = new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f};
        }
        this.unitCell = UnitCell.fromParams(unitCellParams, setRelative, slop);
        return this;
    }

    @Override
    public boolean unitCellEquals(SymmetryInterface uc2) {
        return ((Symmetry)uc2).unitCell.isSameAs(this.unitCell.getF2C());
    }

    @Override
    public boolean isSymmetryCell(SymmetryInterface sym) {
        UnitCell uc = ((Symmetry)sym).unitCell;
        float[][] myf2c = !uc.isStandard() ? (float[][])null : (this.symmetryInfo != null ? this.symmetryInfo.spaceGroupF2C : this.unitCell.getF2C());
        boolean ret = uc.isSameAs(myf2c);
        if (this.symmetryInfo != null && this.symmetryInfo.setIsCurrentCell(ret)) {
            this.setUnitCellFromParams(this.symmetryInfo.spaceGroupF2CParams, false, Float.NaN);
        }
        return ret;
    }

    @Override
    public String getUnitCellState() {
        if (this.unitCell == null) {
            return "";
        }
        return this.unitCell.getState();
    }

    @Override
    public Lst<String> getMoreInfo() {
        return this.unitCell.moreInfo;
    }

    @Override
    public void initializeOrientation(M3 mat) {
        this.unitCell.initOrientation(mat);
    }

    @Override
    public void unitize(T3 ptFrac) {
        this.unitCell.unitize(ptFrac);
    }

    @Override
    public void toUnitCell(T3 pt, T3 offset) {
        this.unitCell.toUnitCell(pt, offset);
    }

    @Override
    public P3 toSupercell(P3 fpt) {
        return this.unitCell.toSupercell(fpt);
    }

    @Override
    public void toFractional(T3 pt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toFractional(pt, ignoreOffset);
        }
    }

    @Override
    public void toCartesian(T3 pt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toCartesian(pt, ignoreOffset);
        }
    }

    @Override
    public float[] getUnitCellParams() {
        return this.unitCell.getUnitCellParams();
    }

    @Override
    public float[] getUnitCellAsArray(boolean vectorsOnly) {
        return this.unitCell.getUnitCellAsArray(vectorsOnly);
    }

    @Override
    public P3[] getUnitCellVerticesNoOffset() {
        return this.unitCell.getVertices();
    }

    @Override
    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    @Override
    public void setOffsetPt(T3 pt) {
        this.unitCell.setOffset(pt);
    }

    @Override
    public void setOffset(int nnn) {
        P3 pt = new P3();
        SimpleUnitCell.ijkToPoint3f(nnn, pt, 0, 0);
        this.unitCell.setOffset(pt);
    }

    @Override
    public T3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    @Override
    public SymmetryInterface getUnitCellMultiplied() {
        UnitCell uc = this.unitCell.getUnitCellMultiplied();
        if (uc == this.unitCell) {
            return this;
        }
        Symmetry s = new Symmetry();
        s.unitCell = uc;
        return s;
    }

    @Override
    public P3[] getCanonicalCopy(float scale, boolean withOffset) {
        return this.unitCell.getCanonicalCopy(scale, withOffset);
    }

    @Override
    public float getUnitCellInfoType(int infoType) {
        return this.unitCell.getInfo(infoType);
    }

    @Override
    public String getUnitCellInfo(boolean scaled) {
        return this.unitCell == null ? null : this.unitCell.dumpInfo(false, scaled);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    @Override
    public P3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    @Override
    public SymmetryInterface getUnitCell(T3[] oabc, boolean setRelative, String name) {
        if (oabc == null) {
            return null;
        }
        this.unitCell = UnitCell.fromOABC(oabc, setRelative);
        if (name != null) {
            this.unitCell.name = name;
        }
        return this;
    }

    @Override
    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    @Override
    public BS notInCentroid(ModelSet modelSet, BS bsAtoms, int[] minmax) {
        try {
            BS bsDelete = new BS();
            int iAtom0 = bsAtoms.nextSetBit(0);
            JmolMolecule[] molecules = modelSet.getMolecules();
            int moleculeCount = molecules.length;
            Atom[] atoms = modelSet.at;
            boolean isOneMolecule = molecules[moleculeCount - 1].firstAtomIndex == modelSet.am[atoms[iAtom0].mi].firstAtomIndex;
            P3 center = new P3();
            float packing = (float)minmax[6] / 100.0f;
            boolean centroidPacked = packing != 0.0f;
            int i = moleculeCount;
            block2: while (--i >= 0 && bsAtoms.get(molecules[i].firstAtomIndex)) {
                BS bs = molecules[i].atomList;
                center.set(0.0f, 0.0f, 0.0f);
                int n = 0;
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    if (isOneMolecule || centroidPacked) {
                        center.setT(atoms[j]);
                        if (this.isNotCentroid(center, 1, minmax, packing)) {
                            if (isOneMolecule) {
                                bsDelete.set(j);
                            }
                        } else if (!isOneMolecule) {
                            continue block2;
                        }
                    } else {
                        center.add(atoms[j]);
                        ++n;
                    }
                    j = bs.nextSetBit(j + 1);
                }
                if (!centroidPacked && (n <= 0 || !this.isNotCentroid(center, n, minmax, 0.0f))) continue;
                bsDelete.or(bs);
            }
            return bsDelete;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 center, int n, int[] minmax, float packing) {
        center.scale(1.0f / (float)n);
        this.toFractional(center, false);
        if (packing != 0.0f) {
            float d = packing >= 0.0f ? packing : 5.0E-6f;
            return center.x + d <= (float)minmax[0] || center.x - d > (float)minmax[3] || center.y + d <= (float)minmax[1] || center.y - d > (float)minmax[4] || center.z + d <= (float)minmax[2] || center.z - d > (float)minmax[5];
        }
        return center.x + 5.0E-6f <= (float)minmax[0] || center.x + 5.0E-5f > (float)minmax[3] || center.y + 5.0E-6f <= (float)minmax[1] || center.y + 5.0E-5f > (float)minmax[4] || center.z + 5.0E-6f <= (float)minmax[2] || center.z + 5.0E-5f > (float)minmax[5];
    }

    private SymmetryDesc getDesc(ModelSet modelSet) {
        if (modelSet == null) {
            return nullDesc == null ? (nullDesc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", null, "modelkit")) : nullDesc;
        }
        return (this.desc == null ? (this.desc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", modelSet.vwr, "eval")) : this.desc).set(modelSet);
    }

    @Override
    public Object getSymmetryInfoAtom(ModelSet modelSet, int iatom, String xyz, int op, P3 translation, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth, int options, int[] opList) {
        return this.getDesc(modelSet).getSymopInfo(iatom, xyz, op, translation, pt, pt2, id, type, scaleFactor, nth, options, opList);
    }

    @Override
    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, String sgName, int modelIndex, boolean isFull, float[] cellParams) {
        Map<String, Object> info;
        boolean isForModel;
        boolean bl = isForModel = sgName == null;
        if (sgName == null && (info = modelSet.getModelAuxiliaryInfo(modelSet.vwr.am.cmi)) != null) {
            sgName = (String)info.get("spaceGroup");
        }
        SymmetryInterface cellInfo = null;
        if (cellParams != null) {
            cellInfo = new Symmetry().setUnitCellFromParams(cellParams, false, Float.NaN);
        }
        return this.getDesc(modelSet).getSpaceGroupInfo(this, modelIndex, sgName, 0, null, null, null, 0.0f, -1, isFull, isForModel, 0, cellInfo, null);
    }

    @Override
    public T3[] getV0abc(Object def, M4 retMatrix) {
        Object t = null;
        return (t != null ? t instanceof T3 : def instanceof T3[]) ? (T3[])def : UnitCell.getMatrixAndUnitCell(this.unitCell, def, retMatrix);
    }

    @Override
    public Quat getQuaternionRotation(String abc) {
        return this.unitCell == null ? null : this.unitCell.getQuaternionRotation(abc);
    }

    @Override
    public P3 getFractionalOrigin() {
        return this.unitCell.getFractionalOrigin();
    }

    @Override
    public boolean getState(ModelSet ms, int modelIndex, SB commands) {
        T3 ptm;
        boolean isAssigned = ms.getInfo(modelIndex, "spaceGroupAssigned") != null;
        P3 pt = this.getFractionalOffset();
        boolean loadUC = false;
        if (pt != null && (pt.x != 0.0f || pt.y != 0.0f || pt.z != 0.0f)) {
            commands.append("; set unitcell ").append(Escape.eP(pt));
            loadUC = true;
        }
        if ((ptm = this.getUnitCellMultiplier()) != null) {
            commands.append("; set unitcell ").append(SimpleUnitCell.escapeMultiplier(ptm));
            loadUC = true;
        }
        String sg = (String)ms.getInfo(modelIndex, "spaceGroup");
        if (isAssigned && sg != null) {
            String cmd = "\n UNITCELL " + Escape.e(ms.getUnitCell(modelIndex).getUnitCellVectors());
            commands.append(cmd);
            commands.append("\n MODELKIT SPACEGROUP " + PT.esc(sg));
            commands.append(cmd);
            loadUC = true;
        }
        return loadUC;
    }

    @Override
    public AtomIndexIterator getIterator(Viewer vwr, Atom atom, BS bsAtoms, float radius) {
        return ((UnitCellIterator)Interface.getInterface("org.jmol.symmetry.UnitCellIterator", vwr, "script")).set(this, atom, vwr.ms.at, bsAtoms, radius);
    }

    @Override
    public boolean toFromPrimitive(boolean toPrimitive, char type, T3[] oabc, M3 primitiveToCrystal) {
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromOABC(oabc, false);
        }
        return this.unitCell.toFromPrimitive(toPrimitive, type, oabc, primitiveToCrystal);
    }

    @Override
    public Lst<P3> generateCrystalClass(P3 pt00) {
        P3 pt0;
        if (this.symmetryInfo == null || !this.symmetryInfo.isCurrentCell) {
            return null;
        }
        SymmetryOperation[] ops = this.getSymmetryOperations();
        Lst<P3> lst = new Lst<P3>();
        boolean isRandom = pt00 == null;
        float rand1 = 0.0f;
        float rand2 = 0.0f;
        float rand3 = 0.0f;
        if (isRandom) {
            rand1 = (float)Math.E;
            rand2 = (float)Math.PI;
            rand3 = (float)Math.log10(2000.0);
            pt0 = P3.new3(rand1 + 1.0f, rand2 + 2.0f, rand3 + 3.0f);
        } else {
            pt0 = P3.newP(pt00);
        }
        if (ops == null || this.unitCell == null) {
            lst.addLast(pt0);
        } else {
            this.unitCell.toFractional(pt0, true);
            P3 pt1 = null;
            P3 pt2 = null;
            if (isRandom) {
                pt1 = P3.new3(rand2 + 4.0f, rand3 + 5.0f, rand1 + 6.0f);
                this.unitCell.toFractional(pt1, true);
                pt2 = P3.new3(rand3 + 7.0f, rand1 + 8.0f, rand2 + 9.0f);
                this.unitCell.toFractional(pt2, true);
            }
            Bspt bspt = new Bspt(3, 0);
            CubeIterator iter = bspt.allocateCubeIterator();
            P3 pt = new P3();
            int i = ops.length;
            while (--i >= 0) {
                ops[i].rotate2(pt0, pt);
                iter.initialize(pt, 0.001f, false);
                if (iter.hasMoreElements()) continue;
                P3 ptNew = P3.newP(pt);
                lst.addLast(ptNew);
                bspt.addTuple(ptNew);
                if (!isRandom) continue;
                if (pt2 != null) {
                    ops[i].rotate2(pt2, pt);
                    lst.addLast(P3.newP(pt));
                }
                if (pt1 == null) continue;
                ops[i].rotate2(pt1, pt);
                lst.addLast(P3.newP(pt));
            }
            int j = lst.size();
            while (--j >= 0) {
                pt = (P3)lst.get(j);
                if (isRandom) {
                    pt.scale(0.5f);
                }
                this.unitCell.toCartesian(pt, true);
            }
        }
        return lst;
    }

    @Override
    public void calculateCIPChiralityForAtoms(Viewer vwr, BS bsAtoms) {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        String dataClass = vwr.getBoolean(603979960) ? "CIPData" : "CIPDataTracker";
        CIPData data = ((CIPData)Interface.getInterface("org.jmol.symmetry." + dataClass, vwr, "script")).set(vwr, bsAtoms);
        data.setRule6Full(vwr.getBoolean(603979823));
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
    }

    @Override
    public String[] calculateCIPChiralityForSmiles(Viewer vwr, String smiles) throws Exception {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        CIPDataSmiles data = ((CIPDataSmiles)Interface.getInterface("org.jmol.symmetry.CIPDataSmiles", vwr, "script")).setAtomsForSmiles(vwr, smiles);
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
        return data.getSmilesChiralityArray();
    }

    private CIPChirality getCIPChirality(Viewer vwr) {
        return this.cip == null ? (this.cip = (CIPChirality)Interface.getInterface("org.jmol.symmetry.CIPChirality", vwr, "script")) : this.cip;
    }

    @Override
    public Map<String, Object> getUnitCellInfoMap() {
        return this.unitCell == null ? null : this.unitCell.getInfo();
    }

    @Override
    public void setUnitCell(SymmetryInterface uc) {
        this.unitCell = UnitCell.cloneUnitCell(((Symmetry)uc).unitCell);
    }

    @Override
    public Object findSpaceGroup(Viewer vwr, BS atoms, String xyzList, float[] unitCellParams, T3 origin, T3[] oabc, int flags) {
        return ((SpaceGroupFinder)Interface.getInterface("org.jmol.symmetry.SpaceGroupFinder", vwr, "eval")).findSpaceGroup(vwr, atoms, xyzList, unitCellParams, origin, oabc, this, flags);
    }

    @Override
    public void setSpaceGroupName(String name) {
        this.symmetryInfo = null;
        if (this.spaceGroup != null) {
            this.spaceGroup.setName(name);
        }
    }

    @Override
    public void setSpaceGroupTo(Object sg) {
        this.symmetryInfo = null;
        this.spaceGroup = sg instanceof SpaceGroup ? (SpaceGroup)sg : SpaceGroup.getSpaceGroupFromJmolClegOrITA(sg.toString());
    }

    @Override
    public BS removeDuplicates(ModelSet ms, BS bs, boolean highPrec) {
        UnitCell uc = this.unitCell;
        Atom[] atoms = ms.at;
        float[] occs = ms.occupancies;
        boolean haveOccupancies = occs != null;
        P3[] unitized = new P3[bs.length()];
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            P3 pt = unitized[i] = P3.newP(atoms[i]);
            uc.toFractional(pt, false);
            if (highPrec) {
                uc.unitizeRnd(pt);
            } else {
                uc.unitize(pt);
            }
            i = bs.nextSetBit(i + 1);
        }
        i = bs.nextSetBit(0);
        while (i >= 0) {
            Atom a = atoms[i];
            P3 pt = unitized[i];
            int type = a.getAtomicAndIsotopeNumber();
            float occ = haveOccupancies ? occs[i] : 0.0f;
            int j = bs.nextSetBit(i + 1);
            while (j >= 0) {
                P3 pt2;
                Atom b = atoms[j];
                if (type == b.getAtomicAndIsotopeNumber() && (!haveOccupancies || occ == occs[j]) && pt.distanceSquared(pt2 = unitized[j]) < 1.96E-6f) {
                    bs.clear(j);
                }
                j = bs.nextSetBit(j + 1);
            }
            i = bs.nextSetBit(i + 1);
        }
        return bs;
    }

    @Override
    public Lst<P3> getEquivPoints(Lst<P3> pts, P3 pt, String flags) {
        M4[] ops = this.getSymmetryOperations();
        return ops == null || this.unitCell == null ? null : this.unitCell.getEquivPoints(pt, flags, ops, pts == null ? new Lst<P3>() : pts, 0, 0, 0);
    }

    @Override
    public void getEquivPointList(Lst<P3> pts, int nInitial, String flags, M4[] opsCtr) {
        int i;
        int dup0;
        int n0;
        boolean tofractional;
        M4[] ops = opsCtr == null ? this.getSymmetryOperations() : opsCtr;
        boolean newPt = flags.indexOf("newpt") >= 0;
        boolean zapped = flags.indexOf("zapped") >= 0;
        int n = pts.size();
        boolean bl = tofractional = flags.indexOf("tofractional") >= 0;
        if (flags.indexOf("fromfractional") < 0) {
            for (int i2 = 0; i2 < pts.size(); ++i2) {
                this.toFractional((T3)pts.get(i2), false);
            }
        }
        flags = flags + ",fromfractional,tofractional";
        int check0 = nInitial > 0 ? 0 : n;
        boolean allPoints = nInitial == n;
        int n2 = n0 = nInitial > 0 ? nInitial : n;
        if (allPoints) {
            --nInitial;
            --n0;
        }
        if (zapped) {
            n0 = 0;
        }
        P3 p0 = nInitial > 0 ? (P3)pts.get(nInitial) : null;
        int n3 = dup0 = opsCtr == null ? n0 : check0;
        if (ops != null || this.unitCell != null) {
            for (i = nInitial; i < n; ++i) {
                this.unitCell.getEquivPoints((P3)pts.get(i), flags, ops, pts, check0, n0, dup0);
            }
        }
        if (!zapped && (pts.size() == nInitial || pts.get(nInitial) != p0 || allPoints || newPt)) {
            --n;
        }
        i = n - nInitial;
        while (--i >= 0) {
            pts.removeItemAt(nInitial);
        }
        if (!tofractional) {
            i = pts.size();
            while (--i >= nInitial) {
                this.toCartesian((T3)pts.get(i), false);
            }
        }
    }

    @Override
    public int[] getInvariantSymops(P3 pt, int[] v0) {
        SymmetryOperation[] ops = this.getSymmetryOperations();
        if (ops == null) {
            return new int[0];
        }
        BS bs = new BS();
        P3 p = new P3();
        P3 p0 = new P3();
        int nops = ops.length;
        for (int i = 1; i < nops; ++i) {
            p.setT(pt);
            this.unitCell.toFractional(p, false);
            this.unitCell.unitize(p);
            p0.setT(p);
            ops[i].rotTrans(p);
            this.unitCell.unitize(p);
            if (!(p0.distanceSquared(p) < 1.96E-6f)) continue;
            bs.set(i);
        }
        int[] ret = new int[bs.cardinality()];
        if (v0 != null && ret.length != v0.length) {
            return null;
        }
        int k = 0;
        for (int i = 1; i < nops; ++i) {
            boolean isOK = bs.get(i);
            if (!isOK) continue;
            if (v0 != null && v0[k] != i + 1) {
                return null;
            }
            ret[k++] = i + 1;
        }
        return ret;
    }

    @Override
    public Object getWyckoffPosition(Viewer vwr, P3 p, String letter) {
        if (this.unitCell == null) {
            return "";
        }
        SpaceGroup sg = this.spaceGroup;
        if (sg == null && this.symmetryInfo != null && (sg = SpaceGroup.determineSpaceGroupN(this.symmetryInfo.sgName)) == null) {
            sg = SpaceGroup.getSpaceGroupFromJmolClegOrITA(this.symmetryInfo.intlTableJmolID);
        }
        if (sg == null || sg.itaNumber == null) {
            return "?";
        }
        if (p == null) {
            p = P3.new3(0.53f, 0.2f, 0.16f);
        } else {
            p = P3.newP(p);
            this.unitCell.toFractional(p, false);
            this.unitCell.unitize(p);
        }
        if (wyckoffFinder == null) {
            wyckoffFinder = (WyckoffFinder)Interface.getInterface("org.jmol.symmetry.WyckoffFinder", null, "symmetry");
        }
        try {
            int mode;
            boolean withMult;
            WyckoffFinder w = wyckoffFinder.getWyckoffFinder(vwr, sg);
            boolean bl = withMult = letter != null && letter.charAt(0) == 'M';
            if (withMult) {
                String string = letter = letter.length() == 1 ? null : letter.substring(1);
            }
            int n = letter == null ? -1 : (letter.equalsIgnoreCase("coord") ? -2 : (letter.equalsIgnoreCase("coords") ? -3 : (mode = letter.endsWith("*") ? (int)letter.charAt(0) : 0)));
            if (mode != 0) {
                return w == null ? "?" : w.getInfo(this.unitCell, p, mode, withMult);
            }
            if (w.findPositionFor(p, letter) == null) {
                return null;
            }
            this.unitCell.toCartesian(p, false);
            return p;
        }
        catch (Exception e) {
            e.printStackTrace();
            return letter == null ? "?" : null;
        }
    }

    @Override
    public M4 getTransform(P3 fracA, P3 fracB, boolean best) {
        return this.getDesc(null).getTransform(this.unitCell, this.getSymmetryOperations(), fracA, fracB, best);
    }

    @Override
    public boolean isWithinUnitCell(P3 pt, float x, float y, float z) {
        return this.unitCell.isWithinUnitCell(x, y, z, pt);
    }

    @Override
    public boolean checkPeriodic(P3 pt) {
        return this.unitCell.checkPeriodic(pt);
    }

    @Override
    public Object staticConvertOperation(String xyz, M4 matrix) {
        return matrix == null ? SymmetryOperation.stringToMatrix(xyz) : SymmetryOperation.getXYZFromMatrixFrac(matrix, false, false, false, true);
    }

    @Override
    public Object getSubgroupJSON(Viewer vwr, int itaFrom, int itaTo, int index1, int index2) {
        boolean allSubsMap = itaTo < 0;
        boolean asIntArray = itaTo == 0 && index1 == 0;
        boolean asSSIntArray = itaTo == 0 && index1 < 0;
        boolean isIndexMap = itaTo == 0 && index1 > 0 && index2 < 0;
        boolean isIndexTStr = itaTo == 0 && index1 > 0 && index2 > 0;
        boolean isWhereList = itaTo > 0 && index1 < 0;
        boolean isWhereMap = itaTo > 0 && index1 > 0 && index2 < 0;
        boolean isWhereTStr = itaTo > 0 && index1 > 0 && index2 > 0;
        try {
            Map o = (Map)this.getSpaceGroupJSON(vwr, "subgroups", "map", itaFrom);
            int ithis = 0;
            if (o != null) {
                if (allSubsMap) {
                    return o;
                }
                if (asIntArray || asSSIntArray) {
                    Lst list = (Lst)o.get("subgroups");
                    int n = list.size();
                    Object groups = asIntArray ? new int[n][] : (Object)null;
                    BS bs = asSSIntArray ? new BS() : null;
                    int i = n;
                    while (--i >= 0) {
                        o = (Map)list.get(i);
                        int isub = (Integer)o.get("subgroup");
                        if (asSSIntArray) {
                            bs.set(isub);
                            continue;
                        }
                        int subIndex = (Integer)o.get("subgroupIndex");
                        int trType = "k".equals(o.get("trType")) ? 2 : 1;
                        String subType = trType == 1 ? (String)o.get("trSubtype") : "";
                        double det = ((Number)o.get("det")).doubleValue();
                        int idet = (int)(det < 1.0 ? -1.0 / det : det);
                        if (subType.equals("ct")) {
                            trType = 3;
                        } else if (subType.equals("eu")) {
                            trType = 4;
                        }
                        int ntrm = ((Lst)o.get("trm")).size();
                        groups[i] = new int[]{isub, ntrm, subIndex, idet, trType};
                    }
                    if (asSSIntArray) {
                        int[] a = new int[bs.cardinality()];
                        int p = 0;
                        int i2 = bs.nextSetBit(0);
                        while (i2 >= 0) {
                            a[p++] = i2;
                            i2 = bs.nextSetBit(i2 + 1);
                        }
                        return a;
                    }
                    return groups;
                }
                Lst list = (Lst)o.get("subgroups");
                int i0 = 0;
                int n = list.size();
                if (isIndexMap || isIndexTStr) {
                    if (index1 > n) {
                        throw new ArrayIndexOutOfBoundsException("no map.subgroups[" + index1 + "]!");
                    }
                    i0 = index1 - 1;
                    if (isIndexMap) {
                        return list.get(i0);
                    }
                    n = index1;
                }
                Lst<Map> whereList = isWhereList ? new Lst<Map>() : null;
                for (int i = i0; i < n; ++i) {
                    o = (Map)list.get(i);
                    int isub = (Integer)o.get("subgroup");
                    if (!isIndexTStr && isub != itaTo) continue;
                    if (++ithis == index1) {
                        if (isWhereMap) {
                            return o;
                        }
                    } else if (isWhereTStr) continue;
                    if (isWhereList) {
                        whereList.addLast(o);
                        continue;
                    }
                    Lst trms = (Lst)o.get("trms");
                    n = trms.size();
                    if (index2 < 1 || index2 > n) {
                        return null;
                    }
                    return ((Map)trms.get(index2 - 1)).get("trm");
                }
                if (isWhereList && !whereList.isEmpty()) {
                    return whereList;
                }
            }
            if (index1 == 0) {
                return null;
            }
            if (isWhereTStr && ithis > 0) {
                throw new ArrayIndexOutOfBoundsException("only " + ithis + " maximal subgroup information for " + itaFrom + ">>" + itaTo + "!");
            }
            throw new ArrayIndexOutOfBoundsException("no maximal subgroup information for " + itaFrom + ">>" + itaTo + "!");
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public Object getSpaceGroupJSON(Viewer vwr, String name, Object data, int index) {
        boolean isThis;
        boolean isSettings;
        if (vwr == null) {
            vwr = this.vwr;
        }
        boolean isSubgroups = !(isSettings = name.equals("settings")) && name.equals("subgroups");
        boolean bl = isThis = (isSettings || isSubgroups) && index == Integer.MIN_VALUE;
        String s0 = !isSettings && !isSubgroups ? name : (isThis ? this.getSpaceGroupName() : "" + index);
        try {
            Map resource;
            int itno;
            String sgname;
            boolean isInt;
            boolean isTM;
            String tm = null;
            if (isSettings || isSubgroups) {
                isTM = false;
                isInt = true;
                String string = sgname = isSettings ? (String)data : null;
                if (isThis) {
                    itno = PT.parseInt(this.getIntTableNumber());
                    if (isSettings) {
                        if (this.spaceGroup == null) {
                            SpaceGroup sg = this.symmetryInfo.getDerivedSpaceGroup();
                            if (sg == null) {
                                return new Hashtable();
                            }
                            sgname = sg.jmolId;
                        } else {
                            sgname = this.getIntTableNumberFull();
                        }
                    }
                } else {
                    itno = index;
                }
            } else {
                sgname = (String)data;
                int pt = sgname.indexOf("(");
                if (pt < 0) {
                    pt = sgname.indexOf(":");
                }
                boolean bl2 = isTM = pt >= 0 && sgname.indexOf(",") > pt;
                if (isTM) {
                    tm = sgname.substring(pt + 1, sgname.length() - (sgname.endsWith(")") ? 1 : 0));
                    sgname = sgname.substring(0, pt);
                    isThis = true;
                }
                itno = sgname.equalsIgnoreCase("ALL") ? 0 : PT.parseInt(sgname);
                isInt = itno != Integer.MIN_VALUE;
                pt = sgname.indexOf(46);
                if (!isTM && isInt && index == 0 && pt > 0) {
                    index = PT.parseInt(sgname.substring(pt + 1));
                    sgname = sgname.substring(0, pt);
                }
            }
            if (isInt && (itno > 230 || (isSettings ? itno < 1 : itno < 0))) {
                throw new ArrayIndexOutOfBoundsException(itno);
            }
            if (isSubgroups) {
                if (itaSubData == null) {
                    itaSubData = new Map[230];
                }
                if ((resource = itaSubData[itno - 1]) == null) {
                    Symmetry.itaSubData[itno - 1] = resource = (Map)this.getResource(vwr, "sg/json/sub_" + itno + ".json");
                }
                if (resource != null) {
                    return resource;
                }
            } else if (isSettings || name.equalsIgnoreCase("ITA")) {
                if (itno == 0) {
                    if (allDataITA == null) {
                        allDataITA = (Lst)this.getResource(vwr, "sg/json/ita_all.json");
                    }
                    return allDataITA;
                }
                if (itaData == null) {
                    itaData = new Map[230];
                }
                if ((resource = itaData[itno - 1]) == null) {
                    Symmetry.itaData[itno - 1] = resource = (Map)this.getResource(vwr, "sg/json/ita_" + itno + ".json");
                }
                if (resource != null) {
                    if (index == 0 && tm == null) {
                        return resource;
                    }
                    Lst its = (Lst)resource.get("its");
                    if (its != null) {
                        int i0;
                        if (isSettings && !isThis) {
                            return its;
                        }
                        int n = its.size();
                        int n2 = i0 = isInt && !isThis ? index : n;
                        if (i0 > n) {
                            return null;
                        }
                        Map map = null;
                        int i = i0;
                        while (--i >= 0) {
                            map = (Map)its.get(i);
                            if (i == index - 1 || (tm == null ? sgname.equals(map.get("jmolId")) : tm.equals(map.get("trm")))) {
                                System.out.println(tm);
                                System.out.println(map);
                                if (map.containsKey("more")) break;
                                return map;
                            }
                            map = null;
                        }
                        if (map != null) {
                            return SpaceGroup.fillMoreData(map, (String)map.get("clegId"), itno, (Map)its.get(0));
                        }
                    }
                }
            } else if (name.equalsIgnoreCase("AFLOW") && tm == null) {
                if (aflowStructures == null) {
                    aflowStructures = (Map)this.getResource(vwr, "sg/json/aflow_structures.json");
                }
                if (itno == 0) {
                    return aflowStructures;
                }
                if (itno == Integer.MIN_VALUE) {
                    Lst<String> start = null;
                    if (sgname.endsWith("*")) {
                        start = new Lst<String>();
                        sgname = sgname.substring(0, sgname.length() - 1);
                    }
                    for (int j = 1; j <= 230; ++j) {
                        Lst list = (Lst)aflowStructures.get("" + j);
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            String id = (String)list.get(i);
                            if (start != null && id.startsWith(sgname)) {
                                start.addLast("=aflowlib/" + j + "." + (i + 1) + "\t" + id);
                                continue;
                            }
                            if (!id.equalsIgnoreCase(sgname)) continue;
                            return j + "." + (i + 1);
                        }
                    }
                    return start != null && start.size() > 0 ? start : null;
                }
                Lst adata = (Lst)aflowStructures.get("" + sgname);
                if (index <= adata.size()) {
                    return index == 0 ? adata : adata.get(index - 1);
                }
            }
            if (isThis) {
                return new Hashtable();
            }
            throw new IllegalArgumentException(s0);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private Object getResource(Viewer vwr, String resource) {
        try {
            BufferedReader r = FileManager.getBufferedReaderForResource(vwr, this, "org/jmol/symmetry/", resource);
            String[] data = new String[1];
            if (Rdr.readAllAsString(r, Integer.MAX_VALUE, false, data, 0)) {
                return new JSJSONParser().parse(data[0], true);
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    @Override
    public float getCellWeight(P3 pt) {
        return this.unitCell.getCellWeight(pt);
    }

    @Override
    public float getPrecision() {
        return this.unitCell == null ? Float.NaN : this.unitCell.getPrecision();
    }

    @Override
    public boolean fixUnitCell(float[] params) {
        return UnitCell.createCompatibleUnitCell(this.spaceGroup, params, null, true);
    }

    @Override
    public String staticGetTransformABC(Object transform, boolean normalize) {
        return SymmetryOperation.getTransformABC(transform, normalize);
    }

    void setCartesianOffset(T3 origin) {
        this.unitCell.setCartesianOffset(origin);
    }

    public void setSymmetryInfoFromFile(ModelSet ms, int modelIndex, float[] unitCellParams) {
        Map<String, Object> modelAuxiliaryInfo = ms.getModelAuxiliaryInfo(modelIndex);
        this.symmetryInfo = new SymmetryInfo();
        float[] params = this.symmetryInfo.setSymmetryInfoFromFile(modelAuxiliaryInfo, unitCellParams);
        if (params != null) {
            String s;
            this.setUnitCellFromParams(params, modelAuxiliaryInfo.containsKey("jmolData"), Float.NaN);
            this.unitCell.moreInfo = (Lst)modelAuxiliaryInfo.get("moreUnitCellInfo");
            modelAuxiliaryInfo.put("infoUnitCell", this.getUnitCellAsArray(false));
            this.setOffsetPt((T3)modelAuxiliaryInfo.get("unitCellOffset"));
            M3 matUnitCellOrientation = (M3)modelAuxiliaryInfo.get("matUnitCellOrientation");
            if (matUnitCellOrientation != null) {
                this.initializeOrientation(matUnitCellOrientation);
            }
            if ((s = this.symmetryInfo.strSUPERCELL) != null) {
                T3[] oabc = this.unitCell.getUnitCellVectors();
                oabc[0] = new P3();
                ms.setModelCagePts(modelIndex, oabc, "conventional");
            }
            if (Logger.debugging) {
                Logger.debug("symmetryInfos[" + modelIndex + "]:\n" + this.unitCell.dumpInfo(true, true));
            }
        }
    }

    public void transformUnitCell(M4 trm) {
        if (trm == null) {
            trm = UnitCell.toTrm(this.spaceGroup.itaTransform, null);
        }
        M4 trmInv = M4.newM4(trm);
        trmInv.invert();
        T3[] oabc = this.getUnitCellVectors();
        for (int i = 1; i <= 3; ++i) {
            this.toFractional(oabc[i], true);
            trmInv.rotate(oabc[i]);
            this.toCartesian(oabc[i], true);
        }
        P3 o = new P3();
        trm.getTranslation(o);
        this.toCartesian(o, true);
        oabc[0].add(o);
        this.unitCell = UnitCell.fromOABC(oabc, false);
    }

    @Override
    public Object getITASettingValue(Viewer vwr, String itaIndex, String key) {
        Object o = this.getSpaceGroupJSON(vwr, "ITA", itaIndex, 0);
        return o instanceof Map ? ((Map)o).get(key) : o;
    }

    @Override
    public String staticCleanTransform(String tr) {
        return SymmetryOperation.getTransformABC(UnitCell.toTrm(tr, null), true);
    }

    @Override
    public M4 replaceTransformMatrix(M4 trm) {
        M4 trm0 = this.transformMatrix;
        this.transformMatrix = trm;
        return trm0;
    }

    @Override
    public String getUnitCellDisplayName() {
        String name = this.symmetryInfo != null ? this.symmetryInfo.getDisplayName(this) : (this.spaceGroup != null ? this.spaceGroup.getDisplayName() : null);
        return name.length() > 0 ? name : null;
    }

    @Override
    public String staticToRationalXYZ(P3 fPt, String sep) {
        String s = SymmetryOperation.fcoord(fPt, sep);
        return ",".equals(sep) ? s : "(" + s + ")";
    }

    @Override
    public String getClegId() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.getDerivedSpaceGroup().getClegId();
        }
        return this.spaceGroup.getClegId();
    }

    @Override
    public int getFinalOperationCount() {
        this.setFinalOperations(3, null, null, -1, -1, false, null);
        return this.spaceGroup.getOperationCount();
    }

    @Override
    public Object convertTransform(String transform, M4 trm) {
        if (transform == null) {
            return this.staticGetTransformABC(trm, false);
        }
        if (transform.equals("xyz")) {
            return trm == null ? null : SymmetryOperation.getXYZFromMatrix(trm, false, false, false);
        }
        if (trm == null) {
            trm = new M4();
        }
        UnitCell.getMatrixAndUnitCell(null, transform, trm);
        return trm;
    }

    @Override
    public M4 staticGetMatrixTransform(String cleg) {
        return this.getCLEGInstance().getMatrixTransform(this.vwr, cleg);
    }

    @Override
    public String staticTransformSpaceGroup(BS bs, String cleg, Object paramsOrUC, SB sb) {
        return this.getCLEGInstance().transformSpaceGroup(this.vwr, bs, cleg, paramsOrUC, sb);
    }

    private CLEG getCLEGInstance() {
        if (clegInstance == null) {
            clegInstance = (CLEG)Interface.getInterface("org.jmol.symmetry.CLEG", null, "symmetry");
        }
        return clegInstance;
    }

    @Override
    public SymmetryInterface setViewer(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }
}

