/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.api.SymmetryInterface;
import org.jmol.script.SV;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.UnitCell;
import org.jmol.viewer.Viewer;

public final class CLEG {
    public static final String HEX_TO_RHOMB = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c";
    public static final String RHOMB_TO_HEX = "a-b,b-c,a+b+c";

    public static void standardizeTokens(String[] tokens, boolean isEnd) {
        int i = tokens.length;
        while (--i >= 0) {
            String t = tokens[i];
            if (t.length() == 0) continue;
            if ((t = CLEG.cleanCleg000(t)).endsWith(":h")) {
                if (!t.startsWith("R")) {
                    t = t.substring(0, t.length() - 2);
                }
            } else if (isEnd || !t.endsWith(":2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c")) {
                if (t.endsWith(":r")) {
                    if (!t.startsWith("R")) {
                        t = t.substring(0, t.length() - 1) + HEX_TO_RHOMB;
                    }
                } else if (t.equals("r")) {
                    t = HEX_TO_RHOMB;
                } else if (t.equals("h")) {
                    t = RHOMB_TO_HEX;
                }
            }
            tokens[i] = t;
        }
        System.out.println("MK StandardizeTokens " + Arrays.toString(tokens));
    }

    public static String cleanCleg000(String t) {
        return t.endsWith(";0,0,0") ? t.substring(t.length() - 6) : t;
    }

    public static boolean isInt(String name, int n) {
        int i = n;
        while (--i >= 0) {
            if (PT.isDigit(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int isClegSetting(String name) {
        int p = name.indexOf(":");
        return p > 0 && CLEG.isInt(name, p) && name.indexOf(",") > p ? p : 0;
    }

    public static boolean checkSyntax(String[] tokens, SymmetryInterface sym) {
        for (int i = 0; i < tokens.length; ++i) {
            String transform;
            boolean isHall;
            String s = tokens[i].trim();
            if (s.length() == 0) continue;
            int ptColon = s.indexOf(":");
            int ptComma = s.indexOf(",", ptColon + 1);
            int ptDot = s.indexOf(".");
            int ptHall = s.indexOf("]");
            boolean bl = isHall = ptHall > 0 && s.charAt(0) == '[' && (ptColon < 0 || ptColon == ptHall + 1);
            double itno = isHall ? 1.0f : PT.parseFloatStrict(ptColon > 0 ? s.substring(0, ptColon) : s);
            if (Double.isNaN(itno) ? ptDot > 0 || ptColon > 0 && ptComma > 0 : itno < 1.0 || itno >= 231.0) {
                return false;
            }
            if (ptComma < 0) continue;
            String string = transform = ptColon > 0 ? s.substring(ptColon + 1) : s;
            if (((M4)sym.convertTransform(transform, null)).determinant3() != 0.0f) continue;
            return false;
        }
        return true;
    }

    public static boolean isCalcType(String token) {
        return token.length() == 0 || token.equals("sub") || token.equals("super");
    }

    public static boolean isTransformOnly(String token) {
        return CLEG.isTransform(token, false) && token.indexOf(":") < 0;
    }

    public static boolean isTransform(String token, boolean checkColonRH) {
        return token.length() == 0 || token.indexOf(44) > 0 || "!r!h".indexOf(token) >= 0 || checkColonRH && (token.endsWith(":r") || token.endsWith(":h"));
    }

    M4 getMatrixTransform(Viewer vwr, String cleg) {
        ClegData data;
        String err;
        String[] tokens;
        if (cleg.indexOf(">") < 0) {
            cleg = ">>" + cleg;
        }
        if ((tokens = PT.split(cleg, ">"))[0].length() == 0) {
            tokens[0] = "ref";
        }
        if ((err = CLEG.assignSpaceGroup(data = new ClegData(vwr.getSymTemp(), tokens), new AssignSGParams(vwr))).indexOf("!") > 0) {
            System.err.println(err);
            return null;
        }
        System.out.println("Modelkit transform: " + PT.join(tokens, '>', 0));
        cleg = data.abcFor(data.trMat);
        System.out.println("Modelkit transform: " + tokens[0] + ">" + cleg + ">" + tokens[tokens.length - 1]);
        return data.trMat;
    }

    String transformSpaceGroup(Viewer vwr, BS bs, String cleg, Object paramsOrUC, SB sb) {
        AssignSGParams asgParams;
        ClegData data;
        String ret;
        SymmetryInterface sym0 = vwr.getCurrentUnitCell();
        SymmetryInterface sym = vwr.getOperativeSymmetry();
        if (sym0 != null && sym != sym0) {
            sym.getUnitCell(sym0.getV0abc(null, null), false, "modelkit");
        }
        if (cleg.indexOf("<") >= 0) {
            cleg = PT.rep(cleg, "<<", ">super>").replace('<', '>');
        }
        if (cleg.length() == 0 || cleg.endsWith(">")) {
            cleg = cleg + ".";
        }
        if ((ret = CLEG.assignSpaceGroup(data = new ClegData(vwr.getSymTemp(), PT.split(cleg, ">")), asgParams = new AssignSGParams(vwr, sym, bs, paramsOrUC, 0, false, sb, cleg.equals(".")))).endsWith("!")) {
            return ret;
        }
        if (asgParams.mkIsAssign) {
            sb.append(ret);
        }
        return ret;
    }

    private static String assignSpaceGroup(ClegData data, AssignSGParams asgParams) {
        boolean isFinal;
        String calcNext;
        boolean isSubgroupCalc;
        boolean haveUCParams;
        boolean initializing;
        Viewer vwr = asgParams.vwr;
        int index = asgParams.mkIndex;
        String[] tokens = data.tokens;
        boolean bl = initializing = index < 0;
        if (initializing) {
            index = 0;
        }
        if (index >= tokens.length) {
            return "invalid CLEG expression!";
        }
        boolean bl2 = haveUCParams = asgParams.mkParamsOrUC != null;
        if (tokens.length > 1 && haveUCParams) {
            return "invalid syntax - can't mix transformations and UNITCELL option!";
        }
        if (index == 0 && !initializing) {
            CLEG.standardizeTokens(tokens, false);
        }
        boolean nextTransformExplicit = tokens.length > index + 1 && CLEG.isTransformOnly(tokens[index + 1]) && tokens[index + 1].length() > 0;
        String token = tokens[index].trim();
        boolean isDot = token.equals(".");
        if (index == 0) {
            if (token.length() == 0) {
                if (asgParams.mkSym00 == null) {
                    return "no starting space group for CLEG!";
                }
                if (!asgParams.mkIsAssign) {
                    tokens[0] = asgParams.mkSym00.getClegId();
                    asgParams.mkIndex = 1;
                    asgParams.mkWsNode = true;
                    asgParams.mkIgnoreAllSettings = nextTransformExplicit;
                    return CLEG.assignSpaceGroup(data, asgParams);
                }
            }
            if (asgParams.mkIsAssign && asgParams.mkSym00 == null) {
                return "no starting space group for calculation!";
            }
        }
        if (((isSubgroupCalc = CLEG.isCalcType(token)) || CLEG.isTransformOnly(token)) != asgParams.mkWsNode) {
            return "invalid CLEG expression, not node>transform>node>transform>....!";
        }
        asgParams.mkWsNode = !asgParams.mkWsNode;
        String string = calcNext = isSubgroupCalc ? token : null;
        if (isSubgroupCalc) {
            token = tokens[++index].trim();
        }
        boolean bl3 = isFinal = index == tokens.length - 1;
        if (isFinal && isDot && data.getPrevNode() != null) {
            token = data.getPrevNode().getCleanITAName();
        }
        int pt = token.lastIndexOf(":");
        boolean zapped = asgParams.mkSym00 == null;
        boolean isUnknown = false;
        boolean haveTransform = CLEG.isTransform(token, false);
        boolean isSetting = haveTransform && pt >= 0;
        boolean isTransformOnly = haveTransform && !isSetting;
        boolean restarted = false;
        boolean ignoreNodeTransform = false;
        boolean ignoreFirstSetting = false;
        SymmetryInterface sym = data.sym;
        ClegNode node = null;
        if (!isTransformOnly) {
            data.sym = sym;
            node = new ClegNode(data, index, token);
            if (data.errString != null) {
                return data.errString;
            }
        }
        if (data.getPrevNode() == null) {
            if (!CLEG.checkSyntax(tokens, sym)) {
                return "invalid CLEG expression!";
            }
            if (!asgParams.mkCalcOnly && !isTransformOnly && zapped && !node.isDefaultSetting()) {
                String ita = node.myIta;
                String[] cleg = new String[]{ita};
                AssignSGParams paramsInit = asgParams.mkCalcOnly ? new AssignSGParams(vwr) : new AssignSGParams(vwr, null, null, asgParams.mkParamsOrUC, -1, true, asgParams.mkSb, false);
                ClegData cdInit = new ClegData(vwr.getSymTemp(), cleg);
                String err = CLEG.assignSpaceGroup(cdInit, paramsInit);
                if (err.endsWith("!")) {
                    return err;
                }
                if (asgParams.mkCalcOnly) {
                    sym = asgParams.mkSym00 = cdInit.sym;
                    data.trMat = cdInit.trMat;
                } else {
                    asgParams.mkSym00 = vwr.getOperativeSymmetry();
                }
                if (asgParams.mkSym00 == null) {
                    return "modelkit spacegroup initialization error!";
                }
                zapped = false;
                restarted = true;
            }
            ignoreFirstSetting = index == 0 && (!asgParams.mkCalcOnly && !zapped && nextTransformExplicit || asgParams.mkIsAssign);
            String ita0 = zapped ? null : asgParams.mkSym00.getClegId();
            String trm0 = null;
            if (!zapped && ita0 != null && !ita0.equals("0")) {
                int pt1 = ita0.indexOf(":");
                if (pt1 > 0) {
                    trm0 = ita0.substring(pt1 + 1);
                    ita0 = ita0.substring(0, pt1);
                    pt1 = -1;
                }
                if (ignoreFirstSetting) {
                    trm0 = (String)asgParams.mkSym00.getSpaceGroupInfoObj("itaTransform", null, false, false);
                }
            }
            if (data.trMat == null) {
                data.trMat = new M4();
                data.trMat.setIdentity();
            }
            if (!asgParams.mkIsAssign) {
                data.sym = sym;
                data.setPrevNode(new ClegNode(data, -1, ita0 + ":" + trm0));
                if (asgParams.mkIgnoreAllSettings) {
                    data.getPrevNode().disable();
                }
                if (!data.getPrevNode().update(data)) {
                    return data.errString;
                }
            }
        }
        if (isSubgroupCalc) {
            data.getPrevNode().setCalcNext(calcNext);
        }
        if (isTransformOnly) {
            if (isFinal) {
                isUnknown = true;
                return "CLEG pathway is incomplete!";
            }
            if (token.length() > 0) {
                data.addTransform(index, token);
            }
            ++asgParams.mkIndex;
            return CLEG.assignSpaceGroup(data, asgParams);
        }
        if (!ignoreFirstSetting) {
            data.sym = sym;
            if (ignoreNodeTransform) {
                node.disable();
            }
            if (!node.update(data)) {
                return data.errString;
            }
            if (isFinal && isDot) {
                data.setNodeTransform(node);
            }
            data.updateTokens(node);
        }
        if (!isFinal) {
            ++asgParams.mkIndex;
            data.setPrevNode(node);
            return CLEG.assignSpaceGroup(data, asgParams);
        }
        float[] params = null;
        T3[] oabc = null;
        T3 origin = null;
        float[] fArray = params = !haveUCParams || !AU.isAD(asgParams.mkParamsOrUC) ? null : (float[])asgParams.mkParamsOrUC;
        if (zapped) {
            float[] fArray2;
            if (params == null) {
                float[] fArray3 = new float[6];
                fArray3[0] = 10.0f;
                fArray3[1] = 10.0f;
                fArray3[2] = 10.0f;
                fArray3[3] = 90.0f;
                fArray3[4] = 90.0f;
                fArray2 = fArray3;
                fArray3[5] = 90.0f;
            } else {
                fArray2 = params;
            }
            sym.setUnitCellFromParams(fArray2, false, Float.NaN);
            asgParams.mkParamsOrUC = null;
            haveUCParams = false;
        }
        if (haveUCParams) {
            if (AU.isAD(asgParams.mkParamsOrUC)) {
                params = (float[])asgParams.mkParamsOrUC;
            } else {
                oabc = (T3[])asgParams.mkParamsOrUC;
                origin = oabc[0];
            }
        } else if (!zapped) {
            sym = data.sym = asgParams.mkSym00;
            if (data.trMat == null) {
                data.trMat = new M4();
                data.trMat.setIdentity();
            }
            oabc = sym.getV0abc(new Object[]{data.trMat}, null);
            origin = oabc[0];
        }
        if (oabc != null) {
            params = sym.getUnitCell(oabc, false, "assign").getUnitCellParams();
            if (origin == null) {
                origin = oabc[0];
            }
        }
        boolean isP1 = token.equalsIgnoreCase("P1") || token.equals("ITA/1.1");
        try {
            Map sgInfo;
            boolean noAtoms;
            BS bsAtoms;
            int modelIndex = -1;
            if (asgParams.mkCalcOnly) {
                asgParams.mkBitset = bsAtoms = new BS();
                noAtoms = true;
            } else {
                BS bsCell;
                if (asgParams.mkBitset != null && asgParams.mkBitset.isEmpty()) {
                    return "no atoms specified!";
                }
                bsAtoms = vwr.getThisModelAtoms();
                BS bS = bsCell = isP1 ? bsAtoms : SV.getBitSet(vwr.evaluateExpressionAsVariable("{within(unitcell)}"), true);
                if (asgParams.mkBitset == null) {
                    asgParams.mkBitset = bsAtoms;
                }
                if (asgParams.mkBitset != null) {
                    bsAtoms.and(asgParams.mkBitset);
                    if (!isP1) {
                        bsAtoms.and(bsCell);
                    }
                }
                int n = (noAtoms = bsAtoms.isEmpty()) && vwr.am.cmi < 0 ? 0 : (modelIndex = noAtoms ? vwr.am.cmi : vwr.ms.at[bsAtoms.nextSetBit(0)].getModelIndex());
                if (!asgParams.mkIsAssign) {
                    vwr.ms.getModelAuxiliaryInfo(modelIndex).remove("spaceGroupInfo");
                }
            }
            if (!zapped && !asgParams.mkIsAssign) {
                sym.replaceTransformMatrix(data.trMat);
            }
            if (params == null) {
                params = sym.getUnitCellMultiplied().getUnitCellParams();
            }
            Map map = noAtoms && (isUnknown |= asgParams.mkIsAssign) ? null : (sgInfo = (Map)vwr.findSpaceGroup(sym, isUnknown ? bsAtoms : null, isUnknown ? null : node.getName(), params, origin, oabc, 2 | (asgParams.mkCalcOnly ? 16 : 0) | (!zapped || asgParams.mkIsAssign ? 0 : 4)));
            if (sgInfo == null) {
                return "Space group " + node.getName() + " is unknown or not compatible!";
            }
            if (oabc == null || zapped) {
                oabc = (P3[])sgInfo.get("unitcell");
            }
            token = (String)sgInfo.get("name");
            String jmolId = (String)sgInfo.get("jmolId");
            BS basis = (BS)sgInfo.get("basis");
            SpaceGroup sg = (SpaceGroup)sgInfo.remove("sg");
            sym.getUnitCell(oabc, false, null);
            sym.setSpaceGroupTo(sg == null ? jmolId : sg);
            sym.setSpaceGroupName(token);
            if (asgParams.mkCalcOnly) {
                data.sym = sym;
                return "OK";
            }
            if (basis == null) {
                basis = sym.removeDuplicates(vwr.ms, bsAtoms, true);
            }
            vwr.ms.setSpaceGroup(modelIndex, sym, basis);
            if (asgParams.mkIsAssign) {
                return token;
            }
            if (zapped || restarted) {
                vwr.runScript("unitcell on; center unitcell;axes unitcell; axes 0.1; axes on;set perspectivedepth false;moveto 0 axis c1;draw delete;show spacegroup");
            }
            String finalTransform = data.abcFor(data.trMat);
            if (!initializing) {
                CLEG.standardizeTokens(tokens, true);
                String msg = PT.join(tokens, '>', 0) + (basis.isEmpty() ? "" : "\n basis=" + basis);
                System.out.println("ModelKit CLEG=" + msg);
                asgParams.mkSb.append(msg).append("\n");
            }
            return finalTransform;
        }
        catch (Exception e) {
            if (!Viewer.isJS) {
                e.printStackTrace();
            }
            return e.getMessage() + "!";
        }
    }

    private static class AssignSGParams {
        final Viewer vwr;
        final boolean mkCalcOnly;
        final boolean mkIsAssign;
        final SB mkSb;
        boolean mkIgnoreAllSettings;
        SymmetryInterface mkSym00;
        BS mkBitset;
        Object mkParamsOrUC;
        boolean mkWsNode;
        int mkIndex;

        AssignSGParams(Viewer vwr) {
            this.vwr = vwr;
            this.mkCalcOnly = true;
            this.mkIsAssign = false;
            this.mkSb = null;
        }

        AssignSGParams(Viewer vwr, SymmetryInterface sym00, BS bs, Object paramsOrUC, int index, boolean ignoreAllSettings, SB sb, boolean isAssign) {
            this.vwr = vwr;
            this.mkCalcOnly = false;
            this.mkIndex = index;
            this.mkSym00 = sym00;
            this.mkBitset = bs;
            this.mkParamsOrUC = paramsOrUC;
            this.mkIgnoreAllSettings = ignoreAllSettings;
            this.mkSb = sb;
            this.mkIsAssign = isAssign;
        }
    }

    public static class ClegNode {
        public static final String TYPE_REFERENCE = "ref";
        public static final String CALC_SUB = "sub";
        public static final String CALC_SUPER = "super";
        public static final String CALC_SET = "set";
        String name;
        String myIta;
        String myTrm;
        int index;
        public String calcNext;
        String calculated;
        public boolean disabled;
        private boolean isThisModelCalc;
        private String hallSymbol;

        public ClegNode(ClegData data, int index, String name) {
            if (name == null) {
                return;
            }
            this.index = index;
            int pt = CLEG.isClegSetting(name);
            if (pt > 0) {
                this.myIta = name.substring(0, pt);
                this.myTrm = name.substring(pt + 1);
            }
            this.init(data, name);
        }

        public void disable() {
            this.disabled = true;
        }

        private void init(ClegData data, String name) {
            int pt;
            boolean isITAnDotm;
            boolean isPrimitive;
            if (name.equals(TYPE_REFERENCE)) {
                this.isThisModelCalc = true;
            }
            if (isPrimitive = name.endsWith(":p")) {
                name = name.substring(0, name.length() - 2);
            }
            if (isITAnDotm = name.startsWith("ITA/")) {
                name = name.substring(4);
            }
            boolean isHM = false;
            this.hallSymbol = null;
            String hallTrm = null;
            if (name.charAt(0) == '[') {
                pt = name.indexOf(93);
                if (pt < 0) {
                    data.errString = "invalid Hall symbol: " + name + "!";
                    return;
                }
                this.hallSymbol = name.substring(1, pt);
                if ((pt = name.indexOf(":", pt)) > 0) {
                    hallTrm = name.substring(pt + 1);
                }
                name = "Hall:" + this.hallSymbol;
            } else if (name.startsWith("HM:")) {
                isHM = true;
            } else if (name.length() <= 3 && (isITAnDotm = CLEG.isInt(name, name.length()))) {
                name = name + ".1";
            }
            if (!isITAnDotm && this.hallSymbol == null && !isHM) {
                int n = pt = PT.isDigit(name.charAt(0)) ? name.indexOf(" ") : -1;
                if (pt > 0) {
                    name = name.substring(0, pt);
                }
                if (name.indexOf(46) > 0 && !Double.isNaN(PT.parseFloat(name))) {
                    isITAnDotm = true;
                }
            }
            if (isITAnDotm) {
                String string = this.myTrm = name.endsWith(".1") ? "a,b,c" : (String)data.sym.getITASettingValue(null, name, "trm");
                if (this.myTrm == null) {
                    data.errString = "Unknown ITA setting: " + name + "!";
                    return;
                }
                String[] parts = PT.split(name, ".");
                this.myIta = parts[0];
            } else {
                if (this.myIta == null) {
                    this.myIta = (String)data.sym.getSpaceGroupInfoObj("itaNumber", name, false, false);
                }
                if (this.myTrm == null) {
                    this.myTrm = (String)data.sym.getSpaceGroupInfoObj("itaTransform", name, false, false);
                }
                if (this.hallSymbol != null && hallTrm != null) {
                    if (this.myTrm.equals("a,b,c")) {
                        this.myTrm = hallTrm;
                    } else {
                        data.errString = "Non-reference Hall symbol cannot also contain a setting: " + name + "!";
                        return;
                    }
                }
            }
            if ("0".equals(this.myIta)) {
                data.errString = "Could not get ITA space group for " + name + "!";
                return;
            }
            if (isPrimitive) {
                this.myTrm = data.addPrimitiveTransform(this.myIta, this.myTrm);
            }
            this.setITAName();
        }

        public String setITAName() {
            this.name = "ITA/" + this.myIta + ":" + this.myTrm;
            return this.name;
        }

        public boolean update(ClegData data) {
            if (data.errString != null) {
                return false;
            }
            if (this.name == null) {
                return true;
            }
            ClegNode prev = data.prevNode;
            if (prev.isThisModelCalc) {
                prev.myIta = this.myIta;
            }
            boolean haveReferenceCell = data.trLink == null && this.myIta != null && (this.myIta.equals(prev.myIta) || prev.calcNext != null);
            System.out.println("ClegNode update i=" + this.index + " n=" + this.name + "\n data.trLink=" + data.trLink + "\n " + prev + " " + prev.myIta + " " + prev.calcNext + "  haveref=" + haveReferenceCell);
            if (!haveReferenceCell) {
                return true;
            }
            M4 trm0 = M4.newM4(data.trMat);
            data.removePrevNodeTrm();
            String trCalc = null;
            if (prev.calcNext != null) {
                boolean unspecifiedSettingChangeOnly;
                boolean isSub = true;
                boolean isImplicit = false;
                switch (prev.calcNext) {
                    case "super": {
                        isSub = false;
                        break;
                    }
                    case "sub": {
                        break;
                    }
                    case "": 
                    case "set": {
                        prev.calcNext = CALC_SET;
                        isImplicit = true;
                    }
                }
                int ita1 = PT.parseInt(prev.myIta);
                int ita2 = PT.parseInt(this.myIta);
                boolean bl = unspecifiedSettingChangeOnly = isImplicit && ita1 == ita2;
                if (!unspecifiedSettingChangeOnly) {
                    boolean haveCalc;
                    Object o = data.sym.getSubgroupJSON(null, isSub ? ita1 : ita2, isSub ? ita2 : ita1, 0, 1);
                    trCalc = (String)o;
                    boolean bl2 = haveCalc = trCalc != null;
                    if (haveCalc && !isSub) {
                        trCalc = "!" + trCalc;
                    }
                    String calc = prev.myIta + ">" + (haveCalc ? trCalc : "?") + ">" + this.myIta;
                    if (!haveCalc) {
                        throw new RuntimeException(calc);
                    }
                    System.out.println("Modelkit sub := " + calc);
                    data.addSGTransform(trCalc, CALC_SUB);
                }
            }
            if (!this.disabled) {
                data.addSGTransform(this.myTrm, "myTrm");
            }
            this.calculated = data.calculate(trm0);
            System.out.println("calculated is " + this.calculated);
            return true;
        }

        public String getName() {
            return this.name;
        }

        public String getCleanITAName() {
            return this.name.startsWith("ITA/") ? this.name.substring(4) : this.name;
        }

        public boolean isDefaultSetting() {
            return this.myTrm == null || CLEG.cleanCleg000(this.myTrm).equals("a,b,c");
        }

        public void setCalcNext(String calcNext) {
            this.calcNext = calcNext;
        }

        public String toString() {
            return "[ClegNode #" + this.index + " " + this.name + "   " + this.myIta + ":" + this.myTrm + (this.disabled ? " disabled" : "") + "]";
        }
    }

    public static class ClegData {
        public final String[] tokens;
        public SymmetryInterface sym;
        public M4 trMat;
        public String errString;
        M4 trLink;
        private M4 trTemp = new M4();
        ClegNode prevNode;

        public ClegData(SymmetryInterface sym, String[] tokens) {
            this.tokens = tokens;
            this.sym = sym;
        }

        public M4 addSGTransform(String tr, String what) {
            if (this.trMat == null) {
                System.out.println("ClegData reset");
                this.trMat = new M4();
                this.trMat.setIdentity();
            }
            if (tr != null) {
                this.sym.convertTransform(tr, this.trTemp);
                this.trMat.mul(this.trTemp);
            }
            System.out.println("ClegData adding " + what + " " + tr + " now " + this.abcFor(this.trMat));
            return this.trMat;
        }

        public String abcFor(M4 trm) {
            return this.sym.staticGetTransformABC(trm, false);
        }

        public void removePrevNodeTrm() {
            if (this.prevNode != null && this.prevNode.myTrm != null && !this.prevNode.disabled) {
                this.addSGTransform("!" + this.prevNode.myTrm, "!prevNode.myTrm");
            }
        }

        public String calculate(M4 trm0) {
            trm0.invert();
            M4 trm1 = M4.newM4(this.trMat);
            trm1.mul(trm0);
            return (String)this.sym.convertTransform(null, trm1);
        }

        public void updateTokens(ClegNode node) {
            int index = node.index;
            String s = node.name;
            s = s.startsWith("ITA/") ? s.substring(4) : node.myIta + ":" + node.myTrm;
            this.setToken(index, s);
            if (node.calculated != null && index > 0) {
                this.setToken(index - 1, node.calculated);
            }
        }

        private void setToken(int index, String s) {
            this.tokens[index] = s;
        }

        public void addTransformLink() {
            if (this.trLink == null) {
                this.trLink = new M4();
                this.trLink.setIdentity();
            }
            this.trLink.mul(this.trTemp);
        }

        public void setNodeTransform(ClegNode node) {
            node.myTrm = this.abcFor(this.trMat);
            node.setITAName();
        }

        public void addTransform(int index, String transform) {
            this.addSGTransform(transform, ">t>");
            this.addTransformLink();
            System.out.println("ModelKit.assignSpaceGroup index=" + index + " trm=" + this.trMat);
        }

        public ClegNode getPrevNode() {
            System.out.println("cleg? getprev " + this.prevNode);
            return this.prevNode;
        }

        public ClegNode setPrevNode(ClegNode node) {
            System.out.println("cleg? setprev " + node);
            this.prevNode = node;
            return this.prevNode;
        }

        public String addPrimitiveTransform(String myIta, String myTrm) {
            String hmName = (String)this.sym.getSpaceGroupInfoObj("hmName", myIta + ":" + myTrm, false, false);
            if (hmName == null) {
                return myTrm;
            }
            char c = hmName.charAt(0);
            if ("ABCFI".indexOf(c) < 0) {
                return myTrm;
            }
            M4 t = M4.newMV(UnitCell.getPrimitiveTransform(c), P3.new3(0.0f, 0.0f, 0.0f));
            this.sym.convertTransform(myTrm, this.trTemp);
            t.mul(this.trTemp);
            return this.abcFor(t);
        }
    }
}

