/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.jvm.GarbageCollectorInfo;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;

public class GCInfoCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final int SAMPLING_TIME_INTERVAL = MetricsConfiguration.CONFIG_MAP.get(GCInfoCollector.class).samplingInterval;
    private static final int EXPECTED_KEYS_PATH_LENGTH = 0;

    public GCInfoCollector() {
        super(SAMPLING_TIME_INTERVAL, "GCInfo", StatMetrics.GC_INFO_COLLECTOR_EXECUTION_TIME, StatExceptionCode.GC_INFO_COLLECTOR_ERROR);
    }

    @Override
    public void collectMetrics(long startTime) {
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        for (Map.Entry<String, Supplier<String>> entry : GarbageCollectorInfo.getGcSuppliers().entrySet()) {
            this.value.append(new GCInfo(entry.getKey(), entry.getValue().get()).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        }
        this.saveMetricValues(this.value.toString(), startTime, new String[0]);
    }

    @Override
    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath != null && keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath(startTime, "gc_info");
    }

    public static class GCInfo
    extends MetricStatus {
        private String memoryPool;
        private String collectorName;

        public GCInfo() {
        }

        public GCInfo(String memoryPool, String collectorName) {
            this.memoryPool = memoryPool;
            this.collectorName = collectorName;
        }

        @JsonProperty(value="MemoryPool")
        public String getMemoryPool() {
            return this.memoryPool;
        }

        @JsonProperty(value="CollectorName")
        public String getCollectorName() {
            return this.collectorName;
        }
    }
}

