/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.Configuration;

public class MLConfig
implements ToXContentObject,
Writeable {
    public static final String TYPE_FIELD = "type";
    public static final String CONFIGURATION_FIELD = "configuration";
    public static final String CREATE_TIME_FIELD = "create_time";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String CONFIG_TYPE_FIELD = "config_type";
    public static final String ML_CONFIGURATION_FIELD = "ml_configuration";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_NEW_CONFIG_FIELDS = CommonValue.VERSION_2_15_0;
    private String type;
    private String configType;
    private Configuration configuration;
    private Configuration mlConfiguration;
    private final Instant createTime;
    private Instant lastUpdateTime;
    private Instant lastUpdatedTime;

    public MLConfig(String type, String configType, Configuration configuration, Configuration mlConfiguration, Instant createTime, Instant lastUpdateTime, Instant lastUpdatedTime) {
        this.type = type;
        this.configType = configType;
        this.configuration = configuration;
        this.mlConfiguration = mlConfiguration;
        this.createTime = createTime;
        this.lastUpdateTime = lastUpdateTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public MLConfig(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.type = input.readOptionalString();
        if (input.readBoolean()) {
            this.configuration = new Configuration(input);
        }
        this.createTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_NEW_CONFIG_FIELDS)) {
            this.configType = input.readOptionalString();
            if (input.readBoolean()) {
                this.mlConfiguration = new Configuration(input);
            }
            this.lastUpdatedTime = input.readOptionalInstant();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalString(this.type);
        if (this.configuration != null) {
            out.writeBoolean(true);
            this.configuration.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_NEW_CONFIG_FIELDS)) {
            out.writeOptionalString(this.configType);
            if (this.mlConfiguration != null) {
                out.writeBoolean(true);
                this.mlConfiguration.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalInstant(this.lastUpdatedTime);
        }
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.configType != null || this.type != null) {
            builder.field(TYPE_FIELD, this.configType == null ? this.type : this.configType);
        }
        if (this.configuration != null || this.mlConfiguration != null) {
            builder.field(CONFIGURATION_FIELD, (ToXContent)(this.mlConfiguration == null ? this.configuration : this.mlConfiguration));
        }
        if (this.createTime != null) {
            builder.field(CREATE_TIME_FIELD, this.createTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null || this.lastUpdatedTime != null) {
            builder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdatedTime == null ? this.lastUpdateTime.toEpochMilli() : this.lastUpdatedTime.toEpochMilli());
        }
        return builder.endObject();
    }

    public static MLConfig fromStream(StreamInput in) throws IOException {
        MLConfig mlConfig = new MLConfig(in);
        return mlConfig;
    }

    public static MLConfig parse(XContentParser parser) throws IOException {
        String type = null;
        String configType = null;
        Configuration configuration = null;
        Configuration mlConfiguration = null;
        Instant createTime = null;
        Instant lastUpdateTime = null;
        Instant lastUpdatedTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block18;
                }
                case "config_type": {
                    configType = parser.text();
                    continue block18;
                }
                case "configuration": {
                    configuration = Configuration.parse(parser);
                    continue block18;
                }
                case "ml_configuration": {
                    mlConfiguration = Configuration.parse(parser);
                    continue block18;
                }
                case "create_time": {
                    createTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
                case "last_updated_time": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return MLConfig.builder().type(type).configType(configType).configuration(configuration).mlConfiguration(mlConfiguration).createTime(createTime).lastUpdateTime(lastUpdateTime).lastUpdatedTime(lastUpdatedTime).build();
    }

    @Generated
    public static MLConfigBuilder builder() {
        return new MLConfigBuilder();
    }

    @Generated
    public MLConfigBuilder toBuilder() {
        return new MLConfigBuilder().type(this.type).configType(this.configType).configuration(this.configuration).mlConfiguration(this.mlConfiguration).createTime(this.createTime).lastUpdateTime(this.lastUpdateTime).lastUpdatedTime(this.lastUpdatedTime);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getConfigType() {
        return this.configType;
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Configuration getMlConfiguration() {
        return this.mlConfiguration;
    }

    @Generated
    public Instant getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLConfig)) {
            return false;
        }
        MLConfig other = (MLConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$configType = this.getConfigType();
        String other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Configuration this$mlConfiguration = this.getMlConfiguration();
        Configuration other$mlConfiguration = other.getMlConfiguration();
        if (this$mlConfiguration == null ? other$mlConfiguration != null : !((Object)this$mlConfiguration).equals(other$mlConfiguration)) {
            return false;
        }
        Instant this$createTime = this.getCreateTime();
        Instant other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        Instant this$lastUpdatedTime = this.getLastUpdatedTime();
        Instant other$lastUpdatedTime = other.getLastUpdatedTime();
        return !(this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Configuration $mlConfiguration = this.getMlConfiguration();
        result = result * 59 + ($mlConfiguration == null ? 43 : ((Object)$mlConfiguration).hashCode());
        Instant $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        Instant $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        return result;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setConfigType(String configType) {
        this.configType = configType;
    }

    @Generated
    public static class MLConfigBuilder {
        @Generated
        private String type;
        @Generated
        private String configType;
        @Generated
        private Configuration configuration;
        @Generated
        private Configuration mlConfiguration;
        @Generated
        private Instant createTime;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private Instant lastUpdatedTime;

        @Generated
        MLConfigBuilder() {
        }

        @Generated
        public MLConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MLConfigBuilder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Generated
        public MLConfigBuilder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public MLConfigBuilder mlConfiguration(Configuration mlConfiguration) {
            this.mlConfiguration = mlConfiguration;
            return this;
        }

        @Generated
        public MLConfigBuilder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public MLConfigBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLConfigBuilder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Generated
        public MLConfig build() {
            return new MLConfig(this.type, this.configType, this.configuration, this.mlConfiguration, this.createTime, this.lastUpdateTime, this.lastUpdatedTime);
        }

        @Generated
        public String toString() {
            return "MLConfig.MLConfigBuilder(type=" + this.type + ", configType=" + this.configType + ", configuration=" + String.valueOf(this.configuration) + ", mlConfiguration=" + String.valueOf(this.mlConfiguration) + ", createTime=" + String.valueOf(this.createTime) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ")";
        }
    }
}

