/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace.tabs;

import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.workspace.TabbedWorkspace;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.protege.editor.core.ui.workspace.WorkspaceTabPlugin;
import org.protege.editor.core.ui.workspace.tabs.LoadedTabsSelector;

public class DeleteCustomTabsAction
extends ProtegeAction {
    private static final long serialVersionUID = 5921291642080458478L;
    private JMenu parentMenu;
    private MenuListener listener = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent e) {
            DeleteCustomTabsAction.this.updateEnabledStatus();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    };

    @Override
    public void initialise() throws Exception {
    }

    @Override
    public void dispose() throws Exception {
        if (this.parentMenu != null) {
            this.parentMenu.removeMenuListener(this.listener);
            this.parentMenu = null;
        }
    }

    public void setMenuParent(JComponent parent) {
        if (parent instanceof JMenu) {
            this.parentMenu = (JMenu)parent;
            this.parentMenu.addMenuListener(this.listener);
        }
    }

    private void updateEnabledStatus() {
        TabbedWorkspace workspace = (TabbedWorkspace)this.getWorkspace();
        this.setEnabled(!workspace.getCustomTabsManager().getCustomTabs().isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        LoadedTabsSelector selector;
        TabbedWorkspace workspace = (TabbedWorkspace)this.getWorkspace();
        int ret = JOptionPaneEx.showConfirmDialog(workspace, "Delete Tabs", selector = new LoadedTabsSelector(workspace), -1, 2, selector);
        if (ret == 0) {
            for (WorkspaceTabPlugin tabPlugin : selector.getSelectedTabs()) {
                String id = tabPlugin.getId();
                if (workspace.containsTab(id)) {
                    WorkspaceTab tab = workspace.getWorkspaceTab(id);
                    workspace.removeTab(tab);
                    try {
                        tab.dispose();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                workspace.getCustomTabsManager().deleteCustomTab(id);
            }
        }
    }
}

