/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.model_group;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;

public class MLRegisterModelGroupInput
implements ToXContentObject,
Writeable {
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String MODEL_ACCESS_MODE = "access_mode";
    public static final String ADD_ALL_BACKEND_ROLES = "add_all_backend_roles";
    private String name;
    private String description;
    private List<String> backendRoles;
    private AccessMode modelAccessMode;
    private Boolean isAddAllBackendRoles;

    public MLRegisterModelGroupInput(String name, String description, List<String> backendRoles, AccessMode modelAccessMode, Boolean isAddAllBackendRoles) {
        this.name = Objects.requireNonNull(name, "model group name must not be null");
        this.description = description;
        this.backendRoles = backendRoles;
        this.modelAccessMode = modelAccessMode;
        this.isAddAllBackendRoles = isAddAllBackendRoles;
    }

    public MLRegisterModelGroupInput(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readOptionalString();
        this.backendRoles = in.readOptionalStringList();
        if (in.readBoolean()) {
            this.modelAccessMode = (AccessMode)in.readEnum(AccessMode.class);
        }
        this.isAddAllBackendRoles = in.readOptionalBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.description);
        if (this.backendRoles != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelAccessMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelAccessMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.isAddAllBackendRoles);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.name);
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.backendRoles != null && this.backendRoles.size() > 0) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.modelAccessMode != null) {
            builder.field(MODEL_ACCESS_MODE, (Object)this.modelAccessMode);
        }
        if (this.isAddAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES, this.isAddAllBackendRoles);
        }
        builder.endObject();
        return builder;
    }

    public static MLRegisterModelGroupInput parse(XContentParser parser) throws IOException {
        String name = null;
        String description = null;
        ArrayList<String> backendRoles = null;
        AccessMode modelAccessMode = null;
        Boolean isAddAllBackendRoles = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block14;
                }
                case "description": {
                    description = parser.text();
                    continue block14;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block14;
                }
                case "access_mode": {
                    modelAccessMode = AccessMode.from(parser.text().toLowerCase(Locale.ROOT));
                    continue block14;
                }
                case "add_all_backend_roles": {
                    isAddAllBackendRoles = parser.booleanValue();
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelGroupInput(name, description, backendRoles, modelAccessMode, isAddAllBackendRoles);
    }

    @Generated
    public static MLRegisterModelGroupInputBuilder builder() {
        return new MLRegisterModelGroupInputBuilder();
    }

    @Generated
    public MLRegisterModelGroupInputBuilder toBuilder() {
        return new MLRegisterModelGroupInputBuilder().name(this.name).description(this.description).backendRoles(this.backendRoles).modelAccessMode(this.modelAccessMode).isAddAllBackendRoles(this.isAddAllBackendRoles);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public AccessMode getModelAccessMode() {
        return this.modelAccessMode;
    }

    @Generated
    public Boolean getIsAddAllBackendRoles() {
        return this.isAddAllBackendRoles;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Generated
    public void setModelAccessMode(AccessMode modelAccessMode) {
        this.modelAccessMode = modelAccessMode;
    }

    @Generated
    public void setIsAddAllBackendRoles(Boolean isAddAllBackendRoles) {
        this.isAddAllBackendRoles = isAddAllBackendRoles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLRegisterModelGroupInput)) {
            return false;
        }
        MLRegisterModelGroupInput other = (MLRegisterModelGroupInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isAddAllBackendRoles = this.getIsAddAllBackendRoles();
        Boolean other$isAddAllBackendRoles = other.getIsAddAllBackendRoles();
        if (this$isAddAllBackendRoles == null ? other$isAddAllBackendRoles != null : !((Object)this$isAddAllBackendRoles).equals(other$isAddAllBackendRoles)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$backendRoles = this.getBackendRoles();
        List<String> other$backendRoles = other.getBackendRoles();
        if (this$backendRoles == null ? other$backendRoles != null : !((Object)this$backendRoles).equals(other$backendRoles)) {
            return false;
        }
        AccessMode this$modelAccessMode = this.getModelAccessMode();
        AccessMode other$modelAccessMode = other.getModelAccessMode();
        return !(this$modelAccessMode == null ? other$modelAccessMode != null : !((Object)((Object)this$modelAccessMode)).equals((Object)other$modelAccessMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLRegisterModelGroupInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isAddAllBackendRoles = this.getIsAddAllBackendRoles();
        result = result * 59 + ($isAddAllBackendRoles == null ? 43 : ((Object)$isAddAllBackendRoles).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $backendRoles = this.getBackendRoles();
        result = result * 59 + ($backendRoles == null ? 43 : ((Object)$backendRoles).hashCode());
        AccessMode $modelAccessMode = this.getModelAccessMode();
        result = result * 59 + ($modelAccessMode == null ? 43 : ((Object)((Object)$modelAccessMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLRegisterModelGroupInput(name=" + this.getName() + ", description=" + this.getDescription() + ", backendRoles=" + String.valueOf(this.getBackendRoles()) + ", modelAccessMode=" + String.valueOf((Object)this.getModelAccessMode()) + ", isAddAllBackendRoles=" + this.getIsAddAllBackendRoles() + ")";
    }

    @Generated
    public static class MLRegisterModelGroupInputBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private List<String> backendRoles;
        @Generated
        private AccessMode modelAccessMode;
        @Generated
        private Boolean isAddAllBackendRoles;

        @Generated
        MLRegisterModelGroupInputBuilder() {
        }

        @Generated
        public MLRegisterModelGroupInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLRegisterModelGroupInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLRegisterModelGroupInputBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLRegisterModelGroupInputBuilder modelAccessMode(AccessMode modelAccessMode) {
            this.modelAccessMode = modelAccessMode;
            return this;
        }

        @Generated
        public MLRegisterModelGroupInputBuilder isAddAllBackendRoles(Boolean isAddAllBackendRoles) {
            this.isAddAllBackendRoles = isAddAllBackendRoles;
            return this;
        }

        @Generated
        public MLRegisterModelGroupInput build() {
            return new MLRegisterModelGroupInput(this.name, this.description, this.backendRoles, this.modelAccessMode, this.isAddAllBackendRoles);
        }

        @Generated
        public String toString() {
            return "MLRegisterModelGroupInput.MLRegisterModelGroupInputBuilder(name=" + this.name + ", description=" + this.description + ", backendRoles=" + String.valueOf(this.backendRoles) + ", modelAccessMode=" + String.valueOf((Object)this.modelAccessMode) + ", isAddAllBackendRoles=" + this.isAddAllBackendRoles + ")";
        }
    }
}

