/*global QUnit*/

sap.ui.define([
	"sap/ui/fl/write/_internal/transport/Transports",
	"sap/ui/thirdparty/sinon-4"
], function(
	Transports,
	sinon
) {
	"use strict";

	QUnit.module("sap.ui.fl.write._internal.transport.Transports", {
		beforeEach: function() {
			this.oServer = sinon.fakeServer.create();
		},
		afterEach: function() {
			this.oServer.restore();
		}
	});

	QUnit.test("sap.ui.fl.write._internal.transport.Transports.getTransports", function(assert) {
		var oObject;
		this.oServer.respondWith([200, {
			"Content-Type": "application/json",
			"Content-Length": 13
		}, '{ "localonly":false, "transports":[{"transportId":"4711","owner":"TESTUSER","description":"test transport1"}] }']);
		this.oServer.autoRespond = true;

		oObject = {
			"package": "testpackage",
			name: "testname",
			namespace: "namespace",
			type: "variant"
		};

		return Transports.getTransports(oObject).then(function(oResult) {
			assert.equal(oResult.transports[0].transportId, '4711');
			assert.equal(oResult.localonly, false);
		});
	});

	QUnit.test("sap.ui.fl.write._internal.transport.Transports.makeChangesTransportable", function(assert) {
		var oParams;
		this.oServer.respondWith([204, {}, ""]);
		this.oServer.autoRespond = true;

		oParams = {
			transportId: "testtransport1", changeIds: [{
				namespace: "testnamespace/",
				fileName: "testname",
				fileType: "testtype"
			}],
			reference: "aReference"
		};

		return Transports.makeChangesTransportable(oParams).then(function() {
			assert.ok(true);
		});
	});

	QUnit.test("sap.ui.fl.write._internal.transport.Transports.makeChangesTransportable - no transport", function(assert) {
		var oParams;
		this.oServer.respondWith([204, {}, ""]);
		this.oServer.autoRespond = true;

		oParams = {
			changeIds: [{
				namespace: "testnamespace/",
				fileName: "testname",
				fileType: "testtype"
			}]
		};

		return Transports.makeChangesTransportable(oParams)["catch"](function() {
			assert.ok(true);
		});
	});

	QUnit.test("sap.ui.fl.write._internal.transport.Transports.makeChangesTransportable - no change IDs", function(assert) {
		var oParams;
		this.oServer.respondWith([204, {}, ""]);
		this.oServer.autoRespond = true;

		oParams = {transportId: "testtransport1"};

		return Transports.makeChangesTransportable(oParams)["catch"](function() {
			assert.ok(true);
		});
	});

	QUnit.done(function () {
		document.getElementById("qunit-fixture").style.display = "none";
	});
});
