/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import org.jdesktop.swingx.painter.AbstractPainter;

public class GlossPainter
extends AbstractPainter<Object> {
    private Paint paint;
    private GlossPosition position;

    public GlossPainter() {
        this(new Color(1.0f, 1.0f, 1.0f, 0.2f), GlossPosition.TOP);
    }

    public GlossPainter(Paint paint) {
        this(paint, GlossPosition.TOP);
    }

    public GlossPainter(GlossPosition position) {
        this(new Color(1.0f, 1.0f, 1.0f, 0.2f), position);
    }

    public GlossPainter(Paint paint, GlossPosition position) {
        this.setPaint(paint);
        this.setPosition(position);
    }

    @Override
    protected void doPaint(Graphics2D g2, Object component, int width, int height) {
        if (this.getPaint() != null) {
            Ellipse2D.Double ellipse = new Ellipse2D.Double((double)(-width) / 2.0, (double)height / 2.7, (double)width * 2.0, (double)height * 2.0);
            Area gloss = new Area(ellipse);
            if (this.getPosition() == GlossPosition.TOP) {
                Area area = new Area(new Rectangle(0, 0, width, height));
                area.subtract(new Area(ellipse));
                gloss = area;
            }
            g2.setPaint(this.getPaint());
            g2.fill(gloss);
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        Paint old = this.paint;
        this.paint = paint;
        this.setDirty(true);
        this.firePropertyChange("paint", old, this.getPaint());
    }

    public GlossPosition getPosition() {
        return this.position;
    }

    public void setPosition(GlossPosition position) {
        GlossPosition old = this.position;
        this.position = position;
        this.setDirty(true);
        this.firePropertyChange("position", (Object)old, (Object)this.getPosition());
    }

    public static enum GlossPosition {
        TOP,
        BOTTOM;

    }
}

