/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.response;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.sql.spark.response.JobExecutionResponseReader;

public class OpenSearchJobExecutionResponseReader
implements JobExecutionResponseReader {
    private final Client client;
    private static final Logger LOG = LogManager.getLogger();

    public OpenSearchJobExecutionResponseReader(Client client) {
        this.client = client;
    }

    public JSONObject getResultWithJobId(String jobId, String resultLocation) {
        return this.searchInSparkIndex((QueryBuilder)QueryBuilders.termQuery((String)"jobRunId", (String)jobId), resultLocation);
    }

    public JSONObject getResultWithQueryId(String queryId, String resultLocation) {
        return this.searchInSparkIndex((QueryBuilder)QueryBuilders.termQuery((String)"queryId", (String)queryId), resultLocation);
    }

    private JSONObject searchInSparkIndex(QueryBuilder query, String resultIndex) {
        ActionFuture searchResponseActionFuture;
        SearchRequest searchRequest = new SearchRequest();
        String searchResultIndex = resultIndex == null ? "query_execution_result" : resultIndex;
        searchRequest.indices(new String[]{searchResultIndex});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(query);
        searchRequest.source(searchSourceBuilder);
        JSONObject data = new JSONObject();
        try {
            searchResponseActionFuture = this.client.search(searchRequest);
        }
        catch (IndexNotFoundException e) {
            LOG.info(resultIndex + " is not created yet.");
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SearchResponse searchResponse = (SearchResponse)searchResponseActionFuture.actionGet();
        if (searchResponse.status().getStatus() != 200) {
            throw new RuntimeException("Fetching result from " + searchResultIndex + " index failed with status : " + searchResponse.status());
        }
        for (SearchHit searchHit : searchResponse.getHits().getHits()) {
            data.put("data", searchHit.getSourceAsMap());
        }
        return data;
    }
}

