/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.controller;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.transport.controller.MLUndeployControllerNodeResponse;

public class MLUndeployControllerNodesResponse
extends BaseNodesResponse<MLUndeployControllerNodeResponse>
implements ToXContentObject {
    public MLUndeployControllerNodesResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(MLUndeployControllerNodeResponse::readStats), in.readList(FailedNodeException::new));
    }

    public MLUndeployControllerNodesResponse(ClusterName clusterName, List<MLUndeployControllerNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public void writeNodesTo(StreamOutput out, List<MLUndeployControllerNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<MLUndeployControllerNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(MLUndeployControllerNodeResponse::readStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (MLUndeployControllerNodeResponse deployStats : this.getNodes()) {
            if (deployStats.isControllerUndeployStatusEmpty()) continue;
            DiscoveryNode node = deployStats.getNode();
            String nodeId = node.getId();
            builder.startObject(nodeId);
            deployStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

