"""DICOM private dictionary auto-generated by generate_private_dict.py.

Data generated from GDCM project's private dictionary.

The outer dictionary key is the Private Creator name ("owner"), while the inner
dictionary key is a map of DICOM tag to (VR, VM, name, is_retired).
"""


private_dictionaries: dict[str, dict[str, tuple[str, str, str, str]]] = {
    '1.2.840.113663.1': {
        '0029xx00': ('US', '1', 'Unknown', ''),
        '0029xx01': ('US', '1', 'Unknown', ''),
    },
    '1.2.840.113681': {
        '0019xx10': ('ST', '1', 'CR Image Params Common', ''),
        '0019xx11': ('ST', '1', 'CR Image IP Params Single', ''),
        '0019xx12': ('ST', '1', 'CR Image IP Params Left', ''),
        '0019xx13': ('ST', '1', 'CR Image IP Params Right', ''),
    },
    '1.2.840.113708.794.1.1.2.0': {
        '0087xx10': ('CS', '1', 'Media Type', ''),
        '0087xx20': ('CS', '1', 'Media Location', ''),
        '0087xx30': ('ST', '1', 'Storage File ID', ''),
        '0087xx40': ('DS', '1', 'Study or Image Size in MB', ''),
        '0087xx50': ('IS', '1', 'Estimated Retrieve Time', ''),
    },
    '2.16.840.1.114059.1.1.6.1.50.1': {
        '0029xx20': ('LT', '1', 'Description', ''),
        '0029xx21': ('ST', '1', 'Orientation', ''),
        '0029xx22': ('ST', '1', 'Parameter 1', ''),
        '0029xx23': ('ST', '1', 'Parameter 2', ''),
        '0029xx24': ('LO', '1', 'Teeth', ''),
        '0029xx25': ('LO', '1', 'Jaw', ''),
        '0029xx26': ('LO', '1', 'Quadrant', ''),
        '0029xx27': ('LO', '1', 'CRC', ''),
    },
    'A.L.I. Technologies, Inc.': {
        '3711xx01': ('LO', '1', 'Filename', ''),
        '3711xx02': ('OB', '1', 'Data Blob of a Visit', ''),
        '3711xx03': ('US', '1', 'Revision Number', ''),
        '3711xx04': ('UL', '1', 'Unix Timestamp', ''),
        '3711xx05': ('IS', '1', 'Bag ID', ''),
        '3711xx0C': ('UI', '1', 'Original Study UID', ''),
        '3711xx0D': ('US', '1', 'Overlay Grayscale Value', ''),
        '3711xx0E': ('CS', '1', 'Anonymization Status', ''),
    },
    'ACUSON': {
        '0009xx00': ('IS', '1', 'Unknown', ''),
        '0009xx01': ('IS', '1', 'Unknown', ''),
        '0009xx02': ('UN', '1', 'Unknown', ''),
        '0009xx03': ('UN', '1', 'Unknown', ''),
        '0009xx04': ('UN', '1', 'Unknown', ''),
        '0009xx05': ('UN', '1', 'Unknown', ''),
        '0009xx06': ('UN', '1', 'Unknown', ''),
        '0009xx07': ('UN', '1', 'Unknown', ''),
        '0009xx08': ('LT', '1', 'Unknown', ''),
        '0009xx09': ('LT', '1', 'Unknown', ''),
        '0009xx0A': ('IS', '1', 'Unknown', ''),
        '0009xx0B': ('IS', '1', 'Unknown', ''),
        '0009xx0C': ('IS', '1', 'Unknown', ''),
        '0009xx0D': ('IS', '1', 'Unknown', ''),
        '0009xx0E': ('IS', '1', 'Unknown', ''),
        '0009xx0F': ('UN', '1', 'Unknown', ''),
        '0009xx10': ('IS', '1', 'Unknown', ''),
        '0009xx11': ('UN', '1', 'Unknown', ''),
        '0009xx12': ('IS', '1', 'Unknown', ''),
        '0009xx13': ('IS', '1', 'Unknown', ''),
        '0009xx14': ('LT', '1', 'Unknown', ''),
        '0009xx15': ('UN', '1', 'Unknown', ''),
    },
    'ACUSON: 1.2.840.11386.1.0': {
        '7FDFxx00': ('IS', '1', 'Lossy Compression Ratio', ''),
        '7FDFxx01': ('US', '1', 'Image Format', ''),
        '7FDFxx02': ('US', '1', 'Acuson Region Type', ''),
        '7FDFxx0B': ('UL', '1', 'Acuson Image Apex X', ''),
        '7FDFxx0C': ('UL', '1', 'Acuson Image Apex Y', ''),
        '7FDFxx0D': ('IS', '1', 'B-Color-On Flag', ''),
    },
    'ACUSON:1.2.840.113680.1.0:0921': {
        '0009xx20': ('UN', '1', 'View Name', ''),
        '0009xx2A': ('UN', '1', 'View List', ''),
    },
    'ACUSON:1.2.840.113680.1.0:7f10': {
        '7FDFxx00': ('UN', '1', 'Lossy Compression Ratio', ''),
        '7FDFxx01': ('UN', '1', 'Image Format', ''),
        '7FDFxx02': ('UN', '1', 'Acuson Region Type', ''),
        '7FDFxx0B': ('UN', '1', 'Acuson Image Apex X', ''),
        '7FDFxx0C': ('UN', '1', 'Acuson Image Apex Y', ''),
        '7FDFxx0D': ('UN', '1', 'B-Color-On Flag', ''),
        '7FDFxx0E': ('UN', '1', 'Acuson Mechanical Apex X', ''),
        '7FDFxx0F': ('UN', '1', 'Acuson Mechanical Apex Y', ''),
        '7FDFxx10': ('UN', '1', 'Acquisition Type:', ''),
        '7FDFxx18': ('UN', '1', 'Transformation Matrix Sequence', ''),
        '7FDFxx20': ('UN', '1', 'Left angle', ''),
        '7FDFxx22': ('UN', '1', 'Right angle', ''),
        '7FDFxx24': ('UN', '1', 'Color Map Family', ''),
        '7FDFxx25': ('UN', '1', 'Full Colormap.', ''),
        '7FDFxx26': ('UN', '1', 'Color Invert', ''),
        '7FDFxx27': ('UN', '1', 'Color Baseline', ''),
        '7FDFxx28': ('UN', '1', 'CD Color Mix Points X1', ''),
        '7FDFxx29': ('UN', '1', 'CD Color Mix Points Y1', ''),
        '7FDFxx2A': ('UN', '1', 'CD Color Mix Points X2', ''),
        '7FDFxx2B': ('UN', '1', 'CD Color Mix Points Y2', ''),
        '7FDFxx2C': ('UN', '1', 'Color Accent', ''),
        '7FDFxx30': ('UN', '1', 'Persistence SQ', ''),
        '7FDFxx31': ('UN', '1', 'Persistence Mode', ''),
        '7FDFxx32': ('UN', '1', 'Persistence Coefficient Mode', ''),
        '7FDFxx33': ('UN', '1', 'Alpha coefficient', ''),
        '7FDFxx34': ('UN', '1', 'Gamma coefficient', ''),
        '7FDFxx35': ('UN', '1', 'Persistence Time Flag', ''),
        '7FDFxx36': ('UN', '1', 'Persistence adaptive flag', ''),
        '7FDFxx37': ('UN', '1', 'Persistence Frame Rate', ''),
        '7FDFxx38': ('UN', '1', 'Persistence ID', ''),
        '7FDFxx40': ('UN', '1', 'Observation Date Time SQ', ''),
        '7FDFxx50': ('UN', '1', 'Capture Type Name', ''),
        '7FDFxx52': ('UN', '1', 'Capture Type Number', ''),
        '7FDFxx54': ('UN', '1', 'Number of Capture Types', ''),
        '7FDFxx60': ('UN', '1', 'CD Steering Angle', ''),
        '7FDFxx61': ('UN', '1', 'CD PRI', ''),
        '7FDFxx62': ('UN', '1', 'CD Dynamic Range', ''),
        '7FDFxx63': ('UN', '1', 'CD Velocity Scale Min', ''),
        '7FDFxx64': ('UN', '1', 'CD Velocity Scale Max', ''),
        '7FDFxx65': ('UN', '1', 'CD Color Mode', ''),
        '7FDFxx66': ('UN', '1', 'CD Frequency', ''),
        '7FDFxx67': ('UN', '1', 'CD Balance', ''),
        '7FDFxx68': ('UN', '1', 'CD Delta', ''),
        '7FDFxx69': ('UN', '1', 'CD Pan Box Min X0', ''),
        '7FDFxx6A': ('UN', '1', 'CD Pan Box Min Y0', ''),
        '7FDFxx6B': ('UN', '1', 'CD Pan Box Min X1', ''),
        '7FDFxx6C': ('UN', '1', 'CD Pan Box Min Y1', ''),
        '7FDFxx6D': ('UN', '1', 'CPS Map Type', ''),
        '7FDFxx6E': ('UN', '1', 'CPS Map Data', ''),
        '7FDFxx6F': ('UN', '1', 'CPS Balance Setting', ''),
        '7FDFxx70': ('UN', '1', '3DCard Step Angle', ''),
        '7FDFxx71': ('UN', '1', '3DCard Xdcr Angle', ''),
        '7FDFxx72': ('UN', '1', 'B-mode Frequency', ''),
        '7FDFxx73': ('UN', '1', 'B-mode Dynamic Range', ''),
        '7FDFxx74': ('UN', '1', 'B-mode Frame Rate', ''),
        '7FDFxx75': ('UN', '1', 'B-mode Space Time', ''),
        '7FDFxx76': ('UN', '1', 'B-mode Persistence', ''),
        '7FDFxx77': ('UN', '1', 'B-mode Display Depth Start', ''),
        '7FDFxx78': ('UN', '1', 'B-mode Display Depth End', ''),
        '7FDFxx79': ('UN', '1', 'B-mode Res Mode', ''),
        '7FDFxx7A': ('UN', '1', 'B-mode Preset Application', ''),
        '7FDFxx7B': ('UN', '1', 'Image Spec Name', ''),
        '7FDFxx7C': ('UN', '1', 'B Preset Image Look', ''),
        '7FDFxx7D': ('UN', '1', 'B-mode Post Processing', ''),
        '7FDFxx7E': ('UN', '1', 'B Edge', ''),
        '7FDFxx7F': ('UN', '1', 'B Delta', ''),
        '7FDFxx80': ('UN', '1', 'B-mode 1D Post Processing Curve', ''),
        '7FDFxx81': ('UN', '1', 'B-mode Delta (ECRI) Map Diagonal', ''),
        '7FDFxx82': ('UN', '1', 'Bytes Per Timestamp', ''),
        '7FDFxx83': ('UN', '1', 'Microseconds in unit timestamp', ''),
        '7FDFxx84': ('UN', '1', 'Start Stopwatch Timestamp', ''),
        '7FDFxx85': ('UN', '1', 'Acoustic Frame Timestamp', ''),
        '7FDFxx86': ('UN', '1', 'R-Wave Timestamp', ''),
        '7FDFxx87': ('UN', '1', 'Last Destruction Timestamp', ''),
        '7FDFxx88': ('UN', '1', 'Pixels Per Second', ''),
        '7FDFxx89': ('UN', '1', 'ECG Reference Timestamp', ''),
        '7FDFxx8A': ('UN', '1', 'ECG Sampling Interval (milliseconds)', ''),
        '7FDFxx8B': ('UN', '1', 'ECG Sample Count', ''),
        '7FDFxx8C': ('UN', '1', 'ECG Sample Size', ''),
        '7FDFxx8D': ('UN', '1', 'ECG Data Value', ''),
        '7FDFxx8E': ('UN', '1', 'Contrast/Active Image Indicator', ''),
        '7FDFxx8F': ('UN', '1', 'Live Dual Mode Indicator', ''),
        '7FDFxx90': ('UN', '1', '3DCard Clipset ID', ''),
        '7FDFxx91': ('UN', '1', '3DCard HRWave Min', ''),
        '7FDFxx92': ('UN', '1', '3DCard HRWave Max', ''),
        '7FDFxx93': ('UN', '1', 'Perspective Capture Type', ''),
        '7FDFxxF1': ('UN', '1', 'Trigger Mask.', ''),
        '7FDFxxF2': ('UN', '1', 'Study Directory', ''),
        '7FDFxxF3': ('UN', '1', 'Last Modify Date', ''),
        '7FDFxxF4': ('UN', '1', 'Last Modify Time', ''),
        '7FDFxxF5': ('UN', '1', 'Teaching Study', ''),
        '7FDFxxF6': ('UN', '1', 'Series Base UID', ''),
    },
    'ACUSON:1.2.840.113680.1.0:7ffe': {
        '7FDFxx00': ('UN', '1', 'Data Padding', ''),
    },
    'ADAC_IMG': {
        '0019xx02': ('IS', '1', 'Ver200 ADAC Pegasys File Size', ''),
        '0019xx10': ('LO', '2', 'ADAC Header Signature', ''),
        '0019xx11': ('US', '1', 'Number of ADAC Headers', ''),
        '0019xx12': ('IS', '1-n', 'ADAC Header/Image Sizes', ''),
        '0019xx20': ('OB', '1', 'ADAC Pegasys Headers', ''),
        '0019xx21': ('US', '1', 'Ver200 Number of ADAC Headers', ''),
        '0019xx41': ('IS', '1-n', 'Ver200 ADAC Header/Image Size', ''),
        '0019xx61': ('OB', '1', 'Ver200 ADAC Pegasys Headers', ''),
        '7043xx00': ('SH', '1', 'Cardiac Stress State', ''),
        '7043xx10': ('LO', '1', 'Philips NM Private Group', ''),
    },
    'AEGIS_DICOM_2.00': {
        '0003xx00': ('US', '1-n', 'Unknown', ''),
        '0005xx00': ('US', '1-n', 'Unknown', ''),
        '0009xx00': ('US', '1-n', 'Unknown', ''),
        '0019xx00': ('US', '1-n', 'Unknown', ''),
        '0029xx00': ('US', '1-n', 'Unknown', ''),
        '1369xx00': ('US', '1-n', 'Unknown', ''),
    },
    'AGFA': {
        '0009xx10': ('LO', '1', 'Unknown', ''),
        '0009xx11': ('LO', '1', 'Unknown', ''),
        '0009xx13': ('LO', '1', 'Unknown', ''),
        '0009xx14': ('LO', '1', 'Unknown', ''),
        '0009xx15': ('LO', '1', 'Unknown', ''),
        '0019xx10': ('SH', '1', 'Private Identification Code', ''),
        '0019xx11': ('LO', '3', 'Identification Data (Note 2)', ''),
        '0019xx13': ('LO', '1', 'Sensitometry Name', ''),
        '0019xx14': ('ST', '3', 'Window/Level List (Note 3)', ''),
        '0019xx15': ('LO', '1', 'Dose Monitoring List', ''),
        '0019xx16': ('LO', '3', 'Other Info (Note 5)', ''),
        '0019xx1A': ('LO', '1', 'Clipped Exposure Deviation', ''),
        '0019xx1B': ('LO', '1', 'Logarithmic PLT Full Scale', ''),
        '0019xx60': ('US', '1', 'Total number of series', ''),
        '0019xx61': ('SH', '1', 'Session Number', ''),
        '0019xx62': ('SH', '1', 'ID Station name', ''),
        '0019xx65': ('US', '1', 'Number of images in study to be transmitted (only sent with autoverify: on)', ''),
        '0019xx70': ('US', '1', 'Total number of images', ''),
        '0019xx80': ('ST', '1', 'Geometrical Transformations', ''),
        '0019xx81': ('ST', '1', 'Roam Origin', ''),
        '0019xx82': ('US', '1', 'Zoom factor', ''),
        '0019xx93': ('CS', '1', 'Status', ''),
    },
    'AGFA PACS Archive Mirroring 1.0': {
        '0031xx00': ('CS', '1', 'Unknown', ''),
        '0031xx01': ('UL', '1', 'Unknown', ''),
    },
    'AGFA-AG_HPState': {
        '0071xx18': ('SQ', '1', 'Unknown', ''),
        '0071xx19': ('SQ', '1', 'Unknown', ''),
        '0071xx1A': ('SQ', '1', 'Unknown', ''),
        '0071xx1C': ('SQ', '1', 'Unknown', ''),
        '0071xx1E': ('SQ', '1', 'Unknown', ''),
        '0071xx20': ('FL', '1-n', 'Unknown', ''),
        '0071xx21': ('FD', '1-n', 'Unknown', ''),
        '0071xx22': ('FD', '1-n', 'Unknown', ''),
        '0071xx23': ('FD', '1-n', 'Unknown', ''),
        '0071xx24': ('FD', '1', 'Unknown', ''),
        '0073xx23': ('SH', '1', 'Unknown', ''),
        '0073xx24': ('SQ', '1', 'Unknown', ''),
        '0073xx28': ('SQ', '1', 'Unknown', ''),
        '0073xx80': ('FL', '1', 'Unknown', ''),
        '0075xx10': ('LO', '1', 'Unknown', ''),
        '0087xx01': ('LO', '1', 'Unknown', ''),
        '0087xx02': ('LO', '1', 'Unknown', ''),
    },
    'AGFA_ADC_Compact': {
        '0019xx05': ('ST', '1', 'Data stream from cassette', ''),
        '0019xx10': ('LO', '1', 'Private Identification Code', ''),
        '0019xx30': ('ST', '1', 'Set of destination types', ''),
        '0019xx40': ('ST', '1', 'Set of destination Ids', ''),
        '0019xx50': ('ST', '1', 'Set of processing codes', ''),
        '0019xx60': ('US', '1', 'Number of series in study', ''),
        '0019xx61': ('US', '1', 'Session Number', ''),
        '0019xx62': ('SH', '1', 'ID station name', ''),
        '0019xx70': ('US', '1', 'Number of images in series', ''),
        '0019xx71': ('US', '1', 'Break condition', ''),
        '0019xx72': ('US', '1', 'Wait (or Hold) flag', ''),
        '0019xx73': ('US', '1', 'ScanRes flag', ''),
        '0019xx74': ('SH', '1', 'Operation code', ''),
        '0019xx95': ('CS', '1', 'Image quality', ''),
    },
    'ALOKA:1.2.392.200039.103.2': {
        '0009xx00': ('SH', '1', 'Unknown', ''),
        '0009xx04': ('US', '1-n', 'Unknown', ''),
        '0009xx06': ('US', '1-n', 'Unknown', ''),
        '0009xx0A': ('SH', '1', 'Unknown', ''),
        '0009xx20': ('CS', '1', 'Unknown', ''),
        '0009xx22': ('CS', '1', 'Unknown', ''),
        '0009xx24': ('CS', '1', 'Unknown', ''),
        '0009xx26': ('IS', '1', 'Unknown', ''),
        '0009xx28': ('IS', '1', 'Unknown', ''),
        '0009xx2A': ('DS', '1', 'Unknown', ''),
        '0009xx30': ('FD', '1', 'Unknown', ''),
        '0009xx32': ('DS', '1', 'Unknown', ''),
        '0009xx34': ('CS', '1', 'Unknown', ''),
        '0019xx08': ('FD', '1', 'Unknown', ''),
        '0019xx0C': ('CS', '1', 'Unknown', ''),
        '0019xx0E': ('DS', '1', 'Unknown', ''),
        '0019xx18': ('SL', '1', 'Unknown', ''),
        '0019xx1A': ('SL', '1', 'Unknown', ''),
        '0019xx40': ('SS', '1', 'Unknown', ''),
        '0019xx46': ('US', '1', 'Unknown', ''),
        '0019xx50': ('SL', '1', 'Unknown', ''),
        '0019xx52': ('DS', '1', 'Unknown', ''),
        '0019xx54': ('DS', '1', 'Unknown', ''),
        '0019xx56': ('FD', '1', 'Unknown', ''),
    },
    'AMI Annotations_01': {
        '3101xx10': ('SQ', '1', 'AMI Annotation Sequence (RET)', ''),
    },
    'AMI Annotations_02': {
        '3101xx20': ('SQ', '1', 'AMI Annotation Sequence (RET)', ''),
    },
    'AMI ImageContextExt_01': {
        '3107xxA0': ('CS', '1', 'AMI Window Function (RET)', ''),
        '3107xxB0': ('DS', '1', 'AMI Window Slope (RET)', ''),
    },
    'AMI ImageContext_01': {
        '3109xx10': ('CS', '1', 'AMI Window Invert (RET)', ''),
        '3109xx20': ('IS', '1', 'AMI Window Center (RET)', ''),
        '3109xx30': ('IS', '1', 'AMI Window Widith (RET)', ''),
        '3109xx40': ('CS', '1', 'AMI Pixel Aspect Ratio Swap (RET)', ''),
        '3109xx50': ('CS', '1', 'AMI Enable Averaging (RET)', ''),
        '3109xx60': ('CS', '1', 'AMI Quality (RET)', ''),
        '3109xx70': ('CS', '1', 'AMI Viewport Annotation Level (RET)', ''),
        '3109xx80': ('CS', '1', 'AMI Show Image Annotation (RET)', ''),
        '3109xx90': ('CS', '1', 'AMI Show Image Overlay (RET)', ''),
    },
    'AMI ImageTransform_01': {
        '3107xx10': ('DS', '1', 'AMI Transformation Matrix (RET)', ''),
        '3107xx20': ('DS', '1', 'AMI Center Offset (RET)', ''),
        '3107xx30': ('DS', '1', 'AMI Magnification (RET)', ''),
        '3107xx40': ('CS', '1', 'AMI Magnification Type (RET)', ''),
        '3107xx50': ('DS', '1', 'AMI Displayed Area (RET)', ''),
        '3107xx60': ('DS', '1', 'AMI Calibration Factor (RET)', ''),
    },
    'AMI Sequence AnnotElements_01': {
        '3105xx10': ('DS', '1', 'AMI Annotation Element Position', ''),
        '3105xx20': ('LT', '1', 'AMI Annotation Element Text', ''),
    },
    'AMI Sequence Annotations_01': {
        '3103xx10': ('CS', '1', 'AMI Annotation Sequence (RET)', ''),
        '3103xx20': ('UI', '1', 'AMI Annotation UID (RET)', ''),
        '3103xx30': ('US', '1', 'AMI Annotation Color (RET)', ''),
        '3103xx40': ('FD', '1', 'FontSize', ''),
        '3103xx50': ('CS', '1', 'AMI Annotation Line Style (RET)', ''),
        '3103xx60': ('SQ', '1', 'AMI Annotation Elements (RET)', ''),
        '3103xx70': ('SH', '1', 'AMI Annotation Label (RET)', ''),
        '3103xx80': ('PN', '1', 'AMI Annotation Creator (RET)', ''),
        '3103xx90': ('PN', '1', 'AMI Annotation Modifiers (RET)', ''),
        '3103xxA0': ('DA', '1', 'AMI Annotation Creation Date (RET)', ''),
        '3103xxB0': ('TM', '1', 'AMI Annotation Creation Time (RET)', ''),
        '3103xxC0': ('DA', '1', 'AMI Annotation Modification Dates (RET)', ''),
        '3103xxD0': ('TM', '1', 'AMI Annotation Modification Times (RET)', ''),
        '3103xxE0': ('US', '1', 'AMI Annotation Frame Number (RET)', ''),
    },
    'AMI Sequence Annotations_02': {
        '3103xx10': ('CS', '1', 'AMI Annotation Sequence (RET)', ''),
        '3103xx20': ('UI', '1', 'AMI Annotation UID (RET)', ''),
        '3103xx30': ('US', '1', 'AMI Annotation Color (RET)', ''),
        '3103xx50': ('CS', '1', 'AMI Annotation Line Style (RET)', ''),
        '3103xx60': ('SQ', '1', 'AMI Annotation Elements (RET)', ''),
        '3103xx70': ('SH', '1', 'AMI Annotation Label (RET)', ''),
        '3103xx80': ('PN', '1', 'AMI Annotation Creator (RET)', ''),
        '3103xx90': ('PN', '1', 'AMI Annotation Modifiers (RET)', ''),
        '3103xxA0': ('DA', '1', 'AMI Annotation Creation Date (RET)', ''),
        '3103xxB0': ('TM', '1', 'AMI Annotation Creation Time (RET)', ''),
        '3103xxC0': ('DA', '1', 'AMI Annotation Modification Dates (RET)', ''),
        '3103xxD0': ('TM', '1', 'AMI Annotation Modification Times (RET)', ''),
        '3103xxE0': ('US', '1', 'AMI Annotation Frame Number (RET)', ''),
    },
    'AMI StudyExtensions_01': {
        '3111xx01': ('UL', '1', 'AMI Last Released Annot Label (RET)', ''),
    },
    'AMICAS0': {
        '0023xx01': ('UI', '1', '', ''),
        '0023xx08': ('US', '1', '', ''),
        '0023xx10': ('US', '1', '', ''),
        '0023xx16': ('SL', '1', '', ''),
    },
    'APEX_PRIVATE': {
        '0027xx10': ('LO', '1', 'Private Creator', ''),
        '0027xx11': ('DS', '1', 'Bed Position', ''),
    },
    'ATL HDI V1.0': {
        '0009xx00': ('UN', '1', 'Private', ''),
        '0009xx10': ('UN', '1', 'Private', ''),
        '0009xx20': ('UN', '1', 'Private', ''),
        '0009xx30': ('UN', '1', 'Private', ''),
        '0009xx40': ('UN', '1', 'Private', ''),
        '0009xx50': ('UN', '1', 'Private', ''),
        '0009xx60': ('UN', '1', 'Private', ''),
        '0009xx70': ('UN', '1', 'Private', ''),
        '0009xx80': ('UN', '1', 'Private', ''),
        '0009xx90': ('UN', '1', 'Private', ''),
        '0009xx91': ('UN', '1', 'Private', ''),
        '0029xx30': ('UN', '1', 'Loop Mode', ''),
        '0029xx31': ('UN', '1', 'Trigger mode', ''),
        '0029xx32': ('UN', '1', 'Number of Loops', ''),
        '0029xx33': ('UN', '1', 'Loop Indexes', ''),
        '0029xx34': ('UN', '1', 'Loop Heart Rates', ''),
        '0029xx35': ('UN', '1', 'Medications', ''),
    },
    'ATL PRIVATE TAGS': {
        '0029xx30': ('UL', '1', 'Loop Mode', ''),
        '0029xx31': ('UL', '1', 'Trigger mode', ''),
        '0029xx32': ('UL', '1', 'Number of Loops', ''),
        '0029xx33': ('DS', '1-n', 'Loop Indexes', ''),
        '0029xx34': ('DS', '1-n', 'Loop Heart Rates', ''),
        '0029xx35': ('LO', '1', 'Medications', ''),
    },
    'Acuson X500': {
        '0009xx20': ('UN', '1', '(a)View Name', ''),
        '0009xx2A': ('UN', '1', 'View List', ''),
        '0011xx10': ('UN', '1', 'Siemens Medical', ''),
        '0011xx11': ('UN', '1', 'DIMAQ Software', ''),
        '0011xx20': ('UN', '1', 'Private Data', ''),
        '0011xx21': ('UN', '1', 'Private Data', ''),
        '0013xx10': ('UN', '1', 'Siemens Medical', ''),
        '0013xx11': ('UN', '1', 'DIMAQ Software', ''),
        '0013xx20': ('UN', '1', 'Private Data', ''),
        '0015xx10': ('UN', '1', 'Siemens Medical', ''),
        '0015xx11': ('UN', '1', 'DIMAQ Software', ''),
        '0015xx20': ('UN', '1', 'Private Data', ''),
        '0017xx10': ('UN', '1', 'Siemens Medical', ''),
        '0017xx11': ('UN', '1', 'DIMAQ Software', ''),
        '0017xx20': ('UN', '1', 'Private Data', ''),
        '0019xx20': ('UN', '1', 'Import Structured', ''),
    },
    'Agfa ADC NX': {
        '0019xx09': ('SQ', '1', 'Unknown', ''),
        '0019xxF5': ('CS', '1', 'Cassette Orientation', ''),
        '0019xxF6': ('DS', '1', 'Plate Sensitivity', ''),
        '0019xxF7': ('DS', '1', 'Plate Erasability', ''),
        '0019xxF8': ('IS', '1', 'Unknown', ''),
        '0019xxFE': ('CS', '1', 'Unknown', ''),
    },
    'AgilityRuntime': {
        '0029xx11': ('CS', '1', 'Unknown', ''),
        '0029xx12': ('US', '1', 'Unknown', ''),
        '0029xx13': ('US', '1', 'Unknown', ''),
        '0029xx14': ('US', '1', 'Unknown', ''),
        '0029xx1F': ('US', '1', 'Unknown', ''),
    },
    'Applicare/Centricity Radiology Web/Version 1.0': {
        '4109xx01': ('SH', '1', 'Mammography Laterality', ''),
        '4109xx02': ('SH', '1', 'Mammography View Name', ''),
        '4109xx03': ('SH', '1', 'Mammography View Modifier', ''),
    },
    'Applicare/Centricity Radiology Web/Version 2.0': {
        '4111xx01': ('CS', '1', 'Secondary Spine Label', ''),
        '4111xx02': ('IS', '1', 'Additional tags for Presentation State', ''),
    },
    'Applicare/Print/Version 5.1': {
        '4101xx01': ('UL', '1', '<internal', ''),
        '4101xx02': ('SQ', '1', '<internal', ''),
        '4101xx03': ('LO', '1', '<internal', ''),
        '4101xx04': ('UL', '1', '<internal', ''),
        '4101xx05': ('FD', '1', '<internal', ''),
        '4101xx06': ('US', '1', '<internal', ''),
        '4101xx07': ('US', '1', '<internal', ''),
        '4101xx08': ('US', '1', '<internal', ''),
        '4101xx09': ('US', '1', '<internal', ''),
    },
    'Applicare/RadStore/Version 1.0': {
        '3113xx01': ('SL', '1', 'OBSOLETE', ''),
        '3113xx02': ('SL', '1', 'Id1', ''),
        '3113xx03': ('SL', '1', 'Id2', ''),
        '3113xx04': ('SL', '1', 'Id3', ''),
        '3113xx11': ('LO', '1', 'OBSOLETE', ''),
        '3113xx12': ('CS', '1', 'State', ''),
        '3113xx13': ('DT', '1', 'DateLastModified', ''),
        '3113xx14': ('DT', '1', 'DateLastAccessed', ''),
        '3113xx15': ('CS', '1', 'OBSOLETE', ''),
        '3113xx16': ('FD', '1', 'ByteSize', ''),
        '3113xx17': ('LO', '1', 'LibraryId', ''),
        '3113xx18': ('LO', '1', 'Pathnames', ''),
        '3113xx19': ('LO', '1', 'DriverPath', ''),
        '3113xx1A': ('LO', '1', 'Source', ''),
        '3113xx1B': ('LO', '1', 'Destination', ''),
        '3113xx1C': ('SL', '1', 'MediumId', ''),
        '3113xx1D': ('LO', '1', 'ArchiveId', ''),
        '3113xx1E': ('LO', '1', 'Origin', ''),
        '3113xx21': ('SL', '1', 'Version', ''),
        '3113xx22': ('SL', '1', 'OBSOLETE', ''),
        '3113xx23': ('ST', '1', 'InstanceFileLocation', ''),
        '3113xx31': ('IS', '1', 'OBSOLETE', ''),
        '3113xx32': ('IS', '1', 'OBSOLETE', ''),
        '3113xx33': ('IS', '1', 'OBSOLETE', ''),
        '3113xx35': ('LO', '1', 'ImageMediumLocation', ''),
        '3113xx36': ('LO', '1', 'ImageMediumLabel', ''),
        '3113xx37': ('CS', '1', 'ImageMediumState', ''),
        '3113xx38': ('LO', '1', 'SeriesMediumLocation', ''),
        '3113xx39': ('LO', '1', 'SeriesMediumLabel', ''),
        '3113xx3A': ('CS', '1', 'SeriesMediumState', ''),
        '3113xx3B': ('LO', '1', 'StudyMediumLocation', ''),
        '3113xx3C': ('LO', '1', 'StudyMediumLabel', ''),
        '3113xx3D': ('CS', '1', 'StudyMediumState', ''),
        '3113xx52': ('CS', '1', 'StudyState', ''),
        '3113xx53': ('CS', '1', 'SeriesState', ''),
        '3113xx55': ('CS', '1', 'ImageStateText', ''),
        '3113xx56': ('CS', '1', 'SeriesStateText', ''),
        '3113xx57': ('CS', '1', 'StudyStateText', ''),
        '3113xx60': ('DT', '1', 'Expiration', ''),
        '3113xx69': ('AT', '1', 'DeletedTags', ''),
    },
    'Applicare/RadWorks/Version 5.0': {
        '3109xx01': ('ST', '1', '<internal', ''),
        '3109xx02': ('SH', '1', 'NEW/SEEN Status', ''),
        '3109xx03': ('CS', '1', 'Delete Lock', ''),
        '3109xx04': ('CS', '1', '<internal', ''),
        '3109xx05': ('CS', '1', '<internal', ''),
        '3109xx06': ('CS', '1', '<internal', ''),
        '3109xx07': ('UL', '1', '<internal', ''),
        '3109xx08': ('LO', '1', 'Receive Origin', ''),
        '3109xx09': ('LO', '1', 'Folder', ''),
        '3109xx0A': ('DA', '1', 'Receive Date', ''),
        '3109xx0B': ('TM', '1', 'Receive Time', ''),
        '3109xx0C': ('CS', '1', 'Prior', ''),
        '3109xx0D': ('CS', '1', 'STAT Study', ''),
        '3109xx0E': ('CS', '1', '<internal', ''),
        '3109xx10': ('CS', '1', '<internal', ''),
        '3109xx11': ('LO', '1', '<internal', ''),
        '3109xx12': ('LO', '1', '<internal', ''),
        '3109xx13': ('DA', '1', '<internal', ''),
        '3109xx14': ('TM', '1', '<internal', ''),
        '3109xx19': ('LO', '1', '<internal', ''),
        '3109xx20': ('UI', '1', '<internal', ''),
        '3109xx21': ('CS', '1', '<internal', ''),
        '3109xx22': ('AE', '1', '<internal', ''),
        '3109xx23': ('US', '1', '<internal', ''),
        '3109xx24': ('LO', '1', '<internal', ''),
        '3109xx25': ('LO', '1', '<internal', ''),
        '3109xx26': ('UI', '1', '<internal', ''),
        '3109xx27': ('SQ', '1', '<internal', ''),
        '3109xx28': ('LO', '1', '<internal', ''),
        '3109xx29': ('LO', '1', '<internal', ''),
        '3109xx2A': ('LO', '1', 'Send Flag', ''),
        '3109xx2B': ('LO', '1', 'Print Flag', ''),
        '3109xx2C': ('LO', '1', 'Archive Flag', ''),
        '3109xx30': ('LO', '1', '<internal', ''),
        '3109xx31': ('CS', '1', '<internal', ''),
        '3109xx32': ('CS', '1', '<internal', ''),
        '3109xx33': ('CS', '1', 'Request Storage Commitment', ''),
        '3109xx34': ('CS', '1', 'Requested Compression', ''),
        '3109xx35': ('SQ', '1', '<internal', ''),
        '3109xx36': ('LO', '1', '<internal', ''),
        '3109xx37': ('UI', '1', '<internal', ''),
        '3109xx38': ('SH', '1', '<internal', ''),
        '3109xx39': ('SH', '1', '<internal', ''),
        '3109xx40': ('IS', '1', '<internal', ''),
        '3109xx41': ('CS', '1', '<internal', ''),
        '3109xx42': ('CS', '1', '<internal', ''),
        '3109xx43': ('CS', '1', 'Archive Status', ''),
        '3109xxEE': ('UI', '1', '<internal', ''),
        '3109xxEF': ('CS', '1', '<internal', ''),
    },
    'Applicare/RadWorks/Version 6.0': {
        '4103xx01': ('AT', '1', 'Internal: non-existent tags', ''),
        '4103xx02': ('UI', '1', 'Internal: non-existent objects', ''),
        '4105xx01': ('CS', '1', 'Annotation Type', ''),
        '4105xx02': ('DS', '1', 'Annotation Value', ''),
        '4105xx03': ('UI', '1', 'Cutline Image UID', ''),
        '4105xx04': ('UI', '1', 'Cutline Set UID', ''),
        '4105xx05': ('US', '1', 'Annotation Color', ''),
        '4105xx06': ('CS', '1', 'Annotation Line Style', ''),
        '4105xx07': ('SH', '1', 'Annotation Label', ''),
        '4105xx08': ('PN', '1', 'Annotation Creator', ''),
        '4105xx09': ('DA', '1', 'Annotation Creation Date', ''),
        '4105xx0A': ('TM', '1', 'Annotation Creation Time', ''),
        '4105xx0B': ('SQ', '1', 'Annotation Modification Sequence', ''),
        '4105xx0C': ('PN', '1', 'Annotation Modifier', ''),
        '4105xx0D': ('DA', '1', 'Annotation Modification Date', ''),
        '4105xx0E': ('TM', '1', 'Annotation Modification Time', ''),
        '4105xx0F': ('LO', '1', 'Palette Color LUT Name', ''),
        '4105xx10': ('US', '1', 'Annotation Number', ''),
        '4107xx01': ('SQ', '1', 'Requested Palette Color LUT', ''),
    },
    'Applicare/RadWorks/Version 6.0/Summary': {
        '3109xx11': ('ST', '1', 'Receive Origin Description', ''),
        '3109xx12': ('ST', '1', 'Receive Origin Description', ''),
    },
    'Applicare/Workflow/Version 1.0': {
        '3113xx01': ('CS', '1', '<internal', ''),
        '3113xx10': ('SH', '1', '<internal', ''),
        '3113xx11': ('SH', '1', '<internal', ''),
        '3113xx12': ('LO', '1', '<internal', ''),
        '3113xx15': ('SH', '1', '<internal', ''),
        '3113xx16': ('SH', '1', '<internal', ''),
        '3113xx17': ('LO', '1', '<internal', ''),
        '3113xx20': ('SH', '1', '<internal', ''),
        '3113xx21': ('SH', '1', '<internal', ''),
        '3113xx22': ('LO', '1', '<internal', ''),
        '3113xx25': ('SH', '1', '<internal', ''),
        '3113xx26': ('SH', '1', '<internal', ''),
        '3113xx27': ('LO', '1', '<internal', ''),
        '3113xx30': ('UI', '1', '<internal', ''),
        '3113xx31': ('UI', '1', '<internal', ''),
        '3113xxE0': ('CS', '1', '<internal', ''),
        '3113xxE1': ('CS', '1', '<internal', ''),
        '3113xxE2': ('CS', '1', '<internal', ''),
    },
    'BRIT Systems, Inc.': {
        '0021xx00': ('SQ', '1', 'Person Information Sequence', ''),
        '0021xx01': ('LO', '1', 'Person ID', ''),
        '0021xx02': ('PN', '1', 'Person Name', ''),
        '0021xx03': ('LO', '1', 'Person Role', ''),
        '0021xx04': ('SH', '1', 'Person Home Phone', ''),
        '0021xx05': ('SH', '1', 'Person Work Phone', ''),
        '0021xx06': ('SH', '1', 'Person Cell Phone', ''),
        '0021xx07': ('SH', '1', 'Person Pager Phone', ''),
        '0021xx08': ('SH', '1', 'Person Fax Phone', ''),
        '0021xx09': ('LO', '1', 'Person EMail', ''),
        '0021xx0A': ('ST', '1', 'Person Address', ''),
        '0021xx0B': ('LO', '1', 'Person Password', ''),
        '0021xx0C': ('SH', '1', 'Person Emergency Phone', ''),
        '0021xx0D': ('LO', '1', 'Physician ID', ''),
        '0021xx11': ('LO', '1', 'Original Patient ID', ''),
        '0021xx12': ('UI', '1', 'Original Study Instance UID', ''),
        '0021xx13': ('UI', '1', 'Original Series Instance UID', ''),
        '0021xx14': ('LO', '1', 'Master Accession Number', ''),
        '0021xx15': ('LO', '1', 'Order Category', ''),
        '0021xx16': ('LO', '1', 'Patient ICN', ''),
        '0021xx17': ('LO', '1', 'Patient DFS', ''),
        '0021xx18': ('LO', '1', 'Patient Class', ''),
        '0021xx19': ('LO', '1', 'Patient Type', ''),
        '0021xx1F': ('LT', '1', 'Generic String', ''),
        '0021xx20': ('LO', '1', 'QC Study Assigned By', ''),
        '0021xx21': ('LO', '1', 'QC Study Split By', ''),
        '0021xx22': ('LO', '1', 'QC Study Moved By', ''),
        '0021xx23': ('LO', '1', 'QC Study Edited By', ''),
        '0021xx24': ('LO', '1', 'QC Series Split By', ''),
        '0021xx25': ('LO', '1', 'QC Series Moved By', ''),
        '0021xx26': ('LO', '1', 'QC Series Edited By', ''),
        '0021xx27': ('LO', '1', 'QC Image Moved By', ''),
        '0021xx28': ('LO', '1', 'QC Image Edited By', ''),
        '0021xx30': ('LO', '1', 'QC Done Time', ''),
        '0021xx31': ('LO', '1', 'QC Last Modification Time', ''),
        '0021xx32': ('LO', '1', 'QC Image Accepted By', ''),
        '0021xx33': ('LO', '1', 'QC Image Rejected By', ''),
        '0021xx34': ('DA', '1', 'QC Done Date', ''),
        '0021xx50': ('LO', '1', 'QC Deletion Requested', ''),
        '0021xx90': ('AE', '1', 'Original Sender AE Title', ''),
        '0021xx91': ('LO', '1', 'Software Title', ''),
        '0021xx92': ('SH', '1', 'Software Version', ''),
        '0021xx93': ('LO', '1', 'Serial Number', ''),
        '0021xxA0': ('SQ', '1', 'Object Action Sequence', ''),
        '0021xxA1': ('ST', '1', 'Object Action', ''),
        '0021xxA2': ('DA', '1', 'Object Action Date', ''),
        '0021xxA3': ('TM', '1', 'Object Action Time', ''),
        '0021xxA5': ('AE', '1', 'Local AE Title', ''),
        '0021xxA6': ('SH', '1', 'Local IP Address', ''),
        '0021xxA7': ('AE', '1', 'Remote AE Title', ''),
        '0021xxA8': ('SH', '1', 'Remote IP Address', ''),
    },
    'BioPri': {
        '0009xx00': ('LO', '1', 'Unknown', ''),
        '0009xx01': ('UN', '1', 'Unknown', ''),
        '0009xx02': ('UN', '1', 'Unknown', ''),
        '0009xx03': ('LO', '1-n', 'Unknown', ''),
        '0009xx04': ('LO', '1', 'Unknown', ''),
        '0009xx05': ('LO', '1', 'Unknown', ''),
        '0009xx07': ('LO', '1', 'Unknown', ''),
        '0009xx08': ('LO', '1', 'Unknown', ''),
        '0009xx09': ('LO', '1', 'Unknown', ''),
        '0009xx10': ('UN', '1', 'Unknown', ''),
    },
    'BioPri3D': {
        '001110xx': ('UN', '1', 'Private Segmentation Data', ''),
        '006310xx': ('UN', '1', 'Private Creator', ''),
    },
    'BrainLAB_BeamProfile': {
        '3411xx01': ('SQ', '1', 'Beam Profile Sequence', ''),
        '3411xx02': ('IS', '1', 'Beam Profile Number', ''),
        '3411xx03': ('SQ', '1', 'Beam Parameter Sequence', ''),
        '3411xx04': ('UT', '1', 'Parameter Description', ''),
        '3411xx05': ('OB', '1', 'Parameter Data', ''),
        '3411xx06': ('IS', '1', 'Referenced Beam Profile Number', ''),
    },
    'BrainLAB_Conversion': {
        '0009xx01': ('LO', '1', 'Export Platform Name', ''),
        '0009xx02': ('OB', '1', 'Export Platform Data', ''),
    },
    'BrainLAB_PatientSetup': {
        '3273xx00': ('DS', '3', 'Isocenter Position', ''),
        '3273xx01': ('CS', '1', 'Patient Position', ''),
    },
    'CAMTRONICS': {
        '0029xx10': ('LT', '1', 'Commentline', ''),
        '0029xx20': ('DS', '1', 'Edge Enhancement Coefficient', ''),
        '0029xx50': ('LT', '1', 'Scene Text', ''),
        '0029xx60': ('LT', '1', 'Image Text', ''),
        '0029xx70': ('IS', '1', 'Pixel Shift Horizontal', ''),
        '0029xx80': ('IS', '1', 'Pixel Shift Vertical', ''),
        '0029xx90': ('IS', '1', 'Unknown', ''),
    },
    'CAMTRONICS IP': {
        '0029xx10': ('LT', '1', 'Unknown', ''),
        '0029xx20': ('UN', '1', 'Unknown', ''),
        '0029xx30': ('UN', '1', 'Unknown', ''),
        '0029xx40': ('UN', '1', 'Unknown', ''),
    },
    'CANON_MEC_MR3': {
        '00290001': ('SQ', '1', 'Other Private Data', ''),
        '00290089': ('LO', '1', 'Unknown', ''),
        '00290090': ('OB', '1', 'Reversed EVRLE DataSet', ''),
        '700D0000': ('DS', '1', 'Scale Factor', ''),
        '700D0005': ('DS', '4', 'FOV', ''),
        '700D000C': ('CS', '1', 'Receiver Gain Correction Check Flag', ''),
        '700D0020': ('SH', '1', 'Identification Flag of 3D GDC', ''),
    },
    'CANON_MEC_MR3^10': {
        '00090002': ('SH', '1', 'Unknown', ''),
        '00110003': ('US', '1', 'Unknown', ''),
        '00110004': ('SQ', '1', 'Unknown', ''),
        '00110005': ('US', '1', 'Unknown', ''),
        '00110006': ('US', '1', 'Unknown', ''),
        '00110007': ('UL', '1-n', 'Unknown', ''),
        '00110008': ('SH', '1', 'Unknown', ''),
        '0011000C': ('SS', '1', 'Unknown', ''),
        '0011000E': ('US', '2', 'Unknown', ''),
        '00190001': ('UL', '1', 'Unknown', ''),
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('US', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190005': ('FL', '1', 'Unknown', ''),
        '00190006': ('SL', '1', 'Unknown', ''),
        '00190007': ('FL', '3', 'Unknown', ''),
        '00190008': ('US', '1', 'Unknown', ''),
        '00190009': ('FL', '1', 'Unknown', ''),
        '0019000A': ('FL', '1', 'Unknown', ''),
        '0019000B': ('FL', '1', 'Unknown', ''),
        '0019000C': ('US', '3', 'Unknown', ''),
        '0019000D': ('SL', '6', 'Unknown', ''),
        '0019000E': ('SL', '6', 'Unknown', ''),
        '0019000F': ('SL', '6', 'Unknown', ''),
        '00190010': ('US', '2', 'Unknown', ''),
        '00190011': ('SL', '2', 'Unknown', ''),
        '00190012': ('US', '1', 'Unknown', ''),
        '00190013': ('SL', '1', 'Unknown', ''),
        '00190014': ('US', '1', 'Unknown', ''),
        '00190015': ('SL', '1', 'Unknown', ''),
        '00190016': ('FL', '1', 'Unknown', ''),
        '00190017': ('SL', '1', 'Unknown', ''),
        '00190018': ('US', '1', 'Unknown', ''),
        '00190019': ('SL', '1', 'Unknown', ''),
        '0019001A': ('US', '1', 'Unknown', ''),
        '0019001B': ('SL', '1', 'Unknown', ''),
        '0019001C': ('SL', '1', 'Unknown', ''),
        '0019001D': ('SL', '1', 'Unknown', ''),
        '0019001E': ('US', '1', 'Unknown', ''),
        '00190027': ('SL', '1', 'Unknown', ''),
        '00190028': ('SL', '1', 'Unknown', ''),
        '00190029': ('SH', '1', 'Unknown', ''),
        '0019002A': ('SL', '1', 'Unknown', ''),
        '0019002B': ('SH', '1', 'Unknown', ''),
        '0019002C': ('SL', '1', 'Unknown', ''),
        '0019002D': ('SL', '1', 'Unknown', ''),
        '0019002E': ('US', '1', 'Unknown', ''),
        '0019002F': ('FL', '1', 'Unknown', ''),
        '00190030': ('UL', '1', 'Unknown', ''),
        '00190031': ('OF', '1-n', 'Unknown', ''),
        '00190032': ('FL', '1', 'Unknown', ''),
        '00190033': ('SL', '3', 'Unknown', ''),
        '00190034': ('SL', '1', 'Unknown', ''),
        '00190035': ('SL', '1', 'Unknown', ''),
        '00190036': ('SQ', '1', 'Unknown', ''),
        '00190038': ('SL', '1', 'Unknown', ''),
        '00190039': ('SL', '1', 'Unknown', ''),
        '0019003A': ('SL', '1', 'Unknown', ''),
        '0019003B': ('SL', '2', 'Unknown', ''),
        '0019003C': ('SL', '1', 'Unknown', ''),
        '0019003D': ('SL', '1', 'Unknown', ''),
        '0019003E': ('SL', '1', 'Unknown', ''),
        '0019003F': ('SL', '1', 'Unknown', ''),
        '00190042': ('US', '1', 'Unknown', ''),
        '00190043': ('US', '1', 'Unknown', ''),
        '00190044': ('SL', '1', 'Unknown', ''),
        '00190045': ('SS', '1', 'Unknown', ''),
        '00190046': ('US', '1', 'Unknown', ''),
        '00190047': ('FL', '1', 'Unknown', ''),
        '00190048': ('US', '1', 'Unknown', ''),
        '00190049': ('US', '1', 'Unknown', ''),
        '0019004B': ('US', '1', 'Unknown', ''),
        '0019004C': ('US', '1', 'Unknown', ''),
        '0019004E': ('US', '1', 'Unknown', ''),
        '0019004F': ('US', '1', 'Unknown', ''),
        '00190050': ('SL', '2', 'Unknown', ''),
        '00190051': ('SL', '2', 'Unknown', ''),
        '00190052': ('LO', '1', 'Unknown', ''),
        '00190054': ('US', '1', 'Unknown', ''),
        '00190055': ('US', '1', 'Unknown', ''),
        '00190056': ('FL', '3', 'Unknown', ''),
        '00190057': ('FL', '3', 'Unknown', ''),
        '00190058': ('FL', '3', 'Unknown', ''),
        '00190059': ('SL', '1', 'Unknown', ''),
        '0019005A': ('FL', '1-n', 'Unknown', ''),
        '0019005D': ('FL', '1-n', 'Unknown', ''),
        '0019005E': ('SL', '1', 'Unknown', ''),
        '0019005F': ('FL', '1', 'Unknown', ''),
        '00190060': ('US', '1', 'Unknown', ''),
        '00190061': ('US', '1', 'Unknown', ''),
        '00190062': ('US', '1', 'Unknown', ''),
        '00190063': ('FL', '1', 'Unknown', ''),
        '00190065': ('SL', '2', 'Unknown', ''),
        '0019006B': ('SL', '1', 'Unknown', ''),
        '0019006D': ('SL', '1', 'Unknown', ''),
        '0019006E': ('FL', '1', 'Unknown', ''),
        '0019006F': ('SL', '1', 'Unknown', ''),
        '00190070': ('LO', '1', 'Unknown', ''),
        '00190071': ('LO', '1', 'Unknown', ''),
        '00190073': ('LO', '1', 'Unknown', ''),
        '00190075': ('LO', '1', 'Unknown', ''),
        '00190076': ('LO', '1', 'Unknown', ''),
        '00190078': ('LO', '1', 'Unknown', ''),
        '0019007B': ('LO', '1', 'Unknown', ''),
        '0019007C': ('FL', '1', 'Unknown', ''),
        '0019007D': ('FL', '1', 'Unknown', ''),
        '0019007E': ('SL', '1', 'Unknown', ''),
        '0019007F': ('SL', '1', 'Unknown', ''),
        '00190085': ('FL', '1', 'Unknown', ''),
        '00190086': ('SL', '1', 'Unknown', ''),
        '00190087': ('FL', '1', 'Unknown', ''),
        '00190088': ('LO', '1', 'Unknown', ''),
        '00190089': ('FL', '1', 'Unknown', ''),
        '0019008A': ('SL', '1-n', 'Unknown', ''),
        '0019008C': ('UL', '1', 'Unknown', ''),
        '0019008D': ('TM', '1', 'Unknown', ''),
        '0019008E': ('SL', '1', 'Unknown', ''),
        '00190092': ('SL', '1', 'Unknown', ''),
        '00190093': ('FL', '3', 'Unknown', ''),
        '00190096': ('US', '1', 'Unknown', ''),
        '0019009B': ('FL', '3', 'Unknown', ''),
        '0019009C': ('SL', '1', 'Unknown', ''),
        '001900A0': ('SL', '4', 'Unknown', ''),
        '001900A1': ('DS', '1', 'Unknown', ''),
        '001900A2': ('SL', '1', 'Unknown', ''),
        '001900A3': ('SL', '3', 'Unknown', ''),
        '001900A4': ('FL', '3', 'Unknown', ''),
        '001900A5': ('FL', '1', 'Unknown', ''),
        '001900A6': ('SL', '1', 'Unknown', ''),
        '001900A8': ('FL', '1', 'Unknown', ''),
        '001900A9': ('SL', '1', 'Unknown', ''),
        '001900AB': ('FL', '3', 'Unknown', ''),
        '001900AC': ('US', '1', 'Unknown', ''),
        '001900AD': ('FL', '1', 'Unknown', ''),
        '001900AE': ('FL', '1', 'Unknown', ''),
        '001900AF': ('SL', '1', 'Unknown', ''),
        '001900B0': ('SL', '1', 'Unknown', ''),
        '001900B1': ('SL', '1', 'Unknown', ''),
        '001900B4': ('SL', '1', 'Unknown', ''),
        '001900B5': ('SL', '1', 'Unknown', ''),
        '001900B6': ('SL', '1', 'Unknown', ''),
        '001900B7': ('FL', '2', 'Unknown', ''),
        '001900BA': ('FL', '1', 'Unknown', ''),
        '001900BB': ('FL', '1', 'Unknown', ''),
        '001900BC': ('FL', '2', 'Unknown', ''),
        '001900BD': ('SL', '1', 'Unknown', ''),
        '001900BE': ('SL', '1', 'Unknown', ''),
        '001900C1': ('SL', '1', 'Unknown', ''),
        '001900C3': ('SL', '1', 'Unknown', ''),
        '001900C6': ('FL', '2', 'Unknown', ''),
        '001900C9': ('SL', '1', 'Unknown', ''),
        '001900CA': ('LO', '1', 'Unknown', ''),
        '001900CB': ('UL', '1', 'Unknown', ''),
        '001900CC': ('UL', '1', 'Unknown', ''),
        '001900CD': ('SL', '1', 'Unknown', ''),
        '001900CE': ('SL', '1', 'Unknown', ''),
        '001900CF': ('SL', '1', 'Unknown', ''),
        '001900D0': ('US', '1', 'Unknown', ''),
        '001900D1': ('SL', '1', 'Unknown', ''),
        '001900D2': ('SL', '3', 'Unknown', ''),
        '001900D3': ('SL', '1', 'Unknown', ''),
        '001900D4': ('SL', '1', 'Unknown', ''),
        '001900D8': ('US', '1', 'Unknown', ''),
        '001900D9': ('SQ', '1', 'Unknown', ''),
        '001900DA': ('US', '1', 'Unknown', ''),
        '001900DB': ('SL', '1', 'Unknown', ''),
        '001900DC': ('SL', '1', 'Unknown', ''),
        '001900E1': ('SL', '1', 'Unknown', ''),
        '001900E4': ('SL', '1', 'Unknown', ''),
        '001900E5': ('SQ', '1', 'Unknown', ''),
        '001900E6': ('SQ', '1', 'Unknown', ''),
        '001900E9': ('SL', '1', 'Unknown', ''),
        '001900EA': ('UI', '1', 'Unknown', ''),
        '001900EB': ('SL', '1', 'Unknown', ''),
        '001900EC': ('US', '1', 'Unknown', ''),
        '001900EE': ('FL', '1', 'Unknown', ''),
        '001900EF': ('FL', '1', 'Unknown', ''),
        '001900F0': ('SL', '1', 'Unknown', ''),
        '001900F1': ('FL', '1', 'Unknown', ''),
        '001900F2': ('FL', '1', 'Unknown', ''),
        '001900F3': ('SL', '1', 'Unknown', ''),
        '001900F4': ('FD', '1', 'Unknown', ''),
        '001900F5': ('SL', '1', 'Unknown', ''),
        '001900F6': ('UI', '1', 'Unknown', ''),
        '001900F8': ('US', '1', 'Unknown', ''),
        '001900F9': ('SL', '1', 'Unknown', ''),
        '001900FA': ('FL', '1', 'Unknown', ''),
        '001900FB': ('UL', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('FL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
        '001900FF': ('SL', '3', 'Unknown', ''),
        '00210002': ('SL', '1', 'Unknown', ''),
        '00210003': ('SL', '1', 'Unknown', ''),
        '00210004': ('US', '1', 'Unknown', ''),
        '00210008': ('DS', '3', 'Unknown', ''),
        '00210009': ('DS', '3', 'Unknown', ''),
        '0021000A': ('DS', '3', 'Unknown', ''),
        '0021000B': ('US', '1', 'Unknown', ''),
        '0021000C': ('US', '1', 'Unknown', ''),
        '0021000D': ('FL', '1', 'Unknown', ''),
        '0021000F': ('US', '1', 'Unknown', ''),
        '00210012': ('DS', '3', 'Unknown', ''),
        '00210014': ('SQ', '1', 'Unknown', ''),
        '00210015': ('FL', '1', 'Unknown', ''),
        '00210016': ('FL', '2', 'Unknown', ''),
        '00210018': ('US', '1', 'Unknown', ''),
        '0021001D': ('IS', '1', 'Unknown', ''),
        '0021001F': ('US', '1', 'Unknown', ''),
        '00210022': ('US', '1', 'Unknown', ''),
        '00210023': ('SS', '1', 'Unknown', ''),
        '00290001': ('SL', '1', 'Unknown', ''),
        '00290005': ('SQ', '1', 'Unknown', ''),
        '00290006': ('FL', '1', 'Unknown', ''),
        '00290007': ('FL', '1', 'Unknown', ''),
        '0029001C': ('FL', '2', 'Unknown', ''),
        '00290021': ('SL', '3', 'Unknown', ''),
        '0029004E': ('SL', '1', 'Unknown', ''),
        '00290050': ('LO', '1', 'Unknown', ''),
        '00290051': ('LO', '1', 'Unknown', ''),
        '00290052': ('LO', '1', 'Unknown', ''),
        '00290054': ('LO', '1', 'Unknown', ''),
        '00290067': ('FD', '4', 'Unknown', ''),
        '00290068': ('SS', '1', 'Unknown', ''),
        '0029006E': ('OB', '1', 'Unknown', ''),
        '700D0010': ('DS', '1', '2nd Flip Angle [degree]', ''),
        '700D0011': ('US', '2', 'Acquisition Inner Matrix', ''),
        '700D0012': ('US', '1', 'MP2RAGE Flag', ''),
        '700D0013': ('FL', '1', 'Inversion efficiency of inversion recovery pulse', ''),
        '700D0014': ('SL', '1', 'Number of dummy shot', ''),
        '700D0015': ('FL', '1', 'FFE total repetition time[s]', ''),
        '700D0016': ('LO', '3', 'PAS Name', ''),
        '700D0017': ('LT', '1', 'Intended Processing', ''),
        '700D0018': ('SS', '1', 'Scanned Orientation IDs', ''),
        '700D0019': ('OB', '1', 'PAS Reproduct Information', ''),
        '700D001A': ('DS', '1', 'ASTAR Inversion Time', ''),
        '700D001B': ('DS', '1', 'Saturation Recovery Time', ''),
        'E2010002': ('US', '1', 'Unknown', ''),
        'E3010000': ('SH', '1', 'Unknown', ''),
        'E4010000': ('US', '1', 'Unknown', ''),
        'E4010001': ('US', '1', 'Unknown', ''),
        'E4010002': ('US', '1', 'Unknown', ''),
        'E4010003': ('US', '1', 'Unknown', ''),
        'E4010004': ('US', '1', 'Unknown', ''),
        'E4010005': ('OB', '1', 'Unknown', ''),
        'E4010007': ('FL', '1', 'Unknown', ''),
        'E4010008': ('FL', '1', 'Unknown', ''),
        'E4010012': ('FL', '1', 'Unknown', ''),
        'E4010013': ('OB', '1', 'Unknown', ''),
        'E4010020': ('SQ', '1', 'Unknown', ''),
        'E4010021': ('SQ', '1', 'Unknown', ''),
        'E4010022': ('LO', '1', 'Unknown', ''),
        'E4010023': ('SH', '1', 'Unknown', ''),
        'E4010024': ('OB', '1', 'Unknown', ''),
        'E4030000': ('SQ', '1', 'Unknown', ''),
        'EE010000': ('US', '1', 'Unknown', ''),
        'EE010001': ('OB', '1', 'Unknown', ''),
        'EE010002': ('US', '1', 'Unknown', ''),
    },
    'CANON_MEC_MR3^11': {
        '00190001': ('OB', '1', 'Unknown', ''),
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('SL', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190008': ('SH', '1', 'Unknown', ''),
        '00190009': ('SL', '2', 'Unknown', ''),
        '0019000A': ('SL', '1', 'Unknown', ''),
        '0019000C': ('SL', '1', 'Unknown', ''),
        '00190019': ('SQ', '1', 'Unknown', ''),
        '0019001A': ('FL', '1', 'Unknown', ''),
        '00190024': ('SL', '1', 'Unknown', ''),
        '00190025': ('SL', '1', 'Unknown', ''),
        '00190026': ('SL', '1', 'Unknown', ''),
        '00190028': ('SL', '1', 'Unknown', ''),
        '00190029': ('SL', '1', 'Unknown', ''),
        '0019002A': ('FL', '1', 'Unknown', ''),
        '0019002B': ('FL', '1', 'Unknown', ''),
        '0019002C': ('SL', '3', 'Unknown', ''),
        '0019002D': ('SL', '3', 'Unknown', ''),
        '0019002E': ('SL', '1', 'Unknown', ''),
        '00190030': ('SL', '1', 'Unknown', ''),
        '00190031': ('SL', '1', 'Unknown', ''),
        '00190032': ('SL', '1', 'Unknown', ''),
        '00190034': ('FL', '1', 'Unknown', ''),
        '00190035': ('SL', '1', 'Unknown', ''),
        '00190036': ('FL', '1', 'Unknown', ''),
        '00190037': ('SL', '1', 'Unknown', ''),
        '00190038': ('SL', '1', 'Unknown', ''),
        '00190039': ('FL', '1', 'Unknown', ''),
        '0019003A': ('FL', '1', 'Unknown', ''),
        '0019003D': ('SL', '1', 'Unknown', ''),
        '0019003E': ('FL', '9', 'Unknown', ''),
        '0019003F': ('UI', '1', 'Unknown', ''),
        '00190040': ('US', '1', 'Unknown', ''),
        '00190041': ('US', '1', 'Unknown', ''),
        '00190042': ('SL', '1', 'Unknown', ''),
        '00190043': ('SL', '1', 'Unknown', ''),
        '00190044': ('SL', '1', 'Unknown', ''),
        '00190046': ('FL', '1', 'Unknown', ''),
        '00190048': ('LT', '1', 'Unknown', ''),
        '00190049': ('LT', '1', 'Unknown', ''),
        '0019004C': ('SL', '1', 'Unknown', ''),
        '0019004D': ('SL', '1', 'Unknown', ''),
        '0019004E': ('SL', '1', 'Unknown', ''),
        '00190055': ('LO', '1', 'Unknown', ''),
        '00190057': ('FL', '1', 'Unknown', ''),
        '00190058': ('US', '1', 'Unknown', ''),
        '00190059': ('US', '1', 'Unknown', ''),
        '0019005D': ('SL', '1', 'Unknown', ''),
        '0019005E': ('US', '1', 'Unknown', ''),
        '0019005F': ('FL', '1', 'Unknown', ''),
        '00190060': ('SL', '1', 'Unknown', ''),
        '00190061': ('FL', '1', 'Unknown', ''),
        '00190062': ('FL', '1', 'Unknown', ''),
        '00190063': ('SL', '1', 'Unknown', ''),
        '00190065': ('SL', '1', 'Unknown', ''),
        '00190066': ('SL', '6', 'Unknown', ''),
        '00190068': ('SL', '1', 'Unknown', ''),
        '00190069': ('SL', '1', 'Unknown', ''),
        '0019006A': ('SL', '1', 'Unknown', ''),
        '0019006B': ('SL', '6', 'Unknown', ''),
        '0019006D': ('SH', '1', 'Unknown', ''),
        '0019006E': ('SH', '1', 'Unknown', ''),
        '0019006F': ('FL', '1', 'Unknown', ''),
        '00190071': ('SL', '1', 'Unknown', ''),
        '00190072': ('FL', '1', 'Unknown', ''),
        '00190073': ('FL', '1', 'Unknown', ''),
        '00190077': ('FL', '1', 'Unknown', ''),
        '00190078': ('SL', '1', 'Unknown', ''),
        '00190079': ('FL', '1', 'Unknown', ''),
        '0019007A': ('SL', '2', 'Unknown', ''),
        '0019007C': ('FL', '3', 'Unknown', ''),
        '0019007D': ('SL', '1', 'Unknown', ''),
        '0019007E': ('SL', '1', 'Unknown', ''),
        '0019007F': ('SL', '1', 'Unknown', ''),
        '00190080': ('FL', '1', 'Unknown', ''),
        '00190083': ('FL', '1', 'Unknown', ''),
        '00190087': ('SL', '1', 'Unknown', ''),
        '0019008A': ('US', '1', 'Unknown', ''),
        '0019008F': ('SL', '1', 'Unknown', ''),
        '00190092': ('SL', '1', 'Unknown', ''),
        '00190093': ('SL', '1', 'Unknown', ''),
        '00190094': ('FL', '1', 'Unknown', ''),
        '0019009A': ('SL', '1', 'Unknown', ''),
        '0019009B': ('US', '1', 'Unknown', ''),
        '0019009C': ('FL', '1', 'Unknown', ''),
        '0019009D': ('SL', '1', 'Unknown', ''),
        '0019009E': ('SL', '1', 'Unknown', ''),
        '0019009F': ('SL', '1', 'Unknown', ''),
        '001900A1': ('SL', '1', 'Unknown', ''),
        '001900A2': ('SL', '1', 'Unknown', ''),
        '001900A3': ('SL', '1', 'Unknown', ''),
        '001900A5': ('US', '1', 'Unknown', ''),
        '001900A6': ('US', '1', 'Unknown', ''),
        '001900A8': ('SL', '1', 'Unknown', ''),
        '001900AD': ('SL', '1', 'Unknown', ''),
        '001900AE': ('SL', '1', 'Unknown', ''),
        '001900B0': ('FL', '1', 'Unknown', ''),
        '001900B1': ('SL', '1', 'Unknown', ''),
        '001900B2': ('US', '1', 'Unknown', ''),
        '001900B3': ('US', '1', 'Unknown', ''),
        '001900B4': ('US', '1', 'Unknown', ''),
        '001900B5': ('FL', '1', 'Unknown', ''),
        '001900B6': ('SL', '1', 'Unknown', ''),
        '001900B7': ('US', '1', 'Unknown', ''),
        '001900B9': ('US', '1', 'Unknown', ''),
        '001900BB': ('FL', '1', 'Unknown', ''),
        '001900BC': ('SL', '1', 'Unknown', ''),
        '001900BD': ('SL', '1', 'Unknown', ''),
        '001900BE': ('FL', '1', 'Unknown', ''),
        '001900BF': ('SL', '1', 'Unknown', ''),
        '001900C0': ('SL', '1', 'Unknown', ''),
        '001900C1': ('US', '1', 'Unknown', ''),
        '001900C2': ('SL', '1', 'Unknown', ''),
        '001900C3': ('FL', '1', 'Unknown', ''),
        '001900C4': ('SL', '1', 'Unknown', ''),
        '001900CD': ('SL', '3', 'Unknown', ''),
        '001900E1': ('FL', '1', 'Unknown', ''),
        '001900E3': ('SL', '3', 'Unknown', ''),
        '001900E4': ('DS', '1', 'Unknown', ''),
        '001900E5': ('SQ', '1', 'Unknown', ''),
        '001900E6': ('SQ', '1', 'Unknown', ''),
        '001900F1': ('SL', '3', 'Unknown', ''),
        '001900F2': ('FL', '3', 'Unknown', ''),
        '001900F3': ('SL', '1', 'Unknown', ''),
        '001900F4': ('SL', '1', 'Unknown', ''),
        '001900F5': ('SQ', '1', 'Unknown', ''),
        '001900F6': ('SL', '1', 'Unknown', ''),
        '001900F7': ('SL', '1', 'Unknown', ''),
        '001900F8': ('SL', '1', 'Unknown', ''),
        '001900F9': ('SL', '1', 'Unknown', ''),
        '001900FA': ('SL', '1', 'Unknown', ''),
        '001900FB': ('FL', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('SL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
        '001900FF': ('SL', '1', 'Unknown', ''),
    },
    'CANON_MEC_MR3^12': {
        '00190000': ('SL', '1', 'Unknown', ''),
        '00190001': ('SL', '1', 'Unknown', ''),
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('SL', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190005': ('SH', '1', 'Unknown', ''),
        '00190006': ('FL', '1', 'Unknown', ''),
        '00190007': ('UL', '1', 'Unknown', ''),
        '00190008': ('UL', '1', 'Unknown', ''),
        '00190009': ('SL', '1', 'Unknown', ''),
        '0019000A': ('SL', '1', 'Unknown', ''),
        '0019000B': ('SL', '1', 'Unknown', ''),
        '0019000C': ('UL', '1', 'Unknown', ''),
        '0019000D': ('SQ', '1', 'Unknown', ''),
        '0019000E': ('US', '1', 'Unknown', ''),
        '00190010': ('SL', '1', 'Unknown', ''),
        '00190011': ('SL', '1', 'Unknown', ''),
        '00190012': ('SL', '1', 'Unknown', ''),
        '00190013': ('FL', '1', 'Unknown', ''),
        '00190014': ('FL', '1', 'Unknown', ''),
        '00190018': ('UL', '1', 'Unknown', ''),
        '00190028': ('DS', '1', 'Unknown', ''),
        '0019002A': ('DS', '3', 'Unknown', ''),
        '0019002B': ('SQ', '1', 'Unknown', ''),
        '00190032': ('SH', '1', 'Unknown', ''),
        '00190034': ('SL', '1', 'Unknown', ''),
        '00190052': ('FL', '2', 'Unknown', ''),
        '00190076': ('OB', '1', 'Unknown', ''),
        '00190079': ('SQ', '1', 'Unknown', ''),
        '00190080': ('FD', '1', 'Unknown', ''),
        '00190086': ('LO', '1', 'Unknown', ''),
        '00190087': ('SQ', '1', 'Unknown', ''),
        '00190088': ('US', '1', 'Unknown', ''),
        '00190089': ('SL', '1', 'Unknown', ''),
        '0019008A': ('US', '1', 'Unknown', ''),
        '0019008B': ('US', '1', 'Unknown', ''),
        '00190093': ('SL', '1', 'Unknown', ''),
        '00190094': ('UI', '1', 'Unknown', ''),
        '00190095': ('UI', '1', 'Unknown', ''),
        '00190097': ('FL', '1', 'Unknown', ''),
        '00190098': ('FL', '3', 'Unknown', ''),
        '00190099': ('LO', '1', 'Unknown', ''),
        '0019009A': ('DS', '1', 'Unknown', ''),
        '0019009B': ('IS', '1', 'Unknown', ''),
        '0019009C': ('DS', '1', 'Unknown', ''),
        '0019009D': ('US', '1', 'Unknown', ''),
        '0019009E': ('FL', '3', 'Unknown', ''),
        '0019009F': ('FL', '1', 'Unknown', ''),
        '001900A0': ('FL', '1', 'Unknown', ''),
        '001900A1': ('FL', '1', 'Unknown', ''),
        '001900A2': ('FL', '1', 'Unknown', ''),
        '001900A3': ('FL', '1', 'Unknown', ''),
        '001900A4': ('FL', '1', 'Unknown', ''),
        '001900A5': ('FL', '1', 'Unknown', ''),
        '001900A6': ('FL', '2-2n', 'Unknown', ''),
        '001900A7': ('FL', '1', 'Unknown', ''),
        '001900A8': ('FL', '1', 'Unknown', ''),
        '001900AA': ('FL', '3', 'Unknown', ''),
        '001900AB': ('FL', '3', 'Unknown', ''),
        '001900AC': ('FL', '3', 'Unknown', ''),
        '001900AD': ('FL', '3', 'Unknown', ''),
        '001900AE': ('FL', '3', 'Unknown', ''),
        '001900AF': ('FL', '3', 'Unknown', ''),
        '001900B3': ('FD', '1', 'Unknown', ''),
        '001900C2': ('US', '1', 'Unknown', ''),
        '001900C3': ('FL', '1', 'Unknown', ''),
        '001900C4': ('SL', '1', 'Unknown', ''),
        '001900C5': ('SL', '1', 'Unknown', ''),
        '001900C6': ('SL', '1', 'Unknown', ''),
        '001900C7': ('FL', '1', 'Unknown', ''),
        '001900CD': ('LO', '1', 'Unknown', ''),
        '001900CE': ('UL', '1', 'Unknown', ''),
        '001900CF': ('FL', '1', 'Unknown', ''),
        '001900D1': ('FL', '3', 'Unknown', ''),
        '001900D2': ('US', '3', 'Unknown', ''),
        '001900D3': ('SS', '1', 'Unknown', ''),
        '001900D4': ('US', '2', 'Unknown', ''),
        '001900D5': ('FL', '1', 'Unknown', ''),
        '001900D6': ('FL', '3', 'Unknown', ''),
        '001900D7': ('US', '2', 'Unknown', ''),
        '001900DE': ('US', '1', 'Unknown', ''),
        '001900DF': ('US', '1', 'Unknown', ''),
        '001900E0': ('US', '1', 'Unknown', ''),
        '001900E1': ('FL', '3', 'Unknown', ''),
        '001900E2': ('FL', '3', 'Unknown', ''),
        '001900E3': ('TM', '1', 'Unknown', ''),
        '001900E4': ('US', '2', 'Unknown', ''),
        '001900EB': ('US', '1', 'Unknown', ''),
        '001900EC': ('US', '1', 'Unknown', ''),
        '001900EF': ('DS', '1', 'Unknown', ''),
        '001900F0': ('LO', '1', 'Unknown', ''),
        '001900F1': ('LO', '1', 'Unknown', ''),
        '001900FA': ('LT', '1', 'Unknown', ''),
        '001900FB': ('FL', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('SL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
    },
    'CANON_MEC_MR3^13': {
        '00190002': ('US', '1', 'Unknown', ''),
        '00190003': ('SL', '1', 'Unknown', ''),
        '00190004': ('US', '1', 'Unknown', ''),
        '00190005': ('SL', '1', 'Unknown', ''),
        '00190008': ('SL', '1', 'Unknown', ''),
        '00190009': ('SQ', '1', 'Unknown', ''),
        '0019000A': ('FD', '3', 'Unknown', ''),
        '0019000B': ('FD', '1', 'Unknown', ''),
        '0019000C': ('FD', '1', 'Unknown', ''),
        '0019000F': ('SH', '1', 'Unknown', ''),
        '00190014': ('SH', '1', 'Unknown', ''),
        '00190019': ('US', '1', 'Unknown', ''),
        '0019001B': ('US', '1', 'Unknown', ''),
        '0019001F': ('US', '1', 'Unknown', ''),
        '00190022': ('SL', '1', 'Unknown', ''),
        'E4030000': ('SH', '1', 'Unknown', ''),
        'E4030001': ('OB', '1', 'Unknown', ''),
        'E4030002': ('OB', '1', 'Unknown', ''),
        'E4030003': ('OB', '1', 'Unknown', ''),
    },
    'CARDIO-D.R. 1.0': {
        '0009xx00': ('UL', '1', 'File Location', ''),
        '0009xx01': ('UL', '1', 'File Size', ''),
        '0009xx40': ('SQ', '1', 'Alternate Image Sequence', ''),
        '0019xx00': ('CS', '1-2', 'Image Blanking Shape', ''),
        '0019xx02': ('IS', '1', 'Image Blanking Left Vertical Edge', ''),
        '0019xx04': ('IS', '1', 'Image Blanking Right Vertical Edge', ''),
        '0019xx06': ('IS', '1', 'Image Blanking Upper Horizontal Edge', ''),
        '0019xx08': ('IS', '1', 'Image Blanking Lower Horizontal Edge', ''),
        '0019xx10': ('IS', '2', 'Center Of Circular Image Blanking', ''),
        '0019xx12': ('IS', '1', 'Radius Of Circular Image Blanking', ''),
        '0019xx30': ('UL', '1', 'Maximum Frame Size', ''),
        '0021xx13': ('IS', '1', 'Image Sequence Number', ''),
        '0029xx00': ('SQ', '1', 'Standard Edge Enhancement Sequence', ''),
        '0029xx01': ('US', '2', 'Convolution Kernel Size', ''),
        '0029xx02': ('US', '1-n', 'Convolution Kernel Coefficients', ''),
        '0029xx03': ('FL', '1', 'Edge Enhancement Gain', ''),
    },
    'CARDIO-SMS 1.0': {
        '0009xx02': ('OB', '1', 'Private Data', ''),
        '0009xx03': ('OB', '1', 'Private Data', ''),
        '0009xx04': ('OB', '1', 'Private Data', ''),
        '0009xx05': ('OB', '1', 'Private Data', ''),
        '0009xx06': ('OB', '1', 'Private Data', ''),
        '0009xx08': ('OB', '1', 'ACOM flags', ''),
        '0009xx0A': ('UN', '1', 'Private Data', ''),
        '0009xx0B': ('UN', '1', 'Private Data', ''),
        '0009xx0C': ('UN', '1', 'Private Data', ''),
        '0029xx80': ('SQ', '1', 'Private Data', ''),
        '0031xx01': ('UN', '1', 'Private Data stream', ''),
    },
    'CEMAX-ICON': {
        '0019xx00': ('LT', '1', 'CR Processing Parameters', ''),
        '0019xx10': ('LO', '1', 'CR Exposure Menu Code', ''),
        '0019xx20': ('LO', '1', 'CR Exposure Menu String', ''),
        '0019xx30': ('LO', '1', 'CR EDR Mode', ''),
        '0019xx40': ('LO', '1', 'CR Latitude', ''),
        '0019xx50': ('LO', '1', 'CR Group Number', ''),
        '0019xx60': ('LO', '1', 'CR Equipment ID', ''),
        '0019xx70': ('LO', '1', 'CR Image Serial Number', ''),
        '0019xx80': ('LO', '1', 'CR Bar Code Number', ''),
        '0019xx90': ('LO', '1', 'CR Film Output Exposure', ''),
        '0029xx00': ('LO', '1', 'Key Image', ''),
        '0029xx10': ('LT', '1-n', 'Note', ''),
        '0029xx20': ('SQ', '1', 'Annotation Sequence', ''),
        '0029xx30': ('IS', '1', 'X Start Position', ''),
        '0029xx40': ('IS', '1', 'Y Start Position', ''),
        '0029xx50': ('IS', '1', 'X End Position', ''),
        '0029xx60': ('IS', '1', 'Y End Position', ''),
        '0029xx70': ('LO', '1', 'Annotation Text', ''),
        '0029xx80': ('IS', '1', 'Which Marker', ''),
        '0029xx90': ('SQ', '1', 'Annotation Sequence', ''),
        '0029xx91': ('IS', '1-n', 'X Coordinates', ''),
        '0029xx92': ('IS', '1-n', 'Y Coordinates', ''),
        '0029xx93': ('IS', '1', 'Annotation Type', ''),
        '0029xx94': ('IS', '1', 'Number of points', ''),
        '0029xx95': ('IS', '1', 'Fill Type', ''),
        '3033xx00': ('CS', '1', 'Study Priority Status', ''),
    },
    'Canon Inc.': {
        '0019xx10': ('OB', '1', 'Canon Internal Data 1', ''),
        '0019xx13': ('UN', '1', 'Unknown', ''),
        '0019xx15': ('DS', '2', 'Unknown', ''),
        '0019xx16': ('UN', '1', 'Unknown', ''),
        '0019xx17': ('DS', '1', 'Unknown', ''),
        '0019xx18': ('UN', '1', 'Unknown', ''),
        '0019xx19': ('UN', '1', 'Unknown', ''),
        '0019xx1A': ('UN', '1', 'Unknown', ''),
        '0019xx1B': ('LO', '1', 'Unknown', ''),
        '0019xx1C': ('IS', '1', 'Unknown', ''),
        '0019xx1E': ('IS', '1', 'Unknown', ''),
        '0019xx1F': ('UN', '1', 'Unknown', ''),
        '0019xx21': ('IS', '1', 'Unknown', ''),
        '0019xx60': ('US', '1', 'Performed number of series', ''),
        '0019xx70': ('US', '1', 'Performed number of images', ''),
        '0019xx7F': ('OB', '1', 'Canon Internal Data 111', ''),
    },
    'DIDI TO PCR 1.1': {
        '0019xx00': ('LT', '1', 'Post Mode String', ''),
        '0019xx01': ('LT', '1', 'Post Data', ''),
        '0019xx10': ('LT', '1', 'Image Header', ''),
        '0019xx22': ('LO', '1', 'Route AET', ''),
        '0019xx23': ('DS', '1', 'PCR Print Scale', ''),
        '0019xx24': ('ST', '1', 'PCR Print Job End', ''),
        '0019xx25': ('IS', '1', 'PCR No Film Copies', ''),
        '0019xx26': ('IS', '1', 'PCR Film Layout Position', ''),
        '0019xx27': ('ST', '1', 'PCR Print Report Name', ''),
        '0019xx70': ('ST', '1', 'RAD Protocol Printer', ''),
        '0019xx71': ('ST', '1', 'RAD Protocol Medium', ''),
        '0019xx80': ('LO', '1', 'Original Filename', ''),
        '0019xx81': ('SH', '1', 'Filter Type', ''),
        '0019xx82': ('LT', '1', 'Stitching', ''),
        '0019xx89': ('IS', '1', 'Exposure Index', ''),
        '0019xx8A': ('IS', '1', 'Collimator X', ''),
        '0019xx8B': ('IS', '1', 'Collimator Y', ''),
        '0019xx8C': ('LO', '1', 'Print Marker', ''),
        '0019xx8D': ('LO', '1', 'RGDV Name', ''),
        '0019xx8E': ('LO', '1', 'Acqd Sensitivity', ''),
        '0019xx8F': ('LO', '1', 'Processing Category', ''),
        '0019xx90': ('LO', '1', 'Unprocessed Flag', ''),
        '0019xx91': ('DS', '2', 'Key Values', ''),
        '0019xx92': ('LO', '1', 'Destination Postprocessing Function', ''),
        '0019xxA0': ('LO', '1', 'Version', ''),
        '0019xxA1': ('LO', '1', 'Ranging Mode', ''),
        '0019xxA2': ('DS', '1', 'Abdomen Brightness', ''),
        '0019xxA3': ('DS', '1', 'Fixed Brightness', ''),
        '0019xxA4': ('DS', '1', 'Detail Contrast', ''),
        '0019xxA5': ('DA', '1', 'Contrast Balance', ''),
        '0019xxA6': ('DS', '1', 'Structure Boost', ''),
        '0019xxA7': ('DS', '1', 'Structure Preference', ''),
        '0019xxA8': ('DS', '1', 'Noise Robustness', ''),
        '0019xxA9': ('DS', '1', 'Noise Dose Limit', ''),
        '0019xxAA': ('DS', '1', 'Noise Dose Step', ''),
        '0019xxAB': ('DS', '1', 'Noise Frequency Limit', ''),
        '0019xxAC': ('DS', '1', 'Weak Contrast Limit', ''),
        '0019xxAD': ('DS', '1', 'Strong Contrast Limit', ''),
        '0019xxAE': ('DS', '1', 'Structure Boost Offset', ''),
        '0019xxAF': ('LO', '1', 'Smooth Gain', ''),
        '0019xxB0': ('LO', '1', 'Measure Field 1', ''),
        '0019xxB1': ('LO', '1', 'Measure Field 2', ''),
        '0019xxB2': ('IS', '1', 'Key Percentile 1', ''),
        '0019xxB3': ('IS', '1', 'Key Percentile 2', ''),
        '0019xxB4': ('IS', '1', 'Density LUT', ''),
        '0019xxB5': ('DS', '1', 'Brightness', ''),
        '0019xxB6': ('DS', '1', 'Gamma', ''),
        '0089xx10': ('SQ', '1', 'Stamp Image Sequence', ''),
    },
    'DIGISCAN IMAGE': {
        '0029xx31': ('US', '1-n', 'Unknown', ''),
        '0029xx32': ('US', '1-n', 'Unknown', ''),
        '0029xx33': ('LO', '1', 'Unknown', ''),
        '0029xx34': ('LO', '1', 'Unknown', ''),
    },
    'DLX_ANNOT_01': {
        '70xxxx04': ('ST', '1', 'Text_annotation', ''),
        '70xxxx05': ('IS', '2', 'Box', ''),
        '70xxxx07': ('IS', '2', 'Arrow end', ''),
    },
    'DLX_EXAMS_01': {
        '0015xx01': ('DS', '1', 'Stenos_calibr_ratio;', ''),
        '0015xx02': ('DS', '1', 'Stenos_magnification;', ''),
        '0015xx03': ('DS', '1', 'Cardiac_calibr_ratio;', ''),
    },
    'DLX_LKUP_01': {
        '60xxxx01': ('LT', '3', 'Gray Palette color lookup table descriptor', ''),
        '60xxxx02': ('LT', '1', 'Gray Palette color lookup table data', ''),
    },
    'DLX_PATNT_01': {
        '0011xx01': ('LT', '1', 'patient DOB', ''),
    },
    'DLX_SERIE_01': {
        '0019xx01': ('DS', '1', 'Angle Value 1', ''),
        '0019xx02': ('DS', '1', 'Angle Value 2', ''),
        '0019xx03': ('DS', '1', 'Angle Value 3', ''),
        '0019xx04': ('CS', '1', 'Angle Label 1', ''),
        '0019xx05': ('CS', '1', 'Angle Label 2', ''),
        '0019xx06': ('CS', '1', 'Angle Label 3', ''),
        '0019xx07': ('ST', '1', 'Adx Procedure Name', ''),
        '0019xx08': ('ST', '1', 'Adx Exam Name', ''),
        '0019xx09': ('SH', '1', 'Adx Patient Size', ''),
        '0019xx0A': ('IS', '1', 'Adx Record View', ''),
        '0019xx10': ('DS', '1', 'Adx Injector Delay', ''),
        '0019xx11': ('CS', '1', 'Adx Auto Inject', ''),
        '0019xx14': ('IS', '1', 'Adx Acq Mode', ''),
        '0019xx15': ('CS', '1', 'Adx Camera Rotation Enable', ''),
        '0019xx16': ('CS', '1', 'Adx Reverse Sweep', ''),
        '0019xx17': ('IS', '1', 'User Spatial Filter Strength', ''),
        '0019xx18': ('IS', '1', 'User Zoom Factor', ''),
        '0019xx19': ('IS', '1', 'X Zoom', ''),
        '0019xx1A': ('IS', '1', 'Y Zoom', ''),
        '0019xx1B': ('DS', '1', 'Adx Focus', ''),
        '0019xx1C': ('CS', '1', 'Adx Dose', ''),
        '0019xx1D': ('IS', '1', 'Side Mark', ''),
        '0019xx1E': ('IS', '1', 'Percent Landscape', ''),
        '0019xx1F': ('DS', '1', 'Adx Exposure Duration', ''),
        '0019xx20': ('SH', '1', 'Ip Address', ''),
        '0019xx21': ('DS', '1', 'Table Vertical Position', ''),
        '0019xx22': ('DS', '1', 'Table Longitudinal Position', ''),
        '0019xx23': ('DS', '1', 'Table Lateral Position', ''),
        '0019xx24': ('DS', '1', 'Lambda cm Pincushion Distortion', ''),
        '0019xx25': ('DS', '1', 'Slope LV Regression', ''),
        '0019xx26': ('DS', '1', 'Intercept LV Regression', ''),
        '0019xx27': ('DS', '1', 'Image chain FWHM psf mm min', ''),
        '0019xx28': ('DS', '1', 'Image chain FWHM psf mm max', ''),
    },
    'DL_INTERNAL_USE': {
        '0015xx8F': ('IS', '1', 'Unknown', ''),
    },
    'DR Systems, Inc.': {
        '4453xx01': ('LO', '1', 'DR Exam ID', ''),
        '4453xx02': ('LO', '1', 'DR Image Type', ''),
        '4453xx04': ('LO', '1', 'DR File Type', ''),
        '4453xx05': ('LO', '1', 'DR File Suffix', ''),
        '4453xx0A': ('UN', '1', 'DR Annotation Type', ''),
        '4453xx0C': ('SQ', '1', 'DR Original Instance UID Sequence', ''),
    },
    'DicomUtils 20100512': {
        '00090001': ('SQ', '1', 'DICOMUTILS_PROCESSING_METHODS', ''),
    },
    'ELGEMS_XPERT': {
        '7FA1xx00': ('OB', '1', 'XPert Composite Report Item buffer', ''),
        '7FA1xx10': ('OB', '1', 'Xpert Composite Report Item Identificator', ''),
    },
    'ELSCINT1': {
        '0003xx01': ('OW', '1', 'Offset List Structure', ''),
        '00E10046': ('OB', '1', 'Unknown', ''),
        '00E100E1': ('UN', '1', 'Unknown', ''),
        '00E100EC': ('UN', '1', 'Unknown', ''),
        '00E11021': ('DS', '1', 'DLP', ''),
        '00E11037': ('DS', '1', 'Total Saving Dose', ''),
        '00E1103E': ('IS', '1', 'Split Is Dual Surview', ''),
        '00E11050': ('DS', '1', 'Acquisition Duration', ''),
        '00E110C4': ('DS', '1', 'Abs Bed Pos', ''),
        '00E1xx01': ('US', '1', 'Data Dictionary Version', ''),
        '00E1xx05': ('IS', '1', 'Unknown', ''),
        '00E1xx06': ('IS', '1', 'Unknown', ''),
        '00E1xx07': ('IS', '1', 'Unknown', ''),
        '00E1xx14': ('CS', '1', 'Unknown', ''),
        '00E1xx18': ('OB', '1', 'Unknown', ''),
        '00E1xx21': ('DS', '1', 'Unknown', ''),
        '00E1xx22': ('DS', '2', 'Presentation Relative Center', ''),
        '00E1xx23': ('DS', '2', 'Presentation Relative Part', ''),
        '00E1xx24': ('CS', '1', 'Presentation Horizontal Invert', ''),
        '00E1xx25': ('CS', '1', 'Unknown', ''),
        '00E1xx2A': ('DS', '1', 'Unknown', ''),
        '00E1xx30': ('UI', '1', 'Unknown', ''),
        '00E1xx31': ('CS', '1', 'Unknown', ''),
        '00E1xx32': ('US', '2', 'Unknown', ''),
        '00E1xx37': ('DS', '1', 'Unknown', ''),
        '00E1xx39': ('SQ', '1', 'Unknown', ''),
        '00E1xx3F': ('CS', '1', 'Unknown', ''),
        '00E1xx40': ('SH', '1', 'Image Label', ''),
        '00E1xx41': ('DS', '1', 'Unknown', ''),
        '00E1xx42': ('LO', '1', 'Unknown', ''),
        '00E1xx43': ('IS', '1', 'Unknown', ''),
        '00E1xx50': ('DS', '1', 'Acquisition Duration', ''),
        '00E1xx51': ('SH', '1', 'Unknown', ''),
        '00E1xx60': ('CS', '1', 'Unknown', ''),
        '00E1xx61': ('LO', '1', 'Protocol File Name', ''),
        '00E1xx62': ('CS', '1', 'Unknown', ''),
        '00E1xx63': ('SH', '1', 'Patient Language', ''),
        '00E1xx65': ('LO', '1', 'Patient Data Modification Date', ''),
        '00E1xx6A': ('IS', '1', 'Unknown', ''),
        '00E1xx6B': ('IS', '1', 'Unknown', ''),
        '00E1xxA0': ('LO', '1', 'Unknown', ''),
        '00E1xxC2': ('UI', '1', 'Unknown', ''),
        '00E3xx00': ('OB', '1', 'Unknown', ''),
        '00E3xx18': ('OB', '1', 'Unknown', ''),
        '00E3xx1F': ('OB', '1', 'Unknown', ''),
        '01E10040': ('UN', '1', 'Unknown', ''),
        '01E11017': ('UI', '1', 'ECG Reference UID', ''),
        '01E11026': ('CS', '1', 'Phantom Type', ''),
        '01E1xx18': ('OB', '1', 'Unknown', ''),
        '01E1xx21': ('ST', '1', 'Unknown', ''),
        '01E1xx34': ('IS', '1', 'Unknown', ''),
        '01F1000F': ('UN', '1', 'Unknown', ''),
        '01F11001': ('CS', '1', 'Acquisition Type', ''),
        '01F11002': ('CS', '1', 'Resolution', ''),
        '01F11004': ('CS', '1', 'Angular Sampling', ''),
        '01F11008': ('DS', '1', 'Scan Length', ''),
        '01F1100C': ('DS', '1', 'Scanner Relative Center', ''),
        '01F1100E': ('FL', '1', 'Recon Enhancement', ''),
        '01F11026': ('FD', '1', 'Pitch', ''),
        '01F11027': ('DS', '1', 'Rotation Time', ''),
        '01F11028': ('DS', '1', 'Table Increment', ''),
        '01F11032': ('CS', '1', 'View Convention', ''),
        '01F11033': ('DS', '1', 'Cycle Time', ''),
        '01F11041': ('LO', '1', 'Gating Delay', ''),
        '01F11045': ('IS', '1', 'Initial Heart Rate', ''),
        '01F11049': ('DS', '1', 'Planned mAs', ''),
        '01F1104B': ('SH', '1', 'Collimation', ''),
        '01F1104C': ('SH', '1', 'DOSE Right DOM', ''),
        '01F1104D': ('SH', '1', 'Adaptive Filter', ''),
        '01F1104E': ('SH', '1', 'Scan Type', ''),
        '01F1xx01': ('CS', '1', 'Acquisition Type', ''),
        '01F1xx02': ('CS', '1', 'Unknown', ''),
        '01F1xx03': ('CS', '1', 'Concurrent Slices Generation', ''),
        '01F1xx04': ('CS', '1', 'Angular Sampling Density', ''),
        '01F1xx05': ('DS', '1', 'Reconstruction Arc', ''),
        '01F1xx06': ('DS', '1', 'Unknown', ''),
        '01F1xx07': ('DS', '1', 'Table Velocity', ''),
        '01F1xx08': ('DS', '1', 'Acquisition Length', ''),
        '01F1xx0A': ('US', '1', 'Edge Enhancement Weight', ''),
        '01F1xx0B': ('CS', '2', 'Unknown', ''),
        '01F1xx0C': ('DS', '2', 'Scanner Relative Center', ''),
        '01F1xx0D': ('DS', '1', 'Rotation Angle', ''),
        '01F1xx0E': ('FL', '1', 'Unknown', ''),
        '01F1xx26': ('DS', '1', 'Pitch', ''),
        '01F1xx27': ('DS', '1', 'Rotation Time', ''),
        '01F1xx28': ('DS', '1', 'Unknown', ''),
        '01F1xx30': ('US', '1', 'Unknown', ''),
        '01F1xx32': ('CS', '1', 'Image View Convention', ''),
        '01F1xx33': ('DS', '1', 'Unknown', ''),
        '01F1xx36': ('CS', '1', 'Unknown', ''),
        '01F1xx37': ('DS', '1', 'Unknown', ''),
        '01F1xx38': ('LO', '1', 'Unknown', ''),
        '01F1xx39': ('LO', '1', 'Unknown', ''),
        '01F1xx40': ('CS', '1', 'Unknown', ''),
        '01F1xx42': ('SH', '1', 'Unknown', ''),
        '01F1xx43': ('LO', '1', 'Unknown', ''),
        '01F1xx44': ('OW', '1', 'Unknown', ''),
        '01F1xx45': ('IS', '1', 'Unknown', ''),
        '01F1xx46': ('FL', '1', 'Unknown', ''),
        '01F1xx47': ('SH', '1', 'Unknown', ''),
        '01F1xx49': ('DS', '1', 'Unknown', ''),
        '01F1xx4A': ('SH', '1', 'Unknown', ''),
        '01F1xx4B': ('SH', '1', 'Unknown', ''),
        '01F1xx4C': ('SH', '1', 'Unknown', ''),
        '01F1xx4D': ('SH', '1', 'Unknown', ''),
        '01F1xx4E': ('LO', '1', 'Unknown', ''),
        '01F1xx53': ('SH', '1', 'Unknown', ''),
        '01F3xx01': ('SQ', '1', 'Unknown', ''),
        '01F3xx02': ('SS', '1', 'Unknown', ''),
        '01F3xx03': ('FL', '2', 'Unknown', ''),
        '01F3xx04': ('FL', '1', 'Unknown', ''),
        '01F3xx11': ('SQ', '1', 'PS Sequence', ''),
        '01F3xx12': ('SS', '1', 'Unknown', ''),
        '01F3xx13': ('FL', '2', 'Unknown', ''),
        '01F3xx14': ('FL', '1', 'Unknown', ''),
        '01F3xx15': ('US', '1', 'Unknown', ''),
        '01F3xx16': ('FL', '1', 'Unknown', ''),
        '01F3xx17': ('FL', '1', 'Unknown', ''),
        '01F3xx18': ('SH', '1', 'Unknown', ''),
        '01F3xx19': ('FL', '1', 'Unknown', ''),
        '01F3xx23': ('US', '1', 'Unknown', ''),
        '01F3xx24': ('IS', '2', 'Unknown', ''),
        '01F70097': ('UN', '1', 'Unknown', ''),
        '01F70099': ('UN', '1', 'Unknown', ''),
        '01F7009B': ('IS', '1', 'iDose Level', ''),
        '01F7109B': ('IS', '1', 'iDose Level', ''),
        '01F7xx10': ('OB', '1', 'Unknown', ''),
        '01F7xx11': ('OW', '1', 'Unknown', ''),
        '01F7xx13': ('OW', '1', 'Unknown', ''),
        '01F7xx14': ('OW', '1', 'Unknown', ''),
        '01F7xx15': ('OW', '1', 'Unknown', ''),
        '01F7xx16': ('OW', '1', 'Unknown', ''),
        '01F7xx17': ('OW', '1', 'Unknown', ''),
        '01F7xx18': ('OW', '1', 'Unknown', ''),
        '01F7xx19': ('OW', '1', 'Unknown', ''),
        '01F7xx1A': ('OW', '1', 'Unknown', ''),
        '01F7xx1B': ('OW', '1', 'Unknown', ''),
        '01F7xx1C': ('OW', '1', 'Unknown', ''),
        '01F7xx1E': ('OW', '1', 'Unknown', ''),
        '01F7xx1F': ('OW', '1', 'Unknown', ''),
        '01F7xx22': ('UI', '1', 'Unknown', ''),
        '01F7xx23': ('OW', '1', 'Unknown', ''),
        '01F7xx25': ('OW', '1', 'Unknown', ''),
        '01F7xx26': ('OW', '1', 'Unknown', ''),
        '01F7xx27': ('OW', '1', 'Unknown', ''),
        '01F7xx28': ('OW', '1', 'Unknown', ''),
        '01F7xx29': ('OW', '1', 'Unknown', ''),
        '01F7xx2B': ('OW', '1', 'Unknown', ''),
        '01F7xx2C': ('OW', '1', 'Unknown', ''),
        '01F7xx2D': ('OW', '1', 'Unknown', ''),
        '01F7xx2E': ('OW', '1', 'Unknown', ''),
        '01F7xx30': ('OW', '1', 'Unknown', ''),
        '01F7xx31': ('OW', '1', 'Unknown', ''),
        '01F7xx70': ('OW', '1', 'Unknown', ''),
        '01F7xx73': ('OW', '1', 'Unknown', ''),
        '01F7xx74': ('OW', '1', 'Unknown', ''),
        '01F7xx75': ('OW', '1', 'Unknown', ''),
        '01F91001': ('LO', '1', 'Mar Filter', ''),
        '01F91002': ('DS', '1', 'Recon Increment', ''),
        '01F91003': ('DS', '1', 'CTDIw', ''),
        '01F91004': ('IS', '1', 'Couch Direction', ''),
        '01F91005': ('IS', '1', 'Series No In Acquisition', ''),
        '01F91007': ('SH', '1', 'Dose Right ACS', ''),
        '01F91008': ('DS', '1', 'Left DMS Tmp Diff', ''),
        '01F91009': ('DS', '1', 'Right DMS Tmp Diff', ''),
        '01F91010': ('LO', '1', 'Dose Right Noise', ''),
        '01F91011': ('DS', '1', 'Zero Position', ''),
        '01F91012': ('DS', '1', 'Show Couch Position', ''),
        '01F91013': ('IS', '1', 'Recon Mode', ''),
        '01F91014': ('DS', '1', 'Water Size', ''),
        '01F91015': ('DS', '1', 'Digital Tilt', ''),
        '01F91016': ('DS', '1', 'Scan Arc', ''),
        '0601xx00': ('SH', '1', 'Implementation Version', ''),
        '0601xx20': ('DS', '1', 'Relative Table Position', ''),
        '0601xx21': ('DS', '1', 'Relative Table Height', ''),
        '0601xx30': ('SH', '1', 'Surview Direction', ''),
        '0601xx31': ('DS', '1', 'Surview Length', ''),
        '0601xx50': ('SH', '1', 'Image View Type', ''),
        '0601xx70': ('DS', '1', 'Batch Number', ''),
        '0601xx71': ('DS', '1', 'Batch Size', ''),
        '0601xx72': ('DS', '1', 'Batch Slice Number', ''),
        '07A1xx01': ('UL', '1', 'number of series in study', ''),
        '07A1xx02': ('UL', '1', 'number of images in series', ''),
        '07A1xx03': ('UL', '1', 'last update time', ''),
        '07A1xx04': ('UL', '1', 'last update date', ''),
        '07A1xx07': ('US', '3', 'Unknown', ''),
        '07A1xx08': ('DS', '1-n', 'Unknown', ''),
        '07A1xx09': ('OW', '1', 'Unknown', ''),
        '07A1xx0A': ('OB', '1', 'Tamar Compressed Pixel Data', ''),
        '07A1xx0C': ('US', '1', 'Unknown', ''),
        '07A1xx10': ('LO', '1', 'Tamar Software Version', ''),
        '07A1xx11': ('CS', '1', 'Tamar Compression Type', ''),
        '07A1xx12': ('FL', '1-n', 'Unknown', ''),
        '07A1xx13': ('UL', '1', 'Unknown', ''),
        '07A1xx14': ('LO', '1', 'protection flag', ''),
        '07A1xx16': ('FL', '1-n', 'Unknown', ''),
        '07A1xx18': ('SQ', '1', 'Unknown', ''),
        '07A1xx19': ('FL', '1', 'Unknown', ''),
        '07A1xx1C': ('FL', '1-n', 'Unknown', ''),
        '07A1xx2A': ('CS', '1', 'Tamar Study Status', ''),
        '07A1xx2B': ('CS', '1', 'Unknown', ''),
        '07A1xx36': ('AE', '1', 'Tamar Source Ae', ''),
        '07A1xx40': ('CS', '1', 'Tamar Study Body Part', ''),
        '07A1xx43': ('IS', '1', 'Unknown', ''),
        '07A1xx50': ('US', '1', 'Tamar Site Id', ''),
        '07A1xx56': ('US', '1', 'Unknown', ''),
        '07A1xx5A': ('CS', '1', 'Unknown', ''),
        '07A1xx75': ('LO', '2', 'Unknown', ''),
        '07A1xx85': ('UL', '1', 'Tamar Translate Flags', ''),
        '07A1xx9F': ('CS', '1', 'Unknown', ''),
        '07A3xx01': ('LO', '1', 'Tamar Exe Software Version', ''),
        '07A3xx03': ('CS', '1', 'Tamar Study Has Sticky Note', ''),
        '07A3xx05': ('CS', '1', 'Unknown', ''),
        '07A3xx06': ('CS', '1', 'Unknown', ''),
        '07A3xx10': ('LO', '1', 'Tamar Original Curve Desc', ''),
        '07A3xx34': ('SH', '1', 'Tamar Study Age', ''),
        '07A3xx43': ('DS', '1-n', 'Unknown', ''),
        '07A3xx55': ('SH', '1', 'Unknown', ''),
        '07A3xx61': ('LT', '1', 'Unknown', ''),
        '07A3xx62': ('SQ', '1', 'Unknown', ''),
        '07A3xx63': ('SQ', '1', 'Unknown', ''),
        '07A3xx64': ('IS', '1-n', 'Unknown', ''),
        '07A3xx66': ('IS', '1', 'Unknown', ''),
        '07A3xx99': ('CS', '1', 'Unknown', ''),
        '07A3xx9C': ('CS', '1', 'Unknown', ''),
        '07A3xx9F': ('CS', '1', 'Unknown', ''),
        '5001xx70': ('SQ', '1', 'Unknown', ''),
        '5001xx71': ('SH', '1', 'Unknown', ''),
        '5001xx80': ('SQ', '1', 'Unknown', ''),
        '5001xx81': ('SH', '1', 'Unknown', ''),
        '5001xx82': ('US', '3', 'Unknown', ''),
        '5001xx83': ('FL', '1-n', 'Unknown', ''),
        '5001xx84': ('SQ', '1', 'Unknown', ''),
        '6001xx10': ('CS', '1', 'Text Overlay Flag', ''),
        '7FDFxxF0': ('OB', '1', 'Unknown', ''),
        '7FDFxxFF': ('SH', '1', 'Unknown', ''),
    },
    'EMAGEON JPEG2K INFO': {
        '0009xx00': ('SQ', '1', 'Unknown', ''),
        '0009xx01': ('DT', '1', 'Unknown', ''),
    },
    'EMAGEON STUDY HOME': {
        '0009xx00': ('LO', '1', 'Unknown', ''),
        '0009xx01': ('LO', '1', 'Unknown', ''),
    },
    'Eclipse 60': {
        '0029xx30': ('UL', '1', 'Private data', ''),
        '0029xx31': ('UL', '1', 'Private data', ''),
        '0029xx32': ('UL', '1', 'Private data', ''),
        '0029xx33': ('DS', '1', 'Private data', ''),
        '0029xx34': ('DS', '1', 'Private data', ''),
        '0029xx36': ('SL', '1', 'Private data', ''),
        '0029xx40': ('CS', '1', 'Private data', ''),
        '0029xx50': ('CS', '1', 'Private data', ''),
        '0029xx51': ('UL', '1', 'Private data', ''),
        '0029xx52': ('UL', '1', 'Private data', ''),
        '0029xx53': ('DS', '1', 'Private data', ''),
        '0029xx54': ('UL', '1', 'Private data', ''),
        '0029xx55': ('FL', '1', 'Private data', ''),
        '0029xx56': ('US', '1', 'Private data', ''),
        '0029xx60': ('LO', '1', 'Private data', ''),
        '0031xx30': ('UL', '1', 'Private data', ''),
        '0031xx31': ('UL', '1', 'Private data', ''),
        '0031xx32': ('LO', '1', 'Private data', ''),
        '0031xx33': ('UL', '1', 'Private data', ''),
        '0031xx34': ('UL', '1', 'Private data', ''),
        '0031xx35': ('UL', '1', 'Private data', ''),
        '200Dxx01': ('LO', '1', 'Private data', ''),
        '200Dxx02': ('LO', '1', 'Private data', ''),
        '200Dxx03': ('LO', '1', 'Private data', ''),
        '200Dxx04': ('LO', '1', 'Private data', ''),
        '200Dxx05': ('LO', '1', 'Private data', ''),
        '200Dxx06': ('LO', '1', 'Private data', ''),
        '200Dxx07': ('LO', '1', 'Private data', ''),
        '200Dxx08': ('LO', '1', 'Private data', ''),
        '200Dxx09': ('LO', '1', 'Private data', ''),
        '200Dxx0A': ('IS', '1', 'Private data', ''),
        '200Dxx0B': ('OB', '1', 'Private data', ''),
        '200Dxx0C': ('IS', '1', 'Private data', ''),
        '200Dxx0D': ('UL', '1', 'Private data', ''),
        '200Dxx0E': ('IS', '1', 'Private data', ''),
        '200Dxx0F': ('IS', '1', 'Private data', ''),
        '200Dxx10': ('IS', '1', 'Private data', ''),
        '200Dxx11': ('IS', '1', 'Private data', ''),
        '200Dxx12': ('OB', '1', 'Private data', ''),
        '200Dxx13': ('IS', '1', 'Private data', ''),
        '200Dxx14': ('IS', '1', 'Private data', ''),
        '200Dxx15': ('IS', '1', 'Private data', ''),
        '200Dxx1A': ('IS', '1', 'Private data', ''),
        '200Dxx1B': ('IS', '1', 'Private data', ''),
        '200Dxx20': ('SQ', '1', 'Private data', ''),
        '200Dxx27': ('FD', '1', 'Private data', ''),
        '200Dxx28': ('FD', '1', 'Private data', ''),
        '200Dxx30': ('LO', '1', 'Private data', ''),
        '200Dxx31': ('LO', '1', 'Private data', ''),
        '200Dxx32': ('LO', '1', 'Private data', ''),
        '200Dxx33': ('LO', '1', 'Private data', ''),
        '200Dxx34': ('LO', '1', 'Private data', ''),
        '200Dxx35': ('LO', '1', 'Private data', ''),
        '200Dxx36': ('LO', '1', 'Private data', ''),
        '200Dxx37': ('LO', '1', 'Private data', ''),
        '200Dxx38': ('LO', '1', 'Private data', ''),
        '200Dxx39': ('LO', '1', 'Private data', ''),
        '200Dxx3A': ('LO', '1', 'Private data', ''),
        '200Dxx50': ('CS', '1', 'Private data', ''),
        '200Dxx51': ('CS', '1', 'Private data', ''),
        '200Dxx52': ('FD', '1', 'Private data', ''),
        '200Dxx53': ('CS', '1', 'Private data', ''),
        '200Dxx54': ('CS', '1', 'Private data', ''),
        '200Dxx55': ('FD', '1', 'Private data', ''),
        '200Dxx56': ('FD', '1', 'Private data', ''),
        '200Dxx57': ('FD', '1', 'Private data', ''),
        '200Dxx58': ('IS', '1', 'Private data', ''),
        '200Dxx59': ('FD', '1', 'Private data', ''),
        '200Dxx5A': ('FD', '1', 'Private data', ''),
        '200Dxx5D': ('CS', '1', 'Private data', ''),
        '200Dxx5E': ('CS', '1', 'Private data', ''),
        '200DxxFF': ('IS', '1', 'Private data', ''),
        '7777xx01': ('DA', '1', 'Private data', ''),
        '7777xx02': ('CS', '1', 'Private data', ''),
        '7777xx03': ('LO', '1', 'Private data', ''),
        '7777xx10': ('LO', '1', 'Private data', ''),
        '7777xx14': ('LT', '1', 'Private data', ''),
    },
    'FDMS 1.0': {
        '0009xx04': ('SH', '1', 'Image Control Unit', ''),
        '0009xx05': ('OW', '1', 'Image UID', ''),
        '0009xx06': ('OW', '1', 'Route Image UID', ''),
        '0009xx08': ('UL', '1', 'Image Display Information Version No.', ''),
        '0009xx09': ('UL', '1', 'Patient Information Version No.', ''),
        '0009xx0C': ('OW', '1', 'Film UID', ''),
        '0009xx10': ('CS', '1', 'Exposure Unit Type Code', ''),
        '0009xx80': ('LO', '1', 'Kanji Hospital Name', ''),
        '0009xx90': ('ST', '1', 'Distribution Code', ''),
        '0009xx92': ('SH', '1', 'Kanji Department Name', ''),
        '0009xxF0': ('CS', '1', 'Blackening Process Flag', ''),
        '0009xxF1': ('ST', '1', 'Processing Information Flag', ''),
        '0019xx15': ('LO', '1', 'Kanji Body Part for Exposure', ''),
        '0019xx30': ('LO', '1', 'Menu Character String', ''),
        '0019xx32': ('LO', '1', 'Kanji Menu Name', ''),
        '0019xx40': ('CS', '1', 'Image Processing Type', ''),
        '0019xx50': ('CS', '1', 'EDR Mode', ''),
        '0019xx60': ('SH', '1', "Radiographer's Code", ''),
        '0019xx70': ('IS', '1', 'Split Exposure Format', ''),
        '0019xx71': ('IS', '1', 'No. of Split Exposure Frames', ''),
        '0019xx80': ('IS', '1', 'Reading Position Specification', ''),
        '0019xx81': ('IS', '1', 'Reading Sensitivity Center', ''),
        '0019xx90': ('SH', '1', 'Film Annotation Character String 1', ''),
        '0019xx91': ('SH', '1', 'Film Annotation Character String 2', ''),
        '0019xxA0': ('SQ', '1', 'Exposure Status Sequence', ''),
        '0019xxA1': ('CS', '1', 'Exposure Status', ''),
        '0019xxA2': ('CS', '1', 'Exposure Kind', ''),
        '0021xx10': ('CS', '1', 'FCR Image ID', ''),
        '0021xx30': ('CS', '1', 'Set No.', ''),
        '0021xx40': ('IS', '1', 'Image No. in the Set', ''),
        '0021xx50': ('CS', '1', 'Pair Processing Information', ''),
        '0021xx70': ('IS', '1', 'Film Number within the Series', ''),
        '0021xx80': ('OB', '1', 'Equipment Type-Specific Information', ''),
        '0021xx90': ('CS', '1', 'LUT Number', ''),
        '0023xx10': ('SQ', '1', 'Left-image Processing Parameter Sequence', ''),
        '0023xx20': ('SQ', '1', 'Right-image Processing Parameter Sequence', ''),
        '0023xx30': ('SQ', '1', 'Single-image Processing Parameter Sequence', ''),
        '0025xx10': ('US', '1', 'Relative Light Emission Amount Sk', ''),
        '0025xx11': ('US', '1', 'Term of Correction for Each IP Type St', ''),
        '0025xx12': ('US', '1', 'Reading Gain Gp', ''),
        '0025xx13': ('US', '1', 'Latitude', ''),
        '0025xx15': ('CS', '1', 'Image Processing Selection Flag', ''),
        '0025xx16': ('US', '1', 'Min', ''),
        '0025xx17': ('US', '1', 'Max', ''),
        '0025xx20': ('US', '2', 'Sensitivity Shift (S-SHFT)', ''),
        '0025xx21': ('US', '1', 'Contrast Shift (C-SHIFT)', ''),
        '0025xx30': ('US', '1', 'GT', ''),
        '0025xx31': ('SS', '1', 'GA', ''),
        '0025xx32': ('US', '1', 'GC', ''),
        '0025xx33': ('SS', '1', 'GS', ''),
        '0025xx34': ('SS', '1', 'tan θ', ''),
        '0025xx40': ('US', '1', 'RT', ''),
        '0025xx41': ('US', '1', 'RN', ''),
        '0025xx42': ('US', '1', 'RE', ''),
        '0025xx43': ('US', '1', 'N', ''),
        '0025xx50': ('US', '1', 'DRT', ''),
        '0025xx51': ('US', '1', 'DRN', ''),
        '0025xx52': ('US', '1', 'DRE', ''),
        '0025xx53': ('US', '1', 'DN', ''),
        '0025xx60': ('US', '1', 'ORN', ''),
        '0025xx61': ('US', '1', 'ORE', ''),
        '0025xx62': ('US', '1', 'ON', ''),
        '0025xx63': ('CS', '1', 'ORD', ''),
        '0025xx70': ('US', '1', 'MDT', ''),
        '0025xx71': ('US', '1', 'MDB', ''),
        '0025xx72': ('US', '1', 'MDE', ''),
        '0025xx73': ('US', '1-n', 'MFP-DRC Suppression Characteristics Parameters', ''),
        '0025xx74': ('US', '1-n', 'MFP-DRC Frequency Characteristics Parameters', ''),
        '0025xx80': ('US', '1', 'MRT', ''),
        '0025xx81': ('US', '1', 'MRB', ''),
        '0025xx82': ('US', '1', 'MRE', ''),
        '0025xx83': ('US', '1-n', 'MFP-USM Suppression Characteristics Parameters', ''),
        '0025xx84': ('US', '1-n', 'MFP-USM Frequency Characteristics Parameters', ''),
        '0025xx90': ('US', '1', 'PTE (α edge)', ''),
        '0025xx91': ('US', '1', 'PTR (α calc)', ''),
        '0025xx92': ('US', '1', 'PRN', ''),
        '0025xx93': ('US', '1', 'PRE', ''),
        '0025xx94': ('US', '1', 'PEM Sstd', ''),
        '0025xx95': ('US', '1', 'PEM Lstd', ''),
        '0025xx96': ('CS', '1', 'PEM Unsharp Mask Value N', ''),
        '0025xxA0': ('US', '1', 'MFP GT', ''),
        '0025xxA1': ('SS', '1', 'MFP GA', ''),
        '0025xxA2': ('US', '1', 'MFP GC', ''),
        '0025xxA3': ('SS', '1', 'MFP GS', ''),
        '0027xx10': ('SQ', '1', 'γ Raw Data Table Sequence', ''),
        '0027xx20': ('SQ', '1', 'β Raw Data Table Sequence', ''),
        '0027xx30': ('SQ', '1', 'DRC Raw Data Table Sequence', ''),
        '0027xx40': ('SQ', '1', 'MFP-DRC Raw Data Table Sequence', ''),
        '0027xx50': ('SQ', '1', 'MFP-USM Raw Data Table Sequence', ''),
        '0027xx60': ('SQ', '1', 'PEM α Edge Raw Data Table Sequence', ''),
        '0027xx70': ('SQ', '1', 'PEM α Calc Raw Data Table Sequence', ''),
        '0027xx80': ('SQ', '1', 'MFP γ Raw Data Table Sequence', ''),
        '0027xxA0': ('IS', '1', 'No. of Data', ''),
        '0027xxA1': ('CS', '2', 'Data Input Type', ''),
        '0027xxA2': ('CS', '2', 'Data Output Type', ''),
        '0027xxA3': ('US_SS', '1-n', 'Raw Data', ''),
        '0029xx20': ('CS', '1', 'Image Scanning Direction', ''),
        '0029xx25': ('CS', '1', 'Image Rotation/Reversal Information', ''),
        '0029xx30': ('CS', '1', 'Extended Reading Size Value', ''),
        '0029xx34': ('US', '1', 'Mag./Reduc. Ratio', ''),
        '0029xx44': ('CS', '1', 'Line Density Code', ''),
        '0029xx50': ('CS', '1', 'Data Compression Code', ''),
        '0032xx32': ('PN', '1', 'Requesting Physician', ''),
        '0032xx33': ('LO', '1', 'Requesting Service', ''),
        '2011xx00': ('CS', '1', 'Trim Density', ''),
        '2011xx01': ('IS', '1', 'Trim Width', ''),
        '2011xx02': ('CS', '1', 'Image Mag./Reduc. Range', ''),
        '2011xx10': ('CS', '1', 'Image Display Format', ''),
        '2011xx11': ('CS', '1', 'Image Position Specifying Flag', ''),
        '2011xx20': ('OW', '1', 'Interpolation A-VRS System Format', ''),
        '50F1xx06': ('CS', '1', 'Energy Subtraction Param.', ''),
        '50F1xx07': ('CS', '1', 'Subtraction Registration Result', ''),
        '50F1xx08': ('CS', '1', 'Energy Subtraction Param. 2', ''),
        '50F1xx09': ('SL', '1', 'Afin Conversion Coefficient', ''),
        '50F1xx0A': ('SH', '1', 'FNC Parameters', ''),
        '50F1xx10': ('CS', '1', 'Film Output Format', ''),
        '50F1xx20': ('CS', '1', 'Image Processing Modification Flag', ''),
    },
    'FFP DATA': {
        '0009xx01': ('UN', '1', 'CR Header Information', ''),
    },
    'GDCM CONFORMANCE TESTS': {
        '4D4Dxx01': ('SQ', '1', 'Array Container Sequence', ''),
        '4D4Dxx02': ('OB', '1', '0-Filled Array', ''),
    },
    'GE ??? From Adantage Review CS': {
        '0019xx30': ('LO', '1', 'CR EDR Mode', ''),
        '0019xx40': ('LO', '1', 'CR Latitude', ''),
        '0019xx50': ('LO', '1', 'CR Group Number', ''),
        '0019xx70': ('LO', '1', 'CR Image Serial Number', ''),
        '0019xx80': ('LO', '1', 'CR Bar Code Number', ''),
        '0019xx90': ('LO', '1', 'CR Film Output Exposures', ''),
    },
    'GE LUT Asymmetry Parameter': {
        '0045xx67': ('DS', '1', 'LUT Asymmetry', ''),
    },
    'GEHC_CT_ADVAPP_001': {
        '0053xx20': ('IS', '1', 'ShuttleFlag', ''),
        '0053xx21': ('IS', '1', 'TableSpeedNotReachesTargetFlag', ''),
        '0053xx40': ('SH', '1', 'IterativeReconAnnotation', ''),
        '0053xx41': ('SH', '1', 'IterativeReconMode', ''),
        '0053xx42': ('LO', '1', 'IterativeReconConfiguration', ''),
        '0053xx43': ('SH', '1', 'IterativeReconLevel', ''),
        '0053xx60': ('SH', '1', 'reconFlipRotateAnno', ''),
        '0053xx61': ('SH', '1', 'highResolutionFlag', ''),
        '0053xx62': ('SH', '1', 'RespiratoryFlag', ''),
    },
    'GEIIS': {
        '0009xx10': ('SQ', '1', 'GE IIS Thumbnail Sequence', ''),
        '0009xx12': ('IS', '1', 'Unknown', ''),
        '0029xx10': ('UL', '1', 'Shift Count', ''),
        '0029xx12': ('UL', '1', 'Offset', ''),
        '0029xx14': ('UL', '1', 'Actual Frame Number', ''),
        '004Bxx13': ('IS', '1', 'Unknown', ''),
        '004Bxx15': ('LT', '1', 'Unknown', ''),
        '0905xx30': ('LO', '1', 'Assigning Authority For Patient ID', ''),
        '0907xx10': ('UI', '1', 'Original Study Instance UID', ''),
        '0907xx20': ('UI', '1', 'Original Series Instance UID', ''),
        '0907xx30': ('UI', '1', 'Original SOP Instance UID', ''),
        '7FD1xx10': ('UL', '1', 'GE IIS Compression ID', ''),
        '7FD1xx20': ('UL', '1', 'GE IIS Multiframe Offsets', ''),
        '7FD1xx30': ('UL', '1', 'Unknown', ''),
        '7FD1xx40': ('UL', '1-n', 'Unknown', ''),
        '7FD1xx50': ('UL', '1-n', 'Unknown', ''),
        '7FD1xx60': ('UL', '1-n', 'Unknown', ''),
    },
    'GEIIS PACS': {
        '0903xx10': ('US', '1', 'Reject Image Flag', ''),
        '0903xx11': ('US', '1', 'Significant Flag', ''),
        '0903xx12': ('US', '1', 'Confidential Flag', ''),
        '0903xx20': ('CS', '1', 'Unknown', ''),
        '0907xx21': ('US', '1', 'GEIIS_PREFETCH_ALGORITHM', ''),
        '0907xx22': ('US', '1', 'GEIIS_LIMIT_RECENT_STUDIES', ''),
        '0907xx23': ('US', '1', 'GEIIS_LIMIT_OLDEST_STUDIES', ''),
        '0907xx24': ('US', '1', 'GEIIS_LIMIT_RECENT_MONTHS', ''),
        '0907xx31': ('UI', '1-n', 'GEIIS_EXCLUDE_STUDY_UIDS', ''),
    },
    'GEMS-IT/Centricity RA600/7.0': {
        '4113xx10': ('UI', '1', 'Number of images in study', ''),
    },
    'GEMS_0039': {
        '0039xx95': ('LO', '1', 'Unknown', ''),
    },
    'GEMS_3DSTATE_001': {
        '0047xxD6': ('ST', '1', 'General Description', ''),
        '0047xxD7': ('CS', '1', 'TDRT', ''),
        '0047xxD8': ('US', '1', 'NVRP', ''),
        '0047xxD9': ('US', '1', 'CVRPN', ''),
        '0047xxDA': ('SQ', '1', 'Volume Rendering Presets Sequence', ''),
        '0047xxDB': ('LO', '1', 'Preset Name', ''),
        '0047xxDC': ('SS', '1-n', 'Opacity Curve X', ''),
        '0047xxDD': ('FL', '1-n', 'Opacity Curve Y', ''),
        '0047xxDE': ('US', '1', 'NOCP', ''),
        '0047xxDF': ('SS', '1-n', 'Color Curve X', ''),
        '0047xxE1': ('US', '1', 'NCCP', ''),
        '0047xxE2': ('CS', '1', 'GSA', ''),
        '0047xxE3': ('CS', '1', 'VRSF', ''),
        '0047xxE4': ('FL', '1', 'AF', ''),
        '0047xxE5': ('FL', '1', 'DF', ''),
        '0047xxE6': ('FL', '1', 'SCF', ''),
        '0047xxE7': ('FL', '1', 'SPF', ''),
        '0047xxE8': ('FL', '24', 'Orthogonal Clipping Planes', ''),
        '0047xxE9': ('FL', '3', 'CP', ''),
        '0047xxEA': ('DS', '3', 'CFP', ''),
        '0047xxEB': ('DS', '3', 'CVU', ''),
        '0047xxEC': ('FL', '1', 'RFOV', ''),
        '0047xxED': ('CS', '1', 'PPRP', ''),
        '0047xxEE': ('DS', '1', '3DWW', ''),
        '0047xxEF': ('DS', '1', '3DWL', ''),
        '0047xxF0': ('CS', '1', 'BBV', ''),
        '0047xxF1': ('CS', '1', 'ERF', ''),
        '0047xxF2': ('US', '1', 'TDRMS', ''),
        '0047xxF3': ('FL', '1', 'TDSSS', ''),
    },
    'GEMS_ACQU_01': {
        '0009xx24': ('DS', '1', 'Unknown', ''),
        '0009xx25': ('US', '1', 'Unknown', ''),
        '0009xx3E': ('US', '1', 'Unknown', ''),
        '0009xx3F': ('US', '1', 'Unknown', ''),
        '0009xx42': ('US', '1', 'Unknown', ''),
        '0009xx43': ('US', '1', 'Unknown', ''),
        '0009xxF8': ('US', '1', 'Unknown', ''),
        '0009xxFB': ('IS', '1', 'Unknown', ''),
        '001910xx': ('LO', '1', 'Private Element Creator', ''),
        '0019xx01': ('LT', '1', 'Unknown', ''),
        '0019xx02': ('SL', '1', 'Detector Channel', ''),
        '0019xx03': ('DS', '1', 'Cell number at Theta', ''),
        '0019xx04': ('DS', '1', 'Cell spacing', ''),
        '0019xx05': ('LT', '1', 'Unknown', ''),
        '0019xx06': ('UN', '1', 'Unknown', ''),
        '0019xx0E': ('US', '1', 'Unknown', ''),
        '0019xx0F': ('DS', '1', 'Horiz. Frame of ref.', ''),
        '0019xx11': ('SS', '1', 'Series contrast', ''),
        '0019xx12': ('SS', '1', 'Last pseq', ''),
        '0019xx13': ('SS', '1', 'Start number for baseline', ''),
        '0019xx14': ('SS', '1', 'End number for baseline', ''),
        '0019xx15': ('SS', '1', 'Start number for enhanced scans', ''),
        '0019xx16': ('SS', '1', 'End number for enhanced scans', ''),
        '0019xx17': ('SS', '1', 'Series plane', ''),
        '0019xx18': ('LO', '1', 'First scan ras', ''),
        '0019xx19': ('DS', '1', 'First scan location', ''),
        '0019xx1A': ('LO', '1', 'Last scan ras', ''),
        '0019xx1B': ('DS', '1', 'Last scan loc', ''),
        '0019xx1E': ('DS', '1', 'Display field of view', ''),
        '0019xx20': ('DS', '1', 'Unknown', ''),
        '0019xx22': ('DS', '1', 'Unknown', ''),
        '0019xx23': ('DS', '1', 'Table Speed [mm/rotation]', ''),
        '0019xx24': ('DS', '1', 'Mid Scan Time [sec]', ''),
        '0019xx25': ('SS', '1', 'Mid scan flag', ''),
        '0019xx26': ('SL', '1', 'Tube Azimuth [degree]', ''),
        '0019xx27': ('DS', '1', 'Rotation Speed [msec]', ''),
        '0019xx2A': ('DS', '1', 'x-ray On position', ''),
        '0019xx2B': ('DS', '1', 'x-ray Off position', ''),
        '0019xx2C': ('SL', '1', 'Number of triggers', ''),
        '0019xx2D': ('US', '1', 'Unknown', ''),
        '0019xx2E': ('DS', '1', 'Angle of first view', ''),
        '0019xx2F': ('DS', '1', 'Trigger frequency', ''),
        '0019xx39': ('SS', '1', 'SFOV Type', ''),
        '0019xx3A': ('IS', '1', 'Unknown', ''),
        '0019xx3B': ('LT', '1', 'Unknown', ''),
        '0019xx3C': ('UN', '1', 'Unknown', ''),
        '0019xx3E': ('UN', '1', 'Unknown', ''),
        '0019xx3F': ('UN', '1', 'Unknown', ''),
        '0019xx40': ('SS', '1', 'Stat recon flag', ''),
        '0019xx41': ('SS', '1', 'Compute type', ''),
        '0019xx42': ('SS', '1', 'Segment Number', ''),
        '0019xx43': ('SS', '1', 'Total Segments Required', ''),
        '0019xx44': ('DS', '1', 'Interscan delay', ''),
        '0019xx47': ('SS', '1', 'View compression factor', ''),
        '0019xx48': ('US', '1', 'Unknown', ''),
        '0019xx49': ('US', '1', 'Unknown', ''),
        '0019xx4A': ('SS', '1', 'Total no. of ref channels', ''),
        '0019xx4B': ('SL', '1', 'Data size for scan data', ''),
        '0019xx52': ('SS', '1', 'Recon post proc. Flag', ''),
        '0019xx54': ('UN', '1', 'Unknown', ''),
        '0019xx57': ('SS', '1', 'CT water number', ''),
        '0019xx58': ('SS', '1', 'CT bone number', ''),
        '0019xx5A': ('FL', '1', 'Acquisition Duration', ''),
        '0019xx5D': ('US', '1', 'Unknown', ''),
        '0019xx5E': ('SL', '1', 'Number of channels (1...512)', ''),
        '0019xx5F': ('SL', '1', 'Increment between channels', ''),
        '0019xx60': ('SL', '1', 'Starting view', ''),
        '0019xx61': ('SL', '1', 'Number of views', ''),
        '0019xx62': ('SL', '1', 'Increment between views', ''),
        '0019xx6A': ('SS', '1', 'Dependent on #views processed', ''),
        '0019xx6B': ('SS', '1', 'Field of view in detector cells', ''),
        '0019xx70': ('SS', '1', 'Value of back projection button', ''),
        '0019xx71': ('SS', '1', 'Set if fatq estimates were used', ''),
        '0019xx72': ('DS', '1', 'Z chan avg over views', ''),
        '0019xx73': ('DS', '1', 'Avg of left ref chans over views', ''),
        '0019xx74': ('DS', '1', 'Max left chan over views', ''),
        '0019xx75': ('DS', '1', 'Avg of right ref chans over views', ''),
        '0019xx76': ('DS', '1', 'Max right chan over views', ''),
        '0019xx7D': ('DS', '1', 'Second echo', ''),
        '0019xx7E': ('SS', '1', 'Number of echoes', ''),
        '0019xx7F': ('DS', '1', 'Table delta', ''),
        '0019xx81': ('SS', '1', 'Contiguous', ''),
        '0019xx82': ('US', '1', 'Unknown', ''),
        '0019xx83': ('DS', '1', 'Unknown', ''),
        '0019xx84': ('DS', '1', 'Peak SAR', ''),
        '0019xx85': ('SS', '1', 'Monitor SAR', ''),
        '0019xx86': ('US', '1', 'Unknown', ''),
        '0019xx87': ('DS', '1', 'Cardiac repetition time', ''),
        '0019xx88': ('SS', '1', 'Images per cardiac cycle', ''),
        '0019xx8A': ('SS', '1', 'Actual receive gain analog', ''),
        '0019xx8B': ('SS', '1', 'Actual receive gain digital', ''),
        '0019xx8D': ('DS', '1', 'Delay after trigger', ''),
        '0019xx8F': ('SS', '1', 'Swappf', ''),
        '0019xx90': ('SS', '1', 'Pause Interval', ''),
        '0019xx91': ('DS', '1', 'Pause Time', ''),
        '0019xx92': ('SL', '1', 'Slice offset on freq axis', ''),
        '0019xx93': ('DS', '1', 'Auto Prescan Center Frequency', ''),
        '0019xx94': ('SS', '1', 'Auto Prescan Transmit Gain', ''),
        '0019xx95': ('SS', '1', 'Auto Prescan Analog receiver gain', ''),
        '0019xx96': ('SS', '1', 'Auto Prescan Digital receiver gain', ''),
        '0019xx97': ('SL', '1', 'Bitmap defining CVs', ''),
        '0019xx98': ('SS', '1', 'Center freq. Method', ''),
        '0019xx99': ('US', '1', 'Unknown', ''),
        '0019xx9B': ('SS', '1', 'Pulse Sequence Mode', ''),
        '0019xx9C': ('LO', '1', 'Pulse Sequence Name', ''),
        '0019xx9D': ('DT', '1', 'Pulse Sequence Date', ''),
        '0019xx9E': ('LO', '1', 'Internal Pulse Sequence Name', ''),
        '0019xx9F': ('SS', '1', 'Transmitting Coil Type', ''),
        '0019xxA0': ('SS', '1', 'Surface Coil Type', ''),
        '0019xxA1': ('SS', '1', 'Extremity Coil flag', ''),
        '0019xxA2': ('SL', '1', 'Raw data run number', ''),
        '0019xxA3': ('UL', '1', 'Calibrated Field strength', ''),
        '0019xxA4': ('SS', '1', 'SAT fat/water/bone', ''),
        '0019xxA5': ('DS', '1', 'Receive bandwidth', ''),
        '0019xxA7': ('DS', '1', 'User data 0', ''),
        '0019xxA8': ('DS', '1', 'User data 1', ''),
        '0019xxA9': ('DS', '1', 'User data 2', ''),
        '0019xxAA': ('DS', '1', 'User data 3', ''),
        '0019xxAB': ('DS', '1', 'User data 4', ''),
        '0019xxAC': ('DS', '1', 'User data 5', ''),
        '0019xxAD': ('DS', '1', 'User data 6', ''),
        '0019xxAE': ('DS', '1', 'User data 7', ''),
        '0019xxAF': ('DS', '1', 'User data 8', ''),
        '0019xxB0': ('DS', '1', 'User data 9', ''),
        '0019xxB1': ('DS', '1', 'User data 10', ''),
        '0019xxB2': ('DS', '1', 'User data 11', ''),
        '0019xxB3': ('DS', '1', 'User data 12', ''),
        '0019xxB4': ('DS', '1', 'User data 13', ''),
        '0019xxB5': ('DS', '1', 'User data 14', ''),
        '0019xxB6': ('DS', '1', 'User data 15', ''),
        '0019xxB7': ('DS', '1', 'User data 16', ''),
        '0019xxB8': ('DS', '1', 'User data 17', ''),
        '0019xxB9': ('DS', '1', 'User data 18', ''),
        '0019xxBA': ('DS', '1', 'User data 19', ''),
        '0019xxBB': ('DS', '1', 'User data 20', ''),
        '0019xxBC': ('DS', '1', 'User data 21', ''),
        '0019xxBD': ('DS', '1', 'User data 22', ''),
        '0019xxBE': ('DS', '1', 'Projection angle', ''),
        '0019xxC0': ('SS', '1', 'Saturation planes', ''),
        '0019xxC1': ('SS', '1', 'Surface coil intensity', ''),
        '0019xxC2': ('SS', '1', 'SAT location R', ''),
        '0019xxC3': ('SS', '1', 'SAT location L', ''),
        '0019xxC4': ('SS', '1', 'SAT location A', ''),
        '0019xxC5': ('SS', '1', 'SAT location P', ''),
        '0019xxC6': ('SS', '1', 'SAT location H', ''),
        '0019xxC7': ('SS', '1', 'SAT location F', ''),
        '0019xxC8': ('SS', '1', 'SAT thickness R/L', ''),
        '0019xxC9': ('SS', '1', 'SAT thickness A/P', ''),
        '0019xxCA': ('SS', '1', 'SAT thickness H/F', ''),
        '0019xxCB': ('SS', '1', 'Phase Contrast flow axis', ''),
        '0019xxCC': ('SS', '1', 'Velocity encoding', ''),
        '0019xxCD': ('SS', '1', 'Thickness disclaimer', ''),
        '0019xxCE': ('SS', '1', 'Prescan type', ''),
        '0019xxCF': ('SS', '1', 'Prescan status', ''),
        '0019xxD0': ('SH', '1', 'Raw data type', ''),
        '0019xxD2': ('SS', '1', 'Projection Algorithm', ''),
        '0019xxD3': ('SH', '1', 'Projection Algorithm Name', ''),
        '0019xxD4': ('US', '1', 'Unknown', ''),
        '0019xxD5': ('SS', '1', 'Fractional echo', ''),
        '0019xxD6': ('SS', '1', 'Prep pulse', ''),
        '0019xxD7': ('SS', '1', 'Cardiac phase number', ''),
        '0019xxD8': ('SS', '1', 'Variable echoflag', ''),
        '0019xxD9': ('DS', '1', 'Concatenated SAT {# DTI Diffusion Dir., release 9.0 & below}', ''),
        '0019xxDA': ('SS', '1', 'Reference channel used', ''),
        '0019xxDB': ('DS', '1', 'Back projector coefficient', ''),
        '0019xxDC': ('SS', '1', 'Primary speed correction used', ''),
        '0019xxDD': ('SS', '1', 'Overrange correction used', ''),
        '0019xxDE': ('DS', '1', 'Dynamic Z alpha value', ''),
        '0019xxDF': ('DS', '1', 'User data 23 {# DTI Diffusion Dir., release 9.0 & below}', ''),
        '0019xxE0': ('DS', '1', 'User data 24 {# DTI Diffusion Dir., release 10.0 & above}', ''),
        '0019xxE1': ('DS', '1', 'Unknown', ''),
        '0019xxE2': ('DS', '1', 'Velocity Encode Scale', ''),
        '0019xxE3': ('LT', '1', 'Unknown', ''),
        '0019xxE4': ('LT', '1', 'Unknown', ''),
        '0019xxE5': ('IS', '1', 'Unknown', ''),
        '0019xxE6': ('US', '1', 'Unknown', ''),
        '0019xxE8': ('DS', '1', 'Unknown', ''),
        '0019xxE9': ('DS', '1', 'Unknown', ''),
        '0019xxEB': ('DS', '1', 'Unknown', ''),
        '0019xxEC': ('US', '1', 'Unknown', ''),
        '0019xxF0': ('UN', '1', 'Unknown', ''),
        '0019xxF1': ('LT', '1', 'Unknown', ''),
        '0019xxF2': ('SS', '1', 'Fast phases', ''),
        '0019xxF3': ('LT', '1', 'Unknown', ''),
        '0019xxF4': ('LT', '1', 'Unknown', ''),
        '0019xxF9': ('DS', '1', 'Transmit gain', ''),
    },
    'GEMS_ACRQA_1.0 BLOCK1': {
        '0023xx00': ('LO', '1', 'CR Exposure Menu Code', ''),
        '0023xx10': ('LO', '1', 'CR Exposure Menu String', ''),
        '0023xx20': ('LO', '1', 'CR EDR Mode', ''),
        '0023xx30': ('LO', '1', 'CR Latitude', ''),
        '0023xx40': ('LO', '1', 'CR Group Number', ''),
        '0023xx50': ('US', '1', 'CR Image Serial Number', ''),
        '0023xx60': ('LO', '1', 'CR Bar Code Number', ''),
        '0023xx70': ('LO', '1', 'CR Film Output Exposure', ''),
        '0023xx80': ('LO', '1', 'CR Film Format', ''),
        '0023xx90': ('LO', '1', 'CR S-Shift String', ''),
    },
    'GEMS_ACRQA_1.0 BLOCK2': {
        '0023xx00': ('US', '1', 'CR S-Shift', ''),
        '0023xx10': ('DS', '1', 'CR C-Shift', ''),
        '0023xx20': ('DS', '1', 'CR GT', ''),
        '0023xx30': ('DS', '1', 'CR GA', ''),
        '0023xx40': ('DS', '1', 'CR GC', ''),
        '0023xx50': ('DS', '1', 'CR GS', ''),
        '0023xx60': ('DS', '1', 'CR RT', ''),
        '0023xx70': ('DS', '1', 'CR RE', ''),
        '0023xx80': ('US', '1', 'CR RN', ''),
        '0023xx90': ('DS', '1', 'CR DRT', ''),
    },
    'GEMS_ACRQA_1.0 BLOCK3': {
        '0023xx00': ('DS', '1', 'CR DRE', ''),
        '0023xx10': ('US', '1', 'CR DRN', ''),
        '0023xx20': ('DS', '1', 'CR ORE', ''),
        '0023xx30': ('US', '1', 'CR ORN', ''),
        '0023xx40': ('US', '1', 'CR ORD', ''),
        '0023xx50': ('LO', '1', 'CR Cassette Size', ''),
        '0023xx60': ('LO', '1', 'CR Machine ID', ''),
        '0023xx70': ('LO', '1', 'CR Machine Type', ''),
        '0023xx80': ('LO', '1', 'CR Technician Code', ''),
        '0023xx90': ('LO', '1', 'CR ES Parameters', ''),
    },
    'GEMS_ACRQA_2.0 BLOCK1': {
        '0023xx00': ('LO', '1', 'CR Exposure Menu Code', ''),
        '0023xx10': ('LO', '1', 'CR Exposure Menu String', ''),
        '0023xx20': ('LO', '1', 'CR EDR Mode', ''),
        '0023xx30': ('LO', '1', 'CR Latitude', ''),
        '0023xx40': ('LO', '1', 'CR Group Number', ''),
        '0023xx50': ('US', '1', 'CR Image Serial Number', ''),
        '0023xx60': ('LO', '1', 'CR Bar Code Number', ''),
        '0023xx70': ('LO', '1', 'CR Film Output Exposure', ''),
        '0023xx80': ('LO', '1', 'CR Film Format', ''),
        '0023xx90': ('LO', '1', 'CR S Shift String', ''),
    },
    'GEMS_ACRQA_2.0 BLOCK2': {
        '0023xx00': ('US', '1', 'CR S Shift', ''),
        '0023xx10': ('LO', '1', 'CR C Shift', ''),
        '0023xx20': ('LO', '1', 'CR GT', ''),
        '0023xx30': ('DS', '1', 'CR GA', ''),
        '0023xx40': ('DS', '1', 'CR GC', ''),
        '0023xx50': ('DS', '1', 'CR GS', ''),
        '0023xx60': ('LO', '1', 'CR RT', ''),
        '0023xx70': ('DS', '1', 'CR RE', ''),
        '0023xx80': ('US', '1', 'CR RN', ''),
        '0023xx90': ('DS', '1', 'CR DRT', ''),
    },
    'GEMS_ACRQA_2.0 BLOCK3': {
        '0023xx00': ('DS', '1', 'CR DRE', ''),
        '0023xx10': ('US', '1', 'CR DRN', ''),
        '0023xx20': ('DS', '1', 'CR ORE', ''),
        '0023xx30': ('US', '1', 'CR ORN', ''),
        '0023xx40': ('US', '1', 'CR ORD', ''),
        '0023xx50': ('LO', '1', 'CR Cassette Size', ''),
        '0023xx60': ('LO', '1', 'CR Machine ID', ''),
        '0023xx70': ('LO', '1', 'CR Machine Type', ''),
        '0023xx80': ('LO', '1', 'CR Technician Code', ''),
        '0023xx90': ('LO', '1', 'CR Energy Subtraction Parameters', ''),
        '0023xxF0': ('LO', '1', 'CR Distribution Code', ''),
        '0023xxFF': ('US', '1', 'CR Shutters Applied', ''),
    },
    'GEMS_ADWSoft_3D1': {
        '0047xx01': ('SQ', '1', 'Reconstruction Parameters Sequence', ''),
        '0047xx49': ('UL', '3-n', 'Volume Color', ''),
        '0047xx50': ('UL', '1', 'Volume Voxel Count', ''),
        '0047xx51': ('UL', '1-n', 'Volume Segment Count', ''),
        '0047xx53': ('US', '1', 'Volume Slice Size', ''),
        '0047xx54': ('US', '1', 'Volume Slice Count', ''),
        '0047xx55': ('SL', '1', 'Volume Threshold Value', ''),
        '0047xx57': ('DS', '1', 'Volume Voxel Ratio', ''),
        '0047xx58': ('DS', '1', 'Volume Voxel Size', ''),
        '0047xx59': ('US', '1', 'Volume Z Position Size', ''),
        '0047xx60': ('DS', '9', 'Volume Base Line', ''),
        '0047xx61': ('DS', '3', 'Volume Center Point', ''),
        '0047xx63': ('SL', '1', 'Volume Skew Base', ''),
        '0047xx64': ('DS', '9', 'Volume Registration Transform Rotation Matrix', ''),
        '0047xx65': ('DS', '3', 'Volume Registration Transform Translation Vector', ''),
        '0047xx66': ('DS', '1', 'Volume Tilt', ''),
        '0047xx70': ('DS', '1-n', 'KPV List', ''),
        '0047xx71': ('IS', '1-n', 'X-Ray Tube Current List', ''),
        '0047xx72': ('IS', '1-n', 'Exposure List', ''),
        '0047xx80': ('LO', '1', 'Acquisition DLX Identifier', ''),
        '0047xx81': ('IS', '1', 'Acquisition DLX 2D Series Count', ''),
        '0047xx85': ('SQ', '1', 'Acquisition DLX 2D Series Sequence', ''),
        '0047xx89': ('DS', '1-n', 'Contrast Agent Volume List', ''),
        '0047xx8A': ('US', '1', 'Number Of Injections', ''),
        '0047xx8B': ('US', '1', 'Frame Count', ''),
        '0047xx91': ('LO', '1', 'XA 3D Reconstruction Algorithm Name', ''),
        '0047xx92': ('CS', '1', 'XA 3D Reconstruction Algorithm Version', ''),
        '0047xx93': ('DA', '1', 'DLX Calibration Date', ''),
        '0047xx94': ('TM', '1', 'DLX Calibration Time', ''),
        '0047xx95': ('CS', '1', 'DLX Calibration Status', ''),
        '0047xx96': ('IS', '1-n', 'Used Frames', ''),
        '0047xx98': ('US', '1', 'Transform Count', ''),
        '0047xx99': ('SQ', '1', 'Transform Sequence', ''),
        '0047xx9A': ('DS', '9', 'Transform Rotation Matrix', ''),
        '0047xx9B': ('DS', '3', 'Transform Translation Vector', ''),
        '0047xx9C': ('LO', '1', 'Transform Label', ''),
        '0047xxB0': ('SQ', '1', 'Wireframe List', ''),
        '0047xxB1': ('US', '1', 'Wireframe Count', ''),
        '0047xxB2': ('US', '1', 'Location System', ''),
        '0047xxB5': ('LO', '1', 'Wireframe Name', ''),
        '0047xxB6': ('LO', '1', 'Wireframe Group Name', ''),
        '0047xxB7': ('LO', '1', 'Wireframe Color', ''),
        '0047xxB8': ('SL', '1', 'Wireframe Attributes', ''),
        '0047xxB9': ('SL', '1', 'Wireframe Point Count', ''),
        '0047xxBA': ('SL', '1', 'Wireframe Timestamp', ''),
        '0047xxBB': ('SQ', '1', 'Wireframe Point List', ''),
        '0047xxBC': ('DS', '3', 'Wireframe Points Coordinates', ''),
        '0047xxC0': ('DS', '3', 'Volume Upper Left High Corner RAS', ''),
        '0047xxC1': ('DS', '9', 'Volume Slice To RAS Rotation Matrix', ''),
        '0047xxC2': ('DS', '1', 'Volume Upper Left High Corner TLOC', ''),
        '0047xxD1': ('OB', '1', 'Volume Segment List', ''),
        '0047xxD2': ('OB', '1', 'Volume Gradient List', ''),
        '0047xxD3': ('OB', '1', 'Volume Density List', ''),
        '0047xxD4': ('OB', '1', 'Volume Z Position List', ''),
        '0047xxD5': ('OB', '1', 'Volume Original Index List', ''),
        '0047xxF4': ('LO', '1-n', 'Volume Name(s)', ''),
        '0047xxF5': ('DS', '1-n', 'Min original density', ''),
        '0047xxF6': ('DS', '1-n', 'Max original density', ''),
        '0047xxF7': ('DS', '1-n', 'Min Converted Density', ''),
        '0047xxF8': ('DS', '1-n', 'Max Converted Density', ''),
        '0047xxF9': ('LO', '1', 'Protocol Film Name', ''),
        '0047xxFA': ('US', '1', 'Protocol Resolution', ''),
        '0047xxFB': ('US', '1', 'Phase Number (percent)', ''),
        '0047xxFC': ('OB', '1', 'Volume midscan times list', ''),
        '0047xxFD': ('OB', '1', 'Volume Registered Phases List', ''),
        '0047xxFE': ('LO', '1', 'Protocol Name', ''),
        '0047xxFF': ('LO', '1', 'Protocol Title', ''),
    },
    'GEMS_ADWSoft_3D2': {
        '0057xx01': ('OB', '1', 'Cardiac Reconstruction Algorithm List', ''),
        '0057xx02': ('OB', '1', 'Average Heart Rate for Image List', ''),
        '0057xx03': ('OB', '1', 'Temporal Resolution List', ''),
        '0057xx04': ('LT', '1', 'Layout View Preset', ''),
    },
    'GEMS_ADWSoft_DPO': {
        '0039xx80': ('IS', '1', 'Private Entity Number', ''),
        '0039xx85': ('DA', '1', 'Private Entity Date', ''),
        '0039xx90': ('TM', '1', 'Private Entity Time', ''),
        '0039xx95': ('LO', '1', 'Private Entity Launch Command', ''),
        '0039xxAA': ('CS', '1', 'Private Entity Type', ''),
    },
    'GEMS_ADWSoft_DPO1': {
        '0039xx80': ('IS', '1', 'Private Entity Number', ''),
        '0039xx85': ('DA', '1', 'Private Entity Date', ''),
        '0039xx90': ('TM', '1', 'Private Entity Time', ''),
        '0039xx95': ('LO', '1', 'Private Entity Launch Command', ''),
        '0039xxAA': ('CS', '1', 'Private Entity Type', ''),
    },
    'GEMS_AWSOFT_CD1': {
        '0039xx65': ('UI', '1', 'Reference to Study UID', ''),
        '0039xx70': ('UI', '1', 'Reference to Series UID', ''),
        '0039xx75': ('IS', '1', 'Reference to Original Instance', ''),
        '0039xx80': ('IS', '1', 'DPO Number', ''),
        '0039xx85': ('DA', '1', 'DPO Date', ''),
        '0039xx90': ('TM', '1', 'DPO Time', ''),
        '0039xx95': ('LO', '1', 'DPO Invocation String', ''),
        '0039xxAA': ('CS', '1', 'DPO type', ''),
        '0039xxFF': ('OB', '1', 'DPO data', ''),
    },
    'GEMS_AWSoft_SB1': {
        '0039xx50': ('UI', '1', 'Reference to Study UID', ''),
        '0039xx51': ('UI', '1', 'Reference to Series UID', ''),
        '0039xx52': ('IS', '1', 'Reference to Original Instance Number', ''),
        '0039xx95': ('LO', '1', 'Private Entity Launch Command', ''),
    },
    'GEMS_CTHD_01': {
        '0033xx02': ('UN', '1', 'Unknown', ''),
    },
    'GEMS_CT_CARDIAC_001': {
        '0049xx01': ('SQ', '1', 'CT Cardiac Sequence', ''),
        '0049xx02': ('CS', '1', 'HeartRateAtConfirm', ''),
        '0049xx03': ('FL', '1', 'AvgHeartRatePriorToConfirm', ''),
        '0049xx04': ('CS', '1', 'MinHeartRatePriorToConfirm', ''),
        '0049xx05': ('CS', '1', 'MaxHeartRatePriorToConfirm', ''),
        '0049xx06': ('FL', '1', 'StdDevHeartRatePriorToConfirm', ''),
        '0049xx07': ('US', '1', 'NumHeartRateSamplesPriorToConfirm', ''),
        '0049xx08': ('CS', '1', 'AutoHeartRateDetectPredict', ''),
        '0049xx09': ('CS', '1', 'SystemOptimizedHeartRate', ''),
        '0049xx0A': ('ST', '1', 'EkgMonitorType', ''),
        '0049xx0B': ('CS', '1', 'NumReconSectors', ''),
        '0049xx0C': ('FL', '256', 'RpeakTimeStamps', ''),
    },
    'GEMS_CT_HINO_01': {
        '004Bxx01': ('DS', '1-n', 'Beam Thickess', ''),
        '004Bxx02': ('DS', '1-n', 'R Time', ''),
        '004Bxx03': ('IS', '1', 'HBC Number', ''),
    },
    'GEMS_CT_VES_01': {
        '0051xx01': ('SQ', '1', 'CTVESSequence', ''),
    },
    'GEMS_DLX_DOSE_01': {
        '0027xx01': ('SQ', '1', 'Private Radiation Dose Sequence', ''),
        '0027xx02': ('IS', '1', 'Run Number', ''),
        '0027xx03': ('TM', '1', 'Run Time', ''),
        '0027xx04': ('IS', '1', 'Number of Frames', ''),
        '0027xx05': ('DS', '1', 'Frames per Second', ''),
        '0027xx06': ('CS', '1', 'Plane', ''),
        '0027xx07': ('DS', '1', 'KV', ''),
        '0027xx08': ('DS', '1', 'MA', ''),
        '0027xx09': ('DS', '1', 'Mas', ''),
        '0027xx10': ('DS', '1', 'Ms', ''),
        '0027xx11': ('DS', '1', 'Angulation', ''),
        '0027xx12': ('DS', '1', 'Rotation', ''),
        '0027xx13': ('DS', '1', 'Focal Distance', ''),
        '0027xx14': ('DS', '1', 'Image Intensifier Mode', ''),
    },
    'GEMS_DL_FRAME_01': {
        '0025xx02': ('IS', '1', 'Frame Id', ''),
        '0025xx03': ('DS', '1', 'Distance Source To Detector', ''),
        '0025xx04': ('DS', '1', 'Distance Source To Patient', ''),
        '0025xx05': ('DS', '1', 'Distance Source To Skin', ''),
        '0025xx06': ('DS', '1', 'Positioner Primary Angle', ''),
        '0025xx07': ('DS', '1', 'Positioner Secondary Angle', ''),
        '0025xx08': ('IS', '1', 'Beam Orientation', ''),
        '0025xx09': ('DS', '1', 'Larm Angle', ''),
        '0025xx0A': ('SQ', '1', 'Frame Sequence', ''),
        '0025xx0B': ('DS', '1', 'Target Cnr', ''),
        '0025xx10': ('DS', '1', 'Pivot Angle', ''),
        '0025xx1A': ('DS', '1', 'Arc Angle', ''),
        '0025xx1B': ('DS', '1', 'Table Vertical Position', ''),
        '0025xx1C': ('DS', '1', 'Table Longitudinal Position', ''),
        '0025xx1D': ('DS', '1', 'Table Lateral Position', ''),
        '0025xx1E': ('IS', '1', 'Beam Cover Area', ''),
        '0025xx1F': ('DS', '1', 'Kvp Actual', ''),
        '0025xx20': ('DS', '1', 'Mas Actual', ''),
        '0025xx21': ('DS', '1', 'Pw Actual', ''),
        '0025xx22': ('DS', '1', 'Kvp Commanded', ''),
        '0025xx23': ('DS', '1', 'Mas Commanded', ''),
        '0025xx24': ('DS', '1', 'Pw Commanded', ''),
        '0025xx25': ('CS', '1', 'Grid', ''),
        '0025xx26': ('DS', '1', 'Sensor Feedback', ''),
        '0025xx27': ('DS', '1', 'Target Entrance Dose', ''),
        '0025xx28': ('DS', '1', 'Cnr Commanded', ''),
        '0025xx29': ('DS', '1', 'Contrast Commanded', ''),
        '0025xx2A': ('DS', '1', 'Ept Actual', ''),
        '0025xx2B': ('IS', '1', 'Spectral Filter Znb', ''),
        '0025xx2C': ('DS', '1', 'Spectral Filter Weight', ''),
        '0025xx2D': ('DS', '1', 'Spectral Filter Density', ''),
        '0025xx2E': ('IS', '1', 'Spectral Filter Thickness', ''),
        '0025xx2F': ('IS', '1', 'Spectral Filter Status', ''),
        '0025xx30': ('IS', '1', 'Fov Dimension', ''),
        '0025xx33': ('IS', '1', 'Fov Origin', ''),
        '0025xx34': ('IS', '1', 'Collimator Left Vertical Edge', ''),
        '0025xx35': ('IS', '1', 'Collimator Right Vertical Edge', ''),
        '0025xx36': ('IS', '1', 'Collimator Up Horizontal Edge', ''),
        '0025xx37': ('IS', '1', 'Collimator Low Horizontal Edge', ''),
        '0025xx38': ('IS', '1', 'Vertices Polygonal Collimator', ''),
        '0025xx39': ('IS', '1', 'Contour Filter Distance', ''),
        '0025xx3A': ('UL', '1', 'Contour Filter Angle', ''),
        '0025xx3B': ('CS', '1', 'Table Rotation Status', ''),
        '0025xx3C': ('CS', '1', 'Internal Label Frame', ''),
    },
    'GEMS_DL_IMG_01': {
        '0019xx0B': ('DS', '1', 'Fov Dimension Double', ''),
        '0019xx0C': ('FL', '2-2n', 'LV Diastolic contour', ''),
        '0019xx0D': ('FL', '2-2n', 'LV Systolic contour', ''),
        '0019xx2B': ('FL', '1', 'Distance to table top', ''),
        '0019xx30': ('LO', '1', 'Image File Name', ''),
        '0019xx31': ('IS', '1', 'Default Spatial Filter Family', ''),
        '0019xx32': ('IS', '1', 'Default Spatial Filter Strength', ''),
        '0019xx33': ('DS', '1', 'Min Saturation Dose', ''),
        '0019xx34': ('DS', '1', 'Detector Gain', ''),
        '0019xx35': ('DS', '1', 'Patient Dose Limit', ''),
        '0019xx36': ('DS', '1', 'Preproc Image Rate Max', ''),
        '0019xx37': ('CS', '1', 'Sensor Roi Shape', ''),
        '0019xx38': ('DS', '1', 'Sensor Roi x Position', ''),
        '0019xx39': ('DS', '1', 'Sensor Roi y Position', ''),
        '0019xx3A': ('DS', '1', 'Sensor Roi x Size', ''),
        '0019xx3B': ('DS', '1', 'Sensor Roi y Size', ''),
        '0019xx3D': ('DS', '1', 'Noise Sensitivity', ''),
        '0019xx3E': ('DS', '1', 'Sharp Sensitivity', ''),
        '0019xx3F': ('DS', '1', 'Contrast Sensitivity', ''),
        '0019xx40': ('DS', '1', 'Lag Sensitivity', ''),
        '0019xx41': ('CS', '1', 'Tube', ''),
        '0019xx42': ('US', '1', 'Detector Size Rows', ''),
        '0019xx43': ('US', '1', 'Detector Size Columns', ''),
        '0019xx44': ('DS', '1', 'Min Object Size', ''),
        '0019xx45': ('DS', '1', 'Max Object Size', ''),
        '0019xx46': ('DS', '1', 'Max Object Speed', ''),
        '0019xx47': ('CS', '1', 'Object Back Motion', ''),
        '0019xx48': ('UL', '1', 'Exposure Trajectory Family', ''),
        '0019xx49': ('DS', '1', 'Window Time Duration', ''),
        '0019xx4A': ('CS', '1', 'Positioner Angle Display Mode', ''),
        '0019xx4B': ('IS', '1', 'Detector Origin', ''),
        '0019xx4C': ('CS', '1', 'Unknown', ''),
        '0019xx4E': ('DS', '1', 'Default Brightness Contrast', ''),
        '0019xx4F': ('DS', '1', 'User Brightness Contrast', ''),
        '0019xx50': ('IS', '1', 'Source Series Number', ''),
        '0019xx51': ('IS', '1', 'Source Image Number', ''),
        '0019xx52': ('IS', '1', 'Source Frame Number', ''),
        '0019xx53': ('UI', '1', 'Source Series Item Id', ''),
        '0019xx54': ('UI', '1', 'Source Image Item Id', ''),
        '0019xx55': ('UI', '1', 'Source Frame Item Id', ''),
        '0019xx80': ('DS', '1', 'Image Dose', ''),
        '0019xx81': ('US', '1', 'Calibration Frame', ''),
        '0019xx82': ('CS', '1', 'Calibration Object', ''),
        '0019xx83': ('DS', '1', 'Calibration Object Size mm', ''),
        '0019xx84': ('FL', '1', 'Calibration Factor', ''),
        '0019xx85': ('DA', '1', 'Calibration Date', ''),
        '0019xx86': ('TM', '1', 'Calibration Time', ''),
        '0019xx87': ('US', '1', 'Calibration Accuracy', ''),
        '0019xx88': ('CS', '1', 'Calibration Extended', ''),
        '0019xx89': ('US', '1', 'Calibration Image Original', ''),
        '0019xx8A': ('US', '1', 'Calibration Frame Original', ''),
        '0019xx8B': ('US', '1', 'Calibration Number Of Points Uif', ''),
        '0019xx8C': ('US', '1', 'Calibration Points Row', ''),
        '0019xx8D': ('US', '1', 'Calibration Points Column', ''),
        '0019xx8E': ('FL', '1', 'Calibration Magnification Ratio', ''),
        '0019xx8F': ('LO', '1', 'Calibration Sw Version', ''),
        '0019xx90': ('LO', '1', 'Extend Calibration Sw Version', ''),
        '0019xx91': ('IS', '1', 'Calibration Return Code', ''),
        '0019xx92': ('DS', '1', 'Detector Rotation Angle', ''),
        '0019xx93': ('CS', '1', 'Spatial Change', ''),
        '0019xx94': ('CS', '1', 'Inconsistent Flag', ''),
        '0019xx95': ('CS', '1', 'Image Sweep', ''),
        '0019xx96': ('CS', '1', 'Internal Label Image', ''),
        '0019xx97': ('DS', '1', 'Angle 1 Increment', ''),
        '0019xx98': ('DS', '1', 'Angle 2 Increment', ''),
        '0019xx99': ('DS', '1', 'Angle 3 Increment', ''),
        '0019xx9A': ('DS', '1', 'Sensor Feedback', ''),
        '0019xx9B': ('CS', '1', 'Grid', ''),
        '0019xx9C': ('FL', '1', 'Default Mask Pixel Shift', ''),
        '0019xx9D': ('CS', '1', 'Applicable Review Mode', ''),
        '0019xx9E': ('DS', '1', 'Log Lut Control Points', ''),
        '0019xx9F': ('DS', '1', 'Exp Lut Control Points', ''),
        '0019xxA0': ('DS', '1', 'ABD Value', ''),
        '0019xxA1': ('DS', '1', 'Sub Window Center', ''),
        '0019xxA2': ('DS', '1', 'Sub Window Width', ''),
        '0019xxA3': ('DS', '1', 'Image Rotation', ''),
        '0019xxA4': ('CS', '1', 'Auto Injection Enabled', ''),
        '0019xxA5': ('CS', '1', 'Injection Phase', ''),
        '0019xxA6': ('DS', '1', 'Injection Delay', ''),
        '0019xxA7': ('IS', '1', 'Reference Injection Frame Number', ''),
        '0019xxA8': ('DS', '1', 'Injection Duration', ''),
        '0019xxA9': ('DS', '1', 'EPT', ''),
        '0019xxAA': ('CS', '1', 'Can Downscan 512', ''),
        '0019xxAB': ('IS', '1', 'Current Spatial Filter Strength', ''),
        '0019xxAC': ('DS', '1', 'Brightness Sensitivity', ''),
        '0019xxAD': ('DS', '1', 'Exp Lut NOSUB Control Points', ''),
        '0019xxAE': ('LO', '1-n', 'SUB operator LUTs names', ''),
        '0019xxAF': ('DS', '1-n', 'kVp actual vector', ''),
        '0019xxB0': ('DS', '1-n', 'mAs actual vector', ''),
        '0019xxB1': ('LO', '1', 'Acquisition Mode Description', ''),
        '0019xxB2': ('LO', '1', 'Acquisition Mode Display Label', ''),
        '0019xxB3': ('LO', '1', 'Acquisition Protocol User Name', ''),
        '0019xxB8': ('FL', '1', 'Recommended display frame rate float', ''),
        '0019xxB9': ('FL', '1-n', 'ABD Vector', ''),
        '0019xxBA': ('CS', '1', 'Acquisition region', ''),
        '0019xxBB': ('CS', '1', 'Acquisition SUB mode', ''),
        '0019xxBC': ('FL', '1', 'Unknown', ''),
        '0019xxBD': ('CS', '1-n', 'Table rotation status vector', ''),
        '0019xxBE': ('FL', '1-n', 'Source to image distance per frame vector', ''),
        '0019xxC2': ('DS', '1-n', 'pw actual vector', ''),
        '0019xxC4': ('IS', '1', 'Spectral filter thickness', ''),
        '0019xxC5': ('FL', '1', 'Preselected pivot rotation speed', ''),
        '0019xxC7': ('CS', '1', 'Patient position per image', ''),
        '0019xxC8': ('CS', '1', '3D structure of interest', ''),
        '0019xxC9': ('CS', '1', '3D calibration out of date flag', ''),
        '0019xxCA': ('IS', '1', '3Dspin expected number of frames', ''),
        '0019xxD4': ('FL', '1', 'Detection gain value', ''),
        '0019xxD5': ('FL', '1', 'mR mAs calibration value', ''),
        '0019xxDC': ('LO', '1', 'DRM LUT file name', ''),
        '0019xxDD': ('DS', '1-n', 'DRM Strength', ''),
        '0019xxDE': ('CS', '1', 'Acquisition Plane', ''),
        '0019xxDF': ('FL', '1-n', 'LP off longitudinal position Z', ''),
        '0019xxE0': ('FL', '1', 'DAP of current record', ''),
        '0019xxE1': ('FL', '1', 'Pivot Lateral Angle', ''),
        '0019xxE2': ('FL', '1', 'Carm Lateral Angle', ''),
        '0019xxE3': ('FL', '1-n', 'Pivot Lateral Angle increment', ''),
        '0019xxE4': ('FL', '1-n', 'Carm Lateral Angle increment', ''),
        '0019xxE7': ('FL', '1', 'LP off long pos Z first frame', ''),
        '0019xxE8': ('FL', '1-n', 'LP off long pos Z increment', ''),
        '0019xxE9': ('FL', '1-n', 'Source to detector distance per frame vector', ''),
        '0019xxEA': ('FL', '1', 'Unknown', ''),
        '0019xxEB': ('FL', '1', 'Unknown', ''),
        '0019xxEC': ('FL', '1', 'Unknown', ''),
        '0019xxED': ('FL', '1', 'Unknown', ''),
    },
    'GEMS_DL_PATNT_01': {
        '0011xx80': ('UI', '1', 'Patient Instance Uid', ''),
        '0011xx81': ('IS', '1', 'Last Study Number', ''),
        '0011xx82': ('CS', '1', 'Patient Repaired', ''),
        '0011xx83': ('CS', '1', 'Lock Demographics', ''),
    },
    'GEMS_DL_SERIES': {
        '0015xx87': ('IS', '1', 'Number of images', ''),
        '0019xx0B': ('DS', '1-2', 'fov dimension double', ''),
        '0019xx31': ('IS', '1', 'default spatial filter family', ''),
        '0019xx32': ('IS', '1', 'default spatial filter strength', ''),
        '0019xx4B': ('IS', '2', 'Detector origin', ''),
        '0019xx4E': ('DS', '2', 'def_bright_contr', ''),
        '0019xx4F': ('DS', '2', 'user_bright_contr', ''),
        '0019xx81': ('US', '1', 'Calibration frame', ''),
        '0019xx82': ('CS', '1', 'Calibration object', ''),
        '0019xx83': ('DS', '1', 'Calibration object size mm', ''),
        '0019xx84': ('FL', '1', 'Calibration factor', ''),
        '0019xx85': ('DA', '1', 'Calibration date', ''),
        '0019xx86': ('TM', '1', 'Calibration time', ''),
        '0019xx87': ('US', '1', 'Calibration accuracy', ''),
        '0019xx88': ('CS', '1', 'Calibration extended', ''),
        '0019xx89': ('US', '1', 'Calibration image original', ''),
        '0019xx8A': ('US', '1', 'Calibration frame original', ''),
        '0019xx8B': ('US', '1', 'Calibration nb points uif', ''),
        '0019xx8C': ('US', '1-n', 'Calibration points row', ''),
        '0019xx8D': ('US', '1-n', 'Calibration points column', ''),
        '0019xx8E': ('FL', '1', 'Calibration mag ratio', ''),
        '0019xx8F': ('LO', '1', 'Calibration sw version', ''),
        '0019xx90': ('LO', '1', 'Extend calib sw version', ''),
        '0019xx91': ('IS', '1', 'Calibration return code', ''),
        '0019xx92': ('DS', '1', 'detector_rot_angle', ''),
        '0019xx93': ('CS', '1', 'Spatial change', ''),
        '0019xx95': ('CS', '2', 'Image sweep', ''),
        '0019xx97': ('DS', '1-n', 'Angle 1 increment', ''),
        '0019xx98': ('DS', '1-n', 'Angle 2 increment', ''),
        '0019xx99': ('DS', '1-n', 'Angle 3 increment', ''),
        '0019xx9A': ('DS', '1-n', 'sensor feedback', ''),
        '0019xx9D': ('CS', '1', 'applicable review mode', ''),
        '0019xx9E': ('DS', '1-n', 'log LUT control points', ''),
        '0019xx9F': ('DS', '1-n', 'exp LUT SUB control points', ''),
        '0019xxA0': ('DS', '1', 'ABD value', ''),
        '0019xxA1': ('DS', '1', 'Sub window center', ''),
        '0019xxA2': ('DS', '1', 'Sub window width', ''),
        '0019xxA4': ('CS', '1', 'Auto injection enabled', ''),
        '0019xxA5': ('CS', '1', 'injection phase', ''),
        '0019xxA6': ('DS', '1', 'injection delay', ''),
        '0019xxA7': ('IS', '1', 'reference injection frame number', ''),
        '0019xxA9': ('DS', '1-n', 'EPT', ''),
        '0019xxAA': ('CS', '1', 'can downscan 512', ''),
        '0019xxAB': ('IS', '1', 'current spatial filter strength', ''),
        '0019xxAD': ('DS', '1-n', 'exp LUT NOSUB control points', ''),
        '0019xxAE': ('LO', '1-n', 'SUB operator LUTs names', ''),
        '0019xxC4': ('IS', '1', 'Default spatial filter family', ''),
        '0019xxC5': ('FL', '1', 'Preselected pivot rotation speed', ''),
        '0019xxC7': ('CS', '1', 'Patient position per image', ''),
        '0019xxC8': ('CS', '1', '3D structure of interest', ''),
        '0019xxC9': ('CS', '1', '3D calibration out of date flag', ''),
        '0019xxCA': ('IS', '1', '3Dspin expected number of frames', ''),
        '0019xxD4': ('FL', '1', 'Detection gain value', ''),
        '0019xxD5': ('FL', '1', 'mR mAs calibration value', ''),
        '0019xxDC': ('LO', '1', 'DRM LUT file name', ''),
        '0019xxDD': ('DS', '1-n', 'DRM Strength', ''),
    },
    'GEMS_DL_SERIES_01': {
        '0015xx85': ('LO', '1', 'Series File Name', ''),
        '0015xx87': ('IS', '1', 'Number Of Images', ''),
        '0015xx8C': ('CS', '1', 'Sent Flag', ''),
        '0015xx8D': ('US', '1', 'Item Locked', ''),
        '0019xx4C': ('CS', '1', 'internal label', ''),
        '0019xx4D': ('CS', '1', 'browser hide', ''),
    },
    'GEMS_DL_STUDY_01': {
        '0015xx80': ('DS', '1', 'Study Dose', ''),
        '0015xx81': ('DS', '1', 'Study Total Dap', ''),
        '0015xx82': ('DS', '1', 'Study Fluoro Dap', ''),
        '0015xx83': ('IS', '1', 'Study Fluoro Time', ''),
        '0015xx84': ('DS', '1', 'Study Record Dap', ''),
        '0015xx85': ('IS', '1', 'Study Record Time', ''),
        '0015xx86': ('IS', '1', 'Last Xa Number', ''),
        '0015xx88': ('PN', '1', 'Default Operator Name', ''),
        '0015xx89': ('PN', '1', 'Default Performing Physician Name', ''),
        '0015xx8A': ('CS', '1', 'Default Patient Orientation', ''),
        '0015xx8B': ('IS', '1', 'Last Sc Number', ''),
        '0015xx8E': ('UI', '1', 'Common Series Instance Uid', ''),
        '0015xx8F': ('IS', '1', 'Study Number', ''),
        '0015xx92': ('FL', '1', 'Study dose Frontal', ''),
        '0015xx93': ('FL', '1', 'Study total dap Frontal', ''),
        '0015xx94': ('FL', '1', 'Study fluoro dap frontal', ''),
        '0015xx95': ('IS', '1', 'Study fluoro time frontal', ''),
        '0015xx96': ('FL', '1', 'Study record dap frontal', ''),
        '0015xx97': ('IS', '1', 'Study record time frontal', ''),
        '0015xx98': ('FL', '1', 'Study dose lateral', ''),
        '0015xx99': ('FL', '1', 'Study total dap lateral', ''),
        '0015xx9A': ('FL', '1', 'Study fluoro dap lateral', ''),
        '0015xx9B': ('IS', '1', 'Study fluoro time lateral', ''),
        '0015xx9C': ('FL', '1', 'Study record dap leteral', ''),
        '0015xx9D': ('IS', '1', 'Study record time lateral', ''),
    },
    'GEMS_DRS_1': {
        '0037xx10': ('LO', '1', 'Referring Department', ''),
        '0037xx20': ('US', '1', 'Screen Number', ''),
        '0037xx40': ('SH', '1', 'Left Orientation', ''),
        '0037xx42': ('SH', '1', 'Right Orientation', ''),
        '0037xx50': ('CS', '1', 'Inversion', ''),
        '0037xx60': ('US', '1', 'DSA', ''),
    },
    'GEMS_FALCON_03': {
        '0045xx55': ('DS', '8', 'A_Coefficients', ''),
        '0045xx62': ('IS', '1', 'User Window Center', ''),
        '0045xx63': ('IS', '1', 'User Window Width', ''),
        '0045xx65': ('IS', '1', 'Requested Detector Entrance Dose', ''),
        '0045xx67': ('DS', '3', 'VOI LUT Asymmetry parameter beta', ''),
        '0045xx69': ('IS', '1', 'Collimator rotation', ''),
        '0045xx72': ('DS', '1', 'Collimator Width', ''),
        '0045xx73': ('DS', '1', 'Collimator Height', ''),
    },
    'GEMS_FUNCTOOL_01': {
        '0051xx01': ('LO', '1', 'Functional Proc Group Name', ''),
        '0051xx02': ('LO', '1', 'Functional Processing Name', ''),
        '0051xx03': ('SL', '1', 'Bias of Functional Image', ''),
        '0051xx04': ('FL', '1', 'Scale of Functional Image', ''),
        '0051xx05': ('SL', '1', 'Length of Parameters String', ''),
        '0051xx06': ('LT', '1', 'Store Parameters string, delimited by character ESC=0x1B (27)', ''),
        '0051xx07': ('LO', '1', 'Functional Image Version', ''),
        '0051xx08': ('SL', '1', 'Store Color Ramp', ''),
        '0051xx09': ('SL', '1', 'Store Width of Functional Image', ''),
        '0051xx0A': ('SL', '1', 'Store level of Functional Image', ''),
        '0051xx0B': ('FL', '1', 'Store B-Value with Functional Image', ''),
        '0051xx0C': ('LO', '1', 'Analysis Package', ''),
        '0051xx0E': ('UN', '1', 'Unknown', ''),
    },
    'GEMS_GDXE_ATHENAV2_INTERNAL_USE': {
        '7FDFxx10': ('LT', '1', 'PPS Stream', ''),
        '7FDFxx11': ('LT', '1', 'Pixel Data References (temporary)', ''),
        '7FDFxx20': ('SS', '1', 'Auto Push Tag', ''),
        '7FDFxx25': ('CS', '1', 'PPS Status', ''),
    },
    'GEMS_GDXE_FALCON_04': {
        '0011xx03': ('UI', '1', 'Processed Series UID', ''),
        '0011xx04': ('CS', '1', 'Acquisition Type', ''),
        '0011xx05': ('UI', '1', 'Acquisition UID', ''),
        '0011xx06': ('DS', '1', 'Image Dose', ''),
        '0011xx07': ('FL', '1', 'Study Dose', ''),
        '0011xx08': ('FL', '1', 'Study DAP', ''),
        '0011xx09': ('SL', '1', 'Non-Digital Exposures', ''),
        '0011xx10': ('SL', '1', 'Total Exposures', ''),
        '0011xx11': ('LT', '1', 'ROI', ''),
        '0011xx12': ('LT', '1', 'Patient Size String', ''),
        '0011xx13': ('UI', '1', 'SPS UID', ''),
        '0011xx14': ('UI', '1', 'Unknown', ''),
        '0011xx15': ('DS', '1', 'Detector ARC Gain', ''),
        '0011xx16': ('LT', '1', 'Processing Debug Info', ''),
        '0011xx17': ('CS', '1', 'Override mode', ''),
        '0011xx19': ('DS', '1', 'Film Speed Selection', ''),
        '0011xx27': ('UN', '1', 'Unknown', ''),
        '0011xx28': ('UN', '1', 'Unknown', ''),
        '0011xx29': ('UN', '1', 'Unknown', ''),
        '0011xx30': ('UN', '1', 'Unknown', ''),
        '0011xx31': ('IS', '8', 'Detected Field of View', ''),
        '0011xx32': ('IS', '8', 'Adjusted Field of View', ''),
        '0011xx33': ('DS', '1', 'Detected Exposure Index', ''),
        '0011xx34': ('DS', '1', 'Compensated Detector Exposure', ''),
        '0011xx35': ('DS', '1', 'Uncompensated Detector Exposure', ''),
        '0011xx36': ('DS', '1', 'Median Anatomy Count Value', ''),
        '0011xx37': ('DS', '2', 'DEI lower and upper limit values', ''),
        '0011xx38': ('SL', '6', 'Shift Vector for Pasting', ''),
        '0011xx39': ('CS', '1', 'Image Number in Pasting', ''),
        '0011xx40': ('SL', '1', 'Pasting Overlap', ''),
        '0011xx41': ('IS', '24', 'Sub-image Collimator Vertices', ''),
        '0011xx42': ('LO', '1', 'View IP', ''),
        '0011xx43': ('IS', '24', 'Key-stone Coordinates', ''),
        '0011xx44': ('CS', '1', 'Receptor Type', ''),
        '0011xx46': ('LO', '1-n', 'Unknown', ''),
        '0011xx47': ('DS', '1', 'Unknown', ''),
    },
    'GEMS_GENIE_1': {
        '0009xx01': ('SH', '1', 'Unknown', ''),
        '0009xx10': ('LO', '1', 'Study Name', ''),
        '0009xx11': ('SL', '1', 'Study Flags', ''),
        '0009xx12': ('SL', '1', 'Study Type', ''),
        '0009xx1E': ('UI', '1', 'Dataset UID', ''),
        '0009xx20': ('LO', '1', 'Series Object Name', ''),
        '0009xx21': ('SL', '1', 'Series Flags', ''),
        '0009xx22': ('SH', '1', 'User Orientation', ''),
        '0009xx23': ('SL', '1', 'Initiation Type', ''),
        '0009xx24': ('SL', '1', 'Initiation Delay', ''),
        '0009xx25': ('SL', '1', 'Initiation Count Rate', ''),
        '0009xx26': ('SL', '1', 'Number Energy Sets', ''),
        '0009xx27': ('SL', '1', 'Number Detectors', ''),
        '0009xx28': ('SL', '1', 'Number RR Windows', ''),
        '0009xx29': ('SL', '1', 'Number MG Time Slots', ''),
        '0009xx2A': ('SL', '1', 'Number View Sets', ''),
        '0009xx2B': ('LO', '1', 'Trigger History UID', ''),
        '0009xx2C': ('LO', '1', 'Series Comments', ''),
        '0009xx2D': ('SL', '1', 'Track Beat Average', ''),
        '0009xx2E': ('FD', '1', 'Distance Prescribed', ''),
        '0009xx2F': ('SL', '1', 'Table Direction', ''),
        '0009xx30': ('LO', '1', 'Unknown', ''),
        '0009xx33': ('FD', '1', 'Rotational Continuous Speed', ''),
        '0009xx34': ('SL', '1', 'Gantry Motion Type (retired)', ''),
        '0009xx35': ('SL', '1', 'Gantry Locus Type', ''),
        '0009xx37': ('SL', '1', 'Starting Heart Rate', ''),
        '0009xx38': ('SL', '1', 'RR Window Width', ''),
        '0009xx39': ('SL', '1', 'RR Window Offset', ''),
        '0009xx3A': ('SL', '1', 'Percent Cycle Imaged', ''),
        '0009xx40': ('PN', '1', 'Patient Object Name', ''),
        '0009xx41': ('SL', '1', 'Patient Flags', ''),
        '0009xx42': ('DA', '1', 'Patient Creation Date', ''),
        '0009xx43': ('TM', '1', 'Patient Creation Time', ''),
        '0009xx44': ('SL', '1', 'Num Views Acquired (retired)', ''),
        '0009xx45': ('LT', '1', 'Unknown', ''),
        '0011xx0A': ('SL', '1', 'Series Type', ''),
        '0011xx0B': ('SL', '1', 'Effective Series Duration', ''),
        '0011xx0C': ('SL', '1', 'Num Beats', ''),
        '0011xx0D': ('LO', '1', 'Radio Nuclide Name', ''),
        '0011xx10': ('LO', '1', 'Dataset Object Name', ''),
        '0011xx11': ('IS', '1', 'Dataset Modified', ''),
        '0011xx12': ('LO', '1-n', 'Dataset Name', ''),
        '0011xx13': ('SL', '1', 'Dataset Type', ''),
        '0011xx14': ('SH', '1', 'Completion Time', ''),
        '0011xx15': ('SL', '1', 'Detector Number', ''),
        '0011xx16': ('SL', '1', 'Energy Number', ''),
        '0011xx17': ('SL', '1', 'RR Interval Window Number', ''),
        '0011xx18': ('SL', '1', 'MG Bin Number', ''),
        '0011xx19': ('FD', '1', 'Radius Of Rotation', ''),
        '0011xx1A': ('SL', '1', 'Detector Count Zone', ''),
        '0011xx1B': ('SL', '1', 'Num Energy Windows', ''),
        '0011xx1C': ('SL', '4', 'Energy Offset', ''),
        '0011xx1D': ('SL', '1', 'Energy Range', ''),
        '0011xx1E': ('SL', '4', 'Energy Width (retired)', ''),
        '0011xx1F': ('SL', '1', 'Image Orientation', ''),
        '0011xx21': ('DS', '1', 'Acq Zoom (retired)', ''),
        '0011xx22': ('DS', '1', 'Acq Pan (retired)', ''),
        '0011xx23': ('SL', '1', 'Use FOV Mask', ''),
        '0011xx24': ('SL', '1', 'FOV Mask Y Cutoff Distance', ''),
        '0011xx25': ('SL', '1', 'FOV Mask Cutoff Angle', ''),
        '0011xx26': ('SL', '1', 'Table Orientation', ''),
        '0011xx27': ('SL', '2', 'ROI Top Left', ''),
        '0011xx28': ('SL', '2', 'ROI Bottom Right', ''),
        '0011xx29': ('SL', '1', 'Uniformity Mean', ''),
        '0011xx2A': ('FD', '1', 'Phase Duration (retired)', ''),
        '0011xx2C': ('FD', '1', 'View X Adjustment', ''),
        '0011xx2D': ('FD', '1', 'View Y Adjustment', ''),
        '0011xx2E': ('SL', '1', 'Pixel Overflow Flag', ''),
        '0011xx2F': ('SL', '1', 'Overflow Level', ''),
        '0011xx30': ('LO', '1', 'Picture Object Name', ''),
        '0011xx31': ('LO', '1', 'Acquisition Parent UID', ''),
        '0011xx32': ('LO', '1', 'Processing Parent UID', ''),
        '0011xx33': ('LO', '1', 'Energy Correct Name', ''),
        '0011xx34': ('LO', '1', 'Spatial Correct Name', ''),
        '0011xx35': ('LO', '1', 'Tuning Calib Name', ''),
        '0011xx36': ('LO', '1', 'Uniformity Correct Name', ''),
        '0011xx37': ('LT', '1', 'Acquisition Specific Correction Name', ''),
        '0011xx38': ('SL', '1', 'Byte Order', ''),
        '0011xx39': ('SL', '1', 'Compression Type', ''),
        '0011xx3A': ('SL', '1', 'Picture Format', ''),
        '0011xx3B': ('FD', '1', 'Pixel Scale', ''),
        '0011xx3C': ('FD', '1', 'Pixel Offset', ''),
        '0011xx3D': ('SL', '4', 'Energy Peak (retired)', ''),
        '0011xx3E': ('SL', '1', 'FOV Shape', ''),
        '0011xx3F': ('SL', '1', 'Dataset Flags', ''),
        '0011xx40': ('LO', '1', 'Viewing Object Name', ''),
        '0011xx41': ('SL', '1', 'Orientation Angle', ''),
        '0011xx42': ('FD', '1', 'Rotation Angle', ''),
        '0011xx43': ('SL', '1', 'Window Inverse Flag', ''),
        '0011xx44': ('FD', '1', 'Threshold Center', ''),
        '0011xx45': ('FD', '1', 'Threshold Width', ''),
        '0011xx46': ('SL', '1', 'Interpolation Type', ''),
        '0011xx50': ('LO', '1', 'Where Object Name', ''),
        '0011xx55': ('FD', '1', 'Period', ''),
        '0011xx56': ('FD', '1', 'Elapsed Time', ''),
        '0011xx57': ('FD', '2', 'FOV', ''),
        '0011xx61': ('SL', '1', 'Image Size', ''),
        '0011xx62': ('FD', '1', 'Linear FOV', ''),
        '0011xx63': ('FD', '1', 'Spatial Offset', ''),
        '0011xx64': ('FD', '1', 'Spatial Orientation', ''),
        '0011xx65': ('LO', '1', 'Reference Dataset UID', ''),
        '0011xx66': ('SH', '1', 'Starcam Reference Dataset', ''),
        '0011xx67': ('SL', '1', 'Reference Frame Number', ''),
        '0011xx68': ('SL', '1', 'Cursor Length', ''),
        '0011xx69': ('SL', '1', 'Number of Cursors', ''),
        '0011xx6A': ('SL', '1', 'Cursor Coordinates', ''),
        '0011xx6B': ('SL', '1', 'Recon Options Flag', ''),
        '0011xx6C': ('FD', '1', 'Motion Threshold', ''),
        '0011xx6D': ('UI', '1', 'Motion Curve UID', ''),
        '0011xx6E': ('SL', '1', 'Recon Type', ''),
        '0011xx6F': ('SL', '1', 'Pre Filter Type', ''),
        '0011xx71': ('SL', '1', 'Back Proj Filter Type', ''),
        '0011xx72': ('SL', '1', 'Recon Arc', ''),
        '0011xx73': ('FD', '1', 'Recon Pan AP Offset', ''),
        '0011xx74': ('FD', '1', 'Recon Pan LR Offset', ''),
        '0011xx75': ('FD', '1', 'Recon Area', ''),
        '0011xx76': ('SL', '1', 'Start View', ''),
        '0011xx77': ('SL', '1', 'Attenuation Type', ''),
        '0011xx78': ('SL', '1', 'Dual Energy Processing', ''),
        '0011xx79': ('SH', '1', 'Pre Filter Param', ''),
        '0011xx7A': ('SH', '1', 'Pre Filter Param 2', ''),
        '0011xx7B': ('SH', '1', 'Back Proj Filter Param', ''),
        '0011xx7C': ('SH', '1', 'Back Proj Filter Param 2', ''),
        '0011xx7D': ('SH', '1', 'Attenuation Coef', ''),
        '0011xx7E': ('SL', '1', 'Ref Slice Width', ''),
        '0011xx7F': ('FD', '1', 'Ref Trans Pixel Volume', ''),
        '0011xx81': ('SH', '1', 'Attenuation Threshold', ''),
        '0011xx82': ('FD', '1', 'Interpolation Distance', ''),
        '0011xx83': ('FD', '1', 'Interpolation Center X', ''),
        '0011xx84': ('FD', '1', 'Interpolation Center Y', ''),
        '0011xx85': ('SL', '1', 'Quant Filter Flag', ''),
        '0011xx86': ('SL', '1', 'Head Conversion', ''),
        '0011xx87': ('SL', '1', 'Slice Width Pixels', ''),
        '0011xx88': ('SL', '1', 'Rfmtr Trans Ref', ''),
        '0011xx89': ('FD', '1', 'Rfmtr Trans Ref mm', ''),
        '0011xx8A': ('SL', '1', 'Two Line Trans Ref', ''),
        '0011xx8B': ('SL', '1', 'Three-D Zero', ''),
        '0011xx8C': ('SL', '1', 'Three-D Zero Length', ''),
        '0011xx8D': ('SL', '1', 'Three-D Zero In', ''),
        '0013xx10': ('FD', '2', 'Digital FOV', ''),
        '0013xx11': ('SL', '1', 'Source Translator', ''),
        '0013xx12': ('UL', '1', 'RAL Flags', ''),
        '0013xx13': ('SQ', '1', 'Xeleris Frame Sequence', ''),
        '0013xx14': ('SL', '1', 'Original Image Num', ''),
        '0013xx15': ('FD', '1', 'Fscalar', ''),
        '0013xx16': ('SL', '1', 'AutoTrack Peak', ''),
        '0013xx17': ('SL', '1', 'AutoTrack Width', ''),
        '0013xx18': ('FD', '1', 'Transmission Scan Time', ''),
        '0013xx19': ('FD', '1', 'Transmission Mask Width', ''),
        '0013xx1A': ('FD', '1', 'Copper Attenuator Thickness', ''),
        '0013xx1B': ('FD', '1', 'Det Ang Separation', ''),
        '0013xx1C': ('SL', '1', 'Axial Acceptance Angle', ''),
        '0013xx1D': ('SL', '1', 'Theta Acceptance Value', ''),
        '0013xx1E': ('FD', '1-n', 'Tomo View Offset', ''),
        '0013xx20': ('FD', '1', 'Accepted Beats Time', ''),
        '0013xx21': ('FD', '2', 'Threshold', ''),
        '0013xx22': ('FD', '2', 'Linear Depth', ''),
        '0013xx23': ('LO', '1', 'Unif Date Time', ''),
        '0013xx24': ('SL', '1', 'Series Accepted Beats', ''),
        '0013xx25': ('SL', '1', 'Series Rejected Beats', ''),
        '0013xx26': ('LT', '1', 'Study Comments', ''),
        '0015xx10': ('SL', '1', 'Frame Termination Condition', ''),
        '0015xx11': ('SL', '1', 'Frame Termination Value', ''),
        '0015xx12': ('SL', '1', 'Num ECT Phases', ''),
        '0015xx13': ('SL', '1', 'Num WB Scans', ''),
        '0015xx14': ('SL', '1', 'ECT Phase Num', ''),
        '0015xx15': ('SL', '1', 'WB Scan Num', ''),
        '0015xx16': ('SL', '1', 'Comb Head Number', ''),
        '0015xx17': ('UL', '1', 'Preceding Beat', ''),
        '0019xx5F': ('SQ', '1', 'Unknown', ''),
        '0033xx07': ('SQ', '1-n', 'Orig SOP Instance UID', ''),
        '0033xx08': ('CS', '1', 'Xeleris Data Object Type', ''),
        '0033xx10': ('SL', '1', 'Modified', ''),
        '0033xx11': ('LO', '1', 'Name', ''),
        '0033xx16': ('LO', '1', 'ProtocolDataUID', ''),
        '0033xx17': ('SH', '1', 'Date', ''),
        '0033xx18': ('SH', '1', 'Time', ''),
        '0033xx19': ('UL', '1', 'ProtocoldataFlags', ''),
        '0033xx1A': ('UL', '1', 'ProtocolName', ''),
        '0033xx1B': ('LO', '1', 'RelevantDataUID', ''),
        '0033xx1C': ('LO', '1', 'BulkData', ''),
        '0033xx1D': ('SL', '1-n', 'IntData', ''),
        '0033xx1E': ('FD', '1-n', 'DoubleData', ''),
        '0033xx1F': ('OB', '1', 'StringData', ''),
        '0033xx20': ('LT', '1-n', 'BulkDataFormat', ''),
        '0033xx21': ('LT', '1-n', 'IntDataFormat', ''),
        '0033xx22': ('LT', '1-n', 'DoubleDataFormat', ''),
        '0033xx23': ('LT', '1-n', 'StringDataFormat', ''),
        '0033xx24': ('LT', '1', 'Description', ''),
        '0033xx30': ('UL', '1', 'Allocate trigger buffer', ''),
        '0033xx33': ('UL', '1', 'Number of triggers', ''),
        '0033xx34': ('UL', '1', 'Trigger size', ''),
        '0033xx35': ('UL', '1', 'Trigger data size', ''),
        '0033xx36': ('OB', '1-n', 'Trigger data', ''),
        '0035xx01': ('FD', '1-n', 'Start Angle', ''),
        '0055xx12': ('SQ', '1', 'Xeleris Energy Window Information Sequence', ''),
        '0055xx13': ('SQ', '1', 'Xeleris Energy Window Range Sequence', ''),
        '0055xx22': ('SQ', '1', 'Xeleris Detector Information Sequence', ''),
        '0055xx52': ('SQ', '1', 'Xeleris Rotation Information Sequence', ''),
        '0055xx62': ('SQ', '1', 'Xeleris Gated Information Sequence', ''),
        '0055xx63': ('SQ', '1', 'Xeleris Data Information Sequence', ''),
        '0055xx64': ('SQ', '1', 'SDODoubleData SQ', ''),
        '0055xx65': ('SQ', '1', 'Unknown', ''),
        '5001xx01': ('SL', '1', 'Modified', ''),
        '5001xx02': ('LO', '1', 'Name', ''),
        '5001xx03': ('SL', '1', 'Cid', ''),
        '5001xx04': ('SL', '1', 'Srid', ''),
        '5001xx05': ('LO', '1', 'SOPClassUID', ''),
        '5001xx06': ('LO', '1', 'SOPInstanceUID', ''),
        '5001xx07': ('SL', '1', 'CurveType', ''),
        '5001xx08': ('SL', '1', 'GraphType', ''),
        '5001xx09': ('LO', '1', 'Legend', ''),
        '5001xx0A': ('LO', '1', 'XUnits', ''),
        '5001xx0B': ('LO', '1', 'YUnits', ''),
        '5001xx0C': ('SL', '1', 'Edit', ''),
        '5001xx0D': ('SL', '1', 'Suspend', ''),
        '5001xx0E': ('SL', '1', 'StyleLine', ''),
        '5001xx0F': ('SL', '1', 'StyleFill', ''),
        '5001xx10': ('LO', '1', 'StyleColour', ''),
        '5001xx11': ('SL', '1', 'StyleWidth', ''),
        '5001xx12': ('SL', '1', 'StylePoint', ''),
        '5001xx13': ('LO', '1', 'StylePColour', ''),
        '5001xx14': ('SL', '1', 'StylePSize', ''),
        '5001xx15': ('SL', '1', 'Segments', ''),
        '5001xx16': ('SL', '1', 'SegType', ''),
        '5001xx17': ('FD', '1-n', 'SegStart', ''),
        '5001xx18': ('FD', '1-n', 'SegEnd', ''),
        '5001xx19': ('SL', '1-n', 'SegStyleLine', ''),
        '5001xx1A': ('SL', '1-n', 'SegStyleFill', ''),
        '5001xx1B': ('LO', '1', 'SegStyleColour', ''),
        '5001xx1C': ('SL', '1-n', 'SegStyleWidth', ''),
        '5001xx1D': ('SL', '1-n', 'SegStylePoint', ''),
        '5001xx1E': ('SL', '1', 'SegStylePColour', ''),
        '5001xx1F': ('SL', '1', 'SegStylePSize', ''),
        '5001xx20': ('LO', '1', 'SegName', ''),
        '5001xx21': ('SL', '1-n', 'SegAllowDirInt', ''),
        '5001xx22': ('SL', '1', 'TextAnnots', ''),
        '5001xx23': ('FD', '1-n', 'TxtX', ''),
        '5001xx24': ('FD', '1-n', 'TxtY', ''),
        '5001xx25': ('LO', '1', 'TxtText', ''),
        '5001xx26': ('LO', '1', 'TxtName', ''),
        '5001xx30': ('LO', '1', 'ROIName', ''),
        '5001xx31': ('LO', '1', 'DerivedFromImageUID', ''),
        '5001xx32': ('SL', '1-n', 'DerivedFromImages', ''),
        '5001xx33': ('UL', '1', 'CurveFlags', ''),
        '5001xx34': ('LO', '1', 'CurveName', ''),
        '5001xx35': ('LO', '1', 'DatasetName', ''),
        '5001xx36': ('LO', '1', 'CurveUID', ''),
        '5001xx37': ('FD', '1', 'ROIArea', ''),
        '5001xx38': ('SL', '1', 'Modified', ''),
        '5001xx39': ('LO', '1', 'Name', ''),
        '5001xx3A': ('LO', '1', 'Software version', ''),
        '5001xx3B': ('SH', '1', 'StartDate', ''),
        '5001xx3C': ('SH', '1', 'CompletionDate', ''),
        '5001xx3D': ('LO', '1', 'DetectorName', ''),
        '5001xx41': ('SL', '1', 'Modified', ''),
        '5001xx42': ('LO', '1', 'Name', ''),
        '5001xx43': ('SL', '1', 'Name', ''),
        '5001xx44': ('SL', '1', 'Name', ''),
        '5001xx45': ('LO', '1', 'SOPClassUID', ''),
        '5001xx46': ('LO', '1', 'SOPInstanceUID', ''),
        '5001xx47': ('LO', '1', 'NormalColor', ''),
        '5001xx48': ('LT', '1', 'NameFont', ''),
        '5001xx49': ('SL', '1', 'FillPattern', ''),
        '5001xx4A': ('SL', '1', 'LineStyle', ''),
        '5001xx4B': ('SL', '1', 'LineDashLength', ''),
        '5001xx4C': ('SL', '1', 'LineThickness', ''),
        '5001xx4D': ('SL', '1', 'Interactivity', ''),
        '5001xx4E': ('SL', '1', 'NamePos', ''),
        '5001xx4F': ('SL', '1', 'NameDisplay', ''),
        '5001xx50': ('LO', '1', 'Label', ''),
        '5001xx51': ('SL', '1-n', 'BpSeg', ''),
        '5001xx52': ('US', '1-n', 'BpSegPairs', ''),
        '5001xx53': ('SL', '1', 'SeedSpace', ''),
        '5001xx54': ('FD', '1-n', 'Seeds', ''),
        '5001xx55': ('SL', '1-n', 'Shape', ''),
        '5001xx56': ('FD', '1-n', 'ShapeTilt', ''),
        '5001xx59': ('SL', '1-n', 'ShapePtsSpace', ''),
        '5001xx5A': ('SL', '1-n', 'ShapeCtrlPtsCounts', ''),
        '5001xx5B': ('FD', '1-n', 'ShapeCtrlPts', ''),
        '5001xx5C': ('SL', '1', 'ShapeCPSpace', ''),
        '5001xx5D': ('SL', '1', 'ROIFlags', ''),
        '5001xx5E': ('SL', '1', 'FrameNumber', ''),
        '5001xx5F': ('SL', '1', 'Id', ''),
        '5001xx60': ('LO', '1-n', 'DatasetROIMapping', ''),
    },
    'GEMS_GNHD_01': {
        '0033xx01': ('UN', '1', 'Unknown', ''),
        '0033xx02': ('UN', '1', 'Unknown', ''),
    },
    'GEMS_HELIOS_01': {
        '0045xx01': ('SS', '1', 'Number of Macro Rows in Detector', ''),
        '0045xx02': ('FL', '1', 'Macro width at ISO Center', ''),
        '0045xx03': ('SS', '1', 'DAS type', ''),
        '0045xx04': ('SS', '1', 'DAS gain', ''),
        '0045xx05': ('SS', '1', 'DAS Temperature', ''),
        '0045xx06': ('CS', '1', 'Table Direction', ''),
        '0045xx07': ('FL', '1', 'Z smoothing Factor', ''),
        '0045xx08': ('SS', '1', 'View Weighting Mode', ''),
        '0045xx09': ('SS', '1', 'Sigma Row number', ''),
        '0045xx0A': ('FL', '1', 'Minimum DAS value', ''),
        '0045xx0B': ('FL', '1', 'Maximum Offset Value', ''),
        '0045xx0C': ('SS', '1', 'Number of Views shifted', ''),
        '0045xx0D': ('SS', '1', 'Z tracking Flag', ''),
        '0045xx0E': ('FL', '1', 'Mean Z error', ''),
        '0045xx0F': ('FL', '1', 'Z tracking Error', ''),
        '0045xx10': ('SS', '1', 'Start View 2A', ''),
        '0045xx11': ('SS', '1', 'Number of Views 2A', ''),
        '0045xx12': ('SS', '1', 'Start View 1A', ''),
        '0045xx13': ('SS', '1', 'Sigma Mode', ''),
        '0045xx14': ('SS', '1', 'Number of Views 1A', ''),
        '0045xx15': ('SS', '1', 'Start View 2B', ''),
        '0045xx16': ('SS', '1', 'Number Views 2B', ''),
        '0045xx17': ('SS', '1', 'Start View 1B', ''),
        '0045xx18': ('SS', '1', 'Number of Views 1B', ''),
        '0045xx19': ('SS', '1', 'Air Calibration Date', ''),
        '0045xx1A': ('SS', '1', 'Air Calibration Time', ''),
        '0045xx1B': ('SS', '1', 'Phantom Calibration Date', ''),
        '0045xx1C': ('SS', '1', 'Phantom Calibration Time', ''),
        '0045xx1D': ('SS', '1', 'Z Slope Calibration Date', ''),
        '0045xx1E': ('SS', '1', 'Z Slope Calibration Time', ''),
        '0045xx1F': ('SS', '1', 'Cross Talk Calibration Date', ''),
        '0045xx20': ('SS', '1', 'Cross Talk Calibration Time', ''),
        '0045xx21': ('SS', '1', 'Iterbone Flag', ''),
        '0045xx22': ('SS', '1', 'Peristaltic Flag', ''),
        '0045xx30': ('CS', '1', 'CardiacReconAlgorithm', ''),
        '0045xx31': ('CS', '1', 'AvgHeartRateForImage', ''),
        '0045xx32': ('FL', '1', 'Temporal Resolution', ''),
        '0045xx33': ('CS', '1', 'PctRpeakDelay', ''),
        '0045xx34': ('CS', '1', 'ActualPctRpeakDelay', ''),
        '0045xx36': ('CS', '1', 'EkgFullMaStartPhase', ''),
        '0045xx37': ('CS', '1', 'EkgFullMaEndPhase', ''),
        '0045xx38': ('CS', '1', 'EkgModulationMaxMa', ''),
        '0045xx39': ('CS', '1', 'EkgModulationMinMa', ''),
        '0045xx3B': ('LO', '1', 'Noise Reduction Image Filter Description', ''),
        '0045xx3F': ('IS', '1', 'RPeakTimeDelay', ''),
        '0045xx44': ('IS', '1', 'ActualRPeakTimeDelay', ''),
        '0045xx45': ('ST', '1', 'CardiacScanOptions', ''),
        '0045xx50': ('FD', '1', 'Temporal Center View Angle', ''),
        '0045xx51': ('FD', '1', 'Recon Center View Angle', ''),
        '0045xx52': ('CS', '1', 'WideCone Masking', ''),
        '0045xx53': ('FD', '1', 'WideCone Corner Blending Radius', ''),
        '0045xx54': ('FD', '1', 'WideCone Corner Blending Radius Offset', ''),
        '0045xx55': ('CS', '1', 'Internal Recon Algorithm', ''),
    },
    'GEMS_HINO_CT_01': {
        '004Bxx01': ('DS', '1-n', 'Beam Thickness', ''),
        '004Bxx02': ('DS', '1-n', 'R Time', ''),
        '004Bxx03': ('IS', '1', 'HBC number', ''),
    },
    'GEMS_IDEN_01': {
        '000910xx': ('LO', '1', 'Private Element Creator', ''),
        '0009xx01': ('LO', '1', 'Full fidelity', ''),
        '0009xx02': ('SH', '1', 'Suite id', ''),
        '0009xx04': ('SH', '1', 'Product id', ''),
        '0009xx17': ('LT', '1', 'Series Description', ''),
        '0009xx1A': ('US', '1', 'Unknown', ''),
        '0009xx20': ('US', '1', 'Unknown', ''),
        '0009xx27': ('SL', '1', 'Image actual date', ''),
        '0009xx2F': ('SH', '1', 'Unknown', ''),
        '0009xx30': ('SH', '1', 'Service id', ''),
        '0009xx31': ('SH', '1', 'Mobile location number', ''),
        '0009xxE2': ('LT', '1-n', 'Image Type (ORIGINAL\\PROSPECTIVE ...)', ''),
        '0009xxE3': ('UI', '1', 'Equipment UID', ''),
        '0009xxE6': ('SH', '1', 'Genesis Version - now', ''),
        '0009xxE7': ('UL', '1', 'Exam Record checksum', ''),
        '0009xxE8': ('SH', '1', 'Series Suite Id', ''),
        '0009xxE9': ('SL', '1', 'Actual series data time stamp', ''),
    },
    'GEMS_IMAG_01': {
        '002710xx': ('LO', '1', 'Private Element Creator', ''),
        '0027xx06': ('SL', '1', 'Image archive flag', ''),
        '0027xx10': ('SS', '1', 'Scout Type', ''),
        '0027xx1C': ('SL', '1', 'Vma mamp', ''),
        '0027xx1D': ('SS', '1', 'Vma phase', ''),
        '0027xx1E': ('SL', '1', 'Vma mod', ''),
        '0027xx1F': ('SL', '1', 'Vma clip', ''),
        '0027xx20': ('SS', '1', 'Smart scan ON/OFF flag', ''),
        '0027xx30': ('SH', '1', 'Foreign Image Revision', ''),
        '0027xx31': ('SS', '1', 'Imaging Mode', ''),
        '0027xx32': ('SS', '1', 'Pulse Sequence', ''),
        '0027xx33': ('SL', '1', 'Imaging Options', ''),
        '0027xx35': ('SS', '1', 'Plane Type', ''),
        '0027xx36': ('SL', '1', 'Oblique Plane', ''),
        '0027xx40': ('SH', '1', 'RAS letter of image location', ''),
        '0027xx41': ('FL', '1', 'Image location', ''),
        '0027xx42': ('FL', '1', 'Center R coord of plane image', ''),
        '0027xx43': ('FL', '1', 'Center A coord of plane image', ''),
        '0027xx44': ('FL', '1', 'Center S coord of plane image', ''),
        '0027xx45': ('FL', '1', 'Normal R coord', ''),
        '0027xx46': ('FL', '1', 'Normal A coord', ''),
        '0027xx47': ('FL', '1', 'Normal S coord', ''),
        '0027xx48': ('FL', '1', 'R Coord of Top Right Corner', ''),
        '0027xx49': ('FL', '1', 'A Coord of Top Right Corner', ''),
        '0027xx4A': ('FL', '1', 'S Coord of Top Right Corner', ''),
        '0027xx4B': ('FL', '1', 'R Coord of Bottom Right Corner', ''),
        '0027xx4C': ('FL', '1', 'A Coord of Bottom Right Corner', ''),
        '0027xx4D': ('FL', '1', 'S Coord of Bottom Right Corner', ''),
        '0027xx50': ('FL', '1', 'Scan Start Location', ''),
        '0027xx51': ('FL', '1', 'Scan End Location', ''),
        '0027xx52': ('SH', '1', 'RAS letter for side of image', ''),
        '0027xx53': ('SH', '1', 'RAS letter for anterior/posterior', ''),
        '0027xx54': ('SH', '1', 'RAS letter for scout start loc', ''),
        '0027xx55': ('SH', '1', 'RAS letter for scout end loc', ''),
        '0027xx60': ('FL', '1', 'Image dimension - X', ''),
        '0027xx61': ('FL', '1', 'Image dimension - Y', ''),
        '0027xx62': ('FL', '1', 'Number of Excitations', ''),
        '0029xx15': ('SL', '1', 'Lower range of Pixels1', ''),
        '0029xx16': ('SL', '1', 'Lower range of Pixels1', ''),
        '0029xx17': ('SL', '1', 'Lower range of Pixels2', ''),
        '0029xx18': ('SL', '1', 'Upper range of Pixels2', ''),
        '0029xx1A': ('SL', '1', 'Len of tot hdr in bytes No longer supported', ''),
        '0029xx26': ('SS', '1', 'Version of the hdr struct', ''),
        '0029xx34': ('SL', '1', 'Advantage comp. Overflow', ''),
        '0029xx35': ('SL', '1', 'Advantage comp. Underflow', ''),
    },
    'GEMS_IMPS_01': {
        '002910xx': ('LO', '1', 'Private Element Creator', ''),
        '0029xx04': ('SL', '1', 'Lower range of Pixels1', ''),
        '0029xx05': ('DS', '1', 'Lower range of Pixels1', ''),
        '0029xx06': ('DS', '1', 'Lower range of Pixels1', ''),
        '0029xx07': ('SL', '1', 'Lower range of Pixels1', ''),
        '0029xx08': ('SH', '1', 'Lower range of Pixels1', ''),
        '0029xx09': ('SH', '1', 'Lower range of Pixels1', ''),
        '0029xx0A': ('SS', '1', 'Lower range of Pixels1', ''),
        '0029xx15': ('SL', '1', 'Lower range of Pixels1', ''),
        '0029xx16': ('SL', '1', 'Upper range of Pixels1', ''),
        '0029xx17': ('SL', '1', 'Lower range of Pixels2', ''),
        '0029xx18': ('SL', '1', 'Upper range of Pixels2', ''),
        '0029xx1A': ('SL', '1', 'Len of tot hdr in bytes', ''),
        '0029xx26': ('SS', '1', 'Version of the hdr struct', ''),
        '0029xx34': ('SL', '1', 'Advantage comp. Overflow', ''),
        '0029xx35': ('SL', '1', 'Advantage comp. Underflow', ''),
        '0043xx13': ('SS', '5', 'Decon kernel parameters', ''),
    },
    'GEMS_IQTB_IDEN_47': {
        '0047xx01': ('SH', '1', 'Image Path', ''),
        '0047xx02': ('UL', '1', 'Image Date/Time', ''),
        '0047xx03': ('UL', '1', 'Queue Sequence Number', ''),
        '0047xx04': ('UL', '1', 'Recon Sequence ID', ''),
    },
    'GEMS_IT_US_REPORT': {
        '0045xx11': ('OW', '1', 'Vivid excel file', ''),
        '0045xx12': ('OW', '1', 'Vivid CHM file', ''),
        '0045xx13': ('OW', '1', 'Vivid PDF file', ''),
    },
    'GEMS_LUNAR_RAW': {
        '7003xx01': ('ST', '1', 'enCORE File Name', ''),
        '7003xx02': ('OB', '1', 'enCORE File Data', ''),
        '7003xx03': ('UL', '1', 'enCORE File Length', ''),
        '7003xx04': ('LO', '1', 'enCORE File Modified Time', ''),
    },
    'GEMS_MR_RAW_01': {
        '7001xx01': ('OB', '1', 'rdb_hdr_rec', ''),
        '7001xx02': ('OB', '1', 'rdb_hdr_per_pass_tab', ''),
        '7001xx03': ('OB', '1', 'rdb_hdr_unlock_raw', ''),
        '7001xx04': ('OB', '1', 'rdb_hdr_data_acq_tab', ''),
        '7001xx05': ('OB', '1', 'rdb_hdr_nex_tab', ''),
        '7001xx06': ('OB', '1', 'rdb_hdr_nex_abort_tab', ''),
        '7001xx07': ('OB', '1', 'rdb_hdr_tool', ''),
        '7001xx08': ('OB', '1', 'rdb_raw_data', ''),
        '7001xx09': ('OB', '1', 'SSP save', ''),
        '7001xx0A': ('OB', '1', 'UDA save', ''),
        '7001xx0B': ('OB', '1', 'rdb_chemsat_data', ''),
    },
    'GEMS_PARM_01': {
        '004310xx': ('LO', '1', 'Private Element Creator', ''),
        '0043xx01': ('SS', '1', 'Bitmap of prescan options', ''),
        '0043xx02': ('SS', '1', 'Gradient offset in X', ''),
        '0043xx03': ('SS', '1', 'Gradient offset in Y', ''),
        '0043xx04': ('SS', '1', 'Gradient offset in Z', ''),
        '0043xx05': ('SS', '1', 'Img is original or unoriginal', ''),
        '0043xx06': ('SS', '1', 'Number of EPI shots', ''),
        '0043xx07': ('SS', '1', 'Views per segment', ''),
        '0043xx08': ('SS', '1', 'Respiratory rate, bpm', ''),
        '0043xx09': ('SS', '1', 'Respiratory trigger point', ''),
        '0043xx0A': ('SS', '1', 'Type of receiver used', ''),
        '0043xx0B': ('DS', '1', 'DB/dt Peak rate of change of gradient field', ''),
        '0043xx0C': ('DS', '1', 'dB/dt Limits in units of percent', ''),
        '0043xx0D': ('DS', '1', 'PSD estimated limit', ''),
        '0043xx0E': ('DS', '1', 'PSD estimated limit in tesla per second', ''),
        '0043xx0F': ('DS', '1', 'Saravghead', ''),
        '0043xx10': ('US', '1', 'Window value', ''),
        '0043xx11': ('US', '1', 'Total input views', ''),
        '0043xx12': ('SS', '3', 'X-ray chain', ''),
        '0043xx13': ('SS', '5', 'Decon kernel parameters', ''),
        '0043xx14': ('SS', '3', 'Calibration parameters', ''),
        '0043xx15': ('SS', '3', 'Total output views', ''),
        '0043xx16': ('SS', '5', 'Number of overranges', ''),
        '0043xx17': ('DS', '1', 'IBH image scale factors', ''),
        '0043xx18': ('DS', '3', 'BBH coefficients', ''),
        '0043xx19': ('SS', '1', 'Number of BBH chains to blend', ''),
        '0043xx1A': ('SL', '1', 'Starting channel number', ''),
        '0043xx1B': ('SS', '1', 'Ppscan parameters', ''),
        '0043xx1C': ('SS', '1', 'GE image integrity', ''),
        '0043xx1D': ('SS', '1', 'Level value', ''),
        '0043xx1E': ('DS', '1', 'Delta Start Time [msec]', ''),
        '0043xx1F': ('SL', '1', 'Max overranges in a view', ''),
        '0043xx20': ('DS', '1', 'Avg overranges all views', ''),
        '0043xx21': ('SS', '1', 'Corrected after glow terms', ''),
        '0043xx25': ('SS', '6', 'Reference channels', ''),
        '0043xx26': ('US', '6', 'No views ref chans blocked', ''),
        '0043xx27': ('SH', '1', 'Scan Pitch Ratio', ''),
        '0043xx28': ('OB', '1', 'Unique image iden', ''),
        '0043xx29': ('OB', '1', 'Histogram tables', ''),
        '0043xx2A': ('OB', '1', 'User defined data', ''),
        '0043xx2B': ('SS', '4', 'Private Scan Options', ''),
        '0043xx2C': ('SS', '1', 'Effective echo spacing', ''),
        '0043xx2D': ('SH', '1', 'Filter Mode (String slop field 1 in legacy GE MR', ''),
        '0043xx2E': ('SH', '1', 'String slop field 2', ''),
        '0043xx2F': ('SS', '1', 'Image Type (real, imaginary, phase, magnitude)', ''),
        '0043xx30': ('SS', '1', 'Vas collapse flag', ''),
        '0043xx31': ('DS', '2', 'Recon Center Coordinates', ''),
        '0043xx32': ('SS', '1', 'Vas flags', ''),
        '0043xx33': ('FL', '1', 'Neg_scanspacing', ''),
        '0043xx34': ('IS', '1', 'Offset Frequency', ''),
        '0043xx35': ('UL', '1', 'User_usage_tag', ''),
        '0043xx36': ('UL', '1', 'User_fill_map_MSW', ''),
        '0043xx37': ('UL', '1', 'User_fill_map_LSW', ''),
        '0043xx38': ('FL', '24', 'User data 25...User data 48 {User48=Effective Resolution for spiral}', ''),
        '0043xx39': ('IS', '4', 'Slop_int_6... slop_int_9', ''),
        '0043xx40': ('FL', '4', 'Trigger on position', ''),
        '0043xx41': ('FL', '4', 'Degree of rotation', ''),
        '0043xx42': ('SL', '4', 'DAS trigger source', ''),
        '0043xx43': ('SL', '4', 'DAS fpa gain', ''),
        '0043xx44': ('SL', '4', 'DAS output source', ''),
        '0043xx45': ('SL', '4', 'DAS ad input', ''),
        '0043xx46': ('SL', '4', 'DAS cal mode', ''),
        '0043xx47': ('SL', '4', 'DAS cal frequency', ''),
        '0043xx48': ('SL', '4', 'DAS reg xm', ''),
        '0043xx49': ('SL', '4', 'DAS auto zero', ''),
        '0043xx4A': ('SS', '4', 'Starting channel of view', ''),
        '0043xx4B': ('SL', '4', 'DAS xm pattern', ''),
        '0043xx4C': ('SS', '4', 'TGGC trigger mode', ''),
        '0043xx4D': ('FL', '4', 'Start scan to X-ray on delay', ''),
        '0043xx4E': ('FL', '4', 'Duration of X-ray on', ''),
        '0043xx60': ('IS', '8', 'Slop_int_10...slop_int_17', ''),
        '0043xx61': ('UI', '1', 'Scanner Study Entity UID', ''),
        '0043xx62': ('SH', '1', 'Scanner Study ID', ''),
        '0043xx63': ('SH', '1', 'Raw Data ID', ''),
        '0043xx64': ('CS', '1-n', 'Image Filter', ''),
        '0043xx65': ('US', '1', 'Motion Correction Indicator', ''),
        '0043xx66': ('US', '1', 'Helical Correction Indicator', ''),
        '0043xx67': ('US', '1', 'IBO Correction Indicator', ''),
        '0043xx68': ('US', '1', 'XT Correction Indicator', ''),
        '0043xx69': ('US', '1', 'Q-cal Correction Indicator', ''),
        '0043xx6A': ('US', '1', 'AV Correction Indicator', ''),
        '0043xx6B': ('US', '1', 'L-MDK Correction Indicator', ''),
        '0043xx6C': ('IS', '1', 'Detector Row', ''),
        '0043xx6D': ('IS', '1', 'Area Size', ''),
        '0043xx6E': ('SH', '1', 'Auto mA Mode', ''),
        '0043xx6F': ('DS', '3-4', 'Scanner Table Entry (single gradient coil systems only)/Scanner Table Entry + Gradient Coil Selected', ''),
        '0043xx70': ('LO', '1', 'Paradigm Name', ''),
        '0043xx71': ('ST', '1', 'Paradigm Description', ''),
        '0043xx72': ('UI', '1', 'Paradigm UID', ''),
        '0043xx73': ('US', '1', 'Experiment Type', ''),
        '0043xx74': ('US', '1', '#rest volumes', ''),
        '0043xx75': ('US', '1', '#active volumes', ''),
        '0043xx76': ('US', '1', '#dummy scans', ''),
        '0043xx77': ('SH', '1', 'Application Name', ''),
        '0043xx78': ('SH', '1', 'Application Version', ''),
        '0043xx79': ('US', '1', 'Slices Per Volume', ''),
        '0043xx7A': ('US', '1', 'Expected Time Points', ''),
        '0043xx7B': ('FL', '1-n', 'Regressor Values', ''),
        '0043xx7C': ('FL', '1', 'Delay after slice group', ''),
        '0043xx7D': ('US', '1', 'Recon mode flag word', ''),
        '0043xx7E': ('LO', '1-n', 'PACC specific information', ''),
        '0043xx7F': ('DS', '1-n', 'Reserved', ''),
        '0043xx80': ('LO', '1-n', 'Coil ID Data', ''),
        '0043xx81': ('LO', '1', 'GE Coil Name', ''),
        '0043xx82': ('LO', '1-n', 'System Configuration Information', ''),
        '0043xx83': ('DS', '1-2', 'Asset R Factors', ''),
        '0043xx84': ('LO', '5', 'Additional Asset Data', ''),
        '0043xx85': ('UT', '1', 'Debug Data (text format)', ''),
        '0043xx86': ('OB', '1', 'Debug Data (binary format)', ''),
        '0043xx87': ('UT', '1', 'Reserved', ''),
        '0043xx88': ('UI', '1', 'PURE Acquisition Calibration Series UID', ''),
        '0043xx89': ('LO', '3', 'Governing Body, dB/dt, and SAR definition', ''),
        '0043xx8A': ('CS', '1', 'Private In-Plane Phase Encoding Direction', ''),
        '0043xx8B': ('OB', '1', 'FMRI Binary Data Block', ''),
        '0043xx8C': ('DS', '6', 'Voxel Location', ''),
        '0043xx8D': ('DS', '7-7n', 'SAT Band Locations', ''),
        '0043xx8E': ('DS', '3', 'Spectro Prescan Values', ''),
        '0043xx8F': ('DS', '3', 'Spectro Parameters', ''),
        '0043xx90': ('LO', '1-n', 'SAR Definition', ''),
        '0043xx91': ('DS', '1-n', 'SAR value', ''),
        '0043xx92': ('LO', '1', 'Image Error Text', ''),
        '0043xx93': ('DS', '1-n', 'Spectro Quantitation Values', ''),
        '0043xx94': ('DS', '1-n', 'Spectro Ratio Values', ''),
        '0043xx95': ('LO', '1', 'Prescan Reuse String', ''),
        '0043xx96': ('CS', '1', 'Content Qualification', ''),
        '0043xx97': ('LO', '8', 'Image Filtering Parameters', ''),
        '0043xx98': ('UI', '1', 'ASSET Acquisition Calibration Series UID', ''),
        '0043xx99': ('LO', '1-n', 'Extended Options', ''),
        '0043xx9A': ('IS', '1', 'Rx Stack Identification', ''),
        '0043xx9B': ('DS', '1', 'NPW factor', ''),
        '0043xx9C': ('OB', '1', 'Research Tag 1', ''),
        '0043xx9D': ('OB', '1', 'Research Tag 2', ''),
        '0043xx9E': ('OB', '1', 'Research Tag 3', ''),
        '0043xx9F': ('OB', '1', 'Research Tag 4', ''),
        '0043xxA0': ('SQ', '1', 'Spectroscopy Pixel Sequence', ''),
        '0043xxA1': ('SQ', '1', 'Spectroscopy Default Display Sequence', ''),
        '0043xxA2': ('DS', '1-n', 'MEG Data', ''),
        '0043xxA3': ('CS', '1', 'ASL Contrast technique', ''),
        '0043xxA4': ('LO', '1', 'Detailed text for ASL labeling technique', ''),
        '0043xxA5': ('IS', '1', 'Duration of the label or control pulse', ''),
        '0051xx0A': ('SL', '1', 'Store level of Functional Image', ''),
        '0051xx0B': ('FL', '1', 'Store B-Value with Functional Image', ''),
        '2001xx10': ('UI', '1', 'DICOM Implementation UID', ''),
        '2001xx11': ('SH', '1', 'DICOM Implementation Version', ''),
        '2001xx12': ('UI', '1', 'Within-DICOM-Implementation SOP Instance UID', ''),
        '2001xx13': ('SH', '1', 'Application Name', ''),
        '2001xx14': ('SH', '1', 'Application Version', ''),
        '2001xx15': ('SH', '1', 'Compatibility Version', ''),
        '2001xx21': ('UI', '1-n', 'Referenced Series UID', ''),
        '2001xx31': ('US', '1', 'Number of Objects Averaged', ''),
        '2001xx41': ('US', '1', 'Number of Expected Time Points', ''),
        '2001xx51': ('US', '1', 'Number of Slices Per Volume', ''),
        '2001xx60': ('US', '1', 'BW Image Type', ''),
        '2001xx61': ('US', '1', 'Experiment Type', ''),
        '2001xx71': ('UI', '1', 'Paradigm UID', ''),
        '2001xx72': ('LO', '1', 'Paradigm Name', ''),
        '2001xx73': ('ST', '1', 'Paradigm Description', ''),
        '2001xx80': ('OB', '1', 'Contrast', ''),
        '2001xx81': ('FL', '1-n', 'Regressor Values', ''),
        '2001xx86': ('US', '1', 'Number of Degrees of Freedom', ''),
        '2001xx8A': ('FL', '1', 'Z Threshold', ''),
        '2001xx8B': ('FL', '1', 'p Threshold', ''),
        '2001xx90': ('OB', '1', 'Processing parameters', ''),
        '2001xx91': ('OB', '1', 'Motion Plot', ''),
        '2001xx92': ('OB', '1', 'ROIs', ''),
        '2001xx93': ('OB', '1', 'Tracts', ''),
        '2001xx94': ('OB', '1', 'Report', ''),
        '2001xx95': ('OB', '1', 'Response Data', ''),
        '2001xxA0': ('FL', '1-n', 'Motion Parameters', ''),
        '2001xxA1': ('FL', '1-n', 'Registration Parameters', ''),
        '2001xxA2': ('FL', '1-n', 'Subject Data', ''),
        '2001xxB0': ('OB', '1', 'DTI Parameters', ''),
        '2001xxC0': ('OB', '1', 'Paradigm Info', ''),
    },
    'GEMS_PATI_01': {
        '001110xx': ('LO', '1', 'Private Element Creator', ''),
        '0011xx10': ('SS', '1', 'Patient Status', ''),
    },
    'GEMS_PETD_01': {
        '0009xx01': ('LO', '2', 'GE Discovery PET Implementation Version Name', ''),
        '0009xx02': ('LO', '1', 'PET patient_id', ''),
        '0009xx03': ('SH', '1', 'PET compatible_version', ''),
        '0009xx04': ('SH', '1', 'GE Advance Patient.software_version', ''),
        '0009xx05': ('DT', '1', 'PET patient_datetime', ''),
        '0009xx06': ('SL', '1', 'PET type', ''),
        '0009xx07': ('UI', '1', 'PET exam_id', ''),
        '0009xx08': ('SH', '1', 'PET compatible_version', ''),
        '0009xx09': ('SH', '1', 'PET software_version', ''),
        '0009xx0A': ('UI', '1', 'PET scan_id', ''),
        '0009xx0B': ('SH', '1', 'PET compatible_version', ''),
        '0009xx0C': ('SH', '1', 'PET software_version', ''),
        '0009xx0D': ('DT', '1', 'PET scan_datetime', ''),
        '0009xx0E': ('DT', '1', 'PET scan_ready', ''),
        '0009xx0F': ('ST', '1', 'PET scan_description', ''),
        '0009xx10': ('LO', '1', 'PET hospital_name', ''),
        '0009xx11': ('LO', '1', 'PET scanner_desc', ''),
        '0009xx12': ('LO', '1', 'PET manufacturer', ''),
        '0009xx13': ('UI', '1', 'PET for_identifier', ''),
        '0009xx14': ('LO', '1', 'PET landmark_name', ''),
        '0009xx15': ('SH', '1', 'PET landmark_abbrev', ''),
        '0009xx16': ('SL', '1', 'PET patient_position', ''),
        '0009xx17': ('SL', '1', 'PET scan_perspective', ''),
        '0009xx18': ('SL', '1', 'PET scan_type', ''),
        '0009xx19': ('SL', '1', 'PET scan_mode', ''),
        '0009xx1A': ('SL', '1', 'PET start_condition', ''),
        '0009xx1B': ('SL', '1', 'PET start_cond_data', ''),
        '0009xx1C': ('SL', '1', 'PET sel_stop_cond', ''),
        '0009xx1D': ('SL', '1', 'PET sel_stop_cond_data', ''),
        '0009xx1E': ('SL', '1', 'PET collect_deadtime', ''),
        '0009xx1F': ('SL', '1', 'PET collect_singles', ''),
        '0009xx20': ('SL', '1', 'PET collect_countrate', ''),
        '0009xx21': ('SL', '1', 'PET countrate_period', ''),
        '0009xx22': ('SL', '1', 'PET delayed_events', ''),
        '0009xx23': ('SL', '1', 'PET delayed_bias', ''),
        '0009xx24': ('SL', '1', 'PET word_size', ''),
        '0009xx25': ('SL', '1', 'PET axial_acceptance', ''),
        '0009xx26': ('SL', '1', 'PET axial_angle_3d', ''),
        '0009xx27': ('SL', '1', 'PET theta_compression', ''),
        '0009xx28': ('SL', '1', 'PET axial_compression', ''),
        '0009xx29': ('FL', '1', 'PET gantry_tilt_angle', ''),
        '0009xx2A': ('SL', '1', 'PET collimation', ''),
        '0009xx2B': ('SL', '1', 'PET scan_fov', ''),
        '0009xx2C': ('SL', '1', 'PET axial_fov', ''),
        '0009xx2D': ('SL', '1', 'PET event_separation', ''),
        '0009xx2E': ('SL', '1', 'PET mask_width', ''),
        '0009xx2F': ('SL', '1', 'PET binning_mode', ''),
        '0009xx30': ('SL', '1', 'PET trig_rej_method', ''),
        '0009xx31': ('SL', '1', 'PET number_for_reject', ''),
        '0009xx32': ('SL', '1', 'PET lower_reject_limit', ''),
        '0009xx33': ('SL', '1', 'PET upper_reject_limit', ''),
        '0009xx34': ('SL', '1', 'PET triggers_acquired', ''),
        '0009xx35': ('SL', '1', 'PET triggers_rejected', ''),
        '0009xx36': ('LO', '1', 'PET tracer_name', ''),
        '0009xx37': ('LO', '1', 'PET batch_description', ''),
        '0009xx38': ('FL', '1', 'PET tracer_activity', ''),
        '0009xx39': ('DT', '1', 'PET meas_datetime', ''),
        '0009xx3A': ('FL', '1', 'PET pre_inj_volume', ''),
        '0009xx3B': ('DT', '1', 'PET admin_datetime', ''),
        '0009xx3C': ('FL', '1', 'PET post_inj_activity', ''),
        '0009xx3D': ('DT', '1', 'PET post_inj_datetime', ''),
        '0009xx3E': ('SH', '1', 'PET radionuclide_name', ''),
        '0009xx3F': ('FL', '1', 'PET half_life', ''),
        '0009xx40': ('FL', '1', 'PET positron_fraction', ''),
        '0009xx41': ('SL', '1', 'PET source1_holder', ''),
        '0009xx42': ('FL', '1', 'PET source1_activity', ''),
        '0009xx43': ('DT', '1', 'PET source1_meas_dt', ''),
        '0009xx44': ('SH', '1', 'PET source1_radnuclide', ''),
        '0009xx45': ('FL', '1', 'PET source1_half_life', ''),
        '0009xx46': ('SL', '1', 'PET source2_holder', ''),
        '0009xx47': ('FL', '1', 'PET source2_activity', ''),
        '0009xx48': ('DT', '1', 'PET source2_meas_dt', ''),
        '0009xx49': ('SH', '1', 'PET source2_radnuclide', ''),
        '0009xx4A': ('FL', '1', 'PET source2_half_life', ''),
        '0009xx4B': ('SL', '1', 'PET source_speed', ''),
        '0009xx4C': ('FL', '1', 'PET source_location', ''),
        '0009xx4D': ('SL', '1', 'PET emission_present', ''),
        '0009xx4E': ('SL', '1', 'PET lower_axial_acc', ''),
        '0009xx4F': ('SL', '1', 'PET upper_axial_acc', ''),
        '0009xx50': ('SL', '1', 'PET lower_coinc_limit', ''),
        '0009xx51': ('SL', '1', 'PET upper_coinc_limit', ''),
        '0009xx52': ('SL', '1', 'PET coinc_delay_offset', ''),
        '0009xx53': ('SL', '1', 'PET coinc_output_mode', ''),
        '0009xx54': ('SL', '1', 'PET upper_energy_limit', ''),
        '0009xx55': ('SL', '1', 'PET lower_energy_limit', ''),
        '0009xx56': ('UI', '1', 'PET normal_cal_id', ''),
        '0009xx57': ('UI', '1', 'PET normal_2d_cal_id', ''),
        '0009xx58': ('UI', '1', 'PET blank_cal_id', ''),
        '0009xx59': ('UI', '1', 'PET wc_cal_id', ''),
        '0009xx5A': ('SL', '1', 'PET derived', ''),
        '0009xx5B': ('LO', '1', 'PET contrast_agent', ''),
        '0009xx5C': ('UI', '1', 'PET frame_id', ''),
        '0009xx5D': ('UI', '1', 'PET scan_id', ''),
        '0009xx5E': ('UI', '1', 'PET exam_id', ''),
        '0009xx5F': ('LO', '1', 'PET patient_id', ''),
        '0009xx60': ('SH', '1', 'PET compatible_version', ''),
        '0009xx61': ('SH', '1', 'PET software_version', ''),
        '0009xx62': ('ST', '1', 'PET where_is_frame', ''),
        '0009xx63': ('SL', '1', 'PET frame_size', ''),
        '0009xx64': ('SL', '1', 'PET file_exists', ''),
        '0009xx65': ('SL', '1', 'PET patient_entry', ''),
        '0009xx66': ('FL', '1', 'PET table_height', ''),
        '0009xx67': ('FL', '1', 'PET table_z_position', ''),
        '0009xx68': ('DT', '1', 'PET landmark_datetime', ''),
        '0009xx69': ('SL', '1', 'PET slice_count', ''),
        '0009xx6A': ('FL', '1', 'PET start_location', ''),
        '0009xx6B': ('SL', '1', 'PET acq_delay', ''),
        '0009xx6C': ('DT', '1', 'PET acq_start', ''),
        '0009xx6D': ('SL', '1', 'PET acq_duration', ''),
        '0009xx6E': ('SL', '1', 'PET acq_bin_dur', ''),
        '0009xx6F': ('SL', '1', 'PET acq_bin_start', ''),
        '0009xx70': ('SL', '1', 'PET actual_stop_cond', ''),
        '0009xx71': ('FD', '1', 'PET total_prompts', ''),
        '0009xx72': ('FD', '1', 'PET total_delays', ''),
        '0009xx73': ('SL', '1', 'PET frame_valid', ''),
        '0009xx74': ('SL', '1', 'PET validity_info', ''),
        '0009xx75': ('SL', '1', 'PET archived', ''),
        '0009xx76': ('SL', '1', 'PET compression', ''),
        '0009xx77': ('SL', '1', 'PET uncompressed_size', ''),
        '0009xx78': ('SL', '1', 'PET accum_bin_dur', ''),
        '0009xx79': ('SH', '1', 'PET compatible_version', ''),
        '0009xx7A': ('SH', '1', 'PET software_version', ''),
        '0009xx7B': ('DT', '1', 'PET is_datetime', ''),
        '0009xx7C': ('SL', '1', 'PET is_source', ''),
        '0009xx7D': ('SL', '1', 'PET is_contents', ''),
        '0009xx7E': ('SL', '1', 'PET is_type', ''),
        '0009xx7F': ('DS', '3', 'PET is_reference', ''),
        '0009xx80': ('SL', '1', 'PET multi_patient', ''),
        '0009xx81': ('SL', '1', 'PET number_of_normals', ''),
        '0009xx82': ('UI', '1', 'PET color_map_id', ''),
        '0009xx83': ('SL', '1', 'PET window_level_type', ''),
        '0009xx84': ('FL', '1', 'PET rotate', ''),
        '0009xx85': ('SL', '1', 'PET flip', ''),
        '0009xx86': ('FL', '1', 'PET zoom', ''),
        '0009xx87': ('SL', '1', 'PET pan_x', ''),
        '0009xx88': ('SL', '1', 'PET pan_y', ''),
        '0009xx89': ('FL', '1', 'PET window_level_min', ''),
        '0009xx8A': ('FL', '1', 'PET window_level_max', ''),
        '0009xx8B': ('SL', '1', 'PET recon_method', ''),
        '0009xx8C': ('SL', '1', 'PET attenuation', ''),
        '0009xx8D': ('FL', '1', 'PET atten_coefficient', ''),
        '0009xx8E': ('SL', '1', 'PET bp_filter', ''),
        '0009xx8F': ('FL', '1', 'PET bp_filter_cutoff', ''),
        '0009xx90': ('SL', '1', 'PET bp_filter_order', ''),
        '0009xx91': ('FL', '1', 'PET bp_center_l', ''),
        '0009xx92': ('FL', '1', 'PET bp_center_p', ''),
        '0009xx93': ('SL', '1', 'PET atten_smooth', ''),
        '0009xx94': ('SL', '1', 'PET atten_smooth_param', ''),
        '0009xx95': ('SL', '1', 'PET angle_smooth_param', ''),
        '0009xx96': ('UI', '1', 'PET wellcountercal_id', ''),
        '0009xx97': ('UI', '1', 'PET trans_scan_id', ''),
        '0009xx98': ('UI', '1', 'PET norm_cal_id', ''),
        '0009xx99': ('UI', '1', 'PET blnk_cal_id', ''),
        '0009xx9A': ('FL', '1', 'PET cac_edge_threshold', ''),
        '0009xx9B': ('FL', '1', 'PET cac_skull_offset', ''),
        '0009xx9C': ('UI', '1', 'PET emiss_sub_id', ''),
        '0009xx9D': ('SL', '1', 'PET radial_filter_3d', ''),
        '0009xx9E': ('FL', '1', 'PET radial_cutoff_3d', ''),
        '0009xx9F': ('SL', '1', 'PET axial_filter_3d', ''),
        '0009xxA0': ('FL', '1', 'PET axial_cutoff_3d', ''),
        '0009xxA1': ('FL', '1', 'PET axial_start', ''),
        '0009xxA2': ('FL', '1', 'PET axial_spacing', ''),
        '0009xxA3': ('SL', '1', 'PET axial_angles_used', ''),
        '0009xxA4': ('SH', '1', 'PET compatible_version', ''),
        '0009xxA5': ('SH', '1', 'PET software_version', ''),
        '0009xxA6': ('SL', '1', 'PET slice_number', ''),
        '0009xxA7': ('FL', '1', 'PET total_counts', ''),
        '0009xxA8': ('OB', '1', 'PET other_atts', ''),
        '0009xxA9': ('SL', '1', 'PET other_atts_size', ''),
        '0009xxAA': ('SL', '1', 'PET archived', ''),
        '0009xxAB': ('FL', '1', 'PET bp_center_x', ''),
        '0009xxAC': ('FL', '1', 'PET bp_center_y', ''),
        '0009xxAD': ('UI', '1', 'PET trans_frame_id', ''),
        '0009xxAE': ('UI', '1', 'PET tpluse_frame_id', ''),
        '0009xxB1': ('FL', '1', 'PET profile_spacing', ''),
        '0009xxB2': ('SL', '1', 'PET ir_num_iterations', ''),
        '0009xxB3': ('SL', '1', 'PET ir_num_subsets', ''),
        '0009xxB4': ('FL', '1', 'PET ir_recon_fov', ''),
        '0009xxB5': ('SL', '1', 'PET ir_corr_model', ''),
        '0009xxB6': ('SL', '1', 'PET ir_loop_filter', ''),
        '0009xxB7': ('FL', '1', 'PET ir_pre_filt_parm', ''),
        '0009xxB8': ('SL', '1', 'PET ir_loop_filt_parm', ''),
        '0009xxB9': ('FL', '1', 'PET response_filt_parm', ''),
        '0009xxBA': ('SL', '1', 'PET post_filter', ''),
        '0009xxBB': ('FL', '1', 'PET post_filt_parm', ''),
        '0009xxBC': ('SL', '1', 'PET ir_regularize', ''),
        '0009xxBD': ('FL', '1', 'PET regularize_parm', ''),
        '0009xxBE': ('SL', '1', 'PET ac_bp_filter', ''),
        '0009xxBF': ('FL', '1', 'PET ac_bp_filt_cut_off', ''),
        '0009xxC0': ('SL', '1', 'PET ac_bp_filt_order', ''),
        '0009xxC1': ('SL', '1', 'PET ac_img_smooth', ''),
        '0009xxC2': ('FL', '1', 'PET ac_img_smooth_parm', ''),
        '0009xxC3': ('SL', '1', 'PET scatter_method', ''),
        '0009xxC4': ('SL', '1', 'PET scatter_num_iter', ''),
        '0009xxC5': ('FL', '1', 'PET scatter_parm', ''),
        '0009xxC6': ('FL', '1', 'PET seg_qc_parm', ''),
        '0009xxC7': ('SL', '1', 'PET overlap', ''),
        '0009xxC8': ('UI', '1', 'PET ovlp_frm_id', ''),
        '0009xxC9': ('UI', '1', 'PET ovlp_trans_frm_id', ''),
        '0009xxCA': ('UI', '1', 'PET ovlp_tpulse_frm_id', ''),
        '0009xxCB': ('FL', '1', 'PET vqc_x_axis_trans', ''),
        '0009xxCC': ('FL', '1', 'PET vqc_x_axis_tilt', ''),
        '0009xxCD': ('FL', '1', 'PET vqc_y_axis_trans', ''),
        '0009xxCE': ('FL', '1', 'PET vqc_y_axis_swivel', ''),
        '0009xxCF': ('FL', '1', 'PET vqc_z_axis_trans', ''),
        '0009xxD0': ('FL', '1', 'PET vqc_z_axis_roll', ''),
        '0009xxD1': ('LO', '1', 'PET ctac_conv_scale', ''),
        '0009xxD2': ('UI', '1', 'PET image_set_id', ''),
        '0009xxD3': ('SL', '1', 'PET constrast_route', ''),
        '0009xxD4': ('LO', '1', 'PET ctac_conv_scale', ''),
        '0009xxD5': ('FL', '1', 'PET loop_filter_parm', ''),
        '0009xxD6': ('FL', '1', 'PET image_one_loc', ''),
        '0009xxD7': ('FL', '1', 'PET image_index_loc', ''),
        '0009xxD8': ('SL', '1', 'PET frame_number', ''),
        '0009xxD9': ('SL', '1', 'PET list_file_exists', ''),
        '0009xxDA': ('ST', '1', 'PET where_is_list_frame', ''),
        '0009xxDB': ('SL', '1', 'PET ir_z_filter_flag', ''),
        '0009xxDC': ('FL', '1', 'PET ir_z_filter_ratio', ''),
        '0009xxDD': ('US', '1', 'PET num_of_rr_interval', ''),
        '0009xxDE': ('US', '1', 'PET num_of_time_slots', ''),
        '0009xxDF': ('US', '1', 'PET num_of_slices', ''),
        '0009xxE0': ('US', '1', 'PET num_of_time_slices', ''),
        '0009xxE1': ('SL', '1', 'PET unlisted_scan', ''),
        '0009xxE2': ('SL', '1', 'PET rest_stress', ''),
        '0009xxE3': ('FL', '1', 'PET phase percentage', ''),
        '0009xxE4': ('ST', '1', 'Recon Protocol', ''),
        '0009xxE5': ('FL', '1', 'PET left shift', ''),
        '0009xxE6': ('FL', '1', 'PET posterior shift', ''),
        '0009xxE7': ('FL', '1', 'PET superior shift', ''),
        '0009xxE8': ('SL', '1', 'PET acq_bin_num', ''),
        '0009xxE9': ('FL', '1', 'PET acq_bin_dur_percent', ''),
        '0009xxEA': ('SL', '1', '3D Filter flag', ''),
        '0009xxEB': ('FL', '1', '3D Filter cutoff', ''),
        '0009xxEC': ('SL', '1', '3D Filter order', ''),
        '0009xxF0': ('UI', '1', 'Reformat group', ''),
        '0011xx01': ('SQ', '1', 'GE Advance ROI Sequence', ''),
        '0011xx02': ('UI', '1', 'GE Advance ROI.roi_id', ''),
        '0011xx03': ('UI', '1', 'GE Advance ROI.image_id', ''),
        '0011xx04': ('SH', '1', 'GE Advance ROI.compatible_version', ''),
        '0011xx05': ('SH', '1', 'GE Advance ROI.software_version', ''),
        '0011xx06': ('LO', '1', 'GE Advance ROI.roi_name', ''),
        '0011xx07': ('DT', '1', 'GE Advance ROI.roi_datetime', ''),
        '0011xx08': ('SL', '1', 'GE Advance ROI.roi_type', ''),
        '0011xx09': ('FL', '1', 'GE Advance ROI.center_x', ''),
        '0011xx0A': ('FL', '1', 'GE Advance ROI.center_y', ''),
        '0011xx0B': ('FL', '1', 'GE Advance ROI.width', ''),
        '0011xx0C': ('FL', '1', 'GE Advance ROI.height', ''),
        '0011xx0D': ('FL', '1', 'GE Advance ROI.angle', ''),
        '0011xx0E': ('SL', '1', 'GE Advance ROI.number_of_points', ''),
        '0011xx0F': ('OB', '1', 'GE Advance ROI.roi_data', ''),
        '0011xx10': ('SL', '1', 'GE Advance ROI.roi_size', ''),
        '0011xx11': ('LO', '1', 'GE Advance ROI.color', ''),
        '0011xx12': ('SL', '1', 'GE Advance ROI.line_type', ''),
        '0011xx13': ('SL', '1', 'GE Advance ROI.line_width', ''),
        '0011xx14': ('SL', '1', 'GE Advance ROI.roi_number', ''),
        '0011xx15': ('SL', '1', 'GE Advance ROI.convex', ''),
        '0011xx16': ('SL', '1', 'GE Advance ROI.atten_corr_flag', ''),
        '0011xx18': ('OB', '1', 'Unknown', ''),
        '0013xx01': ('SQ', '1', 'GE Advance Annotation Sequence', ''),
        '0013xx02': ('UI', '1', 'GE Advance Annotation.annotation_id', ''),
        '0013xx03': ('UI', '1', 'GE Advance Annotation.image_id', ''),
        '0013xx04': ('SH', '1', 'GE Advance Annotation.compatible_version', ''),
        '0013xx05': ('SH', '1', 'GE Advance Annotation.software_version', ''),
        '0013xx06': ('SL', '1', 'GE Advance Annotation.type', ''),
        '0013xx07': ('LO', '1', 'GE Advance Annotation.font_name', ''),
        '0013xx08': ('SH', '1', 'GE Advance Annotation.font_size', ''),
        '0013xx09': ('LO', '1', 'GE Advance Annotation.foreground_color', ''),
        '0013xx0A': ('LO', '1', 'GE Advance Annotation.background_color', ''),
        '0013xx0B': ('SL', '1', 'GE Advance Annotation.coordinate_system', ''),
        '0013xx0C': ('FL', '1', 'GE Advance Annotation.start_x', ''),
        '0013xx0D': ('FL', '1', 'GE Advance Annotation.start_y', ''),
        '0013xx0E': ('FL', '1', 'GE Advance Annotation.end_x', ''),
        '0013xx0F': ('FL', '1', 'GE Advance Annotation.end_y', ''),
        '0013xx10': ('SL', '1', 'GE Advance Annotation.start_symbol', ''),
        '0013xx11': ('SL', '1', 'GE Advance Annotation.end_symbol', ''),
        '0013xx12': ('OB', '1', 'GE Advance Annotation.annotation_data', ''),
        '0013xx13': ('SL', '1', 'GE Advance Annotation.annotation_size', ''),
        '0013xx14': ('LO', '1', 'GE Advance Annotation.label_id', ''),
        '0017xx01': ('UI', '1', 'PET correction_cal_id', ''),
        '0017xx02': ('SH', '1', 'PET compatible_version', ''),
        '0017xx03': ('SH', '1', 'PET software_version', ''),
        '0017xx04': ('DT', '1', 'PET cal_datetime', ''),
        '0017xx05': ('LO', '1', 'PET cal_description', ''),
        '0017xx06': ('SL', '1', 'PET cal_type', ''),
        '0017xx07': ('ST', '1', 'PET where_is_corr', ''),
        '0017xx08': ('SL', '1', 'PET corr_file_size', ''),
        '0017xx09': ('LO', '1', 'PET scan_id', ''),
        '0017xx0A': ('DT', '1', 'PET scan_datetime', ''),
        '0017xx0B': ('LO', '1', 'PET norm_2d_cal_id', ''),
        '0017xx0C': ('SH', '1', 'PET hosp_identifier', ''),
        '0017xx0D': ('SL', '1', 'PET archived', ''),
        '0019xx01': ('UI', '1', 'PET wc_cal_id', ''),
        '0019xx02': ('SH', '1', 'PET compatible_version', ''),
        '0019xx03': ('SH', '1', 'PET software_version', ''),
        '0019xx04': ('DT', '1', 'PET cal_datetime', ''),
        '0019xx05': ('SL', '1', 'PET cal_type', ''),
        '0019xx06': ('LO', '1', 'PET cal_description', ''),
        '0019xx07': ('LO', '1', 'PET cal_hardware', ''),
        '0019xx08': ('OB', '1', 'PET coefficients', ''),
        '0019xx09': ('FL', '1', 'PET activity_factor_hr', ''),
        '0019xx0A': ('FL', '1', 'PET activity_factor_hs', ''),
        '0019xx0B': ('FL', '1', 'PET activity_factor_3d', ''),
        '0019xx0C': ('LO', '1', 'PET scan_id', ''),
        '0019xx0D': ('DT', '1', 'PET scan_datetime', ''),
        '0019xx0E': ('SH', '1', 'PET hosp_identifier', ''),
        '0019xx0F': ('FL', '1', 'PET meas_activity', ''),
        '0019xx10': ('DT', '1', 'PET meas_datetime', ''),
        '0019xx11': ('SL', '1', 'PET axial_filter_3d', ''),
        '0019xx12': ('FL', '1', 'PET axial_cutoff_3d', ''),
        '0019xx13': ('SL', '1', 'PET default_flag', ''),
        '0019xx14': ('SL', '1', 'PET archived', ''),
        '0019xx15': ('SL', '1', 'PET wc_cal_rec_method', ''),
        '0019xx16': ('SL', '1', 'PET activity_factor_2d', ''),
        '0019xx17': ('SL', '1', 'PET isotope', ''),
        '0021xx01': ('US', '1', 'PET raw_data_type', ''),
        '0021xx02': ('UL', '1', 'PET raw_data_size', ''),
        '0023xx01': ('OB', '1', 'raw_data_blob', ''),
        '0023xx02': ('OB', '1', 'PET raw_data_blob', ''),
        '5001xx01': ('UI', '1', 'GE Advance Curve.curve_id', ''),
        '5001xx02': ('SH', '1', 'GE Advance Curve.compatible_version', ''),
        '5001xx03': ('SH', '1', 'GE Advance Curve.software_version', ''),
        '5001xx04': ('SL', '1', 'GE Advance Curve.statistics_type', ''),
        '5001xx05': ('LT', '1', 'GE Advance Curve.how_derived', ''),
        '5001xx06': ('SL', '1', 'GE Advance Curve.how_derived_size', ''),
        '5001xx07': ('SL', '1', 'GE Advance Curve.multi_patient', ''),
        '5001xx08': ('SL', '1', 'GE Advance Curve.deadtime', ''),
        '5003xx01': ('SQ', '1', 'GE Advance Graph Sequence', ''),
        '5003xx02': ('UI', '1', 'GE Advance Graph.graph_id', ''),
        '5003xx03': ('SH', '1', 'GE Advance Graph.compatible_version', ''),
        '5003xx04': ('SH', '1', 'GE Advance Graph.software_version', ''),
        '5003xx05': ('LO', '1', 'GE Advance Graph.title', ''),
        '5003xx06': ('DT', '1', 'GE Advance Graph.graph_datetime', ''),
        '5003xx07': ('ST', '1', 'GE Advance Graph.graph_description', ''),
        '5003xx08': ('LO', '1', 'GE Advance Graph.title_font_name', ''),
        '5003xx09': ('SH', '1', 'GE Advance Graph.title_font_size', ''),
        '5003xx0A': ('LO', '1', 'GE Advance Graph.footer', ''),
        '5003xx0B': ('SH', '1', 'GE Advance Graph.footer_font_size', ''),
        '5003xx0C': ('LO', '1', 'GE Advance Graph.foreground_color', ''),
        '5003xx0D': ('LO', '1', 'GE Advance Graph.background_color', ''),
        '5003xx0E': ('SL', '1', 'GE Advance Graph.graph_border', ''),
        '5003xx0F': ('SL', '1', 'GE Advance Graph.graph_width', ''),
        '5003xx10': ('SL', '1', 'GE Advance Graph.graph_height', ''),
        '5003xx11': ('SL', '1', 'GE Advance Graph.grid', ''),
        '5003xx12': ('LO', '1', 'GE Advance Graph.label_font_name', ''),
        '5003xx13': ('SH', '1', 'GE Advance Graph.label_font_size', ''),
        '5003xx14': ('LO', '1', 'GE Advance Graph.axes_color', ''),
        '5003xx15': ('LO', '1', 'GE Advance Graph.x_axis_label', ''),
        '5003xx16': ('SL', '1', 'GE Advance Graph.x_axis_units', ''),
        '5003xx17': ('FL', '1', 'GE Advance Graph.x_major_tics', ''),
        '5003xx18': ('FL', '1', 'GE Advance Graph.x_axis_min', ''),
        '5003xx19': ('FL', '1', 'GE Advance Graph.x_axis_max', ''),
        '5003xx1A': ('LO', '1', 'GE Advance Graph.y_axis_label', ''),
        '5003xx1B': ('SL', '1', 'GE Advance Graph.y_axis_units', ''),
        '5003xx1C': ('FL', '1', 'GE Advance Graph.y_major_tics', ''),
        '5003xx1D': ('FL', '1', 'GE Advance Graph.y_axis_min', ''),
        '5003xx1E': ('FL', '1', 'GE Advance Graph.y_axis_max', ''),
        '5003xx1F': ('LO', '1', 'GE Advance Graph.legend_font_name', ''),
        '5003xx20': ('SH', '1', 'GE Advance Graph.legend_font_size', ''),
        '5003xx21': ('SL', '1', 'GE Advance Graph.legend_location_x', ''),
        '5003xx22': ('SL', '1', 'GE Advance Graph.legend_location_y', ''),
        '5003xx23': ('SL', '1', 'GE Advance Graph.legend_width', ''),
        '5003xx24': ('SL', '1', 'GE Advance Graph.legend_height', ''),
        '5003xx25': ('SL', '1', 'GE Advance Graph.legend_border', ''),
        '5003xx26': ('SL', '1', 'GE Advance Graph.multi_patient', ''),
        '5005xx01': ('SQ', '1', 'GE Advance CurvePresentation Sequence', ''),
        '5005xx02': ('UI', '1', 'GE Advance CurvePresentation.curvepresent_id', ''),
        '5005xx03': ('UI', '1', 'GE Advance CurvePresentation.graph_id', ''),
        '5005xx04': ('UI', '1', 'GE Advance CurvePresentation.curve_id', ''),
        '5005xx05': ('SH', '1', 'GE Advance CurvePresentation.compatible_version', ''),
        '5005xx06': ('SH', '1', 'GE Advance CurvePresentation.software_version', ''),
        '5005xx07': ('LO', '1', 'GE Advance CurvePresentation.curve_label', ''),
        '5005xx08': ('LO', '1', 'GE Advance CurvePresentation.color', ''),
        '5005xx09': ('SL', '1', 'GE Advance CurvePresentation.line_type', ''),
        '5005xx0A': ('SL', '1', 'GE Advance CurvePresentation.line_width', ''),
        '5005xx0B': ('SL', '1', 'GE Advance CurvePresentation.point_symbol', ''),
        '5005xx0C': ('SL', '1', 'GE Advance CurvePresentation.point_symbol_dim', ''),
        '5005xx0D': ('LO', '1', 'GE Advance CurvePresentation.point_color', ''),
    },
    'GEMS_QVA_PHOTO_01': {
        '0009xx60': ('FL', '1', 'Dodge End Diastolic Volume ml', ''),
        '0009xx61': ('FL', '1', 'Dodge End Systolic Volume ml', ''),
        '0009xx62': ('FL', '1', 'Dodge Stroke Volume ml', ''),
        '0009xx63': ('IS', '1', 'Dodge Ejection Fraction', ''),
        '0009xx64': ('FL', '1', 'Simpson End Diastolic Volume ml', ''),
        '0009xx65': ('FL', '1', 'Simpson End Systolic Volume ml', ''),
        '0009xx66': ('FL', '1', 'Simpson Stroke Volume ml', ''),
        '0009xx67': ('IS', '1', 'Simpson Ejection Fraction', ''),
        '0009xx68': ('FL', '1', 'CFX Single Hypokinesia in Region', ''),
        '0009xx69': ('FL', '1', 'CFX Single Hyperkinesia in Opposite Region', ''),
        '0009xx6A': ('IS', '1', 'CFX Single Total LV contour Percent', ''),
        '0009xx6B': ('FL', '1', 'CFX Multiple Hypokinesia in Region', ''),
        '0009xx6C': ('FL', '1', 'CFX Multiple Hyperkinesia in Opposite Region', ''),
        '0009xx6D': ('IS', '1', 'CFX Multiple Total LV contour Percent', ''),
        '0009xx6E': ('FL', '1', 'RCA Single Hypokinesia in Region', ''),
        '0009xx6F': ('FL', '1', 'RCA Single Hyperkinesia in Opposite Region', ''),
        '0009xx70': ('IS', '1', 'RCA Single Total LV contour Percent', ''),
        '0009xx71': ('FL', '1', 'RCA Multiple Hypokinesia in Region', ''),
        '0009xx72': ('FL', '1', 'RCA Multiple Hyperkinesia in Opposite Region', ''),
        '0009xx73': ('IS', '1', 'RCA Multiple Total LV contour Percent', ''),
        '0009xx74': ('FL', '1', 'LAD Single Hypokinesia in Region', ''),
        '0009xx75': ('FL', '1', 'LAD Single Hyperkinesia in Opposite Region', ''),
        '0009xx76': ('IS', '1', 'LAD Single Total LV contour Percent', ''),
        '0009xx77': ('FL', '1', 'LAD Multiple Hypokinesia in Region', ''),
        '0009xx78': ('FL', '1', 'LAD Multiple Hyperkinesia in Opposite Region', ''),
        '0009xx79': ('IS', '1', 'LAD Multiple Total LV contour Percent', ''),
        '0009xx7A': ('FL', '1', 'Dodge End Diastolic Volume ml/m2', ''),
        '0009xx7C': ('FL', '1', 'Dodge End Systolic Volume ml/m2', ''),
        '0009xx7E': ('FL', '1', 'Dodge Stroke Volume ml/m2', ''),
        '0009xx80': ('FL', '1', 'Simpson End Diastolic Volume ml/m2', ''),
        '0009xx82': ('FL', '1', 'Simpson End Systolic Volume ml/m2', ''),
        '0009xx84': ('FL', '1', 'Simpson Stroke Volume ml/m2', ''),
    },
    'GEMS_RELA_01': {
        '002110xx': ('LO', '1', 'Private Element Creator', ''),
        '0021xx03': ('SS', '1', 'Series from which Prescribed', ''),
        '0021xx05': ('SH', '1', 'Genesis Version - now', ''),
        '0021xx07': ('UL', '1', 'Series Record checksum', ''),
        '0021xx15': ('US', '1', 'Unknown', ''),
        '0021xx16': ('SS', '1', 'Unknown', ''),
        '0021xx18': ('SH', '1', 'Genesis version - Now', ''),
        '0021xx19': ('UL', '1', 'Acq recon record checksum', ''),
        '0021xx20': ('DS', '1', 'Table start location', ''),
        '0021xx35': ('SS', '1', 'Series from which prescribed', ''),
        '0021xx36': ('SS', '1', 'Image from which prescribed', ''),
        '0021xx37': ('SS', '1', 'Screen Format', ''),
        '0021xx4A': ('LO', '1', 'Anatomical reference for scout', ''),
        '0021xx4E': ('US', '1', 'Unknown', ''),
        '0021xx4F': ('SS', '1', 'Locations in acquisition', ''),
        '0021xx50': ('SS', '1', 'Graphically prescribed', ''),
        '0021xx51': ('DS', '1', 'Rotation from source x rot', ''),
        '0021xx52': ('DS', '1', 'Rotation from source y rot', ''),
        '0021xx53': ('DS', '1', 'Rotation from source z rot', ''),
        '0021xx54': ('SH', '3', 'Image position', ''),
        '0021xx55': ('SH', '6', 'Image orientation', ''),
        '0021xx56': ('SL', '1', 'Num 3D slabs', ''),
        '0021xx57': ('SL', '1', 'Locs per 3D slab', ''),
        '0021xx58': ('SL', '1', 'Overlaps', ''),
        '0021xx59': ('SL', '1', 'Image Filtering 0.5/0.2T', ''),
        '0021xx5A': ('SL', '1', 'Diffusion direction', ''),
        '0021xx5B': ('DS', '1', 'Tagging Flip Angle', ''),
        '0021xx5C': ('DS', '1', 'Tagging Orientation', ''),
        '0021xx5D': ('DS', '1', 'Tag Spacing', ''),
        '0021xx5E': ('DS', '1', 'RTIA_timer', ''),
        '0021xx5F': ('DS', '1', 'Fps', ''),
        '0021xx70': ('LT', '1', 'Unknown', ''),
        '0021xx71': ('LT', '1', 'Unknown', ''),
        '0021xx81': ('DS', '1', 'Auto window/level alpha', ''),
        '0021xx82': ('DS', '1', 'Auto window/level beta', ''),
        '0021xx83': ('DS', '1', 'Auto window/level window', ''),
        '0021xx84': ('DS', '1', 'Auto window/level level', ''),
        '0021xx90': ('SS', '1', 'Tube focal spot position', ''),
        '0021xx91': ('SS', '1', 'Biopsy position', ''),
        '0021xx92': ('FL', '1', 'Biopsy T location', ''),
        '0021xx93': ('FL', '1', 'Biopsy ref location', ''),
    },
    'GEMS_RTEN_01': {
        '0249xx11': ('DA', '1', 'Plan Creation Date', ''),
        '0249xx13': ('TM', '1', 'Plan Creation Time', ''),
        '0249xx14': ('PN', '1', 'Operator Name', ''),
        '0249xx16': ('LO', '1', 'Plan Comment', ''),
        '0249xx18': ('SQ', '1', 'Plan Image Sequence', ''),
        '0249xx1A': ('LO', '1', 'Exam/Series/Image Identifier', ''),
        '0249xx1B': ('IS', '1', 'Additional Image Identifier', ''),
        '0249xx1C': ('CS', '1', 'Build Resolution', ''),
        '0249xx20': ('SQ', '1', 'Structure Sequence', ''),
        '0249xx22': ('SH', '1', 'Structure Name', ''),
        '0249xx24': ('CS', '1', 'Structure Type', ''),
        '0249xx28': ('CS', '1', 'Structure Color', ''),
        '0249xx30': ('SQ', '1', 'Slab Sequence', ''),
        '0249xx32': ('SQ', '1', 'Slab Image Sequence', ''),
        '0249xx36': ('DS', '1', 'Z Plus Thickness', ''),
        '0249xx38': ('DS', '1', 'Z Minus Thickness', ''),
        '0249xx3A': ('DS', '3-n', 'Slab Shape', ''),
        '0249xx40': ('SQ', '1', 'Marker Sequence', ''),
        '0249xx42': ('SH', '1', 'Marker Name', ''),
        '0249xx44': ('CS', '1', 'Marker Color', ''),
        '0249xx46': ('DS', '3', 'Marker Position', ''),
        '0249xx50': ('SQ', '1', 'Beam Group Sequence', ''),
        '0249xx51': ('SH', '1', 'Group Name', ''),
        '0249xx52': ('CS', '1-n', 'Group Properties', ''),
        '0249xx54': ('SQ', '1', 'Beam Sequence', ''),
        '0249xx60': ('SQ', '1', 'Machine Reference Sequence', ''),
        '0249xx62': ('SH', '1', 'Machine Name', ''),
        '0249xx64': ('SH', '1', 'Beam Name', ''),
        '0249xx66': ('CS', '1', 'Particle Type', ''),
        '0249xx68': ('DS', '1', 'Nominal Particle Energy', ''),
        '0249xx70': ('SQ', '1', 'Block Sequence', ''),
        '0249xx72': ('LO', '1', 'Block Name', ''),
        '0249xx74': ('DS', '2-n', 'Block Shape', ''),
        '0249xx80': ('SQ', '1', 'Cutout Sequence', ''),
        '0249xx82': ('LO', '1', 'Cutout Name', ''),
        '0249xx84': ('DS', '2-n', 'Cutout Shape', ''),
        '0249xx90': ('SH', '1', 'Collimator Name', ''),
        '0249xx92': ('CS', '1', 'Collimator Type', ''),
        '0249xxA0': ('SQ', '1', 'Dynamic Segment Sequence', ''),
        '0249xxA2': ('DS', '1', 'Table Angle', ''),
        '0249xxA4': ('DS', '1', 'Gantry Angle', ''),
        '0249xxA6': ('DS', '1', 'Collimator Angle', ''),
        '0249xxA8': ('DS', '3', 'Isocenter Position', ''),
        '0249xxA9': ('DS', '1', 'Source-Surface Distance', ''),
        '0249xxAA': ('DS', '1', 'X Symmetric Opening', ''),
        '0249xxAC': ('DS', '1', 'Y Symmetric Opening', ''),
        '0249xxAE': ('DS', '1', 'X Positive Jaw Position', ''),
        '0249xxB0': ('DS', '1', 'X Negative Jaw Position', ''),
        '0249xxB2': ('DS', '1', 'Y Positive Jaw Position', ''),
        '0249xxB4': ('DS', '1', 'Y Negative Jaw Position', ''),
        '0249xxB6': ('DS', '2-n', 'Leaf Positions', ''),
        '0249xxD0': ('CS', '1', 'Treatment Position', ''),
    },
    'GEMS_SENO_02': {
        '0045xx04': ('CS', '1', 'AES', ''),
        '0045xx06': ('DS', '1', 'Stereo angle', ''),
        '0045xx09': ('DS', '1', 'Real Magnification Factor', ''),
        '0045xx0B': ('CS', '1', 'Senograph Type', ''),
        '0045xx0C': ('DS', '1', 'Integration Time', ''),
        '0045xx0D': ('DS', '1', 'ROI Origin X and Y', ''),
        '0045xx11': ('DS', '2', 'Receptor Size cm X and Y', ''),
        '0045xx12': ('IS', '2', 'Receptor Size Pixels X and Y', ''),
        '0045xx13': ('ST', '1', 'Screen', ''),
        '0045xx14': ('DS', '1', 'Pixel Pitch Microns', ''),
        '0045xx15': ('IS', '1', 'Pixel Depth Bits', ''),
        '0045xx16': ('IS', '2', 'Binning Factor X and Y', ''),
        '0045xx1B': ('LO', '1', 'Clinical View', ''),
        '0045xx1D': ('DS', '1', 'Mean Of Raw Gray Levels', ''),
        '0045xx1E': ('DS', '1', 'Mean Of Offset Gray Levels', ''),
        '0045xx1F': ('DS', '1', 'Mean Of Corrected Gray Levels', ''),
        '0045xx20': ('DS', '1', 'Estimated Anat mean', ''),
        '0045xx21': ('DS', '1', 'Mean Of Log Region Gray Levels', ''),
        '0045xx22': ('DS', '1', 'Standard Deviation Of Raw Gray Levels', ''),
        '0045xx23': ('DS', '1', 'Standard Deviation Of Corrected Gray Levels', ''),
        '0045xx24': ('DS', '1', 'Standard Deviation Of Region Gray Levels', ''),
        '0045xx25': ('DS', '1', 'Standard Deviation Of Log Region Gray Levels', ''),
        '0045xx26': ('OB', '1', 'MAO Buffer', ''),
        '0045xx27': ('IS', '1', 'Set Number', ''),
        '0045xx28': ('CS', '1', 'WindowingType (LINEAR or GAMMA)', ''),
        '0045xx29': ('DS', '2', 'Windowing parameters', ''),
        '0045xx2A': ('IS', '1', '2DLocX', ''),
        '0045xx2B': ('IS', '1', '2DLocY', ''),
        '0045xx39': ('US', '1', 'Vignette Rows', ''),
        '0045xx3A': ('US', '1', 'Vignette Columns', ''),
        '0045xx3B': ('US', '1', 'Vignette Bits Allocated', ''),
        '0045xx3C': ('US', '1', 'Vignette Bits Stored', ''),
        '0045xx3D': ('US', '1', 'Vignette High Bit', ''),
        '0045xx3E': ('US', '1', 'Vignette Pixel Representation', ''),
        '0045xx3F': ('OB', '1', 'Vignette Pixel Data', ''),
        '0045xx49': ('DS', '1', 'Radiological Thickness', ''),
        '0045xx50': ('UI', '1', 'SC Instance UID', ''),
        '0045xx51': ('UI', '1', 'SC series UID', ''),
        '0045xx52': ('IS', '1', 'Raw Diagnostic Low', ''),
        '0045xx53': ('IS', '1', 'Raw Diagnostic High', ''),
        '0045xx54': ('DS', '1', 'Exponent', ''),
        '0045xx55': ('IS', '1', 'A Coefficients', ''),
        '0045xx56': ('DS', '1', 'Noise Reduction Sensitivity', ''),
        '0045xx57': ('DS', '1', 'Noise Reduction Threshold', ''),
        '0045xx58': ('DS', '1', 'mu', ''),
        '0045xx59': ('IS', '1', 'Threshold', ''),
        '0045xx60': ('IS', '4', 'Breast ROI X', ''),
        '0045xx61': ('IS', '4', 'Breast ROI Y', ''),
        '0045xx62': ('IS', '1', 'User Window Center', ''),
        '0045xx63': ('IS', '1', 'User Window Width', ''),
        '0045xx64': ('IS', '1', 'Segm Threshold', ''),
        '0045xx65': ('IS', '1', 'Detector Entrance Dose', ''),
        '0045xx66': ('IS', '1', 'Asymmetrical Collimation Information', ''),
        '0045xx71': ('OB', '1', 'STX buffer', ''),
        '0045xx72': ('DS', '2', 'Image Crop point', ''),
    },
    'GEMS_SERS_01': {
        '002510xx': ('LO', '1', 'Private Element Creator', ''),
        '0025xx06': ('SS', '1', 'Last pulse sequence used', ''),
        '0025xx07': ('SL', '1', 'Images in Series', ''),
        '0025xx10': ('SL', '1', 'Landmark Counter', ''),
        '0025xx11': ('SS', '1', 'Number of Acquisitions', ''),
        '0025xx14': ('SL', '1', 'Indicates no. of updates to header', ''),
        '0025xx17': ('SL', '1', 'Series Complete Flag', ''),
        '0025xx18': ('SL', '1', 'Number of images archived', ''),
        '0025xx19': ('SL', '1', 'Last image number used', ''),
        '0025xx1A': ('SH', '1', 'Primary Receiver Suite and Host', ''),
        '0025xx1B': ('OB', '1', 'Protocol Data Block (compressed)', ''),
    },
    'GEMS_STDY_01': {
        '002310xx': ('LO', '1', 'Private Element Creator', ''),
        '0023xx01': ('SL', '1', 'Number of series in Study', ''),
        '0023xx02': ('SL', '1', 'Number of unarchived Series', ''),
        '0023xx10': ('SS', '1', 'Reference image field', ''),
        '0023xx50': ('SS', '1', 'Summary image', ''),
        '0023xx70': ('FD', '1', 'Start time(secs) in first axial', ''),
        '0023xx74': ('SL', '1', 'No. of updates to header', ''),
        '0023xx7D': ('SS', '1', 'Indicates study has complete info (DICOM/genesis)', ''),
    },
    'GEMS_Ultrasound_ImageGroup_001': {
        '6003xx10': ('SQ', '1', 'Unknown', ''),
        '6003xx11': ('OB', '1', 'Unknown', ''),
    },
    'GEMS_Ultrasound_MovieGroup_001': {
        '7FE1xx01': ('SQ', '1', 'Unknown', ''),
        '7FE1xx02': ('LO', '1', 'Unknown', ''),
        '7FE1xx03': ('UL', '1', 'Unknown', ''),
        '7FE1xx08': ('SQ', '1', 'Unknown', ''),
        '7FE1xx10': ('SQ', '1', 'Unknown', ''),
        '7FE1xx12': ('LO', '1', 'Unknown', ''),
        '7FE1xx18': ('SQ', '1', 'Unknown', ''),
        '7FE1xx20': ('SQ', '1', 'Unknown', ''),
        '7FE1xx24': ('SH', '1', 'Unknown', ''),
        '7FE1xx26': ('SQ', '1', 'Unknown', ''),
        '7FE1xx36': ('SQ', '1', 'Unknown', ''),
        '7FE1xx37': ('UL', '1', 'Unknown', ''),
        '7FE1xx43': ('OB', '1', 'Unknown', ''),
        '7FE1xx48': ('FD', '1-2', 'Unknown', ''),
        '7FE1xx49': ('UL', '1', 'Unknown', ''),
        '7FE1xx51': ('FL', '1', 'Unknown', ''),
        '7FE1xx52': ('FD', '1', 'Unknown', ''),
        '7FE1xx53': ('UL', '1', 'Unknown', ''),
        '7FE1xx54': ('SL', '1', 'Unknown', ''),
        '7FE1xx55': ('OB', '1', 'Unknown', ''),
        '7FE1xx57': ('LT', '1', 'Unknown', ''),
        '7FE1xx60': ('OB', '1', 'Unknown', ''),
        '7FE1xx61': ('OW', '1', 'Unknown', ''),
        '7FE1xx70': ('SQ', '1', 'Unknown', ''),
        '7FE1xx71': ('UL', '1', 'Unknown', ''),
        '7FE1xx72': ('LO', '1', 'Unknown', ''),
        '7FE1xx73': ('SQ', '1', 'Unknown', ''),
        '7FE1xx74': ('LO', '1', 'Unknown', ''),
        '7FE1xx75': ('SQ', '1', 'Unknown', ''),
        '7FE1xx77': ('FD', '1-n', 'Unknown', ''),
        '7FE1xx79': ('SL', '1', 'Unknown', ''),
        '7FE1xx83': ('SQ', '1', 'Unknown', ''),
        '7FE1xx84': ('LO', '1', 'Unknown', ''),
        '7FE1xx85': ('SQ', '1', 'Unknown', ''),
        '7FE1xx86': ('SL', '4', 'Unknown', ''),
        '7FE1xx87': ('FD', '4', 'Unknown', ''),
        '7FE1xx88': ('FD', '1', 'Unknown', ''),
    },
    'GEMS_VXTLSTATE_001': {
        '0057xx05': ('SQ', '1', 'Volumes_info', ''),
        '0057xx06': ('SQ', '1', 'Image_UIDs', ''),
        '0057xx07': ('DT', '1', 'SUV_ScanTime', ''),
        '0057xx08': ('DT', '1', 'SUV_AdministredTime', ''),
        '0057xx09': ('DT', '1', 'SUV_MeasuredTime', ''),
        '0057xx10': ('DT', '1', 'SUV_PostInjectedTime', ''),
        '0057xx11': ('FL', '1', 'SUV_TracerActivity', ''),
        '0057xx12': ('FL', '1', 'SUV_PostInjectedActivity', ''),
        '0057xx13': ('FL', '1', 'SUV_HalfLife', ''),
        '0057xx14': ('LO', '1', 'SState_Version', ''),
        '0057xx15': ('SQ', '1', 'SegList_Seq', ''),
        '0057xx16': ('IS', '1', 'SegList_Count', ''),
        '0057xx17': ('OB', '1', 'SegList_List', ''),
        '0057xx18': ('LO', '1', 'SegList_Name', ''),
        '0057xx19': ('LO', '1', 'Volume_Filename', ''),
        '0057xx20': ('LO', '1', 'SegList_Label', ''),
        '0057xx21': ('SQ', '1', 'Bookmark_Seq', ''),
        '0057xx22': ('LT', '1', 'Bookmark', ''),
        '0057xx23': ('FL', '3', 'Cursor_position', ''),
        '0057xx24': ('UL', '3-n', 'Color_Value_Field', ''),
        '0057xx25': ('IS', '1', 'Count', ''),
        '0057xx26': ('SQ', '1', 'Views_info', ''),
        '0057xx27': ('LT', '1', 'View_Slot', ''),
        '0057xx28': ('IS', '1', 'Wireframe_Size', ''),
        '0057xx29': ('UT', '1', 'Wireframe', ''),
        '0057xx30': ('IS', '1', 'Annotation_Size', ''),
        '0057xx31': ('LT', '1', 'Annotation', ''),
        '0057xx32': ('IS', '1', 'Slider_State', ''),
        '0057xx33': ('LO', '1', 'Proto_Name', ''),
        '0057xx34': ('LO', '1', 'Proto_Title', ''),
        '0057xx35': ('LO', '1', 'Proto_FilmName', ''),
        '0057xx36': ('LO', '1', 'Proto_Step', ''),
        '0057xx38': ('LT', '1', 'SegList_Slots', ''),
        '0057xx39': ('IS', '1', 'VT_Points_Size', ''),
        '0057xx40': ('LT', '1', 'VT_Points', ''),
        '0057xx41': ('IS', '1', 'VT_Meas_Size', ''),
        '0057xx42': ('LT', '1', 'VT_Meas', ''),
        '0057xx43': ('IS', '1', 'VT_Tree_Size', ''),
        '0057xx44': ('UT', '1', 'VT_Tree', ''),
        '0057xx46': ('IS', '1', 'VT_Preset_Size', ''),
        '0057xx47': ('LT', '1', 'VT_Preset', ''),
        '0057xx48': ('IS', '1', 'VT_State_Size', ''),
        '0057xx49': ('LT', '1', 'VT_State', ''),
        '0057xx50': ('IS', '1', 'Preferences_Size', ''),
        '0057xx51': ('LT', '1', 'Preferences', ''),
        '0057xx52': ('IS', '1', 'Volume_ZComb_Filter', ''),
        '0057xx53': ('IS', '1', 'HTML_Page_Size', ''),
        '0057xx54': ('LT', '1', 'HTML_Page', ''),
        '0057xx55': ('FL', '3', 'Camera_Position', ''),
        '0057xx56': ('IS', '1', 'Slider_Size', ''),
        '0057xx57': ('LT', '1', 'Slider', ''),
        '0057xx58': ('LO', '1', 'SegList_Pretty_Name', ''),
    },
    'GEMS_VXTL_USERDATA_01': {
        '0047xx11': ('LT', '1', 'Unknown', ''),
    },
    'GEMS_XELPRV_01': {
        '0033xx08': ('CS', '1', 'Object Type', ''),
        '0033xx10': ('SL', '1', 'Modified', ''),
        '0033xx11': ('LO', '1', 'Name', ''),
        '0033xx14': ('LO', '1', 'StudyId', ''),
        '0033xx16': ('LO', '1', 'ProtocolDataUID', ''),
        '0033xx17': ('SH', '1', 'Date', ''),
        '0033xx18': ('SH', '1', 'Time', ''),
        '0033xx19': ('UL', '1', 'ProtocoldataFlags', ''),
        '0033xx1A': ('LO', '1', 'ProtocolName', ''),
        '0033xx1B': ('LO', '1', 'StudyId', ''),
        '0033xx1C': ('OB', '1', 'BulkData', ''),
        '0033xx1D': ('SL', '1-n', 'IntData', ''),
        '0033xx1E': ('FD', '1-n', 'DoubleData', ''),
        '0033xx1F': ('OB', '1', 'StringData', ''),
        '0033xx20': ('OB', '1', 'BulkDataFormat', ''),
        '0033xx21': ('OB', '1', 'IntDataFormat', ''),
        '0033xx22': ('OB', '1', 'DoubleDataFormat', ''),
        '0033xx23': ('OB', '1', 'StringDataFormat', ''),
        '0033xx24': ('LT', '1', 'Description', ''),
        '0033xx28': ('LO', '1', 'RTName', ''),
        '0033xx29': ('LT', '1', 'RTSpecification', ''),
        '0033xx2A': ('UL', '1', 'ReviewTemplatesFlags', ''),
        '0033xx2B': ('LT', '1', 'DataValidationSpec', ''),
        '0033xx2C': ('LT', '1', 'Description', ''),
        '0033xx2D': ('LT', '1', 'IconDescription', ''),
        '0033xx50': ('SQ', '1', 'ProtocoldataSQ', ''),
        '0033xx51': ('UI', '1', 'PDOSOPClassUID', ''),
        '0033xx52': ('UI', '1', 'PDOSOPInstanceUID', ''),
        '0033xx60': ('SQ', '1', 'ReviewtemplateSQ', ''),
        '0033xx61': ('UI', '1', 'RTOSOPClassUID', ''),
        '0033xx62': ('UI', '1', 'RTOSOPInstanceUID', ''),
        '0033xx70': ('SQ', '1', 'SeriesdataSQ', ''),
        '0033xx71': ('UI', '1', 'SDOSOPClassUID', ''),
        '0033xx72': ('UI', '1', 'SDOSOPInstanceUID', ''),
        '0033xx73': ('SQ', '1', 'SDODoubleDataSQ', ''),
        '0057xx01': ('SQ', '1', 'ROISQ', ''),
        '0057xx02': ('UI', '1', 'SOPClassUID', ''),
        '0057xx03': ('UI', '1', 'SOPInstanceUID', ''),
        '0057xx10': ('IS', '1', 'ROINumber', ''),
        '0057xx11': ('UI', '1', 'Dimensions', ''),
        '0057xx12': ('UI', '1', 'Points', ''),
        '0057xx13': ('UI', '1', 'Type', ''),
        '0057xx14': ('UI', '1', 'Description', ''),
        '0057xx15': ('UI', '1', 'Data value Representation', ''),
        '0057xx16': ('UI', '1', 'Label', ''),
        '0057xx17': ('UI', '1', 'Data', ''),
        '0057xx41': ('SL', '1', 'Modified', ''),
        '0057xx42': ('LO', '1', 'Name', ''),
        '0057xx43': ('SL', '1', 'Rid', ''),
        '0057xx45': ('LO', '1', 'SOPClassUID', ''),
        '0057xx46': ('LO', '1', 'SOPInstanceUID', ''),
        '0057xx47': ('LO', '1', 'Normal Colour', ''),
        '0057xx48': ('LT', '1', 'NameFont', ''),
        '0057xx49': ('SL', '1', 'FillPattern', ''),
        '0057xx4A': ('SL', '1', 'LineStyle', ''),
        '0057xx4B': ('SL', '1', 'LineDashLength', ''),
        '0057xx4C': ('SL', '1', 'LineThickness', ''),
        '0057xx4D': ('SL', '1', 'Interactivity', ''),
        '0057xx4E': ('SL', '1', 'NamePos', ''),
        '0057xx4F': ('SL', '1', 'NameDisplay', ''),
        '0057xx50': ('LO', '1', 'Label', ''),
        '0057xx51': ('SL', '1-n', 'BpSeg', ''),
        '0057xx52': ('US', '1-n', 'BpSegpairs', ''),
        '0057xx53': ('SL', '1', 'SeedSpace', ''),
        '0057xx54': ('FD', '1-n', 'Seeds', ''),
        '0057xx55': ('SL', '1-n', 'Shape', ''),
        '0057xx56': ('FD', '1-n', 'ShapeTilt', ''),
        '0057xx59': ('SL', '1-n', 'ShapePtsSpace', ''),
        '0057xx5A': ('SL', '1-n', 'ShapeCtrlPtsCount', ''),
        '0057xx5B': ('FD', '1-n', 'Shap CtrlPts', ''),
        '0057xx5C': ('SL', '1', 'ShapeCPSpace', ''),
        '0057xx5D': ('UL', '1-n', 'ROIFlags', ''),
        '0057xx5E': ('UL', '1', 'FrameNumber', ''),
        '0057xx60': ('LO', '1-n', 'DatasetROIMapping', ''),
    },
    'GEMS_XR3DCAL_01': {
        '0021xx01': ('IS', '1', '3Dcal image rows', ''),
        '0021xx02': ('IS', '1', '3Dcal image columns', ''),
        '0021xx03': ('FL', '1', '3Dcal field of view', ''),
        '0021xx04': ('DA', '1', '3Dcal acquisition date', ''),
        '0021xx05': ('TM', '1', '3Dcal acquisition time', ''),
        '0021xx06': ('DA', '1', '3Dcal calibration processing date', ''),
        '0021xx07': ('TM', '1', '3Dcal calibration processing time', ''),
        '0021xx08': ('FL', '1', '3Dcal L arm angle', ''),
        '0021xx09': ('FL', '1-n', '3Dcal Pivot angle vector', ''),
        '0021xx0A': ('FL', '1', '3Dcal C arm angle', ''),
        '0021xx0B': ('SQ', '1', '3Dcal matrix sequence', ''),
        '0021xx0C': ('LO', '1-n', '3Dcal matrix elements', ''),
        '0021xx0D': ('LO', '1', '3Dcal algorithm version', ''),
        '0021xx0E': ('FL', '1', '3Dcal 3D frame unit size', ''),
        '0021xx0F': ('LO', '1', '3Dcal calibration mode', ''),
        '0021xx10': ('FL', '1', '3Dcal image frame origin row', ''),
        '0021xx11': ('FL', '1', '3Dcal image frame origin column', ''),
        '0021xx12': ('IS', '1', '3Dcal positioner pivot rotation speed', ''),
        '0021xx13': ('IS', '1', '3Dcal number of images', ''),
        '0021xx14': ('UI', '1', '3Dcal Instance UID', ''),
        '0021xx15': ('FL', '2', '3Dcal image pixel spacing', ''),
        '0021xx16': ('CS', '1', '3Dcal centering mode', ''),
    },
    'GEMS_YMHD_01': {
        '0033xx05': ('UN', '1', 'Unknown', ''),
        '0033xx06': ('UN', '1', 'Unknown', ''),
    },
    'GE_GENESIS_REV3.0': {
        '0019xx39': ('SS', '1', 'Axial Type', ''),
        '0019xx8F': ('SS', '1', 'Swap Phase / Frequency Axis', ''),
        '0019xx9C': ('SS', '1', 'Pulse Sequence Name', ''),
        '0019xx9F': ('SS', '1', 'Coil Type', ''),
        '0019xxA4': ('SS', '1', 'SAT fat/water/none', ''),
        '0019xxC0': ('SS', '1', 'Bitmap of SAT Selections', ''),
        '0019xxC1': ('SS', '1', 'Surfacel Coil Iintensity Correction Flag', ''),
        '0019xxCB': ('SS', '1', 'Phase Contrast Flow Axis', ''),
        '0019xxCC': ('SS', '1', 'Phase Contrast Velocity Encoding', ''),
        '0019xxD5': ('SS', '1', 'Fractional Echo', ''),
        '0019xxD8': ('SS', '1', 'Variable Echo Flag', ''),
        '0019xxD9': ('DS', '1', 'Concatenated Sat', ''),
        '0019xxF2': ('SS', '1', 'Number of Phases', ''),
        '0043xx1E': ('DS', '1', 'Delta Start Time', ''),
        '0043xx27': ('SH', '1', 'Pitch Ratio', ''),
    },
    'GE_GROUP': {
        '6005xx10': ('UT', '1', 'Unknown', ''),
    },
    'HMC - CT - ID': {
        '0009xx00': ('UN', '1', 'Image ID Information (e.g. Patient Name, Patient ID)', ''),
        '0009xx01': ('UN', '1', 'Image ID Information (e.g. Patient Comment)', ''),
    },
    'HOLOGIC': {
        '0011xx00': ('LO', '1', 'Hx Questionnaire', ''),
        '0021xx01': ('LT', '1', 'Image Analysis Data in XML', ''),
        '0023xx00': ('LO', '1', 'Encoding Scheme Version', ''),
        '0023xx01': ('LO', '1', 'P File Name', ''),
        '0023xx02': ('OB', '1', 'P File Data', ''),
        '0023xx03': ('UL', '1', 'P File Length', ''),
        '0023xx04': ('OB', '1', 'R File Data', ''),
        '0023xx05': ('UL', '1', 'R File Length', ''),
    },
    'HOLOGIC, Inc.': {
        '0019xx06': ('LO', '1', 'Unknown', ''),
        '0019xx07': ('SH', '1', 'Unknown', ''),
        '0019xx08': ('LO', '1', 'Unknown', ''),
        '0019xx16': ('DS', '1', 'Unknown', ''),
        '0019xx26': ('LO', '1', 'Unknown', ''),
        '0019xx27': ('SH', '1', 'Unknown', ''),
        '0019xx28': ('LO', '1', 'Unknown', ''),
        '0019xx29': ('LO', '1', 'Unknown', ''),
        '0019xx30': ('US', '1', 'Unknown', ''),
        '0019xx31': ('US', '1', 'Unknown', ''),
        '0019xx32': ('US', '1', 'Unknown', ''),
        '0019xx33': ('US', '1', 'Unknown', ''),
        '0019xx34': ('US', '1', 'Unknown', ''),
        '0019xx35': ('US', '1', 'Unknown', ''),
        '0019xx37': ('LO', '1', 'Unknown', ''),
        '0019xx40': ('DS', '1', 'Unknown', ''),
        '0019xx41': ('DS', '1', 'Unknown', ''),
        '0019xx42': ('DS', '1', 'Unknown', ''),
        '0019xx43': ('DS', '1', 'Unknown', ''),
        '0019xx44': ('IS', '1', 'Unknown', ''),
        '0019xx45': ('IS', '1', 'Unknown', ''),
        '0019xx46': ('IS', '1', 'Unknown', ''),
        '0019xx70': ('DS', '1', 'Unknown', ''),
        '0019xx85': ('IS', '1', 'Unknown', ''),
        '0019xx90': ('DS', '1', 'Unknown', ''),
        '7E01xx01': ('LO', '1', 'Unknown', ''),
        '7E01xx02': ('LO', '1', 'Unknown', ''),
        '7E01xx10': ('SQ', '1', 'Unknown', ''),
        '7E01xx11': ('SQ', '1', 'Unknown', ''),
        '7E01xx12': ('OB', '1', 'Unknown', ''),
        '7F01xx01': ('LO', '1', 'Unknown', ''),
        '7F01xx02': ('SH', '1', 'Unknown', ''),
        '7F01xx10': ('SQ', '1', 'Unknown', ''),
        '7F01xx12': ('OB', '1', 'Unknown', ''),
    },
    'Hologic': {
        '0011xx00': ('LO', '1', 'Hx Questionnaire', ''),
        '0021xx01': ('LT', '1', 'Image Analysis Data in XML', ''),
        '0023xx00': ('LO', '1', 'Encoding Scheme Version', ''),
        '0023xx01': ('LO', '1', 'P File Name', ''),
        '0023xx02': ('OB', '1', 'P File Data', ''),
        '0023xx03': ('UL', '1', 'P File Length', ''),
        '0023xx04': ('OB', '1', 'R File Data', ''),
        '0023xx05': ('UL', '1', 'R File Length', ''),
    },
    'IDEXX': {
        '0011xx00': ('LO', '1', 'Breed Name', ''),
        '0011xx01': ('LO', '1', 'Species Name', ''),
        '0011xx02': ('PN', '1', 'Owner', ''),
    },
    'IMPAC': {
        '300Bxx02': ('FL', '1', 'Unknown', ''),
        '300Bxx04': ('FL', '1', 'Unknown', ''),
        '300Bxx0E': ('FL', '1', 'Unknown', ''),
    },
    'IMS s.r.l. Biopsy Private Code': {
        '1269xx01': ('IS', '1', 'Biopsy Image', ''),
        '1269xx10': ('IS', '1-n', 'Biopsy Markers X', ''),
        '1269xx11': ('IS', '1-n', 'Biopsy Markers Y', ''),
        '1269xx12': ('IS', '1', 'Biopsy Markers Number', ''),
        '1269xx20': ('IS', '1', 'Biopsy Area Left Border', ''),
        '1269xx21': ('IS', '1', 'Biopsy Area Right Border', ''),
        '1269xx22': ('IS', '1', 'Biopsy Area Top Border', ''),
        '1269xx23': ('IS', '1', 'Biopsy Area Bottom Border', ''),
    },
    'IMS s.r.l. Mammography Private Code': {
        '1271xx01': ('IS', '1', 'Unknown', ''),
        '1271xx02': ('IS', '1', 'Unknown', ''),
        '1271xx10': ('IS', '1', 'Unknown', ''),
        '1271xx11': ('IS', '1', 'Unknown', ''),
        '1271xx12': ('IS', '1', 'Unknown', ''),
        '1271xx13': ('IS', '1', 'Unknown', ''),
        '1271xx20': ('IS', '1', 'Unknown', ''),
        '1271xx21': ('IS', '1', 'Unknown', ''),
        '1271xx22': ('IS', '1', 'Unknown', ''),
        '1271xx38': ('LO', '1', 'Unknown', ''),
        '1271xx39': ('US', '1', 'Unknown', ''),
        '1271xx40': ('US', '1', 'Unknown', ''),
        '1271xx41': ('LO', '1', 'Unknown', ''),
        '1271xx42': ('LT', '1', 'Unknown', ''),
        '1271xx45': ('IS', '1', 'Unknown', ''),
        '1271xx46': ('IS', '1', 'Unknown', ''),
        '1271xx47': ('IS', '1', 'Unknown', ''),
        '1271xx48': ('IS', '1', 'Unknown', ''),
        '1271xx49': ('IS', '1', 'Unknown', ''),
        '1271xx50': ('IS', '1', 'Unknown', ''),
        '1271xx51': ('IS', '1', 'Unknown', ''),
        '1271xx52': ('IS', '1', 'Unknown', ''),
        '1271xx53': ('LO', '1', 'Unknown', ''),
        '1271xx54': ('IS', '1', 'Unknown', ''),
    },
    'INFINITT_FMX': {
        '0015xx10': ('LO', '1', 'Unknown', ''),
        '0015xx11': ('LO', '1', 'Unknown', ''),
    },
    'INTEGRIS 1.0': {
        '0009xx08': ('CS', '1', 'Exposure Channel', ''),
        '0009xx32': ('TM', '1', 'Exposure Start Time', ''),
        '0019xx00': ('LO', '1', 'APR Name', ''),
        '0019xx40': ('DS', '1', 'Frame Rate', ''),
        '0021xx12': ('IS', '1', 'Exposure Number', ''),
        '0029xx00': ('SQ', '1', 'Edge Enhancement Sequence', ''),
        '0029xx01': ('US', '2', 'Convolution Kernel Size', ''),
        '0029xx02': ('US', '1-n', 'Convolution Kernel Coefficients', ''),
        '0029xx03': ('FL', '1', 'Edge Enhancement Gain', ''),
        '0029xx08': ('IS', '1', 'Number of Exposure Results', ''),
        '0041xx20': ('DS', '1', 'Accumulated Fluoroscopy Dose', ''),
        '0041xx30': ('DS', '1', 'Accumulated Exposure Dose', ''),
        '0041xx40': ('DS', '1', 'Total Dose', ''),
        '0041xx41': ('US', '1', 'Total Number of Frames', ''),
        '0041xx50': ('SQ', '1', 'Exposure Information Sequence', ''),
    },
    'INTELERAD MEDICAL SYSTEMS': {
        '3F01xx01': ('LO', '1', 'Institution Code', ''),
        '3F01xx02': ('LO', '1', 'Routed Transfer AE', ''),
        '3F01xx03': ('LO', '1', 'Source AE', ''),
        '3F01xx04': ('LO', '1', 'Deferred Validation', ''),
        '3F01xx05': ('LO', '1', 'Series Owner', ''),
    },
    'ISG Image': {
        '0065xx11': ('UL', '1', 'Unknown', ''),
    },
    'ISG shadow': {
        '0029xx70': ('IS', '1', 'Unknown', ''),
        '0029xx80': ('IS', '1', 'Unknown', ''),
        '0029xx90': ('IS', '1', 'Unknown', ''),
    },
    'ISI': {
        '0009xx01': ('SQ', '1', 'SIENET General Purpose IMGF', ''),
    },
    'Image (ID, Version, Size, Dump, GUID)': {
        '8003xx00': ('LO', '1', 'ID', ''),
        '8003xx10': ('LO', '1', 'Version', ''),
        '8003xx20': ('UL', '1', 'Size', ''),
        '8003xx30': ('OB', '1', 'Dump', ''),
        '8003xx40': ('LO', '1', 'GUID', ''),
    },
    'Imaging Dynamics Company Ltd.': {
        '4321xx05': ('UN', '1', 'Custom Tag', ''),
        '4321xx10': ('UN', '1', 'Custom Tag', ''),
        '4321xx41': ('CS', '1', 'Unknown', ''),
        '4321xx42': ('US', '1', 'Unknown', ''),
        '4321xx50': ('DS', '1', 'Custom Tag', ''),
        '4321xx51': ('DS', '1', 'Custom Tag', ''),
        '4321xx64': ('LO', '1', 'Custom Tag', ''),
    },
    'KINETDX': {
        '0021xxA5': ('US', '1', 'Unknown', ''),
        '0021xxA8': ('LO', '1', 'Unknown', ''),
        '0021xxAA': ('OB', '1', 'Unknown', ''),
    },
    'KINETDX_GRAPHICS': {
        '0021xxA4': ('LT', '1', 'Unknown', ''),
    },
    'KRETZ_US': {
        '7FE1xx01': ('OB', '1', 'Unknown', ''),
    },
    'Kodak Image Information': {
        '0029xx15': ('LO', '1', 'Unknown', ''),
        '0029xx16': ('LO', '1', 'Unknown', ''),
        '0029xx17': ('LO', '1', 'Unknown', ''),
        '0029xx18': ('UT', '1', 'Unknown', ''),
        '0029xx19': ('IS', '1', 'Unknown', ''),
        '0029xx1A': ('IS', '1', 'Unknown', ''),
    },
    'LODOX_STATSCAN': {
        '0019xx01': ('IS', '1-n', 'Unknown', ''),
        '0019xx02': ('IS', '1', 'Unknown', ''),
        '0019xx03': ('DS', '1', 'Unknown', ''),
        '0019xx04': ('DS', '1', 'Unknown', ''),
        '0019xx05': ('DS', '1', 'Unknown', ''),
        '0019xx06': ('DS', '1', 'Unknown', ''),
        '0019xx07': ('DS', '1', 'Unknown', ''),
        '0019xx08': ('DS', '1', 'Unknown', ''),
    },
    'LORAD Selenia': {
        '0019xx06': ('OB', '1', 'Paddle ID', ''),
        '0019xx07': ('OB', '1', 'Paddle Position', ''),
        '0019xx08': ('OB', '1', 'Collimation Size', ''),
        '0019xx26': ('OB', '1', 'Unknown', ''),
        '0019xx27': ('OB', '1', 'Unknown', ''),
        '0019xx28': ('OB', '1', 'Unknown', ''),
        '0019xx29': ('OB', '1', 'Unknown', ''),
        '0019xx30': ('OB', '1', 'Unknown', ''),
        '0019xx31': ('OB', '1', 'Unknown', ''),
        '0019xx32': ('OB', '1', 'Unknown', ''),
        '0019xx33': ('OB', '1', 'Unknown', ''),
        '0019xx34': ('OB', '1', 'Unknown', ''),
        '0019xx35': ('OB', '1', 'Unknown', ''),
        '0019xx40': ('OB', '1', 'Unknown', ''),
        '0019xx41': ('OB', '1', 'Unknown', ''),
        '0019xx50': ('OB', '1', 'Unknown', ''),
        '0019xx51': ('OB', '1', 'Unknown', ''),
        '0019xx52': ('OB', '1', 'Unknown', ''),
        '0019xx53': ('OB', '1', 'Unknown', ''),
        '0019xx70': ('OB', '1', 'Unknown', ''),
        '0019xx71': ('OB', '1', 'Unknown', ''),
    },
    'MAROTECH Inc.': {
        '0037xx01': ('LO', '1', 'Some kind of version number', ''),
        '0037xx21': ('US', '1', 'Icon Row', ''),
        '0037xx22': ('US', '1', 'Icon Col', ''),
        '0037xx23': ('OB', '1', 'JPEG Compressed Icon', ''),
    },
    'MDS NORDION OTP ANATOMY MODELLING': {
        '3005xx00': ('SQ', '1', 'Unknown', ''),
        '3005xx02': ('CS', '1', 'Unknown', ''),
        '3005xx04': ('DS', '1', 'Unknown', ''),
        '3005xx06': ('DS', '1', 'Unknown', ''),
        '3005xx08': ('DS', '1', 'Unknown', ''),
        '3005xx0A': ('CS', '1', 'Unknown', ''),
        '3005xx0C': ('CS', '1', 'Unknown', ''),
        '3005xx0E': ('CS', '1', 'Unknown', ''),
        '3005xx10': ('DS', '1', 'Unknown', ''),
        '3005xx12': ('DS', '1', 'Unknown', ''),
    },
    'MEDIFACE': {
        '0021xx01': ('UN', '1', 'Unknown', ''),
        '0021xx10': ('UN', '1', 'Unknown', ''),
        '0021xx11': ('UN', '1', 'Unknown', ''),
        '0021xx12': ('UN', '1', 'Unknown', ''),
        '0021xx21': ('UN', '1', 'Unknown', ''),
        '0021xx22': ('UN', '1', 'Unknown', ''),
        '0021xx30': ('UN', '1', 'Unknown', ''),
        '0021xx31': ('UN', '1', 'Unknown', ''),
        '0021xx40': ('UN', '1', 'Unknown', ''),
        '0021xx41': ('UN', '1', 'Unknown', ''),
        '0021xx42': ('UN', '1', 'Unknown', ''),
        '0021xx50': ('UN', '1', 'Unknown', ''),
        '0021xx51': ('UN', '1', 'Unknown', ''),
        '0021xx52': ('UN', '1', 'Unknown', ''),
        '0021xx60': ('UN', '1', 'Unknown', ''),
        '0021xxF1': ('UN', '1', 'Unknown', ''),
        '0021xxF2': ('UN', '1', 'Unknown', ''),
        '0029xx01': ('UL', '1', 'Unknown', ''),
        '0029xx10': ('DS', '1', 'Window Center', ''),
        '0029xx11': ('DS', '1', 'Window Width', ''),
        '0029xx20': ('DS', '1', 'Unknown', ''),
        '0029xx21': ('UL', '1', 'Unknown', ''),
        '0029xx22': ('DS', '2', 'Unknown', ''),
        '0029xx30': ('LT', '1', 'Unknown', ''),
    },
    'MERGE TECHNOLOGIES, INC.': {
        '0009xx00': ('OB', '1', 'Unknown', ''),
    },
    'MITRA LINKED ATTRIBUTES 1.0': {
        '0031xx20': ('LO', '1', 'Global Patient ID', ''),
    },
    'MITRA OBJECT ATTRIBUTES 1.0': {
        '0033xx02': ('LO', '1', 'Unknown', ''),
        '0033xx04': ('LO', '1', 'Unknown', ''),
        '0033xx06': ('LO', '1', 'Unknown', ''),
        '0033xx08': ('LO', '1', 'Unknown', ''),
        '0033xx0A': ('LO', '1', 'Unknown', ''),
    },
    'MITRA OBJECT DOCUMENT 1.0': {
        '0029xx00': ('OB', '1', 'Unknown', ''),
    },
    'MITRA OBJECT UTF8 ATTRIBUTES 1.0': {
        '0033xx02': ('PN', '1', "Patient's Name", ''),
        '0033xx04': ('CS', '1', 'Study Description', ''),
        '0033xx06': ('PN', '1', "Referring Physician's Name", ''),
        '0033xx08': ('PN', '1', "Requesting Physician's Name", ''),
        '0033xx0A': ('PN', '1', "Performing Physician's Name", ''),
        '0033xx0C': ('LO', '1', 'Reason for Study', ''),
        '0033xx0E': ('LT', '1', 'Study Comments', ''),
        '0033xx13': ('PN', '1', "Patient's Name Single Byte", ''),
        '0033xx14': ('PN', '1', "Patient's Name Ideographic", ''),
        '0033xx15': ('PN', '1', "Patient's Name Phonetic", ''),
        '0033xx16': ('PN', '1', "Referring Physician's Name Single Byte", ''),
        '0033xx17': ('PN', '1', "Referring Physician's Name Ideographic", ''),
        '0033xx18': ('PN', '1', "Referring Physician's Name Phonetic", ''),
        '0033xx19': ('PN', '1', "Requesting Physician's Name Single Byte", ''),
        '0033xx1A': ('PN', '1', "Requesting Physician's Name Ideographic", ''),
        '0033xx1B': ('PN', '1', "Requesting Physician's Name Phonetic", ''),
        '0033xx1C': ('PN', '1', "Performing Physician's Name Single Byte", ''),
        '0033xx1D': ('PN', '1', "Performing Physician's Name Ideographic", ''),
        '0033xx1E': ('PN', '1', "Performing Physician's Name Phonetic", ''),
    },
    'MITRA PRESENTATION 1.0': {
        '0029xx00': ('CS', '1', 'Mitra Rotation', ''),
        '0029xx01': ('LO', '1', 'Mitra Window Width', ''),
        '0029xx02': ('LO', '1', 'Mitra Window Centre', ''),
        '0029xx03': ('IS', '1', 'Mitra Invert', ''),
        '0029xx04': ('IS', '1', 'Mitra Has Tabstop', ''),
        '0029xx05': ('CS', '1', 'Smooth Rotation', ''),
        '0029xx10': ('CS', '1', 'Breast Box x0', ''),
        '0029xx11': ('CS', '1', 'Breast Box y0', ''),
        '0029xx12': ('CS', '1', 'Breast Box x1', ''),
        '0029xx13': ('CS', '1', 'Breast Box y1', ''),
    },
    'MMCPrivate': {
        '0009xx00': ('LO', '1', 'Private Creator', ''),
        '0009xx01': ('LO', '1', 'Technologist', ''),
        '0009xx02': ('LO', '1', 'ScheduledStudyDateTime', ''),
        '0009xx03': ('OB', '1', 'StudyAppData', ''),
        '0009xx04': ('UI', '1', 'ProtocolObjectID', ''),
        '0009xx05': ('LO', '1', 'Name', ''),
        '0009xx06': ('IS', '1', 'Frequency', ''),
        '0009xx07': ('SH', '1', 'UpdateFlag', ''),
        '0009xx08': ('SH', '1', 'Directory', ''),
        '0009xx09': ('LO', '1', 'Comments', ''),
        '0009xx0A': ('LO', '1', 'Region', ''),
        '0009xx0B': ('SH', '1', 'Laterality', ''),
        '0009xx0C': ('TM', '1', 'TotalScanTime', ''),
        '0009xx0D': ('LO', '1', 'ContrastMedium', ''),
        '0009xx0E': ('LO', '1', 'CreateDateTime', ''),
        '0009xx0F': ('LO', '1', 'Creator', ''),
        '0009xx10': ('LO', '1', 'SiteName', ''),
        '0009xx11': ('LO', '1', 'ReferringPhysician', ''),
        '0009xx12': ('LO', '1', 'Radiologist', ''),
        '0009xx13': ('LO', '1', 'Technologist', ''),
        '0009xx14': ('UI', '1', 'ProtocolUid', ''),
        '0009xx15': ('SH', '1', 'IsInLibrary', ''),
        '0009xx16': ('LO', '1', 'Gating', ''),
        '0009xx17': ('ST', '1', 'Note', ''),
        '0009xx18': ('IS', '1', 'NumberOfTasks', ''),
        '0009xx19': ('SH', '1', 'IsFlagRaised', ''),
        '0009xx1A': ('SH', '1', 'IsArchived', ''),
        '0009xx1B': ('SH', '1', 'IsDefault', ''),
        '0009xx1C': ('OB', '1', 'ProtocolAppData', ''),
        '0009xx1D': ('SH', '1', 'IsAllowCascadeSave', ''),
        '0009xx1E': ('SH', '1', 'IsAllowCascadeProtect', ''),
        '0009xx1F': ('SQ', '1', 'TaskInfo', ''),
        '0009xx20': ('UI', '1', 'TaskInfoObjectID', ''),
        '0009xx21': ('LO', '1', 'Name', ''),
        '0009xx22': ('SH', '1', 'TaskStatus', ''),
        '0009xx23': ('SH', '1', 'TaskPriority', ''),
        '0009xx24': ('SH', '1', 'Leaf', ''),
        '0009xx25': ('LO', '1', 'TaskID', ''),
        '0009xx26': ('IS', '1', 'Frequency', ''),
        '0009xx27': ('SH', '1', 'UpdateFlag', ''),
        '0009xx28': ('SH', '1', 'Directory', ''),
        '0009xx29': ('LO', '1', 'Comments', ''),
        '0009xx2A': ('SH', '1', 'Category', ''),
        '0009xx2B': ('LO', '1', 'Region', ''),
        '0009xx2C': ('SH', '1', 'Laterality', ''),
        '0009xx2D': ('TM', '1', 'ScanTime', ''),
        '0009xx2E': ('LO', '1', 'ContrastMedium', ''),
        '0009xx2F': ('LO', '1', 'CreateDateTime', ''),
        '0009xx30': ('LO', '1', 'Creator', ''),
        '0009xx31': ('LO', '1', 'SiteName', ''),
        '0009xx32': ('LO', '1', 'ReferringPhysician', ''),
        '0009xx33': ('LO', '1', 'Radiologist', ''),
        '0009xx34': ('LO', '1', 'Technologist', ''),
        '0009xx35': ('UI', '1', 'TaskUid', ''),
        '0009xx36': ('UI', '1', 'TaskInfoUid', ''),
        '0009xx37': ('SH', '1', 'IsInLibrary', ''),
        '0009xx38': ('IS', '1', 'TaskOrder', ''),
        '0009xx39': ('LO', '1', 'Gating', ''),
        '0009xx3A': ('SH', '1', 'Plane', ''),
        '0009xx3B': ('LO', '1', 'SequenceType', ''),
        '0009xx3C': ('SH', '1', 'IsExecutive', ''),
        '0009xx3D': ('ST', '1', 'Note', ''),
        '0009xx3E': ('SH', '1', 'AutoStart', ''),
        '0009xx3F': ('SH', '1', 'AutoSave', ''),
        '0009xx40': ('SH', '1', 'AutoArchive', ''),
        '0009xx41': ('IS', '1', 'QueueGroupID', ''),
        '0009xx42': ('SH', '1', 'IsFlagRaised', ''),
        '0009xx43': ('SH', '1', 'IsArchived', ''),
        '0009xx44': ('SH', '1', 'IsDefault', ''),
        '0009xx45': ('OB', '1', 'TaskInfoAppData', ''),
        '0009xx46': ('SH', '1', 'IsAllowCascadeSave', ''),
        '0009xx47': ('SH', '1', 'IsAllowCascadeProtect', ''),
        '0009xx48': ('LO', '1', 'ProtocolName', ''),
        '0009xx4E': ('LO', '1', 'Cms_BodyPartExamined', ''),
        '0009xx4F': ('LO', '1', 'IsProtected', ''),
        '0009xx50': ('OB', '1', '?StudyReservationInfo', ''),
        '0009xx51': ('LO', '1', 'Cmi_contrastBolusAgent', ''),
        '0009xx52': ('LO', '1', 'Cms_institutionName', ''),
        '0009xx53': ('LO', '1', 'Cms_institutionalDepartmentName', ''),
        '0009xx54': ('LO', '1', 'Cms_seriesDescription', ''),
        '0009xx55': ('LO', '1', 'Cms_operatorsName', ''),
        '0009xx56': ('LO', '1', 'Cms_PerformingPhysiciansName', ''),
        '0009xx57': ('ST', '1', 'Cms_institutionAddress', ''),
        '0009xx58': ('LO', '1', 'Cmi_imageComments', ''),
        '0009xx59': ('LO', '1', 'Cmi_instanceCreationDateTime', ''),
        '0009xx5A': ('LO', '1', 'MppsStepStatus', ''),
        '0009xx5B': ('IS', '1', 'FilmedCount', ''),
        '0009xx5C': ('LO', '1', 'IsAllowCascadeSave', ''),
        '0009xx5D': ('LO', '1', 'IsAllowCascadeProtect', ''),
        '0009xx5E': ('LO', '1', 'IsDeleted', ''),
        '0009xx5F': ('UI', '1', 'ProtocolObjectID', ''),
        '0009xx60': ('OB', '1', 'TaskInfoAppData', ''),
        '0009xx72': ('UI', '1', 'ProtocolTaskInfoObjectID', ''),
        '0009xx73': ('IS', '1', 'ProtocolTaskOrder', ''),
        '0009xx74': ('UI', '1', 'ProtocolTaskUid', ''),
        '0009xx75': ('OB', '1', 'ProtocolTaskAppData', ''),
        '0009xx76': ('SH', '1', 'ProtocolTaskIsAllowCascadeSave', ''),
        '0009xx77': ('SH', '1', 'ProtocolTaskIsAllowCascadeProtect', ''),
        '0011xx00': ('LO', '1', 'Private Creator', ''),
        '0011xx01': ('LO', '1', 'IsRapidRegistration', ''),
        '0011xx02': ('LO', '1', 'IsProtected', ''),
        '0011xx03': ('IS', '1', 'FilmedCount', ''),
        '0011xx04': ('OB', '1', 'ApplicationData', ''),
        '0011xx05': ('LO', '1', 'IsAllowCascadeSave', ''),
        '0011xx06': ('LO', '1', 'IsAllowCascadeProtect', ''),
        '0011xx07': ('LO', '1', 'IsDeleted', ''),
        '0019xx00': ('LO', '1', 'Private Creator', ''),
        '0019xx01': ('LO', '1', 'ProcType', ''),
        '0019xx02': ('LO', '1', 'Plane', ''),
        '0019xx03': ('SH', '1', 'IsSnapShotSeries', ''),
        '0019xx04': ('DS', '1', 'MaxFsColor', ''),
        '0019xx05': ('LO', '1', 'SeriesCategoryType', ''),
        '0019xx07': ('LO', '1', 'ImageContrastBolusAgent', ''),
        '0019xx08': ('DS', '1', 'ImageSliceThickness', ''),
        '0019xx09': ('DS', '1', 'ImageReconstructionDiameter', ''),
        '0019xx0A': ('LO', '1', 'ImageEchoTime', ''),
        '0019xx0B': ('DS', '1', 'ImageRepetitionTime', ''),
        '0019xx0C': ('LO', '1', 'SequenceType', ''),
        '0019xx0D': ('LO', '1', 'TaskUid', ''),
        '0019xx0E': ('OB', '1', 'SeriesAppData', ''),
        '0019xx0F': ('IS', '1', 'MultiSliceNumber', ''),
        '0019xx10': ('LO', '1', 'ImageScanTime', ''),
        '0019xx11': ('LO', '1', 'IsProtected', ''),
        '0019xx12': ('IS', '1', 'ImageIncrement', ''),
        '0019xx13': ('LO', '1', 'MppsStepStatus', ''),
        '0019xx14': ('IS', '1', 'StorageCommittedCount', ''),
        '0019xx15': ('IS', '1', 'ArchivedCount', ''),
        '0019xx16': ('IS', '1', 'TransferredCount', ''),
        '0019xx17': ('LO', '1', 'IsAllowCascadeSave', ''),
        '0019xx18': ('LO', '1', 'IsAllowCascadeProtect', ''),
        '0019xx19': ('LO', '1', 'IsDeleted', ''),
        '0019xx1A': ('UI', '1', 'CharacterizedImageInstanceUid', ''),
        '0019xx1B': ('IS', '1', 'CharacterizedImageCount', ''),
        '0019xx1C': ('LO', '1', 'InternalWindowWidth', ''),
        '0019xx1D': ('LO', '1', 'InternalWindowLevel', ''),
        '0019xx1E': ('LO', '1', '?FlipAngle?', ''),
        '0019xx1F': ('LO', '1', '?InversionTime?', ''),
        '0019xx20': ('UI', '1', 'MultiFrameSopInstanceUid', ''),
        '0019xx21': ('OB', '1', '?ScanInterface.GroupParamArchive', ''),
        '0029xx00': ('LO', '1', 'Private Creator', ''),
        '0029xx01': ('IS', '1', 'SliceNumber', ''),
        '0029xx02': ('IS', '1', 'PhaseNumber', ''),
        '0029xx03': ('LO', '1', 'ProcType', ''),
        '0029xx04': ('LO', '1', 'StopwatchTime', ''),
        '0029xx05': ('LO', '1', 'Plane', ''),
        '0029xx06': ('LO', '1', 'ScanTime', ''),
        '0029xx08': ('LO', '1', 'DualSliceFlag', ''),
        '0029xx09': ('LO', '1', 'SspRatio', ''),
        '0029xx0A': ('LO', '1', 'GatingSignalSource', ''),
        '0029xx0B': ('LO', '1', 'Rephase', ''),
        '0029xx0C': ('LO', '1', 'HalfEcho', ''),
        '0029xx0D': ('LO', '1', 'RectFOVRatio', ''),
        '0029xx0E': ('LO', '1', 'HalfScan', ''),
        '0029xx0F': ('LO', '1', 'NumShots', ''),
        '0029xx10': ('LO', '1', 'ContrastAgent', ''),
        '0029xx11': ('LO', '1', 'EchoAllocation', ''),
        '0029xx12': ('LO', '1', 'NumEchoShift', ''),
        '0029xx13': ('LO', '1', 'FatSat', ''),
        '0029xx14': ('LO', '1', 'MTC', ''),
        '0029xx15': ('LO', '1', 'NumPreSat', ''),
        '0029xx16': ('LO', '1', 'TargetVelocity', ''),
        '0029xx17': ('LO', '1', 'VENCAxis', ''),
        '0029xx18': ('LO', '1', 'NumVENCDirection', ''),
        '0029xx1C': ('LO', '1', 'IsScalableWindowLevel', ''),
        '0029xx1D': ('LO', '1', 'ThreeDSettingLineAngle', ''),
        '0029xx1E': ('LO', '1', 'MPGTotalAxis', ''),
        '0029xx1F': ('LO', '1', 'MPGAxisNumber', ''),
        '0029xx20': ('IS', '1', 'MultiEchoNumber', ''),
        '0029xx21': ('DS', '1', 'NaviAverageGateWidth', ''),
        '0029xx22': ('ST', '1', 'ShimCompensateValue', ''),
        '0029xx23': ('LO', '1', 'GCOffset', ''),
        '0029xx24': ('DS', '1', 'NaviMaxGateWidth', ''),
        '0029xx25': ('DS', '1', 'NaviMinGateWidth', ''),
        '0029xx26': ('DS', '1', 'NaviMaxGatePosition', ''),
        '0029xx27': ('DS', '1', 'NaviMinGatePosition', ''),
        '0029xx28': ('DS', '1', 'TimeDuration', ''),
        '0029xx29': ('DS', '1', 'TablePosition', ''),
        '0029xx2A': ('DS', '1', 'NaviInitialGateWidth', ''),
        '0029xx2B': ('DS', '1', 'NaviFinalGateWidth', ''),
        '0029xx2C': ('DS', '1', 'NaviInitialGatePosition', ''),
        '0029xx2D': ('DS', '1', 'NaviFinalGatePosition', ''),
        '0029xx2E': ('DS', '1', 'NaviAverageGatePosition', ''),
        '0029xx2F': ('OB', '1', 'ImageAppData', ''),
        '0029xx30': ('FD', '1', 'DiffusionBValue', ''),
        '0029xx31': ('SQ', '1', 'SharedFunctionalGroupsSequence', ''),
        '0029xx32': ('SQ', '1', 'PerFrameFunctionalGroupsSequence', ''),
        '0029xx33': ('DS', '1', 'LossyImageCompressionRatio', ''),
        '0029xx34': ('UI', '1', 'InstanceCreatorUID', ''),
        '0029xx35': ('UI', '1', 'RelatedGeneralSOPClassUID', ''),
        '0029xx36': ('UI', '1', 'OriginalSpecializedSOPClassUID', ''),
        '0029xx37': ('SH', '1', 'TimezoneOffsetFromUTC', ''),
        '0029xx38': ('CS', '1', 'SOPInstanceStatus', ''),
        '0029xx39': ('DT', '1', 'SOPAuthorizationDateandTime', ''),
        '0029xx3A': ('LT', '1', 'SOPAuthorizationComment', ''),
        '0029xx3B': ('LO', '1', 'AuthorizationEquipmentCertificationNumber', ''),
        '0029xx3C': ('UL', '1', 'ConcatenationFrameOffsetNumber', ''),
        '0029xx3D': ('US', '1', 'RepresentativeFrameNumber', ''),
        '0029xx3E': ('UI', '1', 'ConcatenationUID', ''),
        '0029xx3F': ('US', '1', 'InConcatenationNumber', ''),
        '0029xx40': ('CS', '1', 'CardiacSynchronizationTechnique', ''),
        '0029xx41': ('CS', '1', 'CardiacSignalSource', ''),
        '0029xx42': ('FD', '1', 'CardiacRRIntervalSpecified', ''),
        '0029xx43': ('CS', '1', 'CardiacBeatRejectionTechnique', ''),
        '0029xx44': ('IS', '1', 'LowRRValue', ''),
        '0029xx45': ('IS', '1', 'HighRRValue', ''),
        '0029xx46': ('IS', '1', 'IntervalsAcquired', ''),
        '0029xx47': ('IS', '1', 'IntervalsRejected', ''),
        '0029xx48': ('CS', '1', 'RespiratoryMotionCompensationTechnique', ''),
        '0029xx49': ('CS', '1', 'RespiratorySignalSource', ''),
        '0029xx4A': ('CS', '1', 'BulkMotionCompensationTechnique', ''),
        '0029xx4B': ('CS', '1', 'BulkMotionSignalSource', ''),
        '0029xx4C': ('CS', '1', 'PixelPresentation', ''),
        '0029xx4D': ('CS', '1', 'VolumetricProperties', ''),
        '0029xx4E': ('CS', '1', 'VolumeBasedCalculationTechnique', ''),
        '0029xx4F': ('ST', '1', 'AcquisitionContextDescription', ''),
        '0029xx50': ('SQ', '1', 'ModalityLUTSequence', ''),
        '0029xx51': ('LO', '1', 'LUTDescriptor', ''),
        '0029xx52': ('LO', '1', 'LUTExplanation', ''),
        '0029xx53': ('LO', '1', 'LUTData', ''),
        '0029xx54': ('CS', '1', 'PresentationLUTShape', ''),
        '0029xx55': ('SQ', '1', 'FrameAnatomySequence', ''),
        '0029xx56': ('CS', '1', 'FrameLaterality', ''),
        '0029xx57': ('SQ', '1', 'AnatomicRegionSequence', ''),
        '0029xx58': ('SH', '1', 'AnatomicRegionCodeValue', ''),
        '0029xx59': ('SH', '1', 'AnatomicRegionCodingSchemeDesignator', ''),
        '0029xx5A': ('SH', '1', 'AnatomicRegionCodingSchemeVersion', ''),
        '0029xx5B': ('LO', '1', 'AnatomicRegionCodeMeaning', ''),
        '0029xx5C': ('SQ', '1', 'PixelValueTransformationSequence', ''),
        '0029xx5D': ('LO', '1', 'RescaleType', ''),
        '0029xx5E': ('SQ', '1', 'CardiacTriggerSequence', ''),
        '0029xx5F': ('FD', '1', 'TriggerDelayTime', ''),
        '0029xx60': ('SQ', '1', 'FrameVOILUTSequence', ''),
        '0029xx61': ('LO', '1', 'WindowCenterAndWidthExplanation', ''),
        '0029xx62': ('CS', '1', 'AcquisitionContrast', ''),
        '0029xx63': ('SQ', '1', 'MRModifierSequence', ''),
        '0029xx64': ('CS', '1', 'ParallelAcquisitionTechnic', ''),
        '0029xx65': ('FD', '1', 'ParallelReductionFactorSecIn', ''),
        '0029xx66': ('CS', '1', 'InversionRecovery', ''),
        '0029xx67': ('CS', '1', 'FlowCompensation', ''),
        '0029xx68': ('CS', '1', 'FlowCompensationDirection', ''),
        '0029xx69': ('CS', '1', 'SpatialPreSaturation', ''),
        '0029xx6A': ('CS', '1', 'PartialFourier', ''),
        '0029xx6B': ('CS', '1', 'PartialFourierDirection', ''),
        '0029xx6C': ('CS', '1', 'ResonantNucleus', ''),
        '0029xx6D': ('CS', '1', 'KSpaceFiltering', ''),
        '0029xx6E': ('CS', '1', 'ApplicableSafetyStandardAgency', ''),
        '0029xx6F': ('LO', '1', 'ApplicableSafetyStandardDescription', ''),
        '0029xx70': ('SQ', '1', 'MRReceiveCoilSequence', ''),
        '0029xx71': ('LO', '1', 'ReceiveCoilManufacturerName', ''),
        '0029xx72': ('CS', '1', 'ReceiveCoilType', ''),
        '0029xx73': ('CS', '1', 'QuadratureReceiveCoil', ''),
        '0029xx74': ('LO', '1', 'MultiCoilConfiguration', ''),
        '0029xx75': ('CS', '1', 'ComplexImageComponent', ''),
        '0029xx76': ('SH', '1', 'PulseSequenceName', ''),
        '0029xx77': ('CS', '1', 'EchoPulseSequence', ''),
        '0029xx78': ('CS', '1', 'MultipleSpinEcho', ''),
        '0029xx79': ('CS', '1', 'MultiPlanarExcitation', ''),
        '0029xx7A': ('CS', '1', 'PhaseContrast', ''),
        '0029xx7B': ('CS', '1', 'TimeOfFlightContrast', ''),
        '0029xx7C': ('CS', '1', 'SteadyStatePulseSequence', ''),
        '0029xx7D': ('CS', '1', 'EchoPlanarPulseSequence', ''),
        '0029xx7E': ('CS', '1', 'SpectrallySelectedSuppression', ''),
        '0029xx7F': ('CS', '1', 'OversamplingPhase', ''),
        '0029xx80': ('CS', '1', 'SegmentedKSpaceTraversal', ''),
        '0029xx81': ('CS', '1', 'CoverageOfKSpace', ''),
        '0029xx82': ('SQ', '1', 'MRTimingAndRelatedParametersSequence', ''),
        '0029xx83': ('US', '1', 'RFEchoTrainLength', ''),
        '0029xx84': ('US', '1', 'GradientEchoTrainLength', ''),
        '0029xx85': ('CS', '1', 'GradientOutputType', ''),
        '0029xx86': ('FD', '1', 'GradientOutput', ''),
        '0029xx87': ('SQ', '1', 'MRFOVGeometrySequence', ''),
        '0029xx88': ('US', '1', 'MRAcquisitionFrequencyEncodingSteps', ''),
        '0029xx89': ('US', '1', 'MRAcquisitionPhaseEncodingStepsInPlane', ''),
        '0029xx8A': ('US', '1', 'MRAcquisitionPhaseEncodingStepsOutOfPlane', ''),
        '0029xx8B': ('SQ', '1', 'MRTransmitCoilSequence', ''),
        '0029xx8C': ('SH', '1', 'TransmitCoilName', ''),
        '0029xx8D': ('LO', '1', 'TransmitCoilManufacturerName', ''),
        '0029xx8E': ('CS', '1', 'TransmitCoilType', ''),
        '0029xx8F': ('SQ', '1', 'MREchoSequence', ''),
        '0029xx90': ('FD', '1', 'EffectiveEchoTime', ''),
        '0029xx91': ('SQ', '1', 'MRMetaboliteMapSequence', ''),
        '0029xx92': ('ST', '1', 'MetaboliteMapDescription', ''),
        '0029xx93': ('SQ', '1', 'MetaboliteMapCodeSequence', ''),
        '0029xx94': ('SH', '1', 'MetaboliteMapCodeValue', ''),
        '0029xx95': ('SH', '1', 'MetaboliteMapCodingSchemeDesignator', ''),
        '0029xx96': ('SH', '1', 'MetaboliteMapCodingSchemeVersion', ''),
        '0029xx97': ('LO', '1', 'MetaboliteMapCodeMeaning', ''),
        '0029xx98': ('SQ', '1', 'MRImagingModifierSequence', ''),
        '0029xx99': ('CS', '1', 'MagnetizationTransfer', ''),
        '0029xx9A': ('CS', '1', 'BloodSignalNulling', ''),
        '0029xx9B': ('CS', '1', 'Tagging', ''),
        '0029xx9C': ('FD', '1', 'TagSpacingFirstDimension', ''),
        '0029xx9D': ('FD', '1', 'TagSpacingSecondDimension', ''),
        '0029xx9E': ('FD', '1', 'TagAngleFirstAxis', ''),
        '0029xx9F': ('SS', '1', 'TagAngleSecondAxis', ''),
        '0029xxA0': ('FD', '1', 'TagThickness', ''),
        '0029xxA1': ('FD', '1', 'TaggingDelay', ''),
        '0029xxA2': ('FD', '1', 'TransmitterFrequency', ''),
        '0029xxA3': ('DS', '1', 'PixelBandwidth', ''),
        '0029xxA4': ('SQ', '1', 'MRVelocityEncodingSequence', ''),
        '0029xxA5': ('FD', '1', 'VelocityEncodingDirection', ''),
        '0029xxA6': ('FD', '1', 'VelocityEncodingMinimumValue', ''),
        '0029xxA7': ('FD', '1', 'VelocityEncodingMaximumValue', ''),
        '0029xxA8': ('SQ', '1', 'MRImageFrameTypeSequence', ''),
        '0029xxA9': ('CS', '1', 'FrameType', ''),
        '0029xxAA': ('CS', '1', 'PixelPresentation', ''),
        '0029xxAB': ('CS', '1', 'VolumetricProperties', ''),
        '0029xxAC': ('CS', '1', 'VolumeBasedCalculationTechnique', ''),
        '0029xxAD': ('IS', '1', 'FilmedCount', ''),
        '0029xxAE': ('LO', '1', 'IsTransferred', ''),
        '0029xxAF': ('LO', '1', 'IsArchived', ''),
        '0029xxB0': ('LO', '1', 'MppsStepStatus', ''),
        '0029xxB1': ('LO', '1', 'CommitmentStatus', ''),
        '0029xxB2': ('LO', '1', 'IsStorageCommitted', ''),
        '0029xxB3': ('LO', '1', 'IsDicom', ''),
        '0029xxB4': ('LO', '1', 'IsAllowCascadeSave', ''),
        '0029xxB5': ('LO', '1', 'IsAllowCascadeProtect', ''),
        '0029xxB6': ('LO', '1', 'IsDeleted', ''),
        '0029xxB7': ('OB', '1', 'ApplicationData', ''),
        '0029xxB8': ('LO', '1', 'IsAllowCascadeSave', ''),
        '0029xxB9': ('LO', '1', 'IsAllowCascadeProtect', ''),
        '0029xxBA': ('LO', '1', 'IsDeleted', ''),
        '0029xxBB': ('IS', '1', 'VOI1', ''),
        '0029xxBC': ('IS', '1', 'VOI2', ''),
        '0029xxBD': ('UI', '1', 'BackgroundImageInstanceUID', ''),
        '0029xxBE': ('LO', '1', 'IsStoredToPortableMedia', ''),
        '0029xxBF': ('DS', '1', 'Voi1', ''),
        '0029xxC0': ('FD', '1', 'SelectiveIRColumn', ''),
        '0029xxC1': ('DS', '1', 'Voi2', ''),
        '0029xxC2': ('DS', '1', 'MixingTime', ''),
        '0029xxC3': ('DS', '1', 'SelectiveIRPosition', ''),
        '0029xxC4': ('DS', '1', 'SelectiveIRRow', ''),
        '0029xxC5': ('DS', '1', 'SelectiveIRColumn', ''),
        '0029xxC6': ('DS', '1', 'SelectiveIROrientation', ''),
        '0029xxC7': ('LO', '1', 'SelectiveIRThickness', ''),
        '0029xxC8': ('SH', '1', 'RephaseOrderSlice', ''),
        '0029xxC9': ('SH', '1', 'RephaseOrderPhase', ''),
        '0029xxCA': ('SH', '1', 'RephaseOrderFreq', ''),
        '0029xxCB': ('ST', '1', 'MetaboliteMapDescription', ''),
        '0029xxCC': ('SQ', '1', 'volumeLocalizationSeq', ''),
        '0029xxCD': ('FD', '1', 'SlabThickness', ''),
        '0029xxCE': ('FD', '1', 'SlabOrientation', ''),
        '0029xxCF': ('FD', '1', 'MidSlabPosition', ''),
        '0029xxD0': ('LO', '1', 'AcqModeSliceDir', ''),
        '0029xxD1': ('LO', '1', 'IRThicknessRatio', ''),
        '0029xxD2': ('LO', '1', 'BBIRThicknessRatio', ''),
        '0029xxD3': ('LO', '1', 'DeltaAngle', ''),
        '0029xxD4': ('IS', '1', 'MultiFrameFrameNumber', ''),
        '0029xxD5': ('UI', '1', 'EnhancedSopInstanceUid', ''),
        '0029xxD6': ('LO', '1', 'PolarityOfPhaseEncoding', ''),
        '0029xxD7': ('OB', '1', 'PresentationStates', ''),
        '0029xxD9': ('DS', '3', 'Magnetic Field Direction', ''),
        '0041xx01': ('OB', '1', 'RawDataAppData', ''),
        '0041xx02': ('SQ', '1', 'RawDataIndex', ''),
        '0041xx03': ('LO', '1', 'ChannelNumber', ''),
        '0041xx04': ('LO', '1', 'AxisDirection', ''),
        '0041xx05': ('LO', '1', 'SlabNumbe', ''),
        '0041xx06': ('LO', '1', 'CardiacPhaseNumbe', ''),
        '0041xx07': ('LO', '1', 'EchoNumber', ''),
        '0041xx08': ('LO', '1', 'SliceEncodeNumber', ''),
        '0041xx09': ('LO', '1', 'NsaNumber', ''),
        '0041xx0A': ('OB', '1', 'RawData', ''),
        '0041xx0B': ('SS', '1', 'RawDataMRInfo', ''),
        '0041xx0C': ('IS', '1', 'NumberOfVoxels', ''),
        '0041xx0D': ('DS', '1', 'MixingTime', ''),
        '0041xx0E': ('DS', '1', 'ADDiff', ''),
        '0041xx0F': ('LO', '1', 'ScanTime', ''),
        '0041xx10': ('LO', '1', 'NumPreSat', ''),
        '0041xx11': ('LO', '1', 'IsStoredToPortableMedia', ''),
        '0041xx12': ('DS', '1', 'Voi1', ''),
        '0041xx13': ('DS', '1', 'Voi2', ''),
        '0041xx14': ('DS', '1', 'VoxelSize', ''),
        '0041xx15': ('IS', '1', 'FreqPoint', ''),
        '0041xx16': ('SH', '1', 'LowOrderShim', ''),
        '0041xx17': ('SH', '1', 'EccLevel', ''),
        '0041xx18': ('FL', '1', 'FwhmHz', ''),
        '0041xx19': ('FL', '1', 'FwhmPpm', ''),
        '0041xx1A': ('FL', '1', 'WaterSupRate', ''),
        '0071xx01': ('FL', '1', 'ForegroundTransparency', ''),
        '0071xx02': ('LO', '1', 'IsDisplayBackgroundImage', ''),
        '0071xx03': ('FL', '1', 'ForegroundHorizontalShift', ''),
        '0071xx04': ('FL', '1', 'ForegroundVerticalShift', ''),
        '0071xx05': ('FL', '1', 'ForegroundRotationAngle', ''),
        '0071xx06': ('FL', '1', 'ForegroundMagnification', ''),
        '0071xx07': ('OB', '1', 'ApplicationData', ''),
    },
    'Mayo/IBM Archive Project': {
        '0021xx01': ('UN', '1', 'Unknown', ''),
        '0021xx10': ('UN', '1', 'Unknown', ''),
        '0021xx11': ('UN', '1', 'Unknown', ''),
        '0021xx12': ('UN', '1', 'Unknown', ''),
        '0021xx13': ('UN', '1', 'Unknown', ''),
        '0021xx14': ('UN', '1', 'Unknown', ''),
        '0021xx15': ('UN', '1', 'Unknown', ''),
        '0021xx16': ('UN', '1', 'Unknown', ''),
        '0021xx17': ('UN', '1', 'Unknown', ''),
        '0021xx18': ('UN', '1', 'Unknown', ''),
        '0021xx19': ('UN', '1', 'Unknown', ''),
        '0021xx1A': ('UN', '1', 'Unknown', ''),
        '0021xx1B': ('UN', '1', 'Unknown', ''),
        '0021xx1C': ('UN', '1', 'Unknown', ''),
        '0021xx1D': ('UN', '1', 'Unknown', ''),
        '0021xx1E': ('UN', '1', 'Unknown', ''),
        '0021xx1F': ('UN', '1', 'Unknown', ''),
        '0021xx20': ('UN', '1', 'Unknown', ''),
        '0021xx40': ('UN', '1', 'Unknown', ''),
        '0021xx41': ('UN', '1', 'Unknown', ''),
        '0021xx50': ('UN', '1', 'Unknown', ''),
        '0021xx60': ('UN', '1', 'Unknown', ''),
        '0021xx65': ('UN', '1', 'Unknown', ''),
    },
    'MeVis BreastCare': {
        '0019xx01': ('LO', '1', 'Unknown', ''),
        '0071xx01': ('LO', '1', 'Unknown', ''),
    },
    'MeVis eD: Geometry Information': {
        '0009xx11': ('UN', '1', 'GeoScannerOrigin', ''),
        '0009xx21': ('UN', '1', 'SlicesID', ''),
    },
    'MeVis eD: Slice Information': {
        '0009xx10': ('UN', '1', 'SlicesSOPInstanceUID', ''),
    },
    'MeVis eD: Timepoint Information': {
        '0009xx10': ('UN', '1', 'TPDateTime', ''),
        '0009xx11': ('UN', '1', 'TPDateTimeType', ''),
        '0009xx12': ('UN', '1', 'TPSeriesDescription', ''),
        '0009xx13': ('UN', '1', 'TPGradientDirections', ''),
        '0009xx21': ('UN', '1', 'GeometryID', ''),
    },
    'MeVis eatDicom': {
        '0009xx10': ('UN', '1', 'EatDicomVersion', ''),
        '0009xx11': ('UN', '1', 'EatDicomOptions', ''),
        '0009xx21': ('UN', '1', 'TimepointsID', ''),
    },
    'MedIns HP Extensions': {
        '5473xx03': ('LO', '1', 'Unknown', ''),
    },
    'Mitra Markup 1.0': {
        '0029xx00': ('OB', '1-n', 'Markup1', ''),
        '0029xx01': ('OB', '1-n', 'Markup2', ''),
        '0029xx02': ('OB', '1-n', 'Markup3', ''),
        '0029xx03': ('OB', '1-n', 'Markup4', ''),
        '0029xx04': ('OB', '1-n', 'Markup5', ''),
        '0029xx05': ('OB', '1-n', 'Markup6', ''),
        '0029xx06': ('OB', '1-n', 'Markup7', ''),
        '0029xx07': ('OB', '1-n', 'Markup8', ''),
        '0029xx08': ('OB', '1-n', 'Markup9', ''),
        '0029xx09': ('OB', '1-n', 'Markup10', ''),
        '0029xx10': ('OB', '1-n', 'Markup11', ''),
        '0029xx11': ('OB', '1-n', 'Markup12', ''),
        '0029xx12': ('OB', '1', 'Markup13', ''),
        '0029xx13': ('OB', '1', 'Markup14', ''),
        '0029xx14': ('OB', '1', 'Markup15', ''),
    },
    'Mitra Object Document 1.0': {
        '0029xx00': ('OB', '1', 'IMPAX object document', ''),
        '0029xx10': ('OB', '1', 'IMPAX markup XML stored', ''),
    },
    'Mitra Presentation 1.0': {
        '0029xx00': ('CS', '1', 'Mitra Rotation', ''),
        '0029xx01': ('LO', '1', 'Mitra Window Width', ''),
        '0029xx02': ('LO', '1', 'Mitra Window Centre', ''),
        '0029xx03': ('IS', '1', 'Mitra Invert', ''),
        '0029xx04': ('IS', '1', 'Mitra Has Tabstop', ''),
        '0029xx05': ('CS', '1', 'Smooth Rotation', ''),
    },
    'Mortara_Inc': {
        '1455xx00': ('OW', '1', 'ELI Interpretation Vector', ''),
        '1455xx01': ('UN', '1', 'Custom ID', ''),
        '1455xx02': ('UT', '1', 'Race', ''),
        '1455xx03': ('UT', '1', 'Social Security Number', ''),
        '1455xx04': ('UT', '1', 'Attending Physician', ''),
        '1455xx05': ('UT', '1', 'Procedural Diagnosis', ''),
        '1455xx06': ('UT', '1', 'Note1', ''),
        '1455xx07': ('UT', '1', 'Note2', ''),
        '1455xx08': ('LO', '1', 'Order Request Number', ''),
        '1455xx10': ('LO', '1', 'Manufacturer Name', ''),
    },
    'NUD_PRIVATE': {
        '7777xx02': ('UT', '1', 'Interfile', ''),
        '7777xx05': ('IS', '1', 'Unknown', ''),
    },
    'ObjectModel (ID, Version, Place, PlaceDescription)': {
        '8101xx00': ('LO', '1', 'ID', ''),
        '8101xx10': ('LO', '1', 'Version', ''),
    },
    'PAPYRUS': {
        '0009xx00': ('LT', '1', 'Original File Name', ''),
        '0009xx10': ('LT', '1', 'Original File Location', ''),
        '0009xx18': ('LT', '1', 'Data Set Identifier', ''),
        '0041xx00': ('LT', '1-n', 'Papyrus Comments', ''),
        '0041xx10': ('US', '1', 'Folder Type', ''),
        '0041xx11': ('LT', '1', 'Patient Folder Data Set ID', ''),
        '0041xx20': ('LT', '1', 'Folder Name', ''),
        '0041xx30': ('DA', '1', 'Creation Date', ''),
        '0041xx32': ('TM', '1', 'Creation Time', ''),
        '0041xx34': ('DA', '1', 'Modified Date', ''),
        '0041xx36': ('TM', '1', 'Modified Time', ''),
        '0041xx40': ('LT', '1-n', 'Owner Name', ''),
        '0041xx50': ('LT', '1', 'Folder Status', ''),
        '0041xx60': ('UL', '1', 'Number of Images', ''),
        '0041xx62': ('UL', '1', 'Number of Other', ''),
        '0041xxA0': ('LT', '1-n', 'External Folder Element DSID', ''),
        '0041xxA1': ('US', '1-n', 'External Folder Element Data Set Type', ''),
        '0041xxA2': ('LT', '1-n', 'External Folder Element File Location', ''),
        '0041xxA3': ('UL', '1-n', 'External Folder Element Length', ''),
        '0041xxB0': ('LT', '1-n', 'Internal Folder Element DSID', ''),
        '0041xxB1': ('US', '1-n', 'Internal Folder Element Data Set Type', ''),
        '0041xxB2': ('UL', '1-n', 'Internal Offset To Data Set', ''),
        '0041xxB3': ('UL', '1-n', 'Internal Offset To Image', ''),
    },
    'PAPYRUS 3.0': {
        '0041xx00': ('LT', '1', 'Comments', ''),
        '0041xx10': ('SQ', '1', 'Pointer Sequence', ''),
        '0041xx11': ('UL', '1', 'Image Pointer', ''),
        '0041xx12': ('UL', '1', 'Pixel Offset', ''),
        '0041xx13': ('SQ', '1', 'Image Identifier Sequence', ''),
        '0041xx14': ('SQ', '1', 'External PAPYRUS-File Reference Sequence', ''),
        '0041xx15': ('US', '1', 'Number of images', ''),
        '0041xx21': ('UI', '1', 'Referenced SOP Class UID', ''),
        '0041xx22': ('UI', '1', 'Referenced SOP Instance UID', ''),
        '0041xx31': ('LO', '1', 'Referenced File Name', ''),
        '0041xx32': ('LO', '1-n', 'Referenced File Path', ''),
        '0041xx41': ('UI', '1', 'Referenced Image SOP Class UID', ''),
        '0041xx42': ('UI', '1', 'Referenced Image SOP Instance UID', ''),
        '0041xx50': ('SQ', '1', 'Image Sequence', ''),
        '60xxxx00': ('IS', '1', 'Overlay ID', ''),
        '60xxxx01': ('LT', '1-n', 'Linked Overlays', ''),
        '60xxxx10': ('US', '1', 'Overlay Rows', ''),
        '60xxxx11': ('US', '1', 'Overlay Columns', ''),
        '60xxxx40': ('LO', '1', 'Overlay Type', ''),
        '60xxxx50': ('US', '1-n', 'Overlay Origin', ''),
        '60xxxx60': ('LO', '1', 'Editable', ''),
        '60xxxx70': ('LO', '1', 'Overlay Font', ''),
        '60xxxx72': ('LO', '1', 'Overlay Style', ''),
        '60xxxx74': ('US', '1', 'Overlay Font Size', ''),
        '60xxxx76': ('LO', '1', 'Overlay Color', ''),
        '60xxxx78': ('US', '1', 'Shadow Size', ''),
        '60xxxx80': ('LO', '1', 'Fill Pattern', ''),
        '60xxxx82': ('US', '1', 'Overlay Pen Size', ''),
        '60xxxxA0': ('LO', '1', 'Label', ''),
        '60xxxxA2': ('LT', '1', 'Post It Text', ''),
        '60xxxxA4': ('US', '2', 'Anchor Point', ''),
        '60xxxxB0': ('LO', '1', 'ROI Type', ''),
        '60xxxxB2': ('LT', '1', 'Attached Annotation', ''),
        '60xxxxBA': ('US', '1-n', 'Contour Points', ''),
        '60xxxxBC': ('US', '1-n', 'Mask Data', ''),
        '60xxxxC0': ('SQ', '1', 'UIN Overlay Sequence', ''),
    },
    'PHILIPS MR': {
        '0009xx10': ('LO', '1', 'SPI Release', ''),
        '0009xx12': ('LO', '1', 'Unknown', ''),
    },
    'PHILIPS MR R5.5/PART': {
        '0019xx00': ('DS', '2', 'Field of View', ''),
    },
    'PHILIPS MR R5.6/PART': {
        '0019xx00': ('DS', '1', 'Field of View', ''),
    },
    'PHILIPS MR SPECTRO;1': {
        '0019xx01': ('US', '1', 'Unknown', ''),
        '0019xx02': ('US', '1', 'Unknown', ''),
        '0019xx03': ('US', '1', 'Unknown', ''),
        '0019xx04': ('US', '1', 'Unknown', ''),
        '0019xx05': ('US', '1', 'Unknown', ''),
        '0019xx06': ('US', '1', 'Unknown', ''),
        '0019xx07': ('IS', '1', 'Unknown', ''),
        '0019xx08': ('IS', '1', 'Unknown', ''),
        '0019xx09': ('IS', '1', 'Unknown', ''),
        '0019xx10': ('IS', '1', 'Unknown', ''),
        '0019xx12': ('IS', '1', 'Unknown', ''),
        '0019xx13': ('IS', '1', 'Unknown', ''),
        '0019xx14': ('US', '1', 'Unknown', ''),
        '0019xx15': ('US', '1-n', 'Unknown', ''),
        '0019xx16': ('IS', '1', 'Unknown', ''),
        '0019xx17': ('IS', '1', 'Unknown', ''),
        '0019xx18': ('UN', '1', 'Unknown', ''),
        '0019xx20': ('IS', '1', 'Unknown', ''),
        '0019xx21': ('IS', '1', 'Unknown', ''),
        '0019xx22': ('IS', '1', 'Unknown', ''),
        '0019xx23': ('IS', '1', 'Unknown', ''),
        '0019xx24': ('IS', '1', 'Unknown', ''),
        '0019xx25': ('IS', '1', 'Unknown', ''),
        '0019xx26': ('IS', '1', 'Unknown', ''),
        '0019xx27': ('IS', '1', 'Unknown', ''),
        '0019xx28': ('IS', '1', 'Unknown', ''),
        '0019xx29': ('IS', '1-n', 'Unknown', ''),
        '0019xx31': ('US', '1', 'Unknown', ''),
        '0019xx32': ('US', '1', 'Unknown', ''),
        '0019xx41': ('LT', '1', 'Unknown', ''),
        '0019xx42': ('IS', '2', 'Unknown', ''),
        '0019xx43': ('IS', '2', 'Unknown', ''),
        '0019xx45': ('US', '1', 'Unknown', ''),
        '0019xx46': ('US', '1', 'Unknown', ''),
        '0019xx47': ('IS', '1', 'Unknown', ''),
        '0019xx48': ('IS', '1', 'Unknown', ''),
        '0019xx49': ('US', '1', 'Unknown', ''),
        '0019xx50': ('UN', '1', 'Unknown', ''),
        '0019xx60': ('US', '1', 'Unknown', ''),
        '0019xx61': ('US', '1', 'Unknown', ''),
        '0019xx70': ('UN', '1', 'Unknown', ''),
        '0019xx71': ('IS', '1-n', 'Unknown', ''),
        '0019xx72': ('US', '1', 'Unknown', ''),
        '0019xx73': ('US', '1', 'Unknown', ''),
        '0019xx74': ('US', '1', 'Unknown', ''),
        '0019xx76': ('US', '1', 'Unknown', ''),
        '0019xx77': ('US', '1', 'Unknown', ''),
        '0019xx78': ('US', '1', 'Unknown', ''),
        '0019xx79': ('US', '1', 'Unknown', ''),
        '0019xx80': ('IS', '1', 'Unknown', ''),
    },
    'PHILIPS MR/LAST': {
        '0019xx09': ('DS', '1', 'Main Magnetic Field', ''),
        '0019xx0E': ('IS', '1', 'Flow Compensation', ''),
        '0019xxB1': ('IS', '1', 'Minimum RR Interval', ''),
        '0019xxB2': ('IS', '1', 'Maximum RR Interval', ''),
        '0019xxB3': ('IS', '1', 'Number of Rejections', ''),
        '0019xxB4': ('IS', '1-n', 'Number of RR Intervals', ''),
        '0019xxB5': ('IS', '1', 'Arrhythmia Rejection', ''),
        '0019xxB7': ('IS', '1', 'Unknown', ''),
        '0019xxC0': ('DS', '1-n', 'Unknown', ''),
        '0019xxC6': ('IS', '1', 'Cycled Multiple Slice', ''),
        '0019xxCE': ('IS', '1', 'REST', ''),
        '0019xxD5': ('DS', '1', 'Unknown', ''),
        '0019xxD6': ('IS', '1', 'Fourier Interpolation', ''),
        '0019xxD9': ('IS', '1-n', 'Unknown', ''),
        '0019xxE0': ('IS', '1', 'Prepulse', ''),
        '0019xxE1': ('DS', '1', 'Prepulse Delay', ''),
        '0019xxE2': ('IS', '1', 'Unknown', ''),
        '0019xxE3': ('DS', '1', 'Unknown', ''),
        '0019xxE4': ('IS', '1', 'Unknown', ''),
        '0019xxE5': ('DS', '1', 'Unknown', ''),
        '0019xxF0': ('LT', '1', 'WS Protocol String 1', ''),
        '0019xxF1': ('LT', '1', 'WS Protocol String 2', ''),
        '0019xxF2': ('LT', '1', 'WS Protocol String 3', ''),
        '0019xxF3': ('LT', '1', 'WS Protocol String 4', ''),
        '0021xx00': ('IS', '1', 'Unknown', ''),
        '0021xx10': ('IS', '1', 'Unknown', ''),
        '0021xx20': ('IS', '1', 'Unknown', ''),
        '0021xx21': ('DS', '1', 'Slice Gap', ''),
        '0021xx22': ('DS', '1', 'Stack Radial Angle', ''),
        '0027xx00': ('US', '1', 'Unknown', ''),
        '0027xx11': ('US', '1-n', 'Unknown', ''),
        '0027xx12': ('DS', '1-n', 'Unknown', ''),
        '0027xx13': ('DS', '1-n', 'Unknown', ''),
        '0027xx14': ('DS', '1-n', 'Unknown', ''),
        '0027xx15': ('DS', '1-n', 'Unknown', ''),
        '0027xx16': ('LO', '1', 'Unknown', ''),
        '0029xx10': ('DS', '1', 'FP Min', ''),
        '0029xx20': ('DS', '1', 'FP Max', ''),
        '0029xx30': ('DS', '1', 'Scaled Minimum', ''),
        '0029xx40': ('DS', '1', 'Scaled Maximum', ''),
        '0029xx50': ('DS', '1', 'Window Minimum', ''),
        '0029xx60': ('DS', '1', 'Window Maximum', ''),
        '0029xx61': ('IS', '1', 'Unknown', ''),
        '0029xx62': ('IS', '1', 'Unknown', ''),
        '0029xx70': ('DS', '1', 'Unknown', ''),
        '0029xx71': ('DS', '1', 'Unknown', ''),
        '0029xx72': ('IS', '1', 'Unknown', ''),
        '0029xx80': ('IS', '2', 'View Center', ''),
        '0029xx81': ('IS', '2', 'View Size', ''),
        '0029xx82': ('IS', '1', 'View Zoom', ''),
        '0029xx83': ('IS', '1', 'View Transform', ''),
        '0041xx07': ('LO', '1', 'Unknown', ''),
        '0041xx09': ('DS', '1', 'Unknown', ''),
        '6001xx00': ('LT', '1', 'Unknown', ''),
    },
    'PHILIPS MR/PART': {
        '0019xx00': ('DS', '1', 'Field of View', ''),
        '0019xx01': ('IS', '1-n', 'Stack Type', ''),
        '0019xx02': ('IS', '1-n', 'Unknown', ''),
        '0019xx03': ('DS', '1', 'Unknown', ''),
        '0019xx05': ('DS', '1', 'CC Angulation', ''),
        '0019xx06': ('DS', '1', 'AP Angulation', ''),
        '0019xx07': ('DS', '1', 'LR Angulation', ''),
        '0019xx08': ('IS', '1', 'Patient Orientation 1', ''),
        '0019xx09': ('IS', '1', 'Patient Orientation', ''),
        '0019xx0A': ('IS', '1', 'Slice Orientation', ''),
        '0019xx0B': ('DS', '1', 'LR Offcenter', ''),
        '0019xx0C': ('DS', '1', 'CC Offcenter', ''),
        '0019xx0D': ('DS', '1', 'AP Offcenter', ''),
        '0019xx0E': ('DS', '1', 'Unknown', ''),
        '0019xx0F': ('IS', '1', 'Number of Slices', ''),
        '0019xx10': ('DS', '1', 'Slice Factor', ''),
        '0019xx11': ('DS', '1-n', 'Echo Times', ''),
        '0019xx14': ('CS', '1', 'Unknown', ''),
        '0019xx15': ('IS', '1', 'Dynamic Study', ''),
        '0019xx18': ('DS', '1', 'Heartbeat Interval', ''),
        '0019xx19': ('DS', '1', 'Repetition Time FFE', ''),
        '0019xx1A': ('DS', '1', 'FFE Flip Angle', ''),
        '0019xx1B': ('IS', '1', 'Number of Scans', ''),
        '0019xx1C': ('CS', '1', 'Unknown', ''),
        '0019xx1D': ('CS', '1', 'Unknown', ''),
        '0019xx1E': ('DS', '1', 'Unknown', ''),
        '0019xx21': ('DS', '1-n', 'Unknown', ''),
        '0019xx22': ('DS', '1', 'Dynamic Scan Time Begin', ''),
        '0019xx23': ('DS', '1-n', 'Unknown', ''),
        '0019xx24': ('IS', '1', 'Unknown', ''),
        '0019xx25': ('DS', '1-n', 'Unknown', ''),
        '0019xx26': ('DS', '1-n', 'Unknown', ''),
        '0019xx27': ('DS', '1-n', 'Unknown', ''),
        '0019xx28': ('CS', '1', 'Unknown', ''),
        '0019xx29': ('DS', '1-n', 'Unknown', ''),
        '0019xx30': ('LO', '1-n', 'Unknown', ''),
        '0019xx31': ('DS', '1-n', 'Unknown', ''),
        '0019xx40': ('US', '1', 'Unknown', ''),
        '0019xx45': ('IS', '1', 'Reconstruction Resolution', ''),
        '0019xx50': ('IS', '1', 'Unknown', ''),
        '0019xx51': ('DS', '1', 'Unknown', ''),
        '0019xx52': ('DS', '1', 'Unknown', ''),
        '0019xx53': ('IS', '1', 'Unknown', ''),
        '0019xx54': ('DS', '1', 'Unknown', ''),
        '0019xx55': ('DS', '1', 'Unknown', ''),
        '0019xx56': ('DS', '1', 'Unknown', ''),
        '0019xx57': ('US', '1', 'Unknown', ''),
        '0019xx58': ('DS', '1', 'Unknown', ''),
        '0019xx59': ('US', '1', 'Unknown', ''),
        '0019xx60': ('DS', '1', 'Unknown', ''),
        '0019xx61': ('DS', '1', 'Unknown', ''),
        '0019xx62': ('DS', '1', 'Unknown', ''),
        '0019xx63': ('DS', '1', 'Unknown', ''),
        '0019xx64': ('DS', '1', 'Repetition Time SE', ''),
        '0019xx65': ('DS', '1', 'Repetition Time IR', ''),
        '0019xx66': ('US', '1', 'Unknown', ''),
        '0019xx67': ('US', '1', 'Unknown', ''),
        '0019xx69': ('IS', '1', 'Number of Phases', ''),
        '0019xx6A': ('IS', '1', 'Cardiac Frequency', ''),
        '0019xx6B': ('DS', '1', 'Inversion Delay', ''),
        '0019xx6C': ('DS', '1', 'Gate Delay', ''),
        '0019xx6D': ('DS', '1', 'Gate Width', ''),
        '0019xx6E': ('DS', '1', 'Trigger Delay Time', ''),
        '0019xx70': ('DS', '1-n', 'Unknown', ''),
        '0019xx80': ('IS', '1', 'Number of Chemical Shifts', ''),
        '0019xx81': ('DS', '1', 'Chemical Shift', ''),
        '0019xx84': ('IS', '1', 'Number of Rows', ''),
        '0019xx85': ('IS', '1', 'Number of Samples', ''),
        '0019xx8A': ('CS', '1', 'Unknown', ''),
        '0019xx8B': ('CS', '1', 'Unknown', ''),
        '0019xx8C': ('CS', '1', 'Unknown', ''),
        '0019xx8D': ('CS', '1', 'Unknown', ''),
        '0019xx8E': ('CS', '1', 'Unknown', ''),
        '0019xx8F': ('CS', '1', 'Unknown', ''),
        '0019xx94': ('LO', '1', 'Magnetization Transfer Contrast', ''),
        '0019xx95': ('LO', '1', 'Spectral Presaturation With Inversion Recovery', ''),
        '0019xx96': ('IS', '1', 'Unknown', ''),
        '0019xx97': ('LO', '1', 'Unknown', ''),
        '0019xx99': ('LO', '1', 'Unknown', ''),
        '0019xxA0': ('IS', '1', 'Unknown', ''),
        '0019xxA1': ('DS', '1', 'Unknown', ''),
        '0019xxA3': ('DS', '1', 'Unknown', ''),
        '0019xxA4': ('CS', '1', 'Unknown', ''),
        '0019xxB4': ('DS', '1', 'Unknown', ''),
        '0019xxB5': ('DS', '1', 'Unknown', ''),
        '0019xxB6': ('DS', '1', 'Unknown', ''),
        '0019xxC0': ('DS', '1', 'Trigger Delay Times', ''),
        '0019xxC8': ('IS', '1', 'Unknown', ''),
        '0019xxC9': ('IS', '1', 'Foldover Direction Transverse', ''),
        '0019xxCA': ('IS', '1', 'Foldover Direction Sagittal', ''),
        '0019xxCB': ('IS', '1', 'Foldover Direction Coronal', ''),
        '0019xxCC': ('IS', '1', 'Unknown', ''),
        '0019xxCD': ('IS', '1', 'Unknown', ''),
        '0019xxCE': ('IS', '1', 'Unknown', ''),
        '0019xxCF': ('IS', '1', 'Number of Echoes', ''),
        '0019xxD0': ('IS', '1', 'Scan Resolution', ''),
        '0019xxD1': ('US', '1', 'Unknown', ''),
        '0019xxD2': ('LO', '2', 'Water Fat Shift', ''),
        '0019xxD3': ('DS', '1', 'Unknown', ''),
        '0019xxD4': ('IS', '1', 'Artifact Reduction', ''),
        '0019xxD5': ('IS', '1', 'Unknown', ''),
        '0019xxD6': ('IS', '1', 'Unknown', ''),
        '0019xxD7': ('DS', '1', 'Scan Percentage', ''),
        '0019xxD8': ('IS', '1', 'Halfscan', ''),
        '0019xxD9': ('IS', '1', 'EPI Factor', ''),
        '0019xxDA': ('IS', '1', 'Turbo Factor', ''),
        '0019xxDB': ('IS', '1', 'Unknown', ''),
        '0019xxE0': ('IS', '1', 'Percentage of Scan Completed', ''),
        '0019xxE1': ('DS', '1', 'Prepulse Delay', ''),
        '0019xxE3': ('DS', '1', 'Phase Contrast Velocity', ''),
        '0019xxF0': ('IS', '1', 'Unknown', ''),
        '0019xxF6': ('CS', '1', 'Unknown', ''),
        '0019xxF7': ('CS', '1', 'Unknown', ''),
        '0019xxF8': ('CS', '1', 'Unknown', ''),
        '0019xxF9': ('CS', '1', 'Unknown', ''),
        '0019xxFA': ('CS', '1', 'Unknown', ''),
        '0019xxFB': ('CS', '1', 'Unknown', ''),
        '0019xxFC': ('IS', '1', 'Resonance Frequency', ''),
        '0021xx00': ('IS', '1', 'Scan Date', ''),
        '0021xx06': ('LO', '1', 'Unknown', ''),
        '0021xx07': ('DT', '1', 'Unknown', ''),
        '0021xx08': ('LO', '1', 'Unknown', ''),
        '0021xx09': ('CS', '1', 'Unknown', ''),
        '0021xx0A': ('CS', '1', 'Unknown', ''),
        '0021xx0F': ('LO', '1', 'Unknown', ''),
        '0021xx10': ('IS', '1', 'Image Type', ''),
        '0021xx13': ('CS', '1', 'Unknown', ''),
        '0021xx14': ('LO', '1', 'Unknown', ''),
        '0021xx15': ('US', '1', 'Unknown', ''),
        '0021xx20': ('IS', '1', 'Slice Number', ''),
        '0021xx21': ('IS', '1', 'Slice Gap', ''),
        '0021xx30': ('IS', '1', 'Echo Number', ''),
        '0021xx31': ('DS', '1', 'Patient Reference ID', ''),
        '0021xx35': ('IS', '1', 'Chemical Shift Number', ''),
        '0021xx40': ('IS', '1', 'Phase Number', ''),
        '0021xx50': ('IS', '1', 'Dynamic Scan Number', ''),
        '0021xx60': ('IS', '1', 'Number of Rows In Object', ''),
        '0021xx61': ('IS', '1-n', 'Row Number', ''),
        '0021xx62': ('IS', '1-n', 'Unknown', ''),
        '0029xx00': ('DS', '2', 'Unknown', ''),
        '0029xx04': ('US', '1', 'Unknown', ''),
        '0029xx10': ('DS', '1', 'Unknown', ''),
        '0029xx11': ('DS', '1', 'Unknown', ''),
        '0029xx20': ('LO', '1', 'Unknown', ''),
        '0029xx31': ('DS', '2', 'Unknown', ''),
        '0029xx32': ('DS', '2', 'Unknown', ''),
        '0029xx50': ('DS', '1', 'Unknown', ''),
        '0029xx51': ('DS', '1', 'Unknown', ''),
        '0029xx52': ('DS', '1', 'Unknown', ''),
        '0029xx53': ('DS', '1', 'Unknown', ''),
        '0029xxC3': ('IS', '1', 'Scan Resolution', ''),
        '0029xxC4': ('IS', '1', 'Field of View', ''),
        '0029xxD5': ('LT', '1', 'Slice Thickness', ''),
    },
    'PHILIPS MR/PART 12': {
        '0009xx10': ('US', '1', 'Unknown', ''),
    },
    'PHILIPS MR/PART 6': {
        '0019xx10': ('IS', '1', 'Unknown', ''),
    },
    'PHILIPS MR/PART 7': {
        '0019xx00': ('IS', '1', 'Unknown', ''),
    },
    'PHILIPS NM -Private': {
        '7051xx00': ('US', '1', 'Current Segment', ''),
        '7051xx01': ('US', '1', 'Number of Segments', ''),
        '7051xx02': ('FL', '1', 'Segment Start Position', ''),
        '7051xx03': ('FL', '1', 'Segment Stop Position', ''),
        '7051xx04': ('FL', '1', 'Rel. COR offset - X dir.', ''),
        '7051xx05': ('FL', '1', 'Rel. COR offset - Z dir.', ''),
        '7051xx06': ('US', '1', 'Current Rotation Number', ''),
        '7051xx07': ('US', '1', 'Number of Rotations', ''),
        '7051xx10': ('DS', '1', 'Alignment Translations', ''),
        '7051xx11': ('DS', '1', 'Alignment Rotations', ''),
        '7051xx12': ('DS', '1', 'Alignment Timestamp', ''),
    },
    'PHILIPS UNDOCUMENTED': {
        '5503xx12': ('SL', '1', 'Slice Thickness', ''),
        '5503xx24': ('UT', '1', 'Plane', ''),
        '5503xx30': ('SS', '1', 'Number of Slices', ''),
        '5503xxA5': ('UT', '1', 'Prepulse', ''),
        '5503xxAE': ('SS', '1', 'Contrast Agent Flag', ''),
        '5503xxBB': ('SL', '1', 'Coil ID', ''),
        '5503xxC2': ('UT', '1', 'Anatomy', ''),
        '5503xxC3': ('UT', '1', 'Indication', ''),
    },
    'PHILIPS UNKNOWN': {
        '2001xx01': ('UN', '1', 'MRSeriesNrOfEchoes', ''),
        '2001xx02': ('UN', '1', 'MRSeriesScanningTechniqueDescription', ''),
        '2001xx05': ('UN', '1', 'StackSequence', ''),
        '2001xx06': ('UN', '1', 'Examination Source', ''),
        '2001xx07': ('UN', '1', 'MRSeriesAcquisitionNumber', ''),
        '2001xx08': ('UN', '1', 'MRSeriesNrOfDynamicScans', ''),
        '2005xx02': ('UN', '1', 'MRSeriesNrOfChemicalShifts', ''),
        '2005xx03': ('UN', '1', 'MRSeriesRepetitionTime', ''),
        '2005xx36': ('UN', '1', 'MRVolumeSelection', ''),
    },
    'PHILIPS-MR-1': {
        '0019xx11': ('IS', '1', 'Chemical Shift Number', ''),
        '0019xx12': ('IS', '1', 'Phase Number (Philips)', ''),
        '0021xx01': ('IS', '1', 'Reconstruction Number', ''),
        '0021xx02': ('IS', '1', 'Slice Number', ''),
    },
    'PMOD_1': {
        '0055xx01': ('FD', '1-n', 'Frame Start Times Vector', ''),
        '0055xx02': ('FD', '3-3n', 'Frame Positions Vector', ''),
        '0055xx03': ('FD', '6-6n', 'Frame Orientations Vector', ''),
        '0055xx04': ('FD', '1-n', 'Frame Durations (ms) Vector', ''),
        '0055xx05': ('FD', '1-n', 'Frame Rescale Slope Vector', ''),
    },
    'PMOD_GENPET': {
        '7FE1xx01': ('UT', '1', 'Slices Names', ''),
        '7FE1xx02': ('UT', '1', 'Gene Codes', ''),
        '7FE1xx03': ('UT', '1', 'Gene Labels', ''),
    },
    'PMS-THORA-5.1': {
        '0089xx20': ('SQ', '1', 'Stamp Image Sequence', ''),
    },
    'PMTF INFORMATION DATA': {
        '00290089': ('LO', '1', 'Unknown', ''),
        '0029xx01': ('SQ', '1', 'Unknown', ''),
        '0029xx31': ('LO', '1', 'PMTF Information 1', ''),
        '0029xx32': ('UL', '1', 'PMTF Information 2', ''),
        '0029xx33': ('UL', '1', 'PMTF Information 3', ''),
        '0029xx34': ('CS', '1', 'PMTF Information 4', ''),
        '0029xx89': ('LO', '1', 'Unknown', ''),
        '0029xx90': ('OB', '1', 'Unknown', ''),
        '7015xx73': ('SQ', '1', 'Unknown', ''),
    },
    'PMTF INFORMATION DATA^10': {
        '00090002': ('SH', '1', 'Unknown', ''),
        '00110003': ('US', '1', 'Unknown', ''),
        '00110004': ('SQ', '1', 'Unknown', ''),
        '00110005': ('US', '1', 'Unknown', ''),
        '00110006': ('US', '1', 'Unknown', ''),
        '00110007': ('US', '1-n', 'Unknown', ''),
        '00110008': ('SH', '1', 'Unknown', ''),
        '00190001': ('UL', '1', 'Unknown', ''),
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('US', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190005': ('FL', '1', 'Unknown', ''),
        '00190006': ('SL', '1', 'Unknown', ''),
        '00190007': ('FL', '3', 'Unknown', ''),
        '00190008': ('US', '1', 'Unknown', ''),
        '00190009': ('FL', '1', 'Unknown', ''),
        '0019000A': ('FL', '1', 'Unknown', ''),
        '0019000B': ('FL', '1', 'Unknown', ''),
        '0019000C': ('US', '3', 'Unknown', ''),
        '0019000D': ('SL', '6', 'Unknown', ''),
        '0019000E': ('SL', '6', 'Unknown', ''),
        '0019000F': ('SL', '6', 'Unknown', ''),
        '00190010': ('US', '2', 'Unknown', ''),
        '00190011': ('SL', '2', 'Unknown', ''),
        '00190012': ('US', '1', 'Unknown', ''),
        '00190013': ('SL', '1', 'Unknown', ''),
        '00190014': ('US', '1', 'Unknown', ''),
        '00190015': ('SL', '1', 'Unknown', ''),
        '00190016': ('FL', '1', 'Unknown', ''),
        '00190017': ('SL', '1', 'Unknown', ''),
        '00190018': ('US', '1', 'Unknown', ''),
        '00190019': ('SL', '1', 'Unknown', ''),
        '0019001A': ('US', '1', 'Unknown', ''),
        '0019001B': ('SL', '1', 'Unknown', ''),
        '0019001C': ('SL', '1', 'Unknown', ''),
        '0019001D': ('SL', '1', 'Unknown', ''),
        '0019001E': ('US', '1', 'Unknown', ''),
        '0019001F': ('SL', '1', 'Unknown', ''),
        '00190020': ('FL', '2', 'Unknown', ''),
        '00190021': ('US', '1', 'Unknown', ''),
        '00190022': ('SL', '2', 'Unknown', ''),
        '00190023': ('FL', '1', 'Unknown', ''),
        '00190024': ('FL', '1', 'Unknown', ''),
        '00190025': ('FL', '1', 'Unknown', ''),
        '00190026': ('SL', '1', 'Unknown', ''),
        '00190027': ('SL', '1', 'Unknown', ''),
        '00190028': ('SL', '1', 'Unknown', ''),
        '00190029': ('SH', '1', 'Unknown', ''),
        '0019002A': ('SL', '1', 'Unknown', ''),
        '0019002B': ('SH', '1', 'Unknown', ''),
        '0019002C': ('SL', '1', 'Unknown', ''),
        '0019002D': ('SL', '1', 'Unknown', ''),
        '0019002E': ('US', '1', 'Unknown', ''),
        '0019002F': ('FL', '1', 'Unknown', ''),
        '00190030': ('UL', '1', 'Unknown', ''),
        '00190031': ('OF', '1-n', 'Unknown', ''),
        '00190032': ('FL', '1', 'Unknown', ''),
        '00190033': ('SL', '3', 'Unknown', ''),
        '00190034': ('SL', '1', 'Unknown', ''),
        '00190035': ('SL', '1', 'Unknown', ''),
        '00190036': ('SQ', '1', 'Unknown', ''),
        '00190038': ('SL', '1', 'Unknown', ''),
        '00190039': ('SL', '1', 'Unknown', ''),
        '0019003A': ('SL', '1', 'Unknown', ''),
        '0019003B': ('SL', '2', 'Unknown', ''),
        '0019003C': ('SL', '1', 'Unknown', ''),
        '0019003D': ('SL', '1', 'Unknown', ''),
        '0019003E': ('SL', '1', 'Unknown', ''),
        '0019003F': ('SL', '1', 'Unknown', ''),
        '00190042': ('US', '1', 'Unknown', ''),
        '00190043': ('US', '1', 'Unknown', ''),
        '00190044': ('SL', '1', 'Unknown', ''),
        '00190045': ('SS', '1', 'Unknown', ''),
        '00190046': ('US', '1', 'Unknown', ''),
        '00190047': ('FL', '1', 'Unknown', ''),
        '00190048': ('US', '1', 'Unknown', ''),
        '00190049': ('US', '1', 'Unknown', ''),
        '0019004B': ('US', '1', 'Unknown', ''),
        '0019004C': ('US', '1', 'Unknown', ''),
        '0019004D': ('SL', '1', 'Unknown', ''),
        '0019004E': ('US', '1', 'Unknown', ''),
        '0019004F': ('US', '1', 'Unknown', ''),
        '00190050': ('SL', '2', 'Unknown', ''),
        '00190051': ('SL', '2', 'Unknown', ''),
        '00190052': ('LO', '1', 'Unknown', ''),
        '00190054': ('US', '1', 'Unknown', ''),
        '00190055': ('US', '1', 'Unknown', ''),
        '00190056': ('FL', '3', 'Unknown', ''),
        '00190057': ('FL', '3', 'Unknown', ''),
        '00190058': ('FL', '3', 'Unknown', ''),
        '00190059': ('SL', '1', 'Unknown', ''),
        '0019005A': ('FL', '1-n', 'Unknown', ''),
        '0019005D': ('FL', '1-n', 'Unknown', ''),
        '0019005E': ('SL', '1', 'Unknown', ''),
        '0019005F': ('FL', '1', 'Unknown', ''),
        '00190060': ('US', '1', 'Unknown', ''),
        '00190061': ('US', '1', 'Unknown', ''),
        '00190062': ('US', '1', 'Unknown', ''),
        '00190063': ('FL', '1', 'Unknown', ''),
        '00190064': ('FL', '1', 'Unknown', ''),
        '00190065': ('SL', '2', 'Unknown', ''),
        '00190069': ('FL', '1', 'Unknown', ''),
        '0019006A': ('US', '1', 'Unknown', ''),
        '0019006B': ('SL', '1', 'Unknown', ''),
        '0019006D': ('SL', '1', 'Unknown', ''),
        '0019006E': ('FL', '1', 'Unknown', ''),
        '0019006F': ('SL', '1', 'Unknown', ''),
        '00190070': ('LO', '1', 'Unknown', ''),
        '00190071': ('LO', '1', '?Sequence Options?', ''),
        '00190073': ('LO', '1', '?Sequence Options?', ''),
        '00190075': ('LO', '1', 'Unknown', ''),
        '00190076': ('LO', '1', 'Unknown', ''),
        '00190078': ('LO', '1', 'Unknown', ''),
        '0019007B': ('LO', '1', 'Unknown', ''),
        '0019007C': ('FL', '1', 'Unknown', ''),
        '0019007D': ('FL', '1', 'Unknown', ''),
        '0019007E': ('SL', '1', 'Unknown', ''),
        '0019007F': ('SL', '1', 'Unknown', ''),
        '00190085': ('FL', '1', 'Unknown', ''),
        '00190086': ('SL', '1', 'Unknown', ''),
        '00190087': ('FL', '1', 'Unknown', ''),
        '00190088': ('LO', '1', '?RxGain?', ''),
        '0019008A': ('SL', '1-n', 'Unknown', ''),
        '0019008C': ('UL', '1', 'Unknown', ''),
        '0019008D': ('TM', '1', 'Unknown', ''),
        '0019008E': ('SL', '1', 'Unknown', ''),
        '00190092': ('SL', '1', 'Unknown', ''),
        '00190093': ('FL', '3', 'Unknown', ''),
        '00190096': ('US', '1', 'Unknown', ''),
        '0019009B': ('FL', '3', 'Unknown', ''),
        '0019009C': ('SL', '1', 'Unknown', ''),
        '001900A0': ('SL', '4', 'Unknown', ''),
        '001900A1': ('DS', '1', 'Unknown', ''),
        '001900A2': ('SL', '1', 'Unknown', ''),
        '001900A3': ('SL', '3', 'Unknown', ''),
        '001900A4': ('FL', '3', 'Unknown', ''),
        '001900A5': ('FL', '1', 'Unknown', ''),
        '001900A6': ('SL', '1', 'Unknown', ''),
        '001900A8': ('FL', '1', '?Repetition Time (/100)', ''),
        '001900A9': ('SL', '1', 'Unknown', ''),
        '001900AB': ('FL', '3', 'Unknown', ''),
        '001900AC': ('US', '1', 'Unknown', ''),
        '001900AD': ('FL', '1', 'Unknown', ''),
        '001900AE': ('FL', '1', 'Unknown', ''),
        '001900AF': ('SL', '1', 'Unknown', ''),
        '001900B0': ('SL', '1', 'Unknown', ''),
        '001900B1': ('SL', '1', 'Unknown', ''),
        '001900B4': ('SL', '1', 'Unknown', ''),
        '001900B5': ('SL', '1', 'Unknown', ''),
        '001900B6': ('SL', '1', 'Unknown', ''),
        '001900B7': ('FL', '2', 'Unknown', ''),
        '001900BA': ('FL', '1', 'Unknown', ''),
        '001900BB': ('FL', '1', 'Unknown', ''),
        '001900BC': ('FL', '2', 'Unknown', ''),
        '001900BD': ('SL', '1', 'Unknown', ''),
        '001900BE': ('SL', '1', 'Acquisition Duration', ''),
        '001900C1': ('SL', '1', 'Unknown', ''),
        '001900C3': ('SL', '1', 'Unknown', ''),
        '001900C6': ('FL', '2', 'Unknown', ''),
        '001900C9': ('SL', '1', 'Unknown', ''),
        '001900CA': ('LO', '1', 'Sequence Name', ''),
        '001900CB': ('UL', '1', 'Unknown', ''),
        '001900CC': ('UL', '1', 'Unknown', ''),
        '001900CD': ('SL', '1', 'Unknown', ''),
        '001900CE': ('SL', '1', 'Unknown', ''),
        '001900CF': ('SL', '1', '?acquired series (vs postproc)?', ''),
        '001900D0': ('US', '1', 'Unknown', ''),
        '001900D1': ('SL', '1', 'Unknown', ''),
        '001900D2': ('SL', '3', 'Unknown', ''),
        '001900D3': ('SL', '1', 'Unknown', ''),
        '001900D4': ('SL', '1', 'Unknown', ''),
        '001900D8': ('US', '1-n', 'Unknown', ''),
        '001900D9': ('SQ', '1', 'Unknown', ''),
        '001900DA': ('US', '1', 'Unknown', ''),
        '001900DB': ('SL', '1', 'Unknown', ''),
        '001900DC': ('SL', '1', 'Unknown', ''),
        '001900E1': ('SL', '1', 'Unknown', ''),
        '001900E4': ('SL', '1', 'Unknown', ''),
        '001900E5': ('SQ', '1', 'Unknown', ''),
        '001900E6': ('SQ', '1', 'Unknown', ''),
        '001900E9': ('SL', '1', 'Unknown', ''),
        '001900EA': ('UI', '1', 'Unknown', ''),
        '001900EB': ('SL', '1', 'Unknown', ''),
        '001900EC': ('US', '1', 'Unknown', ''),
        '001900EE': ('FL', '1', 'Unknown', ''),
        '001900EF': ('FL', '1', 'Unknown', ''),
        '001900F0': ('SL', '1', 'Unknown', ''),
        '001900F1': ('FL', '1', 'Unknown', ''),
        '001900F2': ('FL', '1', 'Unknown', ''),
        '001900F3': ('SL', '1', 'Unknown', ''),
        '001900F4': ('FD', '1', 'Unknown', ''),
        '001900F5': ('SL', '1', 'Unknown', ''),
        '001900F6': ('UI', '1', 'Unknown', ''),
        '001900F8': ('US', '1', 'Unknown', ''),
        '001900F9': ('SL', '1', 'Unknown', ''),
        '001900FA': ('FL', '1', 'Unknown', ''),
        '001900FB': ('UL', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('FL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
        '001900FF': ('SL', '3', 'Unknown', ''),
        '00210002': ('SL', '1', '?num?', ''),
        '00210003': ('SL', '1', '?num?', ''),
        '00210004': ('US', '1', '?num?', ''),
        '00210008': ('DS', '3', '?vect1?', ''),
        '00210009': ('DS', '3', '?vect2?', ''),
        '0021000A': ('DS', '3', '?vect3?', ''),
        '0021000B': ('US', '1', 'Unknown', ''),
        '0021000C': ('US', '1', 'Unknown', ''),
        '0021000D': ('FL', '1', 'Unknown', ''),
        '0021000F': ('US', '1', 'Unknown', ''),
        '00210012': ('DS', '3', '?vect4?', ''),
        '00210014': ('SQ', '1', 'Unknown', ''),
        '00210015': ('FL', '1', 'Unknown', ''),
        '00210016': ('FL', '2', 'Unknown', ''),
        '00210018': ('US', '1', 'Unknown', ''),
        '0021001A': ('US', '1', 'Unknown', ''),
        '0021001D': ('IS', '1', 'Unknown', ''),
        '0021001F': ('US', '1', 'Unknown', ''),
        '00290001': ('SL', '1', 'Unknown', ''),
        '00290005': ('SQ', '1', 'Unknown', ''),
        '00290006': ('FL', '1', 'Unknown', ''),
        '00290007': ('FL', '1', 'Unknown', ''),
        '0029001C': ('FL', '2', 'Unknown', ''),
        '00290021': ('SL', '3', 'Unknown', ''),
        '0029004E': ('SL', '1', 'Unknown', ''),
        '00290050': ('LO', '1', 'Unknown', ''),
        '00290051': ('LO', '1', 'Unknown', ''),
        '00290052': ('LO', '1', 'Unknown', ''),
        '00290054': ('LO', '1', 'Unknown', ''),
        '00290067': ('FD', '4', 'Unknown', ''),
        '00290068': ('SS', '1', 'Unknown', ''),
        '0029006E': ('OB', '1', 'Unknown', ''),
        'E2010002': ('US', '1', 'Unknown', ''),
        'E3010000': ('SH', '1', 'Unknown', ''),
        'E4010000': ('US', '1', 'Unknown', ''),
        'E4010001': ('US', '1', 'Unknown', ''),
        'E4010002': ('US', '1', 'Unknown', ''),
        'E4010003': ('US', '1', 'Unknown', ''),
        'E4010004': ('US', '1', 'Unknown', ''),
        'E4010005': ('OB', '1', 'Unknown', ''),
        'E4010007': ('FL', '1', 'Unknown', ''),
        'E4010008': ('FL', '1', 'Unknown', ''),
        'E4010012': ('FL', '1', 'Unknown', ''),
        'E4010013': ('OB', '1', 'Unknown', ''),
        'E4010020': ('SQ', '1', 'Unknown', ''),
        'E4010021': ('SQ', '1', 'Unknown', ''),
        'E4010022': ('LO', '1', 'Unknown', ''),
        'E4010023': ('SH', '1', 'Unknown', ''),
        'E4010024': ('OB', '1', 'Unknown', ''),
        'E4030000': ('SQ', '1', 'Unknown', ''),
        'EE010000': ('US', '1', 'Unknown', ''),
        'EE010001': ('OB', '1', 'Unknown', ''),
        'EE010002': ('US', '1', 'Unknown', ''),
    },
    'PMTF INFORMATION DATA^11': {
        '00190001': ('OB', '1', '?character set?', ''),
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('SL', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190007': ('OB', '1', 'Unknown', ''),
        '00190008': ('SH', '1', 'Unknown', ''),
        '00190009': ('SL', '2', 'Unknown', ''),
        '0019000A': ('SL', '1', 'Unknown', ''),
        '0019000B': ('OB', '1', 'Unknown', ''),
        '0019000C': ('SL', '1', 'Unknown', ''),
        '00190019': ('SQ', '1', 'Unknown', ''),
        '0019001A': ('FL', '1', 'Unknown', ''),
        '00190024': ('SL', '1', 'Unknown', ''),
        '00190025': ('SL', '1', 'Unknown', ''),
        '00190026': ('SL', '1', 'Unknown', ''),
        '00190028': ('SL', '1', 'Unknown', ''),
        '00190029': ('SL', '1', 'Unknown', ''),
        '0019002A': ('FL', '1', 'Unknown', ''),
        '0019002B': ('FL', '1', 'Unknown', ''),
        '0019002C': ('SL', '3', 'Unknown', ''),
        '0019002D': ('SL', '3', 'Unknown', ''),
        '0019002E': ('SL', '1', 'Unknown', ''),
        '00190030': ('SL', '1', 'Unknown', ''),
        '00190031': ('SL', '1', 'Unknown', ''),
        '00190032': ('SL', '1', 'Unknown', ''),
        '00190034': ('FL', '1', 'Unknown', ''),
        '00190035': ('SL', '1', 'Unknown', ''),
        '00190036': ('FL', '1', 'Unknown', ''),
        '00190037': ('SL', '1', 'Unknown', ''),
        '00190038': ('SL', '1', 'Unknown', ''),
        '00190039': ('FL', '1', 'Unknown', ''),
        '0019003A': ('FL', '1', 'Repetition Time (/100)', ''),
        '0019003C': ('FL', '3', 'Unknown', ''),
        '0019003D': ('SL', '1', 'Unknown', ''),
        '0019003E': ('FL', '9', 'Unknown', ''),
        '0019003F': ('UI', '1', 'Unknown', ''),
        '00190040': ('US', '1', 'Unknown', ''),
        '00190041': ('US', '1', 'Unknown', ''),
        '00190042': ('SL', '1', 'Unknown', ''),
        '00190043': ('SL', '1', 'Unknown', ''),
        '00190044': ('SL', '1', 'Unknown', ''),
        '00190046': ('FL', '1', 'Unknown', ''),
        '00190048': ('LT', '1', '?QD Whole Body?', ''),
        '00190049': ('LT', '1', '?Atlas Head?', ''),
        '0019004C': ('SL', '1', 'Unknown', ''),
        '0019004D': ('SL', '1', '?postproc series?', ''),
        '0019004E': ('SL', '1', 'Unknown', ''),
        '00190055': ('LO', '1', 'Unknown', ''),
        '00190057': ('FL', '1', 'Unknown', ''),
        '00190058': ('US', '1', 'Unknown', ''),
        '00190059': ('US', '1', 'Unknown', ''),
        '0019005C': ('SL', '1', 'Unknown', ''),
        '0019005D': ('SL', '1', 'Unknown', ''),
        '0019005F': ('FL', '1', 'Unknown', ''),
        '00190060': ('SL', '1', 'Unknown', ''),
        '00190061': ('FL', '1', 'Unknown', ''),
        '00190062': ('FL', '1', 'Unknown', ''),
        '00190063': ('SL', '1', 'Unknown', ''),
        '00190065': ('SL', '1', 'Unknown', ''),
        '00190067': ('FL', '1', 'Unknown', ''),
        '00190068': ('SL', '1', 'Unknown', ''),
        '0019006C': ('FL', '1', 'Unknown', ''),
        '0019006D': ('SH', '1', 'Unknown', ''),
        '0019006E': ('SH', '1', 'Sequence Name', ''),
        '0019006F': ('FL', '1', 'Unknown', ''),
        '00190070': ('FL', '1', 'Unknown', ''),
        '00190071': ('SL', '1', 'Unknown', ''),
        '00190072': ('FL', '1', 'Unknown', ''),
        '00190078': ('SL', '1', 'Unknown', ''),
        '0019007A': ('SL', '2', 'Unknown', ''),
        '0019007C': ('FL', '3', 'Unknown', ''),
        '0019007D': ('SL', '1', 'Unknown', ''),
        '0019007E': ('SL', '1', 'Unknown', ''),
        '0019007F': ('SL', '1', 'Unknown', ''),
        '00190080': ('FL', '1', 'Unknown', ''),
        '00190084': ('SL', '1', 'Unknown', ''),
        '00190087': ('SL', '1', 'Unknown', ''),
        '0019008A': ('US', '1', 'Unknown', ''),
        '0019008B': ('SL', '1', 'Unknown', ''),
        '0019008C': ('SL', '1', 'Unknown', ''),
        '0019008F': ('SL', '1', 'Unknown', ''),
        '00190090': ('SL', '1', 'Unknown', ''),
        '00190091': ('SL', '1', 'Unknown', ''),
        '00190092': ('SL', '1', 'Unknown', ''),
        '00190093': ('SL', '1', 'Unknown', ''),
        '00190094': ('FL', '1', 'Unknown', ''),
        '0019009A': ('SL', '1', 'Unknown', ''),
        '0019009B': ('US', '1', 'Unknown', ''),
        '0019009C': ('FL', '1', 'Unknown', ''),
        '0019009D': ('SL', '1', 'Unknown', ''),
        '0019009E': ('SL', '1', 'Unknown', ''),
        '0019009F': ('SL', '1', 'Unknown', ''),
        '001900A0': ('SL', '1', 'Unknown', ''),
        '001900A1': ('SL', '1', 'Unknown', ''),
        '001900A5': ('US', '1', 'Unknown', ''),
        '001900A6': ('US', '1', 'Unknown', ''),
        '001900A8': ('SL', '1', 'Unknown', ''),
        '001900AB': ('US', '1', 'Unknown', ''),
        '001900AD': ('SL', '1', 'Unknown', ''),
        '001900AE': ('SL', '1', 'Unknown', ''),
        '001900B0': ('FL', '1', 'Unknown', ''),
        '001900B1': ('SL', '1', 'Unknown', ''),
        '001900B2': ('US', '1', 'Unknown', ''),
        '001900B3': ('US', '1', 'Unknown', ''),
        '001900B4': ('US', '1', 'Unknown', ''),
        '001900B5': ('FL', '1', 'Unknown', ''),
        '001900B6': ('SL', '1', 'Unknown', ''),
        '001900B7': ('US', '1', 'Unknown', ''),
        '001900B9': ('US', '1', 'Unknown', ''),
        '001900BB': ('FL', '1', 'Unknown', ''),
        '001900BC': ('SL', '1', 'Unknown', ''),
        '001900BD': ('SL', '1', 'Unknown', ''),
        '001900BE': ('FL', '1-n', 'Unknown', ''),
        '001900BF': ('SL', '1', 'Unknown', ''),
        '001900C0': ('SL', '1', 'Unknown', ''),
        '001900C1': ('US', '1', 'Unknown', ''),
        '001900C3': ('FL', '1', 'Unknown', ''),
        '001900C4': ('SL', '1', 'Unknown', ''),
        '001900CD': ('SL', '3', 'Unknown', ''),
        '001900E0': ('FL', '1', 'Unknown', ''),
        '001900E1': ('FL', '1', 'Unknown', ''),
        '001900E3': ('SL', '3', 'Unknown', ''),
        '001900E4': ('DS', '1', 'Unknown', ''),
        '001900E5': ('SQ', '1', 'Unknown', ''),
        '001900E6': ('SQ', '1', 'Unknown', ''),
        '001900F0': ('SL', '1-n', 'Unknown', ''),
        '001900F1': ('SL', '3', 'Diffusion b-value x Toshiba Orientation', ''),
        '001900F2': ('FL', '3', 'Specific Absorption Rate Values', ''),
        '001900F3': ('SL', '1', 'Unknown', ''),
        '001900F4': ('SL', '1', 'Unknown', ''),
        '001900F5': ('SQ', '1', 'Unknown', ''),
        '001900F6': ('SL', '1', 'Unknown', ''),
        '001900F7': ('SL', '1', 'Unknown', ''),
        '001900F8': ('SL', '1', 'Unknown', ''),
        '001900F9': ('SL', '1', 'Unknown', ''),
        '001900FA': ('SL', '1', 'Unknown', ''),
        '001900FB': ('FL', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('SL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
        '001900FF': ('SL', '1', 'Unknown', ''),
    },
    'PMTF INFORMATION DATA^12': {
        '00190000': ('SL', '1', 'Unknown', ''),
        '00190001': ('SL', '1', 'Unknown', ''),
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('SL', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190005': ('SH', '1', '?Sequence Variant?', ''),
        '00190006': ('FL', '1', 'Unknown', ''),
        '00190007': ('UL', '1-2', 'Unknown', ''),
        '00190008': ('UL', '1-2', 'Unknown', ''),
        '00190009': ('SL', '1', 'Unknown', ''),
        '0019000A': ('SL', '1', 'Unknown', ''),
        '0019000B': ('SL', '1', 'Unknown', ''),
        '0019000C': ('UL', '1', 'Unknown', ''),
        '0019000D': ('SQ', '1', 'Unknown', ''),
        '0019000E': ('US', '1', 'Unknown', ''),
        '00190010': ('SL', '1', 'Unknown', ''),
        '00190011': ('SL', '1', 'Unknown', ''),
        '00190012': ('SL', '1', 'Unknown', ''),
        '00190013': ('FL', '1', 'Unknown', ''),
        '00190014': ('FL', '1', 'Unknown', ''),
        '00190018': ('UL', '1', 'Unknown', ''),
        '00190028': ('DS', '1', 'Unknown', ''),
        '0019002A': ('DS', '3', 'Unknown', ''),
        '0019002B': ('SQ', '1', 'Unknown', ''),
        '00190032': ('SH', '1', 'Sequence Name', ''),
        '00190034': ('SL', '1', 'Unknown', ''),
        '00190052': ('FL', '2', 'Unknown', ''),
        '00190076': ('OB', '1', 'Unknown', ''),
        '00190079': ('SQ', '1', 'Unknown', ''),
        '00190080': ('FD', '1', 'Acquisition Duration', ''),
        '00190085': ('US', '1', 'Unknown', ''),
        '00190086': ('LO', '1', 'Unknown', ''),
        '00190087': ('SQ', '1', 'Unknown', ''),
        '00190088': ('US', '1', 'Series Number Global', ''),
        '00190089': ('SL', '1', 'Unknown', ''),
        '0019008A': ('US', '1', 'Series Number Global', ''),
        '0019008B': ('US', '1', 'Unknown', ''),
        '0019008F': ('OB', '1', 'Unknown', ''),
        '00190093': ('SL', '1', '?num?', ''),
        '00190094': ('UI', '1', 'Referenced SOP Instance UID', ''),
        '00190095': ('UI', '1', 'Unknown', ''),
        '00190096': ('LO', '1', '?PASTA?', ''),
        '00190098': ('FL', '3', 'Unknown', ''),
        '00190099': ('LO', '1', 'Sequence Name', ''),
        '0019009A': ('DS', '1', 'Series Number Local', ''),
        '0019009B': ('DS', '1', 'Unknown', ''),
        '0019009C': ('DS', '1', '?num?', ''),
        '0019009D': ('US', '1', 'Unknown', ''),
        '0019009E': ('FL', '3', 'Unknown', ''),
        '0019009F': ('FL', '1', 'Unknown', ''),
        '001900A0': ('FL', '1', 'Unknown', ''),
        '001900A1': ('FL', '1', 'Unknown', ''),
        '001900A2': ('FL', '1', 'Unknown', ''),
        '001900A3': ('FL', '1', 'Unknown', ''),
        '001900A4': ('FL', '1', 'Unknown', ''),
        '001900A5': ('FL', '1', 'Unknown', ''),
        '001900A6': ('FL', '2-2n', 'Unknown', ''),
        '001900A7': ('FL', '1', 'Unknown', ''),
        '001900A8': ('FL', '1', 'Unknown', ''),
        '001900A9': ('FL', '3', 'Unknown', ''),
        '001900AA': ('FL', '3', 'Unknown', ''),
        '001900AB': ('FL', '3', 'Unknown', ''),
        '001900AC': ('FL', '3', 'Unknown', ''),
        '001900AD': ('FL', '3', 'Unknown', ''),
        '001900AE': ('FL', '3', 'Unknown', ''),
        '001900AF': ('FL', '3', 'Unknown', ''),
        '001900B3': ('FD', '1', 'Acquisition Duration', ''),
        '001900B4': ('LO', '1', 'Unknown', ''),
        '001900C2': ('US', '1', 'Unknown', ''),
        '001900C3': ('FL', '1', 'Unknown', ''),
        '001900C4': ('SL', '1', 'Unknown', ''),
        '001900C5': ('SL', '1', 'Unknown', ''),
        '001900C6': ('SL', '1', 'Unknown', ''),
        '001900C7': ('FL', '1', 'Unknown', ''),
        '001900CC': ('SS', '1-n', 'Unknown', ''),
        '001900CD': ('LO', '1', 'Unknown', ''),
        '001900CE': ('UL', '1', 'Unknown', ''),
        '001900CF': ('FL', '1', 'Unknown', ''),
        '001900D1': ('FL', '3', 'Unknown', ''),
        '001900D2': ('US', '3', 'Unknown', ''),
        '001900D3': ('SS', '1', 'Unknown', ''),
        '001900D4': ('US', '2', 'Unknown', ''),
        '001900D5': ('FL', '1', 'Unknown', ''),
        '001900D6': ('FL', '3', 'Unknown', ''),
        '001900D7': ('US', '2', '?vect2?', ''),
        '001900D8': ('FL', '1-n', 'Unknown', ''),
        '001900DE': ('US', '1', '?num?', ''),
        '001900DF': ('US', '1', 'Unknown', ''),
        '001900E0': ('US', '1', 'Unknown', ''),
        '001900E1': ('FL', '3', '?vect3?', ''),
        '001900E2': ('FL', '3', '?vect3?', ''),
        '001900E3': ('TM', '1', '?time?', ''),
        '001900E4': ('US', '2', '?vect2?', ''),
        '001900EB': ('US', '1', '?num?', ''),
        '001900EC': ('US', '1', '?num?', ''),
        '001900EF': ('DS', '1', 'Unknown', ''),
        '001900F0': ('LO', '1', 'Unknown', ''),
        '001900F1': ('LO', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('SL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
    },
    'PMTF INFORMATION DATA^13': {
        'E4030000': ('SH', '1', 'Unknown', ''),
        'E4030001': ('OB', '1', 'Unknown', ''),
        'E4030002': ('OB', '1', 'Unknown', ''),
        'E4030003': ('OB', '1', 'Unknown', ''),
    },
    'POLYTRON-SMS 2.5': {
        '0009xx02': ('UN', '1', 'Private Data 1', ''),
        '0009xx03': ('UN', '1', 'Private Data 2', ''),
        '0009xx04': ('UN', '1', 'Private Data 3', ''),
        '0009xx06': ('UN', '1', 'Private Data 3', ''),
        '0009xx10': ('UN', '1', 'Private Data 4', ''),
        '0009xx11': ('UN', '1', 'Private Data 5', ''),
        '0009xx12': ('UN', '1', 'Private Data 6', ''),
        '0089xx10': ('UN', '1', 'Private Data', ''),
    },
    'PRIVATE ORIGINAL ATTRIBUTES': {
        '0021xx01': ('SQ', '1', 'Private Original Attribute Sequence', ''),
        '0021xx05': ('DT', '1', 'Replacement Date and Time', ''),
        '0021xx10': ('LO', '1', 'Replacement Originator Name', ''),
        '0021xx12': ('LO', '1', 'Replacement Reason', ''),
        '0021xx70': ('PN', '1-n', "Original Operators' Name", ''),
    },
    'Philips EV Imaging DD 017': {
        '2007xxC1': ('UI', '1', '? SOP Instance UID ?', ''),
        '2007xxC2': ('DA', '1', 'Unknown', ''),
        '2007xxC3': ('TM', '1', 'Unknown', ''),
        '2007xxC4': ('UL', '1', 'Unknown', ''),
    },
    'Philips EV Imaging DD 019': {
        '2007xx00': ('LO', '1', 'Unknown', ''),
        '2007xx01': ('UT', '1', 'Unknown', ''),
    },
    'Philips EV Imaging DD 021': {
        '2007xx04': ('SL', '1', 'Vol Seg Edit Connectivity', ''),
    },
    'Philips EV Imaging DD 022': {
        '2007xx00': ('ST', '1', '', ''),
        '2007xx12': ('UN', '1', 'Volume Sequence Capture', ''),
        '2007xx17': ('UN', '1', 'Original SOP Instance', ''),
        '2007xx33': ('LO', '1', '', ''),
        '2007xx34': ('CS', '1', '', ''),
    },
    'Philips EnVisor': {
        '7777xx01': ('DA', '1', "Date 3D/PanView internal 'dataset' file was acquired", ''),
        '7777xx02': ('CS', '1', 'Type of 3D or PanView', ''),
        '7777xx03': ('LO', '1', 'Internal 3D/PanView software version number', ''),
        '7777xx14': ('LT', '1', 'Private string', ''),
    },
    'Philips Imaging DD 001': {
        '2001xx01': ('FL', '1', 'Chemical Shift', ''),
        '2001xx02': ('IS', '1', 'Chemical Shift Number MR', ''),
        '2001xx03': ('FL', '1', 'Diffusion B-Factor', ''),
        '2001xx04': ('CS', '1', 'Diffusion Direction', ''),
        '2001xx05': ('SS', '1', 'Unknown', ''),
        '2001xx06': ('CS', '1', 'Image Enhanced', ''),
        '2001xx07': ('CS', '1', 'Image Type ED ES', ''),
        '2001xx08': ('IS', '1', 'Phase Number', ''),
        '2001xx09': ('FL', '1', 'Unknown', ''),
        '2001xx0A': ('IS', '1', 'Slice Number MR', ''),
        '2001xx0B': ('CS', '1', 'Slice Orientation', ''),
        '2001xx0C': ('CS', '1', 'Unknown', ''),
        '2001xx0E': ('CS', '1', 'Unknown', ''),
        '2001xx0F': ('SS', '1', 'Unknown', ''),
        '2001xx10': ('CS', '1', 'Cardiac Sync', ''),
        '2001xx11': ('FL', '1', 'Diffusion Echo Time', ''),
        '2001xx12': ('CS', '1', 'Dynamic Series', ''),
        '2001xx13': ('SL', '1', 'EPI Factor', ''),
        '2001xx14': ('SL', '1', 'Number of Echoes', ''),
        '2001xx15': ('SS', '1', 'Number of Locations', ''),
        '2001xx16': ('SS', '1', 'Number of PC Directions', ''),
        '2001xx17': ('SL', '1', 'Number of Phases MR', ''),
        '2001xx18': ('SL', '1', 'Number of Slices MR', ''),
        '2001xx19': ('CS', '1', 'Partial Matrix Scanned', ''),
        '2001xx1A': ('FL', '1-n', 'PC Velocity', ''),
        '2001xx1B': ('FL', '1', 'Prepulse Delay', ''),
        '2001xx1C': ('CS', '1', 'Prepulse Type', ''),
        '2001xx1D': ('IS', '1', 'Reconstruction Number MR', ''),
        '2001xx1E': ('CS', '1', 'Unknown', ''),
        '2001xx1F': ('CS', '1', 'Respiration Sync', ''),
        '2001xx20': ('LO', '1', 'Scanning Technique Description MR', ''),
        '2001xx21': ('CS', '1', 'SPIR', ''),
        '2001xx22': ('FL', '1', 'Water Fat Shift', ''),
        '2001xx23': ('DS', '1', 'Flip Angle Philips', ''),
        '2001xx24': ('CS', '1', 'Interactive', ''),
        '2001xx25': ('SH', '1', 'Echo Time Display MR', ''),
        '2001xx26': ('CS', '1', 'Presentation State Subtraction Active', ''),
        '2001xx28': ('FL', '1', 'Edge Enhancement Gain Factor Sub', ''),
        '2001xx29': ('FL', '1', 'Edge Enhancement Gain Factor Non Sub', ''),
        '2001xx2A': ('CS', '1', 'Edge Enhancement Taste Adapt Sub', ''),
        '2001xx2B': ('CS', '1', 'Edge Enhancement Taste Non Sub', ''),
        '2001xx2C': ('FL', '1', 'Harmonization Factor', ''),
        '2001xx2D': ('SS', '1', 'Number of Stack Slices', ''),
        '2001xx2F': ('FL', '1', 'Harmonization Gain', ''),
        '2001xx30': ('UL', '1', 'Log Subtraction Gain Step', ''),
        '2001xx31': ('US', '1', 'Mixing NR of Mask Image Numbers', ''),
        '2001xx32': ('FL', '1-n', 'Stack Radial Angle', ''),
        '2001xx33': ('CS', '1-n', 'Stack Radial Axis', ''),
        '2001xx34': ('CS', '1', 'Mixing Mask Operation', ''),
        '2001xx35': ('SS', '1-n', 'Stack Slice Number', ''),
        '2001xx36': ('CS', '1-n', 'Stack Type', ''),
        '2001xx37': ('CS', '1', 'Mixing Operation Type', ''),
        '2001xx39': ('FL', '1', 'Unknown', ''),
        '2001xx3A': ('CS', '1', 'Pixel Shift', ''),
        '2001xx3D': ('UL', '1', 'Unknown', ''),
        '2001xx3F': ('CS', '1', 'Interpolation Method', ''),
        '2001xx42': ('CS', '1', 'Subtraction Land Marking Active', ''),
        '2001xx46': ('CS', '1', 'Graphic Line Style', ''),
        '2001xx47': ('FL', '1', 'Graphic Line Width', ''),
        '2001xx48': ('SS', '1', 'Graphic Annotation ID', ''),
        '2001xx4B': ('CS', '1', 'Poly Line Interpolation Method', ''),
        '2001xx4C': ('CS', '1', 'Poly Line Begin Point Style', ''),
        '2001xx4D': ('CS', '1', 'Poly Line End Point Style', ''),
        '2001xx4E': ('CS', '1', 'Window Smoothing Taste', ''),
        '2001xx4F': ('FD', '1', 'Harmonization Offset', ''),
        '2001xx50': ('LO', '1', 'Unknown', ''),
        '2001xx52': ('UI', '1', 'Unknown', ''),
        '2001xx53': ('CS', '1', 'Window Invert', ''),
        '2001xx55': ('CS', '1', 'Graphic Line Color', ''),
        '2001xx56': ('CS', '1', 'Graphic Type (Private)', ''),
        '2001xx5A': ('ST', '1', 'Graphic Annotation Model', ''),
        '2001xx5D': ('ST', '1', 'Measurement Text Units', ''),
        '2001xx5E': ('ST', '1', 'Measurement Text Type', ''),
        '2001xx5F': ('SQ', '1', 'Stack Sequence', ''),
        '2001xx60': ('SL', '1', 'Number of Stacks', ''),
        '2001xx61': ('CS', '1', 'Unknown', ''),
        '2001xx62': ('CS', '1', 'Unknown', ''),
        '2001xx63': ('CS', '1', 'Examination Source', ''),
        '2001xx64': ('SH', '1', 'Text Type', ''),
        '2001xx65': ('SQ', '1', 'Unknown', ''),
        '2001xx67': ('CS', '1', 'Unknown', ''),
        '2001xx68': ('SQ', '1', 'Unknown', ''),
        '2001xx69': ('SQ', '1', 'Display Shutter Sequence', ''),
        '2001xx6A': ('SQ', '1', 'Unknown', ''),
        '2001xx6B': ('SQ', '1', 'Has Edge Enhancement Sequence', ''),
        '2001xx6D': ('LO', '1', 'Text Font', ''),
        '2001xx6E': ('SH', '1', 'Series Type', ''),
        '2001xx6F': ('SQ', '1', 'Mixing Sequence', ''),
        '2001xx71': ('CS', '1', 'Unknown', ''),
        '2001xx73': ('SQ', '1', 'Referenced Mask Image Sequence', ''),
        '2001xx74': ('DS', '1-n', 'Window Center Sub', ''),
        '2001xx75': ('DS', '1-n', 'Window Width Sub', ''),
        '2001xx76': ('UL', '1', 'Unknown', ''),
        '2001xx77': ('CS', '1', 'GL TrafoType', ''),
        '2001xx79': ('SQ', '1', 'Harmonisation Sequence', ''),
        '2001xx7A': ('FL', '1', 'Unknown', ''),
        '2001xx7B': ('IS', '1', 'Acquisition Number', ''),
        '2001xx7E': ('US', '1', 'Edge Enhancement Gain Taste', ''),
        '2001xx7F': ('US', '1', 'Edge Enhancement Gain Taste Sub', ''),
        '2001xx80': ('LO', '1', 'Text Anchor Point Alignment', ''),
        '2001xx81': ('IS', '1', 'Number of Dynamic Scans', ''),
        '2001xx82': ('IS', '1', 'Echo Train Length', ''),
        '2001xx83': ('DS', '1', 'Imaging Frequency', ''),
        '2001xx84': ('DS', '1', 'Inversion Time', ''),
        '2001xx85': ('DS', '1', 'Magnetic Field Strength', ''),
        '2001xx86': ('IS', '1', 'Unknown', ''),
        '2001xx87': ('SH', '1', 'Imaged Nucleus', ''),
        '2001xx88': ('DS', '1', 'Number of Averages', ''),
        '2001xx89': ('DS', '1', 'Phase FOV Percent', ''),
        '2001xx8A': ('DS', '1', 'Sampling Percent', ''),
        '2001xx8B': ('SH', '1', 'Unknown', ''),
        '2001xx93': ('LO', '1', 'Text Style', ''),
        '2001xx94': ('LO', '1', 'Processing Order Specialization', ''),
        '2001xx97': ('SH', '1', 'Nucleus', ''),
        '2001xx9A': ('SQ', '1', 'Graphic Number Sequence', ''),
        '2001xx9B': ('UL', '1', 'Graphic Number', ''),
        '2001xx9C': ('LO', '1', 'Unknown', ''),
        '2001xx9D': ('LO', '1', 'PIIM Subtraction Type', ''),
        '2001xx9F': ('US', '2', 'Pixel Processing Kernel Size', ''),
        '2001xxA1': ('CS', '1', 'Is Raw Image', ''),
        '2001xxA2': ('US', '1', 'LOG Subtraction Curve Taste', ''),
        '2001xxA3': ('UL', '1', 'Text Color Foreground', ''),
        '2001xxA4': ('UL', '1', 'Text Color Background', ''),
        '2001xxA5': ('UL', '1', 'Text Color Shadow', ''),
        '2001xxC1': ('LO', '1', 'Nested Object Type Name', ''),
        '2001xxCC': ('ST', '1', 'Unknown', ''),
        '2001xxDA': ('CS', '1', 'Unknown', ''),
        '2001xxF1': ('FL', '1-n', 'Prospective Motion Correction', ''),
        '2001xxF2': ('FL', '1', 'Retrospective Motion Correction', ''),
        '2005xx14': ('CS', '1', 'Diffusion', ''),
        '2005xx20': ('SL', '1', 'Number of Chemical Shifts', ''),
        '2005xx30': ('FL', '1', 'Repetition Time', ''),
        '2005xx33': ('FL', '1', 'Scan Duration', ''),
        '2005xx35': ('CS', '1', 'Data Type', ''),
        '2005xx8B': ('SH', '1', 'Transmitting Coil', ''),
        '2005xx9F': ('CS', '1', 'Spectral Selective Excitation Pulse', ''),
        '2005xxA1': ('CS', '1', 'Syncra Scan Type', ''),
    },
    'Philips Imaging DD 002': {
        '2001xx01': ('US', '1', 'Unknown', ''),
        '2001xx02': ('FD', '1', 'Unknown', ''),
        '2001xx13': ('SS', '1', 'Unknown', ''),
        '2001xx14': ('FD', '1', 'Unknown', ''),
        '2001xx15': ('FD', '1', 'Unknown', ''),
        '2001xx16': ('FD', '1', 'Unknown', ''),
        '2001xx17': ('FD', '1', 'Unknown', ''),
        '2001xx18': ('CS', '1', 'Unknown', ''),
        '2001xx19': ('FD', '1', 'Unknown', ''),
        '2001xx1A': ('FD', '1', 'Unknown', ''),
        '2001xx1B': ('FD', '1', 'Unknown', ''),
        '2001xx1C': ('FD', '1', 'Unknown', ''),
        '2001xx1D': ('FD', '1', 'Unknown', ''),
        '2001xx1E': ('FD', '1', 'Unknown', ''),
        '2001xx1F': ('FD', '1', 'Unknown', ''),
        '2001xx20': ('FD', '1', 'Unknown', ''),
        '2001xx21': ('FD', '1', 'Unknown', ''),
        '2001xx22': ('FD', '1', 'Unknown', ''),
        '2001xx23': ('FD', '1', 'Unknown', ''),
        '2001xx24': ('FD', '1', 'Unknown', ''),
        '2001xx25': ('FD', '1', 'Unknown', ''),
        '2001xx26': ('FD', '1', 'Unknown', ''),
        '2001xx27': ('FD', '1', 'Unknown', ''),
        '2001xx28': ('US', '1', 'Unknown', ''),
        '2001xx29': ('US', '1', 'Unknown', ''),
        '2001xx2A': ('US', '1', 'Unknown', ''),
        '2001xx2B': ('SS', '1', 'Unknown', ''),
        '2001xx2C': ('FD', '1', 'Unknown', ''),
        '2001xx2D': ('FD', '1', 'Unknown', ''),
        '2001xx2E': ('SS', '1', 'Unknown', ''),
        '2001xx2F': ('SS', '1', 'Unknown', ''),
        '2001xx30': ('SS', '1', 'Unknown', ''),
        '2001xx31': ('SS', '1', 'Unknown', ''),
        '2001xx32': ('SS', '1', 'Unknown', ''),
        '2001xx33': ('SS', '1', 'Unknown', ''),
        '2001xx34': ('SS', '1', 'Unknown', ''),
        '2001xx35': ('FD', '1', 'Unknown', ''),
        '2001xx36': ('FD', '1', 'Unknown', ''),
        '2001xx37': ('FD', '1', 'Unknown', ''),
        '2001xx39': ('CS', '1', 'Unknown', ''),
        '2001xx3A': ('SQ', '1', 'Unknown', ''),
        '2001xx3B': ('SQ', '1', 'Unknown', ''),
        '2001xx3C': ('SQ', '1', 'Unknown', ''),
        '2001xx3D': ('SQ', '1', 'Unknown', ''),
        '2001xx3E': ('SS', '1', 'Unknown', ''),
        '2001xx3F': ('SS', '1', 'Unknown', ''),
        '2001xx40': ('SS', '1', 'Unknown', ''),
    },
    'Philips Imaging DD 065': {
        '4007xx00': ('CS', '1', 'Unknown', ''),
    },
    'Philips Imaging DD 067': {
        '4001xx00': ('SQ', '1', 'Unknown', ''),
        '4001xx01': ('CS', '1', 'Unknown', ''),
        '4001xx08': ('CS', '1', 'Unknown', ''),
    },
    'Philips Imaging DD 070': {
        '4001xx10': ('SQ', '1', 'Unknown', ''),
        '4001xx11': ('SQ', '1', 'Unknown', ''),
        '4001xx12': ('SQ', '1', 'Unknown', ''),
        '4001xx16': ('ST', '1', 'Unknown', ''),
        '4001xx17': ('ST', '1', 'Unknown', ''),
        '4001xx18': ('ST', '1', 'Unknown', ''),
        '4001xx1C': ('SQ', '1', 'Unknown', ''),
        '4001xx1D': ('LT', '1', 'Unknown', ''),
    },
    'Philips Imaging DD 073': {
        '4007xx48': ('FL', '1', 'Unknown', ''),
    },
    'Philips Imaging DD 129': {
        '2001xx00': ('SQ', '1', 'Unknown', ''),
        '2001xx01': ('SQ', '1', 'Unknown', ''),
    },
    'Philips MR Imaging DD 001': {
        '2005xx00': ('FL', '1', 'Unknown', ''),
        '2005xx01': ('FL', '1', 'Unknown', ''),
        '2005xx02': ('FL', '1', 'Unknown', ''),
        '2005xx04': ('CS', '1', 'Unknown', ''),
        '2005xx05': ('CS', '1', 'Synergy Reconstruction Type', ''),
        '2005xx08': ('FL', '1', 'Unknown', ''),
        '2005xx09': ('FL', '1', 'Unknown', ''),
        '2005xx0A': ('FL', '1', 'Unknown', ''),
        '2005xx0B': ('FL', '1', 'Unknown', ''),
        '2005xx0C': ('FL', '1', 'Unknown', ''),
        '2005xx0D': ('FL', '1', 'Unknown', ''),
        '2005xx0E': ('FL', '1', 'Unknown', ''),
        '2005xx0F': ('DS', '1', 'Window Center', ''),
        '2005xx10': ('DS', '1', 'Window Width', ''),
        '2005xx11': ('CS', '1', 'Unknown', ''),
        '2005xx12': ('CS', '1', 'Unknown', ''),
        '2005xx13': ('CS', '1', 'Unknown', ''),
        '2005xx14': ('CS', '1', 'Unknown', ''),
        '2005xx15': ('CS', '1', 'Unknown', ''),
        '2005xx16': ('CS', '1', 'Unknown', ''),
        '2005xx17': ('CS', '1', 'Unknown', ''),
        '2005xx18': ('LO', '1', 'Unknown', ''),
        '2005xx19': ('CS', '1', 'Unknown', ''),
        '2005xx1A': ('SS', '1', 'Unknown', ''),
        '2005xx1B': ('CS', '1', 'Unknown', ''),
        '2005xx1C': ('CS', '1', 'Unknown', ''),
        '2005xx1D': ('SS', '1', 'Unknown', ''),
        '2005xx1E': ('SH', '1', 'Unknown', ''),
        '2005xx1F': ('SH', '1', 'Unknown', ''),
        '2005xx20': ('SL', '1', 'Number of Chemical Shift', ''),
        '2005xx21': ('SS', '1', 'Unknown', ''),
        '2005xx22': ('IS', '1', 'Unknown', ''),
        '2005xx23': ('SS', '1', 'Unknown', ''),
        '2005xx25': ('SS', '1', 'Unknown', ''),
        '2005xx26': ('CS', '1', 'Unknown', ''),
        '2005xx27': ('CS', '1', 'Unknown', ''),
        '2005xx28': ('CS', '1', 'Unknown', ''),
        '2005xx29': ('CS', '1', 'Unknown', ''),
        '2005xx2A': ('IS', '1', 'Unknown', ''),
        '2005xx2B': ('SS', '1', 'Unknown', ''),
        '2005xx2C': ('CS', '1', 'Unknown', ''),
        '2005xx2D': ('IS', '1', 'Unknown', ''),
        '2005xx2E': ('CS', '1', 'Unknown', ''),
        '2005xx2F': ('CS', '1', 'Unknown', ''),
        '2005xx30': ('FL', '1', 'Repetition Time', ''),
        '2005xx31': ('CS', '1', 'Unknown', ''),
        '2005xx32': ('CS', '1', 'Unknown', ''),
        '2005xx33': ('FL', '1', 'Acquisition Duration', ''),
        '2005xx34': ('CS', '1', 'Unknown', ''),
        '2005xx35': ('CS', '1', 'Unknown', ''),
        '2005xx36': ('CS', '1', 'Unknown', ''),
        '2005xx37': ('CS', '1', 'Unknown', ''),
        '2005xx38': ('CS', '1', 'Unknown', ''),
        '2005xx39': ('CS', '1', 'Unknown', ''),
        '2005xx3A': ('SH', '1', 'Unknown', ''),
        '2005xx3B': ('CS', '1', 'Unknown', ''),
        '2005xx3C': ('CS', '1', 'Unknown', ''),
        '2005xx3D': ('SS', '1', 'Unknown', ''),
        '2005xx3E': ('SL', '1-n', 'Unknown', ''),
        '2005xx48': ('IS', '1', 'Unknown', ''),
        '2005xx49': ('IS', '1', 'Unknown', ''),
        '2005xx4A': ('IS', '1', 'Unknown', ''),
        '2005xx4B': ('IS', '1', 'Unknown', ''),
        '2005xx4C': ('CS', '1', 'Unknown', ''),
        '2005xx4D': ('CS', '1', 'Unknown', ''),
        '2005xx4E': ('FL', '1', 'Unknown', ''),
        '2005xx4F': ('FL', '1', 'Unknown', ''),
        '2005xx50': ('FL', '1', 'Unknown', ''),
        '2005xx51': ('FL', '1', 'Unknown', ''),
        '2005xx52': ('CS', '1', 'Unknown', ''),
        '2005xx53': ('CS', '1', 'Unknown', ''),
        '2005xx54': ('FL', '1', 'Unknown', ''),
        '2005xx55': ('FL', '1', 'Unknown', ''),
        '2005xx56': ('FL', '1', 'Unknown', ''),
        '2005xx57': ('FL', '1', 'Unknown', ''),
        '2005xx58': ('FL', '1', 'Unknown', ''),
        '2005xx59': ('FL', '1', 'Unknown', ''),
        '2005xx5A': ('FL', '1', 'Unknown', ''),
        '2005xx5B': ('FL', '1', 'Unknown', ''),
        '2005xx5C': ('FL', '1', 'Unknown', ''),
        '2005xx5D': ('CS', '1', 'Unknown', ''),
        '2005xx5E': ('CS', '1', 'Unknown', ''),
        '2005xx5F': ('CS', '1', 'Unknown', ''),
        '2005xx60': ('IS', '1', 'Unknown', ''),
        '2005xx61': ('CS', '1', 'Unknown', ''),
        '2005xx63': ('SS', '1', 'Unknown', ''),
        '2005xx64': ('IS', '1', 'Unknown', ''),
        '2005xx65': ('IS', '1', 'Unknown', ''),
        '2005xx66': ('CS', '1', 'Unknown', ''),
        '2005xx67': ('IS', '1', 'Unknown', ''),
        '2005xx68': ('CS', '1', 'Unknown', ''),
        '2005xx69': ('FL', '1', 'Unknown', ''),
        '2005xx6A': ('FL', '1', 'Unknown', ''),
        '2005xx6B': ('FL', '1', 'Unknown', ''),
        '2005xx6C': ('FL', '1', 'Unknown', ''),
        '2005xx6D': ('FL', '1', 'Unknown', ''),
        '2005xx6E': ('CS', '1', 'Unknown', ''),
        '2005xx6F': ('CS', '1', 'Unknown', ''),
        '2005xx70': ('LO', '1', 'Unknown', ''),
        '2005xx71': ('FL', '1', 'Unknown', ''),
        '2005xx72': ('FL', '1', 'Unknown', ''),
        '2005xx73': ('FL', '1', 'Unknown', ''),
        '2005xx74': ('FL', '1', 'Unknown', ''),
        '2005xx75': ('FL', '1', 'Unknown', ''),
        '2005xx76': ('FL', '1', 'Unknown', ''),
        '2005xx78': ('FL', '1', 'Unknown', ''),
        '2005xx79': ('FL', '1', 'Unknown', ''),
        '2005xx7A': ('FL', '1', 'Unknown', ''),
        '2005xx7B': ('CS', '1', 'Unknown', ''),
        '2005xx7E': ('FL', '1', 'Unknown', ''),
        '2005xx80': ('SQ', '1', 'Unknown', ''),
        '2005xx81': ('CS', '1', 'Unknown', ''),
        '2005xx83': ('SQ', '1', 'Unknown', ''),
        '2005xx84': ('SQ', '1', 'Unknown', ''),
        '2005xx85': ('SQ', '1', 'Unknown', ''),
        '2005xx86': ('SS', '1', 'Unknown', ''),
        '2005xx9E': ('SQ', '1', 'Unknown', ''),
        '2005xx9F': ('CS', '1', 'Unknown', ''),
        '2005xxA0': ('FL', '1', 'Unknown', ''),
        '2005xxA1': ('CS', '1', 'Syncra Scan Type', ''),
        '2005xxA2': ('CS', '1', 'Unknown', ''),
        '2005xxA3': ('IS', '1', 'Unknown', ''),
        '2005xxA4': ('IS', '1', 'Unknown', ''),
        '2005xxA5': ('IS', '1', 'Unknown', ''),
        '2005xxA6': ('IS', '1', 'Unknown', ''),
        '2005xxA7': ('CS', '1', 'Unknown', ''),
        '2005xxA8': ('DS', '1', 'Unknown', ''),
        '2005xxA9': ('CS', '1', 'Unknown', ''),
        '2005xxB0': ('FL', '1', 'Diffusion Direction RL', ''),
        '2005xxB1': ('FL', '1', 'Diffusion Direction AP', ''),
        '2005xxB2': ('FL', '1', 'Diffusion Direction FH', ''),
        '2005xxC0': ('CS', '1', 'Unknown', ''),
    },
    'Philips MR Imaging DD 002': {
        '2005xx32': ('SQ', '1', 'Unknown', ''),
        '2005xx37': ('LO', '1', 'Unknown', ''),
        '2005xx38': ('LO', '1', 'Unknown', ''),
        '2005xx39': ('LO', '1', 'Unknown', ''),
        '2005xx40': ('LO', '1', 'Unknown', ''),
        '2005xx41': ('LO', '1', 'Unknown', ''),
        '2005xx43': ('SL', '1', 'Unknown', ''),
        '2005xx44': ('OW', '1', 'Unknown', ''),
        '2005xx47': ('CS', '1', 'Unknown', ''),
        '2005xx99': ('UL', '1', 'Unknown', ''),
    },
    'Philips MR Imaging DD 003': {
        '2005xx00': ('UL', '1', 'Unknown', ''),
        '2005xx01': ('UL', '1', 'Unknown', ''),
        '2005xx13': ('UL', '1', 'Unknown', ''),
        '2005xx34': ('SL', '1', 'Unknown', ''),
        '2005xx45': ('SS', '1', 'Unknown', ''),
        '2005xx49': ('SS', '1', 'Unknown', ''),
        '2005xx51': ('SS', '1', 'Unknown', ''),
        '2005xx52': ('SS', '1', 'Unknown', ''),
        '2005xx53': ('SS', '1', 'Unknown', ''),
        '2005xx56': ('SS', '1', 'Unknown', ''),
        '2005xx57': ('SS', '1', 'Unknown', ''),
        '2005xx81': ('UI', '1', 'Unknown', ''),
        '2005xx82': ('CS', '1', 'Unknown', ''),
    },
    'Philips MR Imaging DD 004': {
        '2005xx00': ('SS', '1', 'Unknown', ''),
        '2005xx01': ('SS', '1', 'Unknown', ''),
        '2005xx02': ('SS', '1', 'Unknown', ''),
        '2005xx03': ('SS', '1', 'Unknown', ''),
        '2005xx04': ('SS', '1', 'Unknown', ''),
        '2005xx05': ('SS', '1', 'Unknown', ''),
        '2005xx06': ('SS', '1', 'Unknown', ''),
        '2005xx07': ('FL', '1', 'Unknown', ''),
        '2005xx08': ('FL', '1', 'Unknown', ''),
        '2005xx09': ('FL', '1', 'Unknown', ''),
        '2005xx10': ('FL', '1', 'Unknown', ''),
        '2005xx12': ('FL', '1', 'Unknown', ''),
        '2005xx13': ('SS', '1', 'Unknown', ''),
        '2005xx14': ('SS', '1', 'Unknown', ''),
        '2005xx15': ('SS', '1', 'Unknown', ''),
        '2005xx16': ('SS', '1', 'Unknown', ''),
        '2005xx17': ('SS', '1', 'Unknown', ''),
        '2005xx25': ('CS', '1', 'Unknown', ''),
        '2005xx26': ('FL', '1', 'Unknown', ''),
        '2005xx27': ('CS', '1', 'Unknown', ''),
        '2005xx28': ('CS', '1', 'Unknown', ''),
        '2005xx29': ('FL', '1', 'Unknown', ''),
        '2005xx30': ('CS', '1-n', 'Unknown', ''),
        '2005xx31': ('SS', '1', 'Unknown', ''),
        '2005xx33': ('FL', '3', 'Unknown', ''),
        '2005xx34': ('CS', '1', 'Unknown', ''),
        '2005xx35': ('CS', '1', 'Unknown', ''),
        '2005xx36': ('FL', '1', 'Unknown', ''),
        '2005xx37': ('FL', '1', 'Unknown', ''),
        '2005xx38': ('FL', '1', 'Unknown', ''),
        '2005xx39': ('SS', '2', 'Unknown', ''),
        '2005xx40': ('CS', '1', 'Unknown', ''),
        '2005xx41': ('CS', '1', 'Unknown', ''),
        '2005xx42': ('CS', '1', 'Unknown', ''),
        '2005xx43': ('CS', '1', 'Unknown', ''),
        '2005xx44': ('SS', '1-n', 'Unknown', ''),
        '2005xx45': ('CS', '1', 'Unknown', ''),
        '2005xx46': ('CS', '1', 'Unknown', ''),
        '2005xx47': ('FL', '1', 'Unknown', ''),
        '2005xx48': ('CS', '1', 'Unknown', ''),
        '2005xx49': ('FL', '1', 'Unknown', ''),
        '2005xx50': ('FL', '2', 'Unknown', ''),
        '2005xx51': ('SS', '1', 'Unknown', ''),
        '2005xx52': ('SS', '1', 'Unknown', ''),
        '2005xx53': ('LO', '1-n', 'Unknown', ''),
        '2005xx54': ('CS', '1', 'Unknown', ''),
        '2005xx55': ('FL', '1-n', 'Unknown', ''),
        '2005xx56': ('CS', '1', 'Unknown', ''),
        '2005xx57': ('SS', '1', 'Unknown', ''),
        '2005xx58': ('LO', '1', 'Unknown', ''),
        '2005xx59': ('FL', '1', 'Unknown', ''),
        '2005xx60': ('FL', '1', 'Unknown', ''),
        '2005xx61': ('FL', '2', 'Unknown', ''),
        '2005xx62': ('FL', '1', 'Unknown', ''),
        '2005xx63': ('FL', '1', 'Unknown', ''),
        '2005xx64': ('CS', '1', 'Unknown', ''),
        '2005xx70': ('SS', '1', 'Unknown', ''),
        '2005xx71': ('SQ', '1', 'Unknown', ''),
        '2005xx72': ('SS', '1', 'Unknown', ''),
        '2005xx73': ('SS', '1', 'Unknown', ''),
        '2005xx74': ('SS', '1', 'Unknown', ''),
        '2005xx75': ('SS', '1', 'Unknown', ''),
        '2005xx76': ('SS', '1', 'Unknown', ''),
        '2005xx77': ('SS', '1', 'Unknown', ''),
        '2005xx78': ('SS', '1', 'Unknown', ''),
        '2005xx79': ('SS', '1', 'Unknown', ''),
        '2005xx81': ('IS', '1', 'Unknown', ''),
        '2005xx82': ('UL', '1', 'Unknown', ''),
        '2005xx89': ('SQ', '1', 'Unknown', ''),
        '2005xx90': ('CS', '1', 'Unknown', ''),
        '2005xx91': ('PN', '1', 'Unknown', ''),
        '2005xx92': ('IS', '1', 'Unknown', ''),
        '2005xx93': ('IS', '1', 'Unknown', ''),
        '2005xx95': ('UI', '1', 'Unknown', ''),
        '2005xx96': ('CS', '1', 'Unknown', ''),
        '2005xx97': ('LO', '1', 'Unknown', ''),
        '2005xx98': ('CS', '1', 'Unknown', ''),
        '2005xx99': ('CS', '1', 'Unknown', ''),
    },
    'Philips MR Imaging DD 005': {
        '2005xx00': ('CS', '1', 'Unknown', ''),
        '2005xx01': ('UL', '1', 'Unknown', ''),
        '2005xx02': ('SQ', '1', 'Unknown', ''),
        '2005xx03': ('UL', '1', 'Unknown', ''),
        '2005xx06': ('SS', '1', 'Unknown', ''),
        '2005xx07': ('SS', '1', 'Unknown', ''),
        '2005xx09': ('DS', '1', 'Unknown', ''),
        '2005xx0A': ('DS', '1', 'Unknown', ''),
        '2005xx0B': ('LO', '1', 'Unknown', ''),
        '2005xx0E': ('SQ', '1', 'Unknown', ''),
        '2005xx0F': ('SQ', '1', 'Unknown', ''),
        '2005xx10': ('IS', '1', 'Unknown', ''),
        '2005xx11': ('UI', '1', 'Unknown', ''),
        '2005xx12': ('IS', '1', 'Unknown', ''),
        '2005xx13': ('IS', '1', 'Unknown', ''),
        '2005xx14': ('SL', '1', 'Unknown', ''),
        '2005xx15': ('SL', '1', 'Unknown', ''),
        '2005xx16': ('CS', '1', 'Unknown', ''),
        '2005xx18': ('CS', '3', 'Unknown', ''),
        '2005xx19': ('CS', '3', 'Unknown', ''),
        '2005xx1A': ('CS', '1', 'Unknown', ''),
        '2005xx1B': ('IS', '1', 'Unknown', ''),
        '2005xx1C': ('IS', '1', 'Unknown', ''),
        '2005xx1D': ('IS', '1', 'Unknown', ''),
        '2005xx1E': ('UL', '1', 'Unknown', ''),
        '2005xx1F': ('UL', '1', 'Unknown', ''),
        '2005xx20': ('UL', '1', 'Unknown', ''),
        '2005xx21': ('UL', '1', 'Unknown', ''),
        '2005xx22': ('UL', '1', 'Unknown', ''),
        '2005xx23': ('UL', '1', 'Unknown', ''),
        '2005xx24': ('UL', '1', 'Unknown', ''),
        '2005xx25': ('UL', '1', 'Unknown', ''),
        '2005xx26': ('CS', '1', 'Unknown', ''),
        '2005xx27': ('CS', '1', 'Unknown', ''),
        '2005xx28': ('SL', '1', 'Unknown', ''),
        '2005xx2A': ('CS', '1', 'Unknown', ''),
        '2005xx2B': ('CS', '1', 'Unknown', ''),
        '2005xx2C': ('CS', '1', 'Unknown', ''),
        '2005xx2D': ('CS', '1', 'Unknown', ''),
        '2005xx2E': ('FL', '1', 'Unknown', ''),
        '2005xx2F': ('FL', '1', 'Unknown', ''),
        '2005xx30': ('FL', '1', 'Unknown', ''),
        '2005xx31': ('FL', '1', 'Unknown', ''),
        '2005xx32': ('CS', '1', 'Unknown', ''),
        '2005xx35': ('CS', '1', 'Unknown', ''),
        '2005xx36': ('UI', '1', 'Unknown', ''),
        '2005xx37': ('CS', '1', 'Unknown', ''),
        '2005xx38': ('LT', '1', 'Unknown', ''),
        '2005xx39': ('LT', '1', 'Unknown', ''),
        '2005xx3A': ('LT', '1', 'Unknown', ''),
        '2005xx3B': ('CS', '1', 'Unknown', ''),
        '2005xx3C': ('FL', '1', 'Unknown', ''),
        '2005xx3D': ('FL', '1', 'Unknown', ''),
        '2005xx3E': ('FL', '1', 'Unknown', ''),
        '2005xx3F': ('CS', '1', 'Unknown', ''),
        '2005xx40': ('FL', '1', 'Unknown', ''),
        '2005xx41': ('FL', '1', 'Unknown', ''),
        '2005xx42': ('FL', '1', 'Unknown', ''),
        '2005xx43': ('FL', '1', 'Unknown', ''),
        '2005xx44': ('IS', '1', 'Unknown', ''),
        '2005xx45': ('CS', '1', 'Unknown', ''),
        '2005xx46': ('FL', '1', 'Unknown', ''),
        '2005xx47': ('FL', '1', 'Unknown', ''),
        '2005xx48': ('FL', '1', 'Unknown', ''),
        '2005xx49': ('FL', '1', 'Unknown', ''),
        '2005xx4A': ('FL', '1', 'Unknown', ''),
        '2005xx4B': ('FL', '1', 'Unknown', ''),
        '2005xx4C': ('FL', '1', 'Unknown', ''),
        '2005xx4D': ('CS', '1', 'Unknown', ''),
        '2005xx4E': ('CS', '1', 'Unknown', ''),
        '2005xx4F': ('CS', '1', 'Unknown', ''),
        '2005xx50': ('SS', '1', 'Unknown', ''),
    },
    'Philips MR Imaging DD 006': {
        '20050053': ('FL', '1', 'Unknown', ''),
        '20050054': ('FL', '1', 'Unknown', ''),
        '20050055': ('FL', '1', 'Unknown', ''),
        '20050056': ('FL', '1', 'Unknown', ''),
        '20050057': ('CS', '1', 'Unknown', ''),
        '20050058': ('FL', '1', 'Unknown', ''),
        '20050059': ('FL', '1', 'Unknown', ''),
        '20050060': ('IS', '1', 'Unknown', ''),
        '20050061': ('FL', '1', 'Unknown', ''),
        '20050062': ('LT', '1', 'Unknown', ''),
        '20050063': ('CS', '1', 'Unknown', ''),
        '20050064': ('CS', '1', 'Unknown', ''),
        '20050065': ('CS', '1', 'Unknown', ''),
        '20050066': ('CS', '1', 'Unknown', ''),
        '20050067': ('IS', '1', 'Unknown', ''),
        '20050068': ('IS', '1', 'Unknown', ''),
        '20050071': ('IS', '1', 'Unknown', ''),
        '20050072': ('FL', '1', 'Unknown', ''),
        '20050073': ('IS', '1', 'Unknown', ''),
        '20050074': ('DS', '1', 'Unknown', ''),
        '20050075': ('DS', '1', 'Unknown', ''),
        '20050076': ('LT', '1', 'Unknown', ''),
        '20050078': ('CS', '1', 'Unknown', ''),
        '20050079': ('CS', '3', 'Unknown', ''),
        '20050081': ('CS', '1', 'Unknown', ''),
        '20050082': ('IS', '1', 'Unknown', ''),
        '20050083': ('LT', '1', 'Unknown', ''),
        '20050085': ('DS', '1', 'Unknown', ''),
        '20050086': ('LT', '1', 'Unknown', ''),
        '20050087': ('DS', '1', 'Unknown', ''),
        '20050095': ('CS', '1', 'Unknown', ''),
        '20050096': ('IS', '1', 'Unknown', ''),
        '20050097': ('CS', '1', 'Unknown', ''),
        '20050099': ('SL', '1', 'Unknown', ''),
    },
    'Philips MR Imaging DD 007': {
        '20050000': ('CS', '1', 'Unknown', ''),
        '20050001': ('FL', '1', 'Unknown', ''),
        '20050002': ('FL', '1', 'Unknown', ''),
        '20050003': ('FL', '1', 'Unknown', ''),
    },
    'Philips NM Private Group': {
        '7043xx00': ('SH', '1', 'Unknown', ''),
    },
    'Philips PET Private Group': {
        '0511xx00': ('US', '1', 'Unknown', ''),
        '0511xx01': ('US', '1', 'Unknown', ''),
        '0511xx02': ('OB', '1', 'Unknown', ''),
        '0511xx03': ('OB', '1', 'Unknown', ''),
        '0511xx32': ('DS', '1', 'Unknown', ''),
        '0511xx50': ('DS', '1', 'Unknown', ''),
        '7053xx00': ('DS', '1', 'SUV Scale Factor', ''),
        '7053xx01': ('OB', '1', 'Private', ''),
        '7053xx02': ('OB', '1', 'Private', ''),
        '7053xx03': ('ST', '1', 'Original image file name', ''),
        '7053xx04': ('OB', '1', 'File Data', ''),
        '7053xx05': ('LO', '1', 'Worklist Info File Name', ''),
        '7053xx06': ('OB', '1', 'Unknown', ''),
        '7053xx07': ('SQ', '1', 'Acquisition File Sequence', ''),
        '7053xx08': ('SQ', '1', 'Unknown', ''),
        '7053xx09': ('DS', '1', 'Activity Concentration Scale Factor', ''),
        '7053xx0B': ('UN', '1', 'Unknown', ''),
        '7053xx0C': ('UN', '1', 'Unknown', ''),
        '7053xx0D': ('UN', '1', 'Unknown', ''),
        '7053xx0E': ('UN', '1', 'Unknown', ''),
        '7053xx0F': ('UL', '1', 'Segment Size', ''),
        '7053xx10': ('US', '1', 'Segment Number', ''),
        '7053xx11': ('US', '1', 'Number of Segments', ''),
        '7053xx12': ('SQ', '1', 'File Data Sequence', ''),
        '7053xx13': ('SS', '1', 'Unknown', ''),
        '7053xx14': ('SS', '1', 'Unknown', ''),
        '7053xx15': ('SS', '1', 'Unknown', ''),
        '7053xx16': ('SS', '1', 'Unknown', ''),
        '7053xx17': ('SS', '1', 'Unknown', ''),
        '7053xx18': ('SS', '1', 'Unknown', ''),
        '7053xx50': ('UN', '1', 'Unknown', ''),
        '7053xx51': ('UN', '1', 'Unknown', ''),
        '7053xx52': ('UN', '1', 'Unknown', ''),
        '7053xx53': ('UN', '1', 'Unknown', ''),
        '7053xx54': ('UN', '1', 'Unknown', ''),
        '7053xx55': ('UN', '1', 'Unknown', ''),
        '7053xx56': ('UN', '1', 'Unknown', ''),
        '7053xx57': ('UN', '1', 'Unknown', ''),
        '7053xx58': ('UN', '1', 'Unknown', ''),
        '7053xx59': ('UN', '1', 'Unknown', ''),
        '7053xx5A': ('UN', '1', 'Unknown', ''),
        '7053xx5B': ('UN', '1', 'Unknown', ''),
        '7053xx5C': ('UN', '1', 'Unknown', ''),
        '7053xx5D': ('UN', '1', 'Unknown', ''),
        '7053xx5E': ('UN', '1', 'Unknown', ''),
        '7053xx5F': ('UN', '1', 'Unknown', ''),
        '7053xx60': ('UN', '1', 'Unknown', ''),
        '7053xx61': ('UN', '1', 'Unknown', ''),
        '7053xx62': ('UN', '1', 'Unknown', ''),
        '7053xx63': ('UN', '1', 'Unknown', ''),
        '7053xx64': ('UN', '1', 'Unknown', ''),
        '7053xx65': ('UN', '1', 'Unknown', ''),
        '7053xx66': ('UN', '1', 'Unknown', ''),
        '7053xx67': ('UN', '1', 'Unknown', ''),
        '7053xx68': ('UN', '1', 'Unknown', ''),
        '7053xx69': ('UN', '1', 'Unknown', ''),
        '7053xx6A': ('UN', '1', 'Unknown', ''),
        '7053xx6B': ('UN', '1', 'Unknown', ''),
        '7053xx6C': ('UN', '1', 'Unknown', ''),
        '7053xx6D': ('UN', '1', 'Unknown', ''),
        '7053xx6E': ('UN', '1', 'Unknown', ''),
        '7053xx6F': ('UN', '1', 'Unknown', ''),
        '7053xx70': ('UN', '1', 'Unknown', ''),
        '7053xx71': ('UN', '1', 'Unknown', ''),
        '7053xx72': ('UN', '1', 'Unknown', ''),
        '7053xx73': ('UN', '1', 'Unknown', ''),
        '7053xx74': ('UN', '1', 'Unknown', ''),
        '7053xx75': ('UN', '1', 'Unknown', ''),
        '7053xx76': ('UN', '1', 'Unknown', ''),
        '7053xx77': ('UN', '1', 'Unknown', ''),
        '7053xx78': ('UN', '1', 'Unknown', ''),
        '7053xxC2': ('UI', '1', 'Unknown', ''),
        '7053xxD0': ('UN', '1', 'Unknown', ''),
        '7053xxD1': ('UN', '1', 'Unknown', ''),
        '7053xxD2': ('UN', '1', 'Unknown', ''),
        '7053xxD3': ('UN', '1', 'Unknown', ''),
        '7053xxD5': ('UN', '1', 'Unknown', ''),
        '7053xxD6': ('UN', '1', 'Unknown', ''),
        '7053xxD7': ('UN', '1', 'Unknown', ''),
        '7053xxD8': ('UN', '1', 'Unknown', ''),
        '7053xxD9': ('UN', '1', 'Unknown', ''),
    },
    'Philips RAD Imaging DD 001': {
        '200Bxx00': ('PN', '1', 'Unknown', ''),
        '200Bxx01': ('US', '1', 'Unknown', ''),
        '200Bxx02': ('US', '1', 'Unknown', ''),
        '200Bxx05': ('IS', '1', 'Unknown', ''),
        '200Bxx11': ('LO', '1', 'Unknown', ''),
        '200Bxx27': ('DT', '1', 'Unknown', ''),
        '200Bxx28': ('DS', '1', 'Unknown', ''),
        '200Bxx29': ('DS', '1', 'Unknown', ''),
        '200Bxx2A': ('UL', '1', 'Unknown', ''),
        '200Bxx2B': ('DA', '1', 'Unknown', ''),
        '200Bxx2C': ('TM', '1', 'Unknown', ''),
        '200Bxx2D': ('LO', '1', 'Unknown', ''),
        '200Bxx3B': ('LO', '1', 'Unknown', ''),
        '200Bxx40': ('SH', '1', 'Unknown', ''),
        '200Bxx41': ('SH', '1', 'Unknown', ''),
        '200Bxx42': ('UI', '1', 'Unknown', ''),
        '200Bxx43': ('UI', '1', 'Unknown', ''),
        '200Bxx47': ('DA', '1', 'Unknown', ''),
        '200Bxx48': ('SH', '1', 'Unknown', ''),
        '200Bxx4C': ('SH', '1', 'Unknown', ''),
        '200Bxx4D': ('SH', '1', 'Unknown', ''),
        '200Bxx4F': ('DT', '1', 'Unknown', ''),
        '200Bxx52': ('CS', '1', 'Unknown', ''),
    },
    'Philips RAD Imaging DD 097': {
        '200Bxx00': ('ST', '1', 'Unknown', ''),
        '200Bxx01': ('CS', '1', 'Unknown', ''),
        '200Bxx02': ('SS', '1', 'Unknown', ''),
        '200Bxx50': ('SS', '1', 'Unknown', ''),
        '200Bxx51': ('SS', '1', 'Unknown', ''),
        '200Bxx52': ('SS', '1', 'Unknown', ''),
        '200Bxx53': ('SS', '1', 'Unknown', ''),
        '200Bxx54': ('ST', '1', 'Unknown', ''),
        '200Bxx60': ('LT', '1', 'Unknown', ''),
        '200Bxx63': ('LT', '1', 'Unknown', ''),
        '200Bxx65': ('SS', '1', 'Unknown', ''),
        '200Bxx6E': ('US', '1', 'Unknown', ''),
        '200Bxx72': ('FD', '1', 'Unknown', ''),
        '200Bxx73': ('SS', '1', 'Unknown', ''),
        '200Bxx74': ('IS', '1', 'Unknown', ''),
        '200Bxx75': ('CS', '1', 'Unknown', ''),
        '200Bxx76': ('SH', '1', 'Unknown', ''),
        '200Bxx78': ('IS', '1-n', 'Unknown', ''),
        '200Bxx79': ('IS', '1', 'Unknown', ''),
        '200Bxx7A': ('IS', '1', 'Unknown', ''),
        '200Bxx7B': ('US', '1', 'Unknown', ''),
        '200Bxx7C': ('US', '1', 'Unknown', ''),
        '200Bxx7D': ('IS', '1-n', 'Unknown', ''),
        '200Bxx7E': ('UI', '1', 'Unknown', ''),
        '200Bxx81': ('LO', '1', 'Unknown', ''),
        '200Bxx82': ('LO', '1', 'Unknown', ''),
        '200Bxx85': ('IS', '1', 'Unknown', ''),
        '200Bxx86': ('CS', '1', 'Unknown', ''),
        '200Bxx88': ('CS', '1', 'Unknown', ''),
        '200Bxx89': ('LT', '1', 'Unknown', ''),
        '200Bxx90': ('DS', '1', 'Unknown', ''),
        '200Bxx96': ('SH', '1', 'Unknown', ''),
        '200Bxx99': ('SH', '1', 'Unknown', ''),
        '200Bxx9A': ('FD', '1', 'Unknown', ''),
        '200Bxx9B': ('FD', '1', 'Unknown', ''),
        '200BxxA0': ('LT', '1', 'Unknown', ''),
    },
    'Philips US Imaging 60': {
        '0031xx30': ('UL', '1', 'Private data', ''),
        '0031xx31': ('UL', '1', 'Private data', ''),
    },
    'Philips US Imaging DD 017': {
        '200Dxx05': ('LO', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 023': {
        '200Dxx37': ('DA', '1', 'Unknown', ''),
        '200Dxx38': ('TM', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 033': {
        '200Dxx01': ('LO', '1', 'Unknown', ''),
        '200Dxx02': ('LO', '1', 'Unknown', ''),
        '200Dxx03': ('LO', '6', 'Unknown', ''),
        '200Dxx04': ('LO', '6', 'Unknown', ''),
        '200Dxx05': ('LO', '1-n', 'Unknown', ''),
        '200Dxx06': ('LO', '6', 'Unknown', ''),
        '200Dxx07': ('LO', '1', 'Unknown', ''),
        '200Dxx08': ('LO', '1', 'Unknown', ''),
        '200Dxx09': ('LO', '1', 'Unknown', ''),
        '200Dxx0A': ('LO', '1', 'Unknown', ''),
        '200Dxx0B': ('OB', '1', 'Raw Data US', ''),
        '200Dxx14': ('IS', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 034': {
        '200Dxx01': ('LO', '1', 'Unknown', ''),
        '200Dxx02': ('LO', '1', 'Unknown', ''),
        '200Dxx03': ('LO', '1', 'Unknown', ''),
        '200Dxx04': ('LO', '1', 'Unknown', ''),
        '200Dxx05': ('LO', '1', 'Unknown', ''),
        '200Dxx06': ('LO', '1', 'Unknown', ''),
        '200Dxx07': ('LO', '1', 'Unknown', ''),
        '200Dxx08': ('LO', '1', 'Unknown', ''),
        '200Dxx09': ('LO', '1', 'Unknown', ''),
        '200Dxx0A': ('LO', '1', 'Unknown', ''),
        '200Dxx0B': ('LO', '1', 'Unknown', ''),
        '200Dxx0C': ('LO', '1', 'Unknown', ''),
        '200Dxx0D': ('LO', '1', 'Unknown', ''),
        '200Dxx0E': ('LO', '1', 'Unknown', ''),
        '200Dxx0F': ('LO', '1', 'Unknown', ''),
        '200Dxx10': ('LO', '1', 'Unknown', ''),
        '200Dxx21': ('LO', '1', 'Unknown', ''),
        '200Dxx22': ('LO', '1', 'Unknown', ''),
        '200Dxx23': ('LO', '1', 'Unknown', ''),
        '200Dxx24': ('LO', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 035': {
        '200Dxx01': ('LO', '1', 'Unknown', ''),
        '200Dxx02': ('LO', '1', 'Unknown', ''),
        '200Dxx03': ('LO', '1', 'Unknown', ''),
        '200Dxx04': ('LO', '1', 'Unknown', ''),
        '200Dxx05': ('LO', '1', 'Unknown', ''),
        '200Dxx07': ('LO', '1', 'Unknown', ''),
        '200Dxx08': ('LO', '1', 'Unknown', ''),
        '200Dxx09': ('LO', '1', 'Unknown', ''),
        '200Dxx0A': ('LO', '1', 'Unknown', ''),
        '200Dxx0B': ('LO', '1', 'Unknown', ''),
        '200Dxx0C': ('LO', '1', 'Unknown', ''),
        '200Dxx0D': ('LO', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 036': {
        '200Dxx01': ('LO', '3', 'Cols/Rows/Frames', ''),
        '200Dxx02': ('LO', '3', 'Cols/Rows/Frames', ''),
        '200Dxx03': ('LO', '3', 'Voxel Spacing', ''),
        '200Dxx04': ('LO', '3', 'Unknown', ''),
    },
    'Philips US Imaging DD 038': {
        '200Dxx01': ('LO', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 039': {
        '200Dxx01': ('LO', '1', 'Unknown', ''),
        '200Dxx04': ('LO', '1', 'Unknown', ''),
        '200Dxx05': ('LO', '1', 'Unknown', ''),
        '200Dxx06': ('LO', '1', 'Unknown', ''),
        '200Dxx07': ('LO', '1', 'Unknown', ''),
        '200Dxx08': ('LO', '1', 'Unknown', ''),
        '200Dxx09': ('LO', '1', 'Unknown', ''),
        '200Dxx0A': ('LO', '1', 'Unknown', ''),
        '200Dxx0B': ('LO', '1', 'Unknown', ''),
        '200Dxx0C': ('LO', '1', 'Unknown', ''),
        '200Dxx0D': ('LO', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 040': {
        '200Dxx01': ('LO', '1', 'Unknown', ''),
        '200Dxx02': ('LO', '1', 'Unknown', ''),
        '200Dxx03': ('LO', '1', 'Unknown', ''),
        '200Dxx04': ('LO', '1', 'Unknown', ''),
        '200Dxx05': ('LO', '1', 'Unknown', ''),
        '200Dxx06': ('LO', '1', 'Unknown', ''),
        '200Dxx07': ('LO', '1', 'Unknown', ''),
        '200Dxx20': ('LO', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 041': {
        '200Dxx1E': ('LO', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 042': {
        '200Dxx50': ('LO', '3', 'Unknown', ''),
        '200Dxx51': ('LO', '1', 'Unknown', ''),
        '200Dxx52': ('LO', '1', 'Unknown', ''),
        '200Dxx53': ('LO', '1', 'Unknown', ''),
        '200Dxx54': ('LO', '1', 'Unknown', ''),
        '200Dxx55': ('LO', '1', 'Unknown', ''),
        '200Dxx56': ('LO', '1', 'Unknown', ''),
        '200Dxx57': ('LO', '1', 'Unknown', ''),
        '200Dxx58': ('LO', '1', 'Unknown', ''),
        '200Dxx59': ('LO', '1', 'Unknown', ''),
        '200Dxx5A': ('LO', '1', 'Unknown', ''),
        '200Dxx5B': ('LO', '1', 'Unknown', ''),
        '200Dxx5C': ('LO', '1', 'Unknown', ''),
        '200Dxx5D': ('LO', '1', 'Unknown', ''),
        '200Dxx5E': ('LO', '1', 'Unknown', ''),
        '200Dxx5F': ('LO', '1', 'Unknown', ''),
        '200Dxx60': ('LO', '1', 'Unknown', ''),
        '200Dxx70': ('LO', '1', 'Unknown', ''),
        '200Dxx71': ('LO', '1', 'Unknown', ''),
        '200Dxx72': ('LO', '1', 'Unknown', ''),
        '200Dxx73': ('LO', '1', 'Unknown', ''),
        '200Dxx74': ('LO', '1', 'Unknown', ''),
        '200Dxx75': ('LO', '1', 'Unknown', ''),
        '200Dxx76': ('LO', '1', 'Unknown', ''),
        '200Dxx77': ('LO', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 043': {
        '200Dxx05': ('SH', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 109': {
        '200Dxx00': ('US', '1', 'Unknown', ''),
        '200Dxx01': ('SQ', '1', 'Unknown', ''),
        '200Dxx02': ('ST', '1', 'Unknown', ''),
        '200Dxx03': ('CS', '1', 'Unknown', ''),
        '200Dxx04': ('SL', '4', 'Unknown', ''),
        '200Dxx05': ('UL', '3', 'Unknown', ''),
        '200Dxx06': ('UL', '3', 'Unknown', ''),
        '200Dxx07': ('CS', '1', 'Unknown', ''),
        '200Dxx08': ('CS', '1', 'Unknown', ''),
        '200Dxx09': ('OB', '1', 'Unknown', ''),
        '200Dxx0A': ('UL', '1', 'Unknown', ''),
        '200Dxx0B': ('OB', '1', 'Unknown', ''),
        '200Dxx0C': ('UL', '1', 'Unknown', ''),
        '200Dxx0D': ('SQ', '1', 'Unknown', ''),
        '200Dxx0E': ('CS', '1', 'Unknown', ''),
        '200Dxx0F': ('LO', '1', 'Unknown', ''),
        '200Dxx10': ('SL', '1', 'Unknown', ''),
        '200Dxx11': ('LO', '1', 'Unknown', ''),
        '200Dxx12': ('SL', '1', 'Unknown', ''),
    },
    'Philips US Imaging DD 113': {
        '200Dxx01': ('LO', '1', 'Unknown', ''),
        '200Dxx02': ('UL', '1', 'Unknown', ''),
        '200Dxx03': ('UL', '1', 'Unknown', ''),
        '200Dxx04': ('UL', '1', 'Unknown', ''),
        '200Dxx05': ('UL', '1', 'Unknown', ''),
        '200Dxx06': ('UL', '1', 'Unknown', ''),
        '200Dxx07': ('CS', '1', 'Unknown', ''),
        '200Dxx09': ('UL', '1', 'Unknown', ''),
        '200Dxx0B': ('CS', '1', 'Unknown', ''),
        '200Dxx0C': ('UL', '1', 'Unknown', ''),
        '200Dxx0D': ('UL', '1', 'Unknown', ''),
        '200Dxx0E': ('UL', '1', 'Unknown', ''),
        '200Dxx0F': ('DS', '1', 'Unknown', ''),
        '200Dxx10': ('DS', '1', 'Unknown', ''),
        '200Dxx11': ('SL', '1', 'Unknown', ''),
        '200Dxx12': ('UL', '1', 'Unknown', ''),
        '200Dxx13': ('FL', '1-n', 'Unknown', ''),
        '200Dxx14': ('US', '1', 'Unknown', ''),
        '200Dxx15': ('UL', '1', 'Unknown', ''),
        '200Dxx17': ('FD', '1', 'Unknown', ''),
        '200Dxx18': ('FD', '1', 'Unknown', ''),
        '200Dxx19': ('FD', '1', 'Unknown', ''),
        '200Dxx1A': ('FD', '1', 'Unknown', ''),
        '200Dxx1B': ('FD', '1', 'Unknown', ''),
        '200Dxx1C': ('FD', '1', 'Unknown', ''),
        '200Dxx1D': ('UL', '1', 'Unknown', ''),
        '200Dxx1E': ('UL', '1', 'Unknown', ''),
        '200Dxx1F': ('FD', '1', 'Unknown', ''),
        '200Dxx20': ('FD', '1', 'Unknown', ''),
        '200Dxx21': ('FD', '1', 'Unknown', ''),
    },
    'Philips US Private 3D': {
        '200Dxx02': ('IS', '1', 'Threedpr Echo Vision Setting', ''),
        '200Dxx03': ('IS', '1', 'Threedpr Color Vision Setting', ''),
        '200Dxx04': ('IS', '1', 'Threedpr Transparency', ''),
        '200Dxx06': ('FD', '1', 'Threedpr Vision Vol Brightness', ''),
        '200Dxx08': ('IS', '1', 'Threedpr Low Threshold', ''),
        '200Dxx09': ('IS', '1', 'Threedpr Image Layout', ''),
        '200Dxx0A': ('IS', '1', 'Threedpr Xres Filtering Enabled', ''),
        '200Dxx0B': ('IS', '1', 'Threedpr Echo Twod Chroma Map Enabled', ''),
        '200Dxx0C': ('IS', '1', 'Threedpr Box Outlined Enabled', ''),
        '200Dxx0D': ('IS', '1', 'Threedpr Smoothing Enabled', ''),
        '200Dxx0E': ('IS', '1', 'Threedpr Reference Graphic Enabled', ''),
        '200Dxx0F': ('IS', '1', 'Threedpr Map Inverted', ''),
        '200Dxx10': ('IS', '1', 'Threedpr Color Stream Display Enabled', ''),
        '200Dxx11': ('IS', '1', 'Threedpr Echo Stream Display Enabled', ''),
        '200Dxx12': ('LO', '1', 'Vdb Param Color 3d Estimate Scale(2)', ''),
        '200Dxx13': ('LO', '1', 'Vdb Param Color 3d Estimate Apex Position (1)', ''),
        '200Dxx14': ('LO', '1', 'Vdb Param Color 3d Estimate Color Offset', ''),
        '200Dxx15': ('LO', '1', 'Vdb Param Echo 3d Estimate Dimension(2)', ''),
        '200Dxx16': ('SQ', '1', 'Private Native Threed Data Sequence(1)', ''),
        '200Dxx17': ('IS', '1', 'Threedpr Basic Vol Brightness', ''),
        '200Dxx18': ('LO', '1', 'Vdb Param Echo 3d Estimate Apex Position (2)', ''),
        '200Dxx1A': ('IS', '1', 'Threedpr Echo Smoothing', ''),
        '200Dxx1B': ('IS', '1', 'Threedpr Color Smoothing', ''),
        '200Dxx1E': ('IS', '1', 'Threedpr Num Completed Trim Planes', ''),
        '200Dxx1F': ('IS', '1', 'Threedpr Depth', ''),
        '200Dxx20': ('SQ', '1', 'Private Native Data Stream Array', ''),
        '200Dxx21': ('IS', '1', 'Threedpr Wall Filter', ''),
        '200Dxx23': ('FD', '1', 'Threedpr Baseline', ''),
        '200Dxx24': ('FD', '1', 'Threedpr Gain', ''),
        '200Dxx25': ('FD', '1', 'Threedpr Compress', ''),
        '200Dxx26': ('FD', '1', 'Threedpr Light Brightness', ''),
        '200Dxx27': ('FD', '1', 'Threedpr Elevation Scale Factor', ''),
        '200Dxx28': ('FD', '1', 'Threedpr Zoom Factor', ''),
        '200Dxx29': ('FD', '1', 'Threedpr Color Write Priority', ''),
        '200Dxx2A': ('FD', '1', 'Threedpr Rotation Angle X', ''),
        '200Dxx2B': ('FD', '1', 'Threedpr Rotation Angle Y', ''),
        '200Dxx2C': ('FD', '1', 'Threedpr Data Voi Center', ''),
        '200Dxx2D': ('FD', '1', 'Threedpr View Translation', ''),
        '200Dxx2E': ('FD', '1', 'Threedpr Data Voi Min Point', ''),
        '200Dxx2F': ('FD', '1', 'Threedpr Data Voi Max Point', ''),
        '200Dxx30': ('FD', '1', 'Threedpr Box Crop Min Point', ''),
        '200Dxx31': ('FD', '1', 'Threedpr Box Crop Max Point', ''),
        '200Dxx32': ('FD', '1', 'Threedpr Mpr Rotation Matrix', ''),
        '200Dxx33': ('FD', '1', 'Threedpr Vol Rotation Matrix', ''),
        '200Dxx34': ('FD', '1', 'Threedpr Trim Plane Equation', ''),
        '200Dxx35': ('IS', '1', 'Threedpr Subpage Data Version', ''),
        '200Dxx36': ('IS', '1', 'Threedpr Is Arbitrary Crop', ''),
        '200Dxx37': ('IS', '1', 'Threedpr Arbitrary Crop Dist From Center', ''),
        '200Dxx38': ('FD', '1', 'Threedpr Arbitrary Crop Rotation Matrix', ''),
        '200Dxx39': ('FD', '1', 'Threedpr Color Gain', ''),
        '200Dxx40': ('IS', '1', 'Threedpr Color Wall Filter Index', ''),
        '200Dxx41': ('IS', '1', 'Threedpr Cursor Enabled', ''),
        '200Dxx42': ('IS', '1', 'Threedpr Bondbox Graphic Enabled', ''),
    },
    'Philips X-ray Imaging DD 001': {
        '2003xx00': ('CS', '1', 'Unknown', ''),
        '2003xx01': ('LO', '1', 'Unknown', ''),
        '2003xx02': ('FD', '3', 'Unknown', ''),
        '2003xx03': ('LO', '1', 'Unknown', ''),
        '2003xx04': ('SQ', '1', 'Private enhanced Table Sequence', ''),
        '2003xx06': ('SL', '1', 'Unknown', ''),
        '2003xx09': ('SL', '1', 'Unknown', ''),
        '2003xx10': ('LO', '1', 'Unknown', ''),
        '2003xx11': ('SL', '1', 'Unknown', ''),
        '2003xx12': ('SL', '1', 'Unknown', ''),
        '2003xx13': ('SL', '1', 'Unknown', ''),
        '2003xx14': ('FD', '1', 'Unknown', ''),
        '2003xx15': ('FD', '1', 'Unknown', ''),
        '2003xx16': ('SL', '1', 'Unknown', ''),
        '2003xx17': ('SL', '1', 'Unknown', ''),
        '2003xx18': ('SL', '1', 'Unknown', ''),
        '2003xx19': ('SL', '1', 'Unknown', ''),
        '2003xx22': ('SL', '1', 'Unknown', ''),
        '2003xx24': ('FD', '4', 'Unknown', ''),
        '2003xx25': ('SL', '1', 'Unknown', ''),
        '2003xx26': ('SL', '1', 'Unknown', ''),
        '2003xx27': ('SH', '1', 'Unknown', ''),
        '2003xx28': ('SH', '1', 'Unknown', ''),
        '2003xx29': ('FD', '1', 'Unknown', ''),
        '2003xx2A': ('LO', '1', 'Unknown', ''),
        '2003xx2B': ('FD', '1', 'Unknown', ''),
        '2003xx2C': ('SH', '1', 'Unknown', ''),
        '2003xx2D': ('SL', '1-n', 'Unknown', ''),
        '2003xx2E': ('SQ', '1', 'Unknown', ''),
        '2003xx2F': ('CS', '1', 'IsResolvePatientMixApplied', ''),
        '2003xx30': ('CS', '1', 'Unknown', ''),
        '2003xx31': ('CS', '1', 'Unknown', ''),
        '2003xx32': ('UI', '1', 'Unknown', ''),
    },
    'Picker MR Private Group': {
        '7101xx00': ('OB', '1', 'Unknown', ''),
        '7101xx01': ('SL', '1', 'Unknown', ''),
        '7101xx02': ('OB', '1', 'Unknown', ''),
        '7101xx03': ('SL', '1', 'Unknown', ''),
        '7101xx04': ('SH', '1', 'Unknown', ''),
        '7101xx05': ('SH', '2', 'Unknown', ''),
        '7101xx06': ('SH', '4', 'Unknown', ''),
        '7101xx10': ('DS', '1', 'Unknown', ''),
    },
    'Picker NM Private Group': {
        '7001xx01': ('UI', '1', 'Private', ''),
        '7001xx02': ('OB', '1', 'Private', ''),
        '7001xx03': ('OB', '1', 'Private', ''),
        '7001xx04': ('OB', '1', 'Private', ''),
        '7001xx05': ('OB', '1', 'Private', ''),
        '7001xx06': ('OB', '1', 'Private', ''),
        '7001xx07': ('OB', '1', 'Private', ''),
        '7001xx08': ('OB', '1', 'Private', ''),
        '7001xx09': ('OB', '1', 'Private', ''),
        '7001xx10': ('SQ', '1', 'Private', ''),
        '7001xx11': ('LO', '1', 'Private', ''),
        '7001xx12': ('OB', '1', 'Private', ''),
        '7001xx13': ('US', '1', 'Private', ''),
        '7001xx14': ('OB', '1', 'Private', ''),
        '7001xx15': ('OB', '1', 'Private', ''),
        '7001xx16': ('OB', '1', 'Private', ''),
        '7001xx17': ('LO', '1', 'Contains a text string that includes some of the same information that appears on the Odyssey Clinical Index (image directory) for this Image.', ''),
        '7043xx00': ('SH', '1', 'Private.', ''),
    },
    'QCA': {
        '0009xx00': ('CS', '1', 'Analysis Type', ''),
        '0009xx04': ('LO', '1', 'Segment Name', ''),
        '0009xx12': ('DS', '1', 'Pre Catheter size', ''),
        '0009xx13': ('DS', '1', 'Pre Reference Diameter', ''),
        '0009xx14': ('DS', '1', 'Pre Minimum Lumen Diameter', ''),
        '0009xx15': ('DS', '1', 'Pre Average Diameter', ''),
        '0009xx16': ('DS', '1', 'Pre Stenosis Length', ''),
        '0009xx17': ('DS', '1', 'Pre Stenosis %', ''),
        '0009xx18': ('DS', '1', 'Pre Geometric Area Reduction %', ''),
        '0009xx22': ('DS', '1', 'Post Catheter Size', ''),
        '0009xx23': ('DS', '1', 'Post Reference Diameter', ''),
        '0009xx24': ('DS', '1', 'Post Minimum Lumen Diameter', ''),
        '0009xx25': ('DS', '1', 'Post Average Diameter', ''),
        '0009xx26': ('DS', '1', 'Post Stenosis Length', ''),
        '0009xx27': ('DS', '1', 'Post Stenosis %', ''),
        '0009xx28': ('DS', '1', 'Post Geometric Area Reduction %', ''),
    },
    'QCA_RESULTS': {
        '0009xx00': ('CS', '1', 'Analysis Views', ''),
        '0009xx10': ('LO', '1', 'Segment', ''),
        '0009xx11': ('LO', '1', 'Pre Catheter Name', ''),
        '0009xx12': ('DS', '1', 'Pre Catheter Size', ''),
        '0009xx13': ('DS', '1', 'Pre Reference Diameter', ''),
        '0009xx14': ('DS', '1', 'Pre Minimum Lumen Diameter', ''),
        '0009xx15': ('DS', '1', 'Pre Average Diameter', ''),
        '0009xx16': ('DS', '1', 'Pre Stenosis Length', ''),
        '0009xx17': ('IS', '1', 'Pre Stenosis %', ''),
        '0009xx18': ('IS', '1', 'Pre Geometric Area Reduction %', ''),
        '0009xx21': ('LO', '1', 'Post Catheter Name', ''),
        '0009xx22': ('DS', '1', 'Post Catheter Size', ''),
        '0009xx23': ('DS', '1', 'Post Reference Diameter', ''),
        '0009xx24': ('DS', '1', 'Post Minimum Lumen Diameter', ''),
        '0009xx25': ('DS', '1', 'Post Average Diameter', ''),
        '0009xx26': ('DS', '1', 'Post Stenosis Length', ''),
        '0009xx27': ('IS', '1', 'Post Stenosis %', ''),
        '0009xx28': ('IS', '1', 'Post Geometric Area Reduction %', ''),
        '0009xx40': ('IS', '1', 'Calibration Frame', ''),
        '0009xx41': ('IS', '1', 'End Diastolic Frame', ''),
        '0009xx42': ('IS', '1', 'End Systolic Frame', ''),
        '0009xx43': ('DS', '1', 'End Diastolic Volume', ''),
        '0009xx44': ('DS', '1', 'End Systolic Volume', ''),
        '0009xx45': ('DS', '1', 'Stroke Volume', ''),
        '0009xx47': ('DS', '1', 'Ejection Fraction', ''),
        '0009xx48': ('DS', '1', 'Body Surface Area', ''),
        '0009xx49': ('SH', '1', 'Artery Territory Region', ''),
        '0009xx50': ('IS', '1', 'Number of Diseased Vessels', ''),
        '0009xx51': ('DS', '1', 'Hypokinesis in Region', ''),
        '0009xx52': ('DS', '1', 'Hyperkinesis in Opposite Region', ''),
        '0009xx53': ('IS', '1', 'Percent Total LV Hypokinesis', ''),
        '0009xx55': ('DS', '1', 'Calibration Factor', ''),
    },
    'QUASAR_INTERNAL_USE': {
        '0009xx01': ('UL', '1-n', 'Rate Vector', ''),
        '0009xx02': ('UL', '1-n', 'Count Vector', ''),
        '0009xx03': ('UL', '1-n', 'Time Vector', ''),
        '0009xx07': ('US', '1-n', 'Angle Vector', ''),
        '0009xx08': ('US', '1', 'Camera Shape', ''),
        '0009xx10': ('US', '1', 'WholeBody Spots', ''),
        '0009xx11': ('US', '1', 'Worklist Flag', ''),
        '0009xx12': ('LO', '1', 'Unknown', ''),
        '0009xx13': ('ST', '1', 'Sequence Type', ''),
        '0009xx14': ('ST', '1', 'Sequence Name', ''),
        '0009xx15': ('UL', '1', 'Avr RR Time Vector', ''),
        '0009xx16': ('UL', '1', 'Low Limit Vector', ''),
        '0009xx17': ('UL', '1', 'High Limit Vector', ''),
        '0009xx18': ('UL', '1', 'Begin Index Vector', ''),
        '0009xx19': ('UL', '1', 'End Index Vector', ''),
        '0009xx1A': ('UL', '1', 'Raw Time Vector', ''),
        '0009xx1B': ('LO', '1', 'Image Type String', ''),
        '0009xx1D': ('US', '1', 'Unknown', ''),
        '0009xx1E': ('ST', '1', 'Unknown', ''),
        '0009xx22': ('FL', '1', 'Unknown', ''),
        '0009xx23': ('US', '1', 'Unknown', ''),
        '0009xx39': ('UI', '1', 'Unknown', ''),
        '0009xx40': ('DA', '1', 'Unknown', ''),
        '0009xx41': ('TM', '1', 'Unknown', ''),
        '0009xx42': ('LO', '1', 'Unknown', ''),
        '0009xx44': ('SH', '1', 'Unknown', ''),
        '0037xx10': ('SQ', '1', 'Unknown', ''),
        '0037xx1B': ('LO', '1', 'Unknown', ''),
        '0037xx30': ('LO', '1', 'Unknown', ''),
        '0037xx40': ('LO', '1', 'Unknown', ''),
        '0037xx50': ('LO', '1', 'Unknown', ''),
        '0037xx60': ('LO', '1', 'Unknown', ''),
        '0037xx70': ('LO', '1', 'Unknown', ''),
    },
    'QVA': {
        '0009xx40': ('IS', '1', 'Calibration Frame', ''),
        '0009xx41': ('IS', '1', 'End Diastolic Frame', ''),
        '0009xx42': ('IS', '1', 'End Systolic Frame', ''),
        '0009xx43': ('DS', '1', 'End Diastolic Volume', ''),
        '0009xx44': ('DS', '1', 'End Systolic Volume', ''),
        '0009xx45': ('DS', '1', 'Stroke Volume', ''),
        '0009xx46': ('DS', '1', 'Cardiac Output', ''),
        '0009xx47': ('DS', '1', 'Ejection Fraction', ''),
        '0009xx48': ('DS', '1', 'Body Surface Area', ''),
        '0009xx49': ('SH', '1', 'Artery Territory Region', ''),
        '0009xx50': ('IS', '1', 'Number of Diseased Vessels', ''),
        '0009xx51': ('DS', '1', 'Hypokinesis in Region', ''),
        '0009xx52': ('DS', '1', 'Hyperkinesis in Region', ''),
        '0009xx53': ('IS', '1', 'percent of chords with hyperkinesis <- 2 SD', ''),
        '0009xx54': ('IS', '1', 'percent of chords with alkinesis/dyskinesis', ''),
        '0009xx55': ('DS', '1', 'Calibration Factor', ''),
    },
    'REPORT_FROM_APP': {
        '0039xx95': ('LO', '1', 'Unknown', ''),
    },
    'RadWorksMarconi': {
        '0029xx24': ('US', '1', '<internal', ''),
    },
    'RadWorksTBR': {
        '3111xx02': ('CS', '1', 'AMI Compression Type (RET)', ''),
        '3111xxFF': ('SQ', '1', '<internal', ''),
    },
    'SCHICK TECHNOLOGIES - Change Item Creator ID': {
        '0021xx01': ('UI', '1', 'Change List Item UID', ''),
        '0021xx02': ('US', '1', 'Operation', ''),
        '0021xx03': ('DT', '1', 'Date', ''),
        '0021xx04': ('PN', '1', 'User Name', ''),
        '0021xx05': ('OB', '1', 'Additional Change Data', ''),
    },
    'SCHICK TECHNOLOGIES - Change List Creator ID': {
        '0021xx01': ('UI', '1', 'Reference Image Instance UID', ''),
        '0021xx02': ('SQ', '1', 'Sequence', ''),
    },
    'SCHICK TECHNOLOGIES - Image Security Creator ID': {
        '0029xx01': ('UL', '1', 'Image Checksum', ''),
    },
    'SCHICK TECHNOLOGIES - Note Item Creator ID': {
        '0021xx01': ('ST', '1', 'Text', ''),
        '0021xx02': ('DT', '1', 'Date', ''),
        '0021xx03': ('PN', '1', 'User Name', ''),
        '0021xx04': ('US', '2', 'Coordinates (X, Y)', ''),
    },
    'SCHICK TECHNOLOGIES - Note List Creator ID': {
        '0021xx01': ('UI', '1', 'Reference Image Instance UID', ''),
        '0021xx02': ('SQ', '1', 'Item', ''),
    },
    'SCHICK TECHNOLOGIES - Viewset Creator ID': {
        '0009xx01': ('UI', '1', 'Instance UID', ''),
        '0009xx02': ('LO', '1', 'Name', ''),
        '0009xx03': ('SQ', '1', 'Sequence', ''),
        '0009xx04': ('UL', '1', 'Mode', ''),
        '0009xx05': ('UL', '1', 'Type', ''),
    },
    'SCHICK TECHNOLOGIES - Viewset Item Creator ID': {
        '0009xx01': ('UI', '1', 'Image Instance UID', ''),
        '0009xx02': ('US', '1', 'Number', ''),
        '0009xx03': ('US', '1', 'Order', ''),
        '0009xx04': ('US', '1', 'Type', ''),
        '0009xx05': ('US', '1', 'Orientation', ''),
        '0009xx06': ('US', '4', 'Rect (Left, Top, Width, Height)', ''),
        '0009xx07': ('US', '1', 'Caption Height', ''),
        '0009xx08': ('US', '1', 'Source', ''),
        '0009xx09': ('US', '1', 'Default Width', ''),
        '0009xx0A': ('US', '1', 'Default Height', ''),
    },
    'SECTRA_Ident_01': {
        '0009xx01': ('LO', '1', 'Request number', ''),
        '0009xx02': ('LO', '1', 'Examination number', ''),
        '0009xx04': ('LO', '1', 'Series ID', ''),
        '0009xx05': ('LO', '1', 'Series Order', ''),
        '0009xx06': ('LO', '1', 'File Name', ''),
        '0009xx07': ('LO', '1', 'Image Data ID', ''),
    },
    'SECTRA_ImageInfo_01': {
        '0029xx01': ('OB', '1', 'Image info', ''),
        '0029xx02': ('CS', '1', 'Marking', ''),
        '0029xx03': ('LO', '1', 'No Decompression', ''),
        '0029xx04': ('OB', '1', 'Image Info new', ''),
    },
    'SECTRA_OverlayInfo_01': {
        '6001xx01': ('LO', '1', 'Sectra Overlay', ''),
    },
    'SEGAMI MIML': {
        '0031xx98': ('OW', '1', '?Binary XML with PHI?', ''),
    },
    'SEGAMI__MEMO': {
        '0035xx97': ('SH', '1', 'Unknown', ''),
        '0035xx98': ('LT', '1', 'Unknown', ''),
    },
    'SET WINDOW': {
        '0019xx00': ('UN', '1', 'Set Window Image Filter', ''),
        '0019xx01': ('UN', '1', 'Set Window Magnification Power', ''),
    },
    'SHS MagicView 300': {
        '0029xx01': ('FD', '1-n', 'Zoom Factor', ''),
        '0029xx02': ('FD', '1', 'Pan Factor X', ''),
        '0029xx03': ('FD', '1', 'Pan Factor Y', ''),
        '0029xx04': ('LO', '1', 'NmPalette', ''),
    },
    'SIEMENS CM VA0  ACQU': {
        '0019xx10': ('LO', '1', 'Parameter File Name', ''),
        '0019xx11': ('LO', '1', 'Sequence File Name', ''),
        '0019xx12': ('LO', '1', 'Sequence File Owner', ''),
        '0019xx13': ('LO', '1', 'Sequence Description', ''),
        '0019xx14': ('LO', '1', 'EPI File Name', ''),
        '0019xx20': ('LO', '1', 'Mode File Name', ''),
        '0019xx30': ('LO', '1', 'Convolution Kernel Comment 1', ''),
        '0019xx31': ('LO', '1', 'Convolution Kernel Comment 2', ''),
        '0019xx32': ('LO', '1', 'Convolution Kernel Comment 3', ''),
        '0019xx33': ('LO', '1', 'Convolution Kernel Comment 4', ''),
        '0019xx34': ('LO', '1', 'Convolution Kernel Comment 5', ''),
        '0019xx35': ('LO', '1', 'Convolution Kernel Comment 6', ''),
        '0019xx36': ('LO', '1', 'Convolution Kernel Comment 7', ''),
        '0019xx37': ('LO', '1', 'Convolution Kernel Comment 8', ''),
        '0019xx38': ('LO', '1', 'Convolution Kernel Comment 9', ''),
        '0019xx39': ('LO', '1', 'Convolution Kernel Comment 10', ''),
        '0019xx3A': ('LO', '1', 'Reading Code RZ1 Comment 1', ''),
        '0019xx3B': ('LO', '1', 'Reading Code RZ1 Comment 2', ''),
        '0019xx3C': ('LO', '1', 'Reading Code RZ2 Comment 1', ''),
    },
    'SIEMENS CM VA0  CMS': {
        '0009xx00': ('IS', '1', 'Number of Measurements', ''),
        '0009xx10': ('CS', '1', 'Storage Mode', ''),
        '0009xx12': ('UL', '1', 'Evaluation Mask Image', ''),
        '0009xx26': ('DA', '1', 'Table Zero Date', ''),
        '0009xx27': ('TM', '1', 'Table Zero Time', ''),
        '0011xx0A': ('LO', '1', 'Unknown', ''),
        '0011xx10': ('DA', '1', 'Registration Date', ''),
        '0011xx11': ('TM', '1', 'Registration Time', ''),
        '0011xx22': ('LO', '1', 'Unknown', ''),
        '0011xx23': ('DS', '1', 'Used Patient Weight', ''),
        '0011xx40': ('IS', '1', 'Organ Code', ''),
        '0013xx00': ('PN', '1', 'Modifying Physician', ''),
        '0013xx10': ('DA', '1', 'Modification Date', ''),
        '0013xx12': ('TM', '1', 'Modification Time', ''),
        '0013xx20': ('PN', '1', 'Patient Name', ''),
        '0013xx22': ('LO', '1', 'Patient Id', ''),
        '0013xx30': ('DA', '1', 'Patient Birthdate', ''),
        '0013xx31': ('DS', '1', 'Patient Weight', ''),
        '0013xx32': ('PN', '1', 'Patient Maiden Name', ''),
        '0013xx33': ('PN', '1', 'Referring Physician', ''),
        '0013xx34': ('LO', '1', 'Admitting Diagnosis', ''),
        '0013xx35': ('CS', '1', 'Patient Sex', ''),
        '0013xx40': ('LO', '1', 'Procedure Description', ''),
        '0013xx42': ('CS', '1', 'Rest Direction', ''),
        '0013xx44': ('CS', '1', 'Patient Position', ''),
        '0013xx46': ('SH', '1', 'View Direction', ''),
        '0013xx50': ('LO', '1', 'Unknown', ''),
        '0013xx51': ('LO', '1', 'Unknown', ''),
        '0013xx52': ('LO', '1', 'Unknown', ''),
        '0013xx53': ('LO', '1', 'Unknown', ''),
        '0013xx54': ('LO', '1', 'Unknown', ''),
        '0013xx55': ('LO', '1', 'Unknown', ''),
        '0013xx56': ('LO', '1', 'Unknown', ''),
        '0019xx10': ('IS', '1', 'Net Frequency', ''),
        '0019xx20': ('CS', '1', 'Measurement Mode', ''),
        '0019xx30': ('CS', '1', 'Calculation Mode', ''),
        '0019xx50': ('IS', '1', 'Noise Level', ''),
        '0019xx60': ('IS', '1', 'Number of Data Bytes', ''),
        '0019xx70': ('DS', '1-n', 'Unknown', ''),
        '0019xx80': ('LO', '1', 'Unknown', ''),
        '0021xx20': ('DS', '1-n', 'Field of View', ''),
        '0021xx22': ('DS', '1', 'Image Magnification Factor', ''),
        '0021xx24': ('DS', '1-n', 'Image Scroll Offset', ''),
        '0021xx26': ('IS', '1', 'Image Pixel Offset', ''),
        '0021xx30': ('CS', '1', 'View Direction', ''),
        '0021xx32': ('CS', '1', 'Rest Direction', ''),
        '0021xx60': ('DS', '1-n', 'Image Position', ''),
        '0021xx61': ('DS', '1-n', 'Image Normal', ''),
        '0021xx63': ('DS', '1', 'Image Distance', ''),
        '0021xx65': ('US', '1', 'Image Positioning History Mask', ''),
        '0021xx6A': ('DS', '1-n', 'Image Row', ''),
        '0021xx6B': ('DS', '1-n', 'Image Column', ''),
        '0021xx70': ('CS', '1-n', 'Patient Orientation Set 1', ''),
        '0021xx71': ('CS', '1-n', 'Patient Orientation Set 2', ''),
        '0021xx80': ('LO', '1', 'Study Name', ''),
        '0021xx82': ('SH', '1', 'Study Type', ''),
        '0029xx10': ('CS', '1', 'Window Style', ''),
        '0029xx11': ('CS', '1', 'Window Look', ''),
        '0029xx12': ('UL', '1', 'Window Table Index', ''),
        '0029xx13': ('CS', '1', 'Window Scale', ''),
        '0029xx20': ('CS', '1-n', 'Pixel Quality Code', ''),
        '0029xx22': ('IS', '1-n', 'Pixel Quality Value', ''),
        '0029xx50': ('CS', '1', 'Archive Code', ''),
        '0029xx51': ('CS', '1', 'Exposure Code', ''),
        '0029xx52': ('IS', '1', 'Sort Code', ''),
        '0029xx53': ('CS', '1', 'Remote Copy Code', ''),
        '0029xx60': ('IS', '1', 'Splash', ''),
        '0051xx10': ('LO', '1-n', 'Image Text', ''),
        '6021xx00': ('CS', '1', 'Image Graphics Format Code', ''),
        '6021xx10': ('OB', '1', 'Image Graphics', ''),
        '7FE1xx00': ('OB', '1-n', 'Binary Data', ''),
    },
    'SIEMENS CM VA0  COAD': {
        '0019xx3D': ('LO', '1', 'Reading Code RZ2 Comment 2', ''),
    },
    'SIEMENS CM VA0  LAB': {
        '0009xx10': ('LO', '1', 'Generator Identification Label', ''),
        '0009xx11': ('LO', '1', 'Gantry Identification Label', ''),
        '0009xx12': ('LO', '1', 'XRay Tube Identification Label', ''),
        '0009xx13': ('LO', '1', 'Detector Identification Label', ''),
        '0009xx14': ('LO', '1', 'DAS Identification Label', ''),
        '0009xx15': ('LO', '1', 'SMI Identification Label', ''),
        '0009xx16': ('LO', '1', 'CPU Identification Label', ''),
        '0009xx20': ('SH', '1', 'Header Version', ''),
    },
    'SIEMENS CM VA0  OST': {
        '6023xx00': ('LO', '1', 'Osteo Contour Comment', ''),
        '6023xx10': ('SS', '1-n', 'Osteo Contour Buffer', ''),
    },
    'SIEMENS CSA ENVELOPE': {
        '0029xx10': ('OB', '1', 'syngo Report Data', ''),
        '0029xx11': ('OB', '1', 'syngo Report Presentation', ''),
    },
    'SIEMENS CSA HEADER': {
        '0029xx08': ('CS', '1', 'CSA Image Header Type', ''),
        '0029xx09': ('LO', '1', 'CSA Image Header Version', ''),
        '0029xx10': ('OB', '1', 'CSA Image Header Info', ''),
        '0029xx18': ('CS', '1', 'CSA Series Header Type', ''),
        '0029xx19': ('LO', '1', 'CSA Series Header Version', ''),
        '0029xx20': ('OB', '1', 'CSA Series Header Info', ''),
    },
    'SIEMENS CSA NON-IMAGE': {
        '0029xx08': ('CS', '1', 'CSA Data Type', ''),
        '0029xx09': ('LO', '1', 'CSA Data Version', ''),
        '0029xx10': ('OB', '1', 'CSA Data Info', ''),
        '7FE1xx10': ('OB', '1', 'CSA Data', ''),
    },
    'SIEMENS CSA REPORT': {
        '0029xx08': ('CS', '1', 'syngo Report Type', ''),
        '0029xx09': ('LO', '1', 'syngo Report', ''),
        '0029xx15': ('US', '1', 'SR Variant', ''),
        '0029xx17': ('UI', '1', 'SC SOP Instance UID', ''),
    },
    'SIEMENS CT VA0  COAD': {
        '0019xx10': ('IS', '1', 'Distance Source to SourceSide Collimator', ''),
        '0019xx11': ('IS', '1', 'Distance Source to DetectorSide Collimator', ''),
        '0019xx20': ('IS', '1', 'Number of Possible Channels', ''),
        '0019xx21': ('IS', '1', 'Mean Channel Number', ''),
        '0019xx22': ('DS', '1', 'Detector Spacing', ''),
        '0019xx23': ('DS', '1', 'Detector Center', ''),
        '0019xx24': ('DS', '1', 'Reading Integration Time', ''),
        '0019xx50': ('DS', '1', 'Detector Alignment', ''),
        '0019xx52': ('DS', '1', 'Table Feed', ''),
        '0019xx54': ('DS', '1', 'Rotation Time', ''),
        '0019xx60': ('DS', '1', 'Focus Alignment', ''),
        '0019xx65': ('UL', '1', 'Focal Spot Deflection Amplitude', ''),
        '0019xx66': ('UL', '1', 'Focal Spot Deflection Phase', ''),
        '0019xx67': ('UL', '1', 'Focal Spot Deflection Offset', ''),
        '0019xx70': ('DS', '1', 'Water Scaling Factor', ''),
        '0019xx71': ('DS', '1', 'Interpolation Factor', ''),
        '0019xx80': ('CS', '1', 'Patient Region', ''),
        '0019xx82': ('CS', '1', 'Patient Phase of Life', ''),
        '0019xx90': ('DS', '1', 'Osteo Offset', ''),
        '0019xx92': ('DS', '1', 'Osteo Regression Line Slope', ''),
        '0019xx93': ('DS', '1', 'Osteo Regression Line Intercept', ''),
        '0019xx94': ('IS', '1', 'Osteo Standardization Code', ''),
        '0019xx96': ('IS', '1', 'Osteo Phantom Number', ''),
        '0019xxA0': ('DS', '1', 'Spiral Location Begin', ''),
        '0019xxA1': ('DS', '1', 'Spiral Location End', ''),
        '0019xxA2': ('CS', '1', 'Spiral z Profile', ''),
        '0019xxA3': ('CS', '1', 'Spiral Reconstruction Direction', ''),
        '0019xxA4': ('DS', '1', 'Spiral Reconstruction Increment', ''),
        '0019xxA5': ('DS', '1', 'Scan Tilt Plane Distance', ''),
        '0019xxA6': ('UL', '1-n', 'Mode Processing Step Mask', ''),
        '0019xxA7': ('UL', '1', 'Mode Processing Control Mask', ''),
        '0019xxA8': ('UL', '1-n', 'Mode Master Mask', ''),
        '0019xxA9': ('IS', '1', 'Mode Store Step', ''),
        '0019xxAA': ('CS', '1', 'Focus Size Type', ''),
        '0019xxAB': ('IS', '1', 'Mode Adaptive Filter Kind', ''),
        '0019xxAC': ('IS', '1', 'Mode MBH Kind', ''),
        '0019xxAD': ('IS', '1', 'Mode Balancing Kind', ''),
        '0019xxAE': ('IS', '1', 'Number of Readings per Rotation', ''),
        '0019xxAF': ('DS', '1', 'Correction Table Reference Time', ''),
        '0019xxB0': ('DS', '1', 'Feed per Rotation', ''),
        '0019xxB1': ('UN', '1', 'Unknown', ''),
        '0019xxBD': ('IS', '1', 'Pulmo Trigger Level', ''),
        '0019xxBE': ('DS', '1', 'Expiratoric Reserve', ''),
        '0019xxBF': ('DS', '1', 'Vital Capacity', ''),
        '0019xxC0': ('DS', '1', 'Pulmo Water', ''),
        '0019xxC1': ('DS', '1', 'Pulmo Air', ''),
        '0019xxC2': ('DA', '1', 'Pulmo Date', ''),
        '0019xxC3': ('TM', '1', 'Pulmo Time', ''),
        '0019xxC4': ('UL', '1', 'Unknown', ''),
        '0019xxC5': ('IS', '1', 'Unknown', ''),
    },
    'SIEMENS CT VA0  GEN': {
        '0019xx10': ('DS', '1', 'Source Side Collimator Aperture', ''),
        '0019xx11': ('DS', '1', 'Detector Side Collimator Aperture', ''),
        '0019xx20': ('IS', '1', 'Exposure Time current', ''),
        '0019xx21': ('IS', '1', 'Exposure current', ''),
        '0019xx25': ('DS', '1', 'Generator Power current', ''),
        '0019xx26': ('DS', '1', 'Generator Voltage current', ''),
        '0019xx40': ('UL', '1', 'Master Control Mask', ''),
        '0019xx42': ('US', '1-n', 'Processing Mask', ''),
        '0019xx44': ('UL', '1-n', 'IRS Data Number', ''),
        '0019xx45': ('UL', '1-n', 'IRS Data Length', ''),
        '0019xx62': ('IS', '1', 'Number of Virtual Channels', ''),
        '0019xx70': ('IS', '1', 'Number of Reading', ''),
        '0019xx71': ('CS', '1', 'Reading Code', ''),
        '0019xx74': ('IS', '1', 'Number of Projections', ''),
        '0019xx75': ('IS', '1', 'Number of Bytes', ''),
        '0019xx80': ('IS', '1-n', 'Reconstruction Algorithm Set', ''),
        '0019xx81': ('IS', '1', 'Reconstruction Algorithm Index', ''),
        '0019xx82': ('LO', '1', 'Regeneration Software Version', ''),
        '0019xx84': ('IS', '1', 'Multiscan Reconstruction Increment', ''),
        '0019xx85': ('IS', '1', 'Multiscan Reconstruction Width', ''),
        '0019xx88': ('IS', '1', 'Range Number', ''),
        '0021xx10': ('IS', '1', 'Rotation Angle', ''),
        '0021xx11': ('IS', '1', 'Start Angle', ''),
        '0021xx20': ('IS', '1', 'Scan', ''),
        '0021xx30': ('IS', '1', 'Tube Position', ''),
        '0021xx32': ('DS', '1', 'Length of Topogram', ''),
        '0021xx34': ('DS', '1', 'Correction Factor', ''),
        '0021xx36': ('DS', '1', 'Maximum Table Position', ''),
        '0021xx40': ('IS', '1', 'Table Move Direction Code', ''),
        '0021xx45': ('IS', '1', 'VOI Start Row', ''),
        '0021xx46': ('IS', '1', 'VOI Stop Row', ''),
        '0021xx47': ('IS', '1', 'VOI Start Column', ''),
        '0021xx48': ('IS', '1', 'VOI Stop Column', ''),
        '0021xx49': ('IS', '1', 'VOI Start Slice', ''),
        '0021xx4A': ('IS', '1', 'VOI Stop Slice', ''),
        '0021xx50': ('IS', '1', 'Vector Start Row', ''),
        '0021xx51': ('IS', '1', 'Vector Row Step', ''),
        '0021xx52': ('IS', '1', 'Vector Start Column', ''),
        '0021xx53': ('IS', '1', 'Vector Column Step', ''),
        '0021xx60': ('IS', '1', 'Range Type Code', ''),
        '0021xx62': ('IS', '1', 'Reference Type Code', ''),
        '0021xx70': ('DS', '1-n', 'Object Orientation', ''),
        '0021xx72': ('DS', '1-n', 'Light Orientation', ''),
        '0021xx75': ('DS', '1', 'Light Brightness', ''),
        '0021xx76': ('DS', '1', 'Light Contrast', ''),
        '0021xx7A': ('IS', '1-n', 'Overlay Threshold', ''),
        '0021xx7B': ('IS', '1-n', 'Surface Threshold', ''),
        '0021xx7C': ('IS', '1-n', 'Grey Scale Threshold', ''),
        '0021xxA0': ('IS', '1-n', 'Field of Interest', ''),
        '0021xxA1': ('CS', '1', 'Image Filter Label', ''),
        '0021xxA2': ('CS', '1', 'Exemplary Element 1', ''),
        '0021xxA3': ('IS', '1-n', 'Exemplary Element 2', ''),
        '0021xxA4': ('LO', '1', 'Exemplary Element 3', ''),
        '0021xxA5': ('IS', '1', 'Reference Data Set 1', ''),
        '0021xxA6': ('IS', '1', 'Reference Data Set 2', ''),
        '0021xxA7': ('LO', '1', 'Window Program Name', ''),
    },
    'SIEMENS CT VA0  IDE': {
        '0009xx10': ('LO', '1', 'SOMATOM Software Name', ''),
        '0009xx30': ('CS', '1', 'Data Set Subtype 1', ''),
        '0009xx31': ('SH', '1', 'Data Set Subtype 2', ''),
        '0009xx32': ('SH', '1', 'Data Set Subtype 3', ''),
        '0009xx33': ('SH', '1', 'Data Set Subtype 4', ''),
        '0009xx34': ('SH', '1', 'Data Set Subtype 5', ''),
        '0009xx40': ('LO', '1', 'Directory Text', ''),
        '0009xx42': ('LO', '1', 'Exposure Time Text', ''),
        '0009xx50': ('DA', '1', 'Scan Date', ''),
        '0009xx51': ('TM', '1', 'Scan Time', ''),
    },
    'SIEMENS CT VA0  ORI': {
        '0009xx20': ('LO', '1', 'Original Data Set Owner', ''),
        '0009xx30': ('SH', '1', 'Original Modality', ''),
    },
    'SIEMENS CT VA0  ORMR': {
        '0021xx80': ('DS', '1', 'Repetition Time', ''),
        '0021xx81': ('DS', '1', 'Echo Time', ''),
        '0021xx82': ('DS', '1', 'Inversion Time', ''),
        '0021xx83': ('IS', '1', 'Number of Averages', ''),
        '0021xx84': ('DS', '1', 'Imaging Frequency', ''),
        '0021xx85': ('LO', '1', 'Imaged Nucleus', ''),
        '0021xx86': ('IS', '1', 'Echo Number', ''),
        '0021xx90': ('DS', '1', 'Flip Angle', ''),
    },
    'SIEMENS CT VA0  OST': {
        '6021xx00': ('LO', '1', 'Osteo Contour Comment', ''),
        '6021xx10': ('US', '256', 'Osteo Contour Buffer', ''),
    },
    'SIEMENS CT VA0  RAW': {
        '0021xx10': ('UL', '1-n', 'Creation Mask service', ''),
        '0021xx20': ('UL', '1-n', 'Evaluation Mask service', ''),
        '0021xx30': ('US', '1-n', 'Extended Processing Mask', ''),
        '0021xx40': ('UL', '1-n', 'Manipulation Mask', ''),
        '0021xx41': ('UL', '1-n', 'Composition Mask', ''),
        '0021xx42': ('UL', '1-n', 'Alteration Mask', ''),
        '0021xx43': ('UL', '1-n', 'Generation Mask', ''),
        '0021xx44': ('UL', '1-n', 'Function Mask', ''),
        '0021xx50': ('CS', '1', 'Mode Mirroring Code', ''),
    },
    'SIEMENS DFR.01': {
        '0021xx10': ('US', '1', 'Graphic Evaluation Mask', ''),
        '0021xx11': ('US', '1', 'Type 1st Graphic Element', ''),
        '0021xx12': ('LO', '1', 'Description 1st Graphic Element', ''),
        '0021xx13': ('US', '1', 'Type 2nd Graphic Element', ''),
        '0021xx14': ('LO', '1', 'Description 2nd Graphic Element', ''),
        '0021xx15': ('US', '1', 'Type 3rd Graphic Element', ''),
        '0021xx16': ('LO', '1', 'Description 3rd Graphic Element', ''),
        '0021xx17': ('US', '1', 'Type 4th Graphic Element', ''),
        '0021xx18': ('LO', '1', 'Description 4th Graphic Element', ''),
        '0021xx19': ('US', '1', 'Type 5th Graphic Element', ''),
        '0021xx20': ('LO', '1', 'Description 5th Graphic Element', ''),
        '0021xx21': ('US', '1', 'Type 6th Graphic Element', ''),
        '0021xx22': ('LO', '1', 'Description 6th Graphic Element', ''),
        '0021xx23': ('US', '1', 'Type 7th Graphic Element', ''),
        '0021xx24': ('LO', '1', 'Description 7th Graphic Element', ''),
        '0021xx25': ('US', '1', 'Type 8th Graphic Element', ''),
        '0021xx26': ('LO', '1', 'Description 8th Graphic Element', ''),
        '0021xx27': ('US', '1', 'Type 9th Graphic Element', ''),
        '0021xx28': ('LO', '1', 'Description 9th Graphic Element', ''),
        '0021xx29': ('US', '1', 'Type 10th Graphic Element', ''),
        '0021xx30': ('LO', '1', 'Description 10th Graphic Element', ''),
    },
    'SIEMENS DFR.01 MANIPULATED': {
        '0017xx11': ('US', '1', 'Window Width Native Current', ''),
        '0017xx12': ('US', '1', 'Window Center Native', ''),
        '0017xx14': ('US', '1', 'Window Width Subtraction Current', ''),
        '0017xx15': ('US', '1', 'Window Center Subtraction Current', ''),
        '0017xx25': ('DS', '1', 'Edge Enhancement Native Current', ''),
        '0017xx27': ('DS', '1', 'Edge Enhancement Subtraction Current', ''),
        '0017xx29': ('IS', '1', 'Edge Enhancement %', ''),
        '0017xx30': ('IS', '1', 'Harmonization %', ''),
        '0017xx31': ('US', '1', 'DSA Representation Current', ''),
        '0017xx32': ('US', '1', 'Number of Mask Current', ''),
        '0017xx33': ('US', '1', 'RightLeft Mark Current', ''),
        '0017xx35': ('US', '1', 'Number of Series Representative', ''),
        '0017xx37': ('US', '1', 'Rectangle Shutter Horizontal Current', ''),
        '0017xx38': ('US', '1', 'Rectangle Shutter Vertical Aktuell', ''),
        '0017xx71': ('LO', '1', 'Landmark Current', ''),
        '0017xx72': ('US', '1', 'Zoom Factor', ''),
        '0017xx73': ('US', '1', 'Roam Horizontal', ''),
        '0017xx74': ('US', '1', 'Roam Vertical', ''),
        '0017xx77': ('IS', '1', 'Pixel Shift Horizontal', ''),
        '0017xx78': ('IS', '1', 'Pixel Shift Vertical', ''),
        '0017xx79': ('US', '1', 'Image Flip', ''),
        '0017xx7A': ('US', '1', 'Invers Current', ''),
        '0017xx80': ('US', '1', 'Unknown', ''),
        '0017xx83': ('SH', '1', 'Documentation Flag', ''),
        '0017xx84': ('LO', '1', 'Right Marker', ''),
        '0017xx91': ('US', '1', 'Summation Count Filling', ''),
        '0017xx92': ('US', '1', 'Summation Count Mask', ''),
        '0017xx93': ('US', '1', 'PeakOp Start', ''),
        '0017xx94': ('US', '1', 'PeakOp End', ''),
        '0017xxA0': ('IS', '1', 'Cine Rate', ''),
        '0017xxA1': ('LO', '1', 'Image Name', ''),
        '0017xxA2': ('LO', '1', 'Image Name Extension 1', ''),
        '0017xxA3': ('LO', '1', 'Image Name Extension 2', ''),
    },
    'SIEMENS DFR.01 ORIGINAL': {
        '0017xx10': ('CS', '1', 'Image Type', ''),
        '0017xx11': ('US', '1', 'Window Width Native Original', ''),
        '0017xx12': ('US', '1', 'Window Center Native', ''),
        '0017xx14': ('US', '1', 'Window Width Subtraction Original', ''),
        '0017xx15': ('US', '1', 'Window Center Subtraction Original', ''),
        '0017xx16': ('US', '1', 'LUT Number for Autowindow', ''),
        '0017xx18': ('US', '1', 'Unknown', ''),
        '0017xx21': ('US', '1', 'Edge Enhancement Kernelsize Original', ''),
        '0017xx22': ('US', '1', 'Edge Enhancement Mode Original', ''),
        '0017xx23': ('US', '1-n', 'Edge Enhancement LUTs Original', ''),
        '0017xx24': ('US', '1', 'Filter Type Native Original', ''),
        '0017xx25': ('DS', '1', 'Edge Enhancement Native Original', ''),
        '0017xx26': ('US', '1', 'Filter Type Subtraction Original', ''),
        '0017xx27': ('DS', '1', 'Edge Enhancement Subtraction Original', ''),
        '0017xx2A': ('US', '1', 'Unknown', ''),
        '0017xx30': ('IS', '1', 'Unknown', ''),
        '0017xx31': ('US', '1', 'DSA Representation Original', ''),
        '0017xx32': ('US', '1', 'Number of Maske Original', ''),
        '0017xx33': ('US', '1', 'RightLeft Mark Original', ''),
        '0017xx34': ('DS', '1', 'Slice Position', ''),
        '0017xx37': ('US', '1', 'Rectangle Shutter Horizontal Original', ''),
        '0017xx38': ('US', '1', 'Rectangle Vertical Original', ''),
        '0017xx41': ('DS', '1', 'Dose', ''),
        '0017xx42': ('DS', '1', 'Dose Area Product', ''),
        '0017xx43': ('US', '1', 'Focus', ''),
        '0017xx44': ('US', '1', 'SDM', ''),
        '0017xx45': ('DS', '1', 'Image Intensifer Format', ''),
        '0017xx46': ('DS', '1', 'Density Correction', ''),
        '0017xx47': ('LO', '1', 'Exposure Curves', ''),
        '0017xx48': ('IS', '1', 'Unknown', ''),
        '0017xx49': ('LO', '1', 'Organ Program Name', ''),
        '0017xx4A': ('IS', '1', 'Count of Images in Series', ''),
        '0017xx51': ('US', '1', 'Image Intensifier Zoom', ''),
        '0017xx52': ('UL', '1', 'ROSA Receiver ErrCount', ''),
        '0017xx61': ('US', '1', 'Table Position Peri', ''),
        '0017xx62': ('US', '1-n', 'Series Numbers of Petri', ''),
        '0017xx71': ('LO', '1', 'Landmark Original', ''),
        '0017xx72': ('US', '1', 'Unknown', ''),
        '0017xx73': ('US', '1', 'Unknown', ''),
        '0017xx74': ('US', '1', 'Unknown', ''),
        '0017xx79': ('US', '1', 'Unknown', ''),
        '0017xx7A': ('US', '1', 'Invers Original', ''),
        '0017xx7B': ('IS', '1', 'Unknown', ''),
        '0017xxA0': ('IS', '1', 'Unknown', ''),
        '0017xxB1': ('CS', '1', 'L2 Image', ''),
        '0017xxB2': ('IS', '1', 'L2 Acquisition Monitor', ''),
        '0017xxC1': ('LO', '1', 'Folder UID', ''),
        '0017xxC2': ('LO', '1', 'Series UID', ''),
        '0017xxC3': ('LO', '1', 'Subseries UID', ''),
    },
    'SIEMENS DFR.01 SERVICE': {
        '0021xx10': ('US', '1', '1 Plot', ''),
        '0021xx11': ('US', '1', 'Width 1 Plot', ''),
        '0021xx12': ('US', '1', '2 Plot', ''),
        '0021xx13': ('US', '1', 'Width 2 Plot', ''),
        '0021xx20': ('US', '1-5', 'xCoordinate Region of Interest', ''),
        '0021xx21': ('US', '1-5', 'yCoordinate Region of Interest', ''),
        '0021xx22': ('US', '1-5', 'Width Region of Interest', ''),
        '0021xx23': ('US', '1-5', 'Height Region of Interest', ''),
    },
    'SIEMENS DICOM': {
        '0009xx10': ('UN', '1', 'Unknown', ''),
        '0009xx12': ('LO', '1', 'Unknown', ''),
    },
    'SIEMENS DLR.01': {
        '0019xx10': ('LO', '1', 'Measurement Mode', ''),
        '0019xx11': ('LO', '1', 'Image Type', ''),
        '0019xx15': ('LO', '1', 'Software Version', ''),
        '0019xx20': ('LO', '1', 'MPM Code', ''),
        '0019xx21': ('LO', '1', 'Latitude', ''),
        '0019xx22': ('LO', '1', 'Sensitivity', ''),
        '0019xx23': ('LO', '1', 'EDR', ''),
        '0019xx24': ('LO', '1', 'l fix', ''),
        '0019xx25': ('LO', '1', 's fix', ''),
        '0019xx26': ('LO', '1', 'Preset Mode', ''),
        '0019xx27': ('LO', '1', 'Region', ''),
        '0019xx28': ('LO', '1', 'Subregion', ''),
        '0019xx30': ('LO', '1', 'Orientation', ''),
        '0019xx31': ('LO', '1', 'Mark on Film', ''),
        '0019xx32': ('LO', '1', 'Rotation on DRC', ''),
        '0019xx40': ('LO', '1', 'Reader Type', ''),
        '0019xx41': ('LO', '1', 'Sub Modality', ''),
        '0019xx42': ('LO', '1', 'Reader Serial Number', ''),
        '0019xx50': ('LO', '1', 'Cassette Scale', ''),
        '0019xx51': ('LO', '1', 'Cassette Matrix', ''),
        '0019xx52': ('LO', '1', 'Cassette Submatrix', ''),
        '0019xx53': ('LO', '1', 'Barcode', ''),
        '0019xx60': ('LO', '1', 'GT Contrast Type', ''),
        '0019xx61': ('LO', '1', 'GA Rotation Amount', ''),
        '0019xx62': ('LO', '1', 'GC Rotation Center', ''),
        '0019xx63': ('LO', '1', 'GS Density Shift', ''),
        '0019xx64': ('US', '1', 'RN Frequency Rank', ''),
        '0019xx65': ('LO', '1', 'RE Frequency Enhancement', ''),
        '0019xx66': ('LO', '1', 'RT Frequency Type', ''),
        '0019xx67': ('LO', '1', 'Kernel Length', ''),
        '0019xx68': ('UL', '1', 'Kernel Mode', ''),
        '0019xx69': ('UL', '1', 'Convulsion Mode', ''),
        '0019xx70': ('LO', '1', 'PLA Source', ''),
        '0019xx71': ('LO', '1', 'PLA Destination', ''),
        '0019xx75': ('LO', '1', 'UID Original Image', ''),
        '0019xx76': ('LO', '1', 'Filterset', ''),
        '0019xx80': ('LO', '1', 'Reader Header', ''),
        '0019xx90': ('LO', '1', 'PLA of Secondary Destination', ''),
        '0019xxA0': ('DS', '1', 'Unknown', ''),
        '0019xxA1': ('DS', '1', 'Unknown', ''),
        '0041xx10': ('US', '1', 'Number of Hardcopies', ''),
        '0041xx20': ('CS', '1', 'Film Format', ''),
        '0041xx30': ('LO', '1', 'Film Size', ''),
        '0041xx31': ('LO', '1', 'Full Film Format', ''),
    },
    'SIEMENS ISI': {
        '0003xx08': ('US', '1', 'ISI Command Field', ''),
        '0003xx11': ('US', '1', 'Attach ID Application Code', ''),
        '0003xx12': ('UL', '1', 'Attach ID Message Count', ''),
        '0003xx13': ('DA', '1', 'Attach ID Date', ''),
        '0003xx14': ('TM', '1', 'Attach ID Time', ''),
        '0003xx20': ('US', '1', 'Message Type', ''),
        '0003xx30': ('DA', '1', 'Max Waiting Date', ''),
        '0003xx31': ('TM', '1', 'Max Waiting Time', ''),
        '0009xx01': ('UN', '1', 'RIS Patient Info IMGEF', ''),
        '0009xx14': ('SQ', '1', 'RIS Patient Info IMGEF', ''),
        '0011xx03': ('LO', '1', 'Patient UID', ''),
        '0011xx04': ('LO', '1', 'Patient ID', ''),
        '0011xx0A': ('LO', '1', 'Case ID', ''),
        '0011xx22': ('LO', '1', 'Request ID', ''),
        '0011xx23': ('LO', '1', 'Examination UID', ''),
        '0011xx41': ('LO', '1', 'Medical Alerts', ''),
        '0011xx42': ('LO', '1', 'Contrast Allergy', ''),
        '0011xxA1': ('DA', '1', 'Patient Registration Date', ''),
        '0011xxA2': ('TM', '1', 'Patient Registration Time', ''),
        '0011xxB0': ('LO', '1', 'Patient Last Name', ''),
        '0011xxB2': ('LO', '1', 'Patient First Name', ''),
        '0011xxB4': ('CS', '1', 'Patient Hospital Status', ''),
        '0011xxBC': ('LO', '1', 'Current Location Time', ''),
        '0011xxC0': ('CS', '1', 'Patient Insurance Status', ''),
        '0011xxD0': ('LO', '1', 'Patient Billing Type', ''),
        '0011xxD2': ('LO', '1', 'Patient Billing Address', ''),
        '0031xx12': ('LO', '1', 'Examination Reason', ''),
        '0031xx30': ('DA', '1', 'Requested Date', ''),
        '0031xx32': ('TM', '1', 'Worklist Request Start Time', ''),
        '0031xx33': ('TM', '1', 'Worklist Request End Time', ''),
        '0031xx4A': ('TM', '1', 'Requested Time', ''),
        '0031xx80': ('LO', '1', 'Requested Location', ''),
        '0055xx46': ('PN', '1', 'Current Ward', ''),
        '0193xx02': ('LO', '1', 'RIS Key', ''),
        '0307xx01': ('SQ', '1', 'RIS Worklist IMGEF', ''),
        '0309xx01': ('SQ', '1', 'RIS Report IMGEF', ''),
        '4009xx01': ('LO', '1', 'Report ID', ''),
        '4009xx20': ('CS', '1', 'Report Status', ''),
        '4009xx30': ('DA', '1', 'Report Creation Date', ''),
        '4009xx70': ('PN', '1', 'Report Approving Physician', ''),
        '4009xxE0': ('LO', '1', 'Report Text', ''),
        '4009xxE1': ('LO', '1', 'Report Author', ''),
        '4009xxE2': ('PN', '1', 'Report Transcriber', ''),
        '4009xxE3': ('PN', '1', 'Reporting Radiologist', ''),
    },
    'SIEMENS MED': {
        '0009xx10': ('LO', '1', 'Recognition Code', ''),
        '0009xx30': ('US', '1', 'Byte Offset of Original Header', ''),
        '0009xx31': ('US', '1', 'Length of Original Header', ''),
        '0009xx40': ('US', '1', 'Byte Offset of Pixel Matrix', ''),
        '0009xx41': ('UL', '1', 'Length of Pixel Matrix', ''),
        '0009xx50': ('LO', '1', 'Unknown', ''),
        '0009xx51': ('LO', '1', 'Unknown', ''),
        '0009xx80': ('ST', '1', '', ''),
        '0009xxF5': ('LO', '1', 'PDM EFID Placeholder', ''),
        '0009xxF6': ('LO', '1', 'PDM Data Object Type Extension', ''),
        '0011xx10': ('ST', '1', '', ''),
        '0017xx00': ('ST', '1', '', ''),
        '0017xx20': ('ST', '1', '', ''),
        '0017xx60': ('LO', '1', '', ''),
        '0017xx80': ('ST', '1', '', ''),
        '0019xx01': ('SS', '1', '', ''),
        '0019xx02': ('SS', '1', '', ''),
        '0019xx03': ('SS', '1', '', ''),
        '0019xx04': ('ST', '1', '', ''),
        '0019xx05': ('ST', '1', '', ''),
        '0019xx06': ('SL', '1', '', ''),
        '0019xx07': ('SL', '1', '', ''),
        '0019xx08': ('SS', '1', '', ''),
        '0019xx09': ('SS', '1', '', ''),
        '0019xx0A': ('ST', '1', '', ''),
        '0019xx0B': ('ST', '1', '', ''),
        '0019xx0C': ('SS', '1', '', ''),
        '0019xx0D': ('ST', '1', '', ''),
        '0019xx0E': ('ST', '1', '', ''),
        '0019xx0F': ('SL', '1', '', ''),
        '0019xx11': ('ST', '1', '', ''),
        '0019xx12': ('ST', '1', '', ''),
        '0019xx13': ('SS', '1', '', ''),
        '0019xx14': ('SS', '1', '', ''),
        '0019xx15': ('SS', '1', '', ''),
        '0019xx16': ('SS', '1', '', ''),
        '0019xx17': ('SS', '1', '', ''),
        '0019xx18': ('SS', '1', '', ''),
        '0019xx19': ('SS', '1', '', ''),
        '0019xx1A': ('SS', '1', '', ''),
        '0019xx1B': ('SS', '1', '', ''),
        '0019xx1C': ('SS', '1', '', ''),
        '0019xx1D': ('SS', '1', '', ''),
        '0019xx20': ('SL', '1', '', ''),
        '0019xx21': ('SL', '1', '', ''),
        '0019xx22': ('SL', '1', '', ''),
        '0019xx23': ('SS', '1', '', ''),
        '0019xx24': ('SL', '1', '', ''),
        '0019xx25': ('SL', '1', '', ''),
        '0019xx26': ('SL', '1', '', ''),
        '0019xx27': ('SL', '1', '', ''),
        '0019xx30': ('SL', '1', '', ''),
        '0019xx31': ('SL', '1', '', ''),
        '0019xx32': ('SL', '1', '', ''),
        '0019xx41': ('SS', '1', '', ''),
        '0019xx42': ('SS', '1', '', ''),
        '0019xx43': ('SS', '1', '', ''),
        '0019xx44': ('SS', '1', '', ''),
        '0019xx45': ('SL', '1', '', ''),
        '0019xx47': ('SL', '1', '', ''),
        '0019xx48': ('ST', '1', '', ''),
        '0019xx49': ('SL', '1', '', ''),
        '0019xx4A': ('SS', '1', '', ''),
        '0019xx4B': ('SS', '1', '', ''),
        '0019xx4C': ('SL', '1', '', ''),
        '0019xx4E': ('SS', '1', '', ''),
        '0019xx4F': ('SS', '1', '', ''),
        '0019xx50': ('SS', '1', '', ''),
        '0019xx51': ('SS', '1', '', ''),
        '0019xx52': ('SS', '1', '', ''),
        '0019xx53': ('SS', '1', '', ''),
        '0019xx54': ('ST', '1', '', ''),
        '0019xx55': ('SS', '1', '', ''),
        '0019xx56': ('SS', '1', '', ''),
        '0019xx57': ('SS', '1', '', ''),
        '0019xx58': ('SS', '1', '', ''),
        '0019xx59': ('SS', '1', '', ''),
        '0019xx5A': ('ST', '1', '', ''),
        '0019xx5B': ('SS', '1', '', ''),
        '0019xx5C': ('SS', '1', '', ''),
        '0019xx5D': ('SS', '1', '', ''),
        '0019xx5E': ('SS', '1', '', ''),
        '0019xx5F': ('SS', '1', '', ''),
        '0019xx60': ('SS', '1', '', ''),
        '0019xx61': ('SS', '1', '', ''),
        '0019xx62': ('SS', '1', '', ''),
        '0019xx63': ('SS', '1', '', ''),
        '0019xx64': ('SS', '1', '', ''),
        '0019xx65': ('SS', '1', '', ''),
        '0019xx66': ('SS', '1', '', ''),
        '0019xx67': ('SS', '1', '', ''),
        '0019xx68': ('SL', '1', '', ''),
        '0019xx69': ('SS', '1', '', ''),
        '0019xx6A': ('SS', '1', '', ''),
        '0019xx6B': ('SL', '1', '', ''),
        '0019xx6C': ('SL', '1', '', ''),
        '0019xx6D': ('SS', '1', '', ''),
        '0019xx6E': ('SS', '1', '', ''),
        '0019xx6F': ('SS', '1', '', ''),
        '0019xx70': ('ST', '1', '', ''),
        '0019xx71': ('ST', '1', '', ''),
        '0019xx72': ('SL', '1', '', ''),
        '0019xx73': ('SL', '1', '', ''),
        '0019xx74': ('SS', '1', '', ''),
        '0019xx75': ('SS', '1', '', ''),
        '0019xx76': ('SS', '1', '', ''),
        '0019xx77': ('SS', '1', '', ''),
        '0019xx78': ('SS', '1', '', ''),
        '0019xx7F': ('SS', '1', '', ''),
        '0019xx80': ('SS', '1', '', ''),
        '0019xx81': ('SS', '1', '', ''),
        '0019xx82': ('SL', '1', '', ''),
        '0019xx83': ('SS', '1', '', ''),
        '0019xx84': ('SS', '1', '', ''),
        '0019xx85': ('SS', '1', '', ''),
        '0019xx86': ('SS', '1', '', ''),
        '0019xx87': ('SS', '1', '', ''),
        '0019xx88': ('SL', '1', '', ''),
        '0019xx89': ('SS', '1', '', ''),
        '0019xx8A': ('SL', '1', '', ''),
        '0019xx8D': ('SL', '1', '', ''),
        '0019xx8E': ('SL', '1', '', ''),
        '0019xx91': ('SL', '1', '', ''),
        '0019xx92': ('SL', '1', '', ''),
        '0019xx93': ('SL', '1', '', ''),
        '0019xx94': ('SS', '1', '', ''),
        '0019xx95': ('SS', '1', '', ''),
        '0019xx96': ('SL', '1', '', ''),
        '0019xx97': ('SS', '1', '', ''),
        '0019xxA0': ('SS', '1', '', ''),
        '0019xxA1': ('SS', '1', '', ''),
        '0019xxA2': ('SL', '1', '', ''),
        '0019xxA3': ('SL', '1', '', ''),
        '0019xxA4': ('SL', '1', '', ''),
        '0019xxC0': ('SL', '1', '', ''),
        '0019xxC1': ('SS', '1', '', ''),
        '0019xxC2': ('SS', '1', '', ''),
        '0019xxF0': ('SL', '1', '', ''),
        '001Fxx00': ('LO', '1', '', ''),
        '001Fxx02': ('LO', '1', '', ''),
        '001Fxx50': ('LO', '1', '', ''),
        '001Fxx70': ('LO', '1', '', ''),
        '0021xx10': ('DS', '1', 'Zoom', ''),
        '0021xx11': ('DS', '1-n', 'Target', ''),
        '0021xx12': ('IS', '1', 'Tube Angle During Topogram', ''),
        '0021xx20': ('US', '1', 'ROI Mask', ''),
        '0031xx01': ('ST', '1', '', ''),
        '0031xx03': ('SL', '1', '', ''),
        '0031xx04': ('ST', '1', '', ''),
        '0031xx05': ('SS', '1', '', ''),
        '0031xx06': ('SL', '1', '', ''),
        '0031xx07': ('SS', '1', '', ''),
        '0031xx08': ('ST', '1', '', ''),
        '0031xx09': ('SS', '1', '', ''),
        '0031xx0A': ('SS', '1', '', ''),
        '0031xx0B': ('SS', '1', '', ''),
        '0031xx0C': ('SS', '1', '', ''),
        '0031xx0D': ('SS', '1', '', ''),
        '0031xx0E': ('SS', '1', '', ''),
        '0031xx0F': ('SL', '1', '', ''),
        '0031xx10': ('SL', '1', '', ''),
        '0031xx11': ('SS', '1', '', ''),
        '0041xx12': ('SL', '1', '', ''),
        '0041xx13': ('SL', '1', '', ''),
        '0041xx21': ('ST', '1', '', ''),
        '0041xx30': ('ST', '1', '', ''),
        '0041xx32': ('ST', '1', '', ''),
        '0041xx34': ('ST', '1', '', ''),
        '0041xx36': ('ST', '1', '', ''),
        '0041xx40': ('ST', '1', '', ''),
        '0041xx50': ('SS', '1', '', ''),
        '0041xx52': ('SS', '1', '', ''),
        '0041xx60': ('ST', '1', '', ''),
        '0041xx70': ('SL', '1', '', ''),
        '0041xx71': ('SL', '1', '', ''),
        '0051xx10': ('SS', '1', '', ''),
        '0051xx11': ('SS', '1', '', ''),
        '0051xx12': ('SS', '1', '', ''),
        '0051xx13': ('SS', '1', '', ''),
        '0051xx14': ('SS', '1', '', ''),
        '0051xx15': ('SL', '1', '', ''),
        '0051xx18': ('SL', '1', '', ''),
        '0053xx01': ('SS', '1', '', ''),
        '0053xx02': ('SS', '1', '', ''),
        '0053xx03': ('SS', '1', '', ''),
        '0053xx10': ('SS', '1', '', ''),
        '0053xx11': ('SL', '1', '', ''),
        '0053xx12': ('SS', '1', '', ''),
        '0053xx13': ('SL', '1', '', ''),
        '0053xx14': ('SS', '1', '', ''),
        '0053xx15': ('SL', '1', '', ''),
        '0053xx16': ('SS', '1', '', ''),
        '0053xx17': ('SS', '1', '', ''),
        '0053xx18': ('SL', '1', '', ''),
        '0053xx19': ('SS', '1', '', ''),
        '0053xx1A': ('SS', '1', '', ''),
        '0053xx1B': ('SL', '1', '', ''),
        '0053xx1C': ('SS', '1', '', ''),
        '0053xx1D': ('SL', '1', '', ''),
        '0053xx30': ('SS', '1', '', ''),
        '0053xx31': ('SS', '1', '', ''),
        '0053xx32': ('SS', '1', '', ''),
        '0053xx33': ('SL', '1', '', ''),
        '0053xx40': ('SS', '1', '', ''),
        '0053xx41': ('SL', '1', '', ''),
        '0053xx42': ('SS', '1', '', ''),
        '0053xx43': ('SL', '1', '', ''),
        '0053xx44': ('SS', '1', '', ''),
        '0055xx01': ('SS', '1', '', ''),
        '0055xx02': ('SS', '1', '', ''),
        '0055xx03': ('SL', '1', '', ''),
        '0055xx20': ('SS', '1', '', ''),
        '0055xx21': ('ST', '1', '', ''),
        '0055xx22': ('SS', '1', '', ''),
        '0055xx23': ('ST', '1', '', ''),
        '0055xx24': ('SS', '1', '', ''),
        '0055xx25': ('ST', '1', '', ''),
        '0055xx29': ('SL', '1', '', ''),
        '0055xx2A': ('SL', '1', '', ''),
        '0055xx30': ('SS', '1', '', ''),
        '0055xx31': ('ST', '1', '', ''),
        '0055xx32': ('SS', '1', '', ''),
        '0055xx33': ('ST', '1', '', ''),
        '0055xx34': ('SS', '1', '', ''),
        '0055xx35': ('ST', '1', '', ''),
        '0055xx38': ('SL', '1', '', ''),
        '0055xx39': ('SL', '1', '', ''),
        '0055xx3A': ('SL', '1', '', ''),
        '0055xx40': ('SS', '1', '', ''),
        '0055xx48': ('SL', '1', '', ''),
        '0055xx50': ('SS', '1', '', ''),
        '0055xx51': ('SS', '1', '', ''),
        '0055xx52': ('SS', '1', '', ''),
        '0055xx53': ('ST', '1', '', ''),
        '0055xx54': ('SL', '1', '', ''),
        '0055xx55': ('SL', '1', '', ''),
        '0055xx56': ('SS', '1', '', ''),
        '0055xx57': ('SS', '1', '', ''),
        '0055xx58': ('SL', '1', '', ''),
        '0055xx59': ('ST', '1', '', ''),
        '0055xx5A': ('SL', '1', '', ''),
        '0055xx5B': ('SS', '1', '', ''),
        '0055xx5C': ('ST', '1', '', ''),
        '0055xx5D': ('SS', '1', '', ''),
        '0055xx5E': ('SS', '1', '', ''),
        '0055xx5F': ('SL', '1', '', ''),
        '0055xx60': ('SS', '1', '', ''),
        '0055xx61': ('SS', '1', '', ''),
        '0055xx64': ('SS', '1', '', ''),
        '0055xx65': ('SS', '1', '', ''),
        '0055xx66': ('SS', '1', '', ''),
        '0055xx67': ('SS', '1', '', ''),
        '0055xx68': ('SS', '1', '', ''),
        '0055xx69': ('SS', '1', '', ''),
        '0055xx6A': ('SS', '1', '', ''),
        '0055xx6B': ('SS', '1', '', ''),
        '0055xx6C': ('SS', '1', '', ''),
        '0055xx6D': ('SS', '1', '', ''),
        '0055xx70': ('SL', '1', '', ''),
        '0055xx71': ('SL', '1', '', ''),
        '0055xx72': ('SL', '1', '', ''),
        '0055xx73': ('SL', '1', '', ''),
        '0055xx74': ('SL', '1', '', ''),
        '0055xx75': ('SL', '1', '', ''),
        '0055xx76': ('SL', '1', '', ''),
        '0055xx77': ('SL', '1', '', ''),
        '0055xx78': ('SL', '1', '', ''),
        '0055xx80': ('SS', '1', '', ''),
        '0055xx81': ('SS', '1', '', ''),
        '0055xx82': ('SS', '1', '', ''),
        '0055xx83': ('SS', '1', '', ''),
        '0055xx84': ('SS', '1', '', ''),
        '0055xx85': ('SS', '1', '', ''),
        '0055xx86': ('SL', '1', '', ''),
        '0055xx87': ('SL', '1', '', ''),
        '0055xx88': ('SL', '1', '', ''),
        '0055xx89': ('ST', '1', '', ''),
        '0055xx8A': ('SS', '1', '', ''),
        '0055xx8B': ('SL', '1', '', ''),
        '0055xx8C': ('SS', '1', '', ''),
        '0055xx8D': ('SL', '1', '', ''),
        '0055xx8E': ('SL', '1', '', ''),
        '0055xx8F': ('SL', '1', '', ''),
        '0055xx90': ('SL', '1', '', ''),
        '0055xx91': ('SS', '1', '', ''),
        '0055xx92': ('ST', '1', '', ''),
        '0055xx93': ('SL', '1', '', ''),
        '0055xx94': ('SL', '1', '', ''),
        '0055xx95': ('SL', '1', '', ''),
        '0055xx96': ('SL', '1', '', ''),
        '0055xx97': ('SL', '1', '', ''),
        '0055xx98': ('SS', '1', '', ''),
        '0055xx99': ('SS', '1', '', ''),
        '0055xx9A': ('SS', '1', '', ''),
        '0055xx9B': ('SS', '1', '', ''),
        '0055xx9C': ('SS', '1', '', ''),
        '0055xx9D': ('SL', '1', '', ''),
        '0055xx9E': ('SL', '1', '', ''),
        '0055xx9F': ('SL', '1', '', ''),
        '0055xxA0': ('SL', '1', '', ''),
        '0055xxA1': ('SL', '1', '', ''),
        '0055xxA2': ('SL', '1', '', ''),
        '0055xxA3': ('SL', '1', '', ''),
        '0055xxA4': ('SS', '1', '', ''),
        '0055xxA5': ('SL', '1', '', ''),
        '0055xxA6': ('SL', '1', '', ''),
        '0055xxA7': ('SS', '1', '', ''),
        '0055xxA8': ('SS', '1', '', ''),
        '0055xxA9': ('SS', '1', '', ''),
        '0055xxB0': ('SS', '1', '', ''),
        '0055xxB1': ('SS', '1', '', ''),
        '0057xx10': ('SS', '1', '', ''),
        '0057xx20': ('SL', '1', '', ''),
        '5001xx01': ('SS', '1', '', ''),
        '5001xx02': ('SL', '1', '', ''),
        '5001xx03': ('SL', '1', '', ''),
        '5001xx04': ('SL', '1', '', ''),
        '5001xx05': ('SL', '1', '', ''),
        '5001xx06': ('SL', '1', '', ''),
        '5001xx07': ('ST', '1', '', ''),
        '5001xx08': ('ST', '1', '', ''),
        '5001xx09': ('ST', '1', '', ''),
        '5001xx0A': ('ST', '1', '', ''),
        '5001xx0B': ('SL', '1', '', ''),
        '7001xx10': ('SS', '1', '', ''),
        '7003xx10': ('SL', '1', '', ''),
        '7005xx10': ('SS', '1', '', ''),
        '7FE1xx10': ('SS', '1', '', ''),
        '7FE3xx14': ('SL', '1', '', ''),
        '7FE3xx15': ('SL', '1', '', ''),
        '7FE3xx16': ('SL', '1', '', ''),
        '7FE3xx17': ('SL', '1', '', ''),
        '7FE3xx18': ('SL', '1', '', ''),
        '7FE3xx19': ('ST', '1', '', ''),
        '7FE3xx1A': ('SL', '1', '', ''),
        '7FE3xx1B': ('SS', '1', '', ''),
        '7FE3xx1C': ('SS', '1', '', ''),
        '7FE3xx1E': ('SL', '1', '', ''),
        '7FE3xx1F': ('SL', '1', '', ''),
        '7FE3xx20': ('SL', '1', '', ''),
        '7FE3xx21': ('SL', '1', '', ''),
        '7FE3xx22': ('SL', '1', '', ''),
        '7FE3xx23': ('SL', '1', '', ''),
        '7FE3xx24': ('ST', '1', '', ''),
        '7FE3xx25': ('SS', '1', '', ''),
    },
    'SIEMENS MED DISPLAY': {
        '0029xx04': ('CS', '1', 'Photometric Interpretation', ''),
        '0029xx10': ('US', '1', 'Rows', ''),
        '0029xx11': ('US', '1', 'Columns', ''),
        '0029xx20': ('US', '1', 'Unknown', ''),
        '0029xx21': ('US', '1', 'Unknown', ''),
        '0029xx50': ('US', '2', 'Origin', ''),
        '0029xx80': ('US', '1', 'Unknown', ''),
        '0029xx99': ('LO', '1', 'Shutter Type', ''),
        '0029xxA0': ('US', '1', 'Rows of Rectangular Shutter', ''),
        '0029xxA1': ('US', '1', 'Columns of Rectangular Shutter', ''),
        '0029xxA2': ('US', '1', 'Origin of Rectangular Shutter', ''),
        '0029xxB0': ('US', '1', 'Radius of Circular Shutter', ''),
        '0029xxB2': ('US', '1', 'Origin of Circular Shutter', ''),
        '0029xxC1': ('US', '1', 'Contour of Irregular Shutter', ''),
    },
    'SIEMENS MED DISPLAY 0000': {
        '0029xx99': ('LO', '1', 'Unknown', ''),
        '0029xxC1': ('US', '1-n', 'Unknown', ''),
    },
    'SIEMENS MED ECAT FILE INFO': {
        '0021xx00': ('OB', '1', 'ECAT_Main_Header', ''),
        '0021xx01': ('OB', '1', 'ECAT_Image_Subheader', ''),
    },
    'SIEMENS MED HG': {
        '0029xx10': ('US', '1', 'List of Group Numbers', ''),
        '0029xx15': ('LO', '1', 'List of Shadow Owner Codes', ''),
        '0029xx20': ('US', '1', 'List of Element Numbers', ''),
        '0029xx30': ('US', '1', 'List of Total Display Length', ''),
        '0029xx40': ('LO', '1-n', 'List of Display Prefix', ''),
        '0029xx50': ('LO', '1-n', 'List of Display Postfix', ''),
        '0029xx60': ('US', '1', 'List of Text Position', ''),
        '0029xx70': ('LO', '1', 'List of Text Concatenation', ''),
    },
    'SIEMENS MED MAMMO': {
        '0029xx5A': ('CS', '1', 'Unknown', ''),
    },
    'SIEMENS MED MG': {
        '0029xx10': ('US', '1', 'List of Group Numbers', ''),
        '0029xx15': ('LO', '1', 'List of Shadow Owner Codes', ''),
        '0029xx20': ('US', '1', 'List of Element Numbers', ''),
        '0029xx30': ('US', '1', 'List of Total Display Length', ''),
        '0029xx40': ('LO', '1-n', 'List of Display Prefix', ''),
        '0029xx50': ('LO', '1-n', 'List of Display Postfix', ''),
        '0029xx60': ('US', '1', 'List of Text Position', ''),
        '0029xx70': ('LO', '1', 'List of Text Concatenation', ''),
    },
    'SIEMENS MED NM': {
        '0009xx80': ('LO', '1', 'Main Acquisition View', ''),
        '0011xx10': ('CS', '1', 'Organ System', ''),
        '0017xx00': ('ST', '1', 'Unknown 0017 0000', ''),
        '0017xx20': ('CS', '1', 'Scanning Sequence', ''),
        '0017xx60': ('DS', '1', 'KVP', ''),
        '0017xx70': ('ST', '1', 'Unknown', ''),
        '0017xx80': ('ST', '1-n', 'Unknown 0017 0080', ''),
        '0019xx01': ('SS', '1', 'Number of detectors', ''),
        '0019xx02': ('SS', '1', 'Number of scalers', ''),
        '0019xx03': ('SS', '1', 'Scaler Index', ''),
        '0019xx04': ('DS', '1', 'Radionuclide Units', ''),
        '0019xx05': ('DS', '1', 'Radiopharmaceutical', ''),
        '0019xx06': ('FL', '1', 'Display Magnification', ''),
        '0019xx07': ('SL', '1', 'Scaler Counts', ''),
        '0019xx08': ('SS', '1', 'Processed Flag 0 Raw 1 Process', ''),
        '0019xx09': ('SS', '1', 'MicroDELTA Parameter Blocks', ''),
        '0019xx0A': ('LO', '1', 'MicroDELTA File Extension', ''),
        '0019xx0B': ('LO', '1', 'MicroDELTA Write ID', ''),
        '0019xx0C': ('SS', '1', 'MicroDELTA Write Version', ''),
        '0019xx0D': ('CS', '1', 'MicroDELTA Mode', ''),
        '0019xx0E': ('LO', '1', 'MicroDELTA ESFR', ''),
        '0019xx0F': ('SL', '1', 'Siemens ICON Data Type', ''),
        '0019xx10': ('OW', '1', 'MicroDELTA Expansion Blocks', ''),
        '0019xx11': ('CS', '1', 'MicroDELTA Version', ''),
        '0019xx12': ('LO', '1', 'MicroDELTA Trend', ''),
        '0019xx13': ('SS', '1', 'MicroDELTA Number of Overlays', ''),
        '0019xx14': ('SS', '1', 'MicroDELTA Overlay Block', ''),
        '0019xx15': ('SS', '1', 'MicroDELTA Color Table Extra', ''),
        '0019xx16': ('SS', '1', 'Number of Views', ''),
        '0019xx17': ('SS', '1', 'MicroDELTA Thyroid Markers', ''),
        '0019xx18': ('SS', '1', 'MicroDELTA Color Table Used', ''),
        '0019xx19': ('SS', '1', 'Save Screen Flag 1 SaveScreen', ''),
        '0019xx1A': ('SS', '1', 'MicroDELTA Overlay Map', ''),
        '0019xx1B': ('SS', '1', 'SGI Converted LookUp Table', ''),
        '0019xx1C': ('SS', '1', 'MicroDELTA Mystery1', ''),
        '0019xx1D': ('SS', '1', 'MicroDELTA Mystery2', ''),
        '0019xx20': ('FL', '1', 'Time of Lasix Administration', ''),
        '0019xx21': ('FL', '1', 'Lasix Dose mg', ''),
        '0019xx22': ('FL', '1', 'Bladder Esidual Volume cc', ''),
        '0019xx23': ('SS', '1', 'Bladder Image Extension', ''),
        '0019xx24': ('FL', '1', 'Serum Creatinine mg/dl', ''),
        '0019xx25': ('FL', '1', 'TER', ''),
        '0019xx26': ('FL', '1', 'TER Lower Limit', ''),
        '0019xx27': ('FL', '1', 'Body Surface Area m2', ''),
        '0019xx30': ('FL', '1', 'CTQ Normal Margin', ''),
        '0019xx31': ('FL', '1', 'CTQ Abnormal Sagittal Margin', ''),
        '0019xx32': ('FL', '1', 'CTQ Abnormal Oblique Margin', ''),
        '0019xx41': ('SS', '1', 'Accepted Beats', ''),
        '0019xx42': ('SS', '1', 'Rejected Beats', ''),
        '0019xx43': ('SS', '1', 'Percent of R-R Interval Framed', ''),
        '0019xx44': ('SS', '1', 'Beats Rejected Post PVC', ''),
        '0019xx45': ('FL', '1', 'Trigger Source', ''),
        '0019xx47': ('FL', '1', 'Beat Rejection Parameter', ''),
        '0019xx48': ('SH', '1', 'Rejection Scheme', ''),
        '0019xx49': ('FL', '1', 'PVC Threshold msec', ''),
        '0019xx4A': ('SS', '1', 'Framing Mode 1 Forward 2 F/B', ''),
        '0019xx4B': ('SS', '1', 'Autobeat Window 0 No 1 Yes', ''),
        '0019xx4C': ('FL', '1', 'MicroDELTA Acquisition Time per Window msec', ''),
        '0019xx4E': ('SS', '1', 'CTQ Unknown Entry Count', ''),
        '0019xx4F': ('SS', '1', 'CTQ Matrix Size', ''),
        '0019xx50': ('SS', '1', 'CTQ has been used', ''),
        '0019xx51': ('SS', '1', 'CTQ Male Entry Count', ''),
        '0019xx52': ('SS', '1', 'CTQ Female Entry Count', ''),
        '0019xx53': ('SS', '1', 'CTQ Stress/Rest Time Delay', ''),
        '0019xx54': ('CS', '1', 'CTQ Time Delay Units', ''),
        '0019xx55': ('SS', '1', 'CTQ Min Oblique Stack Count', ''),
        '0019xx56': ('SS', '1', 'CTQ Max Oblique Stack Count', ''),
        '0019xx57': ('SS', '1', 'CTQ Min Sagittal Stack Count', ''),
        '0019xx58': ('SS', '1', 'CTQ Max Sagittal Stack Count', ''),
        '0019xx59': ('SS', '1', 'CTQ Min Radius Percent', ''),
        '0019xx5A': ('UL', '1', 'CTQ Find Max or Average Flag', ''),
        '0019xx5B': ('SS', '1', 'CTQ Basal Slice Index Offset', ''),
        '0019xx5C': ('SS', '1', 'CTQ Starting Line Index', ''),
        '0019xx5D': ('SS', '1', 'CTQ Line Counts', ''),
        '0019xx5E': ('SS', '1', 'CTQ Radii Counts', ''),
        '0019xx5F': ('SS', '1', 'CTQ Radial Angle Increment', ''),
        '0019xx60': ('SS', '1', 'Whole Body Processed Flag 0:Raw 1:Img1-Img2 2:Im', ''),
        '0019xx61': ('SS', '1', 'Whole Body View', ''),
        '0019xx62': ('SS', '1', 'WB Display Field Length in cm', ''),
        '0019xx63': ('SS', '1', 'WB Scan Length in cm', ''),
        '0019xx64': ('SS', '1', 'WB Scan Speed cm/min', ''),
        '0019xx65': ('SS', '1', 'WB Scan Speed Mode 0 Manual 1 Auto', ''),
        '0019xx66': ('SS', '1', 'WB Scan Start 0 Head 1 Feet', ''),
        '0019xx67': ('SS', '1', 'WB Scan Direction 0 Lt to Rt 1 Rt to Lt', ''),
        '0019xx68': ('FL', '1', 'WB Aperature Width in cm', ''),
        '0019xx69': ('SS', '1', 'WB Number of Passes', ''),
        '0019xx6A': ('SS', '1', 'WB Scan Time msec', ''),
        '0019xx6B': ('FL', '1', 'WB Anterior kCounts View 1', ''),
        '0019xx6C': ('FL', '1', 'WB Anterior kCounts View 2', ''),
        '0019xx6D': ('FL', '1', 'WB Count Density', ''),
        '0019xx6E': ('SS', '1', 'WB Reference View Flag 1 Ref', ''),
        '0019xx6F': ('FL', '1', 'WB Coun Density Speed cm/min', ''),
        '0019xx70': ('CS', '1', 'WB Scan Type', ''),
        '0019xx71': ('LO', '1', 'WB IRIS Corr. File Name', ''),
        '0019xx72': ('FL', '1', 'WB Posterior kCounts View 1', ''),
        '0019xx73': ('FL', '1', 'WB Posterior kCounts View 2', ''),
        '0019xx74': ('SS', '1', 'WB Ant View Status No Img 1 Complete 2 Aborted', ''),
        '0019xx75': ('SS', '1', 'WB Post View Status No Img 1 Complete 2 Aborted', ''),
        '0019xx76': ('SS', '1', 'WB Post Scan Time msec', ''),
        '0019xx77': ('SS', '1', 'WB Ant Pixel Overflow 1 Yes', ''),
        '0019xx78': ('SS', '1', 'WB Post Pixel Overflow 1 Yes', ''),
        '0019xx7F': ('SS', '1', 'Segment Type 0 Segments 2 Time/Segment', ''),
        '0019xx80': ('SS', '1', 'Number of Segments', ''),
        '0019xx81': ('SS', '1', 'PVC Rejection Flag 1 Reject', ''),
        '0019xx82': ('SL', '1', 'Total Counts Framed', ''),
        '0019xx83': ('SS', '1', 'Total Beats Framed', ''),
        '0019xx84': ('SS', '1', 'Present Time of Day', ''),
        '0019xx85': ('SS', '1', 'Framed Counts', ''),
        '0019xx86': ('SS', '1', 'Time per Segment msec', ''),
        '0019xx87': ('LT', '1', 'BBA Miscellaneous Info', ''),
        '0019xx88': ('SL', '1', 'Tolerance %', ''),
        '0019xx89': ('SS', '1', 'SWG', ''),
        '0019xx8A': ('SL', '1', 'R-R Interval msec', ''),
        '0019xx8D': ('SL', '1', 'Total Counts in Acquisition', ''),
        '0019xx8E': ('SL', '1', 'Rejection Type', ''),
        '0019xx91': ('FL', '1', 'Phase Total Counts', ''),
        '0019xx92': ('SL', '1', 'Phase Pause msec', ''),
        '0019xx93': ('SL', '1', 'Phase Start msec', ''),
        '0019xx94': ('SS', '1', 'Window Center Method 0 Avg 1 Peak', ''),
        '0019xx95': ('SS', '1', 'Number of Beats to Average', ''),
        '0019xx96': ('FL', '1', 'Histogram Bin Interval msec', ''),
        '0019xx97': ('SS', '1', 'Counts in Peak Bin', ''),
        '0019xxA0': ('SS', '1', 'VPDs Detected', ''),
        '0019xxA1': ('SS', '1', 'Number of Phases', ''),
        '0019xxA2': ('SL', '1', 'Requested Frame Duration msec', ''),
        '0019xxA3': ('SL', '1', 'Frames per Phase', ''),
        '0019xxA4': ('SL', '1', 'Frame Pause msec', ''),
        '0019xxA5': ('SS', '1-n', 'Number of repeats per phase', ''),
        '0019xxA6': ('SS', '1-n', 'Cycles per repeat', ''),
        '0019xxA7': ('SL', '1-n', 'Repeat start time', ''),
        '0019xxA8': ('SL', '1-n', 'Repeat stop time', ''),
        '0019xxA9': ('SL', '1-n', 'Effective repeat time', ''),
        '0019xxAA': ('SS', '1-n', 'Acquired cycles per repeat', ''),
        '0019xxC0': ('FL', '1', 'Head Tilt degrees', ''),
        '0019xxC1': ('SS', '1', 'Uniformity Correction Flag', ''),
        '0019xxC2': ('SS', '1', 'Overflow Flag', ''),
        '0019xxC3': ('ST', '1', 'Unknown', ''),
        '0019xxF0': ('FL', '1', 'Pixel Dimensions', ''),
        '001Fxx50': ('DS', '1', 'Location RET', ''),
        '0021xx00': ('OB', '1', 'ECAT File Menu Header', ''),
        '0021xx01': ('OB', '1', 'ECAT File Subheader', ''),
        '0021xx10': ('ST', '1', 'Unknown', ''),
        '0031xx01': ('LO', '1', 'Camera Name', ''),
        '0031xx02': ('SS', '1', 'Unknown Element 0031 02', ''),
        '0031xx03': ('FL', '1', 'External Zoom', ''),
        '0031xx04': ('FL', '1', 'CCD Energy Level', ''),
        '0031xx05': ('SS', '1', 'CCD Window Width', ''),
        '0031xx06': ('FL', '1', 'CCD Window Offset', ''),
        '0031xx07': ('SS', '1', 'CCD Peaking Mode', ''),
        '0031xx08': ('LO', '1', 'CCD Autopeak Function', ''),
        '0031xx09': ('SS', '1', 'CCD Count Rate Mode', ''),
        '0031xx0A': ('SS', '1', 'Analog Output Device', ''),
        '0031xx0B': ('SS', '1', 'Communication Type', ''),
        '0031xx0C': ('SS', '1', 'Control Unit 1 ICON 2 DOT 3 ScintiView', ''),
        '0031xx0D': ('SS', '1', 'WAM Mode', ''),
        '0031xx0E': ('SS', '1', 'Event Control Mode', ''),
        '0031xx0F': ('FL', '1', 'Zoom X Offset 0.1 mm', ''),
        '0031xx10': ('FL', '1', 'Zoom Y Offset 0.1 mm', ''),
        '0031xx11': ('SS', '1', 'Gantry Zero Position', ''),
        '0031xx12': ('SS', '1', 'Unknown', ''),
        '0031xx13': ('ST', '1', 'Unknown', ''),
        '0031xx14': ('ST', '1', 'Unknown', ''),
        '0031xx15': ('SL', '1-n', 'Unknown', ''),
        '0031xx16': ('SL', '1-n', 'Unknown', ''),
        '0031xx17': ('SS', '1-n', 'Unknown', ''),
        '0031xx20': ('ST', '1', 'Unknown', ''),
        '0031xx21': ('SS', '1', 'Unknown', ''),
        '0033xx00': ('FL', '1-n', 'Flood correction Matrix Det 1 up to SR 2.0', ''),
        '0033xx01': ('FL', '1-n', 'Flood correction Matrix Det 2 up to SR 2.0', ''),
        '0033xx10': ('FL', '1-n', 'COR Data for Detector 1', ''),
        '0033xx11': ('FL', '1-n', 'COR Data for Detector 2', ''),
        '0033xx14': ('FL', '1', 'MHR ( Y-Shift) data for detector 1', ''),
        '0033xx15': ('FL', '1', 'MHR ( Y-Shift) data for detector 2', ''),
        '0033xx18': ('FL', '1-n', 'NCO Data for detector 1', ''),
        '0033xx19': ('FL', '1-n', 'NCO Data for detector 2', ''),
        '0033xx20': ('FL', '1', 'Bed correction angle', ''),
        '0033xx21': ('FL', '1', 'Gantry correction angle', ''),
        '0033xx22': ('SS', '1-n', 'Bed U/D correction data', ''),
        '0033xx23': ('SS', '1-n', 'Unknown', ''),
        '0033xx24': ('FL', '1', 'Backprojection angle head 1', ''),
        '0033xx25': ('FL', '1', 'Backprojection angle head 2', ''),
        '0033xx28': ('SL', '1', 'Number of point sources used for NCO and MHR', ''),
        '0033xx29': ('FL', '1', 'Crystal thickness', ''),
        '0033xx30': ('LO', '1', 'Preset name used for acquisition', ''),
        '0033xx31': ('FL', '1', 'Camera config angle', ''),
        '0033xx32': ('LO', '1', 'Crystal type Startburst or not', ''),
        '0033xx33': ('SL', '1', 'Gantry step for COIN acquisitions', ''),
        '0033xx34': ('FL', '1', 'Bed step for wholebody or Coin acquisitions', ''),
        '0033xx35': ('FL', '1', 'Weight factor table for coincidence acquisitions', ''),
        '0033xx36': ('FL', '1', 'Transaxial acceptance width for coincidence', ''),
        '0033xx37': ('SL', '1', 'Starburst flags', ''),
        '0033xx38': ('FL', '1', 'Pixel scale factor', ''),
        '0035xx00': ('LO', '1', 'Specialized tomo type', ''),
        '0035xx01': ('LO', '1', 'Energy window type', ''),
        '0035xx02': ('SS', '1', 'Start and end row illuminated by wind position', ''),
        '0035xx03': ('LO', '1', 'Blank scan image for profile', ''),
        '0035xx04': ('SS', '1', 'Repeat number of the original dynamic SPECT', ''),
        '0035xx05': ('SS', '1', 'Phase number of the original dynamic SPECT', ''),
        '0037xx00': ('OW', '1', 'Flood correction matrix Detector 1', ''),
        '0037xx80': ('OW', '1', 'Flood correction matrix Detector 2', ''),
        '0039xx00': ('LT', '1', 'Toshiba CBF activity results', ''),
        '0041xx01': ('SL', '1', 'Unknown', ''),
        '0041xx02': ('SL', '1', 'Unknown', ''),
        '0041xx05': ('FD', '1-n', 'Unknown', ''),
        '0041xx06': ('FD', '1-n', 'Unknown', ''),
        '0041xx07': ('FD', '1-n', 'Unknown', ''),
        '0041xx08': ('FD', '1-n', 'Unknown', ''),
        '0041xx11': ('FL', '1-n', 'Unknown', ''),
        '0041xx21': ('LO', '1', 'Text Relating to Data Object', ''),
        '0041xx30': ('DA', '1', 'Folder Creation Date', ''),
        '0041xx32': ('TM', '1', 'Folder Creation Time', ''),
        '0041xx34': ('DA', '1', 'Folder Modification Date', ''),
        '0041xx36': ('TM', '1', 'Folder Modification Time', ''),
        '0041xx40': ('LO', '1', 'Folder Owner Name', ''),
        '0041xx50': ('SS', '1', 'Folder Status', ''),
        '0041xx70': ('SL', '1', 'Number of Images in Folder', ''),
        '0041xx71': ('SL', '1', 'Number of Non-Image Objects', ''),
        '0043xx01': ('FL', '1-n', 'Unknown', ''),
        '0043xx03': ('FL', '1-n', 'Unknown', ''),
        '0043xx04': ('FL', '1-n', 'Unknown', ''),
        '0051xx10': ('SS', '1', 'Number of Windows', ''),
        '0051xx11': ('SS', '1', 'Average Heart Rate BPM', ''),
        '0051xx12': ('SS', '1', 'Accepted Beats in Window', ''),
        '0051xx13': ('SS', '1', 'Average R-R Interval msec', ''),
        '0051xx14': ('SS', '1', 'Window Width %', ''),
        '0051xx15': ('SL', '1', 'Hottest Pixel in Window', ''),
        '0051xx18': ('SL', '1', 'Total Counts in Window', ''),
        '0053xx01': ('SS', '1', 'Terminate on Pixel Overflow Flag 1 Terminate', ''),
        '0053xx02': ('SS', '1', 'Terminate on List Buffer Overflow Flag', ''),
        '0053xx03': ('SS', '1', 'First Frame by Counts', ''),
        '0053xx10': ('SS', '1', 'Elapsed Time Start Condition 0 None 1 Any 2 All', ''),
        '0053xx11': ('SL', '1', 'Elapsed Time Start msec', ''),
        '0053xx12': ('SS', '1', 'Count Rate Start Condition 0 None 1 Any 2 All', ''),
        '0053xx13': ('SL', '1', 'Count Rate Start', ''),
        '0053xx14': ('SS', '1', 'Start Heart Beat Count Condition 0 None 1 Any 2', ''),
        '0053xx15': ('SL', '1', 'Start Heart Beat Count', ''),
        '0053xx16': ('SS', '1', 'Start Heart Rate Threshold Condition', ''),
        '0053xx17': ('SS', '1', 'Start Heart Rate Increasing Flag', ''),
        '0053xx18': ('SL', '1', 'Start Heart Rate', ''),
        '0053xx19': ('SL', '1', 'Manual Stop Flag 0 No 1 Yes', ''),
        '0053xx1A': ('SS', '1', 'Elapsed Time Stop Condition 0 None 1 Any 2 All', ''),
        '0053xx1B': ('SL', '1', 'Elapsed Time Stop', ''),
        '0053xx1C': ('SS', '1', 'Stop Heart Beat Count Condition 0 None 1 Any 2 A', ''),
        '0053xx1D': ('SL', '1', 'Stop Heart Beat Count', ''),
        '0053xx30': ('SS', '1', 'Info Density Stop Condition', ''),
        '0053xx31': ('SS', '1', 'Info Density Stop Scaler', ''),
        '0053xx32': ('SS', '1', 'Info Density Stop Region', ''),
        '0053xx33': ('SL', '1', 'Info Density Stop Count', ''),
        '0053xx40': ('SS', '1', 'Stop Condition Status 0 None 1 Any 2 All', ''),
        '0053xx41': ('SL', '1', 'Stop Count', ''),
        '0053xx42': ('SS', '1', 'Stop Count Condition Status 0 None 1 Any 2 All', ''),
        '0053xx43': ('SL', '1', 'Stop Time', ''),
        '0053xx44': ('SS', '1', 'Stop Time Condition Status 0 None 1 Any 2 All', ''),
        '0055xx02': ('SS', '1', 'Unknown 55-02', ''),
        '0055xx04': ('SS', '1', 'Prompt window width', ''),
        '0055xx05': ('SS', '1', 'Random window width', ''),
        '0055xx20': ('SS', '1', 'Flood Corr. Flag 1 Corr', ''),
        '0055xx21': ('DS', '1', 'Flood Acquisition Date', ''),
        '0055xx30': ('SS', '1', 'COR Corr. Flag 1 Corr', ''),
        '0055xx31': ('DA', '1', 'COR Acquisition Date', ''),
        '0055xx38': ('OW', '1', 'COR Data', ''),
        '0055xx40': ('SS', '1', 'Noncircular Orbit Flag 1 NCO', ''),
        '0055xx48': ('FL', '1', 'NCO Values', ''),
        '0055xx4C': ('SL', '1', 'Unknown', ''),
        '0055xx4D': ('SL', '1', 'Unknown', ''),
        '0055xx50': ('SS', '1', 'Prone Flag 0 Supine 1 Prone', ''),
        '0055xx51': ('SS', '1', 'Orbit 0 Circular 1 Elliptical', ''),
        '0055xx52': ('SS', '1', 'Total Rotation in Degrees', ''),
        '0055xx53': ('CS', '1', 'Zero Location (T=Top B=Bottom)', ''),
        '0055xx54': ('FL', '1', 'Angular Step', ''),
        '0055xx55': ('FL', '1', 'Start Angle', ''),
        '0055xx56': ('SS', '1', 'Decay Corr. Flag 1 Corr', ''),
        '0055xx57': ('SS', '1', 'Scatter Corr. Flag 1 Corr', ''),
        '0055xx58': ('FL', '1', 'Radial Map Info in 0.1 mm Inc.', ''),
        '0055xx59': ('CS', '1', 'Direction H HeadIn F FeetIn', ''),
        '0055xx5A': ('FL', '1', 'Table Traverse cm', ''),
        '0055xx5B': ('SS', '1', 'Multiplexor Flag 1 Multiplexed', ''),
        '0055xx5C': ('DS', '1', 'Pixel Acquisition Date', ''),
        '0055xx5D': ('SS', '1', 'Angle Type 1 360o 2 128 Steps', ''),
        '0055xx5E': ('SL', '1', 'Orbit Definition', ''),
        '0055xx5F': ('FL', '1', 'Arm Length in cm', ''),
        '0055xx60': ('SS', '1', 'Auto Window Beats', ''),
        '0055xx61': ('SS', '1', 'Non-gated File Extension', ''),
        '0055xx64': ('SS', '1', 'TIC Error Values', ''),
        '0055xx65': ('SS', '1', 'X1', ''),
        '0055xx66': ('SS', '1', 'Y1', ''),
        '0055xx67': ('SS', '1', 'X2', ''),
        '0055xx68': ('SS', '1', 'Y2', ''),
        '0055xx69': ('SS', '1', 'X3', ''),
        '0055xx6A': ('SS', '1', 'Y3', ''),
        '0055xx6B': ('SS', '1', 'X4', ''),
        '0055xx6C': ('SS', '1', 'Y4', ''),
        '0055xx6D': ('SS', '1', 'Pixel Size Flag 1 Valid Size', ''),
        '0055xx70': ('FL', '1', 'X Focal Length', ''),
        '0055xx71': ('FL', '1', 'Y Focal Length', ''),
        '0055xx72': ('FL', '1', 'X Gains', ''),
        '0055xx73': ('FL', '1', 'Y Gains', ''),
        '0055xx74': ('FL', '1', 'X Offset', ''),
        '0055xx75': ('FL', '1', 'Y Offset', ''),
        '0055xx76': ('FL', '1', 'X Principal Ray', ''),
        '0055xx77': ('FL', '1', 'Y Principal Ray', ''),
        '0055xx78': ('FL', '1', 'Total Flood Counts', ''),
        '0055xx7E': ('FL', '1-n', 'Collimator thickness', ''),
        '0055xx7F': ('FL', '1-n', 'Collimator angular resolution', ''),
        '0055xx80': ('SS', '1', 'File Altered Flag 1 Altered', ''),
        '0055xx81': ('SS', '1', 'Raw Data Extension', ''),
        '0055xx82': ('SS', '1', 'Sagittal Extension', ''),
        '0055xx83': ('SS', '1', 'Coronal Extension', ''),
        '0055xx84': ('SS', '1', 'Transverse Extension', ''),
        '0055xx85': ('SS', '1', 'Volume Rendered Extension', ''),
        '0055xx86': ('SL', '1', 'Plane of Transverse Bottom Slice', ''),
        '0055xx87': ('SL', '1', 'Plane of Transverse Top Slice', ''),
        '0055xx88': ('SL', '1', 'Slice Step in Pixels', ''),
        '0055xx8A': ('SL', '1', 'Y-Axis Smooth Slice Weights', ''),
        '0055xx8B': ('SL', '1', 'Number of Transverse Slices', ''),
        '0055xx8C': ('SS', '1', 'Attenuation Flag 1 Chang 2 Sorenson', ''),
        '0055xx8D': ('SS', '1', 'Sagittal Right Limit', ''),
        '0055xx8E': ('SS', '1', 'Sagittal Left Limit', ''),
        '0055xx8F': ('SS', '1', 'Coronal Posterior Limit', ''),
        '0055xx90': ('SS', '1', 'Coronal Anterior Limit', ''),
        '0055xx91': ('SS', '1', 'Isotope Used in Reconstruction', ''),
        '0055xx93': ('FL', '1', 'Filter Cutoff Frequency', ''),
        '0055xx94': ('FL', '1', 'Filter Alpha Coefficient', ''),
        '0055xx95': ('FL', '1', 'Filter Order', ''),
        '0055xx96': ('FL', '1', 'Attenuation Coefficient', ''),
        '0055xx97': ('SS', '1', 'Percent Ray', ''),
        '0055xx98': ('SS', '1', 'Astigmatic Collimator 1 Neuro 2 Cardiac', ''),
        '0055xx99': ('SS', '1', 'XP0', ''),
        '0055xx9A': ('SS', '1', 'ZP0', ''),
        '0055xx9B': ('SS', '1', 'XP1', ''),
        '0055xx9C': ('SS', '1', 'ZP1', ''),
        '0055xx9D': ('FL', '1', 'Rotation Matrix', ''),
        '0055xx9E': ('FL', '1', 'X0', ''),
        '0055xx9F': ('FL', '1', 'X1', ''),
        '0055xxA0': ('FL', '1', 'Y0', ''),
        '0055xxA1': ('FL', '1', 'Y1', ''),
        '0055xxA2': ('FL', '1', 'Z0', ''),
        '0055xxA3': ('FL', '1', 'Z1', ''),
        '0055xxA4': ('SS', '1', 'Transverse Scale', ''),
        '0055xxA5': ('FL', '1', 'Pixel Size X Direction mm', ''),
        '0055xxA6': ('FL', '1', 'Pixel Size Y Direction mm', ''),
        '0055xxA7': ('SS', '1', 'Regions File Extension', ''),
        '0055xxA8': ('SS', '1', 'Gated SPECT Bins Reconstructed', ''),
        '0055xxA9': ('SS', '1', 'Vertical Oblique Image', ''),
        '0055xxB0': ('SS', '1', 'Oblique Region First Slice', ''),
        '0055xxB1': ('SS', '1', 'Oblique Region Last Slice', ''),
        '0055xxC0': ('SS', '1-n', 'Unknown', ''),
        '0055xxC2': ('SS', '1', 'Unknown', ''),
        '0055xxC3': ('SS', '1', 'Unknown', ''),
        '0055xxC4': ('SS', '1', 'Unknown', ''),
        '0055xxD0': ('SS', '1', 'Unknown', ''),
        '0057xx01': ('LO', '1', 'e.soft DICOM original image type', ''),
        '0057xx02': ('FL', '1', 'Dose calibration factor', ''),
        '0057xx03': ('LO', '1', 'Units', ''),
        '0057xx04': ('LO', '1', 'Decay correction', ''),
        '0057xx05': ('SL', '1-n', 'Radio nuclide half life', ''),
        '0057xx06': ('FL', '1', 'Rescale intercept', ''),
        '0057xx07': ('FL', '1', 'Rescale Slope', ''),
        '0057xx08': ('FL', '1', 'Frame reference time', ''),
        '0057xx09': ('SL', '1', 'Number of Radiopharmaceutical information seq', ''),
        '0057xx0A': ('FL', '1', 'Decay factor', ''),
        '0057xx0B': ('LO', '1', 'Counts source', ''),
        '0057xx0C': ('SL', '1-n', 'Radio Nuclide positron fraction', ''),
        '0057xx10': ('SS', '1', 'Low Count', ''),
        '0057xx20': ('SS', '1', 'Vertical Oblique Image', ''),
        '5001xx02': ('SL', '1', 'Number of Points', ''),
        '5001xx03': ('FL', '1', 'Minimal Value on X-Axis', ''),
        '5001xx04': ('FL', '1', 'Maximal Value on X-Axis', ''),
        '5001xx05': ('FL', '1', 'Minimal Value on Y-Axis', ''),
        '5001xx06': ('FL', '1', 'Maximal Value on Y-Axis', ''),
        '5001xx07': ('LO', '1', 'Curve Name', ''),
        '5001xx08': ('LO', '1', 'Curve Function Label', ''),
        '5001xx09': ('SH', '1', 'X Axis Label', ''),
        '5001xx0A': ('SH', '1', 'Y Axis Label', ''),
        '5001xx0B': ('OW', '1', 'Curve Data', ''),
        '7FE1xx10': ('OW', '1', 'Compressed Pixel Data', ''),
        '7FE3xx00': ('UL', '1', 'Length of Group 0x7FE3', ''),
        '7FE3xx14': ('SL', '1', 'Lowest Pixel Value in THIS Frame', ''),
        '7FE3xx15': ('SL', '1', 'Highest Pixel Value in THIS Frame', ''),
        '7FE3xx16': ('SL', '1', 'Total Counts in THIS Frame', ''),
        '7FE3xx17': ('SL', '1', 'Duration of THIS Frame msec', ''),
        '7FE3xx18': ('FL', '1', 'Frame Angle', ''),
        '7FE3xx19': ('LO', '1', 'Frame Name', ''),
        '7FE3xx1A': ('FL', '1', 'View Number', ''),
        '7FE3xx1B': ('SS', '1', 'Pixel Overflow Flag 1 Pixel Overflow', ''),
        '7FE3xx1C': ('SS', '1', 'Buffer Overflow Flag 1 Buffer Overflow', ''),
        '7FE3xx1E': ('SL', '1', 'Start Time of THIS Frame From Start of Study', ''),
        '7FE3xx1F': ('SL', '1', 'ROI Maximum Pixel Value', ''),
        '7FE3xx20': ('SL', '1', 'ROI Average Pixel Value', ''),
        '7FE3xx21': ('SL', '1', 'ROI Total Counts', ''),
        '7FE3xx22': ('SL', '1', 'ROI Total Pixels', ''),
        '7FE3xx23': ('SL', '1', 'ROI Center Coordinates', ''),
        '7FE3xx24': ('LO', '1', 'ROI Name', ''),
        '7FE3xx25': ('SS', '1', 'ROI Data', ''),
        '7FE3xx26': ('OW', '1', 'Unknown', ''),
        '7FE3xx27': ('OW', '1', 'Unknown', ''),
        '7FE3xx28': ('OW', '1', 'Unknown', ''),
        '7FE3xx29': ('OW', '1', 'Unknown', ''),
    },
    'SIEMENS MED OCS ACKNOWLEDGE FLAG': {
        '0039xx81': ('IS', '1', 'Acknowledge Flag', ''),
    },
    'SIEMENS MED OCS AE TITLE': {
        '0039xx79': ('CS', '1', 'AE Title', ''),
    },
    'SIEMENS MED OCS CALIBRATION DATE': {
        '0039xx81': ('CS', '1', 'Calibration Date', ''),
    },
    'SIEMENS MED OCS CBT ARC INCREMENT': {
        '0039xx84': ('IS', '1-n', 'Arc Increment', ''),
    },
    'SIEMENS MED OCS CBT ENDING GANTRY ANGLE': {
        '0039xx83': ('DS', '1-n', 'Ending Projection Angle', ''),
    },
    'SIEMENS MED OCS CBT MISSING PROJECTION FRAMES': {
        '0039xx91': ('IS', '1-n', 'Missing Projection Frames', ''),
    },
    'SIEMENS MED OCS CBT PATIENT_ORIENTATION': {
        '0039xx93': ('CS', '1', 'Patient Orientation', ''),
    },
    'SIEMENS MED OCS CBT PROJECTION GANTRY POSITIONS': {
        '0039xx86': ('DS', '1-n', 'Gantry Positions', ''),
    },
    'SIEMENS MED OCS CBT RECON FILTER TYPE': {
        '0039xx90': ('IS', '1', 'Reconstruction Filter Type', ''),
    },
    'SIEMENS MED OCS CBT RECON NUM OF SLICES': {
        '0039xx89': ('IS', '1', 'Number of Reconstruction Slices', ''),
    },
    'SIEMENS MED OCS CBT RECON SLICE HEIGHT': {
        '0039xx88': ('IS', '1', 'Reconstruction Slice Height', ''),
    },
    'SIEMENS MED OCS CBT RECON SLICE WIDTH': {
        '0039xx87': ('IS', '1', 'Reconstruction Slice Width', ''),
    },
    'SIEMENS MED OCS CBT ROTATION DIRECTION': {
        '0039xx85': ('CS', '1-n', 'Gantry Rotation Direction', ''),
    },
    'SIEMENS MED OCS CBT STARTING GANTRY ANGLE': {
        '0039xx82': ('DS', '1-n', 'Starting Projection Angle', ''),
    },
    'SIEMENS MED OCS CBT TOTAL_MU': {
        '0039xx96': ('DS', '1', 'Total MU delivered during Cone Beam', ''),
    },
    'SIEMENS MED OCS COMMON EDGE': {
        '0039xx83': ('IS', '1', 'Common Edge', ''),
    },
    'SIEMENS MED OCS FIELD ID': {
        '0039xx80': ('CS', '1', 'Field ID', ''),
    },
    'SIEMENS MED OCS FIELD NAME': {
        '0039xx79': ('CS', '1', 'Field Name', ''),
    },
    'SIEMENS MED OCS FP Alignment Calibration Date / Time': {
        '0039xx95': ('DT', '1', 'Flat Panel Alignment last calibration Date and Time', ''),
    },
    'SIEMENS MED OCS I0 MU SCALE FACTOR': {
        '0039xx97': ('IS', '1', 'I0-MU Scale Factor', ''),
    },
    'SIEMENS MED OCS ICC MATRIX': {
        '0039xx82': ('DS', '2', 'Image Center in Image Coordinates', ''),
    },
    'SIEMENS MED OCS NUMBER OF FRAMES': {
        '0039xx76': ('IS', '1', 'Number of Frames', ''),
    },
    'SIEMENS MED OCS NUMBER OF SUB FRAMES': {
        '0039xx77': ('IS', '1', 'Number of Sub-Frames', ''),
    },
    'SIEMENS MED OCS PI ALIGNMENT IMAGE': {
        '0039xx94': ('IS', '1', 'Alignment Offset Valid Flag', ''),
    },
    'SIEMENS MED OCS PI VALID PIXEL MAP': {
        '0039xx92': ('IS', '1', 'Valid Pixel Map Flag', ''),
    },
    'SIEMENS MED OCS REFERENCE IMAGE': {
        '0039xx76': ('UI', '1', 'Reference Image', ''),
    },
    'SIEMENS MED OCS REFERENCE LOCKED': {
        '0039xx88': ('IS', '1', 'Locked Flag', ''),
    },
    'SIEMENS MED OCS SC IMG PIX SPC': {
        '0039xx87': ('DS', '2', 'Non-RT Image Pixel Spacing', ''),
    },
    'SIEMENS MED OCS SC IMG SAD': {
        '0039xx86': ('DS', '1', 'Non-RT Image SAD', ''),
    },
    'SIEMENS MED OCS SC IMG SID': {
        '0039xx85': ('DS', '1', 'Non-RT Image SID', ''),
    },
    'SIEMENS MED OCS SCALED IMG PIX SPC': {
        '0039xx84': ('DS', '2', 'Scaled Image Pixel Spacing', ''),
    },
    'SIEMENS MED OCS SITE NAME': {
        '0039xx78': ('CS', '1', 'Site Name', ''),
    },
    'SIEMENS MED OCS TABLE LATERAL POSITION': {
        '0039xx98': ('DS', '1', 'Lateral Table Position', ''),
    },
    'SIEMENS MED OCS TABLE LONGITUDINAL POSITION': {
        '0039xx99': ('DS', '1', 'Longitudinal Table Position', ''),
    },
    'SIEMENS MED OCS TABLE OFFSET': {
        '0039xx78': ('DS', '3', 'Offset', ''),
    },
    'SIEMENS MED OCS TABLE VERTICAL POSITION': {
        '0039xx75': ('DS', '1', 'vertical Table Position', ''),
    },
    'SIEMENS MED OCS TRANS MATRIX': {
        '0039xx80': ('DS', '5', 'Transformation Matrix', ''),
    },
    'SIEMENS MED SMS USG ANTARES': {
        '0019xx00': ('SH', '1', 'Private Creator Version', ''),
        '0019xx03': ('UN', '1', 'Frame Rate', ''),
        '0019xx0C': ('US', '1', 'Burned in Graphics', ''),
        '0019xx0D': ('UN', '1', 'SieClear Index', ''),
        '0019xx20': ('UN', '1', 'B-Mode Submode', ''),
        '0019xx21': ('UN', '1', 'B-Mode Dynamic Range', ''),
        '0019xx22': ('UN', '1', 'B-Mode Overall Gain', ''),
        '0019xx23': ('UN', '1', 'B-Mode Res/Speed Index', ''),
        '0019xx24': ('UN', '1', 'B-Mode Edge Enhance Index', ''),
        '0019xx25': ('UN', '1', 'B-Mode Persistence Index', ''),
        '0019xx26': ('UN', '1', 'B-Mode Map Index', ''),
        '0019xx27': ('US', '1', '???', ''),
        '0019xx28': ('US', '1', '???', ''),
        '0019xx29': ('US', '1', '???', ''),
        '0019xx2A': ('US', '1', 'B-Mode Tint Type', ''),
        '0019xx2D': ('UN', '1', 'B-Mode Tint Index', ''),
        '0019xx2E': ('UN', '1', 'ClarifyVE Index', ''),
        '0019xx31': ('US', '1', 'Unknown', ''),
        '0019xx3A': ('UN', '1', 'Image Flag', ''),
        '0019xx3B': ('LT', '1', 'Unknown', ''),
        '0019xx40': ('UN', '1', 'Color Flow state', ''),
        '0019xx41': ('UN', '1', 'Color Flow Wall Filter Index', ''),
        '0019xx42': ('UN', '1', 'Color Flow Submode', ''),
        '0019xx43': ('UN', '1', 'Color Flow Overall Gain', ''),
        '0019xx44': ('UN', '1', 'Color Flow Res/Speed Index', ''),
        '0019xx46': ('UN', '1', 'Color Flow Smooth Index', ''),
        '0019xx47': ('UN', '1', 'Color Flow Persistence Index', ''),
        '0019xx48': ('UN', '1', 'Color Flow Map Index', ''),
        '0019xx49': ('UN', '1', 'Color Flow Priority Index', ''),
        '0019xx54': ('UN', '1', 'Color Flow Maximum Velocity', ''),
        '0019xx60': ('UN', '1', 'Doppler Dynamic Range', ''),
        '0019xx61': ('UN', '1', 'Doppler Overall Gain', ''),
        '0019xx62': ('UN', '1', 'Doppler Wall Filter', ''),
        '0019xx63': ('UN', '1', 'Doppler Gate Size', ''),
        '0019xx65': ('UN', '1', 'Doppler Map Index', ''),
        '0019xx66': ('UN', '1', 'Doppler Submode', ''),
        '0019xx67': ('US', '1', 'Unknown', ''),
        '0019xx69': ('UN', '1', 'Doppler Time/Freq Res Index', ''),
        '0019xx6A': ('US', '1', 'Doppler Trace Inverted', ''),
        '0019xx6C': ('US', '1', 'Doppler Tint Type', ''),
        '0019xx72': ('UN', '1', 'Doppler Tint Index', ''),
        '0019xx80': ('UN', '1', 'M-Mode Dynamic Range', ''),
        '0019xx81': ('UN', '1', 'M-Mode Overall Gain', ''),
        '0019xx82': ('UN', '1', 'M-Mode Edge Enhance Index', ''),
        '0019xx83': ('UN', '1', 'M-Mode Map Index', ''),
        '0019xx86': ('UN', '1', 'M-Mode Tint Type', ''),
        '0019xx87': ('UN', '1', 'M-Mode Submode', ''),
        '0019xx88': ('UN', '1', 'M-Mode Tint Index', ''),
        '0019xxA0': ('LT', '1', 'Unknown', ''),
    },
    'SIEMENS MED SMS USG ANTARES 3D VOLUME': {
        '0039xx00': ('UN', '1', 'Release Version', ''),
        '0039xx03': ('UN', '1', 'VolumeAcquisitionDuration', ''),
        '0039xx04': ('UN', '1', 'VolumeRawDataType', ''),
        '0039xx05': ('UN', '1', 'ScanType', ''),
        '0039xx06': ('UN', '1', 'ZlateralMin', ''),
        '0039xx07': ('UN', '1', 'ZlateralSpan', ''),
        '0039xx08': ('UN', '1', 'ZRadiusOfCurvature', ''),
        '0039xx09': ('UN', '1', 'WobbleCorrection', ''),
        '0039xx10': ('UN', '1', 'ScaleAlongWidth', ''),
        '0039xx11': ('UN', '1', 'ScaleAlongHeight', ''),
        '0039xx12': ('UN', '1', 'ScaleAlongDepth', ''),
        '0039xx13': ('UN', '1', 'BufferSize', ''),
        '0039xx14': ('UN', '1', 'AcquisitionRate', ''),
        '0039xx15': ('UN', '1', 'DepthMinCm', ''),
        '0039xx16': ('UN', '1', 'IsLeftRightFlippedEn', ''),
        '0039xx17': ('UN', '1', 'IsUpDownFlippedEn', ''),
        '0039xx18': ('UN', '1', 'IsVolumeGeomAccurate', ''),
        '0039xx19': ('UN', '1', 'BByteMaskOffset', ''),
        '0039xx20': ('UN', '1', 'BByteMaskSize', ''),
        '0039xx21': ('UN', '1', 'DepthMaxCm', ''),
        '0039xx22': ('UN', '1', 'AcqPlaneRotationDeg', ''),
        '0039xx23': ('UN', '1', 'BeamAxialSpan', ''),
        '0039xx24': ('UN', '1', 'BeamLateralMin', ''),
        '0039xx25': ('UN', '1', 'BeamLateralSpan', ''),
        '0039xx26': ('UN', '1', 'BeamAxialMin', ''),
        '0039xx27': ('UN', '1', 'NumDisplaySamples', ''),
        '0039xx28': ('UN', '1', 'DVolumeWidth', ''),
        '0039xx29': ('UN', '1', 'DVolumeDepth', ''),
        '0039xx30': ('UN', '1', 'DVolumeHeight', ''),
        '0039xx31': ('UN', '1', 'DVolumePosX', ''),
        '0039xx32': ('UN', '1', 'DVolumePosY', ''),
        '0039xx33': ('UN', '1', 'DVolumePosZ', ''),
        '0039xx34': ('UN', '1', 'DBeamAxialMin', ''),
        '0039xx35': ('UN', '1', 'DBeamAxialSpan', ''),
        '0039xx36': ('UN', '1', 'DBeamLateralMin', ''),
        '0039xx37': ('UN', '1', 'DBeamLateralSpan', ''),
        '0039xx38': ('UN', '1', 'NumOfVolumesInSequence', ''),
        '0039xx39': ('UN', '1', 'DByteMaskOffset', ''),
        '0039xx40': ('UN', '1', 'DByteMaskSize', ''),
        '0039xx50': ('UN', '1', 'PrivateCreatorVersionOfBookmark', ''),
        '0039xx51': ('UN', '1', 'BCutPlaneEnable', ''),
        '0039xx52': ('UN', '1', 'BMprColorMapIndex', ''),
        '0039xx53': ('UN', '1', 'BMprDynamicRangeDb', ''),
        '0039xx54': ('UN', '1', 'BMprGrayMapIndex', ''),
        '0039xx55': ('UN', '1', 'BVolumeRenderMode', ''),
        '0039xx56': ('UN', '1', 'BVrBrightness', ''),
        '0039xx57': ('UN', '1', 'BVrContrast', ''),
        '0039xx58': ('UN', '1', 'BVrColorMapIndex', ''),
        '0039xx59': ('UN', '1', 'BVrDynamicRangeDb', ''),
        '0039xx5A': ('UN', '1', 'BVrGrayMapIndex', ''),
        '0039xx5B': ('UN', '1', 'BVrOpacity', ''),
        '0039xx5C': ('UN', '1', 'BVrThresholdHigh', ''),
        '0039xx5D': ('UN', '1', 'BVrThresholdLow', ''),
        '0039xx5E': ('UN', '1', 'BPreProcessFilterMix', ''),
        '0039xx5F': ('UN', '1', 'CCutPlaneEnable', ''),
        '0039xx60': ('UN', '1', 'CFrontClipMode', ''),
        '0039xx61': ('UN', '1', 'CMprColorMapIndex', ''),
        '0039xx62': ('UN', '1', 'CMprColorFlowPriorityIndex', ''),
        '0039xx63': ('UN', '1', 'CVolumeRenderMode', ''),
        '0039xx64': ('UN', '1', 'CVrColorMapIndex', ''),
        '0039xx65': ('UN', '1', 'CVrColorFlowPriorityIndex', ''),
        '0039xx66': ('UN', '1', 'CVrOpacity', ''),
        '0039xx67': ('UN', '1', 'CVrThresholdHigh', ''),
        '0039xx68': ('UN', '1', 'CVrThresholdLow', ''),
        '0039xx69': ('UN', '1', 'VoiMode', ''),
        '0039xx6A': ('UN', '1', 'VoiRotationOffsetDeg', ''),
        '0039xx6B': ('UN', '1', 'VoiSizeRatioX', ''),
        '0039xx6C': ('UN', '1', 'VoiSizeRatioY', ''),
        '0039xx6D': ('UN', '1', 'VoiSizeRatioZ', ''),
        '0039xx6E': ('UN', '1', 'VoiSyncPlane', ''),
        '0039xx6F': ('UN', '1', 'VoiViewMode', ''),
        '0039xx70': ('UN', '1', 'VrOrientationA', ''),
        '0039xx71': ('UN', '1', 'MprOrientationA', ''),
        '0039xx72': ('UN', '1', 'VrOffsetVector', ''),
        '0039xx73': ('UN', '1', 'BlendingRatio', ''),
        '0039xx74': ('UN', '1', 'FusionBlendMode', ''),
        '0039xx75': ('UN', '1', 'QualityFactor', ''),
        '0039xx76': ('UN', '1', 'RendererType', ''),
        '0039xx77': ('UN', '1', 'SliceMode', ''),
        '0039xx78': ('UN', '1', 'ActiveQuad', ''),
        '0039xx79': ('UN', '1', 'ScreenMode', ''),
        '0039xx7A': ('UN', '1', 'CutPlaneSide', ''),
        '0039xx7B': ('UN', '1', 'WireframeMode', ''),
        '0039xx7C': ('UN', '1', 'CrossmarkMode', ''),
        '0039xx7D': ('UN', '1', 'MprDisplayType', ''),
        '0039xx7E': ('UN', '1', 'VolumeDisplayType', ''),
        '0039xx7F': ('UN', '1', 'LastReset', ''),
        '0039xx80': ('UN', '1', 'LastNonFullScreenMode', ''),
        '0039xx81': ('UN', '1', 'MprToolIndex', ''),
        '0039xx82': ('UN', '1', 'VoiToolIndex', ''),
        '0039xx83': ('UN', '1', 'ToolLoopMode', ''),
        '0039xx84': ('UN', '1', 'VolumeArbMode', ''),
        '0039xx85': ('UN', '1', 'MprZoomEn', ''),
        '0039xx86': ('UN', '1', 'IsVolumeZoomEn', ''),
        '0039xx87': ('UN', '1', 'ZoomLevelMpr', ''),
        '0039xx88': ('UN', '1', 'ZoomLevelVolume', ''),
        '0039xx89': ('UN', '1', 'IsAutoRotateEn', ''),
        '0039xx8A': ('UN', '1', 'AutoRotateAxis', ''),
        '0039xx8B': ('UN', '1', 'AutoRotateRangeIndex', ''),
        '0039xx8C': ('UN', '1', 'AutoRotateSpeedIndex', ''),
        '0039xx8D': ('UN', '1', 'CVrBrightness', ''),
        '0039xx8E': ('UN', '1', 'CFlowStateIndex', ''),
        '0039xx8F': ('UN', '1', 'BSubmodeIndex', ''),
        '0039xx90': ('UN', '1', 'CSubmodeIndex', ''),
        '0039xx91': ('UN', '1', 'DICOMAttrNameCutPlane', ''),
        '0039xx92': ('UN', '1', 'BookmarkChunkId', ''),
        '0039xx93': ('UN', '1', 'SequenceMinChunkId', ''),
        '0039xx94': ('UN', '1', 'SequenceMaxChunkId', ''),
        '0039xx95': ('UN', '1', 'VolumeRateHz', ''),
        '0039xx9A': ('UN', '1', 'VoiPositionOffsetX', ''),
        '0039xx9B': ('UN', '1', 'VoiPositionOffsetY', ''),
        '0039xx9C': ('UN', '1', 'VoiPositionOffsetZ', ''),
        '0039xx9D': ('UN', '1', 'VrToolIndex', ''),
        '0039xx9E': ('UN', '1', 'ShadingPercent', ''),
        '0039xx9F': ('UN', '1', 'VolumeType', ''),
        '0039xxA0': ('UN', '1', 'DICOMAttrNameVrQuadDisplayType', ''),
        '0039xxA1': ('UN', '1', 'DICOMAttrNameMprCenterLocation', ''),
        '0039xxE0': ('UN', '1', 'DICOMAttrNameSliceRangeType', ''),
        '0039xxE1': ('UN', '1', 'DICOMAttrNameSliceMPRPlane', ''),
        '0039xxE2': ('UN', '1', 'DICOMAttrNameSliceLayout', ''),
        '0039xxE3': ('UN', '1', 'DICOMAttrNameSliceSpacing', ''),
        '0039xxE4': ('UN', '1', 'DICOMAttrNameThinVrMode', ''),
        '0039xxE5': ('UN', '1', 'DICOMAttrNameThinVrThickness', ''),
        '0039xxE6': ('UN', '1', 'DICOMAttrNameVoiPivotX', ''),
        '0039xxE7': ('UN', '1', 'DICOMAttrNameVoiPivotY', ''),
        '0039xxE8': ('UN', '1', 'DICOMAttrNameVoiPivotZ', ''),
        '0039xxE9': ('UN', '1', 'DICOMAttrNameCTopVoiQuad', ''),
    },
    'SIEMENS MED SMS USG S2000': {
        '0019xx00': ('UN', '1', 'Private Creator Version', ''),
        '0019xx03': ('FD', '1', 'Frame Rate', ''),
        '0019xx0C': ('US', '1', 'Burned in Graphics', ''),
        '0019xx0D': ('SH', '1', 'SieClear Index', ''),
        '0019xx20': ('SH', '1', 'B-Mode Submode', ''),
        '0019xx21': ('FD', '1', 'B-Mode Dynamic Range', ''),
        '0019xx22': ('FD', '1', 'B-Mode Overall Gain', ''),
        '0019xx23': ('US', '1', 'B-Mode Res/Speed Index', ''),
        '0019xx24': ('US', '1', 'B-Mode Edge Enhance Index', ''),
        '0019xx25': ('US', '1', 'B-Mode Persistence Index', ''),
        '0019xx26': ('US', '1', 'B-Mode Map Index', ''),
        '0019xx27': ('US', '1', '??', ''),
        '0019xx28': ('US', '1', '??', ''),
        '0019xx29': ('US', '1', '??', ''),
        '0019xx2A': ('US', '1', 'B-Mode Tint Type', ''),
        '0019xx2D': ('US', '1', 'B-Mode Tint Index', ''),
        '0019xx2E': ('SH', '1', 'ClarifyVE Index', ''),
        '0019xx3A': ('UN', '1', 'Image Flag', ''),
        '0019xx3B': ('LT', '1', 'IPDA/MDA Data', ''),
        '0019xx3C': ('UT', '1', 'Thumbnail Data', ''),
        '0019xx40': ('UN', '1', 'Color Flow state', ''),
        '0019xx41': ('UN', '1', 'Color Flow Wall Filter Index', ''),
        '0019xx42': ('UN', '1', 'Color Flow Submode', ''),
        '0019xx43': ('UN', '1', 'Color Flow Overall Gain', ''),
        '0019xx44': ('UN', '1', 'Color Flow Res/Speed Index', ''),
        '0019xx46': ('UN', '1', 'Color Flow Smooth Index', ''),
        '0019xx47': ('UN', '1', 'Color Flow Persistence Index', ''),
        '0019xx48': ('UN', '1', 'Color Flow Map Index', ''),
        '0019xx49': ('UN', '1', 'Color Flow Priority Index', ''),
        '0019xx54': ('UN', '1', 'Color Flow Maximum Velocity', ''),
        '0019xx60': ('UN', '1', 'Doppler Dynamic Range', ''),
        '0019xx61': ('UN', '1', 'Doppler Overall Gain', ''),
        '0019xx62': ('UN', '1', 'S2000 Private Doppler Wall Filter', ''),
        '0019xx63': ('UN', '1', 'Attributes Doppler Gate Size', ''),
        '0019xx65': ('UN', '1', 'Doppler Map Index', ''),
        '0019xx66': ('UN', '1', 'Doppler Submode', ''),
        '0019xx69': ('UN', '1', 'Doppler Time/Freq Res Index', ''),
        '0019xx6A': ('UN', '1', 'Doppler Trace Inverted', ''),
        '0019xx6C': ('UN', '1', 'Doppler Tint Type', ''),
        '0019xx72': ('UN', '1', 'Doppler Tint Index', ''),
        '0019xx80': ('UN', '1', 'M-Mode Dynamic Range', ''),
        '0019xx81': ('UN', '1', 'M-Mode Overall Gain', ''),
        '0019xx82': ('UN', '1', 'M-Mode Edge Enhance Index', ''),
        '0019xx83': ('UN', '1', 'M-Mode Map Index', ''),
        '0019xx86': ('UN', '1', 'M-Mode Tint Type', ''),
        '0019xx87': ('UN', '1', 'M-Mode Submode', ''),
        '0019xx88': ('UN', '1', 'M-Mode Tint Index', ''),
    },
    'SIEMENS MED SP DXMG WH AWS 1': {
        '0019xx01': ('UL', '1-n', 'Unknown', ''),
        '0019xx02': ('US', '2', 'Unknown', ''),
        '0041xx02': ('SH', '1', 'Reason for the Requested Procedure', ''),
        '0055xx01': ('LO', '1', 'Projection View Display String', ''),
    },
    'SIEMENS MEDCOM HEADER': {
        '0029xx08': ('CS', '1', 'MedCom Header Type', ''),
        '0029xx09': ('LO', '1', 'MedCom Header Version', ''),
        '0029xx10': ('OB', '1', 'MedCom Header Info', ''),
        '0029xx20': ('OB', '1', 'MedCom History Information', ''),
        '0029xx31': ('LO', '1', 'PMTF Information 1', ''),
        '0029xx32': ('UL', '1', 'PMTF Information 2', ''),
        '0029xx33': ('UL', '1', 'PMTF Information 3', ''),
        '0029xx34': ('CS', '1', 'PMTF Information 4', ''),
        '0029xx35': ('UL', '1', 'PMTF Information 5', ''),
        '0029xx40': ('SQ', '1', 'Application Header Sequence', ''),
        '0029xx41': ('CS', '1', 'Application Header Type', ''),
        '0029xx42': ('LO', '1', 'Application Header ID', ''),
        '0029xx43': ('LO', '1', 'Application Header Version', ''),
        '0029xx44': ('OB', '1', 'Application Header Info', ''),
        '0029xx50': ('LO', '8', 'Workflow Control Flags', ''),
        '0029xx51': ('CS', '1', 'Arch. Management Flag Keep Online', ''),
        '0029xx52': ('CS', '1', 'Arch. Mgmnt Flag Do Not Archive', ''),
        '0029xx53': ('CS', '1', 'Image Location Status', ''),
        '0029xx54': ('DS', '1', 'Estimated Retrieve Time', ''),
        '0029xx55': ('DS', '1', 'Data Size of Retrieved Images', ''),
        '0029xx70': ('SQ', '1', 'Siemens Link Sequence', ''),
        '0029xx71': ('AT', '1', 'Referenced Tag', ''),
        '0029xx72': ('CS', '1', 'Referenced Tag Type', ''),
        '0029xx73': ('UL', '1', 'Referenced Value Length', ''),
        '0029xx74': ('CS', '1', 'Referenced Object Device Type', ''),
        '0029xx75': ('OB', '1', 'Referenced Object Device Location', ''),
        '0029xx76': ('OB', '1', 'Referenced Object ID', ''),
    },
    'SIEMENS MEDCOM HEADER2': {
        '0029xx60': ('LO', '1', 'Series Workflow Status', ''),
    },
    'SIEMENS MEDCOM OOG': {
        '0029xx08': ('CS', '1', 'MedCom OOG Type', ''),
        '0029xx09': ('LO', '1', 'MedCom OOG Version', ''),
        '0029xx10': ('OB', '1', 'MedCom OOG Info', ''),
    },
    'SIEMENS MR EXTRACTED CSA HEADER': {
        '00250001': ('SQ', '1', 'Unknown', ''),
        '00250002': ('LO', '1', 'Unknown', ''),
        '00250003': ('AT', '1', 'Unknown', ''),
        '00250004': ('SS', '1', 'Unknown', ''),
    },
    'SIEMENS MR FMRI': {
        '00210010': ('SQ', '1', 'Unknown', ''),
        '00210011': ('LO', '1', 'Unknown', ''),
        '00210012': ('SQ', '1', 'Unknown', ''),
        '00210013': ('US', '1', 'Unknown', ''),
        '00210014': ('SQ', '1', 'Unknown', ''),
        '00210015': ('US', '1', 'Unknown', ''),
        '00210016': ('LO', '1', 'Unknown', ''),
        '00210017': ('US', '1', 'Unknown', ''),
        '00210018': ('UL', '1', 'Unknown', ''),
        '00210019': ('FL', '1', 'Unknown', ''),
        '00210031': ('SQ', '1', 'Unknown', ''),
        '00210040': ('SQ', '1', 'Unknown', ''),
        '00210041': ('LO', '1', 'Unknown', ''),
        '00210042': ('SQ', '1', 'Unknown', ''),
        '00210043': ('LO', '1', 'Unknown', ''),
        '00210044': ('US', '1', 'Unknown', ''),
        '00210045': ('LO', '1-n', 'Unknown', ''),
        '00210046': ('SQ', '1', 'Unknown', ''),
        '00210047': ('UL', '1', 'Unknown', ''),
        '00210048': ('LO', '1', 'Unknown', ''),
        '00210049': ('FD', '1', 'Unknown', ''),
        '0021004A': ('FD', '1-n', 'Unknown', ''),
        '0021004B': ('FL', '1', 'Unknown', ''),
    },
    'SIEMENS MR HEADER': {
        '0019xx08': ('CS', '1', 'CSA Image Header Type', ''),
        '0019xx09': ('LO', '1', 'CSA Image Header Version ??', ''),
        '0019xx0A': ('US', '1', 'NumberOfImagesInMosaic', ''),
        '0019xx0B': ('DS', '1', 'SliceMeasurementDuration', ''),
        '0019xx0C': ('IS', '1', 'B_value', ''),
        '0019xx0D': ('CS', '1', 'DiffusionDirectionality', ''),
        '0019xx0E': ('FD', '3', 'DiffusionGradientDirection', ''),
        '0019xx0F': ('SH', '1', 'GradientMode', ''),
        '0019xx11': ('SH', '1', 'FlowCompensation', ''),
        '0019xx12': ('SL', '3', 'TablePositionOrigin', ''),
        '0019xx13': ('SL', '3', 'ImaAbsTablePosition', ''),
        '0019xx14': ('IS', '3', 'ImaRelTablePosition', ''),
        '0019xx15': ('FD', '3', 'SlicePosition_PCS', ''),
        '0019xx16': ('DS', '1', 'TimeAfterStart', ''),
        '0019xx17': ('DS', '1', 'SliceResolution', ''),
        '0019xx18': ('IS', '1', 'RealDwellTime', ''),
        '0019xx23': ('IS', '1', 'FMRIStimulInfo', ''),
        '0019xx25': ('FD', '3', 'RBMoCoTrans', ''),
        '0019xx26': ('FD', '3', 'RBMoCoRot', ''),
        '0019xx27': ('FD', '6', 'B_matrix', ''),
        '0019xx28': ('FD', '1', 'BandwidthPerPixelPhaseEncode', ''),
        '0019xx29': ('FD', '1', 'MosaicRefAcqTimes', ''),
        '0051xx08': ('CS', '1', 'CSA Image Header Type', ''),
        '0051xx09': ('LO', '1', 'CSA Image Header Version ??', ''),
        '0051xx0A': ('SH', '1', 'Unknown', ''),
        '0051xx0B': ('SH', '1', 'AcquisitionMatrixText', ''),
        '0051xx0C': ('SH', '1', 'Unknown', ''),
        '0051xx0D': ('SH', '1', 'Unknown', ''),
        '0051xx0E': ('SH', '1', 'Unknown', ''),
        '0051xx0F': ('LO', '1', 'CoilString', ''),
        '0051xx11': ('LO', '1', 'PATModeText', ''),
        '0051xx12': ('SH', '1', 'Unknown', ''),
        '0051xx13': ('SH', '1', 'PositivePCSDirections', ''),
        '0051xx15': ('SH', '1', 'Unknown', ''),
        '0051xx16': ('LO', '1', 'Unknown', ''),
        '0051xx17': ('SH', '1', 'Unknown', ''),
        '0051xx18': ('SH', '1', 'Unknown', ''),
        '0051xx19': ('LO', '1', 'Unknown', ''),
    },
    'SIEMENS MR SDI 02': {
        '00210023': ('UN', '1', 'Unknown', ''),
        '00210046': ('UN', '1', 'Unknown', ''),
        '00210067': ('UN', '1', 'Unknown', ''),
        '00210068': ('UN', '1', 'Unknown', ''),
        '00210089': ('UN', '1', 'Unknown', ''),
    },
    'SIEMENS MR SDS 01': {
        '0021003F': ('UN', '1', 'Unknown', ''),
    },
    'SIEMENS MR VA0  COAD': {
        '0019xx12': ('DS', '1', 'Magnetic Field Strength', ''),
        '0019xx14': ('DS', '1', 'ADC Voltage', ''),
        '0019xx16': ('DS', '1-n', 'ADC Offset', ''),
        '0019xx20': ('DS', '1', 'Transmitter Amplitude', ''),
        '0019xx21': ('IS', '1', 'Number of Transmitter Amplitudes', ''),
        '0019xx22': ('DS', '1', 'Transmitter Attenuator', ''),
        '0019xx24': ('DS', '1', 'Transmitter Calibration', ''),
        '0019xx26': ('DS', '1', 'Transmitter Reference', ''),
        '0019xx50': ('DS', '1', 'Receiver Total Gain', ''),
        '0019xx51': ('DS', '1', 'Receiver Amplifier Gain', ''),
        '0019xx52': ('DS', '1', 'Receiver Preamplifier Gain', ''),
        '0019xx54': ('DS', '1', 'Receiver Cable Attenuation', ''),
        '0019xx55': ('DS', '1', 'Receiver Reference Gain', ''),
        '0019xx56': ('IS', '1', 'Receiver Filter Frequency', ''),
        '0019xx60': ('DS', '1', 'Reconstruction Scale Factor', ''),
        '0019xx62': ('DS', '1', 'Reference Scale Factor', ''),
        '0019xx70': ('DS', '1', 'Phase Gradient Amplitude', ''),
        '0019xx71': ('DS', '1', 'Readout Gradient Amplitude', ''),
        '0019xx72': ('DS', '1', 'Selection Gradient Amplitude', ''),
        '0019xx80': ('DS', '1-n', 'Gradient Delay Time', ''),
        '0019xx82': ('DS', '1', 'Total Gradient Delay Time', ''),
        '0019xx90': ('LO', '1', 'Sensitivity Correction Label', ''),
        '0019xx91': ('DS', '1-5', 'Saturation Phase Encoding Vector Coronal Component', ''),
        '0019xx92': ('DS', '1-5', 'Saturation Readout Vector Coronal Component', ''),
        '0019xxA0': ('IS', '1', 'RF Watchdog Mask', ''),
        '0019xxA1': ('DS', '1', 'EPI Reconstruction Slope', ''),
        '0019xxA2': ('DS', '1', 'RF Power Error Indicator', ''),
        '0019xxA5': ('DS', '1-n', 'Specific Absorption Rate SAR', ''),
        '0019xxA6': ('DS', '1-n', 'Specific Energy Dose SED', ''),
        '0019xxB0': ('UL', '1', 'Adjustment Status Mask', ''),
        '0019xxC1': ('DS', '1-n', 'EPI Capacity', ''),
        '0019xxC2': ('DS', '1-n', 'EPI Inductance', ''),
        '0019xxC3': ('IS', '1-n', 'EPI Switch Configuration Code', ''),
        '0019xxC4': ('IS', '1-n', 'EPI Switch Hardware Code', ''),
        '0019xxC5': ('DS', '1-n', 'EPI Switch Delay Time', ''),
        '0019xxD1': ('DS', '1', 'Flow Sensitivity', ''),
        '0019xxD2': ('CS', '1', 'Calculation Submode', ''),
        '0019xxD3': ('DS', '1', 'Field of View Ratio', ''),
        '0019xxD4': ('IS', '1', 'Base Raw Matrix Size', ''),
        '0019xxD5': ('IS', '1', '2D Phase Oversampling Lines', ''),
        '0019xxD6': ('IS', '1', '3D Phase Oversampling Part', ''),
        '0019xxD7': ('IS', '1', 'Echo Line Position', ''),
        '0019xxD8': ('IS', '1', 'Echo Column Position', ''),
        '0019xxD9': ('IS', '1', 'Lines per Segment', ''),
        '0019xxDA': ('CS', '1', 'Phase Coding Direction', ''),
    },
    'SIEMENS MR VA0  GEN': {
        '0019xx10': ('DS', '1', 'Total Measurement Time nominal', ''),
        '0019xx11': ('DS', '1', 'Total Measurement Time current', ''),
        '0019xx12': ('DS', '1', 'Start Delay Time', ''),
        '0019xx13': ('DS', '1', 'Dwell Time', ''),
        '0019xx14': ('IS', '1', 'Number of Phases', ''),
        '0019xx16': ('UL', '1-n', 'Sequence Control Mask', ''),
        '0019xx18': ('UL', '1', 'Measurement Status Mask', ''),
        '0019xx20': ('IS', '1', 'Number of Fourier Lines nominal', ''),
        '0019xx21': ('IS', '1', 'Number of Fourier Lines current', ''),
        '0019xx26': ('IS', '1', 'Number of Fourier Lines after Zero', ''),
        '0019xx28': ('IS', '1', 'First Measured Fourier Line', ''),
        '0019xx30': ('IS', '1', 'Acquisition Columns', ''),
        '0019xx31': ('IS', '1', 'Reconstruction Columns', ''),
        '0019xx40': ('IS', '1', 'AC Element Number', ''),
        '0019xx41': ('UL', '1', 'AC Element Select Mask', ''),
        '0019xx42': ('UL', '1', 'AC Element Data Mask', ''),
        '0019xx43': ('IS', '1-n', 'AC Element To ADC Connect', ''),
        '0019xx44': ('IS', '1-n', 'AC Element Noise Level', ''),
        '0019xx45': ('IS', '1', 'AC ADC Pair Number', ''),
        '0019xx46': ('UL', '1', 'AC Combination Mask', ''),
        '0019xx50': ('IS', '1', 'Number of Averages current', ''),
        '0019xx60': ('DS', '1', 'Flip Angle', ''),
        '0019xx70': ('IS', '1', 'Number of Prescans', ''),
        '0019xx81': ('CS', '1', 'Filter Type for Raw Data', ''),
        '0019xx82': ('DS', '1-4', 'Filter Parameter for Raw Data', ''),
        '0019xx83': ('CS', '1', 'Filter Type for Image Data', ''),
        '0019xx84': ('DS', '1-4', 'Filter Parameter for Image Data', ''),
        '0019xx85': ('CS', '1', 'Filter Type for Phase Correction', ''),
        '0019xx86': ('DS', '1-4', 'Filter Parameter for Phase Correction', ''),
        '0019xx87': ('CS', '1', 'Normalization Filter Type for Image Data', ''),
        '0019xx88': ('DS', '1-4', 'Normalization Filter Parameter for Image Data', ''),
        '0019xx90': ('IS', '1', 'Number of Saturation Regions', ''),
        '0019xx91': ('DS', '1-5', 'Saturation Phase Encoding Vector Sagittal Compo...', ''),
        '0019xx92': ('DS', '1-5', 'Saturation Readout Vector Sagittal Component', ''),
        '0019xx93': ('IS', '1', 'EPI Stimulation Monitor Mode', ''),
        '0019xx94': ('DS', '1', 'Image Rotation Angle', ''),
        '0019xx96': ('UL', '1-n', 'Coil ID Mask', ''),
        '0019xx97': ('UL', '1-n', 'Coil Class Mask', ''),
        '0019xx98': ('DS', '1-n', 'Coil Position', ''),
        '0019xxA0': ('DS', '1', 'EPI Reconstruction Phase', ''),
        '0019xxA1': ('DS', '1', 'EPI Reconstruction Slope', ''),
        '0021xx20': ('IS', '1', 'Phase Corrections Rows sequence', ''),
        '0021xx21': ('IS', '1', 'Phase Corrections Columns sequence', ''),
        '0021xx22': ('IS', '1', 'Phase Corrections Rows reconstruction', ''),
        '0021xx24': ('IS', '1', 'Phase Corrections Columns reconstruction', ''),
        '0021xx30': ('IS', '1', 'Number of 3D Raw Partitions nominal', ''),
        '0021xx31': ('IS', '1', 'Number of 3D Raw Partitions current', ''),
        '0021xx34': ('IS', '1', 'Number of 3D Image Partitions', ''),
        '0021xx36': ('IS', '1', 'Actual 3D Image Partition Number', ''),
        '0021xx39': ('DS', '1', 'Slab Thickness', ''),
        '0021xx40': ('IS', '1', 'Number of Slices nominal', ''),
        '0021xx41': ('IS', '1', 'Number of Slices current', ''),
        '0021xx42': ('IS', '1', 'Current Slice Number', ''),
        '0021xx43': ('IS', '1', 'Current Group Number', ''),
        '0021xx44': ('DS', '1', 'Current Slice Distance Factor', ''),
        '0021xx45': ('IS', '1', 'MIP Start Row', ''),
        '0021xx46': ('IS', '1', 'MIP Stop Row', ''),
        '0021xx47': ('IS', '1', 'MIP Start Column', ''),
        '0021xx48': ('IS', '1', 'MIP Stop Column', ''),
        '0021xx49': ('IS', '1', 'MIP Start Slice', ''),
        '0021xx4A': ('IS', '1', 'MIP Stop Slice', ''),
        '0021xx4F': ('CS', '1', 'Order of Slices', ''),
        '0021xx50': ('UL', '1', 'Signal Mask', ''),
        '0021xx52': ('IS', '1', 'Delay after Trigger', ''),
        '0021xx53': ('IS', '1', 'RRInterval', ''),
        '0021xx54': ('DS', '1', 'Number of Trigger Pulses', ''),
        '0021xx56': ('DS', '1', 'Repetition Time effective', ''),
        '0021xx57': ('CS', '1', 'Gate Phase', ''),
        '0021xx58': ('DS', '1', 'Gate Threshold', ''),
        '0021xx59': ('DS', '1', 'Gated Ratio', ''),
        '0021xx60': ('IS', '1', 'Number of Interpolated Images', ''),
        '0021xx70': ('IS', '1', 'Number of Echoes', ''),
        '0021xx72': ('DS', '1', 'Second Echo Time', ''),
        '0021xx73': ('DS', '1', 'Second Repetition Time', ''),
        '0021xx80': ('IS', '1', 'Cardiac Code', ''),
        '0021xx91': ('DS', '1-n', 'Saturation Phase Encoding Vector Transversal Co...', ''),
        '0021xx92': ('DS', '1-n', 'Saturation Readout Vector Transversal Component', ''),
        '0021xx93': ('DS', '1', 'EPI Change Value of Magnitude', ''),
        '0021xx94': ('DS', '1', 'EPI Change Value of X Component', ''),
        '0021xx95': ('DS', '1', 'EPI Change Value of Y Component', ''),
        '0021xx96': ('DS', '1', 'EPI Change Value of Z Component', ''),
    },
    'SIEMENS MR VA0  RAW': {
        '0021xx00': ('CS', '1', 'Sequence Type', ''),
        '0021xx01': ('IS', '1', 'Vector Size original', ''),
        '0021xx02': ('IS', '1', 'Vector Size extended', ''),
        '0021xx03': ('DS', '1', 'Acquired Spectral Range', ''),
        '0021xx04': ('DS', '1-n', 'VOI Position', ''),
        '0021xx05': ('DS', '1-n', 'VOI Size', ''),
        '0021xx06': ('IS', '1-n', 'CSI Matrix Size original', ''),
        '0021xx07': ('IS', '1-n', 'CSI Matrix Size extended', ''),
        '0021xx08': ('DS', '1-n', 'Spatial Grid Shift', ''),
        '0021xx09': ('DS', '1', 'Signal Limits Minimum', ''),
        '0021xx10': ('DS', '1', 'Signal Limits Maximum', ''),
        '0021xx11': ('DS', '1', 'Spec Info Mask', ''),
        '0021xx12': ('DS', '1', 'EPI Time Rate of Change of Magnitude', ''),
        '0021xx13': ('DS', '1', 'EPI Time Rate of Change of X Component', ''),
        '0021xx14': ('DS', '1', 'EPI Time Rate of Change of Y Component', ''),
        '0021xx15': ('DS', '1', 'EPI Time Rate of Change of Z Component', ''),
        '0021xx16': ('DS', '1', 'EPI Time Rate of Change Legal Limit 1', ''),
        '0021xx17': ('IS', '1', 'EPI Operation Mode Flag', ''),
        '0021xx18': ('DS', '1', 'EPI Field Calculation Safety Factor', ''),
        '0021xx19': ('DS', '1', 'EPI Legal Limit 1 of Change Value', ''),
        '0021xx20': ('DS', '1', 'EPI Legal Limit 2 of Change Value', ''),
        '0021xx21': ('DS', '1', 'EPI Rise Time', ''),
        '0021xx30': ('DS', '1-n', 'AC ADC Offset', ''),
        '0021xx31': ('DS', '1-n', 'AC Preamplifier Gain', ''),
        '0021xx50': ('CS', '1', 'Saturation Type', ''),
        '0021xx51': ('DS', '1-n', 'Saturation Normal Vector', ''),
        '0021xx52': ('DS', '1-n', 'Saturation Position Vector', ''),
        '0021xx53': ('DS', '1-n', 'Saturation Thickness', ''),
        '0021xx54': ('DS', '1-n', 'Saturation Width', ''),
        '0021xx55': ('DS', '1-n', 'Saturation Distance', ''),
    },
    'SIEMENS NUMARIS II': {
        '7FE3xx00': ('LO', '1', 'Image Graphics Format Code', ''),
        '7FE3xx10': ('OB', '1', 'Image Graphics', ''),
        '7FE3xx20': ('OB', '1', 'Image Graphics Dummy', ''),
    },
    'SIEMENS RA GEN': {
        '0011xx20': ('UL', '1', 'Total Fluoro TimePatient', ''),
        '0011xx25': ('UL', '1', 'Dose Area ProductPatient', ''),
        '0011xx30': ('LO', '1', 'Patient DOB', ''),
        '0011xx35': ('LO', '1', 'Patient Initial Puck Counter', ''),
        '0011xx40': ('CS', '1', 'Patient Initial Position', ''),
        '0019xx15': ('CS', '1', 'Acquired Plane', ''),
        '0019xx20': ('UL', '1', 'Scene Flag', ''),
        '0019xx22': ('UL', '1', 'ReferencePhotofile Flag', ''),
        '0019xx24': ('LO', '1', 'Scene Name', ''),
        '0019xx26': ('US', '1', 'Acquisition Index', ''),
        '0019xx28': ('US', '1', 'Mixed Pulse Mode', ''),
        '0019xx2A': ('US', '1', 'Number of Positions', ''),
        '0019xx2C': ('US', '1', 'Number of Phases', ''),
        '0019xx2E': ('US', '1-n', 'Framerate for 8 Positions', ''),
        '0019xx30': ('US', '1-n', 'FramesPhase', ''),
        '0019xx32': ('US', '1', 'Stepping Direction', ''),
        '0019xx34': ('US', '1', 'Unknown', ''),
        '0019xx36': ('US', '1', 'Unknown', ''),
        '0019xx38': ('US', '1', 'Unknown', ''),
        '0019xx3A': ('US', '1', 'Unknown', ''),
        '0019xx3C': ('US', '1', 'Unknown', ''),
        '0019xx3E': ('US', '1', 'Unknown', ''),
        '0019xx40': ('US', '1', 'Unknown', ''),
        '0019xx42': ('US', '1', 'Unknown', ''),
        '0019xx44': ('US', '1', 'Image Transfer Delay', ''),
        '0019xx46': ('UL', '1', 'InversNot Invers', ''),
        '0019xx48': ('US', '1', 'Unknown', ''),
        '0019xx4A': ('US', '1', 'Unknown', ''),
        '0019xx4C': ('US', '1', 'Blanking Circle Diameter', ''),
        '0019xx50': ('US', '1', 'Stand Data Valid', ''),
        '0019xx52': ('US', '1', 'Table Tilt', ''),
        '0019xx54': ('US', '1', 'Table Axis Rotation', ''),
        '0019xx56': ('US', '1', 'Table Longitudinal Position', ''),
        '0019xx58': ('US', '1', 'Table Side Offset', ''),
        '0019xx5A': ('US', '1', 'Table Isocenter Height', ''),
        '0019xx5C': ('UN', '1', 'Unknown', ''),
        '0019xx5E': ('UL', '1', 'Collimation Data Valid', ''),
        '0019xx60': ('UL', '1', 'PERI Sequence Number', ''),
        '0019xx62': ('UL', '1', 'PERI Total Scenes', ''),
        '0019xx64': ('US', '1', 'PERI Overlap Top', ''),
        '0019xx66': ('UL', '1', 'PERI Overlap Bottom', ''),
        '0019xx68': ('UL', '1', 'Raw Image Number', ''),
        '0019xx6A': ('UL', '1', 'XRay Data Valid', ''),
        '0019xx70': ('US', '1-n', 'Unknown', ''),
        '0019xx72': ('US', '1-n', 'Unknown', ''),
        '0019xx74': ('US', '1-n', 'Unknown', ''),
        '0019xx76': ('UL', '1', 'Filling Average Factor', ''),
        '0019xx78': ('US', '1-n', 'Unknown', ''),
        '0019xx7A': ('US', '1-n', 'Unknown', ''),
        '0019xx7C': ('US', '1-n', 'Unknown', ''),
        '0019xx7E': ('US', '1-n', 'Unknown', ''),
        '0019xx80': ('US', '1-n', 'Unknown', ''),
        '0019xx82': ('US', '1-n', 'Unknown', ''),
        '0019xx84': ('US', '1-n', 'Unknown', ''),
        '0019xx86': ('US', '1-n', 'Unknown', ''),
        '0019xx88': ('US', '1-n', 'Unknown', ''),
        '0019xx8A': ('US', '1-n', 'Unknown', ''),
        '0019xx8C': ('US', '1-n', 'Unknown', ''),
        '0019xx8E': ('US', '1-n', 'Unknown', ''),
        '0019xx92': ('US', '1-n', 'Unknown', ''),
        '0019xx94': ('US', '1-n', 'Unknown', ''),
        '0019xx96': ('US', '1-n', 'Unknown', ''),
        '0019xx98': ('US', '1-n', 'Unknown', ''),
        '0019xx9A': ('US', '1-n', 'Unknown', ''),
        '0019xx9C': ('UL', '1', 'II Level CalibrationFactor', ''),
        '0019xx9E': ('UL', '1', 'Nativ Review Flag', ''),
        '0021xx15': ('US', '1', 'Images in Study', ''),
        '0021xx20': ('US', '1', 'Scenes in Study', ''),
        '0021xx25': ('US', '1', 'Images in Photofile', ''),
        '0021xx30': ('US', '1', 'Images in All Scenes', ''),
        '0021xx40': ('US', '1', 'Unknown', ''),
    },
    'SIEMENS RA PLANE A': {
        '0019xx20': ('UL', '1', 'System Calibration Factor Plane A', ''),
        '0019xx22': ('US', '1', 'XRay Parameter Set Number', ''),
        '0019xx24': ('US', '1', 'XRay System', ''),
        '0019xx26': ('US', '1', 'Unknown', ''),
        '0019xx28': ('US', '1', 'Acquired Display Mode', ''),
        '0019xx2A': ('US', '1', 'Unknown', ''),
        '0019xx2C': ('US', '1', 'Acquisition Framerate', ''),
        '0019xx2E': ('US', '1', 'Maximum Frame Limit', ''),
        '0019xx30': ('US', '1', 'Native Filter Type', ''),
        '0019xx32': ('US', '1', 'Subtracted Filter Type', ''),
        '0019xx34': ('US', '1', 'Filter Factor Native', ''),
        '0019xx36': ('US', '1', 'Anatomic Blackground Factor', ''),
        '0019xx38': ('US', '1', 'Window Upper Limit Native', ''),
        '0019xx3A': ('US', '1', 'Window Lower Limit Native', ''),
        '0019xx3C': ('US', '1', 'Window Brightness Phase 1 Sub', ''),
        '0019xx3E': ('US', '1', 'Window Brightness Phase 2 Sub', ''),
        '0019xx40': ('US', '1', 'Window Contrast Phase 1 Sub', ''),
        '0019xx42': ('US', '1', 'Window Contrast Phase 2 Sub', ''),
        '0019xx44': ('US', '1', 'Filter Factor Subtraction', ''),
        '0019xx46': ('US', '1', 'Peak Opacified', ''),
        '0019xx48': ('UL', '1', 'Mask Frame', ''),
        '0019xx4A': ('UL', '1', 'BIH Frame', ''),
        '0019xx4C': ('US', '1', 'Center Beam Angulation CaudCran', ''),
        '0019xx4E': ('US', '1', 'Center Beam Angulation LR Anterior', ''),
        '0019xx50': ('US', '1', 'Longitudinal Position', ''),
        '0019xx52': ('US', '1', 'Side Offset', ''),
        '0019xx54': ('US', '1', 'Isocenter Height', ''),
        '0019xx56': ('US', '1', 'Image Twist', ''),
        '0019xx58': ('US', '1', 'SourceImage Distance', ''),
        '0019xx5A': ('US', '1', 'Mechanical Magnet Factor', ''),
        '0019xx5C': ('UL', '1', 'Calibration Flag', ''),
        '0019xx5E': ('UL', '1', 'Calibration Angle CranCaud', ''),
        '0019xx60': ('UL', '1', 'Calibration Angle RAOLAO', ''),
        '0019xx62': ('UL', '1', 'Calibration Table to Floor Distance', ''),
        '0019xx64': ('UL', '1', 'Calibration Isocenter to Floor Distance', ''),
        '0019xx66': ('UL', '1', 'Calibration Isocenter to Source Distance', ''),
        '0019xx68': ('UL', '1', 'Calibration Source to II Distance', ''),
        '0019xx6A': ('UL', '1', 'Calibration II Zoom', ''),
        '0019xx6C': ('UL', '1', 'Calibration II Field', ''),
        '0019xx6E': ('UL', '1', 'Calibration Factor', ''),
        '0019xx70': ('UL', '1', 'Calibration Object to Image Distance', ''),
        '0019xx72': ('UL', '1-n', 'Calibration System Factor', ''),
        '0019xx74': ('UL', '1-n', 'Calibration System Correction', ''),
        '0019xx76': ('UL', '1-n', 'Calibration System II Formats', ''),
        '0019xx78': ('UL', '1', 'Calibration Gantry Data Valid', ''),
        '0019xx7A': ('US', '1', 'Collimator Square Breadth', ''),
        '0019xx7C': ('US', '1', 'Collimator Square Height', ''),
        '0019xx7E': ('US', '1', 'Collimator Square Diameter', ''),
        '0019xx80': ('US', '1', 'Collimator Finger Turn Angle', ''),
        '0019xx82': ('US', '1', 'Collimator Finger Position', ''),
        '0019xx84': ('US', '1', 'Collimator Diaphragm Turn Angle', ''),
        '0019xx86': ('US', '1', 'Collimator Diagphragm Position 1', ''),
        '0019xx88': ('US', '1', 'Collimator Diaphragm Position 2', ''),
        '0019xx8A': ('US', '1', 'Collimator Diaphragm Mode', ''),
        '0019xx8C': ('US', '1', 'Collimator Beam Limit Breadth', ''),
        '0019xx8E': ('US', '1', 'Collimator Beam Limit Height', ''),
        '0019xx90': ('US', '1', 'Collimator Beam Limit Diameter', ''),
        '0019xx92': ('US', '1', 'XRay Control Mode', ''),
        '0019xx94': ('US', '1', 'XRay System', ''),
        '0019xx96': ('US', '1', 'Focal Spot', ''),
        '0019xx98': ('US', '1', 'Exposure Control', ''),
        '0019xx9A': ('US', '1', 'XRay Voltage', ''),
        '0019xx9C': ('US', '1', 'XRay Current', ''),
        '0019xx9E': ('UL', '1', 'XRay Current Time Product', ''),
        '0019xxA0': ('US', '1', 'Pulse Time', ''),
        '0019xxA2': ('US', '1', 'Scene Time Fluoro Clock', ''),
        '0019xxA4': ('US', '1', 'Maximum PulseRate', ''),
        '0019xxA6': ('US', '1', 'Pulses per Scene', ''),
        '0019xxA8': ('UL', '1', 'Dose Area Product of Scene', ''),
        '0019xxAA': ('US', '1', 'Dose', ''),
        '0019xxAC': ('US', '1', 'Dose Rate', ''),
    },
    'SIEMENS RA PLANE B': {
        '0019xx20': ('UL', '1', 'System Calibration Factor Plane B', ''),
        '0019xx22': ('US', '1', 'XRay Parameter Set Number', ''),
        '0019xx24': ('US', '1', 'XRay System', ''),
        '0019xx26': ('US', '1', 'Unknown', ''),
        '0019xx28': ('US', '1', 'Acquired Display Mode', ''),
        '0019xx2A': ('US', '1', 'Unknown', ''),
        '0019xx2C': ('US', '1', 'Acquisition Framerate', ''),
        '0019xx2E': ('US', '1', 'Maximum Frame Limit', ''),
        '0019xx30': ('US', '1', 'Native Filter Type', ''),
        '0019xx32': ('US', '1', 'Subtracted Filter Type', ''),
        '0019xx34': ('US', '1', 'Filter Factor Native', ''),
        '0019xx36': ('US', '1', 'Anatomic Blackground Factor', ''),
        '0019xx38': ('US', '1', 'Window Upper Limit Native', ''),
        '0019xx3A': ('US', '1', 'Window Lower Limit Native', ''),
        '0019xx3C': ('US', '1', 'Window Brightness Phase 1 Sub', ''),
        '0019xx3E': ('US', '1', 'Window Brightness Phase 2 Sub', ''),
        '0019xx40': ('US', '1', 'Window Contrast Phase 1 Sub', ''),
        '0019xx42': ('US', '1', 'Window Contrast Phase 2 Sub', ''),
        '0019xx44': ('US', '1', 'Filter Factor Subtraction', ''),
        '0019xx46': ('US', '1', 'Peak Opacified', ''),
        '0019xx48': ('UL', '1', 'Mask Frame', ''),
        '0019xx4A': ('UL', '1', 'BIH Frame', ''),
        '0019xx4C': ('US', '1', 'Center Beam Angulation CaudCran', ''),
        '0019xx4E': ('US', '1', 'Center Beam Angulation LR Anterior', ''),
        '0019xx50': ('US', '1', 'Longitudinal Position', ''),
        '0019xx52': ('US', '1', 'Side Offset', ''),
        '0019xx54': ('US', '1', 'Isocenter Height', ''),
        '0019xx56': ('US', '1', 'Image Twist', ''),
        '0019xx58': ('US', '1', 'SourceImage Distance', ''),
        '0019xx5A': ('US', '1', 'Mechanical Magnet Factor', ''),
        '0019xx5C': ('UL', '1', 'Calibration Flag', ''),
        '0019xx5E': ('UL', '1', 'Calibration Angle CranCaud', ''),
        '0019xx60': ('UL', '1', 'Calibration Angle RAOLAO', ''),
        '0019xx62': ('UL', '1', 'Calibration Table to Floor Distance', ''),
        '0019xx64': ('UL', '1', 'Calibration Isocenter to Floor Distance', ''),
        '0019xx66': ('UL', '1', 'Calibration Isocenter to Source Distance', ''),
        '0019xx68': ('UL', '1', 'Calibration Source to II Distance', ''),
        '0019xx6A': ('UL', '1', 'Calibration II Zoom', ''),
        '0019xx6C': ('UL', '1', 'Calibration II Field', ''),
        '0019xx6E': ('UL', '1', 'Calibration Factor', ''),
        '0019xx70': ('UL', '1', 'Calibration Object to Image Distance', ''),
        '0019xx72': ('UL', '1-n', 'Calibration System Factor', ''),
        '0019xx74': ('UL', '1-n', 'Calibration System Correction', ''),
        '0019xx76': ('UL', '1-n', 'Calibration System II Formats', ''),
        '0019xx78': ('UL', '1', 'Calibration Gantry Data Valid', ''),
        '0019xx7A': ('US', '1', 'Collimator Square Breadth', ''),
        '0019xx7C': ('US', '1', 'Collimator Square Height', ''),
        '0019xx7E': ('US', '1', 'Collimator Square Diameter', ''),
        '0019xx80': ('US', '1', 'Collimator Finger Turn Angle', ''),
        '0019xx82': ('US', '1', 'Collimator Finger Position', ''),
        '0019xx84': ('US', '1', 'Collimator Diaphragm Turn Angle', ''),
        '0019xx86': ('US', '1', 'Collimator Diagphragm Position 1', ''),
        '0019xx88': ('US', '1', 'Collimator Diaphragm Position 2', ''),
        '0019xx8A': ('US', '1', 'Collimator Diaphragm Mode', ''),
        '0019xx8C': ('US', '1', 'Collimator Beam Limit Breadth', ''),
        '0019xx8E': ('US', '1', 'Collimator Beam Limit Height', ''),
        '0019xx90': ('US', '1', 'Collimator Beam Limit Diameter', ''),
        '0019xx92': ('US', '1', 'XRay Control Mode', ''),
        '0019xx94': ('US', '1', 'XRay System', ''),
        '0019xx96': ('US', '1', 'Focal Spot', ''),
        '0019xx98': ('US', '1', 'Exposure Control', ''),
        '0019xx9A': ('US', '1', 'XRay Voltage', ''),
        '0019xx9C': ('US', '1', 'XRay Current', ''),
        '0019xx9E': ('UL', '1', 'XRay Current Time Product', ''),
        '0019xxA0': ('US', '1', 'Pulse Time', ''),
        '0019xxA2': ('US', '1', 'Scene Time Fluoro Clock', ''),
        '0019xxA4': ('US', '1', 'Maximum PulseRate', ''),
        '0019xxA6': ('US', '1', 'Pulses per Scene', ''),
        '0019xxA8': ('UL', '1', 'Dose Area Product of Scene', ''),
        '0019xxAA': ('US', '1', 'Dose', ''),
        '0019xxAC': ('US', '1', 'Dose Rate', ''),
    },
    'SIEMENS RIS': {
        '0011xx10': ('LO', '1', 'Patient UID', ''),
        '0011xx11': ('LO', '1', 'Patient ID', ''),
        '0011xx20': ('DA', '1', 'Patient Registration Date', ''),
        '0011xx21': ('TM', '1', 'Patient Registration Time', ''),
        '0011xx30': ('PN', '1', 'Patient NameRIS', ''),
        '0011xx31': ('PN', '1', 'Patient Prename', ''),
        '0011xx40': ('LO', '1', 'Patient Hospital Status', ''),
        '0011xx41': ('LO', '1', 'Medical Alerts', ''),
        '0011xx42': ('LO', '1', 'Contrast Allergy', ''),
        '0031xx10': ('LO', '1', 'Request UID', ''),
        '0031xx45': ('LO', '1', 'Requesting Physician', ''),
        '0031xx50': ('LO', '1', 'Requested Physician', ''),
        '0033xx10': ('LO', '1', 'Patient Study UID', ''),
    },
    'SIEMENS SIENET': {
        '0019xx01': ('DS', '1', 'Unknown', ''),
    },
    'SIEMENS SMS-AX  ACQ 1.0': {
        '0021xx00': ('US', '1', 'Acquisition Type', ''),
        '0021xx01': ('US', '1', 'Acquisition Mode', ''),
        '0021xx02': ('US', '1', 'Footswitch Index', ''),
        '0021xx03': ('US', '1', 'Acquisition Room', ''),
        '0021xx04': ('SL', '1', 'Current Time Product', ''),
        '0021xx05': ('SL', '1', 'Dose', ''),
        '0021xx06': ('SL', '1', 'Skin Dose Percent', ''),
        '0021xx07': ('SL', '1', 'Skin Dose Accumulation', ''),
        '0021xx08': ('SL', '1', 'Skin Dose Rate', ''),
        '0021xx09': ('UL', '1', 'Impac Filename', ''),
        '0021xx0A': ('UL', '1', 'Copper Filter', ''),
        '0021xx0B': ('US', '1', 'Measuring Field', ''),
        '0021xx0C': ('SS', '3', 'Post Blanking Circle', ''),
        '0021xx0D': ('SS', '2-2n', 'Dyna Angles', ''),
        '0021xx0E': ('SS', '1', 'Total Steps', ''),
        '0021xx0F': ('SL', '3-3n', 'Dyna X-Ray Info', ''),
        '0021xx10': ('US', '1', 'Modality LUT Input Gamma', ''),
        '0021xx11': ('US', '1', 'Modality LUT Output Gamma', ''),
        '0021xx12': ('OB', '1-n', 'SH_STPAR', ''),
        '0021xx13': ('US', '1', 'Acquisition Zoom', ''),
        '0021xx14': ('SS', '1', 'Dyna Angulation Step Width', ''),
        '0021xx15': ('US', '1', 'Harmonization', ''),
        '0021xx16': ('US', '1', 'DR Single Flag', ''),
        '0021xx17': ('SL', '1', 'Source to Isocenter', ''),
        '0021xx18': ('US', '1', 'Pressure Data', ''),
        '0021xx19': ('SL', '1', 'ECG Index Array', ''),
        '0021xx1A': ('US', '1', 'FD Flag', ''),
        '0021xx1B': ('OB', '1', 'SH_ZOOM', ''),
        '0021xx1C': ('OB', '1', 'SH_COLPAR', ''),
        '0021xx1D': ('US', '1', 'K-Factor', ''),
        '0021xx1E': ('US', '8', 'EVE', ''),
        '0021xx1F': ('SL', '1', 'Total Scene Time', ''),
        '0021xx20': ('US', '1', 'Restore Flag', ''),
        '0021xx21': ('US', '1', 'Stand Movement Flag', ''),
        '0021xx22': ('US', '1', 'FD Rows', ''),
        '0021xx23': ('US', '1', 'FD Columns', ''),
        '0021xx24': ('US', '1', 'Table Movement Flag', ''),
        '0021xx25': ('LO', '1', 'Original Organ Program Name', ''),
        '0021xx26': ('DS', '1', 'Crispy XPI Filter', ''),
        '0021xx28': ('SQ', '1', 'Unknown', ''),
        '0021xx30': ('OB', '1', 'Unknown', ''),
        '0021xx40': ('US', '3', 'Unknown', ''),
        '0021xx41': ('LO', '1', 'Unknown', ''),
        '0021xx42': ('US', '1-n', 'Unknown', ''),
        '0021xx57': ('SS', '1-3', 'Unknown', ''),
        '0021xx58': ('DS', '1', 'Unknown', ''),
        '0021xx71': ('DS', '1', 'Unknown', ''),
    },
    'SIEMENS SMS-AX  ORIGINAL IMAGE INFO 1.0': {
        '0025xx00': ('US', '1', 'View Native', ''),
        '0025xx01': ('US', '1', 'Original Series Number', ''),
        '0025xx02': ('US', '1', 'Original Image Number', ''),
        '0025xx03': ('US', '1', 'Win Center', ''),
        '0025xx04': ('US', '1', 'Win Width', ''),
        '0025xx05': ('US', '1', 'Win Brightness', ''),
        '0025xx06': ('US', '1', 'Win Contrast', ''),
        '0025xx07': ('US', '1', 'Original Frame Number', ''),
        '0025xx08': ('US', '1', 'Original Mask Frame Number', ''),
        '0025xx09': ('US', '1', 'Opac', ''),
        '0025xx0A': ('US', '1', 'Original Number of Frames', ''),
        '0025xx0B': ('DS', '1', 'Original Scene Duration', ''),
        '0025xx0C': ('LO', '1', 'Identifier LOID', ''),
        '0025xx0D': ('SS', '1-n', 'Original Scene VFR Info', ''),
        '0025xx0E': ('SS', '1', 'Original Frame ECG Position', ''),
        '0025xx0F': ('SS', '1', 'Original ECG 1st Frame Offset (retired)', ''),
        '0025xx10': ('SS', '1', 'Zoom Flag', ''),
        '0025xx11': ('US', '1', 'Flex', ''),
        '0025xx12': ('US', '1', 'Number of Mask Frames', ''),
        '0025xx13': ('US', '1', 'Number of Fill Frames', ''),
        '0025xx14': ('IS', '1', 'Series Number', ''),
        '0025xx15': ('IS', '1', 'Image Number', ''),
        '0025xx16': ('IS', '1', 'Unknown', ''),
    },
    'SIEMENS SMS-AX  QUANT 1.0': {
        '0023xx00': ('DS', '2', 'Horizontal Calibration Pixel Size', ''),
        '0023xx01': ('DS', '2', 'Vertical Calibration Pixel Size', ''),
        '0023xx02': ('LO', '1', 'Calibration Object', ''),
        '0023xx03': ('DS', '1', 'Calibration Object Size', ''),
        '0023xx04': ('LO', '1', 'Calibration Method', ''),
        '0023xx05': ('ST', '1', 'Filename', ''),
        '0023xx06': ('IS', '1', 'Frame Number', ''),
        '0023xx07': ('IS', '2', 'Calibration Factor Multiplicity', ''),
        '0023xx08': ('IS', '1', 'Calibration TOD Value', ''),
    },
    'SIEMENS SMS-AX  VIEW 1.0': {
        '0019xx00': ('US', '1', 'Review Mode', ''),
        '0019xx01': ('US', '1', 'Anatomical Background Percent', ''),
        '0019xx02': ('US', '1', 'Number of Phases', ''),
        '0019xx03': ('US', '1', 'Apply Anatomical Background', ''),
        '0019xx04': ('SS', '4-4n', 'Pixel Shift Array', ''),
        '0019xx05': ('US', '1', 'Brightness', ''),
        '0019xx06': ('US', '1', 'Contrast', ''),
        '0019xx07': ('US', '1', 'Enabled', ''),
        '0019xx08': ('US', '1', 'Native Edge Enh. Percent Gain', ''),
        '0019xx09': ('SS', '1', 'Native Edge Enh. LUT Index', ''),
        '0019xx0A': ('SS', '1', 'Native Edge Enh. Kernel Size', ''),
        '0019xx0B': ('US', '1', 'Subtr. Edge Enh. Percent Gain', ''),
        '0019xx0C': ('SS', '1', 'Subtr. Edge Enh. LUT Index', ''),
        '0019xx0D': ('SS', '1', 'Subtr. Edge Enh. Kernel Size', ''),
        '0019xx0E': ('US', '1', 'Fade Percent', ''),
        '0019xx0F': ('US', '1', 'Flipped Before Laterality Applied', ''),
        '0019xx10': ('US', '1', 'Apply Fade', ''),
        '0019xx11': ('US', '1', 'RefImages Taken', ''),
        '0019xx12': ('US', '1', 'Zoom', ''),
        '0019xx13': ('SS', '1', 'Pan X', ''),
        '0019xx14': ('SS', '1', 'Pan Y', ''),
        '0019xx15': ('SS', '1', 'Native Edge Enh. Adv Perc. Gain', ''),
        '0019xx16': ('SS', '1', 'Subtr. Edge Enh. Adv Perc. Gain', ''),
        '0019xx17': ('US', '1', 'Invert Flag', ''),
        '0019xx1A': ('OB', '1', 'Quant 1K Overlay', ''),
        '0019xx1B': ('US', '1', 'Original Resolution', ''),
        '0019xx1C': ('DS', '1', 'Auto Window Center', ''),
        '0019xx1D': ('DS', '1', 'Auto Window Width', ''),
    },
    'SIEMENS Selma': {
        '0019xx06': ('IS', '1', 'Unknown', ''),
        '0019xx07': ('IS', '1', 'Unknown', ''),
        '0019xx08': ('IS', '1', 'Unknown', ''),
        '0019xx26': ('LO', '1', 'Unknown', ''),
        '0019xx29': ('LO', '1', 'Unknown', ''),
        '0019xx30': ('US', '1', 'Unknown', ''),
        '0019xx31': ('US', '1', 'Unknown', ''),
        '0019xx32': ('US', '1', 'Unknown', ''),
        '0019xx33': ('US', '1', 'Unknown', ''),
        '0019xx34': ('US', '1', 'Unknown', ''),
        '0019xx35': ('US', '1', 'Unknown', ''),
    },
    'SIEMENS WH SR 1.0': {
        '0071xx01': ('LO', '1', 'Unknown', ''),
        '0071xx02': ('LO', '1', 'Unknown', ''),
    },
    'SIEMENS_FLCOMPACT_VA01A_PROC': {
        '0017xx0A': ('SS', '1', 'Internal Data', ''),
        '0017xx0B': ('SS', '1', 'Internal Data', ''),
        '0017xx0C': ('SS', '1', 'Internal Data', ''),
        '0017xx0D': ('FL', '1', 'Internal Data', ''),
        '0017xx0E': ('LO', '1', 'Internal Data', ''),
        '0017xx0F': ('LO', '1', 'Internal Data', ''),
        '0017xx14': ('US', '1', 'Internal Data', ''),
        '0017xx16': ('US', '1', 'Internal Data', ''),
        '0017xx17': ('US', '1', 'Internal Data', ''),
        '0017xx18': ('US', '1', 'Internal Data', ''),
        '0017xx19': ('US', '1', 'Internal Data', ''),
        '0017xx1A': ('US', '1', 'Internal Data', ''),
        '0017xx1B': ('US', '1', 'Internal Data', ''),
        '0017xx1C': ('US', '1', 'Internal Data', ''),
        '0017xx1E': ('US', '1', 'Internal Data', ''),
        '0017xx1F': ('SS', '1', 'Internal Data', ''),
        '0017xx20': ('SS', '1', 'Internal Data', ''),
        '0017xx21': ('US', '1', 'Internal Data', ''),
        '0017xx22': ('US', '1', 'Internal Data', ''),
        '0017xx23': ('US', '1', 'Internal Data', ''),
        '0017xx24': ('US', '1', 'Internal Data', ''),
        '0017xx25': ('US', '1', 'Internal Data', ''),
        '0017xx26': ('US', '1', 'Internal Data', ''),
        '0017xx27': ('US', '1', 'Internal Data', ''),
        '0017xx28': ('FL', '1', 'Internal Data', ''),
        '0017xx29': ('FL', '1', 'Internal Data', ''),
        '0017xx48': ('SS', '1', 'Internal Data', ''),
        '0017xx49': ('SS', '1', 'Internal Data', ''),
        '0017xx4A': ('SS', '1', 'Internal Data', ''),
        '0017xx4B': ('SS', '1', 'Internal Data', ''),
        '0017xx4C': ('LO', '1', 'Internal Data', ''),
        '0017xx4D': ('SS', '1', 'Internal Data', ''),
        '0017xx4E': ('LO', '1', 'Internal Data', ''),
        '0017xx4F': ('LO', '1', 'Internal Data', ''),
        '0017xx50': ('SS', '1', 'Internal Data', ''),
        '0017xx51': ('FL', '1', 'Internal Data', ''),
        '0017xx52': ('SS', '1', 'Internal Data', ''),
        '0017xx53': ('SS', '1', 'Internal Data', ''),
        '0017xx54': ('SS', '1', 'Internal Data', ''),
        '0017xx55': ('SS', '1', 'Internal Data', ''),
        '0017xx5A': ('OW', '1', 'Internal Data', ''),
        '0017xx5B': ('OW', '1', 'Internal Data', ''),
        '0017xx5C': ('OW', '1', 'Internal Data', ''),
        '0017xx64': ('US', '1', 'Internal Data', ''),
        '0017xx66': ('US', '1', 'Internal Data', ''),
        '0017xx67': ('US', '1', 'Internal Data', ''),
        '0017xx68': ('US', '1', 'Internal Data', ''),
        '0017xx85': ('US', '1', 'Internal Data', ''),
        '0017xx86': ('US', '1', 'Internal Data', ''),
        '0017xx87': ('US', '1', 'Internal Data', ''),
        '0017xx88': ('US', '1', 'Internal Data', ''),
        '0017xx89': ('US', '1', 'Internal Data', ''),
        '0017xx8A': ('US', '1', 'Internal Data', ''),
        '0017xx8B': ('US', '1', 'Internal Data', ''),
        '0017xx8C': ('FL', '1', 'Internal Data', ''),
        '0017xx8D': ('FL', '1', 'Internal Data', ''),
        '0017xx8E': ('US', '1', 'Internal Data', ''),
        '0017xx8F': ('US', '1', 'Internal Data', ''),
        '0017xxA0': ('US', '1', 'Internal Data', ''),
        '0017xxA1': ('US', '1', 'Internal Data', ''),
        '0017xxA2': ('US', '1', 'Internal Data', ''),
        '0017xxA3': ('US', '1', 'Internal Data', ''),
        '0017xxA4': ('US', '1', 'Internal Data', ''),
        '0017xxA5': ('US', '1', 'Internal Data', ''),
        '0017xxA6': ('US', '1', 'Internal Data', ''),
        '0017xxB0': ('DS', '1', 'Internal Data', ''),
        '0017xxC0': ('LO', '1', 'Internal Data', ''),
    },
    'SIENET': {
        '0009xx01': ('US', '1', 'SIENET Command Field', ''),
        '0009xx14': ('LO', '1', 'Receiver PLA', ''),
        '0009xx16': ('US', '1', 'Transfer Priority', ''),
        '0009xx29': ('LO', '1', 'Actual User', ''),
        '0009xx70': ('DS', '1', 'Unknown', ''),
        '0009xx71': ('DS', '1', 'Unknown', ''),
        '0009xx72': ('LO', '1', 'Unknown', ''),
        '0009xx73': ('LO', '1', 'Unknown', ''),
        '0009xx74': ('LO', '1', 'Unknown', ''),
        '0009xx75': ('LO', '1', 'Unknown', ''),
        '0091xx20': ('PN', '1-n', 'Patient Name', ''),
        '0095xx01': ('LO', '1', 'Examination Folder ID', ''),
        '0095xx04': ('SL', '1', 'Folder Reported Status', ''),
        '0095xx05': ('LO', '1', 'Folder Reporting Radiologist', ''),
        '0095xx07': ('LO', '1', 'SIENET ISA PLA', ''),
        '0095xx0C': ('SL', '1', 'Folder Rebuild Status', ''),
        '0095xx20': ('UN', '1', 'Unknown', ''),
        '0095xxFB': ('ST', '1', 'Unknown', ''),
        '0099xx02': ('UL', '1', 'Key Images', ''),
        '0099xx05': ('SL', '1', 'Image Number', ''),
    },
    'SPI': {
        '0009xx10': ('LO', '1', 'Comments', ''),
        '0009xx15': ('LO', '1', 'Unique Identifier', ''),
        '0009xx40': ('US', '1', 'Data Object Type', ''),
        '0009xx41': ('SH', '1', 'Data Object Subtype', ''),
        '0011xx10': ('LO', '1', 'Organ', ''),
        '0011xx15': ('LO', '1', 'Allergy Indication', ''),
        '0011xx20': ('CS', '1', 'Pregnancy', ''),
        '0029xx60': ('LO', '1', 'Compression Algorithm', ''),
    },
    'SPI RELEASE 1': {
        '0009xx10': ('LO', '1', 'Comments', ''),
        '0009xx15': ('LO', '1', 'Unique Identifier', ''),
        '0009xx40': ('US', '1', 'Data Object Type', ''),
        '0009xx41': ('SH', '1', 'Data Object Subtype', ''),
        '0011xx10': ('LO', '1', 'Organ', ''),
        '0011xx15': ('LO', '1', 'Allergy Indication', ''),
        '0011xx20': ('CS', '1', 'Pregnancy', ''),
        '0029xx60': ('LO', '1', 'Compression Algorithm', ''),
    },
    'SPI Release 1': {
        '0009xx08': ('CS', '1', 'Unknown', ''),
        '0009xx10': ('LO', '1', 'Comments', ''),
        '0009xx15': ('LO', '1', 'UID', ''),
        '0009xx40': ('US', '1', 'Data Object Type', ''),
        '0009xx41': ('SH', '1', 'Data Object Subtype', ''),
        '0011xx10': ('LO', '1', 'Organ', ''),
        '0011xx15': ('LO', '1', 'Allergy Indication', ''),
        '0011xx20': ('LO', '1', 'Pregnancy', ''),
        '0029xx60': ('LO', '1', 'Compression Algorithm', ''),
    },
    'SPI-P Release 1': {
        '0009xx00': ('LT', '1', 'Data Object Recognition Code', ''),
        '0009xx04': ('LO', '1-n', 'Image Data Consistency', ''),
        '0009xx08': ('US', '1', 'Unknown', ''),
        '0009xx12': ('LO', '1', 'Unknown', ''),
        '0009xx15': ('LO', '1', 'Unique Identifier', ''),
        '0009xx16': ('LO', '1', 'Unknown', ''),
        '0009xx18': ('LO', '1', 'Unknown', ''),
        '0009xx21': ('LT', '1', 'Unknown', ''),
        '0009xx22': ('LO', '1', 'Unknown', ''),
        '0009xx31': ('LO', '1', 'PACS Unique Identifier', ''),
        '0009xx34': ('LO', '1', 'Cluster Unique Identifier', ''),
        '0009xx38': ('LO', '1', 'System Unique Identifier', ''),
        '0009xx39': ('LO', '1', 'Unknown', ''),
        '0009xx40': ('LO', '1', 'Unknown', ''),
        '0009xx41': ('LO', '1', 'Unknown', ''),
        '0009xx51': ('LO', '1', 'Study Unique Identifier', ''),
        '0009xx61': ('LO', '1', 'Series Unique Identifier', ''),
        '0009xx91': ('LT', '1', 'Unknown', ''),
        '0009xxA0': ('UN', '1', 'Unknown', ''),
        '0009xxF2': ('LT', '1', 'Unknown', ''),
        '0009xxF3': ('UN', '1', 'Unknown', ''),
        '0009xxF4': ('LT', '1', 'Unknown', ''),
        '0009xxF5': ('UN', '1', 'Unknown', ''),
        '0009xxF7': ('LT', '1', 'Unknown', ''),
        '0011xx10': ('LT', '1', 'Patient Entry ID', ''),
        '0011xx20': ('UN', '1', 'Unknown', ''),
        '0011xx21': ('UN', '1', 'Unknown', ''),
        '0011xx22': ('UN', '1', 'Unknown', ''),
        '0011xx30': ('UN', '1', 'Unknown', ''),
        '0011xx31': ('UN', '1', 'Unknown', ''),
        '0011xx32': ('UN', '1', 'Unknown', ''),
        '0019xx00': ('LO', '1', 'Unknown', ''),
        '0019xx01': ('LO', '1', 'Unknown', ''),
        '0019xx02': ('UN', '1', 'Unknown', ''),
        '0019xx10': ('US', '1', 'Mains Frequency', ''),
        '0019xx25': ('LO', '1-n', 'Original Pixel Data Quality', ''),
        '0019xx30': ('US', '1', 'ECG Triggering', ''),
        '0019xx31': ('UN', '1', 'ECG 1 Offset', ''),
        '0019xx32': ('UN', '1', 'ECG 2 Offset 1', ''),
        '0019xx33': ('UN', '1', 'ECG 2 Offset 2', ''),
        '0019xx50': ('US', '1', 'Video Scan Mode', ''),
        '0019xx51': ('US', '1', 'Video LineRate', ''),
        '0019xx60': ('US', '1', 'Xray Technique', ''),
        '0019xx61': ('DS', '1', 'Image Identifier Format', ''),
        '0019xx62': ('US', '1', 'Iris Diaphragm', ''),
        '0019xx63': ('CS', '1', 'Filter', ''),
        '0019xx64': ('CS', '1', 'Cine Parallel', ''),
        '0019xx65': ('CS', '1', 'Cine Master', ''),
        '0019xx70': ('US', '1', 'Exposure Channel', ''),
        '0019xx71': ('UN', '1', 'Exposure Channel First Image', ''),
        '0019xx72': ('US', '1', 'Processing Channel', ''),
        '0019xx80': ('DS', '1', 'Acquisition Delay', ''),
        '0019xx81': ('UN', '1', 'Relative Image Time', ''),
        '0019xx90': ('CS', '1', 'Video White Compression', ''),
        '0019xxA0': ('US', '1', 'Angulation', ''),
        '0019xxA1': ('US', '1', 'Rotation', ''),
        '0021xx12': ('LT', '1', 'Series Unique Identifier', ''),
        '0021xx14': ('LT', '1', 'Unknown', ''),
        '0029xx00': ('DS', '4', 'Unknown', ''),
        '0029xx20': ('DS', '1', 'Pixel Aspect Ratio', ''),
        '0029xx25': ('LO', '1-n', 'Processed Pixel Data Quality', ''),
        '0029xx30': ('LT', '1', 'Unknown', ''),
        '0029xx38': ('US', '1', 'Unknown', ''),
        '0029xx60': ('LT', '1', 'Unknown', ''),
        '0029xx61': ('LT', '1', 'Unknown', ''),
        '0029xx67': ('LT', '1', 'Unknown', ''),
        '0029xx70': ('LT', '1', 'Window ID', ''),
        '0029xx71': ('CS', '1', 'Video Invert Subtracted', ''),
        '0029xx72': ('CS', '1', 'Video Invert Nonsubtracted', ''),
        '0029xx77': ('CS', '1', 'Window Select Status', ''),
        '0029xx78': ('LT', '1', 'ECG Display Printing ID', ''),
        '0029xx79': ('CS', '1', 'ECG Display Printing', ''),
        '0029xx7E': ('CS', '1', 'ECG Display Printing Enable Status', ''),
        '0029xx7F': ('CS', '1', 'ECG Display Printing Select Status', ''),
        '0029xx80': ('LT', '1', 'Physiological Display ID', ''),
        '0029xx81': ('US', '1', 'Preferred Physiological Channel Display', ''),
        '0029xx8E': ('CS', '1', 'Physiological Display Enable Status', ''),
        '0029xx8F': ('CS', '1', 'Physiological Display Select Status', ''),
        '0029xx90': ('DS', '1-n', 'Unknown', ''),
        '0029xx91': ('US', '1', 'Unknown', ''),
        '0029xx9F': ('CS', '1', 'Unknown', ''),
        '0029xxA0': ('DS', '1-n', 'Unknown', ''),
        '0029xxA1': ('US', '1', 'Unknown', ''),
        '0029xxAF': ('CS', '1', 'Unknown', ''),
        '0029xxB0': ('DS', '1-n', 'Unknown', ''),
        '0029xxB1': ('US', '1', 'Unknown', ''),
        '0029xxBF': ('CS', '1', 'Unknown', ''),
        '0029xxC0': ('LT', '1', 'Functional Shutter ID', ''),
        '0029xxC1': ('US', '1', 'Field Of Shutter', ''),
        '0029xxC5': ('LT', '1', 'Field Of Shutter Rectangle', ''),
        '0029xxCE': ('CS', '1', 'Shutter Enable Status', ''),
        '0029xxCF': ('CS', '1', 'Shutter Select Status', ''),
        '7FE1xx10': ('UN', '1', 'Pixel Data', ''),
    },
    'SPI-P Release 1;1': {
        '0009xxC0': ('LT', '1', 'Unknown', ''),
        '0009xxC1': ('LT', '1', 'Unknown', ''),
        '0019xx00': ('UN', '1', 'Physiological Data Type', ''),
        '0019xx01': ('UN', '1', 'Physiological Data Channel And Kind', ''),
        '0019xx02': ('US', '1', 'Sample Bits Allocated', ''),
        '0019xx03': ('US', '1', 'Sample Bits Stored', ''),
        '0019xx04': ('US', '1', 'Sample High Bit', ''),
        '0019xx05': ('US', '1', 'Sample Representation', ''),
        '0019xx06': ('UN', '1', 'Smallest Sample Value', ''),
        '0019xx07': ('UN', '1', 'Largest Sample Value', ''),
        '0019xx08': ('UN', '1', 'Number Of Samples', ''),
        '0019xx09': ('UN', '1', 'Sample Data', ''),
        '0019xx0A': ('UN', '1', 'Sample Rate', ''),
        '0019xx10': ('UN', '1', 'Physiological Data Type 2', ''),
        '0019xx11': ('UN', '1', 'Physiological Data Channel And Kind 2', ''),
        '0019xx12': ('US', '1', 'Sample Bits Allocated 2', ''),
        '0019xx13': ('US', '1', 'Sample Bits Stored 2', ''),
        '0019xx14': ('US', '1', 'Sample High Bit 2', ''),
        '0019xx15': ('US', '1', 'Sample Representation 2', ''),
        '0019xx16': ('UN', '1', 'Smallest Sample Value 2', ''),
        '0019xx17': ('UN', '1', 'Largest Sample Value 2', ''),
        '0019xx18': ('UN', '1', 'Number Of Samples 2', ''),
        '0019xx19': ('UN', '1', 'Sample Data 2', ''),
        '0019xx1A': ('UN', '1', 'Sample Rate 2', ''),
        '0021xx41': ('LO', '1', 'Unknown', ''),
        '0021xx42': ('US', '1', 'Unknown', ''),
        '0021xx43': ('US', '1', 'Unknown', ''),
        '0021xx44': ('DS', '1', 'Unknown', ''),
        '0021xx45': ('LO', '1', 'Unknown', ''),
        '0021xx50': ('US', '1', 'Unknown', ''),
        '0021xx51': ('US', '1', 'Unknown', ''),
        '0021xx52': ('US', '1', 'Unknown', ''),
        '0021xx60': ('IS', '1-n', 'Unknown', ''),
        '0021xx61': ('IS', '1-n', 'Unknown', ''),
        '0021xx67': ('LO', '1-n', 'Unknown', ''),
        '0021xx6A': ('DS', '1-n', 'Unknown', ''),
        '0021xx6B': ('DS', '1-n', 'Unknown', ''),
        '0021xx6C': ('US', '1-n', 'Unknown', ''),
        '0021xx6D': ('DS', '1-n', 'Unknown', ''),
        '0021xx6E': ('US', '1-n', 'Unknown', ''),
        '0021xx6F': ('DS', '1-n', 'Unknown', ''),
        '0029xx00': ('LT', '1', 'Zoom ID', ''),
        '0029xx01': ('DS', '1-n', 'Zoom Rectangle', ''),
        '0029xx03': ('DS', '1', 'Zoom Factor', ''),
        '0029xx04': ('US', '1', 'Zoom Function', ''),
        '0029xx0E': ('CS', '1', 'Zoom Enable Status', ''),
        '0029xx0F': ('CS', '1', 'Zoom Select Status', ''),
        '0029xx40': ('LT', '1', 'Magnifying Glass ID', ''),
        '0029xx41': ('DS', '1-n', 'Magnifying Glass Rectangle', ''),
        '0029xx43': ('DS', '1', 'Magnifying Glass Factor', ''),
        '0029xx44': ('US', '1', 'Magnifying Glass Function', ''),
        '0029xx4E': ('CS', '1', 'Magnifying Glass Enable Status', ''),
        '0029xx4F': ('CS', '1', 'Magnifying Glass Select Status', ''),
    },
    'SPI-P Release 1;2': {
        '0029xx00': ('LT', '1', 'Subtraction Mask ID', ''),
        '0029xx04': ('UN', '1', 'Masking Function', ''),
        '0029xx0C': ('UN', '1', 'Proprietary Masking Parameters', ''),
        '0029xx1E': ('CS', '1', 'Subtraction Mask Enable Status', ''),
        '0029xx1F': ('CS', '1', 'Subtraction Mask Select Status', ''),
    },
    'SPI-P Release 1;3': {
        '0029xx00': ('LT', '1', 'Image Enhancement ID', ''),
        '0029xx01': ('LT', '1', 'Image Enhancement', ''),
        '0029xx02': ('LT', '1', 'Convolution ID', ''),
        '0029xx03': ('LT', '1', 'Convolution Type', ''),
        '0029xx04': ('LT', '1', 'Convolution Kernel Size ID', ''),
        '0029xx05': ('US', '2', 'Convolution Kernel Size', ''),
        '0029xx06': ('US', '1-n', 'Convolution Kernel', ''),
        '0029xx0C': ('DS', '1', 'Enhancement Gain', ''),
        '0029xx1E': ('CS', '1', 'Image Enhancement Enable Status', ''),
        '0029xx1F': ('CS', '1', 'Image Enhancement Select Status', ''),
    },
    'SPI-P Release 2;1': {
        '0011xx18': ('LT', '1', 'Unknown', ''),
        '0023xx0D': ('UI', '1', 'Unknown', ''),
        '0023xx0E': ('UI', '1', 'Unknown', ''),
    },
    'SPI-P-CTBE Release 1': {
        '0019xx00': ('IS', '1', 'Unknown', ''),
        '0019xx02': ('IS', '1', 'Unknown', ''),
        '0019xx03': ('DS', '1', 'Unknown', ''),
        '0019xx04': ('IS', '1', 'Unknown', ''),
        '0019xx05': ('DS', '1', 'Unknown', ''),
        '0019xx0B': ('DS', '1', 'Unknown', ''),
        '0019xx0C': ('IS', '1', 'Unknown', ''),
        '0019xx14': ('IS', '1', 'Unknown', ''),
        '0019xx18': ('IS', '1', 'Unknown', ''),
        '0019xx19': ('IS', '1', 'Unknown', ''),
        '0019xx1A': ('DS', '1', 'Unknown', ''),
        '0019xx1B': ('IS', '1', 'Unknown', ''),
        '0019xx1C': ('IS', '1', 'Unknown', ''),
        '0019xx1D': ('DS', '1', 'Unknown', ''),
    },
    'SPI-P-CTBE-Private Release 1': {
        '0021xx00': ('DS', '1', 'Unknown', ''),
    },
    'SPI-P-GV-CT Release 1': {
        '0009xx00': ('LO', '1', 'Unknown', ''),
        '0009xx10': ('LO', '1', 'Unknown', ''),
        '0009xx20': ('LO', '1', 'Unknown', ''),
        '0009xx30': ('LO', '1', 'Unknown', ''),
        '0009xx40': ('LO', '1', 'Unknown', ''),
        '0009xx50': ('LO', '1', 'Unknown', ''),
        '0009xx60': ('LO', '1', 'Unknown', ''),
        '0009xx70': ('LO', '1', 'Unknown', ''),
        '0009xx75': ('LO', '1', 'Unknown', ''),
        '0009xx80': ('LO', '1', 'Unknown', ''),
        '0009xx90': ('LO', '1', 'Unknown', ''),
        '0019xx08': ('IS', '1', 'Unknown', ''),
        '0019xx09': ('IS', '1', 'Unknown', ''),
        '0019xx0A': ('IS', '1', 'Unknown', ''),
        '0019xx10': ('LO', '1', 'Unknown', ''),
        '0019xx20': ('TM', '1', 'Unknown', ''),
        '0019xx50': ('LO', '1', 'Unknown', ''),
        '0019xx60': ('DS', '1', 'Unknown', ''),
        '0019xx61': ('US', '1', 'Unknown', ''),
        '0019xx63': ('LO', '1', 'Unknown', ''),
        '0019xx64': ('US', '1', 'Unknown', ''),
        '0019xx65': ('IS', '1', 'Unknown', ''),
        '0019xx70': ('LT', '1', 'Unknown', ''),
        '0019xx80': ('LO', '1', 'Unknown', ''),
        '0019xx81': ('LO', '1', 'Unknown', ''),
        '0019xx90': ('LO', '1', 'Unknown', ''),
        '0019xxA0': ('LO', '1', 'Unknown', ''),
        '0019xxA1': ('US', '1', 'Unknown', ''),
        '0019xxA2': ('US', '1', 'Unknown', ''),
        '0019xxA3': ('US', '1', 'Unknown', ''),
        '0019xxB0': ('LO', '1', 'Unknown', ''),
        '0019xxB1': ('LO', '1', 'Unknown', ''),
        '0021xx20': ('LO', '1', 'Unknown', ''),
        '0021xx30': ('DS', '1', 'Unknown', ''),
        '0021xx40': ('LO', '1', 'Unknown', ''),
        '0021xx50': ('LO', '1', 'Unknown', ''),
        '0021xx60': ('DS', '1', 'Unknown', ''),
        '0021xx70': ('DS', '1', 'Unknown', ''),
        '0021xx80': ('DS', '1', 'Unknown', ''),
        '0021xx90': ('DS', '1', 'Unknown', ''),
        '0021xxA0': ('US', '1', 'Unknown', ''),
        '0021xxA1': ('DS', '1', 'Unknown', ''),
        '0021xxA2': ('DS', '1', 'Unknown', ''),
        '0021xxA3': ('LT', '1', 'Unknown', ''),
        '0021xxA4': ('LT', '1', 'Unknown', ''),
        '0021xxB0': ('LO', '1', 'Unknown', ''),
        '0021xxC0': ('LO', '1', 'Unknown', ''),
        '0029xx10': ('LO', '1', 'Unknown', ''),
        '0029xx30': ('UL', '1', 'Unknown', ''),
        '0029xx31': ('UL', '1', 'Unknown', ''),
        '0029xx32': ('UL', '1', 'Unknown', ''),
        '0029xx33': ('UL', '1', 'Unknown', ''),
        '0029xx80': ('LO', '1', 'Unknown', ''),
        '0029xx90': ('LO', '1', 'Unknown', ''),
        '0029xxD0': ('IS', '1', 'Unknown', ''),
        '0029xxD1': ('IS', '1', 'Unknown', ''),
    },
    'SPI-P-PCR Release 2': {
        '0019xx10': ('US', '1', 'Reader Mode', ''),
        '0019xx20': ('ST', '1', 'MRM Code', ''),
        '0019xx30': ('US', '1', 'Unknown', ''),
        '0019xx40': ('DS', '1', 'Latitude', ''),
        '0019xx60': ('ST', '1', 'View Name', ''),
        '0019xx80': ('US', '1', 'Unknown', ''),
        '0019xxA1': ('ST', '1', 'Unknown', ''),
        '0019xxA3': ('DS', '1', 'Unknown', ''),
        '0019xxA4': ('DS', '1', 'Unknown', ''),
        '0019xxA5': ('DS', '1', 'Unknown', ''),
        '0019xxA6': ('DS', '1', 'Unknown', ''),
        '0019xxA7': ('DS', '1', 'Unknown', ''),
        '0019xxA8': ('DS', '1', 'Unknown', ''),
        '0019xxA9': ('DS', '1', 'Unknown', ''),
        '0019xxAA': ('DS', '1', 'Unknown', ''),
        '0019xxAB': ('DS', '1', 'Unknown', ''),
        '0019xxAC': ('DS', '1', 'Unknown', ''),
        '0019xxAD': ('DS', '1', 'Unknown', ''),
        '0019xxAE': ('DS', '1', 'Unknown', ''),
        '0019xxAF': ('ST', '1', 'Unknown', ''),
        '0019xxB0': ('ST', '1', 'Unknown', ''),
        '0019xxB1': ('ST', '1', 'Unknown', ''),
        '0019xxB2': ('IS', '1', 'Unknown', ''),
        '0019xxB3': ('IS', '1', 'Unknown', ''),
        '0019xxB4': ('IS', '1', 'Unknown', ''),
        '0019xxB5': ('DS', '1', 'Unknown', ''),
        '0019xxB6': ('DS', '1', 'Unknown', ''),
        '0019xxB7': ('ST', '1', 'Unknown', ''),
        '0019xxB8': ('DS', '1', 'Unknown', ''),
        '0019xxB9': ('ST', '1', 'Unknown', ''),
        '0019xxBA': ('ST', '1', 'Unknown', ''),
    },
    'SPI-P-Private-CWS Release 1': {
        '0021xx00': ('LT', '1', 'Window Of Images ID', ''),
        '0021xx01': ('CS', '1', 'Window Of Images Type', ''),
        '0021xx02': ('IS', '1-n', 'WindowOfImagesScope', ''),
    },
    'SPI-P-Private-DCI Release 1': {
        '0019xx10': ('UN', '1', 'Unknown', ''),
        '0019xx11': ('UN', '1', 'Unknown', ''),
        '0019xx12': ('UN', '1', 'Unknown', ''),
        '0019xx13': ('UN', '1', 'Unknown', ''),
        '0019xx14': ('UN', '1', 'Unknown', ''),
        '0019xx15': ('UN', '1', 'Unknown', ''),
        '0019xx16': ('UN', '1', 'Unknown', ''),
        '0019xx17': ('UN', '1', 'Unknown', ''),
    },
    'SPI-P-Private-DiDi Release 1': {
        '0019xx00': ('LT', '1', 'Post Mode String', ''),
        '0019xx01': ('LT', '1', 'Post Data', ''),
        '0019xx10': ('LT', '1', 'Image Header', ''),
        '0019xx20': ('LT', '1', 'SCPreName', ''),
        '0019xx21': ('IS', '1', 'SCPostNo', ''),
        '0019xx22': ('LT', '1', 'SCSOPInstanceUID', ''),
        '0019xx23': ('LT', '1', 'SCCreationDate', ''),
        '0019xx24': ('LT', '1', 'SCProcessingCategory', ''),
        '0019xx25': ('LT', '1', 'SCPostMethod', ''),
        '0019xx26': ('LT', '1', 'SCPostString', ''),
        '0019xx27': ('LT', '1', 'SCPostString2', ''),
        '0019xx28': ('LT', '1', 'SCMode', ''),
        '0019xx29': ('IS', '1', 'SCStCommit', ''),
        '0019xx2A': ('IS', '1', 'SCExported', ''),
        '0019xx2B': ('IS', '1', 'SCPrinted', ''),
        '0019xx2C': ('LT', '1', 'SCOperator', ''),
        '0019xx40': ('LT', '1', 'SCPreName', ''),
        '0019xx41': ('IS', '1', 'SCPreType', ''),
    },
    'SPI-P-Private_CDS Release 1': {
        '0021xx40': ('IS', '1', 'Unknown', ''),
        '0029xx00': ('UN', '1', 'Unknown', ''),
        '0029xx10': ('OB', '1', 'Unknown', ''),
    },
    'SPI-P-Private_ICS Release 1': {
        '0019xx30': ('DS', '1', 'Unknown', ''),
        '0019xx31': ('LO', '1', 'Unknown', ''),
        '0029xx07': ('SQ', '1', 'Unknown', ''),
        '0029xx08': ('SQ', '1', 'Unknown', ''),
        '0029xx0C': ('SQ', '1', 'Unknown', ''),
        '0029xx0D': ('SQ', '1', 'Unknown', ''),
        '0029xx0E': ('SQ', '1', 'Unknown', ''),
        '0029xx0F': ('SQ', '1', 'Unknown', ''),
        '0029xx10': ('SQ', '1', 'Unknown', ''),
        '0029xx18': ('FD', '1', 'Unknown', ''),
        '0029xx1B': ('SQ', '1', 'Unknown', ''),
        '0029xx1C': ('SQ', '1', 'Unknown', ''),
        '0029xx1D': ('SQ', '1', 'Unknown', ''),
        '0029xx1E': ('SQ', '1', 'Unknown', ''),
        '0029xx20': ('UN', '1', 'Unknown', ''),
        '0029xx21': ('SQ', '1', 'Unknown', ''),
        '0029xx4C': ('SQ', '1', 'Unknown', ''),
        '0029xx4D': ('SQ', '1', 'Unknown', ''),
        '0029xx4E': ('UN', '1', 'Unknown', ''),
        '0029xx4F': ('UN', '1', 'Unknown', ''),
        '0029xx50': ('UN', '1', 'Unknown', ''),
        '0029xx51': ('UN', '1', 'Unknown', ''),
        '0029xx66': ('DS', '4', 'Unknown', ''),
        '0029xx67': ('LO', '1', 'Unknown', ''),
        '0029xx68': ('US', '1', 'Unknown', ''),
        '0029xx6A': ('LO', '1', 'Unknown', ''),
        '0029xx6B': ('US', '1', 'Unknown', ''),
        '0029xx72': ('SQ', '1', 'Unknown', ''),
        '0029xx91': ('IS', '1', 'Unknown', ''),
        '0029xx93': ('LO', '1-n', 'Unknown', ''),
        '0029xx94': ('LO', '1-n', 'Unknown', ''),
    },
    'SPI-P-Private_ICS Release 1;1': {
        '0029xx00': ('SL', '1', 'Unknown', ''),
        '0029xx05': ('FL', '1', 'Unknown', ''),
        '0029xx06': ('FL', '1', 'Unknown', ''),
        '0029xx20': ('FL', '1', 'Unknown', ''),
        '0029xx21': ('FL', '1', 'Unknown', ''),
        '0029xx22': ('US', '1', 'Unknown', ''),
        '0029xx23': ('FD', '1', 'Unknown', ''),
        '0029xx24': ('FD', '1', 'Unknown', ''),
        '0029xx25': ('FD', '1', 'Unknown', ''),
        '0029xx26': ('FD', '1', 'Unknown', ''),
        '0029xx30': ('ST', '1', 'Unknown', ''),
        '0029xx6B': ('FD', '1', 'Unknown', ''),
        '0029xxC1': ('US', '1', 'Unknown', ''),
        '0029xxCB': ('FD', '1', 'Unknown', ''),
        '0029xxCC': ('FD', '1', 'Unknown', ''),
        '0029xxCD': ('SQ', '1', 'Unknown', ''),
        '0029xxD4': ('FL', '1', 'Unknown', ''),
        '0029xxD5': ('FL', '1', 'Unknown', ''),
        '0029xxD6': ('ST', '1', 'Unknown', ''),
    },
    'SPI-P-Private_ICS Release 1;2': {
        '0029xx00': ('FD', '1', 'Unknown', ''),
        '0029xx01': ('FD', '1', 'Unknown', ''),
        '0029xx02': ('FD', '1', 'Unknown', ''),
        '0029xx03': ('SL', '1', 'Unknown', ''),
        '0029xx04': ('SL', '1', 'Unknown', ''),
        '0029xx05': ('SL', '1', 'Unknown', ''),
        '0029xx30': ('LT', '1', 'Unknown', ''),
        '0029xxA0': ('SL', '1', 'Unknown', ''),
        '0029xxA1': ('FD', '1', 'Unknown', ''),
        '0029xxA2': ('SL', '1', 'Unknown', ''),
        '0029xxA3': ('SL', '1', 'Unknown', ''),
        '0029xxA5': ('SQ', '1', 'Unknown', ''),
        '0029xxA6': ('SL', '1', 'Unknown', ''),
        '0029xxD9': ('SQ', '1', 'Unknown', ''),
    },
    'SPI-P-Private_ICS Release 1;3': {
        '0029xx00': ('ST', '1', 'Unknown', ''),
        '0029xx01': ('ST', '1', 'Unknown', ''),
        '0029xx60': ('US', '1', 'Unknown', ''),
        '0029xxB0': ('SL', '1', 'Unknown', ''),
        '0029xxB1': ('FL', '1', 'Unknown', ''),
        '0029xxB2': ('FL', '1', 'Unknown', ''),
        '0029xxB4': ('FL', '1', 'Unknown', ''),
        '0029xxB9': ('FL', '1', 'Unknown', ''),
        '0029xxC0': ('SQ', '1', 'Unknown', ''),
        '0029xxC1': ('SQ', '1', 'Unknown', ''),
        '0029xxC2': ('SQ', '1', 'Unknown', ''),
        '0029xxC3': ('SQ', '1', 'Unknown', ''),
        '0029xxC4': ('SQ', '1', 'Unknown', ''),
        '0029xxC5': ('SQ', '1', 'Unknown', ''),
    },
    'SPI-P-Private_ICS Release 1;4': {
        '0029xx00': ('UL', '1', 'Unknown', ''),
        '0029xx01': ('FL', '2', 'Unknown', ''),
        '0029xx02': ('SQ', '1', 'Unknown', ''),
        '0029xx06': ('UL', '1', 'Unknown', ''),
        '0029xx07': ('SL', '1', 'Unknown', ''),
        '0029xx08': ('US', '1', 'Unknown', ''),
        '0029xx09': ('FL', '1', 'Unknown', ''),
        '0029xx0A': ('FL', '1', 'Unknown', ''),
        '0029xx0B': ('FL', '1', 'Unknown', ''),
        '0029xx0C': ('FL', '1', 'Unknown', ''),
        '0029xx0E': ('US', '1', 'Unknown', ''),
        '0029xx0F': ('US', '1', 'Unknown', ''),
        '0029xx10': ('SL', '1', 'Unknown', ''),
        '0029xx90': ('SL', '1', 'Unknown', ''),
        '0029xx9A': ('SQ', '1', 'Unknown', ''),
        '0029xx9C': ('SQ', '1', 'Unknown', ''),
        '0029xxA0': ('US', '1', 'Unknown', ''),
        '0029xxA1': ('US', '1', 'Unknown', ''),
        '0029xxB1': ('US', '1', 'Unknown', ''),
        '0029xxB2': ('US', '1', 'Unknown', ''),
        '0029xxB3': ('SL', '1', 'Unknown', ''),
        '0029xxB5': ('FL', '1', 'Unknown', ''),
        '0029xxB6': ('SL', '1', 'Unknown', ''),
        '0029xxBC': ('SL', '1', 'Unknown', ''),
        '0029xxBD': ('SL', '1', 'Unknown', ''),
        '0029xxBE': ('US', '1', 'Unknown', ''),
        '0029xxD6': ('FD', '1', 'Unknown', ''),
        '0029xxD7': ('FD', '1', 'Unknown', ''),
        '0029xxD8': ('UN', '1', 'Unknown', ''),
        '0029xxD9': ('UN', '1', 'Unknown', ''),
        '0029xxDA': ('UN', '1', 'Unknown', ''),
        '0029xxDC': ('FD', '1', 'Unknown', ''),
        '0029xxDD': ('FD', '1', 'Unknown', ''),
        '0029xxE0': ('SQ', '1', 'Unknown', ''),
    },
    'SPI-P-Private_ICS Release 1;5': {
        '0029xx50': ('CS', '1', 'Unknown', ''),
        '0029xx55': ('CS', '1', 'Unknown', ''),
    },
    'SPI-P-Private_ICS Release 1;6': {
        '0029xx01': ('FL', '1', 'Unknown', ''),
        '0029xx02': ('LO', '1', 'Unknown', ''),
        '0029xx03': ('UL', '1', 'Unknown', ''),
        '0029xx04': ('LO', '1', 'Unknown', ''),
        '0029xx06': ('SQ', '1', 'Unknown', ''),
        '0029xx07': ('SQ', '1', 'Unknown', ''),
        '0029xx08': ('US', '1', 'Unknown', ''),
        '0029xx0A': ('US', '1', 'Unknown', ''),
        '0029xx0B': ('US', '1', 'Unknown', ''),
        '0029xx0C': ('US', '1', 'Unknown', ''),
        '0029xx0D': ('US', '1', 'Unknown', ''),
        '0029xx0F': ('LO', '1', 'Unknown', ''),
        '0029xx10': ('US', '1', 'Unknown', ''),
        '0029xx14': ('SQ', '1', 'Unknown', ''),
        '0029xx15': ('UL', '2', 'Unknown', ''),
        '0029xx16': ('FL', '1', 'Unknown', ''),
        '0029xx17': ('FL', '1', 'Unknown', ''),
        '0029xx1A': ('UL', '1', 'Unknown', ''),
        '0029xx1D': ('US', '1', 'Unknown', ''),
        '0029xx1F': ('FL', '1', 'Unknown', ''),
        '0029xx20': ('FL', '1', 'Unknown', ''),
        '0029xx21': ('UL', '1', 'Unknown', ''),
        '0029xx23': ('US', '1', 'Unknown', ''),
        '0029xx24': ('UL', '1', 'Unknown', ''),
        '0029xx2A': ('UL', '1', 'Unknown', ''),
        '0029xx2B': ('SQ', '1', 'Unknown', ''),
        '0029xx2C': ('UL', '1', 'Unknown', ''),
        '0029xx2D': ('SQ', '1', 'Unknown', ''),
        '0029xx2E': ('SQ', '1', 'Unknown', ''),
        '0029xx2F': ('SQ', '1', 'Unknown', ''),
        '0029xx32': ('SQ', '1', 'Unknown', ''),
        '0029xx34': ('SQ', '1', 'Unknown', ''),
        '0029xx35': ('SQ', '1', 'Unknown', ''),
        '0029xx36': ('SQ', '1', 'Unknown', ''),
        '0029xx37': ('SQ', '1', 'Unknown', ''),
        '0029xx38': ('SQ', '1', 'Unknown', ''),
        '0029xx39': ('FL', '1', 'Unknown', ''),
        '0029xx3D': ('SQ', '1', 'Unknown', ''),
        '0029xx43': ('US', '1', 'Unknown', ''),
        '0029xx44': ('US', '1', 'Unknown', ''),
        '0029xx48': ('UL', '1', 'Unknown', ''),
        '0029xx4F': ('SQ', '1', 'Unknown', ''),
        '0029xx5C': ('SQ', '1', 'Unknown', ''),
        '0029xx5D': ('UL', '1-n', 'Unknown', ''),
        '0029xx5E': ('UL', '1', 'Unknown', ''),
        '0029xx5F': ('US', '1', 'Unknown', ''),
        '0029xx63': ('US', '1', 'Unknown', ''),
        '0029xx65': ('SQ', '1', 'Unknown', ''),
        '0029xx66': ('UL', '1', 'Unknown', ''),
        '0029xx67': ('UL', '1', 'Unknown', ''),
        '0029xx68': ('UL', '1', 'Unknown', ''),
        '0029xx69': ('UL', '1', 'Unknown', ''),
        '0029xx6D': ('SQ', '1', 'Unknown', ''),
    },
    'SPI-P-XSB-DCI Release 1': {
        '0019xx10': ('LT', '1', 'Video Beam Boost', ''),
        '0019xx11': ('US', '1', 'Channel Generating Video Sync', ''),
        '0019xx12': ('US', '1', 'Video Gain', ''),
        '0019xx13': ('US', '1', 'Video Offset', ''),
        '0019xx20': ('DS', '1', 'RTD Data Compression Factor', ''),
    },
    'SPI-P-XSB-VISUB Release 1': {
        '0019xx00': ('UN', '1', 'Unknown', ''),
        '0019xx10': ('UN', '1', 'Unknown', ''),
        '0019xx11': ('UN', '1', 'Unknown', ''),
        '0019xx12': ('UN', '1', 'Unknown', ''),
        '0019xx20': ('LO', '1', 'Unknown', ''),
        '0019xx40': ('UN', '1', 'Unknown', ''),
        '0019xx50': ('LO', '1', 'Unknown', ''),
        '0029xx00': ('LO', '1', 'Unknown', ''),
        '0029xx01': ('DS', '1', 'Unknown', ''),
        '0029xx02': ('CS', '1', 'Unknown', ''),
        '0029xx0F': ('CS', '1', 'Unknown', ''),
        '0029xx10': ('LO', '1', 'Unknown', ''),
        '0029xx11': ('DS', '1', 'Unknown', ''),
        '0029xx12': ('CS', '1', 'Unknown', ''),
        '0029xx1F': ('CS', '1', 'Unknown', ''),
        '0029xx20': ('LO', '1', 'Unknown', ''),
        '0029xx21': ('DS', '1', 'Unknown', ''),
        '0029xx22': ('CS', '1', 'Unknown', ''),
        '0029xx2F': ('CS', '1', 'Unknown', ''),
        '0029xx30': ('LO', '1', 'Unknown', ''),
        '0029xx31': ('DS', '1', 'Unknown', ''),
        '0029xx32': ('CS', '1', 'Unknown', ''),
        '0029xx3F': ('CS', '1', 'Unknown', ''),
    },
    'STENTOR': {
        '0073xx01': ('ST', '1', 'Unknown', ''),
        '0073xx02': ('LT', '1', 'Private Creator', ''),
        '0073xx03': ('UT', '1', 'Stentor Remote AETitle Element', ''),
        '0073xx04': ('UT', '1', 'Stentor Local AETitle Element', ''),
        '0073xx06': ('UT', '1', 'Stentor Transfer Syntax Value', ''),
    },
    'SVISION': {
        '0017xx00': ('LO', '1', 'Extended Body Part', ''),
        '0017xx10': ('LO', '1', 'Extended View Position', ''),
        '0017xx20': ('SQ', '1', 'Scheduled Procedure Step', ''),
        '0017xxA0': ('IS', '1', 'Fixed Grid System', ''),
        '0017xxF0': ('IS', '1', 'Images SOP Class', ''),
        '0019xx00': ('IS', '1', 'AEC Field', ''),
        '0019xx01': ('IS', '1', 'AEC Film Screen', ''),
        '0019xx02': ('IS', '1', 'AEC Density', ''),
        '0019xx10': ('IS', '1', 'Patient Thickness', ''),
        '0019xx16': ('IS', '1', 'Unknown', ''),
        '0019xx18': ('IS', '1', 'Beam Distance', ''),
        '0019xx20': ('IS', '1', 'Workstation Number', ''),
        '0019xx28': ('IS', '1', 'Tube Number', ''),
        '0019xx30': ('IS', '1', 'Bucky Grid', ''),
        '0019xx34': ('IS', '1', 'Focus', ''),
        '0019xx38': ('IS', '1', 'Age Group', ''),
        '0019xx40': ('IS', '1', 'Collimator Distance X', ''),
        '0019xx41': ('IS', '1', 'Collimator Distance Y', ''),
        '0019xx50': ('IS', '1', 'Bucky Height', ''),
        '0019xx60': ('IS', '1', 'Bucky Angle', ''),
        '0019xx68': ('IS', '1', 'C-Arm Angle', ''),
        '0019xx69': ('IS', '1', 'Collimator Angle', ''),
        '0019xx70': ('IS', '1', 'Filter Number', ''),
        '0019xx74': ('LO', '1', 'Filter Material 1', ''),
        '0019xx75': ('LO', '1', 'Filter Material 2', ''),
        '0019xx78': ('DS', '1', 'Filter Thickness 1', ''),
        '0019xx79': ('DS', '1', 'Filter Thickness 2', ''),
        '0019xx80': ('IS', '1', 'Bucky Format', ''),
        '0019xx81': ('IS', '1', 'Object Position', ''),
        '0019xx90': ('LO', '1', 'Desk Command', ''),
        '0019xx91': ('IS', '1', 'Central Beam X', ''),
        '0019xx92': ('IS', '1', 'Central Beam Y', ''),
        '0019xx93': ('IS', '1', 'Tube Turn Angle', ''),
        '0019xx94': ('IS', '1', 'Stand drive level', ''),
        '0019xxA0': ('DS', '1', 'Extended Exposure Time', ''),
        '0019xxA1': ('DS', '1', 'Actual Exposure Time', ''),
        '0019xxA8': ('DS', '1', 'Extended X-ray Tube Current', ''),
        '0019xxB0': ('IS', '1', 'Dose Indicator', ''),
        '0019xxB1': ('IS', '1', 'Shift Reference Value', ''),
        '0019xxF0': ('IS', '1', 'Unknown', ''),
        '0021xx00': ('DS', '1', 'Noise Reduction', ''),
        '0021xx01': ('DS', '1', 'Contrast Amplification', ''),
        '0021xx02': ('DS', '1', 'Edge Contrast Boosting', ''),
        '0021xx03': ('DS', '1', 'Latitude Reduction', ''),
        '0021xx10': ('LO', '1', 'Find Range Algorithm', ''),
        '0021xx11': ('DS', '1', 'Threshold C-Algorithm', ''),
        '0021xx20': ('LO', '1', 'Sensometric Curve', ''),
        '0021xx30': ('DS', '1', 'Lower Window Offset', ''),
        '0021xx31': ('DS', '1', 'Upper Window Offset', ''),
        '0021xx40': ('DS', '1', 'Min. Printable Density', ''),
        '0021xx41': ('DS', '1', 'Max. Printable Density', ''),
        '0021xx50': ('DS', '1', 'Min. Window Latitude', ''),
        '0021xx51': ('DS', '1', 'Max. Window Latitude', ''),
        '0021xx52': ('DS', '1', 'Rel. Window Alignment', ''),
        '0021xx60': ('DS', '1', 'Decomposition Layer', ''),
        '0021xx90': ('DS', '1', 'Brightness', ''),
        '0021xx91': ('DS', '1', 'Contrast', ''),
        '0021xx92': ('DS', '1', 'Shape Factor', ''),
        '0023xx00': ('LO', '1', 'Image Laterality', ''),
        '0023xx01': ('IS', '1', 'Letter Position', ''),
        '0023xx02': ('IS', '1', 'Burned In Annotation', ''),
        '0023xx03': ('LO', '1', 'Unknown', ''),
        '0023xxF0': ('IS', '1', 'Image SOP Class', ''),
        '0025xx00': ('IS', '1', 'Original Image', ''),
        '0025xx01': ('IS', '1', 'Not Processed Image', ''),
        '0025xx02': ('IS', '1', 'Cut Out Image', ''),
        '0025xx03': ('IS', '1', 'Duplicated Image', ''),
        '0025xx04': ('IS', '1', 'Stored Image', ''),
        '0025xx05': ('IS', '1', 'Retrieved Image', ''),
        '0025xx06': ('IS', '1', 'New Image', ''),
        '0025xx07': ('IS', '1', 'Media Stored Image', ''),
        '0025xx08': ('IS', '1', 'Image State', ''),
        '0025xx09': ('IS', '1', 'Image Stitched Manually', ''),
        '0025xx0A': ('IS', '1', 'Image Stitched Automatically', ''),
        '0025xx20': ('LO', '1', 'Source Image File', ''),
        '0025xx21': ('LO', '1', 'Source UID', ''),
        '0027xx00': ('IS', '1', 'Number of Series', ''),
        '0027xx01': ('IS', '1', 'Number of Studies', ''),
        '0027xx10': ('DT', '1', 'Oldest Series', ''),
        '0027xx11': ('DT', '1', 'Newest Series', ''),
        '0027xx12': ('DT', '1', 'Oldest Study', ''),
        '0027xx13': ('DT', '1', 'Newest Study', ''),
        '0029xx00': ('IS', '1', 'Key Note Instance UID', ''),
        '0029xx01': ('IS', '1', 'Storage State', ''),
        '0029xx02': ('IS', '1', 'Referenced Image SOP Class', ''),
        '0029xx03': ('LO', '1', 'Ref. Image Instance UID', ''),
        '0029xx04': ('IS', '1', 'Rel. Presentation State Number', ''),
        '0029xx05': ('LO', '1', 'Rel. Presentation State UID', ''),
    },
    'Siemens Ultrasound Miscellaneous': {
        '0019xx20': ('SH', '1', 'Unknown', ''),
    },
    'Siemens: Thorax/Multix FD Image Stamp': {
        '0023xx00': ('US', '1', 'Unknown', ''),
        '0023xx01': ('US', '1', 'Unknown', ''),
        '0023xx02': ('US', '1', 'Unknown', ''),
        '0023xx03': ('US', '1', 'Unknown', ''),
        '0023xx04': ('US', '1', 'Unknown', ''),
    },
    'Siemens: Thorax/Multix FD Lab Settings': {
        '0019xx00': ('LT', '1', 'Internal Value', ''),
        '0019xx02': ('LO', '1', 'Total Area Dose Product', ''),
        '0019xx04': ('LO', '1', 'Unknown', ''),
        '0019xx05': ('US', '1', 'Cassette Image', ''),
        '0019xx06': ('FD', '1', 'Table Object Distance', ''),
        '0019xx07': ('FD', '1', 'Table Detector Distance', ''),
        '0019xx08': ('US', '1', 'Ortho Step Distance', ''),
        '0021xx08': ('US', '1', 'Auto Window Flag', ''),
        '0021xx09': ('SL', '1', 'Auto Window Center', ''),
        '0021xx0A': ('SL', '1', 'Auto Window Width', ''),
        '0021xx0B': ('SS', '1', 'Filter ID', ''),
        '0021xx14': ('US', '1', 'Anatomic Correct View', ''),
        '0021xx15': ('SS', '1', 'Auto Window Shift', ''),
        '0021xx16': ('DS', '1', 'Auto Window Expansion', ''),
        '0021xx17': ('LO', '1', 'System Type', ''),
        '0021xx30': ('SH', '1', 'Anatomic Sort Number', ''),
        '0021xx31': ('SH', '1', 'Acquisition Sort Number', ''),
    },
    'Siemens: Thorax/Multix FD Post Processing': {
        '0021xx00': ('US', '1', 'Label Left', ''),
        '0021xx01': ('SS', '1', 'Label Left Orientation', ''),
        '0021xx02': ('FL', '1', 'Label Left Percentage X', ''),
        '0021xx03': ('FL', '1', 'Label Left Percentage X', ''),
        '0021xx04': ('US', '1', 'Label Right', ''),
        '0021xx05': ('SS', '1', 'Label Right Orientation', ''),
        '0021xx06': ('FL', '1', 'Label Right Percentage X', ''),
        '0021xx07': ('FL', '1', 'Label Right Percentage X', ''),
        '0021xx08': ('US', '1', 'Auto Window Flag', ''),
        '0021xx09': ('SL', '1', 'Auto Window Center', ''),
        '0021xx0A': ('SL', '1', 'Auto Window Width', ''),
        '0021xx0B': ('SS', '1', 'Filter ID', ''),
        '0021xx0C': ('FL', '1', 'Degree of Edge Enhancement', ''),
        '0021xx0D': ('SS', '1', 'Half Kernel Size', ''),
        '0021xx0E': ('US', '1', 'Dose Control Value', ''),
        '0021xx0F': ('US', '1', 'Deleted Image Flag', ''),
        '0021xx10': ('US', '1', 'Same Size Support', ''),
        '0021xx11': ('SS', '1', 'Label Left Init Position', ''),
        '0021xx12': ('SS', '1', 'Label Right Init Position', ''),
        '0021xx13': ('SS', '1', 'Patient Rotation', ''),
        '0021xx14': ('US', '1', 'Anatomic Correct View Flag', ''),
        '0021xx15': ('SS', '1', 'Auto Window Shift', ''),
        '0021xx16': ('DS', '1', 'Auto Window Expansion', ''),
    },
    'Siemens: Thorax/Multix FD Raw Image Settings': {
        '0025xx00': ('SS', '1', 'Raw Image Amplification', ''),
        '0025xx01': ('SS', '1', 'Gamma LUT', ''),
        '0025xx02': ('US', '1', 'Collimator Manual', ''),
        '0025xx03': ('FL', '1', 'Collimator Up Left X Percentage', ''),
        '0025xx04': ('FL', '1', 'Collimator Up Right X Percentage', ''),
        '0025xx05': ('FL', '1', 'Collimator Low Left X Percentage', ''),
        '0025xx06': ('FL', '1', 'Collimator Low Right X Percentage', ''),
        '0025xx07': ('FL', '1', 'Collimator Up Left Y Percentage', ''),
        '0025xx08': ('FL', '1', 'Collimator Up Right Y Percentage', ''),
        '0025xx09': ('FL', '1', 'Collimator Low Left Y Percentage', ''),
        '0025xx0A': ('FL', '1', 'Collimator Low Right Y Percentage', ''),
        '0025xx0B': ('US', '1', 'Set Gray', ''),
        '0025xx0C': ('SS', '1', 'Harmonization Kernel', ''),
        '0025xx0D': ('FL', '1', 'Harmonization Gain', ''),
        '0025xx0E': ('SS', '1', 'Edge Enhancement Kernel', ''),
        '0025xx0F': ('FL', '1', 'Edge Enhancement Gain', ''),
        '0025xx10': ('LT', '1', 'Raw Image File Name', ''),
        '0025xx11': ('SS', '1', 'Global Offset', ''),
        '0025xx12': ('SS', '1', 'Image Columns', ''),
        '0025xx13': ('SS', '1', 'Image Rows', ''),
        '0025xx14': ('SS', '1', 'Image Alignment', ''),
        '0025xx15': ('SS', '1', 'Active Image Columns', ''),
        '0025xx16': ('SS', '1', 'Active Image Rows', ''),
        '0025xx17': ('LO', '1', 'System Type', ''),
        '0025xx18': ('US', '1', 'Auto Gain', ''),
        '0025xx19': ('US', '1', 'Ortho Sub Sampling', ''),
        '0025xx1A': ('US', '2', 'Image Crop Upper Left', ''),
        '0025xx1B': ('US', '2', 'Image Crop Upper Right', ''),
        '0025xx1C': ('US', '2', 'Image Crop Lower Left', ''),
        '0025xx1D': ('US', '2', 'Image Crop Lower Right', ''),
        '0025xx30': ('US', '1', 'Manual Cropping', ''),
        '0025xx31': ('SS', '1', 'Gamma LUT Parameter 1', ''),
        '0025xx32': ('DS', '1', 'Gamma LUT Parameter 2', ''),
        '0025xx33': ('SS', '1', 'Gamma LUT Parameter 3', ''),
        '0025xx34': ('SS', '1', 'Gamma LUT Parameter 4', ''),
    },
    'Siemens: Thorax/Multix FD Version': {
        '0017xx00': ('LO', '1', 'Build Date', ''),
        '0017xx01': ('LO', '1', 'IOD Version', ''),
    },
    'Silhouette Annot V1.0': {
        '0029xx11': ('IS', '1', 'Annotation Name', ''),
        '0029xx12': ('LT', '1', 'Annotation Font', ''),
        '0029xx13': ('LT', '1', 'Annotation Text Foreground Color', ''),
        '0029xx14': ('LT', '1', 'Annotation Text Background Color', ''),
        '0029xx15': ('UL', '1', 'Annotation Text Backing Mode', ''),
        '0029xx16': ('UL', '1', 'Annotation Text Justification', ''),
        '0029xx17': ('UL', '1', 'Annotation Text Location', ''),
        '0029xx18': ('LT', '1', 'Annotation Text String', ''),
        '0029xx19': ('UL', '1', 'Annotation Text Attach Mode', ''),
        '0029xx20': ('UL', '1', 'Annotation Text Cursor Mode', ''),
        '0029xx21': ('UL', '1', 'Annotation Text Shadow Offset X', ''),
        '0029xx22': ('UL', '1', 'Annotation Text Shadow Offset Y', ''),
        '0029xx23': ('LT', '1', 'Annotation Line Color', ''),
        '0029xx24': ('UL', '1', 'Annotation Line Thickness', ''),
        '0029xx25': ('UL', '1', 'Annotation Line Type', ''),
        '0029xx26': ('UL', '1', 'Annotation Line Style', ''),
        '0029xx27': ('UL', '1', 'Annotation Line Dash Length', ''),
        '0029xx28': ('UL', '1', 'Annotation Line Attach Mode', ''),
        '0029xx29': ('UL', '1', 'Annotation Line Point Count', ''),
        '0029xx30': ('FD', '1', 'Annotation Line Points', ''),
        '0029xx31': ('UL', '1', 'Annotation Line Control Size', ''),
        '0029xx32': ('LT', '1', 'Annotation Marker Color', ''),
        '0029xx33': ('UL', '1', 'Annotation Marker Type', ''),
        '0029xx34': ('UL', '1', 'Annotation Marker Size', ''),
        '0029xx35': ('FD', '1', 'Annotation Marker Location', ''),
        '0029xx36': ('UL', '1', 'Annotation Marker Attach Mode', ''),
        '0029xx37': ('LT', '1', 'Annotation Geom Color', ''),
        '0029xx38': ('UL', '1', 'Annotation Geom Thickness', ''),
        '0029xx39': ('UL', '1', 'Annotation Geom Line Style', ''),
        '0029xx40': ('UL', '1', 'Annotation Geom Dash Length', ''),
        '0029xx41': ('UL', '1', 'Annotation Geom Fill Pattern', ''),
        '0029xx42': ('UL', '1', 'Annotation Interactivity', ''),
        '0029xx43': ('FD', '1', 'Annotation Arrow Length', ''),
        '0029xx44': ('FD', '1', 'Annotation Arrow Angle', ''),
        '0029xx45': ('UL', '1', "Annotation Don't Save", ''),
    },
    'Silhouette Graphics Export V1.0': {
        '0029xx00': ('UI', '1', 'Unknown', ''),
    },
    'Silhouette Line V1.0': {
        '0029xx11': ('IS', '1', 'Line Name', ''),
        '0029xx12': ('LT', '1', 'Line Name Font', ''),
        '0029xx13': ('UL', '1', 'Line Name Display', ''),
        '0029xx14': ('LT', '1', 'Line Normal Color', ''),
        '0029xx15': ('UL', '1', 'Line Type', ''),
        '0029xx16': ('UL', '1', 'Line Thickness', ''),
        '0029xx17': ('UL', '1', 'Line Style', ''),
        '0029xx18': ('UL', '1', 'Line Dash Length', ''),
        '0029xx19': ('UL', '1', 'Line Interactivity', ''),
        '0029xx20': ('LT', '1', 'Line Measurement Color', ''),
        '0029xx21': ('LT', '1', 'Line Measurement Font', ''),
        '0029xx22': ('UL', '1', 'Line Measurement Dash Length', ''),
        '0029xx23': ('UL', '1', 'Line Point Space', ''),
        '0029xx24': ('FD', '1', 'Line Points', ''),
        '0029xx25': ('UL', '1', 'Line Control Point Size', ''),
        '0029xx26': ('UL', '1', 'Line Control Point Space', ''),
        '0029xx27': ('FD', '1', 'Line Control Points', ''),
        '0029xx28': ('LT', '1', 'Line Label', ''),
        '0029xx29': ('UL', '1', "Line Don't Save", ''),
    },
    'Silhouette ROI V1.0': {
        '0029xx11': ('IS', '1', 'ROI Name', ''),
        '0029xx12': ('LT', '1', 'ROI Name Font', ''),
        '0029xx13': ('LT', '1', 'ROI Normal Color', ''),
        '0029xx14': ('UL', '1', 'ROI Fill Pattern', ''),
        '0029xx15': ('UL', '1', 'ROI Bp Seg', ''),
        '0029xx16': ('UN', '1', 'ROI Bp Seg Pairs', ''),
        '0029xx17': ('UL', '1', 'ROI Seed Space', ''),
        '0029xx18': ('UN', '1', 'ROI Seeds', ''),
        '0029xx19': ('UL', '1', 'ROI Line Thickness', ''),
        '0029xx20': ('UL', '1', 'ROI Line Style', ''),
        '0029xx21': ('UL', '1', 'ROI Line Dash Length', ''),
        '0029xx22': ('UL', '1', 'ROI Interactivity', ''),
        '0029xx23': ('UL', '1', 'ROI Name Position', ''),
        '0029xx24': ('UL', '1', 'ROI Name Display', ''),
        '0029xx25': ('LT', '1', 'ROI Label', ''),
        '0029xx26': ('UL', '1', 'ROI Shape', ''),
        '0029xx27': ('FD', '1', 'ROI Shape Tilt', ''),
        '0029xx28': ('UL', '1', 'ROI Shape Points Count', ''),
        '0029xx29': ('UL', '1', 'ROI Shape Points Space', ''),
        '0029xx30': ('FD', '1', 'ROI Shape Points', ''),
        '0029xx31': ('UL', '1', 'ROI Shape Control Points Count', ''),
        '0029xx32': ('UL', '1', 'ROI Shape Control Points Space', ''),
        '0029xx33': ('FD', '1', 'ROI Shape Control Points', ''),
        '0029xx34': ('UL', '1', "ROI Don't Save", ''),
    },
    'Silhouette Sequence Ids V1.0': {
        '0029xx41': ('SQ', '1', 'Unknown', ''),
        '0029xx42': ('SQ', '1', 'Unknown', ''),
        '0029xx43': ('SQ', '1', 'Unknown', ''),
    },
    'Silhouette V1.0': {
        '0029xx13': ('UL', '1', 'Unknown', ''),
        '0029xx14': ('UL', '1', 'Unknown', ''),
        '0029xx17': ('UN', '1', 'Unknown', ''),
        '0029xx18': ('UN', '1', 'Unknown', ''),
        '0029xx19': ('UL', '1', 'Unknown', ''),
        '0029xx1A': ('UN', '1', 'Unknown', ''),
        '0029xx1B': ('UL', '1', 'Unknown', ''),
        '0029xx1C': ('UL', '1', 'Unknown', ''),
        '0029xx1D': ('UN', '1', 'Unknown', ''),
        '0029xx1E': ('UN', '1', 'Unknown', ''),
        '0029xx21': ('US', '1', 'Unknown', ''),
        '0029xx22': ('US', '1', 'Unknown', ''),
        '0029xx23': ('US', '1', 'Unknown', ''),
        '0029xx24': ('US', '1', 'Unknown', ''),
        '0029xx25': ('US', '1', 'Unknown', ''),
        '0029xx27': ('UN', '1', 'Unknown', ''),
        '0029xx28': ('UN', '1', 'Unknown', ''),
        '0029xx29': ('UN', '1', 'Unknown', ''),
        '0029xx30': ('UN', '1', 'Unknown', ''),
        '0029xx52': ('US', '1', 'Unknown', ''),
        '0029xx53': ('LT', '1', 'Unknown', ''),
        '0029xx54': ('UN', '1', 'Unknown', ''),
        '0029xx55': ('LT', '1', 'Unknown', ''),
        '0029xx56': ('LT', '1', 'Unknown', ''),
        '0029xx57': ('UN', '1', 'Unknown', ''),
    },
    'Silhouette VRS 3.0': {
        '0029xx13': ('UL', '1', 'Unknown', ''),
        '0029xx14': ('UL', '1', 'Unknown', ''),
        '0029xx17': ('FD', '2', 'Unknown', ''),
        '0029xx18': ('FD', '2', 'Unknown', ''),
        '0029xx19': ('UL', '1', 'Unknown', ''),
        '0029xx1A': ('FD', '1', 'Unknown', ''),
        '0029xx1B': ('UL', '1', 'Unknown', ''),
        '0029xx1C': ('UL', '1', 'Unknown', ''),
        '0029xx1D': ('UL', '3', 'Unknown', ''),
        '0029xx1E': ('UL', '3', 'Unknown', ''),
        '0029xx27': ('US', '1', 'Unknown', ''),
        '0029xx28': ('OB', '1', 'Unknown', ''),
        '0029xx30': ('US', '1', 'Unknown', ''),
        '0029xx32': ('US', '1', 'Unknown', ''),
        '0029xx34': ('LO', '1', 'Unknown', ''),
        '0029xx35': ('CS', '1', 'Unknown', ''),
        '0029xx36': ('US', '1', 'Unknown', ''),
    },
    'Sound Technologies': {
        'F001xx00': ('CS', '1', 'Patient Species', ''),
        'F001xx01': ('CS', '1', 'Patient Breed', ''),
        'F001xx02': ('CS', '1', 'Patient Category Size', ''),
        'F001xx03': ('CS', '1', 'Patient Sex Extended (including spay/neuter)', ''),
        'F001xx04': ('CS', '1', 'Image View', ''),
        'F001xx05': ('CS', '1', 'Anatomy Imaged', ''),
        'F001xx06': ('CS', '1', 'Image enhancements', ''),
        'F001xx07': ('CS', '1', 'Detector Settings', ''),
        'F001xx08': ('CS', '1', 'Application Version', ''),
        'F001xx09': ('LO', '1', 'Image Laterality Extended', ''),
        'F001xx0A': ('PN', '1', 'Client Name', ''),
        'F001xx0B': ('UI', '1', 'Reference Study Instance Uid', ''),
        'F001xx0C': ('UI', '1', 'Reference Series Instance Uid', ''),
        'F001xx0D': ('LO', '1', 'Exam Ref Id', ''),
        'F001xx0E': ('ST', '1', 'Physician Of Record Address', ''),
        'F001xx0F': ('SH', '1', 'Physician Of Record Phone Numbers', ''),
        'F001xx10': ('LT', '1', 'Reason For Study', ''),
        'F001xx11': ('LO', '1', 'Protocol', ''),
        'F001xx12': ('LO', '1', 'CaptureInputType', ''),
        'F001xx13': ('LT', '1', 'Exam Complaint', ''),
        'F001xx14': ('LO', '1', 'Exam Web Code', ''),
        'F001xx15': ('LO', '1', 'Exam Category', ''),
        'F001xx16': ('SH', '1', 'Exam Diagnosis', ''),
        'F001xx17': ('PN', '1', 'Exam Created By', ''),
        'F001xx18': ('LO', '1', 'Exam Created By Group', ''),
        'F001xx19': ('DT', '1', 'Exam Required By DateTime', ''),
        'F001xx1A': ('LO', '1', 'Capture Type', ''),
        'F001xx1B': ('IS', '1', 'Telemed Exam ID', ''),
        'F001xx1C': ('LO', '1', 'Exam Created By Guid', ''),
        'F001xx1D': ('LO', '1', 'Client Name Guid', ''),
    },
    'TMDTK': {
        '7EFFxx21': ('SQ', '1', 'Unknown', ''),
        '7EFFxx2E': ('LT', '1', 'Unknown', ''),
    },
    'TOSHIBA COMAPL HEADER': {
        '0029xx08': ('CS', '1', 'COMAPL Header Type', ''),
        '0029xx09': ('LO', '1', 'COMAPL Header Version', ''),
        '0029xx10': ('LO', '1', '', ''),
        '0029xx20': ('OB', '1', 'COMAPL History Information', ''),
        '0029xx31': ('LO', '1-n', '', ''),
        '0029xx32': ('UL', '1-n', '', ''),
        '0029xx33': ('UL', '1-n', '', ''),
        '0029xx34': ('CS', '1-n', '', ''),
    },
    'TOSHIBA COMAPL OOG': {
        '0029xx08': ('CS', '1', 'COMAPL OOG Type', ''),
        '0029xx09': ('LO', '1', 'COMAPL OOG Version', ''),
        '0029xx10': ('LO', '1', '', ''),
        '0029xx31': ('LO', '1-n', '', ''),
        '0029xx32': ('UL', '1-n', '', ''),
        '0029xx33': ('UL', '1-n', '', ''),
        '0029xx34': ('CS', '1-n', '', ''),
    },
    'TOSHIBA ENCRYPTED SR DATA': {
        '7015xx00': ('OB', '1', 'Toshiba US Private Data', ''),
    },
    'TOSHIBA MDW HEADER': {
        '0029xx08': ('CS', '1', 'Application Header Type', ''),
        '0029xx09': ('LO', '1', 'Application Header Version', ''),
        '0029xx10': ('CS', '1', 'Image Header Type', ''),
        '0029xx11': ('LO', '1', 'Image Header Version', ''),
        '0029xx12': ('OB', '1', 'Image Header Info', ''),
        '0029xx18': ('CS', '1', 'Series Header Type', ''),
        '0029xx19': ('LO', '1', 'Series Header Version', ''),
        '0029xx20': ('OB', '1', 'Series Header Info', ''),
        '0029xx31': ('LO', '1', 'PMTF Information 1', ''),
        '0029xx32': ('UL', '1', 'PMTF Information 2', ''),
        '0029xx33': ('UL', '1', 'PMTF Information 3', ''),
        '0029xx34': ('CS', '1', 'PMTF Information 4', ''),
    },
    'TOSHIBA MDW NON-IMAGE': {
        '0029xx08': ('CS', '1', 'Application Header Type', ''),
        '0029xx09': ('LO', '1', 'Application Header Version', ''),
        '0029xx10': ('OB', '1', 'Application Header Data', ''),
        '0029xx20': ('OB', '1', 'Application Header Data', ''),
        '7FE1xx10': ('OB', '1', 'Toshiba US Private Data', ''),
    },
    'TOSHIBA_MEC_1.0': {
        '0009xx01': ('LT', '1', 'Unknown', ''),
        '0009xx02': ('US', '1-n', 'Unknown', ''),
        '0009xx03': ('US', '1-n', 'Unknown', ''),
        '0009xx04': ('US', '1-n', 'Unknown', ''),
        '0011xx01': ('LT', '1', 'Unknown', ''),
        '0011xx02': ('US', '1-n', 'Unknown', ''),
        '0019xx01': ('US', '1-n', 'Unknown', ''),
        '0019xx02': ('US', '1-n', 'Unknown', ''),
        '0021xx01': ('US', '1-n', 'Unknown', ''),
        '0021xx02': ('US', '1-n', 'Unknown', ''),
        '0021xx03': ('US', '1-n', 'Unknown', ''),
        '7FF1xx01': ('US', '1-n', 'Unknown', ''),
        '7FF1xx02': ('US', '1-n', 'Unknown', ''),
        '7FF1xx03': ('US', '1-n', 'Unknown', ''),
        '7FF1xx10': ('US', '1-n', 'Unknown', ''),
    },
    'TOSHIBA_MEC_CT3': {
        '7005xx00': ('OB', '1-n', 'CT Private Data 1', ''),
        '7005xx03': ('SH', '1', 'Cardiac R-R Mean Time', ''),
        '7005xx04': ('SH', '1', 'Cardiac Reconstruction Gating Phase in Percent', ''),
        '7005xx05': ('SH', '1', 'Cardiac Reconstruction Gating Phase in ms', ''),
        '7005xx06': ('SH', '1', 'Cardiac Reconstruction Mode', ''),
        '7005xx07': ('DS', '2', 'Reconstruction Center', ''),
        '7005xx08': ('DS', '1', 'Detector Slice Thickness in mm', ''),
        '7005xx09': ('LO', '1', 'Number of Detector rows to Reconstruct', ''),
        '7005xx0A': ('DS', '1', 'Table Speed in mm/rot', ''),
        '7005xx0B': ('SH', '1', 'Filter', ''),
        '7005xx0C': ('SH', '1', 'Reconstruction Correction Type', ''),
        '7005xx0D': ('CS', '1', 'Organ', ''),
        '7005xx0E': ('SH', '1', 'File Type Remarks', ''),
        '7005xx0F': ('SH', '1', 'Direction', ''),
        '7005xx10': ('OB', '1-n', 'CT Private Data 2', ''),
        '7005xx11': ('LT', '1', 'Series Comment', ''),
        '7005xx12': ('SH', '1', 'Position', ''),
        '7005xx13': ('US', '1', 'Expert Plan No.', ''),
        '7005xx14': ('US', '1', 'Reconstruction ROI No.', ''),
        '7005xx15': ('US', '1', 'Special Helical ACQ No.', ''),
        '7005xx16': ('UI', '1', 'Volume UID', ''),
        '7005xx17': ('US', '1', 'Total Frame Count in the Volume', ''),
        '7005xx18': ('US', '1', 'Frame No.', ''),
        '7005xx19': ('UL', '1', 'Frame Sort Key', ''),
        '7005xx1A': ('US', '1', 'Frame Sort Order', ''),
        '7005xx1B': ('SH', '1', 'Convolution Kernel', ''),
        '7005xx1C': ('LO', '1', 'Contrast/Bolus Agent', ''),
        '7005xx1D': ('UL', '1', 'Reconstruction Number', ''),
        '7005xx1E': ('UL', '1', 'Raw Data Number', ''),
        '7005xx1F': ('LO', '1', 'Volume Number', ''),
        '7005xx20': ('UL', '1', 'Local Series Number', ''),
        '7005xx21': ('LO', '1', 'Decrease in Artifact Filter', ''),
        '7005xx22': ('DS', '1', 'Reconstruction Interval', ''),
        '7005xx23': ('DS', '1', 'Pitch Factor', ''),
        '7005xx24': ('DA', '1', 'The Acquisition Date of NRA', ''),
        '7005xx25': ('UL', '1', 'Large Data File Attribute', ''),
        '7005xx26': ('CS', '1-8', 'Large Data File Name', ''),
        '7005xx28': ('SQ', '1', 'Enhanced CT Private Sequence', ''),
        '7005xx29': ('UI', '1', 'Frame UID', ''),
        '7005xx30': ('CS', '1', 'Main Modality in Study', ''),
        '7005xx35': ('DS', '2', 'Scan Range', ''),
        '7005xx36': ('OB', '1-n', 'CT Private Data 3', ''),
        '7005xx37': ('IS', '1', 'Total Frames', ''),
        '7005xx38': ('IS', '1', 'Start Frame', ''),
        '7005xx39': ('IS', '1', 'End Frame', ''),
        '7005xx40': ('FD', '1', 'DLP Dose Length Product', ''),
        '7005xx41': ('SH', '1', 'Raw Slice Information', ''),
        '7005xx42': ('US', '1', 'Local Frame No', ''),
        '7005xx43': ('DS', '3', 'Volume Vector', ''),
        '7005xx44': ('US', '1', 'Volume Type', ''),
        '7005xx45': ('DS', '1', 'Relative Table Position of 4D Volume', ''),
        '7005xx46': ('DS', '1', 'Absolute Table Position of 4D Volume', ''),
        '7005xx47': ('DS', '1', 'Slice Pitch of 4D Volume', ''),
        '7005xx48': ('LO', '1', 'Respiratory Gating Inf.', ''),
        '7005xx49': ('SH', '1', 'Respiration Phase', ''),
        '7005xxF1': ('CS', '1', 'Protect Mark for Image, Curve or Private Record', ''),
        '7005xxF2': ('CS', '1', 'Protect Mark for Series Record', ''),
        '7005xxF3': ('CS', '1', 'Protect Mark for Study Record', ''),
    },
    'TOSHIBA_MEC_CT_1.0': {
        '0019xx01': ('IS', '1', 'Unknown', ''),
        '0019xx02': ('IS', '1', 'Unknown', ''),
        '0019xx03': ('US', '1-n', 'Unknown', ''),
        '0019xx04': ('LT', '1', 'Unknown', ''),
        '0019xx05': ('LT', '1', 'Unknown', ''),
        '0019xx06': ('US', '1-n', 'Unknown', ''),
        '0019xx07': ('US', '1-n', 'Unknown', ''),
        '0019xx08': ('LT', '1', 'Orientation Head Feet', ''),
        '0019xx09': ('LT', '1', 'View Direction', ''),
        '0019xx0A': ('LT', '1', 'Orientation Supine Prone', ''),
        '0019xx0B': ('DS', '1', 'Location', ''),
        '0019xx0C': ('CS', '1', 'Scan View Direction', ''),
        '0019xx0D': ('TM', '1', 'Time', ''),
        '0019xx0E': ('DS', '1', 'Unknown', ''),
        '7FF1xx01': ('US', '1-n', 'Unknown', ''),
        '7FF1xx02': ('US', '1-n', 'Unknown', ''),
        '7FF1xx03': ('IS', '1', 'Unknown', ''),
        '7FF1xx04': ('IS', '1', 'Unknown', ''),
        '7FF1xx05': ('US', '1-n', 'Unknown', ''),
        '7FF1xx07': ('US', '1-n', 'Unknown', ''),
        '7FF1xx08': ('US', '1-n', 'Unknown', ''),
        '7FF1xx09': ('US', '1-n', 'Unknown', ''),
        '7FF1xx0A': ('LT', '1', 'Unknown', ''),
        '7FF1xx0B': ('US', '1-n', 'Unknown', ''),
        '7FF1xx0C': ('US', '1-n', 'Unknown', ''),
        '7FF1xx0D': ('US', '1-n', 'Unknown', ''),
    },
    'TOSHIBA_MEC_MR3': {
        '00290089': ('LO', '1', 'Unknown', ''),
        '700Dxx00': ('DS', '1', 'Scale Factor', ''),
        '700Dxx01': ('OB', '1', 'Acquisition Order', ''),
        '700Dxx02': ('DS', '9', 'Orientation Vector', ''),
        '700Dxx03': ('SS', '1', 'Flip Flag', ''),
        '700Dxx04': ('OB', '1', 'Rotate Information', ''),
        '700Dxx05': ('DS', '1', 'FOV', ''),
        '700Dxx06': ('US', '4', 'Image Matrix', ''),
        '700Dxx07': ('OB', '1', 'Image Information', ''),
        '700Dxx08': ('OB', '1', 'Original Data', ''),
        '700Dxx09': ('SS', '1', 'Original Data Flag', ''),
        '700Dxx0C': ('CS', '1', 'Receiver Gain Correction Check Flag', ''),
        '700Dxx20': ('SH', '1', 'Identification Flag of 3D GDC', ''),
        '700Dxx80': ('US', '1', 'Number of PAC channel', ''),
        '700Dxx81': ('US', '1', 'Reference mode', ''),
        '700Dxx82': ('SQ', '1', 'Gain value group for MRS', ''),
        '700Dxx83': ('FL', '1', 'Gain value of each channel for MRS', ''),
        '700Dxx84': ('FL', '1', 'Phase value of each channel for MRS', ''),
        '700Dxx85': ('FL', '1', 'Reference gain value of each channel for MRS', ''),
        '700Dxx86': ('FL', '1', 'Reference gain value of each channel for MRS', ''),
        '700Dxx87': ('FL', '1', 'Receiver gain of reference scan', ''),
        '700Dxx88': ('UL', '1', 'Flag of water Sat pulse', ''),
        '700Dxx89': ('FL', '1', 'Selected contrast TE', ''),
        '700Dxx8A': ('SQ', '1', 'Raw Data Set Sequence', ''),
        '700Dxx8B': ('DS', '1', 'Multi Slice number', ''),
        '700Dxx8C': ('DS', '1', 'Multi Coverage number', ''),
        '700Dxx8D': ('SQ', '1', 'Raw Data Sequence', ''),
        '700Dxx8E': ('DS', '1', 'Coil Channel No.', ''),
        '700Dxx8F': ('OB', '1', 'MRS Raw Data', ''),
        '700Dxx90': ('OF', '1', 'MRS Ref Raw Data', ''),
        '700Dxx91': ('FL', '1', 'Receiver gain of prescan', ''),
    },
    'TOSHIBA_MEC_MR3^10': {
        '00090002': ('SH', '1', 'Unknown', ''),
        '00110003': ('US', '1', 'Unknown', ''),
        '00110004': ('SQ', '1', 'Unknown', ''),
        '00110005': ('US', '1', 'Unknown', ''),
        '00110006': ('US', '1', 'Unknown', ''),
        '00110007': ('US', '1-n', 'Unknown', ''),
        '00110008': ('SH', '1', 'Unknown', ''),
        '0011000C': ('SS', '1', 'Unknown', ''),
        '0011000E': ('US', '2', 'Unknown', ''),
        '00190001': ('UL', '1', 'Unknown', ''),
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('US', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190005': ('FL', '1', 'Unknown', ''),
        '00190006': ('SL', '1', 'Unknown', ''),
        '00190007': ('FL', '3', 'Unknown', ''),
        '00190008': ('US', '1', 'Unknown', ''),
        '00190009': ('FL', '1', 'Unknown', ''),
        '0019000A': ('FL', '1', 'Unknown', ''),
        '0019000B': ('FL', '1', 'Unknown', ''),
        '0019000C': ('US', '3', 'Unknown', ''),
        '0019000D': ('SL', '6', 'Unknown', ''),
        '0019000E': ('SL', '6', 'Unknown', ''),
        '0019000F': ('SL', '6', 'Unknown', ''),
        '00190010': ('US', '2', 'Unknown', ''),
        '00190011': ('SL', '2', 'Unknown', ''),
        '00190012': ('US', '1', 'Unknown', ''),
        '00190013': ('SL', '1', 'Unknown', ''),
        '00190014': ('US', '1', 'Unknown', ''),
        '00190015': ('SL', '1', 'Unknown', ''),
        '00190016': ('FL', '1', 'Unknown', ''),
        '00190017': ('SL', '1', 'Unknown', ''),
        '00190018': ('US', '1', 'Unknown', ''),
        '00190019': ('SL', '1', 'Unknown', ''),
        '0019001A': ('US', '1', 'Unknown', ''),
        '0019001B': ('SL', '1', 'Unknown', ''),
        '0019001C': ('SL', '1', 'Unknown', ''),
        '0019001D': ('SL', '1', 'Unknown', ''),
        '0019001E': ('US', '1', 'Unknown', ''),
        '0019001F': ('SL', '1', 'Unknown', ''),
        '00190020': ('FL', '2', 'Unknown', ''),
        '00190021': ('US', '1', 'Unknown', ''),
        '00190022': ('SL', '2', 'Unknown', ''),
        '00190023': ('FL', '1', 'Unknown', ''),
        '00190024': ('FL', '1', 'Unknown', ''),
        '00190025': ('FL', '1', 'Unknown', ''),
        '00190026': ('SL', '1', 'Unknown', ''),
        '00190027': ('SL', '1', 'Unknown', ''),
        '00190028': ('SL', '1', 'Unknown', ''),
        '00190029': ('SH', '1', 'Unknown', ''),
        '0019002B': ('SH', '1', 'Unknown', ''),
        '0019002C': ('SL', '1', 'Unknown', ''),
        '0019002D': ('SL', '1', 'Unknown', ''),
        '0019002E': ('US', '1', 'Unknown', ''),
        '0019002F': ('FL', '1', 'Unknown', ''),
        '00190030': ('UL', '1', 'Unknown', ''),
        '00190031': ('OF', '1-n', 'Unknown', ''),
        '00190032': ('FL', '1', 'Unknown', ''),
        '00190033': ('SL', '3', 'Unknown', ''),
        '00190034': ('SL', '1', 'Unknown', ''),
        '00190035': ('SL', '1', 'Unknown', ''),
        '00190036': ('SQ', '1', 'Unknown', ''),
        '00190038': ('SL', '1', 'Unknown', ''),
        '0019003A': ('SL', '1', 'Unknown', ''),
        '0019003B': ('SL', '2', 'Unknown', ''),
        '0019003C': ('SL', '1', 'Unknown', ''),
        '0019003D': ('SL', '1', 'Unknown', ''),
        '0019003E': ('SL', '1', 'Unknown', ''),
        '0019003F': ('SL', '1', 'Unknown', ''),
        '00190042': ('US', '1', 'Unknown', ''),
        '00190043': ('US', '1', 'Unknown', ''),
        '00190044': ('SL', '1', 'Unknown', ''),
        '00190045': ('SS', '1', 'Unknown', ''),
        '00190046': ('US', '1', 'Unknown', ''),
        '00190047': ('FL', '1', 'Unknown', ''),
        '00190048': ('US', '1', 'Unknown', ''),
        '00190049': ('US', '1', 'Unknown', ''),
        '0019004B': ('US', '1', 'Unknown', ''),
        '0019004C': ('US', '1', 'Unknown', ''),
        '0019004D': ('SL', '1', 'Unknown', ''),
        '0019004E': ('US', '1', 'Unknown', ''),
        '0019004F': ('US', '1', 'Unknown', ''),
        '00190050': ('SL', '2', 'Unknown', ''),
        '00190051': ('SL', '2', 'Unknown', ''),
        '00190052': ('LO', '1', 'Unknown', ''),
        '00190054': ('US', '1', 'Unknown', ''),
        '00190055': ('US', '1', 'Unknown', ''),
        '00190057': ('FL', '3', 'Unknown', ''),
        '00190058': ('FL', '3', 'Unknown', ''),
        '00190059': ('SL', '1', 'Unknown', ''),
        '0019005A': ('FL', '1-n', 'Unknown', ''),
        '0019005D': ('FL', '1-n', 'Unknown', ''),
        '0019005E': ('SL', '1', 'Unknown', ''),
        '0019005F': ('FL', '1', 'Unknown', ''),
        '00190060': ('US', '1', 'Unknown', ''),
        '00190061': ('US', '1', 'Unknown', ''),
        '00190062': ('US', '1', 'Unknown', ''),
        '00190063': ('FL', '1', 'Unknown', ''),
        '00190064': ('FL', '1', 'Unknown', ''),
        '00190065': ('SL', '2', 'Unknown', ''),
        '00190069': ('FL', '1', 'Unknown', ''),
        '0019006A': ('US', '1', 'Unknown', ''),
        '0019006B': ('SL', '1', 'Unknown', ''),
        '0019006D': ('SL', '1', 'Unknown', ''),
        '0019006E': ('FL', '1', 'Unknown', ''),
        '0019006F': ('SL', '1', 'Unknown', ''),
        '00190070': ('LO', '1', 'Unknown', ''),
        '00190071': ('LO', '1', 'Unknown', ''),
        '00190073': ('LO', '1', 'Unknown', ''),
        '00190075': ('LO', '1', 'Unknown', ''),
        '00190076': ('LO', '1', 'Unknown', ''),
        '00190078': ('LO', '1', 'Unknown', ''),
        '0019007B': ('LO', '1', 'Unknown', ''),
        '0019007C': ('FL', '1', 'Unknown', ''),
        '0019007D': ('FL', '1', 'Unknown', ''),
        '0019007E': ('SL', '1', 'Unknown', ''),
        '0019007F': ('SL', '1', 'Unknown', ''),
        '00190085': ('FL', '1', 'Unknown', ''),
        '00190086': ('SL', '1', 'Unknown', ''),
        '00190087': ('FL', '1', 'Unknown', ''),
        '00190088': ('LO', '1', 'Unknown', ''),
        '0019008A': ('SL', '1-n', 'Unknown', ''),
        '0019008C': ('UL', '1', 'Unknown', ''),
        '0019008D': ('TM', '1', 'Unknown', ''),
        '0019008E': ('SL', '1', 'Unknown', ''),
        '00190092': ('SL', '1', 'Unknown', ''),
        '00190093': ('FL', '3', 'Unknown', ''),
        '00190096': ('US', '1', 'Unknown', ''),
        '0019009B': ('FL', '3', 'Unknown', ''),
        '0019009C': ('SL', '1', 'Unknown', ''),
        '001900A0': ('SL', '4', 'Unknown', ''),
        '001900A1': ('DS', '1', 'Unknown', ''),
        '001900A2': ('SL', '1', 'Unknown', ''),
        '001900A3': ('SL', '3', 'Unknown', ''),
        '001900A4': ('FL', '3', 'Unknown', ''),
        '001900A5': ('FL', '1', 'Unknown', ''),
        '001900A6': ('SL', '1', 'Unknown', ''),
        '001900A8': ('FL', '1', 'Unknown', ''),
        '001900A9': ('SL', '1', 'Unknown', ''),
        '001900AB': ('FL', '3', 'Unknown', ''),
        '001900AC': ('US', '1', 'Unknown', ''),
        '001900AD': ('FL', '1', 'Unknown', ''),
        '001900AE': ('FL', '1', 'Unknown', ''),
        '001900AF': ('SL', '1', 'Unknown', ''),
        '001900B0': ('SL', '1', 'Unknown', ''),
        '001900B1': ('SL', '1', 'Unknown', ''),
        '001900B4': ('SL', '1', 'Unknown', ''),
        '001900B5': ('SL', '1', 'Unknown', ''),
        '001900B6': ('SL', '1', 'Unknown', ''),
        '001900B7': ('FL', '2', 'Unknown', ''),
        '001900BA': ('FL', '1', 'Unknown', ''),
        '001900BB': ('FL', '1', 'Unknown', ''),
        '001900BC': ('FL', '2', 'Unknown', ''),
        '001900BD': ('SL', '1', 'Unknown', ''),
        '001900BE': ('SL', '1', 'Unknown', ''),
        '001900C1': ('SL', '1', 'Unknown', ''),
        '001900C3': ('SL', '1', 'Unknown', ''),
        '001900C6': ('FL', '2', 'Unknown', ''),
        '001900C9': ('SL', '1', 'Unknown', ''),
        '001900CA': ('LO', '1', 'Unknown', ''),
        '001900CB': ('UL', '1', 'Unknown', ''),
        '001900CC': ('UL', '1', 'Unknown', ''),
        '001900CD': ('SL', '1', 'Unknown', ''),
        '001900CE': ('SL', '1', 'Unknown', ''),
        '001900CF': ('SL', '1', 'Unknown', ''),
        '001900D0': ('US', '1', 'Unknown', ''),
        '001900D1': ('SL', '1', 'Unknown', ''),
        '001900D2': ('SL', '3', 'Unknown', ''),
        '001900D3': ('SL', '1', 'Unknown', ''),
        '001900D4': ('SL', '1', 'Unknown', ''),
        '001900D8': ('US', '1', 'Unknown', ''),
        '001900D9': ('SQ', '1', 'Unknown', ''),
        '001900DA': ('US', '1', 'Unknown', ''),
        '001900DB': ('SL', '1', 'Unknown', ''),
        '001900DC': ('SL', '1', 'Unknown', ''),
        '001900E1': ('SL', '1', 'Unknown', ''),
        '001900E4': ('SL', '1', 'Unknown', ''),
        '001900E5': ('SQ', '1', 'Unknown', ''),
        '001900E6': ('SQ', '1', 'Unknown', ''),
        '001900E9': ('SL', '1', 'Unknown', ''),
        '001900EA': ('UI', '1', 'Unknown', ''),
        '001900EB': ('SL', '1', 'Unknown', ''),
        '001900EC': ('US', '1', 'Unknown', ''),
        '001900EE': ('FL', '1', 'Unknown', ''),
        '001900EF': ('FL', '1', 'Unknown', ''),
        '001900F0': ('SL', '1', 'Unknown', ''),
        '001900F1': ('FL', '1', 'Unknown', ''),
        '001900F2': ('FL', '1', 'Unknown', ''),
        '001900F3': ('SL', '1', 'Unknown', ''),
        '001900F4': ('FD', '1', 'Unknown', ''),
        '001900F5': ('SL', '1', 'Unknown', ''),
        '001900F6': ('UI', '1', 'Unknown', ''),
        '001900F8': ('US', '1', 'Unknown', ''),
        '001900F9': ('SL', '1', 'Unknown', ''),
        '001900FA': ('FL', '1', 'Unknown', ''),
        '001900FB': ('UL', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('FL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
        '001900FF': ('SL', '3', 'Unknown', ''),
        '00210002': ('SL', '1', 'Unknown', ''),
        '00210003': ('SL', '1', 'Unknown', ''),
        '00210004': ('US', '1', 'Unknown', ''),
        '00210008': ('DS', '3', 'Unknown', ''),
        '00210009': ('DS', '3', 'Unknown', ''),
        '0021000A': ('DS', '3', 'Unknown', ''),
        '0021000B': ('US', '1', 'Unknown', ''),
        '0021000C': ('US', '1', 'Unknown', ''),
        '0021000D': ('FL', '1', 'Unknown', ''),
        '0021000F': ('US', '1', 'Unknown', ''),
        '00210012': ('DS', '3', 'Unknown', ''),
        '00210014': ('SQ', '1', 'Unknown', ''),
        '00210015': ('FL', '1', 'Unknown', ''),
        '00210016': ('FL', '2', 'Unknown', ''),
        '00210018': ('US', '1', 'Unknown', ''),
        '0021001A': ('US', '1', 'Unknown', ''),
        '0021001D': ('IS', '1', 'Unknown', ''),
        '0021001F': ('US', '1', 'Unknown', ''),
        '00210022': ('US', '1', 'Unknown', ''),
        '00210023': ('SS', '1', 'Unknown', ''),
        '00290001': ('SL', '1', 'Unknown', ''),
        '00290005': ('SQ', '1', 'Unknown', ''),
        '00290006': ('FL', '1', 'Unknown', ''),
        '00290007': ('FL', '1', 'Unknown', ''),
        '0029001C': ('FL', '2', 'Unknown', ''),
        '00290021': ('SL', '3', 'Unknown', ''),
        '0029004E': ('SL', '1', 'Unknown', ''),
        '00290050': ('LO', '1', 'Unknown', ''),
        '00290051': ('LO', '1', 'Unknown', ''),
        '00290052': ('LO', '1', 'Unknown', ''),
        '00290054': ('LO', '1', 'Unknown', ''),
        '00290067': ('FD', '4', 'Unknown', ''),
        '00290068': ('SS', '1', 'Unknown', ''),
        '0029006E': ('OB', '1', 'Unknown', ''),
        '700D0010': ('DS', '1', '2nd Flip Angle [degree]', ''),
        '700D0011': ('US', '2', 'Acquisition Inner Matrix', ''),
        '700D0012': ('US', '1', 'MP2RAGE Flag', ''),
        '700D0013': ('FL', '1', 'Inversion efficiency of inversion recovery pulse', ''),
        '700D0014': ('SL', '1', 'Number of dummy shot', ''),
        '700D0015': ('FL', '1', 'FFE total repetition time[s]', ''),
        '700D0016': ('LO', '3', 'PAS Name', ''),
        '700D0017': ('LT', '1', 'Intended Processing', ''),
        '700D0018': ('SS', '1-n', 'Scanned Orientation IDs', ''),
        '700D0019': ('OB', '1', 'PAS Reproduct Information', ''),
        '700D0080': ('US', '1', 'Unknown', ''),
        'E2010002': ('US', '1', 'Unknown', ''),
        'E3010000': ('SH', '1', 'Unknown', ''),
        'E4010000': ('US', '1', 'Unknown', ''),
        'E4010001': ('US', '1', 'Unknown', ''),
        'E4010002': ('US', '1', 'Unknown', ''),
        'E4010003': ('US', '1', 'Unknown', ''),
        'E4010004': ('US', '1', 'Unknown', ''),
        'E4010005': ('OB', '1', 'Unknown', ''),
        'E4010007': ('FL', '1', 'Unknown', ''),
        'E4010008': ('FL', '1', 'Unknown', ''),
        'E4010012': ('FL', '1', 'Unknown', ''),
        'E4010013': ('OB', '1', 'Unknown', ''),
        'E4010020': ('SQ', '1', 'Unknown', ''),
        'E4010021': ('SQ', '1', 'Unknown', ''),
        'E4010022': ('LO', '1', 'Unknown', ''),
        'E4010023': ('SH', '1', 'Unknown', ''),
        'E4010024': ('OB', '1', 'Unknown', ''),
        'E4030000': ('SQ', '1', 'Unknown', ''),
        'EE010000': ('US', '1', 'Unknown', ''),
        'EE010001': ('OB', '1', 'Unknown', ''),
        'EE010002': ('US', '1', 'Unknown', ''),
    },
    'TOSHIBA_MEC_MR3^11': {
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('SL', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190008': ('SH', '1', 'Unknown', ''),
        '00190009': ('SL', '2', 'Unknown', ''),
        '0019000A': ('SL', '1', 'Unknown', ''),
        '0019000B': ('OB', '1', 'Unknown', ''),
        '0019000C': ('SL', '1', 'Unknown', ''),
        '00190019': ('SQ', '1', 'Unknown', ''),
        '00190024': ('SL', '1', 'Unknown', ''),
        '00190025': ('SL', '1', 'Unknown', ''),
        '00190026': ('SL', '1', 'Unknown', ''),
        '00190028': ('SL', '1', 'Unknown', ''),
        '00190029': ('SL', '1', 'Unknown', ''),
        '0019002A': ('FL', '1', 'Unknown', ''),
        '0019002B': ('FL', '1', 'Unknown', ''),
        '0019002C': ('SL', '3', 'Unknown', ''),
        '0019002D': ('SL', '3', 'Unknown', ''),
        '0019002E': ('SL', '1', 'Unknown', ''),
        '00190030': ('SL', '1', 'Unknown', ''),
        '00190031': ('SL', '1', 'Unknown', ''),
        '00190032': ('SL', '1', 'Unknown', ''),
        '00190034': ('FL', '1', 'Unknown', ''),
        '00190035': ('SL', '1', 'Unknown', ''),
        '00190036': ('FL', '1', 'Unknown', ''),
        '00190037': ('SL', '1', 'Unknown', ''),
        '00190038': ('SL', '1', 'Unknown', ''),
        '00190039': ('FL', '1', 'Unknown', ''),
        '0019003A': ('FL', '1', 'Unknown', ''),
        '0019003C': ('FL', '3', 'Unknown', ''),
        '0019003E': ('FL', '9', 'Unknown', ''),
        '0019003F': ('UI', '1', 'Unknown', ''),
        '00190040': ('US', '1', 'Unknown', ''),
        '00190041': ('US', '1', 'Unknown', ''),
        '00190042': ('SL', '1', 'Unknown', ''),
        '00190043': ('SL', '1', 'Unknown', ''),
        '00190044': ('SL', '1', 'Unknown', ''),
        '00190046': ('FL', '1', 'Unknown', ''),
        '00190048': ('LT', '1', 'Unknown', ''),
        '00190049': ('LT', '1', 'Unknown', ''),
        '0019004C': ('SL', '1', 'Unknown', ''),
        '0019004D': ('SL', '1', 'Unknown', ''),
        '0019004E': ('SL', '1', 'Unknown', ''),
        '00190055': ('LO', '1', 'Unknown', ''),
        '00190057': ('FL', '1', 'Unknown', ''),
        '00190058': ('US', '1', 'Unknown', ''),
        '00190059': ('US', '1', 'Unknown', ''),
        '0019005C': ('SL', '1', 'Unknown', ''),
        '0019005D': ('SL', '1', 'Unknown', ''),
        '0019005F': ('FL', '1', 'Unknown', ''),
        '00190060': ('SL', '1', 'Unknown', ''),
        '00190061': ('FL', '1', 'Unknown', ''),
        '00190062': ('FL', '1', 'Unknown', ''),
        '00190063': ('SL', '1', 'Unknown', ''),
        '00190067': ('FL', '1', 'Unknown', ''),
        '00190068': ('SL', '1', 'Unknown', ''),
        '0019006C': ('FL', '1', 'Unknown', ''),
        '0019006D': ('SH', '1', 'Unknown', ''),
        '0019006E': ('SH', '1', 'Unknown', ''),
        '0019006F': ('FL', '1', 'Unknown', ''),
        '00190070': ('FL', '1', 'Unknown', ''),
        '00190071': ('SL', '1', 'Unknown', ''),
        '00190072': ('FL', '1', 'Unknown', ''),
        '00190073': ('FL', '1', 'Unknown', ''),
        '00190077': ('FL', '1', 'Unknown', ''),
        '00190078': ('SL', '1', 'Unknown', ''),
        '0019007A': ('SL', '2', 'Unknown', ''),
        '0019007C': ('FL', '3', 'Unknown', ''),
        '0019007D': ('SL', '1', 'Unknown', ''),
        '0019007E': ('SL', '1', 'Unknown', ''),
        '0019007F': ('SL', '1', 'Unknown', ''),
        '00190080': ('FL', '1', 'Unknown', ''),
        '00190083': ('FL', '1', 'Unknown', ''),
        '00190084': ('SL', '1', 'Unknown', ''),
        '00190087': ('SL', '1', 'Unknown', ''),
        '0019008A': ('US', '1', 'Unknown', ''),
        '0019008B': ('SL', '1', 'Unknown', ''),
        '0019008C': ('SL', '1', 'Unknown', ''),
        '0019008F': ('SL', '1', 'Unknown', ''),
        '00190091': ('SL', '1', 'Unknown', ''),
        '00190092': ('SL', '1', 'Unknown', ''),
        '00190094': ('FL', '1', 'Unknown', ''),
        '0019009A': ('SL', '1', 'Unknown', ''),
        '0019009B': ('US', '1', 'Unknown', ''),
        '0019009C': ('FL', '1', 'Unknown', ''),
        '0019009D': ('SL', '1', 'Unknown', ''),
        '0019009E': ('SL', '1', 'Unknown', ''),
        '0019009F': ('SL', '1', 'Unknown', ''),
        '001900A0': ('SL', '1', 'Unknown', ''),
        '001900A5': ('US', '1', 'Unknown', ''),
        '001900A6': ('US', '1', 'Unknown', ''),
        '001900A8': ('SL', '1', 'Unknown', ''),
        '001900AB': ('US', '1', 'Unknown', ''),
        '001900AD': ('SL', '1', 'Unknown', ''),
        '001900AE': ('SL', '1', 'Unknown', ''),
        '001900B0': ('FL', '1', 'Unknown', ''),
        '001900B1': ('SL', '1', 'Unknown', ''),
        '001900B2': ('US', '1', 'Unknown', ''),
        '001900B3': ('US', '1', 'Unknown', ''),
        '001900B4': ('US', '1', 'Unknown', ''),
        '001900B5': ('FL', '1', 'Unknown', ''),
        '001900B6': ('SL', '1', 'Unknown', ''),
        '001900B7': ('US', '1', 'Unknown', ''),
        '001900B9': ('US', '1', 'Unknown', ''),
        '001900BB': ('FL', '1', 'Unknown', ''),
        '001900BC': ('SL', '1', 'Unknown', ''),
        '001900BD': ('SL', '1', 'Unknown', ''),
        '001900BE': ('FL', '1', 'Unknown', ''),
        '001900BF': ('SL', '1', 'Unknown', ''),
        '001900C0': ('SL', '1', 'Unknown', ''),
        '001900C1': ('US', '1', 'Unknown', ''),
        '001900C3': ('FL', '1', 'Unknown', ''),
        '001900C4': ('SL', '1', 'Unknown', ''),
        '001900CD': ('SL', '3', 'Unknown', ''),
        '001900E0': ('FL', '1', 'Unknown', ''),
        '001900E1': ('FL', '1', 'Unknown', ''),
        '001900E3': ('SL', '3', 'Unknown', ''),
        '001900E4': ('DS', '1', 'Unknown', ''),
        '001900E5': ('SQ', '1', 'Unknown', ''),
        '001900E6': ('SQ', '1', 'Unknown', ''),
        '001900F0': ('SL', '4', 'Unknown', ''),
        '001900F1': ('SL', '3', 'Unknown', ''),
        '001900F2': ('FL', '3', 'Unknown', ''),
        '001900F3': ('SL', '1', 'Unknown', ''),
        '001900F4': ('SL', '1', 'Unknown', ''),
        '001900F5': ('SQ', '1', 'Unknown', ''),
        '001900F6': ('SL', '1', 'Unknown', ''),
        '001900F7': ('SL', '1', 'Unknown', ''),
        '001900F8': ('SL', '1', 'Unknown', ''),
        '001900F9': ('SL', '1', 'Unknown', ''),
        '001900FA': ('SL', '1', 'Unknown', ''),
        '001900FB': ('FL', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('SL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
        '001900FF': ('SL', '1', 'Unknown', ''),
    },
    'TOSHIBA_MEC_MR3^12': {
        '00190000': ('SL', '1', 'Unknown', ''),
        '00190001': ('SL', '1', 'Unknown', ''),
        '00190002': ('SL', '1', 'Unknown', ''),
        '00190003': ('SL', '1', 'Unknown', ''),
        '00190004': ('SL', '1', 'Unknown', ''),
        '00190005': ('SH', '1', 'Unknown', ''),
        '00190006': ('FL', '1', 'Unknown', ''),
        '00190007': ('UL', '1-n', 'Unknown', ''),
        '00190008': ('UL', '1-n', 'Unknown', ''),
        '00190009': ('SL', '1', 'Unknown', ''),
        '0019000A': ('SL', '1', 'Unknown', ''),
        '0019000B': ('SL', '1', 'Unknown', ''),
        '0019000C': ('UL', '1', 'Unknown', ''),
        '0019000D': ('SQ', '1', 'Unknown', ''),
        '0019000E': ('US', '1', 'Unknown', ''),
        '00190010': ('SL', '1', 'Unknown', ''),
        '00190011': ('SL', '1', 'Unknown', ''),
        '00190012': ('SL', '1', 'Unknown', ''),
        '00190013': ('FL', '1', 'Unknown', ''),
        '00190014': ('FL', '1', 'Unknown', ''),
        '00190018': ('UL', '1', 'Unknown', ''),
        '00190028': ('DS', '1', 'Unknown', ''),
        '0019002A': ('DS', '3', 'Unknown', ''),
        '0019002B': ('SQ', '1', 'Unknown', ''),
        '00190032': ('SH', '1', 'Unknown', ''),
        '00190034': ('SL', '1', 'Unknown', ''),
        '00190052': ('FL', '2', 'Unknown', ''),
        '00190076': ('OB', '1', 'Unknown', ''),
        '00190079': ('SQ', '1', 'Unknown', ''),
        '00190080': ('FD', '1', 'Unknown', ''),
        '00190085': ('US', '1', 'Unknown', ''),
        '00190086': ('LO', '1', 'Unknown', ''),
        '00190087': ('SQ', '1', 'Unknown', ''),
        '00190088': ('US', '1', 'Unknown', ''),
        '00190089': ('SL', '1', 'Unknown', ''),
        '0019008A': ('US', '1', 'Unknown', ''),
        '0019008B': ('US', '1', 'Unknown', ''),
        '0019008F': ('OB', '1', 'Unknown', ''),
        '00190093': ('SL', '1', 'Unknown', ''),
        '00190094': ('UI', '1', 'Unknown', ''),
        '00190095': ('UI', '1', 'Unknown', ''),
        '00190098': ('FL', '3', 'Unknown', ''),
        '00190099': ('LO', '1', 'Unknown', ''),
        '0019009A': ('DS', '1', 'Unknown', ''),
        '0019009B': ('IS', '1', 'Unknown', ''),
        '0019009C': ('DS', '1', 'Unknown', ''),
        '0019009D': ('US', '1', 'Unknown', ''),
        '0019009E': ('FL', '3', 'Unknown', ''),
        '0019009F': ('FL', '1', 'Unknown', ''),
        '001900A0': ('FL', '1', 'Unknown', ''),
        '001900A1': ('FL', '1', 'Unknown', ''),
        '001900A2': ('FL', '1', 'Unknown', ''),
        '001900A3': ('FL', '1', 'Unknown', ''),
        '001900A4': ('FL', '1', 'Unknown', ''),
        '001900A5': ('FL', '1', 'Unknown', ''),
        '001900A6': ('FL', '1-n', 'Unknown', ''),
        '001900A7': ('FL', '1', 'Unknown', ''),
        '001900A8': ('FL', '1', 'Unknown', ''),
        '001900AA': ('FL', '3', 'Unknown', ''),
        '001900AB': ('FL', '3', 'Unknown', ''),
        '001900AC': ('FL', '3', 'Unknown', ''),
        '001900AD': ('FL', '3', 'Unknown', ''),
        '001900AE': ('FL', '3', 'Unknown', ''),
        '001900AF': ('FL', '3', 'Unknown', ''),
        '001900B3': ('FD', '1', 'Unknown', ''),
        '001900B4': ('LO', '1', 'Unknown', ''),
        '001900C2': ('US', '1', 'Unknown', ''),
        '001900C3': ('FL', '1', 'Unknown', ''),
        '001900C4': ('SL', '1', 'Unknown', ''),
        '001900C5': ('SL', '1', 'Unknown', ''),
        '001900C6': ('SL', '1', 'Unknown', ''),
        '001900C7': ('FL', '1', 'Unknown', ''),
        '001900CD': ('LO', '1', 'Unknown', ''),
        '001900CE': ('UL', '1', 'Unknown', ''),
        '001900CF': ('FL', '1', 'Unknown', ''),
        '001900D1': ('FL', '3', 'Unknown', ''),
        '001900D2': ('US', '3', 'Unknown', ''),
        '001900D3': ('SS', '1', 'Unknown', ''),
        '001900D4': ('US', '2', 'Unknown', ''),
        '001900D5': ('FL', '1', 'Unknown', ''),
        '001900D6': ('FL', '3', 'Unknown', ''),
        '001900D7': ('US', '2', 'Unknown', ''),
        '001900D8': ('FL', '1-n', 'Unknown', ''),
        '001900DE': ('US', '1', 'Unknown', ''),
        '001900DF': ('US', '1', 'Unknown', ''),
        '001900E0': ('US', '1', 'Unknown', ''),
        '001900E1': ('FL', '3', 'Unknown', ''),
        '001900E2': ('FL', '3', 'Unknown', ''),
        '001900E3': ('TM', '1', 'Unknown', ''),
        '001900E4': ('US', '2', 'Unknown', ''),
        '001900EB': ('US', '1', 'Unknown', ''),
        '001900EC': ('US', '1', 'Unknown', ''),
        '001900EF': ('DS', '1', 'Unknown', ''),
        '001900F0': ('LO', '1', 'Unknown', ''),
        '001900F1': ('LO', '1', 'Unknown', ''),
        '001900FA': ('LT', '1', 'Unknown', ''),
        '001900FC': ('FL', '1', 'Unknown', ''),
        '001900FD': ('SL', '1', 'Unknown', ''),
        '001900FE': ('SL', '1', 'Unknown', ''),
    },
    'TOSHIBA_MEC_MR3^13': {
        '00190002': ('US', '1', 'Unknown', ''),
        '00190003': ('SL', '1', 'Unknown', ''),
        '00190004': ('US', '1', 'Unknown', ''),
        '00190005': ('SL', '1', 'Unknown', ''),
        '00190008': ('SL', '1', 'Unknown', ''),
        '00190009': ('SQ', '1', 'Unknown', ''),
        '0019000A': ('FD', '3', 'Unknown', ''),
        '0019000B': ('FD', '1', 'Unknown', ''),
        '0019000C': ('FD', '1', 'Unknown', ''),
        '0019000F': ('SH', '1', 'Unknown', ''),
        '00190014': ('SH', '1', 'Unknown', ''),
        '00190019': ('US', '1', 'Unknown', ''),
        '0019001B': ('US', '1', 'Unknown', ''),
        '0019001F': ('US', '1', 'Unknown', ''),
        '00190022': ('SL', '1', 'Unknown', ''),
        'E4030000': ('SH', '1', 'Unknown', ''),
        'E4030001': ('OB', '1', 'Unknown', ''),
        'E4030002': ('OB', '1', 'Unknown', ''),
        'E4030003': ('OB', '1', 'Unknown', ''),
    },
    'TOSHIBA_MEC_OT3': {
        '0009xx00': ('LO', '1', 'HIS/RIS Study ID', ''),
        '7019xx71': ('CS', '1', 'Indicator of creator', ''),
        '7019xx72': ('LO', '1', 'ID of quality assurance reviewer', ''),
        '7019xx73': ('PN', '1', 'Name of quality assurance reviewer', ''),
        '7019xx74': ('DA', '1', 'Date of completion of quality assurance', ''),
        '7019xx75': ('TM', '1', 'Time of completion of quality assurance', ''),
        '7019xx76': ('LO', '1', 'Host name of quality assurance station', ''),
        '7019xx77': ('CS', '1', 'Station name and version of quality assurance station', ''),
        '7019xx78': ('CS', '1', 'Flag of completion of quality assurance', ''),
        '7019xx79': ('CS', '1', 'Status of quality assurance review', ''),
        '7019xx7A': ('UI', '1', 'Original SOP Instance UID', ''),
        '7019xx7B': ('UI', '1', 'Original Series Instance UID', ''),
        '7019xx7C': ('UI', '1', 'Original Study Instance UID', ''),
        '7019xx7D': ('US', '1', 'Rotation information for image display from original image', ''),
        '7019xx7E': ('SQ', '1', 'Sequence of LR mark', ''),
        '7019xx7F': ('US', '1', 'Rotation status at creation of LR mark', ''),
        '7019xx80': ('OB_OW', '1', 'Original image data on area of original LR mark', ''),
        '7019xx81': ('SS', '1', 'X start position of LR mark', ''),
        '7019xx82': ('SS', '1', 'Y start position of LR mark', ''),
        '7019xx83': ('US', '1', 'Size of LR mark in X direction', ''),
        '7019xx84': ('US', '1', 'Size of LR mark in Y direction', ''),
        '7019xx85': ('LO', '1', 'Previous Patient ID', ''),
        '7019xx86': ('CS', '1', 'Previous modality', ''),
    },
    'TOSHIBA_MEC_XA3': {
        '7079xx10': ('LO', '1', '', ''),
        '7079xx21': ('SH', '5', '', ''),
        '7079xx22': ('IS', '2', '', ''),
        '7079xx23': ('IS', '2', '', ''),
        '7079xx24': ('DS', '1', '', ''),
        '7079xx25': ('SH', '1', '', ''),
        '7079xx26': ('DS', '2', '', ''),
        '7079xx27': ('US', '2', '', ''),
        '7079xx28': ('US', '1', '', ''),
        '7079xx29': ('US', '10', '', ''),
        '7079xx2A': ('US', '5', '', ''),
        '7079xx2B': ('UN', '1', '', ''),
        '7079xx2C': ('SH', '3', '', ''),
        '7079xx2D': ('SS', '2', '', ''),
        '7079xx2E': ('SH', '1', '', ''),
        '7079xx2F': ('SH', '1', '', ''),
        '7079xx30': ('US', '1', '', ''),
        '7079xx31': ('US', '1-n', '', ''),
        '7079xx32': ('SH', '2', '', ''),
        '7079xx33': ('US', '1-n', '', ''),
        '7079xx34': ('SH', '1', '', ''),
        '7079xx35': ('SH', '1', '', ''),
        '7079xx36': ('SH', '1', '', ''),
        '7079xx37': ('US', '4', '', ''),
        '7079xx38': ('SS', '1-n', '', ''),
        '7079xx39': ('SS', '1-n', '', ''),
        '7079xx3A': ('US', '2', '', ''),
        '7079xx3B': ('SH', '1', '', ''),
        '7079xx3C': ('DS', '2', '', ''),
        '7079xx3D': ('SS', '2', '', ''),
        '7079xx3E': ('SH', '1', '', ''),
        '7079xx3F': ('US', '2', '', ''),
        '7079xx40': ('SH', '2', '', ''),
        '7079xx41': ('SS', '2', '', ''),
        '7079xx42': ('SH', '1', '', ''),
        '7079xx43': ('SH', '1', '', ''),
        '7079xx44': ('US', '1', '', ''),
        '7079xx45': ('SH', '1', '', ''),
        '7079xx46': ('SS', '1', '', ''),
        '7079xx47': ('SS', '18', '', ''),
        '7079xx48': ('US', '12', '', ''),
        '7079xx49': ('US', '3', '', ''),
        '7079xx4A': ('US', '1', '', ''),
        '7079xx4B': ('LO', '3', '', ''),
        '7079xx4C': ('OB', '1', '', ''),
        '7079xx4D': ('LO', '3', '', ''),
        '7079xx4E': ('SL', '35', '', ''),
        '7079xx4F': ('SH', '3', '', ''),
        '7079xx50': ('US', '1-n', '', ''),
        '7079xx51': ('US', '1-n', '', ''),
        '7079xx52': ('US', '1', '', ''),
        '7079xx53': ('SH', '1', '', ''),
        '7079xx54': ('US', '5', '', ''),
        '7079xx55': ('UL', '47-47n', '', ''),
        '7079xx56': ('US', '1', '', ''),
        '7079xx57': ('US', '1-n', '', ''),
        '7079xx58': ('US', '1', '', ''),
        '7079xx59': ('US', '2-2n', '', ''),
        '7079xx5A': ('US', '1', '', ''),
        '7079xx5B': ('US', '2', '', ''),
        '7079xx5C': ('US', '2-2n', '', ''),
        '7079xx5D': ('SH', '1', '', ''),
        '7079xx5E': ('US', '2', '', ''),
        '7079xx5F': ('SS', '4-4n', '', ''),
        '7079xx60': ('US', '1-n', '', ''),
        '7079xx61': ('SS', '30-30n', '', ''),
        '7079xx62': ('US', '4', '', ''),
        '7079xx63': ('US', '1-n', '', ''),
        '7079xx64': ('US', '1-n', '', ''),
        '7079xx65': ('US', '1-n', '', ''),
        '7079xx66': ('US', '1-n', '', ''),
        '7079xx67': ('US', '1-n', '', ''),
        '7079xx68': ('US', '1-n', '', ''),
        '7079xx69': ('US', '1-n', '', ''),
        '7079xx6A': ('US', '1-n', '', ''),
        '7079xx6B': ('US', '1-n', '', ''),
        '7079xx6C': ('US', '1', '', ''),
        '7079xx6D': ('DS', '1', '', ''),
        '7079xx6E': ('LO', '1', '', ''),
        '7079xx6F': ('DS', '1', '', ''),
        '7079xx70': ('DS', '1', '', ''),
        '7079xx71': ('DS', '1-n', '', ''),
        '7079xx72': ('DS', '1-n', '', ''),
        '7079xx73': ('SL', '4', '', ''),
        '7079xx74': ('SL', '28', '', ''),
        '7079xx75': ('SH', '1', '', ''),
        '7079xx76': ('US', '1', '', ''),
        '7079xx77': ('SL', '1', '', ''),
        '7079xx78': ('US', '1', '', ''),
        '7079xx79': ('US', '1', '', ''),
        '7079xx7B': ('SH', '1', 'Unknown', ''),
        '7079xx80': ('LO', '1', '', ''),
        '7079xx81': ('SS', '1-n', '', ''),
        '7079xx82': ('SS', '1-n', '', ''),
    },
    'TOSHIBA_SR': {
        '7015xx10': ('OB', '1', 'Unknown', ''),
        '7015xx60': ('OB', '1', 'Unknown', ''),
    },
    'Thinking Systems Private Creator': {
        '7FDD0042': ('UN', '1', 'Unknown', ''),
        '7FDD0097': ('UN', '1', 'Unknown', ''),
    },
    'V1': {
        '0011xx01': ('OB', '1', 'User Data', ''),
        '0011xx02': ('DS', '1', 'Normalization Coefficient', ''),
        '0011xx03': ('DS', '1-n', 'Receiving Gain', ''),
        '0011xx04': ('DS', '1', 'Mean Image Noise', ''),
    },
    'VEPRO BROKER 1.0': {
        '0057xx10': ('SQ', '1', 'VEPRO Data replace sequence', ''),
    },
    'VEPRO BROKER 1.0 DATA REPLACE': {
        '0057xx20': ('SQ', '1', 'Original data sequence', ''),
        '0057xx30': ('SQ', '1', 'Replaced data sequence', ''),
        '0057xx40': ('DA', '1', 'Date of data replacement', ''),
        '0057xx41': ('TM', '1', 'Time of data replacement', ''),
        '0057xx42': ('LO', '1', 'Dicom receive node', ''),
        '0057xx43': ('LO', '1', 'Application name', ''),
        '0057xx44': ('LO', '1', 'Computer name', ''),
    },
    'VEPRO DICOM RECEIVE DATA 1.0': {
        '0059xx40': ('DA', '1', 'Receive date', ''),
        '0059xx41': ('TM', '1', 'Receive time', ''),
        '0059xx42': ('ST', '1', 'Receive node', ''),
        '0059xx43': ('ST', '1', 'Receive application', ''),
        '0059xx50': ('ST', '1', 'Receive local computer', ''),
        '0059xx51': ('ST', '1', 'Receive local ae title', ''),
        '0059xx60': ('ST', '1', 'Receive remote computer', ''),
        '0059xx61': ('ST', '1', 'Receive remote ae title', ''),
        '0059xx70': ('UI', '1', 'Receive original transfer syntax', ''),
    },
    'VEPRO DICOM TRANSFER 1.0': {
        '0059xx10': ('SQ', '1', 'Dicom Transfer Info', ''),
    },
    'VEPRO VIF 3.0 DATA': {
        '0055xx30': ('OB', '1', 'Icon data', ''),
        '0055xx65': ('OB', '1', 'Image hash value', ''),
    },
    'VEPRO VIM 5.0 DATA': {
        '0055xx10': ('OB', '1', 'VIFHEADER2', ''),
        '0055xx20': ('OB', '1', 'VIMDATA2', ''),
        '0055xx30': ('OB', '1', 'ICONDATA2', ''),
        '0055xx51': ('UI', '1', 'VEPRO UID ??', ''),
        '0055xx65': ('OB', '1', '??', ''),
    },
    'Varian Medical Systems VISION 3253': {
        '3253xx00': ('UN', '1', 'XML stream.', ''),
        '3253xx01': ('UN', '1', 'Data length of the XML stream', ''),
        '3253xx02': ('UN', '1', 'Extended Interface Format tag', ''),
    },
    'Viewing Protocol': {
        '0065xx93': ('CS', '1', 'Unknown', ''),
    },
    'Vital Images SW 3.4': {
        '5653xx10': ('OB', '1', 'Saved Workflow', ''),
        '5653xx11': ('LO', '1', 'Saved Workflow File Name', ''),
        '5653xx12': ('OB', '1', 'Saved Workflow File Data', ''),
        '5653xx13': ('SL', '1', 'Saved Workflow File Length', ''),
        '5653xx14': ('SQ', '1', 'Saved Workflow File Sequence', ''),
        '5653xx15': ('SQ', '1', 'Image Sequence', ''),
        '5653xx16': ('SL', '1', 'Volume Interpolated Slices', ''),
        '5653xx17': ('UI', '1', 'Volume SOP Instance UID', ''),
        '5653xx18': ('SH', '1', 'Saved Workflow Mark', ''),
        '5653xx19': ('UI', '1', 'Unknown', ''),
        '5653xx22': ('UI', '1', 'Unknown', ''),
        '5653xx23': ('LO', '1', 'Unknown', ''),
    },
    'Voxar 2.16.124.113543.6003.1999.12.20.12.5.0': {
        '1135xx00': ('UI', '1', 'Private Voxar Capture UID', ''),
        '1135xx01': ('OB', '1', 'Private Voxar Saved State', ''),
        '1135xx02': ('SQ', '1', 'Private Voxar Icon Image Sequence', ''),
        '1135xx03': ('ST', '1', 'Private Voxar Top Right Display Demographics', ''),
        '1135xx04': ('ST', '1', 'Private Voxar Bottom Left Display Demographics', ''),
        '1135xx05': ('IS', '1', 'Private Voxar Span State Schema', ''),
        '1135xx06': ('UL', '1', 'Private Voxar Live Image Restored Size', ''),
        '1135xx07': ('UI', '1', 'Private Voxar CaptureType', ''),
        '1135xx08': ('SQ', '1', 'Private Voxar Capture Source Series UID Sequence', ''),
        '1135xx09': ('UI', '1', 'Private Voxar Capture Source Series UID', ''),
        '1135xx10': ('IS', '1', 'Private Voxar Background Gray For Capture', ''),
        '1135xx11': ('IS', '1', 'Private Voxar Calcium Scoring Report Schema', ''),
        '1135xx12': ('IS', '1', 'Private Voxar Source Series Number', ''),
        '1135xx13': ('LO', '1', 'Private Voxar Bottom Left Display Demographics', ''),
    },
    'WG12 Supplement 43': {
        '0009xx01': ('SQ', '1', 'Event Timer Sequence', ''),
        '0009xx02': ('FD', '1', 'Event Time Interval', ''),
        '0009xx03': ('SQ', '1', 'Event Code Sequence', ''),
        '0019xx01': ('FD', '1', 'Focus Depth(s)', ''),
        '0019xx03': ('SQ', '1', 'Excluded Intervals Sequence', ''),
        '0019xx04': ('DT', '1', 'Exclusion Start Datetime', ''),
        '0019xx05': ('FD', '1', 'Exclusion Duration', ''),
        '0019xx06': ('SQ', '1', 'US Image Description Sequence', ''),
        '0019xx07': ('SQ', '1', 'Image Data Type Sequence', ''),
        '0019xx08': ('CS', '1', 'Data Type', ''),
        '0019xx09': ('SQ', '1', 'Transducer Scan Geometry Code Sequence', ''),
        '0019xx0B': ('CS', '1', 'Aliased Data Type', ''),
        '0019xx0C': ('CS', '1', 'Position Measuring Device Used', ''),
        '0019xx0D': ('SQ', '1', 'Transducer Scanning Configuration Code Sequence', ''),
        '0019xx0E': ('SQ', '1', 'Transducer Beam Steering Code Sequence', ''),
        '0019xx0F': ('SQ', '1', 'Transducer Access Code Sequence', ''),
        '0021xx01': ('FD', '1', 'Image Position (Volume)', ''),
        '0021xx02': ('FD', '1', 'Image Orientation (Volume)', ''),
        '0021xx07': ('CS', '1', 'Ultrasound Acquisition Geometry', ''),
        '0021xx08': ('FD', '1', 'Apex Position', ''),
        '0021xx09': ('FD', '1', 'Volume to Transducer Mapping Matrix', ''),
        '0021xx0A': ('FD', '1', 'Volume to Table Mapping Matrix', ''),
        '0021xx0C': ('CS', '1', 'Patient Frame of Reference Source', ''),
        '0021xx0D': ('FD', '1', 'Temporal Position Time Offset', ''),
        '0021xx0E': ('SQ', '1', 'Plane Position (Volume) Sequence', ''),
        '0021xx0F': ('SQ', '1', 'Plane Orientation (Volume) Sequence', ''),
        '0021xx10': ('SQ', '1', 'Temporal Position Sequence', ''),
        '0021xx11': ('CS', '1', 'Dimension Organization Type', ''),
        '0029xx01': ('SQ', '1', 'Data Frame Assignment Sequence', ''),
        '0029xx02': ('CS', '1', 'Data Path Assignment', ''),
        '0029xx03': ('US', '1', 'Bits Mapped to Color Lookup Table', ''),
        '0029xx04': ('SQ', '1', 'Opacity 1 LUT Sequence', ''),
        '0029xx05': ('CS', '1', 'Opacity 1 LUT Transfer Function', ''),
        '0029xx06': ('FD', '1', 'Opacity Constant', ''),
        '0029xx07': ('US', '1', 'Opacity Lookup Table Descriptor', ''),
        '0029xx08': ('OW', '1', 'Opacity Lookup Table Data', ''),
        '0029xx0B': ('SQ', '1', 'Enhanced Palette Color Lookup Table Sequence', ''),
        '0029xx0C': ('SQ', '1', 'Opacity 2 LUT Sequence', ''),
        '0029xx0D': ('CS', '1', 'Opacity 2 LUT Transfer Function', ''),
        '0029xx0E': ('CS', '1', 'Data Path ID', ''),
        '0029xx0F': ('CS', '1', 'RGB LUT Transfer Function', ''),
        '0029xx10': ('CS', '1', 'Alpha LUT Transfer Function', ''),
        '0041xx01': ('CS', '1', 'Performed Protocol Type', ''),
    },
    'agfa/originalStudyUID': {
        '7FDD0013': ('UN', '1', 'Unknown', ''),
    },
    'agfa/seriesHeader': {
        '7FDB0012': ('UN', '1', 'Unknown', ''),
        '7FDB0053': ('UN', '1', 'Unknown', ''),
        '7FDB0054': ('UN', '1', 'Unknown', ''),
        '7FDB0055': ('UN', '1', 'Unknown', ''),
    },
    'http://www.gemedicalsystems.com/it_solutions/bamwallthickness/1.0': {
        '3119xx10': ('DT', '1', 'BAM WallThickness Session Date/Time', ''),
        '3119xx20': ('PN', '1', 'BAM WallThickness Session Creator', ''),
        '3119xx30': ('CS', '1', 'BAM WallThickness Session Completion Flag', ''),
        '3119xx40': ('SQ', '1', 'BAM WallThickness File Sequence', ''),
        '3119xx50': ('ST', '1', 'BAM WallThickness File Name', ''),
        '3119xx60': ('OB', '1', 'BAM WallThickness File Content', ''),
    },
    'http://www.gemedicalsystems.com/it_solutions/orthoview/2.1': {
        '3117xx10': ('DT', '1', 'OrthoView Session Date/Time', ''),
        '3117xx20': ('PN', '1', 'OrthoView Session Creator', ''),
        '3117xx30': ('CS', '1', 'OrthoView Session Completion Flag', ''),
        '3117xx40': ('SQ', '1', 'OrthoView File Sequence', ''),
        '3117xx50': ('ST', '1', 'OrthoView File Name', ''),
        '3117xx60': ('OB', '1', 'OrthoView File Content', ''),
    },
    'http://www.gemedicalsystems.com/it_solutions/rad_pacs/': {
        '3115xx01': ('UT', '1', 'Reference to pacs study', ''),
        '3115xx02': ('UT', '1', 'Reference to pacs image', ''),
        '3115xx03': ('CS', '1', 'Pacs examnotes flag', ''),
    },
    'syngoDynamics': {
        '0021xxAE': ('OB', '1', 'Unknown', ''),
    },
}
